// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_PUBLIC_CPP_EXTERNAL_ARC_MESSAGE_CENTER_ARC_NOTIFICATION_DELEGATE_H_
#define ASH_PUBLIC_CPP_EXTERNAL_ARC_MESSAGE_CENTER_ARC_NOTIFICATION_DELEGATE_H_

#include "base/memory/weak_ptr.h"
#include "ui/message_center/public/cpp/notification_delegate.h"

namespace message_center {

class MessageView;
class Notification;

}  // namespace message_center

namespace ash {

class ArcNotificationItem;

// Implementation of NotificationDelegate for ARC notifications.
class ArcNotificationDelegate : public message_center::NotificationDelegate {
 public:
  explicit ArcNotificationDelegate(base::WeakPtr<ArcNotificationItem> item);

  ArcNotificationDelegate(const ArcNotificationDelegate&) = delete;
  ArcNotificationDelegate& operator=(const ArcNotificationDelegate&) = delete;

  // Creates a view for the given notification (which must have been the one
  // generated by |item_|).
  std::unique_ptr<message_center::MessageView> CreateCustomMessageView(
      const message_center::Notification& notification,
      bool shown_in_popup);

  // message_center::NotificationDelegate overrides:
  void Close(bool by_user) override;
  void Click(const absl::optional<int>& button_index,
             const absl::optional<std::u16string>& reply) override;
  void SettingsClick() override;
  void ExpandStateChanged(bool expanded) override;
  void SnoozeButtonClicked() override;
  message_center::NotificationDelegate* GetDelegateForParentCopy() override;

 private:
  // The destructor is private since this class is ref-counted.
  ~ArcNotificationDelegate() override;

  // We use weak ptr to detect potential use-after-free. The lives of objects
  // around ARC notification is somewhat complex so we want to use it until
  // it gets stable.
  base::WeakPtr<ArcNotificationItem> item_;
};

}  // namespace ash

#endif  // ASH_PUBLIC_CPP_EXTERNAL_ARC_MESSAGE_CENTER_ARC_NOTIFICATION_DELEGATE_H_
