<!--
SPDX-FileCopyrightText: GSConnect Developers https://github.com/GSConnect

SPDX-License-Identifier: GPL-2.0-or-later
-->

# Release Checklist

Steps to prepare a new release.

## Submit a PR to update the version metadata

- [ ] Bump the `project(version)` value in `meson.build`
- [ ] Add a corresponding `<release>...</release>` block
      to the top of the `<releases>` section in
      `data/metainfo/org.gnome.Shell.Extensions.GSConnect.metainfo.xml.in`
- [ ] Merge the PR to create a release commit

> [!CAUTION]
> The AppStream metadata will contain a release date for the new version.
> If the PR isn't merged immediately,
> double-check that it matches the current date before merging.

## Package the new release

- [ ] Run `git pull` on the `main` branch
- [ ] Run `meson setup _build .`
- [ ] Run `meson compile -C _build make-zip`

## Publish to GitHub Releases

- [ ] Open the [New Release template] (or click "Draft a new release" from the Releases page)
- [ ] Create a new `v##` tag matching the new version number
- [ ] Click "Generate release notes" to populate the textarea
      with an autogenerated list of PRs, as a starting point
- [ ] Clean up & compose the final notes, which may mean...

    - [ ] Remove automated PRs (dependabot, Crowdin)
    - [ ] Remove purely-internal PRs,
          like CI, build, or repo-maintenance changes.
          Anything that affects the _repo_, but not the _package_,
          is probably not relevant to endusers and can be left out.
    - [ ] (Optional) Write an introductory "What's New" section,
          highlighting any notable changes or new features.

- [ ] Attach the `_build/gsconnect@andyholmes.github.io.zip` file
- [ ] Publish the release

## Submit to EGO

Once the release is published to GitHub,
the attached zip file can also be submitted to extensions.gnome.org
by the designated extension author (currently @daniellandau).

[New Release template]: https://github.com/GSConnect/gnome-shell-extensions-gsconnect/releases/new
