// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticinference

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDescribeAcceleratorOfferings = "DescribeAcceleratorOfferings"

// DescribeAcceleratorOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAcceleratorOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAcceleratorOfferings for more information on using the DescribeAcceleratorOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAcceleratorOfferingsRequest method.
//    req, resp := client.DescribeAcceleratorOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorOfferings
func (c *ElasticInference) DescribeAcceleratorOfferingsRequest(input *DescribeAcceleratorOfferingsInput) (req *request.Request, output *DescribeAcceleratorOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeAcceleratorOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-accelerator-offerings",
	}

	if input == nil {
		input = &DescribeAcceleratorOfferingsInput{}
	}

	output = &DescribeAcceleratorOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAcceleratorOfferings API operation for Amazon Elastic  Inference.
//
// Describes the locations in which a given accelerator type or set of types
// is present in a given region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation DescribeAcceleratorOfferings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Raised when a malformed input has been provided to the API.
//
//   * ResourceNotFoundException
//   Raised when the requested resource cannot be found.
//
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorOfferings
func (c *ElasticInference) DescribeAcceleratorOfferings(input *DescribeAcceleratorOfferingsInput) (*DescribeAcceleratorOfferingsOutput, error) {
	req, out := c.DescribeAcceleratorOfferingsRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorOfferingsWithContext is the same as DescribeAcceleratorOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAcceleratorOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) DescribeAcceleratorOfferingsWithContext(ctx aws.Context, input *DescribeAcceleratorOfferingsInput, opts ...request.Option) (*DescribeAcceleratorOfferingsOutput, error) {
	req, out := c.DescribeAcceleratorOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAcceleratorTypes = "DescribeAcceleratorTypes"

// DescribeAcceleratorTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAcceleratorTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAcceleratorTypes for more information on using the DescribeAcceleratorTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAcceleratorTypesRequest method.
//    req, resp := client.DescribeAcceleratorTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorTypes
func (c *ElasticInference) DescribeAcceleratorTypesRequest(input *DescribeAcceleratorTypesInput) (req *request.Request, output *DescribeAcceleratorTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAcceleratorTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/describe-accelerator-types",
	}

	if input == nil {
		input = &DescribeAcceleratorTypesInput{}
	}

	output = &DescribeAcceleratorTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAcceleratorTypes API operation for Amazon Elastic  Inference.
//
// Describes the accelerator types available in a given region, as well as their
// characteristics, such as memory and throughput.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation DescribeAcceleratorTypes for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAcceleratorTypes
func (c *ElasticInference) DescribeAcceleratorTypes(input *DescribeAcceleratorTypesInput) (*DescribeAcceleratorTypesOutput, error) {
	req, out := c.DescribeAcceleratorTypesRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorTypesWithContext is the same as DescribeAcceleratorTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAcceleratorTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) DescribeAcceleratorTypesWithContext(ctx aws.Context, input *DescribeAcceleratorTypesInput, opts ...request.Option) (*DescribeAcceleratorTypesOutput, error) {
	req, out := c.DescribeAcceleratorTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccelerators = "DescribeAccelerators"

// DescribeAcceleratorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccelerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccelerators for more information on using the DescribeAccelerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAcceleratorsRequest method.
//    req, resp := client.DescribeAcceleratorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators
func (c *ElasticInference) DescribeAcceleratorsRequest(input *DescribeAcceleratorsInput) (req *request.Request, output *DescribeAcceleratorsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccelerators,
		HTTPMethod: "POST",
		HTTPPath:   "/describe-accelerators",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAcceleratorsInput{}
	}

	output = &DescribeAcceleratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccelerators API operation for Amazon Elastic  Inference.
//
// Describes information over a provided set of accelerators belonging to an
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation DescribeAccelerators for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Raised when a malformed input has been provided to the API.
//
//   * ResourceNotFoundException
//   Raised when the requested resource cannot be found.
//
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/DescribeAccelerators
func (c *ElasticInference) DescribeAccelerators(input *DescribeAcceleratorsInput) (*DescribeAcceleratorsOutput, error) {
	req, out := c.DescribeAcceleratorsRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorsWithContext is the same as DescribeAccelerators with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccelerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) DescribeAcceleratorsWithContext(ctx aws.Context, input *DescribeAcceleratorsInput, opts ...request.Option) (*DescribeAcceleratorsOutput, error) {
	req, out := c.DescribeAcceleratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAcceleratorsPages iterates over the pages of a DescribeAccelerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAccelerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAccelerators operation.
//    pageNum := 0
//    err := client.DescribeAcceleratorsPages(params,
//        func(page *elasticinference.DescribeAcceleratorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticInference) DescribeAcceleratorsPages(input *DescribeAcceleratorsInput, fn func(*DescribeAcceleratorsOutput, bool) bool) error {
	return c.DescribeAcceleratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAcceleratorsPagesWithContext same as DescribeAcceleratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) DescribeAcceleratorsPagesWithContext(ctx aws.Context, input *DescribeAcceleratorsInput, fn func(*DescribeAcceleratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAcceleratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAcceleratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAcceleratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/ListTagsForResource
func (c *ElasticInference) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic  Inference.
//
// Returns all tags of an Elastic Inference Accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Raised when a malformed input has been provided to the API.
//
//   * ResourceNotFoundException
//   Raised when the requested resource cannot be found.
//
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/ListTagsForResource
func (c *ElasticInference) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/TagResource
func (c *ElasticInference) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic  Inference.
//
// Adds the specified tags to an Elastic Inference Accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Raised when a malformed input has been provided to the API.
//
//   * ResourceNotFoundException
//   Raised when the requested resource cannot be found.
//
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/TagResource
func (c *ElasticInference) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/UntagResource
func (c *ElasticInference) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic  Inference.
//
// Removes the specified tags from an Elastic Inference Accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic  Inference's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Raised when a malformed input has been provided to the API.
//
//   * ResourceNotFoundException
//   Raised when the requested resource cannot be found.
//
//   * InternalServerException
//   Raised when an unexpected error occurred during request processing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elastic-inference-2017-07-25/UntagResource
func (c *ElasticInference) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticInference) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The details of an Elastic Inference Accelerator type.
type AcceleratorType struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic Inference Accelerator type.
	AcceleratorTypeName *string `locationName:"acceleratorTypeName" min:"1" type:"string"`

	// The memory information of the Elastic Inference Accelerator type.
	MemoryInfo *MemoryInfo `locationName:"memoryInfo" type:"structure"`

	// The throughput information of the Elastic Inference Accelerator type.
	ThroughputInfo []*KeyValuePair `locationName:"throughputInfo" type:"list"`
}

// String returns the string representation
func (s AcceleratorType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceleratorType) GoString() string {
	return s.String()
}

// SetAcceleratorTypeName sets the AcceleratorTypeName field's value.
func (s *AcceleratorType) SetAcceleratorTypeName(v string) *AcceleratorType {
	s.AcceleratorTypeName = &v
	return s
}

// SetMemoryInfo sets the MemoryInfo field's value.
func (s *AcceleratorType) SetMemoryInfo(v *MemoryInfo) *AcceleratorType {
	s.MemoryInfo = v
	return s
}

// SetThroughputInfo sets the ThroughputInfo field's value.
func (s *AcceleratorType) SetThroughputInfo(v []*KeyValuePair) *AcceleratorType {
	s.ThroughputInfo = v
	return s
}

// The offering for an Elastic Inference Accelerator type.
type AcceleratorTypeOffering struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic Inference Accelerator type.
	AcceleratorType *string `locationName:"acceleratorType" min:"1" type:"string"`

	// The location for the offering. It will return either the region, availability
	// zone or availability zone id for the offering depending on the locationType
	// value.
	Location *string `locationName:"location" min:"1" type:"string"`

	// The location type for the offering. It can assume the following values: region:
	// defines that the offering is at the regional level. availability-zone: defines
	// that the offering is at the availability zone level. availability-zone-id:
	// defines that the offering is at the availability zone level, defined by the
	// availability zone id.
	LocationType *string `locationName:"locationType" min:"1" type:"string" enum:"LocationType"`
}

// String returns the string representation
func (s AcceleratorTypeOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceleratorTypeOffering) GoString() string {
	return s.String()
}

// SetAcceleratorType sets the AcceleratorType field's value.
func (s *AcceleratorTypeOffering) SetAcceleratorType(v string) *AcceleratorTypeOffering {
	s.AcceleratorType = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AcceleratorTypeOffering) SetLocation(v string) *AcceleratorTypeOffering {
	s.Location = &v
	return s
}

// SetLocationType sets the LocationType field's value.
func (s *AcceleratorTypeOffering) SetLocationType(v string) *AcceleratorTypeOffering {
	s.LocationType = &v
	return s
}

// Raised when a malformed input has been provided to the API.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeAcceleratorOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The list of accelerator types to describe.
	AcceleratorTypes []*string `locationName:"acceleratorTypes" type:"list"`

	// The location type that you want to describe accelerator type offerings for.
	// It can assume the following values: region: will return the accelerator type
	// offering at the regional level. availability-zone: will return the accelerator
	// type offering at the availability zone level. availability-zone-id: will
	// return the accelerator type offering at the availability zone level returning
	// the availability zone id.
	//
	// LocationType is a required field
	LocationType *string `locationName:"locationType" min:"1" type:"string" required:"true" enum:"LocationType"`
}

// String returns the string representation
func (s DescribeAcceleratorOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorOfferingsInput"}
	if s.LocationType == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationType"))
	}
	if s.LocationType != nil && len(*s.LocationType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *DescribeAcceleratorOfferingsInput) SetAcceleratorTypes(v []*string) *DescribeAcceleratorOfferingsInput {
	s.AcceleratorTypes = v
	return s
}

// SetLocationType sets the LocationType field's value.
func (s *DescribeAcceleratorOfferingsInput) SetLocationType(v string) *DescribeAcceleratorOfferingsInput {
	s.LocationType = &v
	return s
}

type DescribeAcceleratorOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The list of accelerator type offerings for a specific location.
	AcceleratorTypeOfferings []*AcceleratorTypeOffering `locationName:"acceleratorTypeOfferings" type:"list"`
}

// String returns the string representation
func (s DescribeAcceleratorOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorOfferingsOutput) GoString() string {
	return s.String()
}

// SetAcceleratorTypeOfferings sets the AcceleratorTypeOfferings field's value.
func (s *DescribeAcceleratorOfferingsOutput) SetAcceleratorTypeOfferings(v []*AcceleratorTypeOffering) *DescribeAcceleratorOfferingsOutput {
	s.AcceleratorTypeOfferings = v
	return s
}

type DescribeAcceleratorTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAcceleratorTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorTypesInput) GoString() string {
	return s.String()
}

type DescribeAcceleratorTypesOutput struct {
	_ struct{} `type:"structure"`

	// The available accelerator types.
	AcceleratorTypes []*AcceleratorType `locationName:"acceleratorTypes" type:"list"`
}

// String returns the string representation
func (s DescribeAcceleratorTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorTypesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *DescribeAcceleratorTypesOutput) SetAcceleratorTypes(v []*AcceleratorType) *DescribeAcceleratorTypesOutput {
	s.AcceleratorTypes = v
	return s
}

type DescribeAcceleratorsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the accelerators to describe.
	AcceleratorIds []*string `locationName:"acceleratorIds" type:"list"`

	// One or more filters. Filter names and values are case-sensitive. Valid filter
	// names are: accelerator-types: can provide a list of accelerator type names
	// to filter for. instance-id: can provide a list of EC2 instance ids to filter
	// for.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of items to return in the command's output. If the total
	// number of items available is more than the value specified, a NextToken is
	// provided in the command's output. To resume pagination, provide the NextToken
	// value in the starting-token argument of a subsequent command. Do not use
	// the NextToken response element directly outside of the AWS CLI.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAcceleratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorIds sets the AcceleratorIds field's value.
func (s *DescribeAcceleratorsInput) SetAcceleratorIds(v []*string) *DescribeAcceleratorsInput {
	s.AcceleratorIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAcceleratorsInput) SetFilters(v []*Filter) *DescribeAcceleratorsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAcceleratorsInput) SetMaxResults(v int64) *DescribeAcceleratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAcceleratorsInput) SetNextToken(v string) *DescribeAcceleratorsInput {
	s.NextToken = &v
	return s
}

type DescribeAcceleratorsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the Elastic Inference Accelerators.
	AcceleratorSet []*ElasticInferenceAccelerator `locationName:"acceleratorSet" type:"list"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAcceleratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorsOutput) GoString() string {
	return s.String()
}

// SetAcceleratorSet sets the AcceleratorSet field's value.
func (s *DescribeAcceleratorsOutput) SetAcceleratorSet(v []*ElasticInferenceAccelerator) *DescribeAcceleratorsOutput {
	s.AcceleratorSet = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAcceleratorsOutput) SetNextToken(v string) *DescribeAcceleratorsOutput {
	s.NextToken = &v
	return s
}

// The details of an Elastic Inference Accelerator.
type ElasticInferenceAccelerator struct {
	_ struct{} `type:"structure"`

	// The health of the Elastic Inference Accelerator.
	AcceleratorHealth *ElasticInferenceAcceleratorHealth `locationName:"acceleratorHealth" type:"structure"`

	// The ID of the Elastic Inference Accelerator.
	AcceleratorId *string `locationName:"acceleratorId" min:"1" type:"string"`

	// The type of the Elastic Inference Accelerator.
	AcceleratorType *string `locationName:"acceleratorType" min:"1" type:"string"`

	// The ARN of the resource that the Elastic Inference Accelerator is attached
	// to.
	AttachedResource *string `locationName:"attachedResource" min:"1" type:"string"`

	// The availability zone where the Elastic Inference Accelerator is present.
	AvailabilityZone *string `locationName:"availabilityZone" min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticInferenceAccelerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticInferenceAccelerator) GoString() string {
	return s.String()
}

// SetAcceleratorHealth sets the AcceleratorHealth field's value.
func (s *ElasticInferenceAccelerator) SetAcceleratorHealth(v *ElasticInferenceAcceleratorHealth) *ElasticInferenceAccelerator {
	s.AcceleratorHealth = v
	return s
}

// SetAcceleratorId sets the AcceleratorId field's value.
func (s *ElasticInferenceAccelerator) SetAcceleratorId(v string) *ElasticInferenceAccelerator {
	s.AcceleratorId = &v
	return s
}

// SetAcceleratorType sets the AcceleratorType field's value.
func (s *ElasticInferenceAccelerator) SetAcceleratorType(v string) *ElasticInferenceAccelerator {
	s.AcceleratorType = &v
	return s
}

// SetAttachedResource sets the AttachedResource field's value.
func (s *ElasticInferenceAccelerator) SetAttachedResource(v string) *ElasticInferenceAccelerator {
	s.AttachedResource = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ElasticInferenceAccelerator) SetAvailabilityZone(v string) *ElasticInferenceAccelerator {
	s.AvailabilityZone = &v
	return s
}

// The health details of an Elastic Inference Accelerator.
type ElasticInferenceAcceleratorHealth struct {
	_ struct{} `type:"structure"`

	// The health status of the Elastic Inference Accelerator.
	Status *string `locationName:"status" min:"1" type:"string"`
}

// String returns the string representation
func (s ElasticInferenceAcceleratorHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticInferenceAcceleratorHealth) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ElasticInferenceAcceleratorHealth) SetStatus(v string) *ElasticInferenceAcceleratorHealth {
	s.Status = &v
	return s
}

// A filter expression for the Elastic Inference Accelerator list.
type Filter struct {
	_ struct{} `type:"structure"`

	// The filter name for the Elastic Inference Accelerator list. It can assume
	// the following values: accelerator-type: the type of Elastic Inference Accelerator
	// to filter for. instance-id: an EC2 instance id to filter for.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The values for the filter of the Elastic Inference Accelerator list.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Raised when an unexpected error occurred during request processing.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A throughput entry for an Elastic Inference Accelerator type.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The throughput value of the Elastic Inference Accelerator type. It can assume
	// the following values: TFLOPS16bit: the throughput expressed in 16bit TeraFLOPS.
	// TFLOPS32bit: the throughput expressed in 32bit TeraFLOPS.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The throughput value of the Elastic Inference Accelerator type.
	Value *int64 `locationName:"value" type:"integer"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValuePair) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *KeyValuePair) SetKey(v string) *KeyValuePair {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v int64) *KeyValuePair {
	s.Value = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Elastic Inference Accelerator to list the tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags of the Elastic Inference Accelerator.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The memory information of an Elastic Inference Accelerator type.
type MemoryInfo struct {
	_ struct{} `type:"structure"`

	// The size in mebibytes of the Elastic Inference Accelerator type.
	SizeInMiB *int64 `locationName:"sizeInMiB" type:"integer"`
}

// String returns the string representation
func (s MemoryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemoryInfo) GoString() string {
	return s.String()
}

// SetSizeInMiB sets the SizeInMiB field's value.
func (s *MemoryInfo) SetSizeInMiB(v int64) *MemoryInfo {
	s.SizeInMiB = &v
	return s
}

// Raised when the requested resource cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Elastic Inference Accelerator to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to add to the Elastic Inference Accelerator.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Elastic Inference Accelerator to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to remove from the Elastic Inference Accelerator.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// LocationTypeRegion is a LocationType enum value
	LocationTypeRegion = "region"

	// LocationTypeAvailabilityZone is a LocationType enum value
	LocationTypeAvailabilityZone = "availability-zone"

	// LocationTypeAvailabilityZoneId is a LocationType enum value
	LocationTypeAvailabilityZoneId = "availability-zone-id"
)

// LocationType_Values returns all elements of the LocationType enum
func LocationType_Values() []string {
	return []string{
		LocationTypeRegion,
		LocationTypeAvailabilityZone,
		LocationTypeAvailabilityZoneId,
	}
}
