; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
; PR36485
; musttail call result can't be replaced with a constant, unless the call can be removed

declare i32 @external()

define ptr @start(i8 %v) {
;
; TUNIT-LABEL: define {{[^@]+}}@start
; TUNIT-SAME: (i8 [[V:%.*]]) {
; TUNIT-NEXT:    [[C1:%.*]] = icmp eq i8 [[V]], 0
; TUNIT-NEXT:    br i1 [[C1]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; TUNIT:       true:
; TUNIT-NEXT:    [[CA:%.*]] = musttail call noalias noundef align 4294967296 ptr @side_effects(i8 [[V]])
; TUNIT-NEXT:    ret ptr [[CA]]
; TUNIT:       false:
; TUNIT-NEXT:    [[C2:%.*]] = icmp eq i8 [[V]], 1
; TUNIT-NEXT:    br i1 [[C2]], label [[C2_TRUE:%.*]], label [[C2_FALSE:%.*]]
; TUNIT:       c2_true:
; TUNIT-NEXT:    ret ptr null
; TUNIT:       c2_false:
; TUNIT-NEXT:    [[CA2:%.*]] = musttail call noalias noundef align 4294967296 ptr @dont_zap_me(i8 undef)
; TUNIT-NEXT:    ret ptr [[CA2]]
;
; CGSCC-LABEL: define {{[^@]+}}@start
; CGSCC-SAME: (i8 [[V:%.*]]) {
; CGSCC-NEXT:    [[C1:%.*]] = icmp eq i8 [[V]], 0
; CGSCC-NEXT:    br i1 [[C1]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CGSCC:       true:
; CGSCC-NEXT:    [[CA:%.*]] = musttail call noalias noundef align 4294967296 ptr @side_effects(i8 [[V]])
; CGSCC-NEXT:    ret ptr [[CA]]
; CGSCC:       false:
; CGSCC-NEXT:    [[C2:%.*]] = icmp eq i8 [[V]], 1
; CGSCC-NEXT:    br i1 [[C2]], label [[C2_TRUE:%.*]], label [[C2_FALSE:%.*]]
; CGSCC:       c2_true:
; CGSCC-NEXT:    [[CA1:%.*]] = musttail call noalias noundef align 4294967296 ptr @no_side_effects(i8 [[V]])
; CGSCC-NEXT:    ret ptr [[CA1]]
; CGSCC:       c2_false:
; CGSCC-NEXT:    [[CA2:%.*]] = musttail call noalias noundef align 4294967296 ptr @dont_zap_me(i8 [[V]])
; CGSCC-NEXT:    ret ptr [[CA2]]
;
  %c1 = icmp eq i8 %v, 0
  br i1 %c1, label %true, label %false
true:
  ; FIXME: propagate the value information for %v
  %ca = musttail call ptr @side_effects(i8 %v)
  ret ptr %ca
false:
  %c2 = icmp eq i8 %v, 1
  br i1 %c2, label %c2_true, label %c2_false
c2_true:
  %ca1 = musttail call ptr @no_side_effects(i8 %v)
  ret ptr %ca1
c2_false:
  %ca2 = musttail call ptr @dont_zap_me(i8 %v)
  ret ptr %ca2
}

define internal ptr @side_effects(i8 %v) {
; CHECK-LABEL: define {{[^@]+}}@side_effects
; CHECK-SAME: (i8 [[V:%.*]]) {
; CHECK-NEXT:    [[I1:%.*]] = call i32 @external()
; CHECK-NEXT:    [[CA:%.*]] = musttail call noalias noundef align 4294967296 ptr @start(i8 0)
; CHECK-NEXT:    ret ptr [[CA]]
;
  %i1 = call i32 @external()

  ; since this goes back to `start` the SCPP should be see that the return value
  ; is always `null`.
  ; The call can't be removed due to `external` call above, though.

  %ca = musttail call ptr @start(i8 %v)

  ; Thus the result must be returned anyway
  ret ptr %ca
}

define internal ptr @no_side_effects(i8 %v) readonly nounwind {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@no_side_effects
; CGSCC-SAME: (i8 [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    ret ptr null
;
  ret ptr null
}

define internal ptr @dont_zap_me(i8 %v) {
; CHECK-LABEL: define {{[^@]+}}@dont_zap_me
; CHECK-SAME: (i8 [[V:%.*]]) {
; CHECK-NEXT:    [[I1:%.*]] = call i32 @external()
; CHECK-NEXT:    ret ptr null
;
  %i1 = call i32 @external()
  ret ptr null
}
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
;.
