; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt                        -passes=instcombine -S %s | FileCheck %s --check-prefix=NATURAL
; RUN: opt --data-layout="i16:32" -passes=instcombine -S %s | FileCheck %s --check-prefix=OVERALIGNED

; The data layouts are little endian, so @foo is 0x0123456789ABCDEF in memory.
@foo = constant <4 x i16> <i16 u0x2301, i16 u0x6745, i16 u0xAB89, i16 u0xEFCD>, align 8

declare void @report(i64 %index, i8 %val)

define void @test_vector_load_i8() {
; Access and report each individual byte in @foo.
; OVERALIGNED and NATURAL should have the same result, because the layout of vectors ignores
; element type alignment, and thus the representation of @foo is the same in both cases.
; NATURAL-LABEL: @test_vector_load_i8(
; NATURAL-NEXT:    call void @report(i64 0, i8 1)
; NATURAL-NEXT:    call void @report(i64 1, i8 35)
; NATURAL-NEXT:    call void @report(i64 2, i8 69)
; NATURAL-NEXT:    call void @report(i64 3, i8 103)
; NATURAL-NEXT:    call void @report(i64 4, i8 -119)
; NATURAL-NEXT:    call void @report(i64 5, i8 -85)
; NATURAL-NEXT:    call void @report(i64 6, i8 -51)
; NATURAL-NEXT:    call void @report(i64 7, i8 -17)
; NATURAL-NEXT:    ret void
;
; OVERALIGNED-LABEL: @test_vector_load_i8(
; OVERALIGNED-NEXT:    call void @report(i64 0, i8 1)
; OVERALIGNED-NEXT:    call void @report(i64 1, i8 35)
; OVERALIGNED-NEXT:    call void @report(i64 2, i8 69)
; OVERALIGNED-NEXT:    call void @report(i64 3, i8 103)
; OVERALIGNED-NEXT:    call void @report(i64 4, i8 -119)
; OVERALIGNED-NEXT:    call void @report(i64 5, i8 -85)
; OVERALIGNED-NEXT:    call void @report(i64 6, i8 -51)
; OVERALIGNED-NEXT:    call void @report(i64 7, i8 -17)
; OVERALIGNED-NEXT:    ret void
;
  %ptr0 = getelementptr i8, ptr @foo, i64 0
  %res0 = load i8, ptr %ptr0, align 1
  call void @report(i64 0, i8 %res0)

  %ptr1 = getelementptr i8, ptr @foo, i64 1
  %res1 = load i8, ptr %ptr1, align 1
  call void @report(i64 1, i8 %res1)

  %ptr2 = getelementptr i8, ptr @foo, i64 2
  %res2 = load i8, ptr %ptr2, align 1
  call void @report(i64 2, i8 %res2)

  %ptr3 = getelementptr i8, ptr @foo, i64 3
  %res3 = load i8, ptr %ptr3, align 1
  call void @report(i64 3, i8 %res3)

  %ptr4 = getelementptr i8, ptr @foo, i64 4
  %res4 = load i8, ptr %ptr4, align 1
  call void @report(i64 4, i8 %res4)

  %ptr5 = getelementptr i8, ptr @foo, i64 5
  %res5 = load i8, ptr %ptr5, align 1
  call void @report(i64 5, i8 %res5)

  %ptr6 = getelementptr i8, ptr @foo, i64 6
  %res6 = load i8, ptr %ptr6, align 1
  call void @report(i64 6, i8 %res6)

  %ptr7 = getelementptr i8, ptr @foo, i64 7
  %res7 = load i8, ptr %ptr7, align 1
  call void @report(i64 7, i8 %res7)

  ret void
}
