'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetMap \- Allocate an XkbDescRec structure and populate it with the server's 
keyboard 
client map and server map
.SH SYNOPSIS
.HP
.B XkbDescPtr XkbGetMap
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "unsigned int " "device_spec" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- which
mask selecting subcomponents to populate
.TP
.I \- device_spec
device_id, or XkbUseCoreKbd
.SH DESCRIPTION
.LP
Xkb provides two functions to obtain the keyboard mapping components from the 
server. The 
first function, 
.I XkbGetMap, 
allocates an XkbDescRec structure, retrieves mapping components from the server, 
and 
stores them in the XkbDescRec structure it just allocated. The second function, 
.I XkbGetUpdatedMap, 
retrieves mapping components from the server and stores them in an XkbDescRec 
structure 
that has previously been allocated.

To allocate an XkbDescRec structure and populate it with the server's keyboard 
client map 
and server map, use 
.I XkbGetMap. XkbGetMap 
is similar to 
.I XkbGetKeyboard,
but is used only for obtaining the address of an XkbDescRec structure that is 
populated 
with keyboard mapping components. It allows finer control over which 
substructures of the 
keyboard mapping components are to be populated.
.I XkbGetKeyboard 
always returns fully populated components, while 
.I XkbGetMap 
can be instructed to return a partially populated component.

The 
.I which mask is a bitwise inclusive OR of the masks defined in Table 14.1. Only 
those 
portions of the keyboard server map and the keyboard client maps that are 
specified in 
.I which 
are allocated and populated. 

In addition to allocating and obtaining the server map and the client map,
.I XkbGetMap 
also sets the 
.I device_spec, 
the 
.I min_key_code, 
and 
.I max_key_code 
fields of the keyboard description. 

.I XkbGetMap 
is synchronous; it queries the server for the desired information, waits for a 
reply, and 
then returns. If successful, 
.I XkbGetMap 
returns a pointer to the XkbDescRec structure it allocated. If unsuccessful,
.I XkbGetMap 
returns NULL. When unsuccessful, one of the following protocol errors is also 
generated: 
BadAlloc (unable to allocate the XkbDescRec structure), BadValue (some mask bits 
in 
.I which 
are undefined), or BadImplementation (a compatible version of the Xkb extension 
is not 
available in the server). To free the returned data, use
.I XkbFreeKeyboard.

Xkb also provides convenience functions to get partial component definitions 
from the 
server. These functions are specified in the "convenience functions" column in 
Table 
1. Refer to the sections listed in the table for more information on these 
functions.

.TS
c s s s s
c s s s s
l l l l l
l l l l l
lw(3i) l l lw(1i) lw(3i).
Table 1 Xkb Mapping Component Masks
and Convenience Functions
_
Mask	Value	Map	Fields	Convenience
				Functions
_
T{
XkbKeyTypesMask
T}	(1<<0)	client	T{
types
.br
size_types
.br
num_types
T}	T{
XkbGetKeyTypes
.br
XkbResizeKeyType
.br
XkbCopyKeyType
.br
XkbCopyKeyTypes
T}
T{
XkbKeySymsMask
T}	(1<<1)	client	T{
syms
.br
size_syms
.br
num_syms
.br
key_sym_map
T}	T{
XkbGetKeySyms
.br
XkbResizeKeySyms
.br
XkbChangeTypesOfKey
T}
T{
XkbModifierMapMask
T}	(1<<2)	client	modmap	T{
XkbGetKeyModifierMap
T}
T{
XkbExplicitComponentsMask
T}	(1<<3)	server	T{
explicit
T}	T{
XkbGetKeyExplicitComponents
T}
T{
XkbKeyActionsMask
T}	(1<<4)	server	T{
key_acts
.br
acts
.br
num_acts
.br
size_acts
T}	T{
XkbGetKeyActions
.br
XkbResizeKeyActions
T}
T{
XkbKeyBehaviorsMask
T}	(1<<5)	server	T{
behaviors
T}	T{
XkbGetKeyBehaviors
T}
T{
XkbVirtualModsMask
T}	(1<<6)	server	T{
vmods
T}	T{
XkbGetVirtualMods
T}
T{
XkbVirtualModMapMask
T}	(1<<7)	server	T{
vmodmap
T}	T{
XkbGetVirtualModMap
T}
.TE

.nf
.bp
Xkb defines combinations of these masks for convenience:
   
   #define XkbResizableInfoMask   (XkbKeyTypesMask)
   #define XkbAllClientInfoMask   (XkbKeyTypesMask | XkbKeySymsMask |
                                   XkbModifierMapMask)
   #define XkbAllServerInfoMask   (XkbExplicitComponentsMask |
                                   XkbKeyActionsMask | 
                                   XkbKeyBehaviorsMask |
                                   XkbVirtualModsMask | 
                                   XkbVirtualModMapMask)
   #define XkbAllMapComponentsMask XkbAllClientInfoMask | 
                                   XkbAllServerInfoMask)
      
.fi      
Key types, symbol maps, and actions are all interrelated: changes in one require 
changes 
in the others. The convenience functions make it easier to edit these components 
and 
handle the interdependencies. 

.SH STRUCTURES
.LP
The complete description of an Xkb keyboard is given by an XkbDescRec. The 
component 
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\&* connection to X server */
   unsigned short     flags;        /\&* private to Xkb, do not modify */
   unsigned short     device_spec;  /\&* device of interest */
   KeyCode            min_key_code; /\&* minimum keycode for device */
   KeyCode            max_key_code; /\&* maximum keycode for device */
   XkbControlsPtr     ctrls;        /\&* controls */
   XkbServerMapPtr    server;       /\&* server keymap */
   XkbClientMapPtr    map;          /\&* client keymap */
   XkbIndicatorPtr    indicators;   /\&* indicator map */
   XkbNamesPtr        names;        /\&* names for all components */
   XkbCompatMapPtr    compat;       /\&* compatibility map */
   XkbGeometryPtr     geom;         /\&* physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the 
keyboard. 

Each structure component has a corresponding mask bit that is used in function 
calls to 
indicate that the structure should be manipulated in some manner, such as 
allocating it 
or freeing it. These masks and their relationships to the fields in the 
XkbDescRec are 
shown in Table 2.

.TS
c s s
l l l
l l l.
Table 2 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE
.SH "SEE ALSO"
.BR XkbChangeTypesOfKey (__libmansuffix__),
.BR XkbCopyKeyType (__libmansuffix__),
.BR XkbCopyKeyTypes (__libmansuffix__),
.BR XkbFreeClientMap (__libmansuffix__),
.BR XkbGetKeyActions (__libmansuffix__),
.BR XkbGetKeyBehaviors (__libmansuffix__),
.BR XkbGetKeyboard (__libmansuffix__),
.BR XkbGetKeyExplicitComponents (__libmansuffix__),
.BR XkbGetKeyModifierMap (__libmansuffix__),
.BR XkbGetKeySyms (__libmansuffix__),
.BR XkbGetKeyTypes (__libmansuffix__),
.BR XkbGetUpdatedMap (__libmansuffix__),
.BR XkbGetVirtualModMap (__libmansuffix__),
.BR XkbGetVirtualMods (__libmansuffix__),
.BR XkbResizeKeyActions (__libmansuffix__),
.BR XkbResizeKeySyms (__libmansuffix__),
.BR XkbResizeKeyType (__libmansuffix__)





