.\" Copyright © 2005-2010  Roger Leigh <rleigh@debian.org>
.\"
.\" schroot is free software: you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" schroot is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.\"
.so config.man
.TH SCHROOT\-SETUP 5 "\*[RELEASE_DATE]" "Version \*[VERSION]" "Debian sbuild"
.SH NAME
schroot\-setup \- schroot chroot setup scripts
.SH DESCRIPTION
\fBschroot\fP uses scripts to set up and then clean up the chroot environment.
The directory \f[BI]\*[SCHROOT_CONF_SETUP_D]\fP contains scripts run when a
chroot is created and destroyed.  Several environment variables are set while
the scripts are being run, which allows their behaviour to be customised,
depending upon, for example, the type of chroot in use.
.PP
The scripts are run in name order, like those run by
.BR init (8),
by using the same style of execution as
.BR run-parts (8).
.PP
The setup scripts are all invoked with two options:
.IP 1
The action to perform.
.IP
When a session is first started, the chroot is set up by running the scripts in
\*[SCHROOT_CONF_SETUP_D] with the \[oq]setup\-start\[cq] option.  When the
session is ended, the scripts in \fI\*[SCHROOT_CONF_SETUP_D]\fP are run in
reverse order with the \[oq]setup\-stop\[cq] option.
.IP 2
The chroot status.
.IP
This is either \[oq]ok\[cq] if there are no problems, or \[oq]fail\[cq] if
something went wrong.  For example, particular actions may be skipped on
failure.
.PP
Note that the scripts should be \fIidempotent\fP.  They \fBmust\fP be
idempotent during the \[oq]setup\-stop\[cq] phase, because they may be run more
than once, for example on failure.
.SH ENVIRONMENT
.SS General variables
.TP
AUTH_USER
The username of the user the command in the chroot will run as.
.TP
CHROOT_NAME
The chroot name.  Note that this is the name of the orignal chroot before
session creation; you probably want SESSION_ID.
.TP
LIBEXEC_DIR
The directory under which helper programs are located.
.TP
MOUNT_DIR
The directory under which non-filesystem chroots are mounted (e.g. block
devices and LVM snapshots).
.TP
PID
The process ID of the schroot process.
.TP
PLATFORM
The operating system platform schroot is running upon.  This may be used to
introduce platform-specific behaviour into the setup scripts where required.
Note that the HOST variables are probably what are required.  In the context of
schroot, the platform is the supported configuration and behaviour for a given
architecture, and may be identical between different architectures.
.TP
SESSION_ID
The session identifier.
.TP
VERBOSE
Set to \[oq]quiet\[cq] if only error messages should be printed,
\[oq]normal\[cq] if other messages may be printed as well, and
\[oq]verbose\[cq] if all messages may be printed.  Previously called
AUTH_VERBOSITY.
.TP
CHROOT_SESSION_CREATE
Set to \[oq]true\[cq] if a session will be created, otherwise \[oq]false\[cq].
.TP
CHROOT_SESSION_CLONE
Set to \[oq]true\[cq] if a session will be cloned, otherwise \[oq]false\[cq].
.TP
CHROOT_SESSION_PURGE
Set to \[oq]true\[cq] if a session will be purged, otherwise \[oq]false\[cq].
.TP
CHROOT_TYPE
The type of the chroot.  This is useful for restricting a setup task to
particular types of chroot (e.g. only block devices or LVM snapshots).
.TP
CHROOT_NAME
The name of the chroot.  This is useful for restricting a setup task to a
particular chroot, or set of chroots.
.TP
CHROOT_ALIAS
The name of the alias used to select the chroot.  This is useful for
specialising a setup task based upon one of its alternative alias names, or the
default chroot name.  For example, it could be used to specify additional
sources in \fI/etc/apt/sources.list\fP, such as a stable-security alias for a
stable chroot, or an experimental alias for an unstable chroot.
.TP
CHROOT_DESCRIPTION
The description of the chroot.
.TP
CHROOT_MOUNT_LOCATION
The location to mount the chroot.  It is used for mount point creation and
mounting.
.TP
CHROOT_LOCATION
The location of the chroot inside the mount point.  This is to allow multiple
chroots on a single filesystem.  Set for all mountable chroot types.
.TP
CHROOT_PATH
The absolute path to the chroot.  This is typically CHROOT_MOUNT_LOCATION and
CHROOT_LOCATION concatenated together.  This is the path which should be used
to access the chroots.
.SS Plain and directory chroot variables
These chroot types use only general variables.
.SS File variables
.TP
CHROOT_FILE
The file containing the chroot files.
.TP
CHROOT_FILE_REPACK
Set to \[oq]true\[cq] to repack the chroot into an archive file on ending a
session, otherwise \[oq]false\[cq].
.SS Mountable chroot variables
.PP
These variables are only set for directly mountable chroot types.
.TP
CHROOT_MOUNT_DEVICE
The device to mount containing the chroot.
mounting.
.TP
CHROOT_MOUNT_OPTIONS
Options to pass to
.BR mount (8).
.TP
CHROOT_LOCATION
The location of the chroot inside the mount point.  This allows the existence
of multiple chroots on a single filesystem.
.SS Filesystem union variables
.TP
CHROOT_UNION_TYPE
Union filesystem type.
.TP
CHROOT_UNION_MOUNT_OPTIONS
Union filesystem mount options.
.TP
CHROOT_UNION_OVERLAY_DIRECTORY
Union filesystem overlay directory (writable).
.TP
CHROOT_UNION_UNDERLAY_DIRECTORY
Union filesystem underlay directory (read-only).
.SS Block device variables
.TP
CHROOT_DEVICE
The device containing the chroot root filesystem.  This is usually, but not
necessarily, the device which will be mounted.  For example, an LVM snapshot
this will be the original logical volume.
.SS LVM snapshot variables
.TP
CHROOT_LVM_SNAPSHOT_NAME
Snapshot name to pass to
.BR lvcreate (8).
.TP
CHROOT_LVM_SNAPSHOT_DEVICE
The name of the LVM snapshot device.
.TP
CHROOT_LVM_SNAPSHOT_OPTIONS
Options to pass to
.BR lvcreate (8).
.SS Custom variables
.PP
Custom keys set in \fIschroot.conf\fP will be uppercased and set in the
environment as described in
.BR schroot.conf (5).
.SH FILES
.SS Setup script configuration
The directory \f[BI]\*[SCHROOT_SYSCONF_DIR]/default\fP contains the default
settings used by setup scripts.
.TP
\f[BI]config\fP
Main configuration file read by setup scripts.  The format of this file is
described in
.BR schroot\-script\-config (5).
This is the default value for the \f[CI]script\-config\fP key.  Note that this
was formerly named \fI\*[SCHROOT_SYSCONF_DIR]/script\-defaults\fP.  The following
files are referenced by default:
.TP
\f[BI]copyfiles\fP
A list of files to copy into the chroot from the host system.  Note that this
was formerly named \fI\*[SCHROOT_SYSCONF_DIR]/copyfiles\-defaults\fP.
.TP
\f[BI]fstab\fP
A file in the format decribed in
.BR fstab (5),
used to mount filesystems inside the chroot.  The mount location is relative to
the root of the chroot.  Note that this was formerly named
\fI\*[SCHROOT_SYSCONF_DIR]/mount\-defaults\fP.
.TP
\f[BI]nssdatabases\fP
System databases (as described in \fI/etc/nsswitch.conf\fP on GNU/Linux
systems) to copy into the chroot from the host.  Note that this was formerly
named \fI\*[SCHROOT_SYSCONF_DIR]/nssdatabases\-defaults\fP.
.SS Setup scripts
The directory \f[BI]\*[SCHROOT_CONF_SETUP_D]\fP contains the chroot setup scripts.
.TP
\f[BI]00check\fP
Print debugging diagnostics and perform basic sanity checking.
.TP
\f[BI]05file\fP
Unpack, clean up, and repack file-based chroots.
.TP
\f[BI]05fsunion\fP
Create and remove union filesystems.
.TP
\f[BI]05lvm\fP
Create and remove LVM snapshots.
.TP
\f[BI]10mount\fP
Mount and unmount filesystems.
.TP
\f[BI]15binfmt\fP
Sets up the QEMU user emulator using binfmt-support.  This permits a chroot for
a different CPU architecture to be used transparently, providing an alternative
to cross-compiling or whole-machine emulation.
.TP
\f[BI]15killprocs\fP
Kill processes still running inside the chroot when ending a session, which
would prevent unmounting of filesystems and cleanup of any other resources.
.TP
\f[BI]20copyfiles\fP
Copy files from the host system into the chroot.  Configure networking by
copying \fIhosts\fP and \fIresolv.conf\fP, for example.
.TP
\f[BI]20nssdatabases\fP
Configure system databases by copying passwd, shadow, group etc. into the
chroot.
.TP
\f[BI]50chrootname\fP
Set the chroot name (\fI/etc/debian_chroot\fP) in the chroot.  This may be used
by the shell prompt to display the current chroot.
.so authors.man
.so copyright.man
.SH SEE ALSO
.BR schroot (1),
.BR fstab (5),
.BR schroot.conf (5),
.BR schroot\-script\-config (5),
.BR run\-parts (8).
.\"#
.\"# The following sets edit modes for GNU EMACS
.\"# Local Variables:
.\"# mode:nroff
.\"# fill-column:79
.\"# End:
