/**
 * Type declarations for vectorial font.
 * 
 * @file
 */

#ifndef VGLYPH_H
#define	VGLYPH_H

/**
 * Defines a single glyph. Each glyph contains zero or more paths, each path
 * contains zero or more points. For example, the vertical bar '|' can be
 * described by a single path with 2 vertices.
 */
typedef struct {
	short     path_count;
	short     path_start;
	short     glyph_width;
} VGlyph_Type;

typedef struct {
	short     vertex_count;
	short     vertex_start;
} VGlyph_Path;

typedef struct {
	short     x;
	short     y;
} VGlyph_Vertex;

#endif

