/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */

#ifndef DATUM_H
#define DATUM_H

#ifdef datum_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 *  This enumerative type was prepared from values listed in:
 *
 *  "Enumeration and Bit-Encoded Values for use with
 *  IEEE 1278.1 - 1994, Distributed Interactive Simulation --
 *  Application Protocols"
 *
 *  Document Number:    IST-CR-93-46
 *  Date:               March 1994
 *
 *  Copyright (C) 1995, Riley Rainey, riley@netcom.com
 *
 *  DATUM IDENTIFIERS
 *
 *  Problem:  Which are fixed and which are variable ???
 */
typedef enum {
	datum_Identification = 10000,	/*            */
	datum_EntityType = 11000,	/*            */
	datum_Concatenated = 11100,	/*            */
	datum_Kind = 11110,			/* u_long     */
	datum_Domain = 11120,		/* u_long     */
	datum_Country = 11130,		/* u_long     */
	datum_Category = 11140,		/* u_long     */
	datum_Subcategory = 11150,	/* u_long     */
	datum_Specific = 11160,		/* u_long     */
	datum_Extra = 11170,			/* u_long     */
	datum_ForceID = 11200,		/* u_long     */
	datum_Description = 11300,	/*            */
	datum_AlternativeEntityType = 12000,		/*            */
	datum_AltKind = 12110,		/* u_long     */
	datum_AltDomain = 12120,		/* u_long     */
	datum_AltCountry = 12130,	/* u_long     */
	datum_AltCategory = 12140,	/* u_long     */
	datum_AltSubcategory = 12150,	/* u_long     */
	datum_AltSpecific = 12160,	/* u_long     */
	datum_AltExtra = 12170,		/* u_long     */
	datum_AltDescription = 12300,	/*            */
	datum_EntityMarking = 13000,	/*            */
	datum_EntityMarkingCharacters = 13100,	/* char[10]   */
	datum_CrewID = 13200,		/* char[10]   */
	datum_TaskOrganization = 14000,	/*            */
	datum_RegimentName = 14200,	/* String     */
	datum_BattalionName = 14300,	/* String     */
	datum_CompanyName = 14400,	/* String     */
	datum_PlatoonName = 14500,	/*            */
	datum_SquadName = 14520,		/*            */
	datum_TeamName = 14540,		/*            */
	datum_BumperNumber = 14600,	/*            */
	datum_VehicleNumber = 14700,	/*            */
	datum_UnitNumber = 14800,	/*            */
	datum_DISIdentity = 15000,	/*            */
	datum_DISSiteID = 15100,		/*            */
	datum_DISHostID = 15200,		/*            */
	datum_DISEntityID = 15300,	/*            */
	datum_Loads = 20000,			/*            */
	datum_CrewMembers = 21000,	/*            */
	datum_CrewMemberID = 21100,	/*            */
	datum_Health = 21200,		/*            */
	datum_JobAssignment = 21300,	/* String     */
	datum_Fuel = 23000,			/*            */
	datum_Quantity = 23100,		/* Liters     */
	datum_QuantityGallons = 23105,	/* Gallons    */
	datum_Ammunition = 24000,	/*            */
	datum_120mmHEATquantity = 24001,		/* Rounds     */
	datum_120mmSABOTquantity = 24002,	/* Rounds     */
	datum_127mmM8quantity = 24003,	/* Rounds     */
	datum_127mmM20quantity = 24004,	/* Rounds     */
	datum_762mmM62quantity = 24005,	/* Rounds     */
	datum_M250UKL8A1quantity = 24006,	/* Grenades   */
	datum_M250UKL8A3quantity = 24007,	/* Grenades   */
	datum_762mmM80quantity = 24008,	/* Rounds     */
	datum_127mmquantity = 24009,	/* Rounds     */
	datum_762mmquantity = 24010,	/* Rounds     */
	datum_Minesquantity = 24060,	/* Mines      */
	datum_AmmunitionType = 24100,	/*            */
	datum_AmmunitionKind = 24110,	/*            */
	datum_AmmunitionDomain = 24120,	/*            */
	datum_AmmunitionCountry = 24130,		/*            */
	datum_AmmunitionCategory = 24140,	/*            */
	datum_AmmunitionSubcategory = 24150,		/*            */
	datum_AmmunitionExtra = 24160,	/*            */
	datum_AmmunitionDescription = 24300,		/*            */
	datum_Cargo = 25000,			/*            */
	datum_VehicleMass = 26000,	/* u_long     */
	datum_SupplyQuantity = 27000,	/*            */
	datum_Armament = 28000,		/* Boolean    */
	datum_Status = 30000,		/*            */
	datum_Position = 31000,		/*            */
	datum_MilGrid10 = 31100,		/*            */
	datum_GeocentricCoordinates = 31200,		/*            */
	datum_GeocentricCoordinatesX = 31210,	/* u_long     */
	datum_GeocentricCoordinatesY = 31220,	/* u_long     */
	datum_GeocentricCoordinatesZ = 31230,	/* u_long     */
	datum_Latitude = 31300,		/*            */
	datum_Longitude = 31400,		/*            */
	datum_Orientation = 32000,	/*            */
	datum_HullHeadingAngle = 32100,	/* Degrees    */
	datum_HullPitchAngle = 32200,	/*            */
	datum_RollAngle = 32300,		/*            */
	datum_OrientationX = 32500,	/* u_long     */
	datum_OrientationY = 32600,	/* u_long     */
	datum_OrientationZ = 32700,	/* u_long     */
	datum_Appearance = 33000,	/*            */
	datum_AmbientLighting = 33100,	/*            */
	datum_Lights = 33101,		/*            */
	datum_PaintScheme = 33200,	/*            */
	datum_Smoke = 33300,			/*            */
	datum_TrailingEffects = 33400,	/*            */
	datum_Flaming = 33500,		/*            */
	datum_Marking = 33600,		/*            */
	datum_MinePlowsAttached = 33710,		/*            */
	datum_MineRollersAttached = 33720,	/*            */
	datum_TankTurretAzimuth = 33730,		/* Degrees    */
	datum_FailuresandMalfunctions = 34000,	/*            */
	datum_Age = 34100,			/* Miles      */
	datum_Kilometers = 34110,	/*            */
	datum_Damage = 35000,		/*            */
	datum_Cause = 35050,			/*            */
	datum_MobilityKill = 35100,	/*            */
	datum_Fire_PowerKill = 35200,	/*            */
	datum_PersonnelCasualties = 35300,	/*            */
	datum_Velocity = 36000,		/*            */
	datum_XVelocity = 36100,		/* Meters/sec */
	datum_YVelocity = 36200,		/* Meters/sec */
	datum_ZVelocity = 36300,		/* Meters/sec */
	datum_Acceleration = 37000,	/*            */
	datum_XAcceleration = 37100,	/*            */
	datum_YAcceleration = 37200,	/*            */
	datum_ZAcceleration = 37300,	/*            */
	datum_EngineStatus = 38100,	/*            */
	datum_Exercise = 40000,		/*            */
	datum_TerrainDatabase = 41000,	/*            */
	datum_Missions = 42000,		/*            */
	datum_MissionID = 42100,		/*            */
	datum_MissionType = 42200,	/*            */
	datum_MissionRequestTimeStamp = 42300,	/*            */
	datum_ExerciseDescription = 43000,	/* String     */
	datum_Name = 43100,			/* String     */
	datum_Entities = 43200,		/* Integer    */
	datum_Version = 43300,		/*            */
	datum_Environment = 50000,	/*            */
	datum_Weather = 51000,		/*            */
	datum_ThermalCondition = 51100,	/*            */
	datum_Time = 52000,			/*            */
	datum_TimeofDayDiscrete = 52100,		/*            */
	datum_TimeofDayContinuous = 52200,	/*            */
	datum_TimeMode = 52300,		/*            */
	datum_TimeScene = 52305,		/*            */
	datum_CurrentHour = 52310,	/*            */
	datum_CurrentMinute = 52320,	/*            */
	datum_CurrentSecond = 52330,	/*            */
	datum_Azimuth = 52340,		/*            */
	datum_MaximumElevation = 52350,	/*            */
	datum_TimeZone = 52360,		/*            */
	datum_TimeSunriseEnabled = 52400,	/*            */
	datum_SunriseHour = 52410,	/*            */
	datum_SunriseMinute = 52420,	/*            */
	datum_SunriseSecond = 52430,	/*            */
	datum_SunriseAzimuth = 52440,	/*            */
	datum_TimeSunsetEnabled = 52500,		/*            */
	datum_SunsetHour = 52510,	/*            */
	datum_SunsetMinute = 52520,	/*            */
	datum_SunsetSecond = 52530,	/*            */
	datum_Date = 52600,			/*            */
	datum_Month = 52610,			/*            */
	datum_Day = 52620,			/*            */
	datum_Year = 52630,			/*            */
	datum_Clouds = 53000,		/*            */
	datum_CloudLayerEnable = 53050,	/*            */
	datum_CloudLayerSelection = 53060,	/*            */
	datum_CloudVisibility = 53100,	/*            */
	datum_CloudBaseAltitude = 53200,		/* Meters     */
	datum_CloudBaseAltitudeFeet = 53250,		/* Feet       */
	datum_CloudCeiling = 53300,	/* Meters     */
	datum_cloudCeilingFeet = 53350,	/* Feet       */
	datum_Characteristics = 53400,	/*            */
	datum_Precipitation = 54000,	/*            */
	datum_Rain = 54100,			/* Boolean    */
	datum_Fog = 55000,			/* Boolean    */
	datum_Visibility = 55100,	/* Meters     */
	datum_VisibilityMiles = 55105,	/* Miles      */
	datum_Density = 55200,		/*            */
	datum_Base = 55300,			/*            */
	datum_ViewLayerFromAbove = 55401,	/*            */
	datum_TransitionRange = 55410,	/*            */
	datum_Bottom = 55420,		/* Meters     */
	datum_BottomFeet = 55425,	/* Feet       */
	datum_Ceiling = 55430,		/* Meters     */
	datum_CeilingFeet = 55435,	/* Feet       */
	datum_HeavenlyBodies = 56000,	/*            */
	datum_Sun = 56100,			/*            */
	datum_SunPosition = 56110,	/*            */
	datum_SunPositionAzimuth = 56120,	/*            */
	datum_SunPositionElevation = 56130,	/*            */
	datum_SunPositionIntensity = 56140,	/*            */
	datum_Moon = 56200,			/*            */
	datum_MoonPosition = 56210,	/*            */
	datum_MoonPositionAzimuth = 56220,	/*            */
	datum_MoonPositionElevation = 56230,		/*            */
	datum_MoonPositionIntensity = 56240,		/*            */
	datum_Horizon = 56310,		/*            */
	datum_HorizonAzimuth = 56320,	/*            */
	datum_HorizonElevation = 56330,	/*            */
	datum_HorizonHeading = 56340,	/*            */
	datum_HorizonIntensity = 56350,	/*            */
	datum_Meteorological = 57000,	/*            */
	datum_MeteorologicalTemperature = 57100,		/*            */
	datum_MeteorologicalHumidity = 57200,	/*            */
	datum_MeteorologicalVisibility = 57300,	/*            */
	datum_MeteorologicalWinds = 57400,	/*            */
	datum_MeteorologicalSpeed = 57410,	/*            */
	datum_MeteorologicalRainsoak = 57500,	/*            */
	datum_Haze = 58000,			/* Boolean    */
	datum_HazeVisibility = 58100,	/* Meters     */
	datum_HazeVisibilityMiles = 58105,	/* Miles      */
	datum_HazeDensity = 58200,	/*            */
	datum_HazeCeiling = 58430,	/* Meters     */
	datum_HazeCeilingFeet = 58435,	/* Feet       */
	datum_Communications = 60000,	/*            */
	datum_ChannelType = 61100,	/*            */
	datum_ChannelType1 = 61101,	/*            */
	datum_ChannelIdentification = 61200,		/*            */
	datum_AlphaIdentification = 61300,	/*            */
	datum_RadioIdentification = 61400,	/*            */
	datum_LandLineIdentification = 61500,	/*            */
	datum_IntercomIdentification = 61600,	/*            */
	datum_GroupNetworkChannelNumber = 61700,		/*            */
	datum_RadioCommunicationsStatus = 62100,		/*            */
	datum_StationaryRadioTransmittersDefaultTime = 62200,	/* u_long     */
	datum_MovingRadioTransmittersDefaultTime = 62300,	/* u_long     */
	datum_StationaryRadioSignalsDefaultTime = 62400,		/*            */
	datum_MovingRadioSignalDefaultTime = 62500,	/*            */
	datum_RadioInitTransecSecurityKey = 63101,	/* variable   */
	datum_RadioInitInternalNoiseLevel = 63102,	/* variable   */
	datum_RadioInitSquelchThreshold = 63103,		/* variable   */
	datum_RadioInitAntennaLocation = 63104,	/* variable   */
	datum_RadioInitAntennaPatternType = 63105,	/* variable   */
	datum_RadioInitAntennaPatternLength = 63106,		/* variable   */
	datum_RadioInitBeamDefinition = 63107,	/* variable   */
	datum_RadioInitTransmitHeartbeatTime = 63108,	/* variable   */
	datum_RadioInitTransmitDistanceThreshold = 63109,	/* variable   */
	datum_RadioChannelInitLockoutID = 63110,		/* variable   */
	datum_RadioChannelInitHopsetID = 63111,	/* variable   */
	datum_RadioChannelInitPresetFrequency = 63112,	/* variable   */
	datum_RadioChannelInitFrequencySyncTime = 63113,		/* variable   */
	datum_RadioChannelInitComsecKey = 63114,		/* variable   */
	datum_RadioChannelInitAlpha = 63115,		/* variable   */
	datum_AlgorithmParameters = 70000,	/*            */
	datum_DeadReckoningAlgorithm = 71000,	/*            */
	datum_DRALocationThreshold = 71100,	/* u_long     */
	datum_DRAOrientationThreshold = 71200,	/*            */
	datum_DRATimeThreshold = 71300,	/*            */
	datum_SimulationManagementParameters = 72000,	/*            */
	datum_CheckpointInterval = 72100,	/*            */
	datum_TransmitterTimeThreshold = 72600,	/*            */
	datum_ReceiverTimeThreshold = 72700,		/*            */
	datum_InteroperabilityMode = 73000,	/*            */
	datum_SIMNETDataCollection = 74000,	/* variable*  */
	datum_EventID = 75000,		/*            */
	datum_SourceSiteID = 75100,	/*            */
	datum_SourceHostID = 75200,	/*            */
	datum_ArticulatedPart = 90000,	/*            */
	datum_ArticulatedPartID = 90050,		/*            */
	datum_ArticulatedPartIndex = 90070,	/*            */
	datum_ArticulatedPartPosition = 90100,	/*            */
	datum_ArticulatedPartPositionRate = 90200,	/*            */
	datum_ArticulatedPartExtension = 90300,	/*            */
	datum_ArticulatedPartExtensionRate = 90400,	/*            */
	datum_ArticulatedPartX = 90500,	/*            */
	datum_ArticulatedPartXRate = 90600,	/*            */
	datum_ArticulatedPartY = 90700,	/*            */
	datum_ArticulatedPartYRate = 90800,	/*            */
	datum_ArticulatedPartZ = 90900,	/*            */
	datum_ArticulatedPartZRate = 91000,	/*            */
	datum_ArticulatedPartAzimuth = 91100,	/*            */
	datum_ArticulatedPartAzimuthRate = 91200,	/*            */
	datum_ArticulatedPartElevation = 91300,	/*            */
	datum_ArticulatedPartElevationRate = 91400,	/*            */
	datum_ArticulatedPartRotation = 91500,	/*            */
	datum_ArticulatedPartRotationRate = 91600,	/*            */
	datum_DRAAngularXVelocity = 100001,	/*            */
	datum_DRAAngularYVelocity = 100002,	/*            */
	datum_DRAAngularZVelocity = 100003,	/*            */
	datum_AppearanceTrailingEffects = 100004,	/*            */
	datum_AppearanceHatch = 100005,	/*            */
	datum_AppearanceCharacterSet = 100008,	/*            */
	datum_CapabilityAmmunitionSupplier = 100010,		/*            */
	datum_CapabilityMiscellaneousSupplier = 100011,	/*            */
	datum_CapabilityRepairProvider = 100012,		/*            */
	datum_ArticulationParameter = 100014,	/*            */
	datum_ArticulationParameterType = 100047,	/*            */
	datum_ArticulationParameterValue = 100048,	/*            */
	datum_TimeofDayScene = 100058	/*            */
} datum_Type;

EXTERN char * datum_lookupDatumIDName(datum_Type id);

#undef EXTERN
#endif
