/*--------------------------------------------------------------------------*/
/* ALBERTA:  an Adaptive multi Level finite element toolbox using           */
/*           Bisectioning refinement and Error control by Residual          */
/*           Techniques for scientific Applications                         */
/*                                                                          */
/* www.alberta-fem.de                                                       */
/*                                                                          */
/* file:     assemble_dowb.c                                                */
/*                                                                          */
/* description:  fe-space independent assemblation routines of              */
/*               REAL_D x REAL_D matrices                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* This file's authors: Claus-Justus Heine                                  */
/*                      Lehrstuhle Numerik fuer Hoechstleistungsrechner     */
/*                      Institut fuer Angewandte Analysis                   */
/*                          und Numerische Simulation                       */
/*                      Universitaet Stuttgart                              */
/*                      Pfaffenwaldring 57                                  */
/*                      70569 Stuttgart, Germany                            */
/*                                                                          */
/* (c) by C.-J. Heine (2004-2006)                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#ifndef _ALBERTA_M_M_DM_DM_ASSEMBLE_DOWB_FCTS_H_
#define _ALBERTA_M_M_DM_DM_ASSEMBLE_DOWB_FCTS_H_

#include "alberta.h"
#include "alberta_intern.h"
#include "assemble.h"

#line 31 "../../../../alberta/src/Common/assemble_fcts.h.in"

#if ALBERTA_DEBUG == 1
# define inline /* */
#endif

#define HAVE_M_DST_TYPE 1
#define HAVE_M_LALT_TYPE 1
#define HAVE_DM_LB_TYPE 1
#define HAVE_DM_C_TYPE 1

#if !HAVE_ROW_FCTS_V_TYPE && !HAVE_COL_FCTS_V_TYPE
# define VEC_PFX SS
# define EMIT_SS_VERSIONS 1
#elif HAVE_ROW_FCTS_V_TYPE && HAVE_COL_FCTS_V_TYPE
# define VEC_PFX VV
# define EMIT_VV_VERSIONS 1
#elif HAVE_ROW_FCTS_V_TYPE && HAVE_COL_FCTS_C_TYPE
# define VEC_PFX VC
# define EMIT_VC_VERSIONS 1
#elif HAVE_ROW_FCTS_C_TYPE && HAVE_COL_FCTS_V_TYPE
# define VEC_PFX CV
# define EMIT_CV_VERSIONS 1
#elif !HAVE_M_DST_TYPE && HAVE_ROW_FCTS_V_TYPE && !HAVE_COL_FCTS_V_TYPE
# define VEC_PFX VS
# define EMIT_VS_VERSIONS 1
#elif !HAVE_M_DST_TYPE && !HAVE_ROW_FCTS_V_TYPE && HAVE_COL_FCTS_V_TYPE
# define VEC_PFX SV
# define EMIT_SV_VERSIONS 1
#else
# error impossible block-matrix combinations
#endif

#undef NAME
#undef NAMEPFX
#define NAMEPFX								\
  _AI_CONCAT(VEC_PFX, _MMDMDM_)
#define NAME(base) _AI_CONCAT(NAMEPFX, base)


/* <<< ... with pre-computed integrals */

extern void NAME(pre_2)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_01)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_10)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_11)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(adv_pre_01)(
  const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(adv_pre_10)(
  const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(adv_pre_11)(
  const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);

extern void NAME(pre_2_01)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_2_10)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_2_11)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_2_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);

extern void NAME(pre_01_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_10_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void NAME(pre_11_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);

extern void
NAME(pre_2_01_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void
NAME(pre_2_10_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);
extern void
NAME(pre_2_11_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);

/* <<< ... without pre-computed integrals */

#undef ARG_DECL
#define ARG_DECL (const EL_INFO *el_info, const FILL_INFO *info)

DECLARE_DIM_VERSIONS(extern, NAME(quad_2), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_01), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_10), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_11), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(adv_quad_01), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(adv_quad_10), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(adv_quad_11), ARG_DECL);
extern void NAME(quad_0)(const EL_INFO *el_info, const FILL_INFO *fill_info);

DECLARE_DIM_VERSIONS(extern, NAME(quad_2_01), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_2_10), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_2_11), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_2_0), ARG_DECL);

DECLARE_DIM_VERSIONS(extern, NAME(quad_01_0), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_10_0), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_11_0), ARG_DECL);

DECLARE_DIM_VERSIONS(extern, NAME(quad_2_01_0), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_2_10_0), ARG_DECL);
DECLARE_DIM_VERSIONS(extern, NAME(quad_2_11_0), ARG_DECL);

/* >>> */

#endif

/*
 * Local Variables: ***
 * mode: C ***
 * End: ***
 */
