#ifndef __AAFTypeDefUIDs_h__
#define __AAFTypeDefUIDs_h__

#include "aaf/AAFTypes.h"

// AAF type definition UIDs.
//

//{01010100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt8 =
{0x01010100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt16 =
{0x01010200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt32 =
{0x01010300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt64 =
{0x01010400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int8 =
{0x01010500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int16 =
{0x01010600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int32 =
{0x01010700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01010800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int64 =
{0x01010800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01012001-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PositionType =
{0x01012001, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01012002-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_LengthType =
{0x01012002, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01012003-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_JPEGTableIDType =
{0x01012003, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01012300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PhaseFrameType =
{0x01012300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01030100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_AUID =
{0x01030100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01030200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobIDType =
{0x01030200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01040100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Boolean =
{0x01040100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01100100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Character =
{0x01100100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{01100200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_String =
{0x01100200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010101-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ProductReleaseType =
{0x02010101, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010102-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TapeFormatType =
{0x02010102, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010103-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_VideoSignalType =
{0x02010103, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010104-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TapeCaseType =
{0x02010104, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010105-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ColorSitingType =
{0x02010105, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010106-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EditHintType =
{0x02010106, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010107-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_FadeType =
{0x02010107, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010108-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_LayoutType =
{0x02010108, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010109-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TCSource =
{0x02010109, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010a-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PulldownDirectionType =
{0x0201010a, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010b-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PulldownKindType =
{0x0201010b, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010c-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EdgeType =
{0x0201010c, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010d-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_FilmType =
{0x0201010d, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010e-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_RGBAComponentKind =
{0x0201010e, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201010f-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ReferenceType =
{0x0201010f, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010120-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_AlphaTransparencyType =
{0x02010120, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010121-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_FieldNumber =
{0x02010121, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010122-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ElectroSpatialFormulation =
{0x02010122, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010123-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EmphasisType =
{0x02010123, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010124-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_AuxBitsModeType =
{0x02010124, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010125-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ChannelStatusModeType =
{0x02010125, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010126-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UserDataModeType =
{0x02010126, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010127-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SignalStandardType =
{0x02010127, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02010128-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ScanningDirectionType =
{0x02010128, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201012a-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ContentScanningType =
{0x0201012a, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{0201012b-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TitleAlignmentType =
{0x0201012b, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020101-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationCategoryType =
{0x02020101, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020102-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TransferCharacteristicType =
{0x02020102, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020103-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PluginCategoryType =
{0x02020103, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020104-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UsageType =
{0x02020104, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020105-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ColorPrimariesType =
{0x02020105, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{02020106-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_CodingEquationsType =
{0x02020106, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Rational =
{0x03010100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ProductVersion =
{0x03010200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_VersionType =
{0x03010300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_RGBAComponent =
{0x03010400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DateStruct =
{0x03010500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TimeStruct =
{0x03010600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{03010700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TimeStamp =
{0x03010700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt8Array =
{0x04010100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt8Array12 =
{0x04010200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int32Array =
{0x04010300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Int64Array =
{0x04010400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_StringArray =
{0x04010500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_AUIDArray =
{0x04010600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PositionArray =
{0x04010700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt8Array8 =
{0x04010800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt32Array =
{0x04010900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ChannelStatusModeArray =
{0x04010a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04010b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UserDataModeArray =
{0x04010b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04020100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_RGBALayout =
{0x04020100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04030100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_AUIDSet =
{0x04030100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04030200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_UInt32Set =
{0x04030200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04100100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataValue =
{0x04100100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04100200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Stream =
{0x04100200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04100300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Indirect =
{0x04100300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{04100400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_Opaque =
{0x04100400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ClassDefinitionWeakReference =
{0x05010100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ContainerDefinitionWeakReference =
{0x05010200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataDefinitionWeakReference =
{0x05010300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_InterpolationDefinitionWeakReference =
{0x05010500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobWeakReference =
{0x05010600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationDefinitionWeakReference =
{0x05010700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterDefinitionWeakReference =
{0x05010800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TypeDefinitionWeakReference =
{0x05010900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PluginDefinitionWeakReference =
{0x05010a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_CodecDefinitionWeakReference =
{0x05010b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05010c00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PropertyDefinitionWeakReference =
{0x05010c00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ContentStorageStrongReference =
{0x05020100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DictionaryStrongReference =
{0x05020200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EssenceDescriptorStrongReference =
{0x05020300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_NetworkLocatorStrongReference =
{0x05020400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationGroupStrongReference =
{0x05020500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SegmentStrongReference =
{0x05020600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SourceClipStrongReference =
{0x05020700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SourceReferenceStrongReference =
{0x05020800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ClassDefinitionStrongReference =
{0x05020900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_CodecDefinitionStrongReference =
{0x05020a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ComponentStrongReference =
{0x05020b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020c00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ContainerDefinitionStrongReference =
{0x05020c00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020d00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ControlPointStrongReference =
{0x05020d00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020e00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataDefinitionStrongReference =
{0x05020e00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05020f00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EssenceDataStrongReference =
{0x05020f00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021000-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_IdentificationStrongReference =
{0x05021000, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_InterpolationDefinitionStrongReference =
{0x05021100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_LocatorStrongReference =
{0x05021200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobStrongReference =
{0x05021300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobSlotStrongReference =
{0x05021400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationDefinitionStrongReference =
{0x05021500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterStrongReference =
{0x05021600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterDefinitionStrongReference =
{0x05021700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PluginDefinitionStrongReference =
{0x05021800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PropertyDefinitionStrongReference =
{0x05021900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TaggedValueStrongReference =
{0x05021a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TypeDefinitionStrongReference =
{0x05021b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021c00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_KLVDataStrongReference =
{0x05021c00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021d00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_FileDescriptorStrongReference =
{0x05021d00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021e00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_RIFFChunkStrongReference =
{0x05021e00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05021f00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DescriptiveFrameworkStrongReference =
{0x05021f00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05022000-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_KLVDataDefinitionStrongReference =
{0x05022000, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05022100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TaggedValueDefinitionStrongReference =
{0x05022100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05022200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DescriptiveObjectStrongReference =
{0x05022200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05030d00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataDefinitionWeakReferenceSet =
{0x05030d00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05030e00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterDefinitionWeakReferenceSet =
{0x05030e00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05030f00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PluginDefinitionWeakReferenceSet =
{0x05030f00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05031000-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PropertyDefinitionWeakReferenceSet =
{0x05031000, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05040100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationDefinitionWeakReferenceVector =
{0x05040100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05040200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TypeDefinitionWeakReferenceVector =
{0x05040200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05040300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataDefinitionWeakReferenceVector =
{0x05040300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ClassDefinitionStrongReferenceSet =
{0x05050100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_CodecDefinitionStrongReferenceSet =
{0x05050200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ContainerDefinitionStrongReferenceSet =
{0x05050300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DataDefinitionStrongReferenceSet =
{0x05050400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_EssenceDataStrongReferenceSet =
{0x05050500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_InterpolationDefinitionStrongReferenceSet =
{0x05050600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobStrongReferenceSet =
{0x05050700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_OperationDefinitionStrongReferenceSet =
{0x05050800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterDefinitionStrongReferenceSet =
{0x05050900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PluginDefinitionStrongReferenceSet =
{0x05050a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_PropertyDefinitionStrongReferenceSet =
{0x05050b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050c00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TypeDefinitionStrongReferenceSet =
{0x05050c00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050d00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_KLVDataDefinitionStrongReferenceSet =
{0x05050d00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050e00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TaggedValueDefinitionStrongReferenceSet =
{0x05050e00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05050f00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DescriptiveObjectStrongReferenceSet =
{0x05050f00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060100-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ComponentStrongReferenceVector =
{0x05060100, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060200-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ControlPointStrongReferenceVector =
{0x05060200, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060300-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_IdentificationStrongReferenceVector =
{0x05060300, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060400-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_LocatorStrongReferenceVector =
{0x05060400, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060500-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_MobSlotStrongReferenceVector =
{0x05060500, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060600-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SegmentStrongReferenceVector =
{0x05060600, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060700-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_SourceReferenceStrongReferenceVector =
{0x05060700, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060800-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_TaggedValueStrongReferenceVector =
{0x05060800, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060900-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_KLVDataStrongReferenceVector =
{0x05060900, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060a00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_ParameterStrongReferenceVector =
{0x05060a00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060b00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_FileDescriptorStrongReferenceVector =
{0x05060b00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060c00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_RIFFChunkStrongReferenceVector =
{0x05060c00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};

//{05060d00-0000-0000-060e-2b3401040101}
static const aafUID_t AAFTypeID_DescriptiveObjectStrongReferenceVector =
{0x05060d00, 0x0000, 0x0000, {0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01}};



#endif // ! __AAFTypeDefUIDs_h__
