#include <iostream>
#include <cstdio>

using namespace std;

class xml_document {
    // Non-copyable semantics => functions private and not defined
    xml_document(const xml_document&);
    xml_document& operator=(const xml_document&);
public:
    xml_document() {}
    // Move semantics support
    xml_document& operator=(xml_document&& rhs);
};

xml_document& xml_document::operator=(xml_document&& rhs) {
    return *this; // just a dummy implementation
}

int main() {
  printf ("StdCxx11: Handling of language features introduced with C++11\n");
  printf ("=============================================================\n");
  xml_document d1, d2;
  d1 = static_cast<xml_document&&>(d2); // move semantics
  printf ("=============================================================\n");
}

aspect ExecTracer {
  advice execution ("% ...::%(...)" && !"% main(...)")  : before () {
    printf ("before %s\n", JoinPoint::signature ());
  }
  advice execution ("% ...::%(...)" && !"% main(...)")  : around () {
    tjp->proceed ();
    printf ("after %s\n", JoinPoint::signature ());
  }
};
