/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.FPUtilities;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.BitSet;

public class BitInputStream
extends InputStream
implements Closeable,
DataInput {
    private DataInputStream in;
    private int bitpos;
    private int bittmp;
    private long bitsread;
    private int markbitpos;
    private int markbittmp;
    private long markbitsread;

    public BitInputStream(InputStream in) {
        this.in = new DataInputStream(in);
        this.bitpos = 0;
        this.bittmp = 0;
        this.bitsread = 0L;
        this.markbitpos = 0;
        this.markbittmp = 0;
        this.markbitsread = 0L;
    }

    public boolean atBitBoundary(int multiple) {
        if (multiple < 0) {
            throw new IllegalArgumentException();
        }
        if (multiple == 0 || multiple == 1) {
            return true;
        }
        return this.bitsread % (long)multiple == 0L;
    }

    public boolean atByteBoundary(int multiple) {
        if (multiple < 0) {
            throw new IllegalArgumentException();
        }
        if (multiple == 0) {
            return true;
        }
        if (multiple == 1) {
            return this.bitpos == 0;
        }
        return this.bitpos == 0 && (this.bitsread >> 3) % (long)multiple == 0L;
    }

    public long bitsRead() {
        return this.bitsread;
    }

    public long bytesRead() {
        return this.bitsread >> 3;
    }

    public boolean readBit() throws IOException {
        if (this.bitpos == 0) {
            byte tmp = this.in.readByte();
            this.bitpos = 128;
            this.bittmp = tmp;
        }
        boolean res = (this.bittmp & this.bitpos) != 0;
        this.bitpos >>= 1;
        ++this.bitsread;
        return res;
    }

    public boolean skipBit() throws IOException {
        if (this.bitpos == 0) {
            int tmp = this.in.read();
            if (tmp < 0) {
                return false;
            }
            this.bitpos = 128;
            this.bittmp = tmp;
        }
        this.bitpos >>= 1;
        ++this.bitsread;
        return true;
    }

    public boolean availableBit() throws IOException {
        if (this.bitpos == 0) {
            return this.in.available() > 0;
        }
        return true;
    }

    public BitSet readBits(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new BitSet();
        }
        BitSet b = new BitSet();
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            b.set(n);
        }
        return b;
    }

    public BitSet readBitsLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new BitSet();
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int nb = (n >> 3) - 1;
        BitSet b = new BitSet();
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            b.set(n & 7 | nb - (n >> 3) << 3);
        }
        return b;
    }

    public long skipBits(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        long a = 0L;
        while (n > 0L && this.bitpos > 0) {
            if (this.skipBit()) {
                --n;
                ++a;
                continue;
            }
            return a;
        }
        if (n >= 8L) {
            long bs = this.in.skip(n >> 3);
            this.bitsread += bs << 3;
            n -= bs << 3;
            a += bs << 3;
        }
        while (n > 0L) {
            if (this.skipBit()) {
                --n;
                ++a;
                continue;
            }
            return a;
        }
        return a;
    }

    public long availableBits() throws IOException {
        int m = this.bitpos;
        int b = 0;
        while (m > 0) {
            m >>= 1;
            ++b;
        }
        return (long)b + ((long)this.in.available() << 3);
    }

    public BigInteger readInteger(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        BigInteger i = this.readBit() ? BigInteger.ONE.negate().shiftLeft(--n) : BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            i = i.setBit(n);
        }
        return i;
    }

    public BigInteger readIntegerLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int on = n;
        int nb = (n >> 3) - 1;
        BigInteger i = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            i = i.setBit(n & 7 | nb - (n >> 3) << 3);
        }
        if (i.testBit(on - 1)) {
            i = i.xor(BigInteger.ONE.negate().shiftLeft(on));
        }
        return i;
    }

    public BigInteger readUnsignedInteger(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        BigInteger i = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            i = i.setBit(n);
        }
        return i;
    }

    public BigInteger readUnsignedIntegerLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int nb = (n >> 3) - 1;
        BigInteger i = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            i = i.setBit(n & 7 | nb - (n >> 3) << 3);
        }
        return i;
    }

    public Number readFloat(int n, MathContext mc) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int s = FPUtilities.optimalSignWidth(n);
        int e = FPUtilities.optimalExponentWidth(n);
        int m = FPUtilities.optimalMantissaWidth(n);
        return this.readFloat(s, e, m, mc);
    }

    public Number readFloatLE(int n, MathContext mc) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int s = FPUtilities.optimalSignWidth(n);
        int e = FPUtilities.optimalExponentWidth(n);
        int m = FPUtilities.optimalMantissaWidth(n);
        return this.readFloatLE(s, e, m, mc);
    }

    public Number readFloat(int s, int e, int m, MathContext mc) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        int b = FPUtilities.optimalBias(e);
        return this.readFloat(s, e, m, b, mc);
    }

    public Number readFloatLE(int s, int e, int m, MathContext mc) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        int b = FPUtilities.optimalBias(e);
        return this.readFloatLE(s, e, m, b, mc);
    }

    public Number readFloat(int s, int e, int m, int b, MathContext mc) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger si = this.readUnsignedInteger(s);
        BigInteger ei = this.readUnsignedInteger(e);
        BigInteger mi = this.readUnsignedInteger(m);
        return FPUtilities.decodeFloat(si, ei, mi, s, e, m, b, mc);
    }

    public Number readFloatLE(int s, int e, int m, int b, MathContext mc) throws IOException {
        if (s < 0 || s > 1 || e < 0 || m < 0) {
            throw new IllegalArgumentException();
        }
        if (this.bitpos != 0 || (s + e + m & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        BigInteger i = this.readUnsignedIntegerLE(s + e + m);
        BigInteger[] ii = FPUtilities.splitFloat(i, s, e, m);
        return FPUtilities.decodeFloat(ii[0], ii[1], ii[2], s, e, m, b, mc);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markbitpos = this.bitpos;
        this.markbittmp = this.bittmp;
        this.markbitsread = this.bitsread;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.read();
            if (res >= 0) {
                this.bitsread += 8L;
            }
            return res;
        }
        int tmp = this.in.read();
        if (tmp >= 0) {
            int res = 0;
            int rpos = 128;
            while (this.bitpos > 0) {
                if ((this.bittmp & this.bitpos) != 0) {
                    res |= rpos;
                }
                rpos >>= 1;
                this.bitpos >>= 1;
                ++this.bitsread;
            }
            this.bitpos = 128;
            this.bittmp = tmp;
            while (rpos > 0) {
                if ((this.bittmp & this.bitpos) != 0) {
                    res |= rpos;
                }
                rpos >>= 1;
                this.bitpos >>= 1;
                ++this.bitsread;
            }
            return res;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.read(b);
            if (res >= 0) {
                this.bitsread += (long)res << 3;
            }
            return res;
        }
        int res = 0;
        int tmp = 0;
        while (res < b.length && (tmp = this.read()) >= 0) {
            b[res++] = (byte)tmp;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.read(b, off, len);
            if (res >= 0) {
                this.bitsread += (long)res << 3;
            }
            return res;
        }
        int res = 0;
        int tmp = 0;
        while (res < len && (tmp = this.read()) >= 0) {
            b[off++] = (byte)tmp;
            ++res;
        }
        return res;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.bitpos = this.markbitpos;
        this.bittmp = this.markbittmp;
        this.bitsread = this.markbitsread;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bitpos == 0) {
            long res = this.in.skip(n);
            if (res >= 0L) {
                this.bitsread += res << 3;
            }
            return res;
        }
        return this.skipBits(n << 3) >> 3;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (this.bitpos == 0) {
            this.in.readFully(b);
            this.bitsread += (long)b.length << 3;
        } else {
            int res = 0;
            while (res < b.length) {
                b[res++] = this.readByte();
            }
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.bitpos == 0) {
            this.in.readFully(b, off, len);
            this.bitsread += (long)len << 3;
        } else {
            int res = 0;
            while (res < len) {
                b[off++] = this.readByte();
                ++res;
            }
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.bitpos == 0) {
            boolean res = this.in.readBoolean();
            this.bitsread += 8L;
            return res;
        }
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bitpos == 0) {
            byte res = this.in.readByte();
            this.bitsread += 8L;
            return res;
        }
        byte tmp = this.in.readByte();
        byte res = 0;
        int rpos = 128;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (byte)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 128;
        this.bittmp = tmp;
        while (rpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (byte)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return res;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.readUnsignedByte();
            this.bitsread += 8L;
            return res;
        }
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.bitpos == 0) {
            short res = this.in.readShort();
            this.bitsread += 16L;
            return res;
        }
        short tmp = this.in.readShort();
        short res = 0;
        int rpos = 32768;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (short)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 32768;
        this.bittmp = tmp;
        while (rpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (short)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return res;
    }

    public short readShortLE() throws IOException {
        if (this.bitpos == 0) {
            short res = Short.reverseBytes(this.in.readShort());
            this.bitsread += 16L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.readUnsignedShort();
            this.bitsread += 16L;
            return res;
        }
        return this.readShort() & 0xFFFF;
    }

    public int readUnsignedShortLE() throws IOException {
        if (this.bitpos == 0) {
            int res = Integer.reverseBytes(this.in.readUnsignedShort()) >>> 16;
            this.bitsread += 16L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public char readChar() throws IOException {
        if (this.bitpos == 0) {
            char res = this.in.readChar();
            this.bitsread += 16L;
            return res;
        }
        char tmp = this.in.readChar();
        char res = '\u0000';
        int rpos = 32768;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (char)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 32768;
        this.bittmp = tmp;
        while (rpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res = (char)(res | rpos);
            }
            rpos >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return res;
    }

    public char readCharLE() throws IOException {
        if (this.bitpos == 0) {
            char res = Character.reverseBytes(this.in.readChar());
            this.bitsread += 16L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public int readInt() throws IOException {
        if (this.bitpos == 0) {
            int res = this.in.readInt();
            this.bitsread += 32L;
            return res;
        }
        int tmp = this.in.readInt();
        int res = 0;
        int rpos = Integer.MIN_VALUE;
        while (this.bitpos != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res |= rpos;
            }
            rpos >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        this.bitpos = Integer.MIN_VALUE;
        this.bittmp = tmp;
        while (rpos != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res |= rpos;
            }
            rpos >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        return res;
    }

    public int readIntLE() throws IOException {
        if (this.bitpos == 0) {
            int res = Integer.reverseBytes(this.in.readInt());
            this.bitsread += 32L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public long readLong() throws IOException {
        if (this.bitpos == 0) {
            long res = this.in.readLong();
            this.bitsread += 64L;
            return res;
        }
        long tmp = this.in.readLong();
        long res = 0L;
        long rpos = Long.MIN_VALUE;
        while (this.bitpos != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                res |= rpos;
            }
            rpos >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        long bitpos = Long.MIN_VALUE;
        long bittmp = tmp;
        while (rpos != 0L) {
            if ((bittmp & bitpos) != 0L) {
                res |= rpos;
            }
            rpos >>>= 1;
            bitpos >>>= 1;
            ++this.bitsread;
        }
        this.bitpos = (int)bitpos;
        this.bittmp = (int)bittmp;
        return res;
    }

    public long readLongLE() throws IOException {
        if (this.bitpos == 0) {
            long res = Long.reverseBytes(this.in.readLong());
            this.bitsread += 64L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public float readFloat() throws IOException {
        if (this.bitpos == 0) {
            float res = this.in.readFloat();
            this.bitsread += 32L;
            return res;
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloatLE() throws IOException {
        if (this.bitpos == 0) {
            float res = Float.intBitsToFloat(Integer.reverseBytes(this.in.readInt()));
            this.bitsread += 32L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public double readDouble() throws IOException {
        if (this.bitpos == 0) {
            double res = this.in.readDouble();
            this.bitsread += 64L;
            return res;
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDoubleLE() throws IOException {
        if (this.bitpos == 0) {
            double res = Double.longBitsToDouble(Long.reverseBytes(this.in.readLong()));
            this.bitsread += 64L;
            return res;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

