/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * measurement/SucroseConversion.cpp is part of Brewtarget, and is copyright the following authors 2022-2023:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#include "measurement/SucroseConversion.h"

#include <array>

//
// These 801 rows of data come from the 1970 United States Department of Agriculture (USDA)
// Sucrose Conversion Table (File Code 135-A-50 in January 1981) at
// https://usermanual.wiki/Document/DetailedBrixChart.1345778913.pdf
//
// The document says it was compiled by the "Processed Products Branch, Fruit and Vegetable Division, Agricultural
// Marketing Service, United States Department of Agriculture" from the following two sources:
//   - Refractive Indices of Sucrose Solutions at 20°C (International Scale, 1936) as presented in the 10th
//     Edition of the Methods of Analysis of the Association of Agricultural (now "Analytical") Chemist (AOAC)
//     1965
//   - US National Bureau of Standards Circular C457
//
// I see no evidence of anyone claiming copyright on the data, so it feels safe to assume that it is free to use.
//
// The PDF is not in a great format, but, with a bit of effort, I managed to extract the data and knock it into
// usable shape.  (I also pasted the data into a spreadsheet and did a scatter plot.  When you look at the outliers,
// you find some obvious typos in the original document.  I have corrected these, as noted in the comments below.
// Usually looking at the lines before and after makes it reasonably obvious what the typo was.  In a couple of places
// there are minor discrepancies where it is not 100% obviously a typo.  These I have merely noted.)
//
// .:TBD:. There may be some more elegant way to do this, perhaps when we move to C++20, but an array was the only way
//         I found to avoid copying this data on to the heap (which would be unnecessary since it's const and known at
//         compile time).
//
Measurement::SucroseConversion const Measurement::sucroseConversions[] = {
   // Refractive Index at 20°C  ||  % sucrose or degree Brix  ||  Apparent specific gravity @ 20/20 °C
   {  1.3330,                       0.0,                          1.00000  },
   {  1.3331,                       0.1,                          1.00039  }, // The PDF has this as 0.0 Brix, but I think that's clearly a typo
   {  1.3333,                       0.2,                          1.00078  },
   {  1.3334,                       0.3,                          1.00117  },
   {  1.3336,                       0.4,                          1.00156  },
   {  1.3337,                       0.5,                          1.00194  },
   {  1.3339,                       0.6,                          1.00233  },
   {  1.3340,                       0.7,                          1.00272  },
   {  1.3341,                       0.8,                          1.00312  },
   {  1.3343,                       0.9,                          1.00351  },
   {  1.3344,                       1.0,                          1.00390  },
   {  1.3346,                       1.1,                          1.00429  },
   {  1.3347,                       1.2,                          1.00468  },
   {  1.3349,                       1.3,                          1.00507  },
   {  1.3350,                       1.4,                          1.00546  },
   {  1.3352,                       1.5,                          1.00585  },
   {  1.3353,                       1.6,                          1.00624  },
   {  1.3354,                       1.7,                          1.00663  },
   {  1.3356,                       1.8,                          1.00702  },
   {  1.3357,                       1.9,                          1.00741  },
   {  1.3359,                       2.0,                          1.00780  },
   {  1.3360,                       2.1,                          1.00819  },
   {  1.3362,                       2.2,                          1.00859  },
   {  1.3363,                       2.3,                          1.00898  },
   {  1.3365,                       2.4,                          1.00937  },
   {  1.3366,                       2.5,                          1.00977  }, // From plotting the data, 1.00976 would be a better fit here
   {  1.3368,                       2.6,                          1.01016  },
   {  1.3369,                       2.7,                          1.01055  },
   {  1.3370,                       2.8,                          1.01094  },
   {  1.3372,                       2.9,                          1.01134  },
   {  1.3373,                       3.0,                          1.01173  },
   {  1.3375,                       3.1,                          1.01213  },
   {  1.3376,                       3.2,                          1.01252  },
   {  1.3377,                       3.3,                          1.01292  },
   {  1.3379,                       3.4,                          1.01331  },
   {  1.3380,                       3.5,                          1.01371  },
   {  1.3382,                       3.6,                          1.01410  },
   {  1.3383,                       3.7,                          1.01450  },
   {  1.3385,                       3.8,                          1.01490  },
   {  1.3386,                       3.9,                          1.01529  },
   {  1.3388,                       4.0,                          1.01569  },
   {  1.3389,                       4.1,                          1.01609  },
   {  1.3391,                       4.2,                          1.01649  },
   {  1.3392,                       4.3,                          1.01688  },
   {  1.3394,                       4.4,                          1.01728  },
   {  1.3395,                       4.5,                          1.01768  },
   {  1.3397,                       4.6,                          1.01808  },
   {  1.3398,                       4.7,                          1.01848  },
   {  1.3400,                       4.8,                          1.01888  },
   {  1.3401,                       4.9,                          1.01928  },
   {  1.3402,                       5.0,                          1.01968  },
   {  1.3404,                       5.1,                          1.02008  },
   {  1.3405,                       5.2,                          1.02048  },
   {  1.3407,                       5.3,                          1.02088  },
   {  1.3408,                       5.4,                          1.02128  },
   {  1.3410,                       5.5,                          1.02168  },
   {  1.3411,                       5.6,                          1.02208  },
   {  1.3413,                       5.7,                          1.02248  },
   {  1.3414,                       5.8,                          1.02289  },
   {  1.3416,                       5.9,                          1.02329  },
   {  1.3417,                       6.0,                          1.02369  },
   {  1.3419,                       6.1,                          1.02409  },
   {  1.3420,                       6.2,                          1.02450  },
   {  1.3422,                       6.3,                          1.02490  },
   {  1.3423,                       6.4,                          1.02530  },
   {  1.3425,                       6.5,                          1.02571  },
   {  1.3426,                       6.6,                          1.02611  },
   {  1.3428,                       6.7,                          1.02652  },
   {  1.3429,                       6.8,                          1.02692  },
   {  1.3431,                       6.9,                          1.02733  },
   {  1.3432,                       7.0,                          1.02773  },
   {  1.3434,                       7.1,                          1.02814  },
   {  1.3435,                       7.2,                          1.02854  },
   {  1.3437,                       7.3,                          1.02895  },
   {  1.3438,                       7.4,                          1.02936  },
   {  1.3440,                       7.5,                          1.02976  },
   {  1.3441,                       7.6,                          1.03017  },
   {  1.3443,                       7.7,                          1.03058  },
   {  1.3444,                       7.8,                          1.03098  },
   {  1.3446,                       7.9,                          1.03139  },
   {  1.3447,                       8.0,                          1.03180  },
   {  1.3449,                       8.1,                          1.03221  },
   {  1.3450,                       8.2,                          1.03262  },
   {  1.3452,                       8.3,                          1.03303  },
   {  1.3454,                       8.4,                          1.03344  },
   {  1.3455,                       8.5,                          1.03385  },
   {  1.3457,                       8.6,                          1.03426  },
   {  1.3459,                       8.7,                          1.03467  },
   {  1.3460,                       8.8,                          1.03508  },
   {  1.3461,                       8.9,                          1.03549  },
   {  1.3463,                       9.0,                          1.03590  },
   {  1.3464,                       9.1,                          1.03631  },
   {  1.3466,                       9.2,                          1.03672  },
   {  1.3467,                       9.3,                          1.03713  },
   {  1.3469,                       9.4,                          1.03755  },
   {  1.3470,                       9.5,                          1.03796  },
   {  1.3472,                       9.6,                          1.03837  },
   {  1.3473,                       9.7,                          1.03879  },
   {  1.3475,                       9.8,                          1.03920  },
   {  1.3476,                       9.9,                          1.03961  },
   {  1.3478,                      10.0,                          1.04003  },
   {  1.3480,                      10.1,                          1.04044  },
   {  1.3481,                      10.2,                          1.04086  },
   {  1.3483,                      10.3,                          1.04127  },
   {  1.3484,                      10.4,                          1.04169  },
   {  1.3486,                      10.5,                          1.04210  },
   {  1.3487,                      10.6,                          1.04252  },
   {  1.3489,                      10.7,                          1.04293  },
   {  1.3490,                      10.8,                          1.04335  },
   {  1.3492,                      10.9,                          1.04377  },
   {  1.3493,                      11.0,                          1.04418  },
   {  1.3495,                      11.1,                          1.04460  },
   {  1.3497,                      11.2,                          1.04502  },
   {  1.3498,                      11.3,                          1.04544  },
   {  1.3500,                      11.4,                          1.04585  },
   {  1.3501,                      11.5,                          1.04627  },
   {  1.3503,                      11.6,                          1.04669  },
   {  1.3504,                      11.7,                          1.04711  },
   {  1.3506,                      11.8,                          1.04753  },
   {  1.3507,                      11.9,                          1.04795  },
   {  1.3509,                      12.0,                          1.04837  }, // The PDF has the SG as 1.4837, but I think that's clearly a typo
   {  1.3511,                      12.1,                          1.04879  }, // The PDF has the SG as 1.4839, but I think that's clearly a typo
   {  1.3512,                      12.2,                          1.04921  },
   {  1.3514,                      12.3,                          1.04963  },
   {  1.3515,                      12.4,                          1.05005  },
   {  1.3517,                      12.5,                          1.05047  },
   {  1.3518,                      12.6,                          1.05090  },
   {  1.3520,                      12.7,                          1.05132  },
   {  1.3522,                      12.8,                          1.05174  },
   {  1.3523,                      12.9,                          1.05216  },
   {  1.3525,                      13.0,                          1.05259  },
   {  1.3626,                      13.1,                          1.05301  },
   {  1.3528,                      13.2,                          1.05343  },
   {  1.3529,                      13.3,                          1.05386  },
   {  1.3531,                      13.4,                          1.05428  },
   {  1.3533,                      13.5,                          1.05470  },
   {  1.3534,                      13.6,                          1.05513  },
   {  1.3536,                      13.7,                          1.05556  },
   {  1.3537,                      13.8,                          1.05598  },
   {  1.3539,                      13.9,                          1.05641  },
   {  1.3541,                      14.0,                          1.05683  },
   {  1.3542,                      14.1,                          1.05726  },
   {  1.3544,                      14.2,                          1.05769  },
   {  1.3545,                      14.3,                          1.05811  },
   {  1.3447,                      14.4,                          1.05854  },
   {  1.3548,                      14.5,                          1.05897  },
   {  1.3550,                      14.6,                          1.05940  },
   {  1.3552,                      14.7,                          1.05982  },
   {  1.3553,                      14.8,                          1.06025  },
   {  1.3555,                      14.9,                          1.06068  },
   {  1.3556,                      15.0,                          1.06111  },
   {  1.3558,                      15.1,                          1.06154  },
   {  1.3560,                      15.2,                          1.06197  },
   {  1.3561,                      15.3,                          1.06240  },
   {  1.3563,                      15.4,                          1.06283  },
   {  1.3564,                      15.5,                          1.06326  },
   {  1.3566,                      15.6,                          1.06369  },
   {  1.3567,                      15.7,                          1.06412  },
   {  1.3569,                      15.8,                          1.06455  },
   {  1.3571,                      15.9,                          1.06499  },
   {  1.3573,                      16.0,                          1.06542  },
   {  1.3574,                      16.1,                          1.06585  },
   {  1.3576,                      16.2,                          1.06629  },
   {  1.3577,                      16.3,                          1.06672  },
   {  1.3579,                      16.4,                          1.06715  },
   {  1.3581,                      16.5,                          1.06759  },
   {  1.3582,                      16.6,                          1.06802  },
   {  1.3584,                      16.7,                          1.06845  },
   {  1.3586,                      16.8,                          1.06889  },
   {  1.3587,                      16.9,                          1.06933  },
   {  1.3589,                      17.0,                          1.06976  },
   {  1.3591,                      17.1,                          1.07020  },
   {  1.3592,                      17.2,                          1.07063  },
   {  1.3594,                      17.3,                          1.07107  },
   {  1.3595,                      17.4,                          1.07151  },
   {  1.3597,                      17.5,                          1.07194  },
   {  1.3598,                      17.6,                          1.07238  },
   {  1.3600,                      17.7,                          1.07282  },
   {  1.3602,                      17.8,                          1.07325  },
   {  1.3603,                      17.9,                          1.07369  },
   {  1.3605,                      18.0,                          1.07413  },
   {  1.3607,                      18.1,                          1.07457  },
   {  1.3608,                      18.2,                          1.07501  },
   {  1.3610,                      18.3,                          1.07545  },
   {  1.3612,                      18.4,                          1.07589  },
   {  1.3613,                      18.5,                          1.07633  },
   {  1.3615,                      18.6,                          1.07677  },
   {  1.3617,                      18.7,                          1.07721  },
   {  1.3618,                      18.8,                          1.07765  },
   {  1.3620,                      18.9,                          1.07809  },
   {  1.3621,                      19.0,                          1.07853  },
   {  1.3623,                      19.1,                          1.07898  },
   {  1.3625,                      19.2,                          1.07942  },
   {  1.3626,                      19.3,                          1.07986  },
   {  1.3628,                      19.4,                          1.08030  },
   {  1.3630,                      19.5,                          1.08075  },
   {  1.3631,                      19.6,                          1.08119  },
   {  1.3633,                      19.7,                          1.08164  },
   {  1.3635,                      19.8,                          1.08208  },
   {  1.3636,                      19.9,                          1.08252  },
   {  1.3638,                      20.0,                          1.08297  },
   {  1.3640,                      20.1,                          1.08342  },
   {  1.3641,                      20.2,                          1.08386  },
   {  1.3643,                      20.3,                          1.08431  },
   {  1.3645,                      20.4,                          1.08475  },  // The PDF has the SG as 1.9475, but I think that's clearly a typo
   {  1.3646,                      20.5,                          1.08520  },
   {  1.3648,                      20.6,                          1.08565  },
   {  1.3650,                      20.7,                          1.08609  },
   {  1.3651,                      20.8,                          1.08654  },
   {  1.3653,                      20.9,                          1.08699  },
   {  1.3655,                      21.0,                          1.08744  },
   {  1.3656,                      21.1,                          1.08789  },
   {  1.3658,                      21.2,                          1.08834  },
   {  1.3660,                      21.3,                          1.08879  },
   {  1.3661,                      21.4,                          1.08923  },
   {  1.3663,                      21.5,                          1.08968  },
   {  1.3665,                      21.6,                          1.09013  },
   {  1.3667,                      21.7,                          1.09058  },
   {  1.3668,                      21.8,                          1.09103  },
   {  1.3670,                      21.9,                          1.09149  },
   {  1.3672,                      22.0,                          1.09194  },
   {  1.3673,                      22.1,                          1.09239  },
   {  1.3675,                      22.2,                          1.09284  },
   {  1.3677,                      22.3,                          1.09329  },
   {  1.3678,                      22.4,                          1.09375  },
   {  1.3680,                      22.5,                          1.09420  },
   {  1.3682,                      22.6,                          1.09465  },
   {  1.3683,                      22.7,                          1.09511  },
   {  1.3685,                      22.8,                          1.09556  },
   {  1.3687,                      22.9,                          1.09602  },
   {  1.3688,                      23.0,                          1.09647  },
   {  1.3690,                      23.1,                          1.09693  },
   {  1.3692,                      23.2,                          1.09738  },
   {  1.3694,                      23.3,                          1.09784  },
   {  1.3695,                      23.4,                          1.09829  },
   {  1.3697,                      23.5,                          1.09875  },
   {  1.3699,                      23.6,                          1.09921  },
   {  1.3700,                      23.7,                          1.09966  },
   {  1.3702,                      23.8,                          1.10012  }, // The PDF has the SG as 1.010012, but I think that's clearly a typo
   {  1.3704,                      23.9,                          1.10058  },
   {  1.3706,                      24.0,                          1.10104  },
   {  1.3707,                      24.1,                          1.10149  },
   {  1.3709,                      24.2,                          1.10195  }, // The PDF has the SG as 1.20295, but I think that's clearly a typo
   {  1.3711,                      24.3,                          1.10241  },
   {  1.3712,                      24.4,                          1.10287  },
   {  1.3714,                      24.5,                          1.10333  },
   {  1.3716,                      24.6,                          1.10379  },  // The PDF has the SG as 1.10370, but, from plotting the data, I think that's a typo
   {  1.3718,                      24.7,                          1.10425  },
   {  1.3719,                      24.8,                          1.10471  },
   {  1.3721,                      24.9,                          1.10517  },
   {  1.3723,                      25.0,                          1.10564  },
   {  1.3724,                      25.1,                          1.10610  },
   {  1.3726,                      25.2,                          1.10656  }, // The PDF has the SG as 1.01656, but I think that's clearly a typo
   {  1.3728,                      25.3,                          1.10702  },
   {  1.3729,                      25.4,                          1.10748  },
   {  1.3731,                      25.5,                          1.10795  },
   {  1.3733,                      25.6,                          1.10841  },
   {  1.3735,                      25.7,                          1.10887  },
   {  1.3736,                      25.8,                          1.10934  },
   {  1.3738,                      25.9,                          1.10980  },
   {  1.3740,                      26.0,                          1.11027  },
   {  1.3741,                      26.1,                          1.11073  },
   {  1.3743,                      26.2,                          1.11120  },
   {  1.3745,                      26.3,                          1.11166  },
   {  1.3747,                      26.4,                          1.11213  },
   {  1.3748,                      26.5,                          1.11260  },
   {  1.3750,                      26.6,                          1.11306  },
   {  1.3752,                      26.7,                          1.11353  },
   {  1.3753,                      26.8,                          1.11400  },
   {  1.3755,                      26.9,                          1.11447  },
   {  1.3757,                      27.0,                          1.11493  },
   {  1.3759,                      27.1,                          1.11540  },
   {  1.3761,                      27.2,                          1.11587  },
   {  1.3762,                      27.3,                          1.11634  },
   {  1.3764,                      27.4,                          1.11681  },
   {  1.3766,                      27.5,                          1.11728  },
   {  1.3768,                      27.6,                          1.11775  },
   {  1.3769,                      27.7,                          1.11822  },
   {  1.3771,                      27.8,                          1.11869  },
   {  1.3773,                      27.9,                          1.11916  },
   {  1.3775,                      28.0,                          1.11963  },
   {  1.3777,                      28.1,                          1.12010  },
   {  1.3778,                      28.2,                          1.12058  },
   {  1.3780,                      28.3,                          1.12105  },
   {  1.3782,                      28.4,                          1.12152  },
   {  1.3784,                      28.5,                          1.12199  },
   {  1.3785,                      28.6,                          1.12247  },
   {  1.3787,                      28.7,                          1.12294  },
   {  1.3789,                      28.8,                          1.12342  },
   {  1.3791,                      28.9,                          1.12389  },
   {  1.3792,                      29.0,                          1.12436  },
   {  1.3794,                      29.1,                          1.12484  },
   {  1.3796,                      29.2,                          1.12532  },
   {  1.3798,                      29.3,                          1.12579  },
   {  1.3800,                      29.4,                          1.12627  },
   {  1.3801,                      29.5,                          1.12674  },
   {  1.3803,                      29.6,                          1.12722  },
   {  1.3805,                      29.7,                          1.12770  },
   {  1.3807,                      29.8,                          1.12817  },
   {  1.3809,                      29.9,                          1.12865  },
   {  1.3810,                      30.0,                          1.12913  },
   {  1.3812,                      30.1,                          1.12961  },
   {  1.3814,                      30.2,                          1.13009  },
   {  1.3816,                      30.3,                          1.13057  },
   {  1.3818,                      30.4,                          1.13105  },
   {  1.3820,                      30.5,                          1.13153  },
   {  1.3821,                      30.6,                          1.13201  },
   {  1.3823,                      30.7,                          1.13249  },
   {  1.3825,                      30.8,                          1.13297  },
   {  1.3827,                      30.9,                          1.13345  },
   {  1.3829,                      31.0,                          1.13394  },
   {  1.3830,                      31.1,                          1.13442  },
   {  1.3832,                      31.2,                          1.13490  },
   {  1.3834,                      31.3,                          1.13538  },
   {  1.3836,                      31.4,                          1.13587  },
   {  1.3838,                      31.5,                          1.13635  },
   {  1.3839,                      31.6,                          1.13683  },
   {  1.3841,                      31.7,                          1.13732  },
   {  1.3843,                      31.8,                          1.13780  },
   {  1.3845,                      31.9,                          1.13829  },
   {  1.3847,                      32.0,                          1.13877  },
   {  1.3848,                      32.1,                          1.13926  },
   {  1.3850,                      32.2,                          1.13974  },
   {  1.3852,                      32.3,                          1.14023  },
   {  1.3854,                      32.4,                          1.14072  },
   {  1.3856,                      32.5,                          1.14120  },
   {  1.3858,                      32.6,                          1.14169  },
   {  1.3860,                      32.7,                          1.14218  },
   {  1.3861,                      32.8,                          1.14267  },
   {  1.3863,                      32.9,                          1.14316  },
   {  1.3865,                      33.0,                          1.14364  },
   {  1.3867,                      33.1,                          1.14413  },
   {  1.3869,                      33.2,                          1.14462  },
   {  1.3871,                      33.3,                          1.14511  },
   {  1.3872,                      33.4,                          1.14560  },
   {  1.3874,                      33.5,                          1.14609  },
   {  1.3876,                      33.6,                          1.14658  },
   {  1.3878,                      33.7,                          1.14708  },
   {  1.3879,                      33.8,                          1.14757  },
   {  1.3881,                      33.9,                          1.14806  },
   {  1.3883,                      34.0,                          1.14855  },
   {  1.3885,                      34.1,                          1.14904  },
   {  1.3887,                      34.2,                          1.14954  },
   {  1.3889,                      34.3,                          1.15003  },
   {  1.3891,                      34.4,                          1.15052  },
   {  1.3893,                      34.5,                          1.15102  },
   {  1.3894,                      34.6,                          1.15151  },
   {  1.3896,                      34.7,                          1.15201  },
   {  1.3898,                      34.8,                          1.15250  },
   {  1.3900,                      34.9,                          1.15300  },
   {  1.13902,                     35.0,                          1.15350  },
   {  1.3904,                      35.1,                          1.15399  },
   {  1.3906,                      35.2,                          1.15449  },
   {  1.3908,                      35.3,                          1.15498  },
   {  1.3909,                      35.4,                          1.15548  },
   {  1.13911,                     35.5,                          1.15598  },
   {  1.3913,                      35.6,                          1.15648  },
   {  1.3915,                      35.7,                          1.15698  },
   {  1.3916,                      35.8,                          1.15747  },
   {  1.3918,                      35.9,                          1.15797  },
   {  1.13920,                     36.0,                          1.15847  },
   {  1.3922,                      36.1,                          1.15897  },
   {  1.3924,                      36.2,                          1.15947  },
   {  1.3926,                      36.3,                          1.15997  },
   {  1.3928,                      36.4,                          1.16047  },
   {  1.3930,                      36.5,                          1.16098  },
   {  1.3931,                      36.6,                          1.16148  },
   {  1.3933,                      36.7,                          1.16198  },
   {  1.3935,                      36.8,                          1.16248  },
   {  1.3937,                      36.9,                          1.16298  },
   {  1.3939,                      37.0,                          1.16349  },
   {  1.3941,                      37.1,                          1.16399  },
   {  1.3943,                      37.2,                          1.16449  },
   {  1.3945,                      37.3,                          1.16500  },
   {  1.3947,                      37.4,                          1.16550  },
   {  1.3949,                      37.5,                          1.16601  },
   {  1.3950,                      37.6,                          1.16652  },
   {  1.3952,                      37.7,                          1.16702  },
   {  1.3954,                      37.8,                          1.16752  },
   {  1.3956,                      37.9,                          1.16803  },
   {  1.3958,                      38.0,                          1.16853  },
   {  1.3960,                      38.1,                          1.16904  },
   {  1.3962,                      38.2,                          1.16955  },
   {  1.3964,                      38.3,                          1.17006  },
   {  1.3966,                      38.4,                          1.17056  },
   {  1.3968,                      38.5,                          1.17107  },
   {  1.3970,                      38.6,                          1.17158  },
   {  1.3972,                      38.7,                          1.17209  },
   {  1.37974,                     38.8,                          1.17260  },
   {  1.3976,                      38.9,                          1.17311  },
   {  1.3978,                      39.0,                          1.17362  },
   {  1.3980,                      39.1,                          1.17413  },
   {  1.3982,                      39.2,                          1.17464  },
   {  1.3984,                      39.3,                          1.17515  },
   {  1.3986,                      39.4,                          1.17566  },
   {  1.3988,                      39.5,                          1.17618  },
   {  1.3989,                      39.6,                          1.17669  },
   {  1.3991,                      39.7,                          1.17720  },
   {  1.3993,                      39.8,                          1.17772  },
   {  1.3995,                      39.9,                          1.17823  },
   {  1.3997,                      40.0,                          1.17874  },
   {  1.3999,                      40.1,                          1.17926  },
   {  1.4001,                      40.2,                          1.17977  },
   {  1.4003,                      40.3,                          1.18029  },
   {  1.4005,                      40.4,                          1.18080  },
   {  1.4007,                      40.5,                          1.18132  },
   {  1.4008,                      40.6,                          1.18183  },
   {  1.4010,                      40.7,                          1.18235  },
   {  1.4012,                      40.8,                          1.18287  },
   {  1.4014,                      40.9,                          1.18339  },
   {  1.4016,                      41.0,                          1.18390  },
   {  1.4018,                      41.1,                          1.18442  },
   {  1.4020,                      41.2,                          1.18494  },
   {  1.4022,                      41.3,                          1.18546  },
   {  1.4024,                      41.4,                          1.18598  },
   {  1.4026,                      41.5,                          1.18650  },
   {  1.4028,                      41.6,                          1.18702  },
   {  1.4030,                      41.7,                          1.18754  },
   {  1.4032,                      41.8,                          1.18806  },
   {  1.4034,                      41.9,                          1.18858  },
   {  1.4036,                      42.0,                          1.18910  },
   {  1.4038,                      42.1,                          1.18962  },
   {  1.4040,                      42.2,                          1.19014  },
   {  1.4042,                      42.3,                          1.19062  },
   {  1.4044,                      42.4,                          1.19119  },
   {  1.4046,                      42.5,                          1.19171  },
   {  1.4048,                      42.6,                          1.19224  },
   {  1.4050,                      42.7,                          1.19276  },
   {  1.4052,                      42.8,                          1.19329  },
   {  1.4054,                      42.9,                          1.19381  },
   {  1.4056,                      43.0,                          1.19434  },
   {  1.4058,                      43.1,                          1.19486  },
   {  1.4060,                      43.2,                          1.19539  },
   {  1.4062,                      43.3,                          1.19591  },
   {  1.4064,                      43.4,                          1.19644  },
   {  1.4066,                      43.5,                          1.19697  },
   {  1.4068,                      43.6,                          1.19749  },
   {  1.4070,                      43.7,                          1.19802  },
   {  1.4072,                      43.8,                          1.19855  },
   {  1.4074,                      43.9,                          1.19908  },
   {  1.4076,                      44.0,                          1.19961  },
   {  1.4078,                      44.1,                          1.20013  },
   {  1.4080,                      44.2,                          1.20066  },
   {  1.4082,                      44.3,                          1.20119  },
   {  1.4084,                      44.4,                          1.20172  },
   {  1.4086,                      44.5,                          1.20226  },
   {  1.4088,                      44.6,                          1.20279  },
   {  1.4090,                      44.7,                          1.20332  },
   {  1.4092,                      44.8,                          1.20385  },
   {  1.4094,                      44.9,                          1.20438  },
   {  1.4096,                      45.0,                          1.20491  },
   {  1.4098,                      45.1,                          1.20545  },
   {  1.4100,                      45.2,                          1.20598  },
   {  1.4102,                      45.3,                          1.20651  },
   {  1.4104,                      45.4,                          1.20705  },
   {  1.4107,                      45.5,                          1.20758  },
   {  1.4109,                      45.6,                          1.20812  },
   {  1.4111,                      45.7,                          1.20865  },
   {  1.4113,                      45.8,                          1.20919  },
   {  1.4115,                      45.9,                          1.20972  },
   {  1.4117,                      46.0,                          1.21026  },
   {  1.4119,                      46.1,                          1.21080  },
   {  1.4121,                      46.2,                          1.21133  },
   {  1.4123,                      46.3,                          1.21187  }, // The PDF has the SG as 1.31187, but I think that's clearly a typo
   {  1.4125,                      46.4,                          1.21241  },
   {  1.4127,                      46.5,                          1.21295  },
   {  1.4129,                      46.6,                          1.21349  },
   {  1.4131,                      46.7,                          1.21402  },
   {  1.4133,                      46.8,                          1.21456  },
   {  1.4135,                      46.9,                          1.21510  },
   {  1.4137,                      47.0,                          1.21564  },
   {  1.4139,                      47.1,                          1.21618  },
   {  1.4141,                      47.2,                          1.21673  },
   {  1.4143,                      47.3,                          1.21727  },
   {  1.4145,                      47.4,                          1.21781  },
   {  1.4148,                      47.5,                          1.21835  },
   {  1.4150,                      47.6,                          1.21889  },
   {  1.4152,                      47.7,                          1.21943  },
   {  1.4154,                      47.8,                          1.21998  },
   {  1.4156,                      47.9,                          1.22052  },
   {  1.4158,                      48.0,                          1.22106  },
   {  1.4160,                      48.1,                          1.22161  },
   {  1.4162,                      48.2,                          1.22215  },
   {  1.4164,                      48.3,                          1.22270  },
   {  1.4166,                      48.4,                          1.22324  },
   {  1.4169,                      48.5,                          1.22379  },
   {  1.4171,                      48.6,                          1.22434  },
   {  1.4173,                      48.7,                          1.22488  },
   {  1.4175,                      48.8,                          1.22543  },
   {  1.4177,                      48.9,                          1.22598  },
   {  1.4179,                      49.0,                          1.22652  },
   {  1.4181,                      49.1,                          1.22707  },
   {  1.4183,                      49.2,                          1.22762  },
   {  1.4185,                      49.3,                          1.22817  },
   {  1.4187,                      49.4,                          1.22872  },
   {  1.4190,                      49.5,                          1.22927  },
   {  1.4192,                      49.6,                          1.22982  },
   {  1.4194,                      49.7,                          1.23037  },
   {  1.4196,                      49.8,                          1.23092  },
   {  1.4199,                      49.9,                          1.23147  },
   {  1.4201,                      50.0,                          1.23202  },
   {  1.4203,                      50.1,                          1.23257  },
   {  1.4205,                      50.2,                          1.23313  },
   {  1.4207,                      50.3,                          1.23368  },
   {  1.4209,                      50.4,                          1.23423  },
   {  1.4212,                      50.5,                          1.23478  },
   {  1.4214,                      50.6,                          1.23534  },
   {  1.4216,                      50.7,                          1.23589  },
   {  1.4218,                      50.8,                          1.23645  },
   {  1.4220,                      50.9,                          1.23700  },
   {  1.4222,                      51.0,                          1.23756  },
   {  1.4224,                      51.1,                          1.23811  },
   {  1.4226,                      51.2,                          1.23867  },
   {  1.4228,                      51.3,                          1.23922  },
   {  1.4230,                      51.4,                          1.23978  },
   {  1.4233,                      51.5,                          1.24034  },
   {  1.4235,                      51.6,                          1.24089  },
   {  1.4237,                      51.7,                          1.24145  },
   {  1.4239,                      51.8,                          1.24201  },
   {  1.4241,                      51.9,                          1.24257  },
   {  1.4243,                      52.0,                          1.24313  },
   {  1.4245,                      52.1,                          1.24369  },
   {  1.4248,                      52.2,                          1.24425  },
   {  1.4250,                      52.3,                          1.24481  },
   {  1.4252,                      52.4,                          1.24537  },
   {  1.4254,                      52.5,                          1.24593  },
   {  1.4256,                      52.6,                          1.24649  },
   {  1.4248,                      52.7,                          1.24705  },
   {  1.4260,                      52.8,                          1.24761  },
   {  1.4262,                      52.9,                          1.24818  },
   {  1.4265,                      53.0,                          1.24874  },
   {  1.4267,                      53.1,                          1.24930  },
   {  1.4269,                      53.2,                          1.24987  },
   {  1.4271,                      53.3,                          1.25043  },
   {  1.4273,                      53.4,                          1.25099  },
   {  1.4275,                      53.5,                          1.25156  },
   {  1.4278,                      53.6,                          1.25212  },
   {  1.4280,                      53.7,                          1.25269  },
   {  1.4282,                      53.8,                          1.25325  },
   {  1.4284,                      53.9,                          1.25382  },
   {  1.4286,                      54.0,                          1.25439  },
   {  1.4288,                      54.1,                          1.25495  },
   {  1.4291,                      54.2,                          1.25552  },
   {  1.4293,                      54.3,                          1.25609  },
   {  1.4295,                      54.4,                          1.25666  },
   {  1.4297,                      54.5,                          1.25723  },
   {  1.4299,                      54.6,                          1.25780  },
   {  1.4301,                      54.7,                          1.25836  },
   {  1.4304,                      54.8,                          1.25893  },
   {  1.4306,                      54.9,                          1.25950  },
   {  1.4308,                      55.0,                          1.26007  },
   {  1.4310,                      55.1,                          1.26064  },
   {  1.4312,                      55.2,                          1.26122  },
   {  1.4315,                      55.3,                          1.26179  },
   {  1.4317,                      55.4,                          1.26236  },
   {  1.4319,                      55.5,                          1.26293  },
   {  1.4321,                      55.6,                          1.26350  },
   {  1.4323,                      55.7,                          1.26408  },
   {  1.4326,                      55.8,                          1.26465  },
   {  1.4328,                      55.9,                          1.26522  },
   {  1.4330,                      56.0,                          1.26580  },
   {  1.4332,                      56.1,                          1.26637  },
   {  1.4334,                      56.2,                          1.26695  },
   {  1.4337,                      56.3,                          1.26752  }, // The PDF has the SG as 1.26772, but, from plotting the data, I think that's a typo
   {  1.4339,                      56.4,                          1.26810  },
   {  1.4341,                      56.5,                          1.26868  },
   {  1.4313,                      56.6,                          1.26925  },
   {  1.4345,                      56.7,                          1.26983  },
   {  1.4348,                      56.8,                          1.27041  },
   {  1.4350,                      56.9,                          1.27098  },
   {  1.4352,                      57.0,                          1.27156  },
   {  1.4354,                      57.1,                          1.27214  },
   {  1.4356,                      57.2,                          1.27272  },
   {  1.4359,                      57.3,                          1.27330  },
   {  1.4361,                      57.4,                          1.27388  },
   {  1.4363,                      57.5,                          1.27446  },
   {  1.4365,                      57.6,                          1.27504  },
   {  1.4368,                      57.7,                          1.27562  },
   {  1.4370,                      57.8,                          1.27620  },
   {  1.4372,                      57.9,                          1.27678  },
   {  1.4374,                      58.0,                          1.27736  },
   {  1.4376,                      58.1,                          1.27794  },
   {  1.4379,                      58.2,                          1.27853  },
   {  1.4381,                      58.3,                          1.27911  },
   {  1.4383,                      58.4,                          1.27969  },
   {  1.4385,                      58.5,                          1.28028  },
   {  1.4388,                      58.6,                          1.28086  },
   {  1.4390,                      58.7,                          1.28145  },
   {  1.4392,                      58.8,                          1.28203  },
   {  1.4394,                      58.9,                          1.28262  },
   {  1.4397,                      59.0,                          1.28320  },
   {  1.4399,                      59.1,                          1.28379  },
   {  1.4401,                      59.2,                          1.28437  },
   {  1.4403,                      59.3,                          1.28497  },
   {  1.4406,                      59.4,                          1.28555  },
   {  1.4408,                      59.5,                          1.28614  },
   {  1.4410,                      59.6,                          1.28672  },
   {  1.4412,                      59.7,                          1.28731  },
   {  1.4415,                      59.8,                          1.28789  },
   {  1.4417,                      59.9,                          1.28849  },
   {  1.4419,                      60.0,                          1.28908  },
   {  1.4422,                      60.1,                          1.28966  },
   {  1.4424,                      60.2,                          1.29025  },
   {  1.4426,                      60.3,                          1.29084  },
   {  1.4428,                      60.4,                          1.29143  },
   {  1.4431,                      60.5,                          1.29203  }, // The PDF has the SG as 1.29023, but, from plotting the data, I think that's a typo
   {  1.4433,                      60.6,                          1.29262  },
   {  1.4435,                      60.7,                          1.29321  },
   {  1.4437,                      60.8,                          1.29380  },
   {  1.4440,                      60.9,                          1.29439  },
   {  1.4442,                      61.0,                          1.29498  },
   {  1.4444,                      61.1,                          1.29559  },
   {  1.4447,                      61.2,                          1.29618  },
   {  1.4449,                      61.3,                          1.29677  },
   {  1.4451,                      61.4,                          1.29736  },
   {  1.4453,                      61.5,                          1.29796  },
   {  1.4456,                      61.6,                          1.29855  },
   {  1.4458,                      61.7,                          1.29915  },
   {  1.4460,                      61.8,                          1.29975  },
   {  1.4463,                      61.9,                          1.30034  },
   {  1.4465,                      62.0,                          1.30093  },
   {  1.4467,                      62.1,                          1.30153  },
   {  1.4470,                      62.2,                          1.30212  },
   {  1.4472,                      62.3,                          1.30273  },
   {  1.4474,                      62.4,                          1.30334  },
   {  1.4476,                      62.5,                          1.30393  },
   {  1.4479,                      62.6,                          1.30453  },
   {  1.4481,                      62.7,                          1.30513  },
   {  1.4483,                      62.8,                          1.30573  },
   {  1.4486,                      62.9,                          1.30633  },
   {  1.4488,                      63.0,                          1.30694  },
   {  1.4490,                      63.1,                          1.30754  },
   {  1.4493,                      63.2,                          1.30815  },
   {  1.4495,                      63.3,                          1.30875  },
   {  1.4497,                      63.4,                          1.30936  },
   {  1.4500,                      63.5,                          1.30994  },
   {  1.4502,                      63.6,                          1.31055  },
   {  1.4504,                      63.7,                          1.31117  },
   {  1.4507,                      63.8,                          1.31177  },
   {  1.4509,                      63.9,                          1.31237  },
   {  1.4511,                      64.0,                          1.31297  },
   {  1.4514,                      64.1,                          1.31359  },
   {  1.4516,                      64.2,                          1.31418  },
   {  1.4518,                      64.3,                          1.31479  },
   {  1.4521,                      64.4,                          1.31540  },
   {  1.4523,                      64.5,                          1.31600  },
   {  1.4525,                      64.6,                          1.31661  },
   {  1.4528,                      64.7,                          1.31723  },
   {  1.4530,                      64.8,                          1.31784  },
   {  1.4532,                      64.9,                          1.31845  },
   {  1.4535,                      65.0,                          1.31905  },
   {  1.4537,                      65.1,                          1.31966  },
   {  1.4539,                      65.2,                          1.32028  },
   {  1.45422,                     65.3,                          1.32089  },
   {  1.4544,                      65.4,                          1.32150  },
   {  1.4546,                      65.5,                          1.32210  },
   {  1.4549,                      65.6,                          1.32271  },
   {  1.4551,                      65.7,                          1.32332  },
   {  1.4553,                      65.8,                          1.32393  },
   {  1.4556,                      65.9,                          1.32455  },
   {  1.4558,                      66.0,                          1.32516  },
   {  1.4561,                      66.1,                          1.32577  },
   {  1.4563,                      66.2,                          1.32638  },
   {  1.4565,                      66.3,                          1.32699  },
   {  1.4568,                      66.4,                          1.32759  },
   {  1.4570,                      66.5,                          1.32820  },
   {  1.4572,                      66.6,                          1.32884  },
   {  1.4575,                      66.7,                          1.32945  },
   {  1.4577,                      66.8,                          1.33007  },
   {  1.4580,                      66.9,                          1.33068  },
   {  1.4582,                      67.0,                          1.33129  },
   {  1.4584,                      67.1,                          1.33192  }, // The PDF has the SG as 1.33292, but, from plotting the data, I think that's a typo
   {  1.4587,                      67.2,                          1.33254  },
   {  1.4589,                      67.3,                          1.33315  },
   {  1.4591,                      67.4,                          1.33377  },
   {  1.4594,                      67.5,                          1.33438  },
   {  1.4596,                      67.6,                          1.33500  },
   {  1.4599,                      67.7,                          1.33562  },
   {  1.4601,                      67.8,                          1.33625  },
   {  1.4603,                      67.9,                          1.33686  },
   {  1.4606,                      68.0,                          1.33748  },
   {  1.4608,                      68.1,                          1.33810  },
   {  1.4611,                      68.2,                          1.33872  },
   {  1.4613,                      68.3,                          1.33935  },
   {  1.4615,                      68.4,                          1.33997  },
   {  1.4618,                      68.5,                          1.34059  },
   {  1.4620,                      68.6,                          1.34121  },
   {  1.4623,                      68.7,                          1.34183  },
   {  1.4625,                      68.8,                          1.34245  },
   {  1.4628,                      68.9,                          1.34309  },
   {  1.4630,                      69.0,                          1.34371  },
   {  1.4632,                      69.1,                          1.34433  },
   {  1.4635,                      69.2,                          1.34495  },
   {  1.4637,                      69.3,                          1.34558  },
   {  1.4640,                      69.4,                          1.34621  },
   {  1.4642,                      69.5,                          1.34684  },
   {  1.4644,                      69.6,                          1.34746  },
   {  1.4647,                      69.7,                          1.34809  },
   {  1.4649,                      69.8,                          1.34871  },
   {  1.4652,                      69.9,                          1.34934  },
   {  1.4654,                      70.0,                          1.34997  },
   {  1.4657,                      70.1,                          1.35060  },
   {  1.4659,                      70.2,                          1.35123  },
   {  1.4661,                      70.3,                          1.35186  },
   {  1.4664,                      70.4,                          1.35248  },
   {  1.4666,                      70.5,                          1.35311  },
   {  1.4669,                      70.6,                          1.35375  },
   {  1.4671,                      70.7,                          1.35438  },
   {  1.4674,                      70.8,                          1.35501  },
   {  1.4676,                      70.9,                          1.35564  },
   {  1.4679,                      71.0,                          1.35627  },
   {  1.4681,                      71.1,                          1.35691  },
   {  1.4684,                      71.2,                          1.35754  },
   {  1.4686,                      71.3,                          1.35817  },
   {  1.4688,                      71.4,                          1.35881  },
   {  1.4691,                      71.5,                          1.35944  },
   {  1.4693,                      71.6,                          1.36008  },
   {  1.4696,                      71.7,                          1.36072  },
   {  1.4698,                      71.8,                          1.36135  },
   {  1.4701,                      71.9,                          1.36198  },
   {  1.4703,                      72.0,                          1.36261  },
   {  1.4706,                      72.1,                          1.36324  },
   {  1.4708,                      72.2,                          1.36389  },
   {  1.4711,                      72.3,                          1.36452  },
   {  1.4713,                      72.4,                          1.36516  },
   {  1.4716,                      72.5,                          1.36579  },
   {  1.4718,                      72.6,                          1.36643  },
   {  1.4721,                      72.7,                          1.36707  },
   {  1.4723,                      72.8,                          1.36771  },
   {  1.4725,                      72.9,                          1.36836  },
   {  1.4728,                      73.0,                          1.36900  },
   {  1.4730,                      73.1,                          1.36964  },
   {  1.4733,                      73.2,                          1.37028  },
   {  1.4735,                      73.3,                          1.37092  },
   {  1.4738,                      73.4,                          1.37156  },
   {  1.4740,                      73.5,                          1.37220  },
   {  1.4743,                      73.6,                          1.37283  },
   {  1.4745,                      73.7,                          1.37347  },
   {  1.4748,                      73.8,                          1.37411  },
   {  1.4750,                      73.9,                          1.37476  },
   {  1.4753,                      74.0,                          1.37541  },
   {  1.4756,                      74.1,                          1.37605  },
   {  1.4758,                      74.2,                          1.37669  },
   {  1.4760,                      74.3,                          1.37733  },
   {  1.4763,                      74.4,                          1.37798  },
   {  1.4765,                      74.5,                          1.37864  },
   {  1.4768,                      74.6,                          1.37928  },
   {  1.4770,                      74.7,                          1.37993  },
   {  1.4773,                      74.8,                          1.38057  },
   {  1.4776,                      74.9,                          1.38122  },
   {  1.4778,                      75.0,                          1.38187  },
   {  1.4781,                      75.1,                          1.38252  },
   {  1.4783,                      75.2,                          1.38316  },
   {  1.4786,                      75.3,                          1.38381  },
   {  1.4788,                      75.4,                          1.38445  },
   {  1.4791,                      75.5,                          1.38510  },
   {  1.4793,                      75.6,                          1.38575  },
   {  1.4796,                      75.7,                          1.38640  },
   {  1.4798,                      75.8,                          1.38705  },
   {  1.4801,                      75.9,                          1.38770  },
   {  1.4803,                      76.0,                          1.38835  },
   {  1.4806,                      76.1,                          1.38902  },
   {  1.4808,                      76.2,                          1.38967  },
   {  1.4811,                      76.3,                          1.39032  },
   {  1.4814,                      76.4,                          1.39097  },
   {  1.4816,                      76.5,                          1.39162  },
   {  1.4819,                      76.6,                          1.39228  },
   {  1.4821,                      76.7,                          1.39293  },
   {  1.4824,                      76.8,                          1.39358  },
   {  1.4826,                      76.9,                          1.39423  },
   {  1.4829,                      77.0,                          1.39489  },
   {  1.4831,                      77.1,                          1.39554  },
   {  1.4834,                      77.2,                          1.39619  },
   {  1.4836,                      77.3,                          1.39685  },
   {  1.4839,                      77.4,                          1.39750  },
   {  1.4841,                      77.5,                          1.39816  },
   {  1.4844,                      77.6,                          1.39882  },
   {  1.4847,                      77.7,                          1.39949  },
   {  1.4849,                      77.8,                          1.40014  },
   {  1.4852,                      77.9,                          1.40080  },
   {  1.4854,                      78.0,                          1.40146  },
   {  1.4857,                      78.1,                          1.40211  },
   {  1.4860,                      78.2,                          1.40277  },
   {  1.4862,                      78.3,                          1.40344  },
   {  1.4865,                      78.4,                          1.40409  },
   {  1.4867,                      78.5,                          1.40475  },
   {  1.4870,                      78.6,                          1.40541  },
   {  1.4873,                      78.7,                          1.40607  },
   {  1.4875,                      78.8,                          1.40674  },
   {  1.4878,                      78.9,                          1.40740  }, // The PDF has the SG as 1.40840, but, from plotting the data, I think that's a typo
   {  1.4880,                      79.0,                          1.40806  },
   {  1.4883,                      79.1,                          1.40872  },
   {  1.4886,                      79.2,                          1.40938  },
   {  1.4888,                      79.3,                          1.41005  },
   {  1.4891,                      79.4,                          1.41072  },
   {  1.4893,                      79.5,                          1.41138  },
   {  1.4896,                      79.6,                          1.41204  },
   {  1.4899,                      79.7,                          1.41270  },
   {  1.4901,                      79.8,                          1.41337  },
   {  1.4904,                      79.9,                          1.41404  },
   {  1.4906,                      80.0,                          1.41471  },
};

size_t constexpr Measurement::sucroseConversions_size = std::size(Measurement::sucroseConversions);
