{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdClosed: TSFBool;
    { Internal wrapper for property @link(Closed). This wrapper API may change, we advise to access simpler @link(Closed) instead. }
    public property FdClosed: TSFBool read FFdClosed;
    {  }
    property Closed: Boolean read GetClosed write SetClosed;

    strict private FFdKeyValue: TMFFloat;
    { Internal wrapper for property @link(KeyValue). This wrapper API may change, we advise to access simpler @link(KeyValue) instead. }
    public property FdKeyValue: TMFFloat read FFdKeyValue;
    {  }
    procedure SetKeyValue(const Value: array of Single); overload;
    {  }
    procedure SetKeyValue(const Value: TSingleList); overload;

    strict private FFdKeyVelocity: TMFFloat;
    { Internal wrapper for property @link(KeyVelocity). This wrapper API may change, we advise to access simpler @link(KeyVelocity) instead. }
    public property FdKeyVelocity: TMFFloat read FFdKeyVelocity;
    {  }
    procedure SetKeyVelocity(const Value: array of Single); overload;
    {  }
    procedure SetKeyVelocity(const Value: TSingleList); overload;

    strict private FFdNormalizeVelocity: TSFBool;
    { Internal wrapper for property @link(NormalizeVelocity). This wrapper API may change, we advise to access simpler @link(NormalizeVelocity) instead. }
    public property FdNormalizeVelocity: TSFBool read FFdNormalizeVelocity;
    {  }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

    strict private FEventValue_changed: TSFFloatEvent;
    {  }
    public property EventValue_changed: TSFFloatEvent read FEventValue_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TSplineScalarInterpolatorNode ----------------------------------------------- }

function TSplineScalarInterpolatorNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TSplineScalarInterpolatorNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyValue(const Value: array of Single);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyValue(const Value: TSingleList);
begin
  FdKeyValue.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyVelocity(const Value: array of Single);
begin
  FdKeyVelocity.Send(Value);
end;

procedure TSplineScalarInterpolatorNode.SetKeyVelocity(const Value: TSingleList);
begin
  FdKeyVelocity.Send(Value);
end;

function TSplineScalarInterpolatorNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSplineScalarInterpolatorNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

class function TSplineScalarInterpolatorNode.ClassX3DType: String;
begin
  Result := 'SplineScalarInterpolator';
end;

procedure TSplineScalarInterpolatorNode.CreateNode;
begin
  inherited;

  FFdClosed := TSFBool.Create(Self, True, 'closed', false);
   FdClosed.ChangeAlways := chNone;
  AddField(FFdClosed);

  FFdKeyValue := TMFFloat.Create(Self, True, 'keyValue', []);
   FdKeyValue.ChangeAlways := chNone;
  AddField(FFdKeyValue);

  FFdKeyVelocity := TMFFloat.Create(Self, True, 'keyVelocity', []);
   FdKeyVelocity.ChangeAlways := chNone;
  AddField(FFdKeyVelocity);

  FFdNormalizeVelocity := TSFBool.Create(Self, True, 'normalizeVelocity', false);
   FdNormalizeVelocity.ChangeAlways := chNone;
  AddField(FFdNormalizeVelocity);

  FEventValue_changed := TSFFloatEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);
end;

{$endif read_implementation}
