{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetAntennaLocation: TVector3;
    procedure SetAntennaLocation(const Value: TVector3);
    function GetAntennaPatternLength: Integer;
    procedure SetAntennaPatternLength(const Value: Integer);
    function GetAntennaPatternType: Integer;
    procedure SetAntennaPatternType(const Value: Integer);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetCryptoKeyID: Integer;
    procedure SetCryptoKeyID(const Value: Integer);
    function GetCryptoSystem: Integer;
    procedure SetCryptoSystem(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetFrequency: Integer;
    procedure SetFrequency(const Value: Integer);
    function GetInputSource: Integer;
    procedure SetInputSource(const Value: Integer);
    function GetLengthOfModulationParameters: Integer;
    procedure SetLengthOfModulationParameters(const Value: Integer);
    function GetModulationTypeDetail: Integer;
    procedure SetModulationTypeDetail(const Value: Integer);
    function GetModulationTypeMajor: Integer;
    procedure SetModulationTypeMajor(const Value: Integer);
    function GetModulationTypeSpreadSpectrum: Integer;
    procedure SetModulationTypeSpreadSpectrum(const Value: Integer);
    function GetModulationTypeSystem: Integer;
    procedure SetModulationTypeSystem(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetNetworkMode: TDISNetworkMode;
    procedure SetNetworkMode(const Value: TDISNetworkMode);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetPower: Single;
    procedure SetPower(const Value: Single);
    function GetRadioEntityTypeCategory: Integer;
    procedure SetRadioEntityTypeCategory(const Value: Integer);
    function GetRadioEntityTypeCountry: Integer;
    procedure SetRadioEntityTypeCountry(const Value: Integer);
    function GetRadioEntityTypeDomain: Integer;
    procedure SetRadioEntityTypeDomain(const Value: Integer);
    function GetRadioEntityTypeKind: Integer;
    procedure SetRadioEntityTypeKind(const Value: Integer);
    function GetRadioEntityTypeNomenclature: Integer;
    procedure SetRadioEntityTypeNomenclature(const Value: Integer);
    function GetRadioEntityTypeNomenclatureVersion: Integer;
    procedure SetRadioEntityTypeNomenclatureVersion(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetRelativeAntennaLocation: TVector3;
    procedure SetRelativeAntennaLocation(const Value: TVector3);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTransmitFrequencyBandwidth: Single;
    procedure SetTransmitFrequencyBandwidth(const Value: Single);
    function GetTransmitState: Integer;
    procedure SetTransmitState(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAddress: TSFString;
    { Internal wrapper for property @code(Address). This wrapper API may change, we advise to access simpler @code(Address) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAddress: TSFString read FFdAddress;
    {  }
    property Address: String read GetAddress write SetAddress;

    strict private FFdAntennaLocation: TSFVec3f;
    { Internal wrapper for property @code(AntennaLocation). This wrapper API may change, we advise to access simpler @code(AntennaLocation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAntennaLocation: TSFVec3f read FFdAntennaLocation;
    {  }
    property AntennaLocation: TVector3 read GetAntennaLocation write SetAntennaLocation;

    strict private FFdAntennaPatternLength: TSFInt32;
    { Internal wrapper for property @code(AntennaPatternLength). This wrapper API may change, we advise to access simpler @code(AntennaPatternLength) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAntennaPatternLength: TSFInt32 read FFdAntennaPatternLength;
    {  }
    property AntennaPatternLength: Integer read GetAntennaPatternLength write SetAntennaPatternLength;

    strict private FFdAntennaPatternType: TSFInt32;
    { Internal wrapper for property @code(AntennaPatternType). This wrapper API may change, we advise to access simpler @code(AntennaPatternType) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAntennaPatternType: TSFInt32 read FFdAntennaPatternType;
    {  }
    property AntennaPatternType: Integer read GetAntennaPatternType write SetAntennaPatternType;

    strict private FFdApplicationID: TSFInt32;
    { Internal wrapper for property @code(ApplicationID). This wrapper API may change, we advise to access simpler @code(ApplicationID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdApplicationID: TSFInt32 read FFdApplicationID;
    {  }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;

    strict private FFdCryptoKeyID: TSFInt32;
    { Internal wrapper for property @code(CryptoKeyID). This wrapper API may change, we advise to access simpler @code(CryptoKeyID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCryptoKeyID: TSFInt32 read FFdCryptoKeyID;
    {  }
    property CryptoKeyID: Integer read GetCryptoKeyID write SetCryptoKeyID;

    strict private FFdCryptoSystem: TSFInt32;
    { Internal wrapper for property @code(CryptoSystem). This wrapper API may change, we advise to access simpler @code(CryptoSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCryptoSystem: TSFInt32 read FFdCryptoSystem;
    {  }
    property CryptoSystem: Integer read GetCryptoSystem write SetCryptoSystem;

    strict private FFdEntityID: TSFInt32;
    { Internal wrapper for property @code(EntityID). This wrapper API may change, we advise to access simpler @code(EntityID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityID: TSFInt32 read FFdEntityID;
    {  }
    property EntityID: Integer read GetEntityID write SetEntityID;

    strict private FFdFrequency: TSFInt32;
    { Internal wrapper for property @code(Frequency). This wrapper API may change, we advise to access simpler @code(Frequency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFrequency: TSFInt32 read FFdFrequency;
    {  }
    property Frequency: Integer read GetFrequency write SetFrequency;

    strict private FFdInputSource: TSFInt32;
    { Internal wrapper for property @code(InputSource). This wrapper API may change, we advise to access simpler @code(InputSource) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInputSource: TSFInt32 read FFdInputSource;
    {  }
    property InputSource: Integer read GetInputSource write SetInputSource;

    strict private FFdLengthOfModulationParameters: TSFInt32;
    { Internal wrapper for property @code(LengthOfModulationParameters). This wrapper API may change, we advise to access simpler @code(LengthOfModulationParameters) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLengthOfModulationParameters: TSFInt32 read FFdLengthOfModulationParameters;
    {  }
    property LengthOfModulationParameters: Integer read GetLengthOfModulationParameters write SetLengthOfModulationParameters;

    strict private FFdModulationTypeDetail: TSFInt32;
    { Internal wrapper for property @code(ModulationTypeDetail). This wrapper API may change, we advise to access simpler @code(ModulationTypeDetail) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdModulationTypeDetail: TSFInt32 read FFdModulationTypeDetail;
    {  }
    property ModulationTypeDetail: Integer read GetModulationTypeDetail write SetModulationTypeDetail;

    strict private FFdModulationTypeMajor: TSFInt32;
    { Internal wrapper for property @code(ModulationTypeMajor). This wrapper API may change, we advise to access simpler @code(ModulationTypeMajor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdModulationTypeMajor: TSFInt32 read FFdModulationTypeMajor;
    {  }
    property ModulationTypeMajor: Integer read GetModulationTypeMajor write SetModulationTypeMajor;

    strict private FFdModulationTypeSpreadSpectrum: TSFInt32;
    { Internal wrapper for property @code(ModulationTypeSpreadSpectrum). This wrapper API may change, we advise to access simpler @code(ModulationTypeSpreadSpectrum) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdModulationTypeSpreadSpectrum: TSFInt32 read FFdModulationTypeSpreadSpectrum;
    {  }
    property ModulationTypeSpreadSpectrum: Integer read GetModulationTypeSpreadSpectrum write SetModulationTypeSpreadSpectrum;

    strict private FFdModulationTypeSystem: TSFInt32;
    { Internal wrapper for property @code(ModulationTypeSystem). This wrapper API may change, we advise to access simpler @code(ModulationTypeSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdModulationTypeSystem: TSFInt32 read FFdModulationTypeSystem;
    {  }
    property ModulationTypeSystem: Integer read GetModulationTypeSystem write SetModulationTypeSystem;

    strict private FFdMulticastRelayHost: TSFString;
    { Internal wrapper for property @code(MulticastRelayHost). This wrapper API may change, we advise to access simpler @code(MulticastRelayHost) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayHost: TSFString read FFdMulticastRelayHost;
    {  }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;

    strict private FFdMulticastRelayPort: TSFInt32;
    { Internal wrapper for property @code(MulticastRelayPort). This wrapper API may change, we advise to access simpler @code(MulticastRelayPort) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayPort: TSFInt32 read FFdMulticastRelayPort;
    {  }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;

    strict private FFdNetworkMode: TSFStringEnum;
    { Internal wrapper for property @code(NetworkMode). This wrapper API may change, we advise to access simpler @code(NetworkMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNetworkMode: TSFStringEnum read FFdNetworkMode;
    {  }
    property NetworkMode: TDISNetworkMode read GetNetworkMode write SetNetworkMode;

    strict private FFdPort: TSFInt32;
    { Internal wrapper for property @code(Port). This wrapper API may change, we advise to access simpler @code(Port) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPort: TSFInt32 read FFdPort;
    {  }
    property Port: Integer read GetPort write SetPort;

    strict private FFdPower: TSFFloat;
    { Internal wrapper for property @code(Power). This wrapper API may change, we advise to access simpler @code(Power) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPower: TSFFloat read FFdPower;
    {  }
    property Power: Single read GetPower write SetPower;

    strict private FFdRadioEntityTypeCategory: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeCategory). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeCategory) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeCategory: TSFInt32 read FFdRadioEntityTypeCategory;
    {  }
    property RadioEntityTypeCategory: Integer read GetRadioEntityTypeCategory write SetRadioEntityTypeCategory;

    strict private FFdRadioEntityTypeCountry: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeCountry). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeCountry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeCountry: TSFInt32 read FFdRadioEntityTypeCountry;
    {  }
    property RadioEntityTypeCountry: Integer read GetRadioEntityTypeCountry write SetRadioEntityTypeCountry;

    strict private FFdRadioEntityTypeDomain: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeDomain). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeDomain) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeDomain: TSFInt32 read FFdRadioEntityTypeDomain;
    {  }
    property RadioEntityTypeDomain: Integer read GetRadioEntityTypeDomain write SetRadioEntityTypeDomain;

    strict private FFdRadioEntityTypeKind: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeKind). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeKind) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeKind: TSFInt32 read FFdRadioEntityTypeKind;
    {  }
    property RadioEntityTypeKind: Integer read GetRadioEntityTypeKind write SetRadioEntityTypeKind;

    strict private FFdRadioEntityTypeNomenclature: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeNomenclature). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeNomenclature) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeNomenclature: TSFInt32 read FFdRadioEntityTypeNomenclature;
    {  }
    property RadioEntityTypeNomenclature: Integer read GetRadioEntityTypeNomenclature write SetRadioEntityTypeNomenclature;

    strict private FFdRadioEntityTypeNomenclatureVersion: TSFInt32;
    { Internal wrapper for property @code(RadioEntityTypeNomenclatureVersion). This wrapper API may change, we advise to access simpler @code(RadioEntityTypeNomenclatureVersion) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioEntityTypeNomenclatureVersion: TSFInt32 read FFdRadioEntityTypeNomenclatureVersion;
    {  }
    property RadioEntityTypeNomenclatureVersion: Integer read GetRadioEntityTypeNomenclatureVersion write SetRadioEntityTypeNomenclatureVersion;

    strict private FFdRadioID: TSFInt32;
    { Internal wrapper for property @code(RadioID). This wrapper API may change, we advise to access simpler @code(RadioID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadioID: TSFInt32 read FFdRadioID;
    {  }
    property RadioID: Integer read GetRadioID write SetRadioID;

    strict private FFdReadInterval: TSFFloat;
    { Internal wrapper for property @code(ReadInterval). This wrapper API may change, we advise to access simpler @code(ReadInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReadInterval: TSFFloat read FFdReadInterval;
    {  }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;

    strict private FFdRelativeAntennaLocation: TSFVec3f;
    { Internal wrapper for property @code(RelativeAntennaLocation). This wrapper API may change, we advise to access simpler @code(RelativeAntennaLocation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRelativeAntennaLocation: TSFVec3f read FFdRelativeAntennaLocation;
    {  }
    property RelativeAntennaLocation: TVector3 read GetRelativeAntennaLocation write SetRelativeAntennaLocation;

    strict private FFdRtpHeaderExpected: TSFBool;
    { Internal wrapper for property @code(RtpHeaderExpected). This wrapper API may change, we advise to access simpler @code(RtpHeaderExpected) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRtpHeaderExpected: TSFBool read FFdRtpHeaderExpected;
    {  }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;

    strict private FFdSiteID: TSFInt32;
    { Internal wrapper for property @code(SiteID). This wrapper API may change, we advise to access simpler @code(SiteID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSiteID: TSFInt32 read FFdSiteID;
    {  }
    property SiteID: Integer read GetSiteID write SetSiteID;

    strict private FFdTransmitFrequencyBandwidth: TSFFloat;
    { Internal wrapper for property @code(TransmitFrequencyBandwidth). This wrapper API may change, we advise to access simpler @code(TransmitFrequencyBandwidth) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmitFrequencyBandwidth: TSFFloat read FFdTransmitFrequencyBandwidth;
    {  }
    property TransmitFrequencyBandwidth: Single read GetTransmitFrequencyBandwidth write SetTransmitFrequencyBandwidth;

    strict private FFdTransmitState: TSFInt32;
    { Internal wrapper for property @code(TransmitState). This wrapper API may change, we advise to access simpler @code(TransmitState) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmitState: TSFInt32 read FFdTransmitState;
    {  }
    property TransmitState: Integer read GetTransmitState write SetTransmitState;

    strict private FFdWhichGeometry: TSFInt32;
    { Internal wrapper for property @code(WhichGeometry). This wrapper API may change, we advise to access simpler @code(WhichGeometry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWhichGeometry: TSFInt32 read FFdWhichGeometry;
    {  }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;

    strict private FFdWriteInterval: TSFFloat;
    { Internal wrapper for property @code(WriteInterval). This wrapper API may change, we advise to access simpler @code(WriteInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWriteInterval: TSFFloat read FFdWriteInterval;
    {  }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;

    strict private FEventIsNetworkReader: TSFBoolEvent;
    {  }
    public property EventIsNetworkReader: TSFBoolEvent read FEventIsNetworkReader;

    strict private FEventIsNetworkWriter: TSFBoolEvent;
    {  }
    public property EventIsNetworkWriter: TSFBoolEvent read FEventIsNetworkWriter;

    strict private FEventIsRtpHeaderHeard: TSFBoolEvent;
    {  }
    public property EventIsRtpHeaderHeard: TSFBoolEvent read FEventIsRtpHeaderHeard;

    strict private FEventIsStandAlone: TSFBoolEvent;
    {  }
    public property EventIsStandAlone: TSFBoolEvent read FEventIsStandAlone;

    strict private FEventTimestamp: TSFTimeEvent;
    {  }
    public property EventTimestamp: TSFTimeEvent read FEventTimestamp;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @code(BboxCenter). This wrapper API may change, we advise to access simpler @code(BboxCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @code(BboxSize). This wrapper API may change, we advise to access simpler @code(BboxSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TTransmitterPduNode ----------------------------------------------- }

function TTransmitterPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TTransmitterPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TTransmitterPduNode.GetAntennaLocation: TVector3;
begin
  Result := FdAntennaLocation.Value;
end;

procedure TTransmitterPduNode.SetAntennaLocation(const Value: TVector3);
begin
  FdAntennaLocation.Send(Value);
end;

function TTransmitterPduNode.GetAntennaPatternLength: Integer;
begin
  Result := FdAntennaPatternLength.Value;
end;

procedure TTransmitterPduNode.SetAntennaPatternLength(const Value: Integer);
begin
  FdAntennaPatternLength.Send(Value);
end;

function TTransmitterPduNode.GetAntennaPatternType: Integer;
begin
  Result := FdAntennaPatternType.Value;
end;

procedure TTransmitterPduNode.SetAntennaPatternType(const Value: Integer);
begin
  FdAntennaPatternType.Send(Value);
end;

function TTransmitterPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TTransmitterPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TTransmitterPduNode.GetCryptoKeyID: Integer;
begin
  Result := FdCryptoKeyID.Value;
end;

procedure TTransmitterPduNode.SetCryptoKeyID(const Value: Integer);
begin
  FdCryptoKeyID.Send(Value);
end;

function TTransmitterPduNode.GetCryptoSystem: Integer;
begin
  Result := FdCryptoSystem.Value;
end;

procedure TTransmitterPduNode.SetCryptoSystem(const Value: Integer);
begin
  FdCryptoSystem.Send(Value);
end;

function TTransmitterPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TTransmitterPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TTransmitterPduNode.GetFrequency: Integer;
begin
  Result := FdFrequency.Value;
end;

procedure TTransmitterPduNode.SetFrequency(const Value: Integer);
begin
  FdFrequency.Send(Value);
end;

function TTransmitterPduNode.GetInputSource: Integer;
begin
  Result := FdInputSource.Value;
end;

procedure TTransmitterPduNode.SetInputSource(const Value: Integer);
begin
  FdInputSource.Send(Value);
end;

function TTransmitterPduNode.GetLengthOfModulationParameters: Integer;
begin
  Result := FdLengthOfModulationParameters.Value;
end;

procedure TTransmitterPduNode.SetLengthOfModulationParameters(const Value: Integer);
begin
  FdLengthOfModulationParameters.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeDetail: Integer;
begin
  Result := FdModulationTypeDetail.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeDetail(const Value: Integer);
begin
  FdModulationTypeDetail.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeMajor: Integer;
begin
  Result := FdModulationTypeMajor.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeMajor(const Value: Integer);
begin
  FdModulationTypeMajor.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeSpreadSpectrum: Integer;
begin
  Result := FdModulationTypeSpreadSpectrum.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeSpreadSpectrum(const Value: Integer);
begin
  FdModulationTypeSpreadSpectrum.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeSystem: Integer;
begin
  Result := FdModulationTypeSystem.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeSystem(const Value: Integer);
begin
  FdModulationTypeSystem.Send(Value);
end;

function TTransmitterPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TTransmitterPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TTransmitterPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TTransmitterPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TTransmitterPduNode.GetNetworkMode: TDISNetworkMode;
begin
  Result := TDISNetworkMode(FdNetworkMode.EnumValue);
end;

procedure TTransmitterPduNode.SetNetworkMode(const Value: TDISNetworkMode);
begin
  FdNetworkMode.SendEnumValue(Ord(Value));
end;

function TTransmitterPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TTransmitterPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TTransmitterPduNode.GetPower: Single;
begin
  Result := FdPower.Value;
end;

procedure TTransmitterPduNode.SetPower(const Value: Single);
begin
  FdPower.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeCategory: Integer;
begin
  Result := FdRadioEntityTypeCategory.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeCategory(const Value: Integer);
begin
  FdRadioEntityTypeCategory.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeCountry: Integer;
begin
  Result := FdRadioEntityTypeCountry.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeCountry(const Value: Integer);
begin
  FdRadioEntityTypeCountry.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeDomain: Integer;
begin
  Result := FdRadioEntityTypeDomain.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeDomain(const Value: Integer);
begin
  FdRadioEntityTypeDomain.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeKind: Integer;
begin
  Result := FdRadioEntityTypeKind.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeKind(const Value: Integer);
begin
  FdRadioEntityTypeKind.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeNomenclature: Integer;
begin
  Result := FdRadioEntityTypeNomenclature.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeNomenclature(const Value: Integer);
begin
  FdRadioEntityTypeNomenclature.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeNomenclatureVersion: Integer;
begin
  Result := FdRadioEntityTypeNomenclatureVersion.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeNomenclatureVersion(const Value: Integer);
begin
  FdRadioEntityTypeNomenclatureVersion.Send(Value);
end;

function TTransmitterPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TTransmitterPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TTransmitterPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TTransmitterPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TTransmitterPduNode.GetRelativeAntennaLocation: TVector3;
begin
  Result := FdRelativeAntennaLocation.Value;
end;

procedure TTransmitterPduNode.SetRelativeAntennaLocation(const Value: TVector3);
begin
  FdRelativeAntennaLocation.Send(Value);
end;

function TTransmitterPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TTransmitterPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TTransmitterPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TTransmitterPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TTransmitterPduNode.GetTransmitFrequencyBandwidth: Single;
begin
  Result := FdTransmitFrequencyBandwidth.Value;
end;

procedure TTransmitterPduNode.SetTransmitFrequencyBandwidth(const Value: Single);
begin
  FdTransmitFrequencyBandwidth.Send(Value);
end;

function TTransmitterPduNode.GetTransmitState: Integer;
begin
  Result := FdTransmitState.Value;
end;

procedure TTransmitterPduNode.SetTransmitState(const Value: Integer);
begin
  FdTransmitState.Send(Value);
end;

function TTransmitterPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TTransmitterPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TTransmitterPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TTransmitterPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TTransmitterPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TTransmitterPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TTransmitterPduNode.ClassX3DType: String;
begin
  Result := 'TransmitterPdu';
end;

procedure TTransmitterPduNode.CreateNode;
begin
  inherited;

  FFdAddress := TSFString.Create(Self, True, 'address', 'localhost');
   FdAddress.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAddress);

  FFdAntennaLocation := TSFVec3f.Create(Self, True, 'antennaLocation', Vector3(0, 0, 0));
   FdAntennaLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAntennaLocation);

  FFdAntennaPatternLength := TSFInt32.Create(Self, True, 'antennaPatternLength', 0);
   FdAntennaPatternLength.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAntennaPatternLength);

  FFdAntennaPatternType := TSFInt32.Create(Self, True, 'antennaPatternType', 0);
   FdAntennaPatternType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAntennaPatternType);

  FFdApplicationID := TSFInt32.Create(Self, True, 'applicationID', 1);
   FdApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplicationID);

  FFdCryptoKeyID := TSFInt32.Create(Self, True, 'cryptoKeyID', 0);
   FdCryptoKeyID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCryptoKeyID);

  FFdCryptoSystem := TSFInt32.Create(Self, True, 'cryptoSystem', 0);
   FdCryptoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCryptoSystem);

  FFdEntityID := TSFInt32.Create(Self, True, 'entityID', 0);
   FdEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityID);

  FFdFrequency := TSFInt32.Create(Self, True, 'frequency', 0);
   FdFrequency.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrequency);

  FFdInputSource := TSFInt32.Create(Self, True, 'inputSource', 0);
   FdInputSource.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInputSource);

  FFdLengthOfModulationParameters := TSFInt32.Create(Self, True, 'lengthOfModulationParameters', 0);
   FdLengthOfModulationParameters.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLengthOfModulationParameters);

  FFdModulationTypeDetail := TSFInt32.Create(Self, True, 'modulationTypeDetail', 0);
   FdModulationTypeDetail.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdModulationTypeDetail);

  FFdModulationTypeMajor := TSFInt32.Create(Self, True, 'modulationTypeMajor', 0);
   FdModulationTypeMajor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdModulationTypeMajor);

  FFdModulationTypeSpreadSpectrum := TSFInt32.Create(Self, True, 'modulationTypeSpreadSpectrum', 0);
   FdModulationTypeSpreadSpectrum.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdModulationTypeSpreadSpectrum);

  FFdModulationTypeSystem := TSFInt32.Create(Self, True, 'modulationTypeSystem', 0);
   FdModulationTypeSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdModulationTypeSystem);

  FFdMulticastRelayHost := TSFString.Create(Self, True, 'multicastRelayHost', '');
   FdMulticastRelayHost.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayHost);

  FFdMulticastRelayPort := TSFInt32.Create(Self, True, 'multicastRelayPort', 0);
   FdMulticastRelayPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayPort);

  FFdNetworkMode := TSFStringEnum.Create(Self, True, 'networkMode', @DISNetworkModeNames, Ord(High(DISNetworkModeNames)) + 1, Ord(nmStandAlone));
   FdNetworkMode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNetworkMode);

  FFdPort := TSFInt32.Create(Self, True, 'port', 0);
   FdPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPort);

  FFdPower := TSFFloat.Create(Self, True, 'power', 0.0);
   FdPower.ChangeAlways := chVisibleNonGeometry;
   FdPower.MustBeNonnegative := true;
  AddField(FFdPower);

  FFdRadioEntityTypeCategory := TSFInt32.Create(Self, True, 'radioEntityTypeCategory', 0);
   FdRadioEntityTypeCategory.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeCategory);

  FFdRadioEntityTypeCountry := TSFInt32.Create(Self, True, 'radioEntityTypeCountry', 0);
   FdRadioEntityTypeCountry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeCountry);

  FFdRadioEntityTypeDomain := TSFInt32.Create(Self, True, 'radioEntityTypeDomain', 0);
   FdRadioEntityTypeDomain.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeDomain);

  FFdRadioEntityTypeKind := TSFInt32.Create(Self, True, 'radioEntityTypeKind', 0);
   FdRadioEntityTypeKind.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeKind);

  FFdRadioEntityTypeNomenclature := TSFInt32.Create(Self, True, 'radioEntityTypeNomenclature', 0);
   FdRadioEntityTypeNomenclature.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeNomenclature);

  FFdRadioEntityTypeNomenclatureVersion := TSFInt32.Create(Self, True, 'radioEntityTypeNomenclatureVersion', 0);
   FdRadioEntityTypeNomenclatureVersion.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioEntityTypeNomenclatureVersion);

  FFdRadioID := TSFInt32.Create(Self, True, 'radioID', 0);
   FdRadioID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioID);

  FFdReadInterval := TSFFloat.Create(Self, True, 'readInterval', 0.1);
   FdReadInterval.ChangeAlways := chVisibleNonGeometry;
   FdReadInterval.MustBeNonnegative := true;
  AddField(FFdReadInterval);

  FFdRelativeAntennaLocation := TSFVec3f.Create(Self, True, 'relativeAntennaLocation', Vector3(0, 0, 0));
   FdRelativeAntennaLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRelativeAntennaLocation);

  FFdRtpHeaderExpected := TSFBool.Create(Self, True, 'rtpHeaderExpected', false);
   FdRtpHeaderExpected.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRtpHeaderExpected);

  FFdSiteID := TSFInt32.Create(Self, True, 'siteID', 0);
   FdSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSiteID);

  FFdTransmitFrequencyBandwidth := TSFFloat.Create(Self, True, 'transmitFrequencyBandwidth', 0.0);
   FdTransmitFrequencyBandwidth.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitFrequencyBandwidth);

  FFdTransmitState := TSFInt32.Create(Self, True, 'transmitState', 0);
   FdTransmitState.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitState);

  FFdWhichGeometry := TSFInt32.Create(Self, True, 'whichGeometry', 1);
   FdWhichGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWhichGeometry);

  FFdWriteInterval := TSFFloat.Create(Self, True, 'writeInterval', 1.0);
   FdWriteInterval.ChangeAlways := chVisibleNonGeometry;
   FdWriteInterval.MustBeNonnegative := true;
  AddField(FFdWriteInterval);

  FEventIsNetworkReader := TSFBoolEvent.Create(Self, 'isNetworkReader', false);
  AddEvent(FEventIsNetworkReader);

  FEventIsNetworkWriter := TSFBoolEvent.Create(Self, 'isNetworkWriter', false);
  AddEvent(FEventIsNetworkWriter);

  FEventIsRtpHeaderHeard := TSFBoolEvent.Create(Self, 'isRtpHeaderHeard', false);
  AddEvent(FEventIsRtpHeaderHeard);

  FEventIsStandAlone := TSFBoolEvent.Create(Self, 'isStandAlone', false);
  AddEvent(FEventIsStandAlone);

  FEventTimestamp := TSFTimeEvent.Create(Self, 'timestamp', false);
  AddEvent(FEventTimestamp);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
