{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
{$ifndef CASTLE_SLIM_NODES}
    function GetFillProperties: TFillPropertiesNode;
    procedure SetFillProperties(const Value: TFillPropertiesNode);
{$endif not CASTLE_SLIM_NODES}
    function GetLineProperties: TLinePropertiesNode;
    procedure SetLineProperties(const Value: TLinePropertiesNode);
    function GetMaterial: TAbstractMaterialNode;
    procedure SetMaterial(const Value: TAbstractMaterialNode);
    function GetTexture: TAbstractTextureNode;
    procedure SetTexture(const Value: TAbstractTextureNode);
    function GetTextureTransform: TAbstractTextureTransformNode;
    procedure SetTextureTransform(const Value: TAbstractTextureTransformNode);
    function GetBackMaterial: TAbstractOneSidedMaterialNode;
    procedure SetBackMaterial(const Value: TAbstractOneSidedMaterialNode);
    function GetAlphaMode: TAlphaMode;
    procedure SetAlphaMode(const Value: TAlphaMode);
    function GetAlphaCutoff: Single;
    procedure SetAlphaCutoff(const Value: Single);
    function GetShadowCaster: Boolean;
    procedure SetShadowCaster(const Value: Boolean);
    function GetNormalMap: TAbstractTexture2DNode;
    procedure SetNormalMap(const Value: TAbstractTexture2DNode);
{$ifndef CASTLE_SLIM_NODES}
    function GetHeightMap: TAbstractTexture2DNode;
    procedure SetHeightMap(const Value: TAbstractTexture2DNode);
{$endif not CASTLE_SLIM_NODES}
    function GetHeightMapScale: Single;
    procedure SetHeightMapScale(const Value: Single);
    function GetBlendMode: TBlendModeNode;
    procedure SetBlendMode(const Value: TBlendModeNode);
    function GetAlphaChannel: TAutoAlphaChannel;
    procedure SetAlphaChannel(const Value: TAutoAlphaChannel);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdFillProperties: TSFNode;
    { Internal wrapper for property @code(FillProperties). This wrapper API may change, we advise to access simpler @code(FillProperties) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFillProperties: TSFNode read FFdFillProperties;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    {  }
    property FillProperties: TFillPropertiesNode read GetFillProperties write SetFillProperties;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdLineProperties: TSFNode;
    { Internal wrapper for property @code(LineProperties). This wrapper API may change, we advise to access simpler @code(LineProperties) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLineProperties: TSFNode read FFdLineProperties;
    { Properties how to display line geometry (line width and such). }
    property LineProperties: TLinePropertiesNode read GetLineProperties write SetLineProperties;

    strict private FFdMaterial: TSFNode;
    { Internal wrapper for property @code(Material). This wrapper API may change, we advise to access simpler @code(Material) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaterial: TSFNode read FFdMaterial;
    { Material determines how the shape looks, and how it interacts with lighting. }
    property Material: TAbstractMaterialNode read GetMaterial write SetMaterial;

    strict private FFdShaders: TMFNode;
    { Internal wrapper for property @code(Shaders). This wrapper API may change, we advise to access simpler @code(Shaders) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShaders: TMFNode read FFdShaders;
    { Override shaders used for rendering this shape. Instead of this, it is usually better to use @link(SetEffects) -- the effects set that way are easier, cooperate with CGE built-in rendering features, and one code is more portable to both mobile and desktop. }
    procedure SetShaders(const Value: array of TAbstractShaderNode);

    strict private FFdTexture: TSFNode;
    { Internal wrapper for property @code(Texture). This wrapper API may change, we advise to access simpler @code(Texture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexture: TSFNode read FFdTexture;
    { Main texture used by this appearance (diffuse texture for Phong lighting model, base texture for physical lighting model, emissive texture for the unlit lighting model). @deprecated It is more flexible to set the relevant texture inside material node, like @link(TMaterialNode.DiffuseTexture), @link(TPhysicalMaterialNode.BaseTexture), @link(TAbstractOneSidedMaterialNode.EmissiveTexture TUnlitMaterialNode.EmissiveTexture). }
    property Texture: TAbstractTextureNode read GetTexture write SetTexture;

    strict private FFdTextureTransform: TSFNode;
    { Internal wrapper for property @code(TextureTransform). This wrapper API may change, we advise to access simpler @code(TextureTransform) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTextureTransform: TSFNode read FFdTextureTransform;
    { Texture transformation. }
    property TextureTransform: TAbstractTextureTransformNode read GetTextureTransform write SetTextureTransform;

    strict private FFdBackMaterial: TSFNode;
    { Internal wrapper for property @code(BackMaterial). This wrapper API may change, we advise to access simpler @code(BackMaterial) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBackMaterial: TSFNode read FFdBackMaterial;
    { Alternative material to use for back faces (@italic(not implemented)). }
    property BackMaterial: TAbstractOneSidedMaterialNode read GetBackMaterial write SetBackMaterial;

    strict private FFdAlphaMode: TSFStringEnum;
    { Internal wrapper for property @code(AlphaMode). This wrapper API may change, we advise to access simpler @code(AlphaMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaMode: TSFStringEnum read FFdAlphaMode;
    {  }
    property AlphaMode: TAlphaMode read GetAlphaMode write SetAlphaMode;

    strict private FFdAlphaCutoff: TSFFloat;
    { Internal wrapper for property @code(AlphaCutoff). This wrapper API may change, we advise to access simpler @code(AlphaCutoff) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaCutoff: TSFFloat read FFdAlphaCutoff;
    {  }
    property AlphaCutoff: Single read GetAlphaCutoff write SetAlphaCutoff;

    strict private FFdReceiveShadows: TMFNode;
    { Internal wrapper for property @code(ReceiveShadows). This wrapper API may change, we advise to access simpler @code(ReceiveShadows) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReceiveShadows: TMFNode read FFdReceiveShadows;
    {  }
    procedure SetReceiveShadows(const Value: array of TAbstractPunctualLightNode);

    strict private FFdShadowCaster: TSFBool;
    { Internal wrapper for property @code(ShadowCaster). This wrapper API may change, we advise to access simpler @code(ShadowCaster) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShadowCaster: TSFBool read FFdShadowCaster;
    {  }
    property ShadowCaster: Boolean read GetShadowCaster write SetShadowCaster;

    strict private FFdNormalMap: TSFNode;
    { Internal wrapper for property @code(NormalMap). This wrapper API may change, we advise to access simpler @code(NormalMap) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalMap: TSFNode read FFdNormalMap;
    { Normal map of this appearance. See https://castle-engine.io/x3d_implementation_texturing_extensions.php }
    property NormalMap: TAbstractTexture2DNode read GetNormalMap write SetNormalMap;

{$ifndef CASTLE_SLIM_NODES}
    strict private FFdHeightMap: TSFNode;
    { Internal wrapper for property @code(HeightMap). This wrapper API may change, we advise to access simpler @code(HeightMap) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeightMap: TSFNode read FFdHeightMap;
{$endif not CASTLE_SLIM_NODES}
{$ifndef CASTLE_SLIM_NODES}
    { Height map of this appearance. See https://castle-engine.io/x3d_implementation_texturing_extensions.php }
    property HeightMap: TAbstractTexture2DNode read GetHeightMap write SetHeightMap;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdHeightMapScale: TSFFloat;
    { Internal wrapper for property @code(HeightMapScale). This wrapper API may change, we advise to access simpler @code(HeightMapScale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeightMapScale: TSFFloat read FFdHeightMapScale;
    {  }
    property HeightMapScale: Single read GetHeightMapScale write SetHeightMapScale;

    strict private FFdBlendMode: TSFNode;
    { Internal wrapper for property @code(BlendMode). This wrapper API may change, we advise to access simpler @code(BlendMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBlendMode: TSFNode read FFdBlendMode;
    { Determines the exact blending equation used, in case @link(AlphaMode) indicates blending. See https://castle-engine.io/x3d_extensions.php }
    property BlendMode: TBlendModeNode read GetBlendMode write SetBlendMode;

    strict private FFdEffects: TMFNode;
    { Internal wrapper for property @code(Effects). This wrapper API may change, we advise to access simpler @code(Effects) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEffects: TMFNode read FFdEffects;
    { Additional shader code for rendering this shape. See https://castle-engine.io/compositing_shaders.php . The shader effects they are easy to use, cooperate with CGE built-in rendering features, and one code is more portable to both mobile and desktop. }
    procedure SetEffects(const Value: array of TEffectNode);

    strict private FFdAlphaChannel: TSFStringEnum;
    { Internal wrapper for property @code(AlphaChannel). This wrapper API may change, we advise to access simpler @code(AlphaChannel) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaChannel: TSFStringEnum read FFdAlphaChannel;
    {  }
    property AlphaChannel: TAutoAlphaChannel read GetAlphaChannel write SetAlphaChannel;

{$endif read_interface}

{$ifdef read_implementation}

{ TAppearanceNode ----------------------------------------------- }

{$ifndef CASTLE_SLIM_NODES}
function TAppearanceNode.GetFillProperties: TFillPropertiesNode;
begin
  if FdFillProperties.Value is TFillPropertiesNode then
    Result := TFillPropertiesNode(FdFillProperties.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetFillProperties(const Value: TFillPropertiesNode);
begin
  FdFillProperties.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TAppearanceNode.GetLineProperties: TLinePropertiesNode;
begin
  if FdLineProperties.Value is TLinePropertiesNode then
    Result := TLinePropertiesNode(FdLineProperties.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetLineProperties(const Value: TLinePropertiesNode);
begin
  FdLineProperties.Send(Value);
end;

function TAppearanceNode.GetMaterial: TAbstractMaterialNode;
begin
  if FdMaterial.Value is TAbstractMaterialNode then
    Result := TAbstractMaterialNode(FdMaterial.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetMaterial(const Value: TAbstractMaterialNode);
begin
  FdMaterial.Send(Value);
end;

procedure TAppearanceNode.SetShaders(const Value: array of TAbstractShaderNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractShaderNode));
  FdShaders.Send(A);
end;

function TAppearanceNode.GetTexture: TAbstractTextureNode;
begin
  if FdTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdTexture.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetTexture(const Value: TAbstractTextureNode);
begin
  FdTexture.Send(Value);
end;

function TAppearanceNode.GetTextureTransform: TAbstractTextureTransformNode;
begin
  if FdTextureTransform.Value is TAbstractTextureTransformNode then
    Result := TAbstractTextureTransformNode(FdTextureTransform.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetTextureTransform(const Value: TAbstractTextureTransformNode);
begin
  FdTextureTransform.Send(Value);
end;

function TAppearanceNode.GetBackMaterial: TAbstractOneSidedMaterialNode;
begin
  if FdBackMaterial.Value is TAbstractOneSidedMaterialNode then
    Result := TAbstractOneSidedMaterialNode(FdBackMaterial.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetBackMaterial(const Value: TAbstractOneSidedMaterialNode);
begin
  FdBackMaterial.Send(Value);
end;

function TAppearanceNode.GetAlphaMode: TAlphaMode;
begin
  Result := TAlphaMode(FdAlphaMode.EnumValue);
end;

procedure TAppearanceNode.SetAlphaMode(const Value: TAlphaMode);
begin
  FdAlphaMode.SendEnumValue(Ord(Value));
end;

function TAppearanceNode.GetAlphaCutoff: Single;
begin
  Result := FdAlphaCutoff.Value;
end;

procedure TAppearanceNode.SetAlphaCutoff(const Value: Single);
begin
  FdAlphaCutoff.Send(Value);
end;

procedure TAppearanceNode.SetReceiveShadows(const Value: array of TAbstractPunctualLightNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractPunctualLightNode));
  FdReceiveShadows.Send(A);
end;

function TAppearanceNode.GetShadowCaster: Boolean;
begin
  Result := FdShadowCaster.Value;
end;

procedure TAppearanceNode.SetShadowCaster(const Value: Boolean);
begin
  FdShadowCaster.Send(Value);
end;

function TAppearanceNode.GetNormalMap: TAbstractTexture2DNode;
begin
  if FdNormalMap.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdNormalMap.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetNormalMap(const Value: TAbstractTexture2DNode);
begin
  FdNormalMap.Send(Value);
end;

{$ifndef CASTLE_SLIM_NODES}
function TAppearanceNode.GetHeightMap: TAbstractTexture2DNode;
begin
  if FdHeightMap.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdHeightMap.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetHeightMap(const Value: TAbstractTexture2DNode);
begin
  FdHeightMap.Send(Value);
end;

{$endif not CASTLE_SLIM_NODES}
function TAppearanceNode.GetHeightMapScale: Single;
begin
  Result := FdHeightMapScale.Value;
end;

procedure TAppearanceNode.SetHeightMapScale(const Value: Single);
begin
  FdHeightMapScale.Send(Value);
end;

function TAppearanceNode.GetBlendMode: TBlendModeNode;
begin
  if FdBlendMode.Value is TBlendModeNode then
    Result := TBlendModeNode(FdBlendMode.Value)
  else
    Result := nil;
end;

procedure TAppearanceNode.SetBlendMode(const Value: TBlendModeNode);
begin
  FdBlendMode.Send(Value);
end;

procedure TAppearanceNode.SetEffects(const Value: array of TEffectNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TEffectNode));
  FdEffects.Send(A);
end;

function TAppearanceNode.GetAlphaChannel: TAutoAlphaChannel;
begin
  Result := TAutoAlphaChannel(FdAlphaChannel.EnumValue);
end;

procedure TAppearanceNode.SetAlphaChannel(const Value: TAutoAlphaChannel);
begin
  FdAlphaChannel.SendEnumValue(Ord(Value));
end;

class function TAppearanceNode.ClassX3DType: String;
begin
  Result := 'Appearance';
end;

procedure TAppearanceNode.CreateNode;
begin
  inherited;

{$ifndef CASTLE_SLIM_NODES}
  FFdFillProperties := TSFNode.Create(Self, True, 'fillProperties', [TFillPropertiesNode]);
   FdFillProperties.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFillProperties);
{$endif not CASTLE_SLIM_NODES}

  FFdLineProperties := TSFNode.Create(Self, True, 'lineProperties', [TLinePropertiesNode]);
   FdLineProperties.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLineProperties);

  FFdMaterial := TSFNode.Create(Self, True, 'material', [TAbstractMaterialNode]);
   FdMaterial.ChangeAlways := chEverything;
   FdMaterial.OnBeforeValueChange := {$ifdef FPC}@{$endif}MoveShapeAssociations;
  AddField(FFdMaterial);

  FFdShaders := TMFNode.Create(Self, True, 'shaders', [TAbstractShaderNode]);
   FdShaders.ChangeAlways := chEverything;
  AddField(FFdShaders);

  FFdTexture := TSFNode.Create(Self, True, 'texture', [TAbstractTextureNode]);
   FdTexture.ChangeAlways := chEverything;
  AddField(FFdTexture);

  FFdTextureTransform := TSFNode.Create(Self, True, 'textureTransform', [TAbstractTextureTransformNode]);
   FdTextureTransform.ChangeAlways := chEverything;
  AddField(FFdTextureTransform);

  FFdBackMaterial := TSFNode.Create(Self, True, 'backMaterial', [TAbstractOneSidedMaterialNode]);
   FdBackMaterial.ChangeAlways := chNone;
  AddField(FFdBackMaterial);

  FFdAlphaMode := TSFStringEnum.Create(Self, True, 'alphaMode', @AlphaModeToString, Ord(High(AlphaModeToString)) + 1, Ord(amAuto));
   FdAlphaMode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaMode);

  FFdAlphaCutoff := TSFFloat.Create(Self, True, 'alphaCutoff', 0.5);
   FdAlphaCutoff.ChangeAlways := chVisibleNonGeometry;
   FdAlphaCutoff.MustBeNonnegative := true;
  AddField(FFdAlphaCutoff);

  FFdReceiveShadows := TMFNode.Create(Self, False, 'receiveShadows', [TAbstractPunctualLightNode]);
   FdReceiveShadows.ChangeAlways := chShadowMaps;
  AddField(FFdReceiveShadows);

  FFdShadowCaster := TSFBool.Create(Self, True, 'shadowCaster', true);
   FdShadowCaster.ChangeAlways := chShadowCasters;
  AddField(FFdShadowCaster);

  FFdNormalMap := TSFNode.Create(Self, True, 'normalMap', [TAbstractTexture2DNode]);
   FdNormalMap.ChangeAlways := chEverything;
  AddField(FFdNormalMap);

{$ifndef CASTLE_SLIM_NODES}
  FFdHeightMap := TSFNode.Create(Self, True, 'heightMap', [TAbstractTexture2DNode]);
   FdHeightMap.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHeightMap);
{$endif not CASTLE_SLIM_NODES}

  FFdHeightMapScale := TSFFloat.Create(Self, True, 'heightMapScale', 0.01);
   FdHeightMapScale.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHeightMapScale);

  FFdBlendMode := TSFNode.Create(Self, True, 'blendMode', [TBlendModeNode]);
   FdBlendMode.ChangeAlways := chEverything;
  AddField(FFdBlendMode);

  FFdEffects := TMFNode.Create(Self, False, 'effects', [TEffectNode]);
   FdEffects.ChangeAlways := chEverything;
  AddField(FFdEffects);

  FFdAlphaChannel := TSFStringEnum.Create(Self, True, 'alphaChannel', @AlphaToString, Ord(High(AlphaToString)) + 1, Ord(acAuto));
   FdAlphaChannel.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaChannel);

  DefaultContainerField := 'appearance';
end;

{$endif read_implementation}
