{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdShaders: TMFNode;
    { Internal wrapper for property @code(Shaders). This wrapper API may change, we advise to access simpler @code(Shaders) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShaders: TMFNode read FFdShaders;
    { Shaders used to render background geometry. }
    procedure SetShaders(const Value: array of TAbstractShaderNode);

    strict private FFdEffects: TMFNode;
    { Internal wrapper for property @code(Effects). This wrapper API may change, we advise to access simpler @code(Effects) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEffects: TMFNode read FFdEffects;
    { Shader effects (see https://castle-engine.io/compositing_shaders.php) used to render background geometry. }
    procedure SetEffects(const Value: array of TEffectNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractBackgroundNode ----------------------------------------------- }

procedure TAbstractBackgroundNode.SetShaders(const Value: array of TAbstractShaderNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractShaderNode));
  FdShaders.Send(A);
end;

procedure TAbstractBackgroundNode.SetEffects(const Value: array of TEffectNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TEffectNode));
  FdEffects.Send(A);
end;

class function TAbstractBackgroundNode.ClassX3DType: String;
begin
  Result := 'X3DBackgroundNode';
end;

procedure TAbstractBackgroundNode.CreateNode;
begin
  inherited;

  FFdShaders := TMFNode.Create(Self, True, 'shaders', [TAbstractShaderNode]);
   FdShaders.ChangeAlways := chEverything;
  AddField(FFdShaders);

  FFdEffects := TMFNode.Create(Self, False, 'effects', [TEffectNode]);
   FdEffects.ChangeAlways := chEverything;
  AddField(FFdEffects);
end;

{$endif read_implementation}
