#compdef pylint

# This script was generated by crazy-complete.
# crazy-complete: A tool that creates robust and reliable autocompletion scripts for Bash, Fish and Zsh.
# For more information, visit: https://github.com/crazy-complete/crazy-complete

_pylint() {
  local -a args=(
    '(--full-documentation --generate-rcfile --generate-toml-config --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile --help -h)'{-h,--help}'[show this help message and exit]'
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output -h --rcfile)'--rcfile='[Specify a configuration file to load.]':RCFILE:_files
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --rcfile -h --output)'--output='[Specify an output file.]':OUTPUT:_files
    '(--full-documentation --generate-rcfile --generate-toml-config --help --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --help-msg)'--help-msg='[Display a help message for the given message id and exit. The value may be a comma separated list of message ids.]':HELP_MSG:' '
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs-enabled --long-help --output --rcfile -h --list-msgs)'--list-msgs"[Display a list of all pylint's messages divided by whether they are emittable with the given interpreter.]"
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --long-help --output --rcfile -h --list-msgs-enabled)'--list-msgs-enabled'[Display a list of what messages are enabled, disabled and non-emittable with the given configuration.]'
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --list-groups)'--list-groups"[List pylint's message groups.]"
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --list-conf-levels)'--list-conf-levels"[Generate pylint's confidence levels.]"
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --list-extensions)'--list-extensions'[List available extensions.]'
    '(--generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --full-documentation)'--full-documentation"[Generate pylint's full documentation.]"
    '(--full-documentation --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --generate-rcfile)'--generate-rcfile'[Generate a sample configuration file according to the current configuration. You can put other options before this one to get them in the generated configuration.]'
    '(--full-documentation --generate-rcfile --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --long-help --output --rcfile -h --generate-toml-config)'--generate-toml-config'[Generate a sample configuration file according to the current configuration. You can put other options before this one to get them in the generated configuration. The config is in the .toml format.]'
    '(--full-documentation --generate-rcfile --generate-toml-config --help --help-msg --list-conf-levels --list-extensions --list-groups --list-msgs --list-msgs-enabled --output --rcfile -h --long-help)'--long-help'[Show more verbose help.]'
    '(--init-hook)'--init-hook='[Python code to execute, usually for sys.path manipulation such as pygtk.require().]':INIT_HOOK:' '
    '(--errors-only -E)'{--errors-only,-E}'[In error mode, messages with a category besides ERROR or FATAL are suppressed, and no reports are done by default. Error mode is compatible with disabling specific errors.]'
    '(--verbose -v)'{--verbose,-v}'[In verbose mode, extra non-checker-related info will be displayed.]'
    '(--enable-all-extensions)'--enable-all-extensions'[Load and enable all available extensions. Use --list-extensions to see a list all available extensions.]'
    '(--ignore)'--ignore="[Files or directories to be skipped. They should be base names, not paths. (default\\: ('CVS',))]":'<file>[,<file>...]':' '
    '(--ignore-patterns)'--ignore-patterns="[Files or directories matching the regular expression patterns are skipped. The regex matches against base names, not paths. The default value ignores Emacs file locks (default\\: (re.compile('^\\\\.#'),))]":'<pattern>[,<pattern>...]':' '
    '(--ignore-paths)'--ignore-paths="[Add files or directories matching the regular expressions patterns to the ignore-list. The regex matches against paths and can be in Posix or Windows format. Because '\\\\' represents the directory delimiter on Windows systems, it can't be used as an escape character. (default\\: \\[\\])]":'<pattern>[,<pattern>...]':' '
    '(--persistent)'--persistent='[Pickle collected data for later comparisons. (default\: True)]':'<y or n>':'(y n)'
    '(--load-plugins)'--load-plugins='[List of plugins (as comma separated values of python module names) to load, usually to register additional checkers. (default\: ())]':'<modules>':' '
    '(--fail-under)'--fail-under='[Specify a score threshold under which the program will exit with error. (default\: 10)]':'<score>':' '
    '(--fail-on)'--fail-on='[Return non-zero exit code if any of these messages/categories are detected, even if score is above --fail-under value. Syntax same as enable. Messages specified are enabled, while categories only check already-enabled messages. (default\: )]':'<msg ids>':"_values -s , '<msg ids>' invalid-name disallowed-name typevar-name-incorrect-variance empty-docstring missing-module-docstring missing-class-docstring missing-function-docstring unnecessary-negation singleton-comparison unidiomatic-typecheck typevar-double-variance typevar-name-mismatch consider-using-enumerate consider-iterating-dictionary bad-classmethod-argument bad-mcs-method-argument bad-mcs-classmethod-argument single-string-used-for-slots consider-using-dict-items use-maxsplit-arg use-sequence-for-iteration consider-using-f-string line-too-long too-many-lines trailing-whitespace missing-final-newline trailing-newlines multiple-statements superfluous-parens mixed-line-endings unexpected-line-ending-format wrong-spelling-in-comment wrong-spelling-in-docstring invalid-characters-in-docstring multiple-imports wrong-import-order ungrouped-imports wrong-import-position useless-import-alias import-outside-toplevel use-implicit-booleaness-not-len use-implicit-booleaness-not-comparison use-implicit-booleaness-not-comparison-to-string use-implicit-booleaness-not-comparison-to-zero non-ascii-name non-ascii-module-import bad-file-encoding unnecessary-dunder-call unnecessary-lambda-assignment unnecessary-direct-lambda-call syntax-error unrecognized-inline-option bad-plugin-value bad-configuration-section unrecognized-option init-is-generator return-in-init function-redefined not-in-loop return-outside-function yield-outside-function nonexistent-operator duplicate-argument-name abstract-class-instantiated bad-reversed-sequence too-many-star-expressions invalid-star-assignment-target star-needs-assignment-target nonlocal-and-global continue-in-finally nonlocal-without-binding used-prior-global-declaration misplaced-format-function method-hidden access-member-before-definition no-method-argument no-self-argument invalid-slots-object assigning-non-slot invalid-slots inherit-non-class inconsistent-mro duplicate-bases class-variable-slots-conflict invalid-class-object invalid-enum-extension declare-non-slot non-iterator-returned unexpected-special-method-signature invalid-length-returned invalid-bool-returned invalid-index-returned invalid-repr-returned invalid-str-returned invalid-bytes-returned invalid-hash-returned invalid-length-hint-returned invalid-format-returned invalid-getnewargs-returned invalid-getnewargs-ex-returned import-error relative-beyond-top-level used-before-assignment undefined-variable undefined-all-variable invalid-all-object invalid-all-format possibly-used-before-assignment no-name-in-module unpacking-non-sequence potential-index-error bad-except-order raising-bad-type misplaced-bare-raise bad-exception-cause raising-non-exception notimplemented-raised catching-non-exception bad-super-call no-member not-callable assignment-from-no-return no-value-for-parameter too-many-function-args unexpected-keyword-arg redundant-keyword-arg missing-kwoa invalid-sequence-index invalid-slice-index assignment-from-none not-context-manager invalid-unary-operand-type unsupported-binary-operation repeated-keyword not-an-iterable not-a-mapping unsupported-membership-test unsubscriptable-object unsupported-assignment-operation unsupported-delete-operation invalid-metaclass dict-iter-missing-items await-outside-async unhashable-member invalid-slice-step logging-unsupported-format logging-format-truncated logging-too-many-args logging-too-few-args bad-format-character truncated-format-string mixed-format-string format-needs-mapping missing-format-string-key too-many-format-args too-few-format-args bad-string-format-type bad-str-strip-call invalid-envvar-value singledispatch-method singledispatchmethod-function yield-inside-async-function not-async-context-manager invalid-unicode-codec bidirectional-unicode invalid-character-backspace invalid-character-carriage-return invalid-character-sub invalid-character-esc invalid-character-nul invalid-character-zero-width-space positional-only-arguments-expected invalid-field-call modified-iterating-dict modified-iterating-set fatal astroid-error parse-error config-parse-error method-check-failed raw-checker-failed bad-inline-option locally-disabled file-ignored suppressed-message useless-suppression deprecated-pragma use-symbolic-message-instead c-extension-no-member useless-option-value literal-comparison comparison-with-itself comparison-of-constants no-classmethod-decorator no-staticmethod-decorator useless-object-inheritance property-with-parameters cyclic-import consider-using-from-import duplicate-code too-many-ancestors too-many-instance-attributes too-few-public-methods too-many-public-methods too-many-return-statements too-many-branches too-many-arguments too-many-locals too-many-statements too-many-boolean-expressions too-many-positional-arguments consider-merging-isinstance too-many-nested-blocks simplifiable-if-statement redefined-argument-from-local no-else-return consider-using-ternary trailing-comma-tuple stop-iteration-return simplify-boolean-expression inconsistent-return-statements useless-return consider-swap-variables consider-using-join consider-using-in consider-using-get chained-comparison consider-using-dict-comprehension consider-using-set-comprehension simplifiable-if-expression no-else-raise unnecessary-comprehension consider-using-sys-exit no-else-break no-else-continue super-with-arguments simplifiable-condition condition-evals-to-constant consider-using-generator use-a-generator consider-using-min-builtin consider-using-max-builtin consider-using-with unnecessary-dict-index-lookup use-list-literal use-dict-literal unnecessary-list-index-lookup use-yield-from unknown-option-value unreachable dangerous-default-value pointless-statement pointless-string-statement expression-not-assigned unnecessary-pass unnecessary-lambda duplicate-key useless-else-on-loop exec-used eval-used confusing-with-statement using-constant-test missing-parentheses-for-call-in-test self-assigning-variable redeclared-assigned-name assert-on-string-literal duplicate-value named-expr-without-context pointless-exception-statement return-in-finally contextmanager-generator-missing-cleanup comparison-with-callable lost-exception nan-comparison assert-on-tuple attribute-defined-outside-init bad-staticmethod-argument protected-access implicit-flag-alias arguments-differ signature-differs abstract-method super-init-not-called non-parent-init-called invalid-overridden-method arguments-renamed unused-private-member overridden-final-method subclassed-final-class redefined-slots-in-subclass super-without-brackets useless-parent-delegation unnecessary-semicolon bad-indentation wildcard-import reimported import-self preferred-module misplaced-future shadowed-import fixme global-variable-undefined global-variable-not-assigned global-statement global-at-module-level unused-import unused-variable unused-argument unused-wildcard-import redefined-outer-name redefined-builtin undefined-loop-variable unbalanced-tuple-unpacking cell-var-from-loop possibly-unused-variable self-cls-assignment unbalanced-dict-unpacking bare-except duplicate-except try-except-raise raise-missing-from binary-op-exception raising-format-tuple wrong-exception-operation broad-exception-caught broad-exception-raised keyword-arg-before-vararg arguments-out-of-order non-str-assignment-to-dunder-name isinstance-second-argument-not-valid-type kwarg-superseded-by-positional-arg logging-not-lazy logging-format-interpolation logging-fstring-interpolation bad-format-string-key unused-format-string-key bad-format-string missing-format-argument-key unused-format-string-argument format-combined-specification missing-format-attribute invalid-format-index duplicate-string-formatting-argument f-string-without-interpolation format-string-without-interpolation anomalous-backslash-in-string anomalous-unicode-escape-in-string implicit-str-concat inconsistent-quotes redundant-u-string-prefix bad-open-mode redundant-unittest-assert bad-thread-instantiation shallow-copy-environ invalid-envvar-default subprocess-popen-preexec-fn subprocess-run-check unspecified-encoding forgotten-debug-statement method-cache-max-size-none useless-with-lock unnecessary-ellipsis non-ascii-file-name using-f-string-in-unsupported-version using-final-decorator-in-unsupported-version using-exception-groups-in-unsupported-version using-generic-type-syntax-in-unsupported-version using-assignment-expression-in-unsupported-version using-positional-only-args-in-unsupported-version missing-timeout nested-min-max bad-chained-comparison modified-iterating-list deprecated-module deprecated-method deprecated-argument deprecated-class deprecated-decorator deprecated-attribute return-arg-in-generator boolean-datetime"
    '(--jobs -j)'{--jobs=,-j+}'[Use multiple processes to speed up Pylint. Specifying 0 will auto-detect the number of processors available to use, and will cap the count on Windows to avoid hangs. (default\: 1)]':'<n-processes>':' '
    '(--limit-inference-results)'--limit-inference-results='[Control the amount of potential inferred values when inferring a single object. This can help the performance when dealing with large functions or complex, nested conditions. (default\: 100)]':'<number-of-results>':' '
    '(--extension-pkg-allow-list)'--extension-pkg-allow-list='[A comma-separated list of package or module names from where C extensions may be loaded. Extensions are loading into the active Python interpreter and may run arbitrary code. (default\: \[\])]':'<pkg[,pkg]>':' '
    '(--extension-pkg-whitelist)'--extension-pkg-whitelist='[A comma-separated list of package or module names from where C extensions may be loaded. Extensions are loading into the active Python interpreter and may run arbitrary code. (This is an alternative name to extension-pkg-allow-list for backward compatibility.) (default\: \[\])]':'<pkg[,pkg]>':' '
    '(--suggestion-mode)'--suggestion-mode='[When enabled, pylint would attempt to guess common misconfiguration and emit user-friendly hints instead of false-positive error messages. (default\: True)]':'<y or n>':'(y n)'
    '(--exit-zero)'--exit-zero'[Always return a 0 (non-error) status code, even if lint errors are found. This is primarily useful in continuous integration scripts. (default\: False)]'
    '(--from-stdin)'--from-stdin'[Interpret the stdin as a python script, whose filename needs to be passed as the module_or_package argument. (default\: False)]'
    '(--source-roots)'--source-roots='[Add paths to the list of the source roots. Supports globbing patterns. The source root is an absolute path or a path relative to the current working directory used to determine a package namespace for modules located under the source root. (default\: ())]':'<path>[,<path>...]':' '
    '(--recursive)'--recursive='[Discover python modules and packages in the file system subtree. (default\: False)]':'<yn>':'(y n)'
    '(--py-version)'--py-version='[Minimum Python version to use for version dependent checks. Will default to the version used to run pylint. (default\: (3, 12))]':'<py_version>':' '
    '(--ignored-modules)'--ignored-modules='[List of module names for which member attributes should not be checked and will not be imported (useful for modules/projects where namespaces are manipulated during runtime and thus existing member attributes cannot be deduced by static analysis). It supports qualified module names, as well as Unix pattern matching. (default\: ())]':'<module names>':' '
    '(--analyse-fallback-blocks)'--analyse-fallback-blocks='[Analyse import fallback blocks. This can be used to support both Python 2 and 3 compatible code, which means that the block might have code that exists only in one or another interpreter, leading to false positives when analysed. (default\: False)]':'<y or n>':'(y n)'
    '(--clear-cache-post-run)'--clear-cache-post-run='[Clear in-memory caches upon conclusion of linting. Useful if running pylint in a server-like mode. (default\: False)]':'<y or n>':'(y n)'
    '(--prefer-stubs)'--prefer-stubs='[Resolve imports to .pyi stubs if available. May reduce no-member messages and increase not-an-iterable messages. (default\: False)]':'<y or n>':'(y n)'
    '(--output-format -f)'{--output-format=,-f+}'[Set the output format. Available formats are\: text, parseable, colorized, json2 (improved json format), json (old json format) and msvs (visual studio). You can also give a reporter class, e.g. mypackage.mymodule.MyReporterClass.]':'<format>':' '
    '(--reports -r)'{--reports=,-r+}'[Tells whether to display a full report or only the messages. (default\: False)]':'<y or n>':'(y n)'
    '(--evaluation)'--evaluation="[Python expression which should return a score less than or equal to 10. You have access to the variables 'fatal', 'error', 'warning', 'refactor', 'convention', and 'info' which contain the number of messages in each category, as well as 'statement' which is the total number of statements analyzed. This score is used by the global evaluation report (RP0004). (default\\: max(0, 0 if fatal else 10.0 - ((float(5 * error + warning + refactor + convention) / statement) * 10)))]":'<python_expression>':' '
    '(--score -s)'{--score=,-s+}'[Activate the evaluation score. (default\: True)]':'<y or n>':'(y n)'
    '(--msg-template)'--msg-template='[Template used to display messages. This is a python new-style format string used to format the message information. See doc for all details. (default\: )]':'<template>':' '
    '(--confidence)'--confidence="[Only show warnings with the listed confidence levels. Leave empty to show all. Valid levels\\: HIGH, CONTROL_FLOW, INFERENCE, INFERENCE_FAILURE, UNDEFINED. (default\\: \\['HIGH', 'CONTROL_FLOW', 'INFERENCE', 'INFERENCE_FAILURE', 'UNDEFINED'\\])]":'<levels>':' '
    '(--enable -e)'{--enable=,-e+}'[Enable the message, report, category or checker with the given id(s). You can either give multiple identifier separated by comma (,) or put this option multiple time (only on the command line, not in the configuration file where it should appear only once). See also the "--disable" option for examples.]':'<msg ids>':"_values -s , '<msg ids>' invalid-name disallowed-name typevar-name-incorrect-variance empty-docstring missing-module-docstring missing-class-docstring missing-function-docstring unnecessary-negation singleton-comparison unidiomatic-typecheck typevar-double-variance typevar-name-mismatch consider-using-enumerate consider-iterating-dictionary bad-classmethod-argument bad-mcs-method-argument bad-mcs-classmethod-argument single-string-used-for-slots consider-using-dict-items use-maxsplit-arg use-sequence-for-iteration consider-using-f-string line-too-long too-many-lines trailing-whitespace missing-final-newline trailing-newlines multiple-statements superfluous-parens mixed-line-endings unexpected-line-ending-format wrong-spelling-in-comment wrong-spelling-in-docstring invalid-characters-in-docstring multiple-imports wrong-import-order ungrouped-imports wrong-import-position useless-import-alias import-outside-toplevel use-implicit-booleaness-not-len use-implicit-booleaness-not-comparison use-implicit-booleaness-not-comparison-to-string use-implicit-booleaness-not-comparison-to-zero non-ascii-name non-ascii-module-import bad-file-encoding unnecessary-dunder-call unnecessary-lambda-assignment unnecessary-direct-lambda-call syntax-error unrecognized-inline-option bad-plugin-value bad-configuration-section unrecognized-option init-is-generator return-in-init function-redefined not-in-loop return-outside-function yield-outside-function nonexistent-operator duplicate-argument-name abstract-class-instantiated bad-reversed-sequence too-many-star-expressions invalid-star-assignment-target star-needs-assignment-target nonlocal-and-global continue-in-finally nonlocal-without-binding used-prior-global-declaration misplaced-format-function method-hidden access-member-before-definition no-method-argument no-self-argument invalid-slots-object assigning-non-slot invalid-slots inherit-non-class inconsistent-mro duplicate-bases class-variable-slots-conflict invalid-class-object invalid-enum-extension declare-non-slot non-iterator-returned unexpected-special-method-signature invalid-length-returned invalid-bool-returned invalid-index-returned invalid-repr-returned invalid-str-returned invalid-bytes-returned invalid-hash-returned invalid-length-hint-returned invalid-format-returned invalid-getnewargs-returned invalid-getnewargs-ex-returned import-error relative-beyond-top-level used-before-assignment undefined-variable undefined-all-variable invalid-all-object invalid-all-format possibly-used-before-assignment no-name-in-module unpacking-non-sequence potential-index-error bad-except-order raising-bad-type misplaced-bare-raise bad-exception-cause raising-non-exception notimplemented-raised catching-non-exception bad-super-call no-member not-callable assignment-from-no-return no-value-for-parameter too-many-function-args unexpected-keyword-arg redundant-keyword-arg missing-kwoa invalid-sequence-index invalid-slice-index assignment-from-none not-context-manager invalid-unary-operand-type unsupported-binary-operation repeated-keyword not-an-iterable not-a-mapping unsupported-membership-test unsubscriptable-object unsupported-assignment-operation unsupported-delete-operation invalid-metaclass dict-iter-missing-items await-outside-async unhashable-member invalid-slice-step logging-unsupported-format logging-format-truncated logging-too-many-args logging-too-few-args bad-format-character truncated-format-string mixed-format-string format-needs-mapping missing-format-string-key too-many-format-args too-few-format-args bad-string-format-type bad-str-strip-call invalid-envvar-value singledispatch-method singledispatchmethod-function yield-inside-async-function not-async-context-manager invalid-unicode-codec bidirectional-unicode invalid-character-backspace invalid-character-carriage-return invalid-character-sub invalid-character-esc invalid-character-nul invalid-character-zero-width-space positional-only-arguments-expected invalid-field-call modified-iterating-dict modified-iterating-set fatal astroid-error parse-error config-parse-error method-check-failed raw-checker-failed bad-inline-option locally-disabled file-ignored suppressed-message useless-suppression deprecated-pragma use-symbolic-message-instead c-extension-no-member useless-option-value literal-comparison comparison-with-itself comparison-of-constants no-classmethod-decorator no-staticmethod-decorator useless-object-inheritance property-with-parameters cyclic-import consider-using-from-import duplicate-code too-many-ancestors too-many-instance-attributes too-few-public-methods too-many-public-methods too-many-return-statements too-many-branches too-many-arguments too-many-locals too-many-statements too-many-boolean-expressions too-many-positional-arguments consider-merging-isinstance too-many-nested-blocks simplifiable-if-statement redefined-argument-from-local no-else-return consider-using-ternary trailing-comma-tuple stop-iteration-return simplify-boolean-expression inconsistent-return-statements useless-return consider-swap-variables consider-using-join consider-using-in consider-using-get chained-comparison consider-using-dict-comprehension consider-using-set-comprehension simplifiable-if-expression no-else-raise unnecessary-comprehension consider-using-sys-exit no-else-break no-else-continue super-with-arguments simplifiable-condition condition-evals-to-constant consider-using-generator use-a-generator consider-using-min-builtin consider-using-max-builtin consider-using-with unnecessary-dict-index-lookup use-list-literal use-dict-literal unnecessary-list-index-lookup use-yield-from unknown-option-value unreachable dangerous-default-value pointless-statement pointless-string-statement expression-not-assigned unnecessary-pass unnecessary-lambda duplicate-key useless-else-on-loop exec-used eval-used confusing-with-statement using-constant-test missing-parentheses-for-call-in-test self-assigning-variable redeclared-assigned-name assert-on-string-literal duplicate-value named-expr-without-context pointless-exception-statement return-in-finally contextmanager-generator-missing-cleanup comparison-with-callable lost-exception nan-comparison assert-on-tuple attribute-defined-outside-init bad-staticmethod-argument protected-access implicit-flag-alias arguments-differ signature-differs abstract-method super-init-not-called non-parent-init-called invalid-overridden-method arguments-renamed unused-private-member overridden-final-method subclassed-final-class redefined-slots-in-subclass super-without-brackets useless-parent-delegation unnecessary-semicolon bad-indentation wildcard-import reimported import-self preferred-module misplaced-future shadowed-import fixme global-variable-undefined global-variable-not-assigned global-statement global-at-module-level unused-import unused-variable unused-argument unused-wildcard-import redefined-outer-name redefined-builtin undefined-loop-variable unbalanced-tuple-unpacking cell-var-from-loop possibly-unused-variable self-cls-assignment unbalanced-dict-unpacking bare-except duplicate-except try-except-raise raise-missing-from binary-op-exception raising-format-tuple wrong-exception-operation broad-exception-caught broad-exception-raised keyword-arg-before-vararg arguments-out-of-order non-str-assignment-to-dunder-name isinstance-second-argument-not-valid-type kwarg-superseded-by-positional-arg logging-not-lazy logging-format-interpolation logging-fstring-interpolation bad-format-string-key unused-format-string-key bad-format-string missing-format-argument-key unused-format-string-argument format-combined-specification missing-format-attribute invalid-format-index duplicate-string-formatting-argument f-string-without-interpolation format-string-without-interpolation anomalous-backslash-in-string anomalous-unicode-escape-in-string implicit-str-concat inconsistent-quotes redundant-u-string-prefix bad-open-mode redundant-unittest-assert bad-thread-instantiation shallow-copy-environ invalid-envvar-default subprocess-popen-preexec-fn subprocess-run-check unspecified-encoding forgotten-debug-statement method-cache-max-size-none useless-with-lock unnecessary-ellipsis non-ascii-file-name using-f-string-in-unsupported-version using-final-decorator-in-unsupported-version using-exception-groups-in-unsupported-version using-generic-type-syntax-in-unsupported-version using-assignment-expression-in-unsupported-version using-positional-only-args-in-unsupported-version missing-timeout nested-min-max bad-chained-comparison modified-iterating-list deprecated-module deprecated-method deprecated-argument deprecated-class deprecated-decorator deprecated-attribute return-arg-in-generator boolean-datetime"
    '(--disable -d)'{--disable=,-d+}'[Disable the message, report, category or checker with the given id(s). You can either give multiple identifiers separated by comma (,) or put this option multiple times (only on the command line, not in the configuration file where it should appear only once). You can also use "--disable=all" to disable everything first and then re-enable specific checks. For example, if you want to run only the similarities checker, you can use "--disable=all --enable=similarities". If you want to run only the classes checker, but have no Warning level messages displayed, use "--disable=all --enable=classes --disable=W".]':'<msg ids>':"_values -s , '<msg ids>' invalid-name disallowed-name typevar-name-incorrect-variance empty-docstring missing-module-docstring missing-class-docstring missing-function-docstring unnecessary-negation singleton-comparison unidiomatic-typecheck typevar-double-variance typevar-name-mismatch consider-using-enumerate consider-iterating-dictionary bad-classmethod-argument bad-mcs-method-argument bad-mcs-classmethod-argument single-string-used-for-slots consider-using-dict-items use-maxsplit-arg use-sequence-for-iteration consider-using-f-string line-too-long too-many-lines trailing-whitespace missing-final-newline trailing-newlines multiple-statements superfluous-parens mixed-line-endings unexpected-line-ending-format wrong-spelling-in-comment wrong-spelling-in-docstring invalid-characters-in-docstring multiple-imports wrong-import-order ungrouped-imports wrong-import-position useless-import-alias import-outside-toplevel use-implicit-booleaness-not-len use-implicit-booleaness-not-comparison use-implicit-booleaness-not-comparison-to-string use-implicit-booleaness-not-comparison-to-zero non-ascii-name non-ascii-module-import bad-file-encoding unnecessary-dunder-call unnecessary-lambda-assignment unnecessary-direct-lambda-call syntax-error unrecognized-inline-option bad-plugin-value bad-configuration-section unrecognized-option init-is-generator return-in-init function-redefined not-in-loop return-outside-function yield-outside-function nonexistent-operator duplicate-argument-name abstract-class-instantiated bad-reversed-sequence too-many-star-expressions invalid-star-assignment-target star-needs-assignment-target nonlocal-and-global continue-in-finally nonlocal-without-binding used-prior-global-declaration misplaced-format-function method-hidden access-member-before-definition no-method-argument no-self-argument invalid-slots-object assigning-non-slot invalid-slots inherit-non-class inconsistent-mro duplicate-bases class-variable-slots-conflict invalid-class-object invalid-enum-extension declare-non-slot non-iterator-returned unexpected-special-method-signature invalid-length-returned invalid-bool-returned invalid-index-returned invalid-repr-returned invalid-str-returned invalid-bytes-returned invalid-hash-returned invalid-length-hint-returned invalid-format-returned invalid-getnewargs-returned invalid-getnewargs-ex-returned import-error relative-beyond-top-level used-before-assignment undefined-variable undefined-all-variable invalid-all-object invalid-all-format possibly-used-before-assignment no-name-in-module unpacking-non-sequence potential-index-error bad-except-order raising-bad-type misplaced-bare-raise bad-exception-cause raising-non-exception notimplemented-raised catching-non-exception bad-super-call no-member not-callable assignment-from-no-return no-value-for-parameter too-many-function-args unexpected-keyword-arg redundant-keyword-arg missing-kwoa invalid-sequence-index invalid-slice-index assignment-from-none not-context-manager invalid-unary-operand-type unsupported-binary-operation repeated-keyword not-an-iterable not-a-mapping unsupported-membership-test unsubscriptable-object unsupported-assignment-operation unsupported-delete-operation invalid-metaclass dict-iter-missing-items await-outside-async unhashable-member invalid-slice-step logging-unsupported-format logging-format-truncated logging-too-many-args logging-too-few-args bad-format-character truncated-format-string mixed-format-string format-needs-mapping missing-format-string-key too-many-format-args too-few-format-args bad-string-format-type bad-str-strip-call invalid-envvar-value singledispatch-method singledispatchmethod-function yield-inside-async-function not-async-context-manager invalid-unicode-codec bidirectional-unicode invalid-character-backspace invalid-character-carriage-return invalid-character-sub invalid-character-esc invalid-character-nul invalid-character-zero-width-space positional-only-arguments-expected invalid-field-call modified-iterating-dict modified-iterating-set fatal astroid-error parse-error config-parse-error method-check-failed raw-checker-failed bad-inline-option locally-disabled file-ignored suppressed-message useless-suppression deprecated-pragma use-symbolic-message-instead c-extension-no-member useless-option-value literal-comparison comparison-with-itself comparison-of-constants no-classmethod-decorator no-staticmethod-decorator useless-object-inheritance property-with-parameters cyclic-import consider-using-from-import duplicate-code too-many-ancestors too-many-instance-attributes too-few-public-methods too-many-public-methods too-many-return-statements too-many-branches too-many-arguments too-many-locals too-many-statements too-many-boolean-expressions too-many-positional-arguments consider-merging-isinstance too-many-nested-blocks simplifiable-if-statement redefined-argument-from-local no-else-return consider-using-ternary trailing-comma-tuple stop-iteration-return simplify-boolean-expression inconsistent-return-statements useless-return consider-swap-variables consider-using-join consider-using-in consider-using-get chained-comparison consider-using-dict-comprehension consider-using-set-comprehension simplifiable-if-expression no-else-raise unnecessary-comprehension consider-using-sys-exit no-else-break no-else-continue super-with-arguments simplifiable-condition condition-evals-to-constant consider-using-generator use-a-generator consider-using-min-builtin consider-using-max-builtin consider-using-with unnecessary-dict-index-lookup use-list-literal use-dict-literal unnecessary-list-index-lookup use-yield-from unknown-option-value unreachable dangerous-default-value pointless-statement pointless-string-statement expression-not-assigned unnecessary-pass unnecessary-lambda duplicate-key useless-else-on-loop exec-used eval-used confusing-with-statement using-constant-test missing-parentheses-for-call-in-test self-assigning-variable redeclared-assigned-name assert-on-string-literal duplicate-value named-expr-without-context pointless-exception-statement return-in-finally contextmanager-generator-missing-cleanup comparison-with-callable lost-exception nan-comparison assert-on-tuple attribute-defined-outside-init bad-staticmethod-argument protected-access implicit-flag-alias arguments-differ signature-differs abstract-method super-init-not-called non-parent-init-called invalid-overridden-method arguments-renamed unused-private-member overridden-final-method subclassed-final-class redefined-slots-in-subclass super-without-brackets useless-parent-delegation unnecessary-semicolon bad-indentation wildcard-import reimported import-self preferred-module misplaced-future shadowed-import fixme global-variable-undefined global-variable-not-assigned global-statement global-at-module-level unused-import unused-variable unused-argument unused-wildcard-import redefined-outer-name redefined-builtin undefined-loop-variable unbalanced-tuple-unpacking cell-var-from-loop possibly-unused-variable self-cls-assignment unbalanced-dict-unpacking bare-except duplicate-except try-except-raise raise-missing-from binary-op-exception raising-format-tuple wrong-exception-operation broad-exception-caught broad-exception-raised keyword-arg-before-vararg arguments-out-of-order non-str-assignment-to-dunder-name isinstance-second-argument-not-valid-type kwarg-superseded-by-positional-arg logging-not-lazy logging-format-interpolation logging-fstring-interpolation bad-format-string-key unused-format-string-key bad-format-string missing-format-argument-key unused-format-string-argument format-combined-specification missing-format-attribute invalid-format-index duplicate-string-formatting-argument f-string-without-interpolation format-string-without-interpolation anomalous-backslash-in-string anomalous-unicode-escape-in-string implicit-str-concat inconsistent-quotes redundant-u-string-prefix bad-open-mode redundant-unittest-assert bad-thread-instantiation shallow-copy-environ invalid-envvar-default subprocess-popen-preexec-fn subprocess-run-check unspecified-encoding forgotten-debug-statement method-cache-max-size-none useless-with-lock unnecessary-ellipsis non-ascii-file-name using-f-string-in-unsupported-version using-final-decorator-in-unsupported-version using-exception-groups-in-unsupported-version using-generic-type-syntax-in-unsupported-version using-assignment-expression-in-unsupported-version using-positional-only-args-in-unsupported-version missing-timeout nested-min-max bad-chained-comparison modified-iterating-list deprecated-module deprecated-method deprecated-argument deprecated-class deprecated-decorator deprecated-attribute return-arg-in-generator boolean-datetime"
    '(--min-similarity-lines)'--min-similarity-lines='[Minimum lines number of a similarity. (default\: 4)]':'<int>':' '
    '(--ignore-comments)'--ignore-comments='[Comments are removed from the similarity computation (default\: True)]':'<y or n>':'(y n)'
    '(--ignore-docstrings)'--ignore-docstrings='[Docstrings are removed from the similarity computation (default\: True)]':'<y or n>':'(y n)'
    '(--ignore-imports)'--ignore-imports='[Imports are removed from the similarity computation (default\: True)]':'<y or n>':'(y n)'
    '(--ignore-signatures)'--ignore-signatures='[Signatures are removed from the similarity computation (default\: True)]':'<y or n>':'(y n)'
    '(--ignore-on-opaque-inference)'--ignore-on-opaque-inference='[This flag controls whether pylint should warn about no-member and similar checks whenever an opaque object is returned when inferring. The inference can return multiple potential results while evaluating a Python object, but some branches might not be evaluated, which results in partial inference. In that case, it might be useful to still emit no-member and other checks for the rest of the inferred objects. (default\: True)]':'<y or n>':'(y n)'
    '(--mixin-class-rgx)'--mixin-class-rgx='[Regex pattern to define which classes are considered mixins. (default\: .*\[Mm\]ixin)]':'<regexp>':' '
    '(--ignore-mixin-members)'--ignore-mixin-members='[Tells whether missing members accessed in mixin class should be ignored. A class is considered mixin if its name matches the mixin-class-rgx option. (default\: True)]':'<y or n>':'(y n)'
    '(--ignored-checks-for-mixins)'--ignored-checks-for-mixins="[List of symbolic message names to ignore for Mixin members. (default\\: \\['no-member', 'not-async-context-manager', 'not-context-manager', 'attribute-defined-outside-init'\\])]":'<list of messages names>':' '
    '(--ignore-none)'--ignore-none='[Tells whether to warn about missing members when the owner of the attribute is inferred to be None. (default\: True)]':'<y or n>':'(y n)'
    '(--ignored-classes)'--ignored-classes="[List of class names for which member attributes should not be checked (useful for classes with dynamically set attributes). This supports the use of qualified names. (default\\: ('optparse.Values', 'thread._local', '_thread._local', 'argparse.Namespace'))]":'<members names>':' '
    '(--generated-members)'--generated-members="[List of members which are set dynamically and missed by pylint inference system, and so shouldn't trigger E1101 when accessed. Python regular expressions are accepted. (default\\: ())]":'<members names>':' '
    '(--contextmanager-decorators)'--contextmanager-decorators="[List of decorators that produce context managers, such as contextlib.contextmanager. Add to this list to register other decorators that produce valid context managers. (default\\: \\['contextlib.contextmanager'\\])]":'<decorator names>':' '
    '(--missing-member-hint-distance)'--missing-member-hint-distance='[The minimum edit distance a name should have in order to be considered a similar match for a missing member name. (default\: 1)]':'<member hint edit distance>':' '
    '(--missing-member-max-choices)'--missing-member-max-choices='[The total number of similar names that should be taken in consideration when showing a hint for a missing member. (default\: 1)]':'<member hint max choices>':' '
    '(--missing-member-hint)'--missing-member-hint='[Show a hint with possible names when a member name was not found. The aspect of finding the hint is based on edit distance. (default\: True)]':'<missing member hint>':' '
    '(--signature-mutators)'--signature-mutators='[List of decorators that change the signature of a decorated function. (default\: \[\])]':'<decorator names>':' '
    '(--notes)'--notes="[List of note tags to take in consideration, separated by a comma. (default\\: ('FIXME', 'XXX', 'TODO'))]":'<comma separated values>':' '
    '(--notes-rgx)'--notes-rgx='[Regular expression of note tags to take in consideration. (default\: )]':'<regexp>':' '
    '(--timeout-methods)'--timeout-methods="[List of qualified names (i.e., library.method) which require a timeout parameter e.g. 'requests.api.get,requests.api.post' (default\\: ('requests.api.delete', 'requests.api.get', 'requests.api.head', 'requests.api.options', 'requests.api.patch', 'requests.api.post', 'requests.api.put', 'requests.api.request'))]":'<comma separated list>':' '
    '(--spelling-dict)'--spelling-dict='[Spelling dictionary name. No available dictionaries \: You need to install both the python package and the system dependency for enchant to work. (default\: )]':'<dict name>':' '
    '(--spelling-ignore-words)'--spelling-ignore-words='[List of comma separated words that should not be checked. (default\: )]':'<comma separated words>':' '
    '(--spelling-private-dict-file)'--spelling-private-dict-file='[A path to a file that contains the private dictionary; one word per line. (default\: )]':'<path to file>':_files
    '(--spelling-store-unknown-words)'--spelling-store-unknown-words='[Tells whether to store unknown words to the private dictionary (see the --spelling-private-dict-file option) instead of raising a message. (default\: n)]':'<y or n>':'(y n)'
    '(--max-spelling-suggestions)'--max-spelling-suggestions='[Limits count of emitted suggestions for spelling mistakes. (default\: 4)]':N:' '
    '(--spelling-ignore-comment-directives)'--spelling-ignore-comment-directives='[List of comma separated words that should be considered directives if they appear at the beginning of a comment and should not be checked. (default\: fmt\: on,fmt\: off,noqa\:,noqa,nosec,isort\:skip,mypy\:)]':'<comma separated words>':' '
    '(--max-nested-blocks)'--max-nested-blocks='[Maximum number of nested blocks for function / method body (default\: 5)]':'<int>':' '
    '(--never-returning-functions)'--never-returning-functions="[Complete name of functions that never returns. When checking for inconsistent-return-statements if a never returning function is called then it will be considered as an explicit return statement and no message will be printed. (default\\: ('sys.exit', 'argparse.parse_error'))]":'<members names>':' '
    '(--suggest-join-with-non-empty-separator)'--suggest-join-with-non-empty-separator='[Let '"'"'consider-using-join'"'"' be raised when the separator to join on would be non-empty (resulting in expected fixes of the type\: ``"- " + " - ".join(items)``) (default\: True)]':'<y or n>':'(y n)'
    '(--check-str-concat-over-line-jumps)'--check-str-concat-over-line-jumps='[This flag controls whether the implicit-str-concat should generate a warning on implicit string concatenation in sequences defined over several lines. (default\: False)]':'<y or n>':'(y n)'
    '(--check-quote-consistency)'--check-quote-consistency='[This flag controls whether inconsistent-quotes generates a warning when the character used as a quote delimiter is used inconsistently within a module. (default\: False)]':'<y or n>':'(y n)'
    '(--max-args)'--max-args='[Maximum number of arguments for function / method. (default\: 5)]':'<int>':' '
    '(--max-positional-arguments)'--max-positional-arguments='[Maximum number of positional arguments for function / method. (default\: 5)]':'<int>':' '
    '(--max-locals)'--max-locals='[Maximum number of locals for function / method body. (default\: 15)]':'<int>':' '
    '(--max-returns)'--max-returns='[Maximum number of return / yield for function / method body. (default\: 6)]':'<int>':' '
    '(--max-branches)'--max-branches='[Maximum number of branch for function / method body. (default\: 12)]':'<int>':' '
    '(--max-statements)'--max-statements='[Maximum number of statements in function / method body. (default\: 50)]':'<int>':' '
    '(--max-parents)'--max-parents='[Maximum number of parents for a class (see R0901). (default\: 7)]':'<num>':' '
    '(--ignored-parents)'--ignored-parents='[List of qualified class names to ignore when counting class parents (see R0901) (default\: ())]':'<comma separated list of class names>':' '
    '(--max-attributes)'--max-attributes='[Maximum number of attributes for a class (see R0902). (default\: 7)]':'<num>':' '
    '(--min-public-methods)'--min-public-methods='[Minimum number of public methods for a class (see R0903). (default\: 2)]':'<num>':' '
    '(--max-public-methods)'--max-public-methods='[Maximum number of public methods for a class (see R0904). (default\: 20)]':'<num>':' '
    '(--max-bool-expr)'--max-bool-expr='[Maximum number of boolean expressions in an if statement (see R0916). (default\: 5)]':'<num>':' '
    '(--exclude-too-few-public-methods)'--exclude-too-few-public-methods='[List of regular expressions of class ancestor names to ignore when counting public methods (see R0903) (default\: \[\])]':'<pattern>[,<pattern>...]':' '
    '(--overgeneral-exceptions)'--overgeneral-exceptions="[Exceptions that will emit a warning when caught. (default\\: ('builtins.BaseException', 'builtins.Exception'))]":'<comma-separated class names>':' '
    '(--defining-attr-methods)'--defining-attr-methods="[List of method names used to declare (i.e. assign) instance attributes. (default\\: ('__init__', '__new__', 'setUp', 'asyncSetUp', '__post_init__'))]":'<method names>':' '
    '(--valid-classmethod-first-arg)'--valid-classmethod-first-arg="[List of valid names for the first argument in a class method. (default\\: ('cls',))]":'<argument names>':' '
    '(--valid-metaclass-classmethod-first-arg)'--valid-metaclass-classmethod-first-arg="[List of valid names for the first argument in a metaclass class method. (default\\: ('mcs',))]":'<argument names>':' '
    '(--exclude-protected)'--exclude-protected="[List of member names, which should be excluded from the protected access warning. (default\\: ('_asdict', '_fields', '_replace', '_source', '_make', 'os._exit'))]":'<protected access exclusions>':' '
    '(--check-protected-access-in-special-methods)'--check-protected-access-in-special-methods='[Warn about protected attribute access inside special methods (default\: False)]':'<y or n>':'(y n)'
    '(--max-line-length)'--max-line-length='[Maximum number of characters on a single line. (default\: 100)]':'<int>':' '
    '(--ignore-long-lines)'--ignore-long-lines='[Regexp for a line that is allowed to be longer than the limit. (default\: ^\s*(# )?<?https?\://\S+>?$)]':'<regexp>':' '
    '(--single-line-if-stmt)'--single-line-if-stmt='[Allow the body of an if to be on the same line as the test if there is no else. (default\: False)]':'<y or n>':'(y n)'
    '(--single-line-class-stmt)'--single-line-class-stmt='[Allow the body of a class to be on the same line as the declaration if body contains single statement. (default\: False)]':'<y or n>':'(y n)'
    '(--max-module-lines)'--max-module-lines='[Maximum number of lines in a module. (default\: 1000)]':'<int>':' '
    '(--indent-string)'--indent-string='[String used as indentation unit. This is usually " " (4 spaces) or "\t" (1 tab). (default\: )]':'<string>':' '
    '(--indent-after-paren)'--indent-after-paren='[Number of spaces of indent required inside a hanging or continued line. (default\: 4)]':'<int>':' '
    '(--expected-line-ending-format)'--expected-line-ending-format='[Expected format of line ending, e.g. empty (any line ending), LF or CRLF. (default\: )]':'<empty or LF or CRLF>':' '
    '(--good-names)'--good-names="[Good variable names which should always be accepted, separated by a comma. (default\\: ('i', 'j', 'k', 'ex', 'Run', '_'))]":'<names>':' '
    '(--good-names-rgxs)'--good-names-rgxs='[Good variable names regexes, separated by a comma. If names match any regex, they will always be accepted (default\: )]':'<names>':' '
    '(--bad-names)'--bad-names="[Bad variable names which should always be refused, separated by a comma. (default\\: ('foo', 'bar', 'baz', 'toto', 'tutu', 'tata'))]":'<names>':' '
    '(--bad-names-rgxs)'--bad-names-rgxs='[Bad variable names regexes, separated by a comma. If names match any regex, they will always be refused (default\: )]':'<names>':' '
    '(--name-group)'--name-group="[Colon-delimited sets of names that determine each other's naming style when the name regexes allow several styles. (default\\: ())]":'<name1\:name2>':' '
    '(--include-naming-hint)'--include-naming-hint='[Include a hint for the correct naming format with invalid-name. (default\: False)]':'<y or n>':'(y n)'
    '(--property-classes)'--property-classes="[List of decorators that produce properties, such as abc.abstractproperty. Add to this list to register other decorators that produce valid properties. These decorators are taken in consideration only for invalid-name. (default\\: ('abc.abstractproperty',))]":'<decorator names>':' '
    '(--argument-naming-style)'--argument-naming-style='[Naming style matching correct argument names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--argument-rgx)'--argument-rgx='[Regular expression matching correct argument names. Overrides argument-naming-style. If left empty, argument names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--attr-naming-style)'--attr-naming-style='[Naming style matching correct attribute names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--attr-rgx)'--attr-rgx='[Regular expression matching correct attribute names. Overrides attr-naming-style. If left empty, attribute names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--class-naming-style)'--class-naming-style='[Naming style matching correct class names. (default\: PascalCase)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--class-rgx)'--class-rgx='[Regular expression matching correct class names. Overrides class-naming-style. If left empty, class names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--class-attribute-naming-style)'--class-attribute-naming-style='[Naming style matching correct class attribute names. (default\: any)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--class-attribute-rgx)'--class-attribute-rgx='[Regular expression matching correct class attribute names. Overrides class-attribute-naming-style. If left empty, class attribute names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--class-const-naming-style)'--class-const-naming-style='[Naming style matching correct class constant names. (default\: UPPER_CASE)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--class-const-rgx)'--class-const-rgx='[Regular expression matching correct class constant names. Overrides class-const-naming-style. If left empty, class constant names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--const-naming-style)'--const-naming-style='[Naming style matching correct constant names. (default\: UPPER_CASE)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--const-rgx)'--const-rgx='[Regular expression matching correct constant names. Overrides const-naming-style. If left empty, constant names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--function-naming-style)'--function-naming-style='[Naming style matching correct function names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--function-rgx)'--function-rgx='[Regular expression matching correct function names. Overrides function-naming-style. If left empty, function names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--inlinevar-naming-style)'--inlinevar-naming-style='[Naming style matching correct inline iteration names. (default\: any)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--inlinevar-rgx)'--inlinevar-rgx='[Regular expression matching correct inline iteration names. Overrides inlinevar-naming-style. If left empty, inline iteration names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--method-naming-style)'--method-naming-style='[Naming style matching correct method names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--method-rgx)'--method-rgx='[Regular expression matching correct method names. Overrides method-naming-style. If left empty, method names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--module-naming-style)'--module-naming-style='[Naming style matching correct module names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--module-rgx)'--module-rgx='[Regular expression matching correct module names. Overrides module-naming-style. If left empty, module names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--typealias-rgx)'--typealias-rgx='[Regular expression matching correct type alias names. If left empty, type alias names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--typevar-rgx)'--typevar-rgx='[Regular expression matching correct type variable names. If left empty, type variable names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--variable-naming-style)'--variable-naming-style='[Naming style matching correct variable names. (default\: snake_case)]':'<style>':'(snake_case camelCase PascalCase UPPER_CASE any)'
    '(--variable-rgx)'--variable-rgx='[Regular expression matching correct variable names. Overrides variable-naming-style. If left empty, variable names will be checked with the set naming style. (default\: None)]':'<regexp>':' '
    '(--no-docstring-rgx)'--no-docstring-rgx="[Regular expression which should only match function or class names that do not require a docstring. (default\\: re.compile('^_'))]":'<regexp>':' '
    '(--docstring-min-length)'--docstring-min-length='[Minimum line length for functions/classes that require docstrings, shorter ones are exempt. (default\: -1)]':'<int>':' '
    '(--init-import)'--init-import='[Tells whether we should check for unused import in __init__ files. (default\: False)]':'<y or n>':'(y n)'
    '(--dummy-variables-rgx)'--dummy-variables-rgx='[A regular expression matching the name of dummy variables (i.e. expected to not be used). (default\: _+$|(_\[a-zA-Z0-9_\]*\[a-zA-Z0-9\]+?$)|dummy|^ignored_|^unused_)]':'<regexp>':' '
    '(--additional-builtins)'--additional-builtins='[List of additional names supposed to be defined in builtins. Remember that you should avoid defining new builtins when possible. (default\: ())]':'<comma separated list>':' '
    '(--callbacks)'--callbacks="[List of strings which can identify a callback function by name. A callback name must start or end with one of those strings. (default\\: ('cb_', '_cb'))]":'<callbacks>':' '
    '(--redefining-builtins-modules)'--redefining-builtins-modules="[List of qualified module names which can have objects that can redefine builtins. (default\\: ('six.moves', 'past.builtins', 'future.builtins', 'builtins', 'io'))]":'<comma separated list>':' '
    '(--ignored-argument-names)'--ignored-argument-names="[Argument names that match this expression will be ignored. (default\\: re.compile('_.*|^ignored_|^unused_'))]":'<regexp>':' '
    '(--allow-global-unused-variables)'--allow-global-unused-variables='[Tells whether unused global variables should be treated as a violation. (default\: True)]':'<y or n>':'(y n)'
    '(--allowed-redefined-builtins)'--allowed-redefined-builtins='[List of names allowed to shadow builtins (default\: ())]':'<comma separated list>':' '
    '(--deprecated-modules)'--deprecated-modules='[Deprecated modules which should not be used, separated by a comma. (default\: ())]':'<modules>':' '
    '(--preferred-modules)'--preferred-modules='[Couples of modules and preferred modules, separated by a comma. (default\: ())]':'<module\:preferred-module>':' '
    '(--import-graph)'--import-graph='[Output a graph (.gv or any supported image format) of all (i.e. internal and external) dependencies to the given file (report RP0402 must not be disabled). (default\: )]':'<file.gv>':_files
    '(--ext-import-graph)'--ext-import-graph='[Output a graph (.gv or any supported image format) of external dependencies to the given file (report RP0402 must not be disabled). (default\: )]':'<file.gv>':_files
    '(--int-import-graph)'--int-import-graph='[Output a graph (.gv or any supported image format) of internal dependencies to the given file (report RP0402 must not be disabled). (default\: )]':'<file.gv>':_files
    '(--known-standard-library)'--known-standard-library='[Force import order to recognize a module as part of the standard compatibility libraries. (default\: ())]':'<modules>':' '
    '(--known-third-party)'--known-third-party="[Force import order to recognize a module as part of a third party library. (default\\: ('enchant',))]":'<modules>':' '
    '(--allow-any-import-level)'--allow-any-import-level='[List of modules that can be imported at any level, not just the top level one. (default\: ())]':'<modules>':' '
    '(--allow-wildcard-with-all)'--allow-wildcard-with-all='[Allow wildcard imports from modules that define __all__. (default\: False)]':'<y or n>':'(y n)'
    '(--allow-reexport-from-package)'--allow-reexport-from-package='[Allow explicit reexports by alias from a package __init__. (default\: False)]':'<y or n>':'(y n)'
    '(--logging-modules)'--logging-modules="[Logging modules to check that the string format arguments are in logging function parameter format. (default\\: ('logging',))]":'<comma separated list>':' '
    '(--logging-format-style)'--logging-format-style='[The type of string formatting that logging methods do. `old` means using % formatting, `new` is for `{}` formatting. (default\: old)]':'<old (%) or new ({)>':'(new old)'
    '*':FILE:_files
  )
  _arguments -S -s -w "${args[@]}"
}

_pylint "$@"

# vim: ft=zsh ts=2 sts=2 sw=2 et