Module overview of package `curry-frontend`
===========================================

  * `Base`: Basic types and functions
      * `.CurryTypes` : Conversion of the type representation of
                        `Curry.Syntax.Type` into the representation of
                        `Base.Types`
      * `.Expr`       : Type class for computation of free and bound variables
      * `.Messages`   : Error messages
      * `.NestEnv`    : Nested environment
      * `.SCC`        : Computation of strongly connected components
      * `.ScopeEnv`   : TODO: old stuff
      * `.Subst`      : general substitution implementation
      * `.TopEnv`     : Top level environment
      * `.Types`      : internal representation of types
      * `.TypeSubst`  : type substitution
      * `.Typing`     : Type computation
      * `.Utils`      : auxiliary functions
  * `Checks`: Überprüfungen eines Curry-Moduls
      * `.ExportCheck`: Überprüfung der Exports (unbekannte Symbole etc.)
      * `.KindCheck`  : Überprüfung der Typkonstruktoren, Unterscheidung von
                        Typkonstruktoren und Variablen
      * `.PrecCheck`  : Umordnung des Syntaxbaumes entsprechend der
                        Operatorpräzedenzen
      * `.SyntaxCheck`: Überprüfung der Syntax, Umbenennung von Variablen
      * `.TypeCheck`  : Typüberprüfung
      * `.WarnCheck`  : Erzeugung von Warnungen
  * `Curry.AbstractCurry`: Definition of AbstractCurry
  * `Curry.Base`
      * `.Ident`       : Identifier (unqualified, qualified, module identifier)
      * `.LexComb`     : CPS lexer combinators
      * `.LLParseComb` : CPS parser combinators
      * `.Message`     : Error/Warning monad
      * `.Position`    : source code position
  * `Curry.ExtendedFlat`
      * `.CurryArithmetics`    :
      * `.EraseTypes`          :
      * `.Goodies`             :
      * `.InterfaceEquivalence`: Check the equality of two FlatCurry interfaces
      * `.LiftLetrec`          :
      * `.MonadicGoodies`      :
      * `.Type`                : Definition of ExtendedFlatCurry
      * `.TypeInference`       :
      * `.UnMutual`            :
  * `Curry.Files`
      * `.Filenames`: Curry file extensions and file name manipulation
      * `.PathUtils`: lookup/read/write of Curry files-Dateien
      * `.Unlit`    : unliteration of literate Curry
  * `Curry.FlatCurry`
      * `.Goodies`: Auxiliary functions for working with FlatCurry
      * `.Pretty` : Pretty printer for FlatCurry
      * `.Type`   : Definition of FlatCurry
  * `Curry.Syntax`: Curry AST and related functions
      * `.Lexer`     : Lexer for Curry
      * `.Parser`    : Parser for Curry
      * `.Pretty`    : Pretty-Printer for Curry
      * `.ShowModule`: artificial Show instance
      * `.Type`      : Definition of the abstract syntax tree
      * `.Utils`     : Auxiliary functions
  * `Env`: Umgebungen für die Kompilierung
      * `.Eval`           : Auswertungsannotationen
      * `.Interface`      : Importierte Interfaces
      * `.ModuleAlias`    : Aliase für Module
      * `.OpPrec`         : Operatorpräzedenzen
      * `.TypeConstructor`: Typkonstruktoren
      * `.Value`          : Werte (Funktionen, Konstruktoren, Labels)
  * `Files.CymakePath`: Pfad zur binary
  * `Generators`: Generatoren zur Code-Erzeugung
      * `GenAbstractCurry`: Erzeugung von AbstractCurry
      * `GenFlatCurry`    : Erzeugung von FlatCurry
  * `Html`: Dokumentation
      * `.CurrryHtml`    : Erzeugung einer HTML-Dokumentation
      * `.SyntaxColoring`: Hilfsfunktionen
  * `IL`: interne Zwischensprache (Intermediate Language)
      * `.Pretty`: Pretty-Printer für die Intermediate Language
      * `.Type`  : Intermediate Language
      * `.XML`   : XML-Darstellung der Intermediate Language
  * `Transformations`: Codetransformationen
      * `.CaseCompletion`: Vervollständigung von case-Ausdrücken
      * `.CurryToIL`     : Übersetzung von Curry in die Intermediate Language
      * `.Desugar`       : Übersetzung von syntaktischem Zucker
      * `.Lift`          : Lifting von lambda-Ausdrücken und lokalen Funktionen
      * `.Qual`          : Qualifizierung von Konstruktoren und Funktionen
      * `.Simplify`      : Code-Vereinfachung
  * `CompilerEnv`   : Sammlung von Informationen für die Kompilierung eines
                      Moduls
  * `CompilerOpts`  : Optionen für den Compiler
  * `CurryBuilder`  : Kompilierung eines Moduls inklusive Modulabhängigkeiten
  * `CurryDeps`     : Berechnung von Modulabhängigkeiten
  * `cymake`        : Command-line tool
  * `Exports`       : Erzeugung des Interfaces
  * `Frontend`      : API-Modul (to be removed)
  * `Imports`       : Import von Funktionen etc. aus Schnittstellen
  * `Interfaces`    : Laden der benötigten Schnittstellen
  * `Modules`       : Kompilierung eines einzelnen Moduls
  * `ModuleSummary` : Zusammenfassung eines Moduls (to be removed)
