/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/func_test_case.t.cpp
 *
 * @brief [LEVEL: beta] testing @ref diagnostics::unittest::Func_Test_Case
 *
 * $Id: func_test_case.t.cpp,v 1.9 2005/06/23 09:54:24 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/func_test_case.hpp>

#define TEST_COMPONENT_NAME Func_Test_Case
#define TEST_COMPONENT_NAMESPACE diagnostics::unittest

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;

void test_function(Test_Data & test_data) 
{
    // just to check for the call
    throw Test_Exception("xxx");
}

class Test_Function_Object
{
public:
    void operator()(Test_Data & test_data) const
    {
	// just to check for the call
	throw Test_Exception("xxx");
    }
};


/**
 * @brief [PRO] fct/normal: testing Composition from function.
 */
void composition_from_function(Test_Data & test_data) 
{
    Test_Case *t(create_func_test_case(&test_function,
				       "test_function",
				       3,
				       true,
				       true,
				       true,
				       true));
    TEST_THROWING_BLOCK_ENTER;
    t->run(test_data);
    TEST_THROWING_BLOCK_EXIT(Test_Exception);
    delete t;
}

/**
 * @brief [PRO] fct/normal: testing Composition from function.
 */
void composition_from_object(Test_Data & test_data) 
{
    Test_Case *t(create_func_test_case(Test_Function_Object(),
				       "test_function",
				       3,
				       true,
				       true,
				       true,
				       true));
    TEST_THROWING_BLOCK_ENTER;
    t->run(test_data);
    TEST_THROWING_BLOCK_EXIT(Test_Exception);
    delete t;
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&composition_from_function,LEVEL_PROD);
TEST_NORMAL_CASE(&composition_from_object,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
