/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __DUPLICATE_NAME_HPP_INCLUDED
#define __DUPLICATE_NAME_HPP_INCLUDED

#include "frontend/reporting/CompileError.hpp"

namespace ast {

//! name was declared more than once.
/** A given name was declared already in the current scope.
 */
class DuplicateName : public CompileError {
public:
	//! c'tor
	/** @param dupNode node where a symbol gets redefined.
	 *  @param referring previous definition of that name.
	 *  @param dName name of errorenous node.
	 */
	DuplicateName(
		const AstNode &dupNode,
		const AstNode &referring,
		std::string dName
		);

	//! write error to stream.
	/** @param stream write the compile error to this stream.
	 */
	virtual void put(std::ostream& stream) const;

protected:
	/** Location of previous declaration. */
	const Location firstLoc;
	/** name that was declared twice. */
	std::string name;
};

}; /* namespace ast */

#endif /* __DUPLICATE_NAME_HPP_INCLUDED */
