#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributers.

from fenrirscreenreader.core import debug
class command():
    def __init__(self):
        pass
    def initialize(self, environment):
        self.env = environment
    def shutdown(self):
        pass 
    def getDescription(self):
        return _('Enables or disables automatic reading of time after specified intervals')        
    
    def run(self):
        self.env['runtime']['settingsManager'].setSetting('time', 'enabled', str(not self.env['runtime']['settingsManager'].getSettingAsBool('time', 'enabled')))   
        if self.env['runtime']['settingsManager'].getSettingAsBool('time', 'enabled'): 
            self.env['runtime']['outputManager'].presentText(_("Automatic time announcement enabled"), soundIcon='', interrupt=True)
        else:
            self.env['runtime']['outputManager'].presentText(_("Automatic time announcement disabled"), soundIcon='', interrupt=True)                          
    
    def setCallback(self, callback):
        pass
