/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:07:33 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -dif -name hb_64 -include rdft/scalar/hb.h */

/*
 * This function contains 1038 FP additions, 644 FP multiplications,
 * (or, 520 additions, 126 multiplications, 518 fused multiply/add),
 * 192 stack variables, 15 constants, and 256 memory accesses
 */
#include "rdft/scalar/hb.h"

static void hb_64(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 126); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 126, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tv, Thy, T5B, T7n, Tey, TfP, TjB, Tkl, T2k, T6U, T2H, T7o, Tia, TiH, Tj8;
	       E Tk8, T5E, T6V, T9N, Tbz, T9Q, Tb7, Tev, Tgh, T8G, Tb6, T8N, TbA, TcU, TfO;
	       E Td5, Tgi, T10, Ti3, Tje, TjC, ThF, TiI, Tds, TeA, Tjb, TjD, Tdh, TeB, TfT;
	       E Tgl, TfW, Tgk, T39, T7r, T5H, T6Z, T8V, TbC, T9S, Tbb, T3A, T7q, T5G, T72;
	       E T92, TbD, T9T, Tbe, T1w, ThH, Tjq, Tke, Tjt, Tkf, ThO, TiK, Tec, TgT, Tfc;
	       E Tgb, Tel, TgU, Tfd, Tg8, T5a, T82, T83, T5n, T6i, T77, T7a, T6j, T9f, Tcb;
	       E Tcc, T9m, Tar, Tbj, Tbm, Tas, T21, ThQ, Tjj, Tkb, Tjm, Tkc, ThX, TiL, TdL;
	       E TgW, Tf9, Tg4, TdU, TgX, Tfa, Tg1, T4h, T7Z, T80, T4u, T6f, T7e, T7h, T6g;
	       E T9y, Tce, Tcf, T9F, Tau, Tbq, Tbt, Tav;
	       {
		    E T3, T6, T7, T5t, T24, Tes, Ter, T27, Ti4, T5w, Ta, TcR, Td, TcS, Te;
		    E T2d, Ti5, T5z, T5y, T2i, Tm, Td3, Ti7, T2p, T2u, T8I, Td0, T8H, Tt, TcY;
		    E Ti8, T2A, T2F, T8L, TcX, T8K;
		    {
			 E T1, T2, T4, T5;
			 T1 = cr[0];
			 T2 = ci[WS(rs, 31)];
			 T3 = T1 + T2;
			 T4 = cr[WS(rs, 16)];
			 T5 = ci[WS(rs, 15)];
			 T6 = T4 + T5;
			 T7 = T3 + T6;
			 T5t = T4 - T5;
			 T24 = T1 - T2;
		    }
		    {
			 E T25, T26, T5u, T5v;
			 T25 = ci[WS(rs, 47)];
			 T26 = cr[WS(rs, 48)];
			 Tes = T25 - T26;
			 T5u = ci[WS(rs, 63)];
			 T5v = cr[WS(rs, 32)];
			 Ter = T5u - T5v;
			 T27 = T25 + T26;
			 Ti4 = Ter + Tes;
			 T5w = T5u + T5v;
		    }
		    {
			 E T29, T2h, T2e, T2c;
			 {
			      E T8, T9, T2f, T2g;
			      T8 = cr[WS(rs, 8)];
			      T9 = ci[WS(rs, 23)];
			      Ta = T8 + T9;
			      T29 = T8 - T9;
			      T2f = ci[WS(rs, 39)];
			      T2g = cr[WS(rs, 56)];
			      T2h = T2f + T2g;
			      TcR = T2f - T2g;
			 }
			 {
			      E Tb, Tc, T2a, T2b;
			      Tb = ci[WS(rs, 7)];
			      Tc = cr[WS(rs, 24)];
			      Td = Tb + Tc;
			      T2e = Tb - Tc;
			      T2a = ci[WS(rs, 55)];
			      T2b = cr[WS(rs, 40)];
			      T2c = T2a + T2b;
			      TcS = T2a - T2b;
			 }
			 Te = Ta + Td;
			 T2d = T29 - T2c;
			 Ti5 = TcS + TcR;
			 T5z = T2e + T2h;
			 T5y = T29 + T2c;
			 T2i = T2e - T2h;
		    }
		    {
			 E Ti, T2l, T2t, Td1, Tl, T2q, T2o, Td2;
			 {
			      E Tg, Th, T2r, T2s;
			      Tg = cr[WS(rs, 4)];
			      Th = ci[WS(rs, 27)];
			      Ti = Tg + Th;
			      T2l = Tg - Th;
			      T2r = ci[WS(rs, 59)];
			      T2s = cr[WS(rs, 36)];
			      T2t = T2r + T2s;
			      Td1 = T2r - T2s;
			 }
			 {
			      E Tj, Tk, T2m, T2n;
			      Tj = cr[WS(rs, 20)];
			      Tk = ci[WS(rs, 11)];
			      Tl = Tj + Tk;
			      T2q = Tj - Tk;
			      T2m = ci[WS(rs, 43)];
			      T2n = cr[WS(rs, 52)];
			      T2o = T2m + T2n;
			      Td2 = T2m - T2n;
			 }
			 Tm = Ti + Tl;
			 Td3 = Td1 - Td2;
			 Ti7 = Td1 + Td2;
			 T2p = T2l - T2o;
			 T2u = T2q + T2t;
			 T8I = T2l + T2o;
			 Td0 = Ti - Tl;
			 T8H = T2t - T2q;
		    }
		    {
			 E Tp, T2w, T2E, TcV, Ts, T2B, T2z, TcW;
			 {
			      E Tn, To, T2C, T2D;
			      Tn = ci[WS(rs, 3)];
			      To = cr[WS(rs, 28)];
			      Tp = Tn + To;
			      T2w = Tn - To;
			      T2C = ci[WS(rs, 35)];
			      T2D = cr[WS(rs, 60)];
			      T2E = T2C + T2D;
			      TcV = T2C - T2D;
			 }
			 {
			      E Tq, Tr, T2x, T2y;
			      Tq = cr[WS(rs, 12)];
			      Tr = ci[WS(rs, 19)];
			      Ts = Tq + Tr;
			      T2B = Tq - Tr;
			      T2x = ci[WS(rs, 51)];
			      T2y = cr[WS(rs, 44)];
			      T2z = T2x + T2y;
			      TcW = T2x - T2y;
			 }
			 Tt = Tp + Ts;
			 TcY = Tp - Ts;
			 Ti8 = TcV + TcW;
			 T2A = T2w - T2z;
			 T2F = T2B - T2E;
			 T8L = T2w + T2z;
			 TcX = TcV - TcW;
			 T8K = T2B + T2E;
		    }
		    {
			 E Tf, Tu, T5x, T5A;
			 Tf = T7 + Te;
			 Tu = Tm + Tt;
			 Tv = Tf + Tu;
			 Thy = Tf - Tu;
			 T5x = T5t + T5w;
			 T5A = T5y - T5z;
			 T5B = FMA(KP707106781, T5A, T5x);
			 T7n = FNMS(KP707106781, T5A, T5x);
		    }
		    {
			 E Tew, Tex, Tjz, TjA;
			 Tew = Td0 - Td3;
			 Tex = TcY + TcX;
			 Tey = Tew - Tex;
			 TfP = Tew + Tex;
			 Tjz = Ti4 - Ti5;
			 TjA = Tm - Tt;
			 TjB = Tjz - TjA;
			 Tkl = TjA + Tjz;
		    }
		    {
			 E T28, T2j, T2v, T2G;
			 T28 = T24 - T27;
			 T2j = T2d + T2i;
			 T2k = FMA(KP707106781, T2j, T28);
			 T6U = FNMS(KP707106781, T2j, T28);
			 T2v = FNMS(KP414213562, T2u, T2p);
			 T2G = FMA(KP414213562, T2F, T2A);
			 T2H = T2v + T2G;
			 T7o = T2v - T2G;
		    }
		    {
			 E Ti6, Ti9, Tj6, Tj7;
			 Ti6 = Ti4 + Ti5;
			 Ti9 = Ti7 + Ti8;
			 Tia = Ti6 - Ti9;
			 TiH = Ti6 + Ti9;
			 Tj6 = T7 - Te;
			 Tj7 = Ti8 - Ti7;
			 Tj8 = Tj6 - Tj7;
			 Tk8 = Tj6 + Tj7;
		    }
		    {
			 E T5C, T5D, T9L, T9M;
			 T5C = FMA(KP414213562, T2p, T2u);
			 T5D = FNMS(KP414213562, T2A, T2F);
			 T5E = T5C + T5D;
			 T6V = T5D - T5C;
			 T9L = T5w - T5t;
			 T9M = T2d - T2i;
			 T9N = FMA(KP707106781, T9M, T9L);
			 Tbz = FNMS(KP707106781, T9M, T9L);
		    }
		    {
			 E T9O, T9P, Tet, Teu;
			 T9O = FMA(KP414213562, T8H, T8I);
			 T9P = FMA(KP414213562, T8K, T8L);
			 T9Q = T9O - T9P;
			 Tb7 = T9O + T9P;
			 Tet = Ter - Tes;
			 Teu = Ta - Td;
			 Tev = Tet - Teu;
			 Tgh = Teu + Tet;
		    }
		    {
			 E T8E, T8F, T8J, T8M;
			 T8E = T24 + T27;
			 T8F = T5y + T5z;
			 T8G = FNMS(KP707106781, T8F, T8E);
			 Tb6 = FMA(KP707106781, T8F, T8E);
			 T8J = FNMS(KP414213562, T8I, T8H);
			 T8M = FNMS(KP414213562, T8L, T8K);
			 T8N = T8J + T8M;
			 TbA = T8M - T8J;
		    }
		    {
			 E TcQ, TcT, TcZ, Td4;
			 TcQ = T3 - T6;
			 TcT = TcR - TcS;
			 TcU = TcQ - TcT;
			 TfO = TcQ + TcT;
			 TcZ = TcX - TcY;
			 Td4 = Td0 + Td3;
			 Td5 = TcZ - Td4;
			 Tgi = Td4 + TcZ;
		    }
	       }
	       {
		    E TC, Tdn, ThC, T3e, T3v, T8S, Tdk, T8P, TY, Tdf, ThA, T2S, T2X, T36, Tda;
		    E T35, TJ, Tdq, ThD, T3j, T3o, T3x, Tdl, T3w, TR, Tdc, Thz, T2N, T34, T8Z;
		    E Td9, T8W;
		    {
			 E Ty, T3r, T3u, Tdj, TB, T3a, T3d, Tdi;
			 {
			      E Tw, Tx, T3s, T3t;
			      Tw = cr[WS(rs, 2)];
			      Tx = ci[WS(rs, 29)];
			      Ty = Tw + Tx;
			      T3r = Tw - Tx;
			      T3s = ci[WS(rs, 45)];
			      T3t = cr[WS(rs, 50)];
			      T3u = T3s + T3t;
			      Tdj = T3s - T3t;
			 }
			 {
			      E Tz, TA, T3b, T3c;
			      Tz = cr[WS(rs, 18)];
			      TA = ci[WS(rs, 13)];
			      TB = Tz + TA;
			      T3a = Tz - TA;
			      T3b = ci[WS(rs, 61)];
			      T3c = cr[WS(rs, 34)];
			      T3d = T3b + T3c;
			      Tdi = T3b - T3c;
			 }
			 TC = Ty + TB;
			 Tdn = Ty - TB;
			 ThC = Tdi + Tdj;
			 T3e = T3a + T3d;
			 T3v = T3r - T3u;
			 T8S = T3r + T3u;
			 Tdk = Tdi - Tdj;
			 T8P = T3d - T3a;
		    }
		    {
			 E TU, T2O, T2W, Tdd, TX, T2T, T2R, Tde;
			 {
			      E TS, TT, T2U, T2V;
			      TS = cr[WS(rs, 6)];
			      TT = ci[WS(rs, 25)];
			      TU = TS + TT;
			      T2O = TS - TT;
			      T2U = ci[WS(rs, 41)];
			      T2V = cr[WS(rs, 54)];
			      T2W = T2U + T2V;
			      Tdd = T2U - T2V;
			 }
			 {
			      E TV, TW, T2P, T2Q;
			      TV = ci[WS(rs, 9)];
			      TW = cr[WS(rs, 22)];
			      TX = TV + TW;
			      T2T = TV - TW;
			      T2P = ci[WS(rs, 57)];
			      T2Q = cr[WS(rs, 38)];
			      T2R = T2P + T2Q;
			      Tde = T2P - T2Q;
			 }
			 TY = TU + TX;
			 Tdf = Tdd - Tde;
			 ThA = Tde + Tdd;
			 T2S = T2O + T2R;
			 T2X = T2T + T2W;
			 T36 = T2T - T2W;
			 Tda = TU - TX;
			 T35 = T2O - T2R;
		    }
		    {
			 E TF, T3f, T3n, Tdo, TI, T3k, T3i, Tdp;
			 {
			      E TD, TE, T3l, T3m;
			      TD = cr[WS(rs, 10)];
			      TE = ci[WS(rs, 21)];
			      TF = TD + TE;
			      T3f = TD - TE;
			      T3l = ci[WS(rs, 37)];
			      T3m = cr[WS(rs, 58)];
			      T3n = T3l + T3m;
			      Tdo = T3l - T3m;
			 }
			 {
			      E TG, TH, T3g, T3h;
			      TG = ci[WS(rs, 5)];
			      TH = cr[WS(rs, 26)];
			      TI = TG + TH;
			      T3k = TG - TH;
			      T3g = ci[WS(rs, 53)];
			      T3h = cr[WS(rs, 42)];
			      T3i = T3g + T3h;
			      Tdp = T3g - T3h;
			 }
			 TJ = TF + TI;
			 Tdq = Tdo - Tdp;
			 ThD = Tdp + Tdo;
			 T3j = T3f + T3i;
			 T3o = T3k + T3n;
			 T3x = T3k - T3n;
			 Tdl = TF - TI;
			 T3w = T3f - T3i;
		    }
		    {
			 E TN, T30, T33, Td8, TQ, T2J, T2M, Td7;
			 {
			      E TL, TM, T31, T32;
			      TL = ci[WS(rs, 1)];
			      TM = cr[WS(rs, 30)];
			      TN = TL + TM;
			      T30 = TL - TM;
			      T31 = ci[WS(rs, 49)];
			      T32 = cr[WS(rs, 46)];
			      T33 = T31 + T32;
			      Td8 = T31 - T32;
			 }
			 {
			      E TO, TP, T2K, T2L;
			      TO = cr[WS(rs, 14)];
			      TP = ci[WS(rs, 17)];
			      TQ = TO + TP;
			      T2J = TO - TP;
			      T2K = ci[WS(rs, 33)];
			      T2L = cr[WS(rs, 62)];
			      T2M = T2K + T2L;
			      Td7 = T2K - T2L;
			 }
			 TR = TN + TQ;
			 Tdc = TN - TQ;
			 Thz = Td7 + Td8;
			 T2N = T2J - T2M;
			 T34 = T30 - T33;
			 T8Z = T30 + T33;
			 Td9 = Td7 - Td8;
			 T8W = T2J + T2M;
		    }
		    {
			 E TK, TZ, Tdm, Tdr;
			 TK = TC + TJ;
			 TZ = TR + TY;
			 T10 = TK + TZ;
			 Ti3 = TK - TZ;
			 {
			      E Tjc, Tjd, ThB, ThE;
			      Tjc = TC - TJ;
			      Tjd = ThC - ThD;
			      Tje = Tjc + Tjd;
			      TjC = Tjc - Tjd;
			      ThB = Thz + ThA;
			      ThE = ThC + ThD;
			      ThF = ThB - ThE;
			      TiI = ThE + ThB;
			 }
			 Tdm = Tdk - Tdl;
			 Tdr = Tdn - Tdq;
			 Tds = FNMS(KP414213562, Tdr, Tdm);
			 TeA = FMA(KP414213562, Tdm, Tdr);
			 {
			      E Tj9, Tja, Tdb, Tdg;
			      Tj9 = Thz - ThA;
			      Tja = TR - TY;
			      Tjb = Tj9 - Tja;
			      TjD = Tja + Tj9;
			      Tdb = Td9 - Tda;
			      Tdg = Tdc - Tdf;
			      Tdh = FMA(KP414213562, Tdg, Tdb);
			      TeB = FNMS(KP414213562, Tdb, Tdg);
			 }
		    }
		    {
			 E TfR, TfS, TfU, TfV;
			 TfR = Tda + Td9;
			 TfS = Tdc + Tdf;
			 TfT = FNMS(KP414213562, TfS, TfR);
			 Tgl = FMA(KP414213562, TfR, TfS);
			 TfU = Tdl + Tdk;
			 TfV = Tdn + Tdq;
			 TfW = FMA(KP414213562, TfV, TfU);
			 Tgk = FNMS(KP414213562, TfU, TfV);
			 {
			      E T2Z, T6X, T38, T6Y, T2Y, T37;
			      T2Y = T2S - T2X;
			      T2Z = FMA(KP707106781, T2Y, T2N);
			      T6X = FNMS(KP707106781, T2Y, T2N);
			      T37 = T35 + T36;
			      T38 = FMA(KP707106781, T37, T34);
			      T6Y = FNMS(KP707106781, T37, T34);
			      T39 = FNMS(KP198912367, T38, T2Z);
			      T7r = FNMS(KP668178637, T6X, T6Y);
			      T5H = FMA(KP198912367, T2Z, T38);
			      T6Z = FMA(KP668178637, T6Y, T6X);
			 }
		    }
		    {
			 E T8R, Tb9, T8U, Tba, T8Q, T8T;
			 T8Q = T3x - T3w;
			 T8R = FNMS(KP707106781, T8Q, T8P);
			 Tb9 = FMA(KP707106781, T8Q, T8P);
			 T8T = T3j + T3o;
			 T8U = FNMS(KP707106781, T8T, T8S);
			 Tba = FMA(KP707106781, T8T, T8S);
			 T8V = FMA(KP668178637, T8U, T8R);
			 TbC = FMA(KP198912367, Tb9, Tba);
			 T9S = FNMS(KP668178637, T8R, T8U);
			 Tbb = FNMS(KP198912367, Tba, Tb9);
		    }
		    {
			 E T3q, T70, T3z, T71, T3p, T3y;
			 T3p = T3j - T3o;
			 T3q = FMA(KP707106781, T3p, T3e);
			 T70 = FNMS(KP707106781, T3p, T3e);
			 T3y = T3w + T3x;
			 T3z = FMA(KP707106781, T3y, T3v);
			 T71 = FNMS(KP707106781, T3y, T3v);
			 T3A = FMA(KP198912367, T3z, T3q);
			 T7q = FMA(KP668178637, T70, T71);
			 T5G = FNMS(KP198912367, T3q, T3z);
			 T72 = FNMS(KP668178637, T71, T70);
		    }
		    {
			 E T8Y, Tbc, T91, Tbd, T8X, T90;
			 T8X = T35 - T36;
			 T8Y = FNMS(KP707106781, T8X, T8W);
			 Tbc = FMA(KP707106781, T8X, T8W);
			 T90 = T2S + T2X;
			 T91 = FNMS(KP707106781, T90, T8Z);
			 Tbd = FMA(KP707106781, T90, T8Z);
			 T92 = FMA(KP668178637, T91, T8Y);
			 TbD = FMA(KP198912367, Tbc, Tbd);
			 T9T = FNMS(KP668178637, T8Y, T91);
			 Tbe = FNMS(KP198912367, Tbd, Tbc);
		    }
	       }
	       {
		    E T18, Ted, ThI, T4A, T5f, T9g, TdY, T95, T1u, Te4, ThM, T52, T57, T9c, Te1;
		    E T9b, T1f, Teg, ThJ, T4F, T4K, T5h, TdZ, T5g, T1n, Te9, ThL, T4R, T4W, T99;
		    E Te6, T98;
		    {
			 E T14, T5b, T5e, TdX, T17, T4w, T4z, TdW;
			 {
			      E T12, T13, T5c, T5d;
			      T12 = cr[WS(rs, 1)];
			      T13 = ci[WS(rs, 30)];
			      T14 = T12 + T13;
			      T5b = T12 - T13;
			      T5c = ci[WS(rs, 46)];
			      T5d = cr[WS(rs, 49)];
			      T5e = T5c + T5d;
			      TdX = T5c - T5d;
			 }
			 {
			      E T15, T16, T4x, T4y;
			      T15 = cr[WS(rs, 17)];
			      T16 = ci[WS(rs, 14)];
			      T17 = T15 + T16;
			      T4w = T15 - T16;
			      T4x = ci[WS(rs, 62)];
			      T4y = cr[WS(rs, 33)];
			      T4z = T4x + T4y;
			      TdW = T4x - T4y;
			 }
			 T18 = T14 + T17;
			 Ted = T14 - T17;
			 ThI = TdW + TdX;
			 T4A = T4w + T4z;
			 T5f = T5b - T5e;
			 T9g = T5b + T5e;
			 TdY = TdW - TdX;
			 T95 = T4z - T4w;
		    }
		    {
			 E T1q, T53, T56, Te3, T1t, T4Y, T51, Te2;
			 {
			      E T1o, T1p, T54, T55;
			      T1o = ci[WS(rs, 2)];
			      T1p = cr[WS(rs, 29)];
			      T1q = T1o + T1p;
			      T53 = T1o - T1p;
			      T54 = ci[WS(rs, 50)];
			      T55 = cr[WS(rs, 45)];
			      T56 = T54 + T55;
			      Te3 = T54 - T55;
			 }
			 {
			      E T1r, T1s, T4Z, T50;
			      T1r = cr[WS(rs, 13)];
			      T1s = ci[WS(rs, 18)];
			      T1t = T1r + T1s;
			      T4Y = T1r - T1s;
			      T4Z = ci[WS(rs, 34)];
			      T50 = cr[WS(rs, 61)];
			      T51 = T4Z + T50;
			      Te2 = T4Z - T50;
			 }
			 T1u = T1q + T1t;
			 Te4 = Te2 - Te3;
			 ThM = Te2 + Te3;
			 T52 = T4Y - T51;
			 T57 = T53 - T56;
			 T9c = T4Y + T51;
			 Te1 = T1q - T1t;
			 T9b = T53 + T56;
		    }
		    {
			 E T1b, T4B, T4J, Tee, T1e, T4G, T4E, Tef;
			 {
			      E T19, T1a, T4H, T4I;
			      T19 = cr[WS(rs, 9)];
			      T1a = ci[WS(rs, 22)];
			      T1b = T19 + T1a;
			      T4B = T19 - T1a;
			      T4H = ci[WS(rs, 38)];
			      T4I = cr[WS(rs, 57)];
			      T4J = T4H + T4I;
			      Tee = T4H - T4I;
			 }
			 {
			      E T1c, T1d, T4C, T4D;
			      T1c = ci[WS(rs, 6)];
			      T1d = cr[WS(rs, 25)];
			      T1e = T1c + T1d;
			      T4G = T1c - T1d;
			      T4C = ci[WS(rs, 54)];
			      T4D = cr[WS(rs, 41)];
			      T4E = T4C + T4D;
			      Tef = T4C - T4D;
			 }
			 T1f = T1b + T1e;
			 Teg = Tee - Tef;
			 ThJ = Tef + Tee;
			 T4F = T4B + T4E;
			 T4K = T4G + T4J;
			 T5h = T4G - T4J;
			 TdZ = T1b - T1e;
			 T5g = T4B - T4E;
		    }
		    {
			 E T1j, T4S, T4V, Te8, T1m, T4N, T4Q, Te7;
			 {
			      E T1h, T1i, T4T, T4U;
			      T1h = cr[WS(rs, 5)];
			      T1i = ci[WS(rs, 26)];
			      T1j = T1h + T1i;
			      T4S = T1h - T1i;
			      T4T = ci[WS(rs, 42)];
			      T4U = cr[WS(rs, 53)];
			      T4V = T4T + T4U;
			      Te8 = T4T - T4U;
			 }
			 {
			      E T1k, T1l, T4O, T4P;
			      T1k = cr[WS(rs, 21)];
			      T1l = ci[WS(rs, 10)];
			      T1m = T1k + T1l;
			      T4N = T1k - T1l;
			      T4O = ci[WS(rs, 58)];
			      T4P = cr[WS(rs, 37)];
			      T4Q = T4O + T4P;
			      Te7 = T4O - T4P;
			 }
			 T1n = T1j + T1m;
			 Te9 = Te7 - Te8;
			 ThL = Te7 + Te8;
			 T4R = T4N + T4Q;
			 T4W = T4S - T4V;
			 T99 = T4Q - T4N;
			 Te6 = T1j - T1m;
			 T98 = T4S + T4V;
		    }
		    {
			 E T1g, T1v, Tjo, Tjp;
			 T1g = T18 + T1f;
			 T1v = T1n + T1u;
			 T1w = T1g + T1v;
			 ThH = T1g - T1v;
			 Tjo = ThI - ThJ;
			 Tjp = T1n - T1u;
			 Tjq = Tjo - Tjp;
			 Tke = Tjp + Tjo;
		    }
		    {
			 E Tjr, Tjs, ThK, ThN;
			 Tjr = T18 - T1f;
			 Tjs = ThM - ThL;
			 Tjt = Tjr - Tjs;
			 Tkf = Tjr + Tjs;
			 ThK = ThI + ThJ;
			 ThN = ThL + ThM;
			 ThO = ThK - ThN;
			 TiK = ThK + ThN;
		    }
		    {
			 E Te0, Tg9, Teb, Tga, Te5, Tea;
			 Te0 = TdY - TdZ;
			 Tg9 = Ted + Teg;
			 Te5 = Te1 + Te4;
			 Tea = Te6 - Te9;
			 Teb = Te5 - Tea;
			 Tga = Tea + Te5;
			 Tec = FNMS(KP707106781, Teb, Te0);
			 TgT = FMA(KP707106781, Tga, Tg9);
			 Tfc = FMA(KP707106781, Teb, Te0);
			 Tgb = FNMS(KP707106781, Tga, Tg9);
		    }
		    {
			 E Teh, Tg6, Tek, Tg7, Tei, Tej;
			 Teh = Ted - Teg;
			 Tg6 = TdZ + TdY;
			 Tei = Te6 + Te9;
			 Tej = Te4 - Te1;
			 Tek = Tei - Tej;
			 Tg7 = Tei + Tej;
			 Tel = FNMS(KP707106781, Tek, Teh);
			 TgU = FMA(KP707106781, Tg7, Tg6);
			 Tfd = FMA(KP707106781, Tek, Teh);
			 Tg8 = FNMS(KP707106781, Tg7, Tg6);
		    }
		    {
			 E T4M, T78, T5j, T75, T59, T76, T5m, T79, T4L, T5i;
			 T4L = T4F - T4K;
			 T4M = FMA(KP707106781, T4L, T4A);
			 T78 = FNMS(KP707106781, T4L, T4A);
			 T5i = T5g + T5h;
			 T5j = FMA(KP707106781, T5i, T5f);
			 T75 = FNMS(KP707106781, T5i, T5f);
			 {
			      E T4X, T58, T5k, T5l;
			      T4X = FMA(KP414213562, T4W, T4R);
			      T58 = FNMS(KP414213562, T57, T52);
			      T59 = T4X + T58;
			      T76 = T4X - T58;
			      T5k = FNMS(KP414213562, T4R, T4W);
			      T5l = FMA(KP414213562, T52, T57);
			      T5m = T5k + T5l;
			      T79 = T5l - T5k;
			 }
			 T5a = FNMS(KP923879532, T59, T4M);
			 T82 = FMA(KP923879532, T79, T78);
			 T83 = FMA(KP923879532, T76, T75);
			 T5n = FNMS(KP923879532, T5m, T5j);
			 T6i = FMA(KP923879532, T59, T4M);
			 T77 = FNMS(KP923879532, T76, T75);
			 T7a = FNMS(KP923879532, T79, T78);
			 T6j = FMA(KP923879532, T5m, T5j);
		    }
		    {
			 E T97, Tbk, T9i, Tbh, T9e, Tbi, T9l, Tbl, T96, T9h;
			 T96 = T5h - T5g;
			 T97 = FNMS(KP707106781, T96, T95);
			 Tbk = FMA(KP707106781, T96, T95);
			 T9h = T4F + T4K;
			 T9i = FNMS(KP707106781, T9h, T9g);
			 Tbh = FMA(KP707106781, T9h, T9g);
			 {
			      E T9a, T9d, T9j, T9k;
			      T9a = FMA(KP414213562, T99, T98);
			      T9d = FMA(KP414213562, T9c, T9b);
			      T9e = T9a - T9d;
			      Tbi = T9a + T9d;
			      T9j = FNMS(KP414213562, T98, T99);
			      T9k = FNMS(KP414213562, T9b, T9c);
			      T9l = T9j + T9k;
			      Tbl = T9j - T9k;
			 }
			 T9f = FNMS(KP923879532, T9e, T97);
			 Tcb = FMA(KP923879532, Tbl, Tbk);
			 Tcc = FMA(KP923879532, Tbi, Tbh);
			 T9m = FMA(KP923879532, T9l, T9i);
			 Tar = FNMS(KP923879532, T9l, T9i);
			 Tbj = FNMS(KP923879532, Tbi, Tbh);
			 Tbm = FNMS(KP923879532, Tbl, Tbk);
			 Tas = FMA(KP923879532, T9e, T97);
		    }
	       }
	       {
		    E T1D, TdM, ThR, T3H, T4m, T9z, Tdx, T9o, T1Z, TdD, ThV, T49, T4e, T9s, TdA;
		    E T9r, T1K, TdP, ThS, T3M, T3R, T4o, Tdy, T4n, T1S, TdI, ThU, T3Y, T43, T9v;
		    E TdF, T9u;
		    {
			 E T1z, T4i, T4l, Tdw, T1C, T3D, T3G, Tdv;
			 {
			      E T1x, T1y, T4j, T4k;
			      T1x = ci[0];
			      T1y = cr[WS(rs, 31)];
			      T1z = T1x + T1y;
			      T4i = T1x - T1y;
			      T4j = ci[WS(rs, 48)];
			      T4k = cr[WS(rs, 47)];
			      T4l = T4j + T4k;
			      Tdw = T4j - T4k;
			 }
			 {
			      E T1A, T1B, T3E, T3F;
			      T1A = cr[WS(rs, 15)];
			      T1B = ci[WS(rs, 16)];
			      T1C = T1A + T1B;
			      T3D = T1A - T1B;
			      T3E = ci[WS(rs, 32)];
			      T3F = cr[WS(rs, 63)];
			      T3G = T3E + T3F;
			      Tdv = T3E - T3F;
			 }
			 T1D = T1z + T1C;
			 TdM = T1z - T1C;
			 ThR = Tdv + Tdw;
			 T3H = T3D - T3G;
			 T4m = T4i - T4l;
			 T9z = T4i + T4l;
			 Tdx = Tdv - Tdw;
			 T9o = T3D + T3G;
		    }
		    {
			 E T1V, T4a, T4d, TdC, T1Y, T45, T48, TdB;
			 {
			      E T1T, T1U, T4b, T4c;
			      T1T = ci[WS(rs, 4)];
			      T1U = cr[WS(rs, 27)];
			      T1V = T1T + T1U;
			      T4a = T1T - T1U;
			      T4b = ci[WS(rs, 52)];
			      T4c = cr[WS(rs, 43)];
			      T4d = T4b + T4c;
			      TdC = T4b - T4c;
			 }
			 {
			      E T1W, T1X, T46, T47;
			      T1W = cr[WS(rs, 11)];
			      T1X = ci[WS(rs, 20)];
			      T1Y = T1W + T1X;
			      T45 = T1W - T1X;
			      T46 = ci[WS(rs, 36)];
			      T47 = cr[WS(rs, 59)];
			      T48 = T46 + T47;
			      TdB = T46 - T47;
			 }
			 T1Z = T1V + T1Y;
			 TdD = TdB - TdC;
			 ThV = TdB + TdC;
			 T49 = T45 - T48;
			 T4e = T4a - T4d;
			 T9s = T45 + T48;
			 TdA = T1V - T1Y;
			 T9r = T4a + T4d;
		    }
		    {
			 E T1G, T3I, T3Q, TdN, T1J, T3N, T3L, TdO;
			 {
			      E T1E, T1F, T3O, T3P;
			      T1E = cr[WS(rs, 7)];
			      T1F = ci[WS(rs, 24)];
			      T1G = T1E + T1F;
			      T3I = T1E - T1F;
			      T3O = ci[WS(rs, 40)];
			      T3P = cr[WS(rs, 55)];
			      T3Q = T3O + T3P;
			      TdN = T3O - T3P;
			 }
			 {
			      E T1H, T1I, T3J, T3K;
			      T1H = ci[WS(rs, 8)];
			      T1I = cr[WS(rs, 23)];
			      T1J = T1H + T1I;
			      T3N = T1H - T1I;
			      T3J = ci[WS(rs, 56)];
			      T3K = cr[WS(rs, 39)];
			      T3L = T3J + T3K;
			      TdO = T3J - T3K;
			 }
			 T1K = T1G + T1J;
			 TdP = TdN - TdO;
			 ThS = TdO + TdN;
			 T3M = T3I + T3L;
			 T3R = T3N + T3Q;
			 T4o = T3N - T3Q;
			 Tdy = T1G - T1J;
			 T4n = T3I - T3L;
		    }
		    {
			 E T1O, T3Z, T42, TdH, T1R, T3U, T3X, TdG;
			 {
			      E T1M, T1N, T40, T41;
			      T1M = cr[WS(rs, 3)];
			      T1N = ci[WS(rs, 28)];
			      T1O = T1M + T1N;
			      T3Z = T1M - T1N;
			      T40 = ci[WS(rs, 44)];
			      T41 = cr[WS(rs, 51)];
			      T42 = T40 + T41;
			      TdH = T40 - T41;
			 }
			 {
			      E T1P, T1Q, T3V, T3W;
			      T1P = cr[WS(rs, 19)];
			      T1Q = ci[WS(rs, 12)];
			      T1R = T1P + T1Q;
			      T3U = T1P - T1Q;
			      T3V = ci[WS(rs, 60)];
			      T3W = cr[WS(rs, 35)];
			      T3X = T3V + T3W;
			      TdG = T3V - T3W;
			 }
			 T1S = T1O + T1R;
			 TdI = TdG - TdH;
			 ThU = TdG + TdH;
			 T3Y = T3U + T3X;
			 T43 = T3Z - T42;
			 T9v = T3U - T3X;
			 TdF = T1O - T1R;
			 T9u = T3Z + T42;
		    }
		    {
			 E T1L, T20, Tjh, Tji;
			 T1L = T1D + T1K;
			 T20 = T1S + T1Z;
			 T21 = T1L + T20;
			 ThQ = T1L - T20;
			 Tjh = ThR - ThS;
			 Tji = T1S - T1Z;
			 Tjj = Tjh - Tji;
			 Tkb = Tji + Tjh;
		    }
		    {
			 E Tjk, Tjl, ThT, ThW;
			 Tjk = T1D - T1K;
			 Tjl = ThV - ThU;
			 Tjm = Tjk - Tjl;
			 Tkc = Tjk + Tjl;
			 ThT = ThR + ThS;
			 ThW = ThU + ThV;
			 ThX = ThT - ThW;
			 TiL = ThT + ThW;
		    }
		    {
			 E Tdz, Tg2, TdK, Tg3, TdE, TdJ;
			 Tdz = Tdx - Tdy;
			 Tg2 = TdM + TdP;
			 TdE = TdA + TdD;
			 TdJ = TdF - TdI;
			 TdK = TdE - TdJ;
			 Tg3 = TdJ + TdE;
			 TdL = FNMS(KP707106781, TdK, Tdz);
			 TgW = FMA(KP707106781, Tg3, Tg2);
			 Tf9 = FMA(KP707106781, TdK, Tdz);
			 Tg4 = FNMS(KP707106781, Tg3, Tg2);
		    }
		    {
			 E TdQ, TfZ, TdT, Tg0, TdR, TdS;
			 TdQ = TdM - TdP;
			 TfZ = Tdy + Tdx;
			 TdR = TdF + TdI;
			 TdS = TdD - TdA;
			 TdT = TdR - TdS;
			 Tg0 = TdR + TdS;
			 TdU = FNMS(KP707106781, TdT, TdQ);
			 TgX = FMA(KP707106781, Tg0, TfZ);
			 Tfa = FMA(KP707106781, TdT, TdQ);
			 Tg1 = FNMS(KP707106781, Tg0, TfZ);
		    }
		    {
			 E T3T, T7f, T4q, T7c, T4g, T7d, T4t, T7g, T3S, T4p;
			 T3S = T3M - T3R;
			 T3T = FMA(KP707106781, T3S, T3H);
			 T7f = FNMS(KP707106781, T3S, T3H);
			 T4p = T4n + T4o;
			 T4q = FMA(KP707106781, T4p, T4m);
			 T7c = FNMS(KP707106781, T4p, T4m);
			 {
			      E T44, T4f, T4r, T4s;
			      T44 = FMA(KP414213562, T43, T3Y);
			      T4f = FNMS(KP414213562, T4e, T49);
			      T4g = T44 + T4f;
			      T7d = T44 - T4f;
			      T4r = FNMS(KP414213562, T3Y, T43);
			      T4s = FMA(KP414213562, T49, T4e);
			      T4t = T4r + T4s;
			      T7g = T4s - T4r;
			 }
			 T4h = FNMS(KP923879532, T4g, T3T);
			 T7Z = FMA(KP923879532, T7g, T7f);
			 T80 = FMA(KP923879532, T7d, T7c);
			 T4u = FNMS(KP923879532, T4t, T4q);
			 T6f = FMA(KP923879532, T4g, T3T);
			 T7e = FNMS(KP923879532, T7d, T7c);
			 T7h = FNMS(KP923879532, T7g, T7f);
			 T6g = FMA(KP923879532, T4t, T4q);
		    }
		    {
			 E T9q, Tbr, T9B, Tbo, T9x, Tbp, T9E, Tbs, T9p, T9A;
			 T9p = T4n - T4o;
			 T9q = FNMS(KP707106781, T9p, T9o);
			 Tbr = FMA(KP707106781, T9p, T9o);
			 T9A = T3M + T3R;
			 T9B = FNMS(KP707106781, T9A, T9z);
			 Tbo = FMA(KP707106781, T9A, T9z);
			 {
			      E T9t, T9w, T9C, T9D;
			      T9t = FMA(KP414213562, T9s, T9r);
			      T9w = FNMS(KP414213562, T9v, T9u);
			      T9x = T9t - T9w;
			      Tbp = T9w + T9t;
			      T9C = FMA(KP414213562, T9u, T9v);
			      T9D = FNMS(KP414213562, T9r, T9s);
			      T9E = T9C - T9D;
			      Tbs = T9C + T9D;
			 }
			 T9y = FNMS(KP923879532, T9x, T9q);
			 Tce = FMA(KP923879532, Tbs, Tbr);
			 Tcf = FMA(KP923879532, Tbp, Tbo);
			 T9F = FNMS(KP923879532, T9E, T9B);
			 Tau = FMA(KP923879532, T9E, T9B);
			 Tbq = FNMS(KP923879532, Tbp, Tbo);
			 Tbt = FNMS(KP923879532, Tbs, Tbr);
			 Tav = FMA(KP923879532, T9x, T9q);
		    }
	       }
	       {
		    E T11, T22, TiE, TiJ, TiM, TiN;
		    T11 = Tv + T10;
		    T22 = T1w + T21;
		    TiE = T11 - T22;
		    TiJ = TiH + TiI;
		    TiM = TiK + TiL;
		    TiN = TiJ - TiM;
		    cr[0] = T11 + T22;
		    ci[0] = TiJ + TiM;
		    {
			 E TiD, TiF, TiG, TiO;
			 TiD = W[62];
			 TiF = TiD * TiE;
			 TiG = W[63];
			 TiO = TiG * TiE;
			 cr[WS(rs, 32)] = FNMS(TiG, TiN, TiF);
			 ci[WS(rs, 32)] = FMA(TiD, TiN, TiO);
		    }
	       }
	       {
		    E TiS, Tj0, TiX, Tj3;
		    {
			 E TiQ, TiR, TiV, TiW;
			 TiQ = Tv - T10;
			 TiR = TiL - TiK;
			 TiS = TiQ - TiR;
			 Tj0 = TiQ + TiR;
			 TiV = TiH - TiI;
			 TiW = T1w - T21;
			 TiX = TiV - TiW;
			 Tj3 = TiW + TiV;
		    }
		    {
			 E TiT, TiY, TiP, TiU;
			 TiP = W[94];
			 TiT = TiP * TiS;
			 TiY = TiP * TiX;
			 TiU = W[95];
			 cr[WS(rs, 48)] = FNMS(TiU, TiX, TiT);
			 ci[WS(rs, 48)] = FMA(TiU, TiS, TiY);
		    }
		    {
			 E Tj1, Tj4, TiZ, Tj2;
			 TiZ = W[30];
			 Tj1 = TiZ * Tj0;
			 Tj4 = TiZ * Tj3;
			 Tj2 = W[31];
			 cr[WS(rs, 16)] = FNMS(Tj2, Tj3, Tj1);
			 ci[WS(rs, 16)] = FMA(Tj2, Tj0, Tj4);
		    }
	       }
	       {
		    E Tib, Tie, Tiy, Tiq, Ti0, TiB, Tii, Tiv;
		    Tib = Ti3 + Tia;
		    {
			 E Tio, Tic, Tid, Tip;
			 Tio = Thy - ThF;
			 Tic = ThH + ThO;
			 Tid = ThX - ThQ;
			 Tip = Tid - Tic;
			 Tie = Tic + Tid;
			 Tiy = FMA(KP707106781, Tip, Tio);
			 Tiq = FNMS(KP707106781, Tip, Tio);
		    }
		    {
			 E ThG, Tit, ThZ, Tiu, ThP, ThY;
			 ThG = Thy + ThF;
			 Tit = Tia - Ti3;
			 ThP = ThH - ThO;
			 ThY = ThQ + ThX;
			 ThZ = ThP + ThY;
			 Tiu = ThP - ThY;
			 Ti0 = FNMS(KP707106781, ThZ, ThG);
			 TiB = FMA(KP707106781, Tiu, Tit);
			 Tii = FMA(KP707106781, ThZ, ThG);
			 Tiv = FNMS(KP707106781, Tiu, Tit);
		    }
		    {
			 E Tir, Tiw, Tin, Tis;
			 Tin = W[110];
			 Tir = Tin * Tiq;
			 Tiw = Tin * Tiv;
			 Tis = W[111];
			 cr[WS(rs, 56)] = FNMS(Tis, Tiv, Tir);
			 ci[WS(rs, 56)] = FMA(Tis, Tiq, Tiw);
		    }
		    {
			 E Tiz, TiC, Tix, TiA;
			 Tix = W[46];
			 Tiz = Tix * Tiy;
			 TiC = Tix * TiB;
			 TiA = W[47];
			 cr[WS(rs, 24)] = FNMS(TiA, TiB, Tiz);
			 ci[WS(rs, 24)] = FMA(TiA, Tiy, TiC);
		    }
		    {
			 E Tif, Ti2, Tig, Thx, Ti1;
			 Tif = FNMS(KP707106781, Tie, Tib);
			 Ti2 = W[79];
			 Tig = Ti2 * Ti0;
			 Thx = W[78];
			 Ti1 = Thx * Ti0;
			 cr[WS(rs, 40)] = FNMS(Ti2, Tif, Ti1);
			 ci[WS(rs, 40)] = FMA(Thx, Tif, Tig);
		    }
		    {
			 E Til, Tik, Tim, Tih, Tij;
			 Til = FMA(KP707106781, Tie, Tib);
			 Tik = W[15];
			 Tim = Tik * Tii;
			 Tih = W[14];
			 Tij = Tih * Tii;
			 cr[WS(rs, 8)] = FNMS(Tik, Til, Tij);
			 ci[WS(rs, 8)] = FMA(Tih, Til, Tim);
		    }
	       }
	       {
		    E Tjw, Tk2, Tk5, TjF, TjI, TjU, TjZ, TjM;
		    {
			 E TjE, TjX, Tjg, TjS, TjG, TjH, TjT, Tjv, TjY, Tjf, Tjn, Tju;
			 TjE = TjC - TjD;
			 TjX = FNMS(KP707106781, TjE, TjB);
			 Tjf = Tjb - Tje;
			 Tjg = FMA(KP707106781, Tjf, Tj8);
			 TjS = FNMS(KP707106781, Tjf, Tj8);
			 TjG = FMA(KP414213562, Tjq, Tjt);
			 TjH = FNMS(KP414213562, Tjj, Tjm);
			 TjT = TjG + TjH;
			 Tjn = FMA(KP414213562, Tjm, Tjj);
			 Tju = FNMS(KP414213562, Tjt, Tjq);
			 Tjv = Tjn - Tju;
			 TjY = Tju + Tjn;
			 Tjw = FNMS(KP923879532, Tjv, Tjg);
			 Tk2 = FMA(KP923879532, TjT, TjS);
			 Tk5 = FMA(KP923879532, TjY, TjX);
			 TjF = FMA(KP707106781, TjE, TjB);
			 TjI = TjG - TjH;
			 TjU = FNMS(KP923879532, TjT, TjS);
			 TjZ = FNMS(KP923879532, TjY, TjX);
			 TjM = FMA(KP923879532, Tjv, Tjg);
		    }
		    {
			 E TjV, Tk0, TjR, TjW;
			 TjR = W[54];
			 TjV = TjR * TjU;
			 Tk0 = TjR * TjZ;
			 TjW = W[55];
			 cr[WS(rs, 28)] = FNMS(TjW, TjZ, TjV);
			 ci[WS(rs, 28)] = FMA(TjW, TjU, Tk0);
		    }
		    {
			 E Tk3, Tk6, Tk1, Tk4;
			 Tk1 = W[118];
			 Tk3 = Tk1 * Tk2;
			 Tk6 = Tk1 * Tk5;
			 Tk4 = W[119];
			 cr[WS(rs, 60)] = FNMS(Tk4, Tk5, Tk3);
			 ci[WS(rs, 60)] = FMA(Tk4, Tk2, Tk6);
		    }
		    {
			 E TjJ, Tjy, TjK, Tj5, Tjx;
			 TjJ = FNMS(KP923879532, TjI, TjF);
			 Tjy = W[87];
			 TjK = Tjy * Tjw;
			 Tj5 = W[86];
			 Tjx = Tj5 * Tjw;
			 cr[WS(rs, 44)] = FNMS(Tjy, TjJ, Tjx);
			 ci[WS(rs, 44)] = FMA(Tj5, TjJ, TjK);
		    }
		    {
			 E TjP, TjO, TjQ, TjL, TjN;
			 TjP = FMA(KP923879532, TjI, TjF);
			 TjO = W[23];
			 TjQ = TjO * TjM;
			 TjL = W[22];
			 TjN = TjL * TjM;
			 cr[WS(rs, 12)] = FNMS(TjO, TjP, TjN);
			 ci[WS(rs, 12)] = FMA(TjL, TjP, TjQ);
		    }
	       }
	       {
		    E Tki, TkK, TkN, Tkn, Tkq, TkC, TkH, Tku;
		    {
			 E Tkm, TkF, Tka, TkA, Tko, Tkp, TkB, Tkh, TkG, Tk9, Tkd, Tkg;
			 Tkm = Tje + Tjb;
			 TkF = FMA(KP707106781, Tkm, Tkl);
			 Tk9 = TjC + TjD;
			 Tka = FNMS(KP707106781, Tk9, Tk8);
			 TkA = FMA(KP707106781, Tk9, Tk8);
			 Tko = FNMS(KP414213562, Tke, Tkf);
			 Tkp = FMA(KP414213562, Tkb, Tkc);
			 TkB = Tko + Tkp;
			 Tkd = FNMS(KP414213562, Tkc, Tkb);
			 Tkg = FMA(KP414213562, Tkf, Tke);
			 Tkh = Tkd - Tkg;
			 TkG = Tkg + Tkd;
			 Tki = FNMS(KP923879532, Tkh, Tka);
			 TkK = FMA(KP923879532, TkB, TkA);
			 TkN = FMA(KP923879532, TkG, TkF);
			 Tkn = FNMS(KP707106781, Tkm, Tkl);
			 Tkq = Tko - Tkp;
			 TkC = FNMS(KP923879532, TkB, TkA);
			 TkH = FNMS(KP923879532, TkG, TkF);
			 Tku = FMA(KP923879532, Tkh, Tka);
		    }
		    {
			 E TkD, TkI, Tkz, TkE;
			 Tkz = W[70];
			 TkD = Tkz * TkC;
			 TkI = Tkz * TkH;
			 TkE = W[71];
			 cr[WS(rs, 36)] = FNMS(TkE, TkH, TkD);
			 ci[WS(rs, 36)] = FMA(TkE, TkC, TkI);
		    }
		    {
			 E TkL, TkO, TkJ, TkM;
			 TkJ = W[6];
			 TkL = TkJ * TkK;
			 TkO = TkJ * TkN;
			 TkM = W[7];
			 cr[WS(rs, 4)] = FNMS(TkM, TkN, TkL);
			 ci[WS(rs, 4)] = FMA(TkM, TkK, TkO);
		    }
		    {
			 E Tkr, Tkk, Tks, Tk7, Tkj;
			 Tkr = FNMS(KP923879532, Tkq, Tkn);
			 Tkk = W[103];
			 Tks = Tkk * Tki;
			 Tk7 = W[102];
			 Tkj = Tk7 * Tki;
			 cr[WS(rs, 52)] = FNMS(Tkk, Tkr, Tkj);
			 ci[WS(rs, 52)] = FMA(Tk7, Tkr, Tks);
		    }
		    {
			 E Tkx, Tkw, Tky, Tkt, Tkv;
			 Tkx = FMA(KP923879532, Tkq, Tkn);
			 Tkw = W[39];
			 Tky = Tkw * Tku;
			 Tkt = W[38];
			 Tkv = Tkt * Tku;
			 cr[WS(rs, 20)] = FNMS(Tkw, Tkx, Tkv);
			 ci[WS(rs, 20)] = FMA(Tkt, Tkx, Tky);
		    }
	       }
	       {
		    E T5q, T66, T69, T5J, T5M, T5Y, T63, T5Q;
		    {
			 E T5F, T5I, T61, T5K, T5L, T5X, T3C, T5W, T5p, T62;
			 T5F = FNMS(KP923879532, T5E, T5B);
			 T5I = T5G - T5H;
			 T61 = FNMS(KP980785280, T5I, T5F);
			 T5K = FMA(KP820678790, T5a, T5n);
			 T5L = FNMS(KP820678790, T4h, T4u);
			 T5X = T5K + T5L;
			 {
			      E T2I, T3B, T4v, T5o;
			      T2I = FNMS(KP923879532, T2H, T2k);
			      T3B = T39 - T3A;
			      T3C = FMA(KP980785280, T3B, T2I);
			      T5W = FNMS(KP980785280, T3B, T2I);
			      T4v = FMA(KP820678790, T4u, T4h);
			      T5o = FNMS(KP820678790, T5n, T5a);
			      T5p = T4v - T5o;
			      T62 = T5o + T4v;
			 }
			 T5q = FNMS(KP773010453, T5p, T3C);
			 T66 = FMA(KP773010453, T5X, T5W);
			 T69 = FMA(KP773010453, T62, T61);
			 T5J = FMA(KP980785280, T5I, T5F);
			 T5M = T5K - T5L;
			 T5Y = FNMS(KP773010453, T5X, T5W);
			 T63 = FNMS(KP773010453, T62, T61);
			 T5Q = FMA(KP773010453, T5p, T3C);
		    }
		    {
			 E T5Z, T64, T5V, T60;
			 T5V = W[48];
			 T5Z = T5V * T5Y;
			 T64 = T5V * T63;
			 T60 = W[49];
			 cr[WS(rs, 25)] = FNMS(T60, T63, T5Z);
			 ci[WS(rs, 25)] = FMA(T60, T5Y, T64);
		    }
		    {
			 E T67, T6a, T65, T68;
			 T65 = W[112];
			 T67 = T65 * T66;
			 T6a = T65 * T69;
			 T68 = W[113];
			 cr[WS(rs, 57)] = FNMS(T68, T69, T67);
			 ci[WS(rs, 57)] = FMA(T68, T66, T6a);
		    }
		    {
			 E T5N, T5s, T5O, T23, T5r;
			 T5N = FNMS(KP773010453, T5M, T5J);
			 T5s = W[81];
			 T5O = T5s * T5q;
			 T23 = W[80];
			 T5r = T23 * T5q;
			 cr[WS(rs, 41)] = FNMS(T5s, T5N, T5r);
			 ci[WS(rs, 41)] = FMA(T23, T5N, T5O);
		    }
		    {
			 E T5T, T5S, T5U, T5P, T5R;
			 T5T = FMA(KP773010453, T5M, T5J);
			 T5S = W[17];
			 T5U = T5S * T5Q;
			 T5P = W[16];
			 T5R = T5P * T5Q;
			 cr[WS(rs, 9)] = FNMS(T5S, T5T, T5R);
			 ci[WS(rs, 9)] = FMA(T5P, T5T, T5U);
		    }
	       }
	       {
		    E Tge, TgG, TgK, Tgr, Tgu, TgC, TgF, Tgx;
		    {
			 E Tg5, Tgc, Tgd, Tgj, Tgm, Tgn, TfY, TgA, Tgq, TgB;
			 Tg5 = FMA(KP668178637, Tg4, Tg1);
			 Tgc = FNMS(KP668178637, Tgb, Tg8);
			 Tgd = Tg5 - Tgc;
			 Tgj = FNMS(KP707106781, Tgi, Tgh);
			 Tgm = Tgk - Tgl;
			 Tgn = FMA(KP923879532, Tgm, Tgj);
			 {
			      E TfQ, TfX, Tgo, Tgp;
			      TfQ = FNMS(KP707106781, TfP, TfO);
			      TfX = TfT - TfW;
			      TfY = FMA(KP923879532, TfX, TfQ);
			      TgA = FNMS(KP923879532, TfX, TfQ);
			      Tgo = FMA(KP668178637, Tg8, Tgb);
			      Tgp = FNMS(KP668178637, Tg1, Tg4);
			      Tgq = Tgo - Tgp;
			      TgB = Tgo + Tgp;
			 }
			 Tge = FNMS(KP831469612, Tgd, TfY);
			 TgG = Tgc + Tg5;
			 TgK = FMA(KP831469612, TgB, TgA);
			 Tgr = FNMS(KP831469612, Tgq, Tgn);
			 Tgu = FMA(KP831469612, Tgd, TfY);
			 TgC = FNMS(KP831469612, TgB, TgA);
			 TgF = FNMS(KP923879532, Tgm, Tgj);
			 Tgx = FMA(KP831469612, Tgq, Tgn);
		    }
		    {
			 E Tgf, Tgs, TfN, Tgg;
			 TfN = W[82];
			 Tgf = TfN * Tge;
			 Tgs = TfN * Tgr;
			 Tgg = W[83];
			 cr[WS(rs, 42)] = FNMS(Tgg, Tgr, Tgf);
			 ci[WS(rs, 42)] = FMA(Tgg, Tge, Tgs);
		    }
		    {
			 E Tgv, Tgy, Tgt, Tgw;
			 Tgt = W[18];
			 Tgv = Tgt * Tgu;
			 Tgy = Tgt * Tgx;
			 Tgw = W[19];
			 cr[WS(rs, 10)] = FNMS(Tgw, Tgx, Tgv);
			 ci[WS(rs, 10)] = FMA(Tgw, Tgu, Tgy);
		    }
		    {
			 E TgH, TgE, TgI, Tgz, TgD;
			 TgH = FNMS(KP831469612, TgG, TgF);
			 TgE = W[51];
			 TgI = TgE * TgC;
			 Tgz = W[50];
			 TgD = Tgz * TgC;
			 cr[WS(rs, 26)] = FNMS(TgE, TgH, TgD);
			 ci[WS(rs, 26)] = FMA(Tgz, TgH, TgI);
		    }
		    {
			 E TgN, TgM, TgO, TgJ, TgL;
			 TgN = FMA(KP831469612, TgG, TgF);
			 TgM = W[115];
			 TgO = TgM * TgK;
			 TgJ = W[114];
			 TgL = TgJ * TgK;
			 cr[WS(rs, 58)] = FNMS(TgM, TgN, TgL);
			 ci[WS(rs, 58)] = FMA(TgJ, TgN, TgO);
		    }
	       }
	       {
		    E Th0, Ths, Thv, Th5, Th8, Thk, Thp, Thc;
		    {
			 E Th3, Th4, Thn, Th6, Th7, Thj, TgS, Thi, TgZ, Tho;
			 Th3 = FMA(KP707106781, Tgi, Tgh);
			 Th4 = TfW + TfT;
			 Thn = FNMS(KP923879532, Th4, Th3);
			 Th6 = FMA(KP198912367, TgT, TgU);
			 Th7 = FNMS(KP198912367, TgW, TgX);
			 Thj = Th7 - Th6;
			 {
			      E TgQ, TgR, TgV, TgY;
			      TgQ = FMA(KP707106781, TfP, TfO);
			      TgR = Tgk + Tgl;
			      TgS = FMA(KP923879532, TgR, TgQ);
			      Thi = FNMS(KP923879532, TgR, TgQ);
			      TgV = FNMS(KP198912367, TgU, TgT);
			      TgY = FMA(KP198912367, TgX, TgW);
			      TgZ = TgV + TgY;
			      Tho = TgV - TgY;
			 }
			 Th0 = FNMS(KP980785280, TgZ, TgS);
			 Ths = FMA(KP980785280, Thj, Thi);
			 Thv = FMA(KP980785280, Tho, Thn);
			 Th5 = FMA(KP923879532, Th4, Th3);
			 Th8 = Th6 + Th7;
			 Thk = FNMS(KP980785280, Thj, Thi);
			 Thp = FNMS(KP980785280, Tho, Thn);
			 Thc = FMA(KP980785280, TgZ, TgS);
		    }
		    {
			 E Thl, Thq, Thh, Thm;
			 Thh = W[98];
			 Thl = Thh * Thk;
			 Thq = Thh * Thp;
			 Thm = W[99];
			 cr[WS(rs, 50)] = FNMS(Thm, Thp, Thl);
			 ci[WS(rs, 50)] = FMA(Thm, Thk, Thq);
		    }
		    {
			 E Tht, Thw, Thr, Thu;
			 Thr = W[34];
			 Tht = Thr * Ths;
			 Thw = Thr * Thv;
			 Thu = W[35];
			 cr[WS(rs, 18)] = FNMS(Thu, Thv, Tht);
			 ci[WS(rs, 18)] = FMA(Thu, Ths, Thw);
		    }
		    {
			 E Th9, Th2, Tha, TgP, Th1;
			 Th9 = FNMS(KP980785280, Th8, Th5);
			 Th2 = W[67];
			 Tha = Th2 * Th0;
			 TgP = W[66];
			 Th1 = TgP * Th0;
			 cr[WS(rs, 34)] = FNMS(Th2, Th9, Th1);
			 ci[WS(rs, 34)] = FMA(TgP, Th9, Tha);
		    }
		    {
			 E Thf, The, Thg, Thb, Thd;
			 Thf = FMA(KP980785280, Th8, Th5);
			 The = W[3];
			 Thg = The * Thc;
			 Thb = W[2];
			 Thd = Thb * Thc;
			 cr[WS(rs, 2)] = FNMS(The, Thf, Thd);
			 ci[WS(rs, 2)] = FMA(Thb, Thf, Thg);
		    }
	       }
	       {
		    E T6m, T6O, T6R, T6r, T6u, T6G, T6L, T6y;
		    {
			 E T6p, T6q, T6J, T6s, T6t, T6F, T6e, T6E, T6l, T6K;
			 T6p = FMA(KP923879532, T5E, T5B);
			 T6q = T3A + T39;
			 T6J = FMA(KP980785280, T6q, T6p);
			 T6s = FNMS(KP098491403, T6i, T6j);
			 T6t = FMA(KP098491403, T6f, T6g);
			 T6F = T6s + T6t;
			 {
			      E T6c, T6d, T6h, T6k;
			      T6c = FMA(KP923879532, T2H, T2k);
			      T6d = T5G + T5H;
			      T6e = FNMS(KP980785280, T6d, T6c);
			      T6E = FMA(KP980785280, T6d, T6c);
			      T6h = FNMS(KP098491403, T6g, T6f);
			      T6k = FMA(KP098491403, T6j, T6i);
			      T6l = T6h - T6k;
			      T6K = T6k + T6h;
			 }
			 T6m = FNMS(KP995184726, T6l, T6e);
			 T6O = FMA(KP995184726, T6F, T6E);
			 T6R = FMA(KP995184726, T6K, T6J);
			 T6r = FNMS(KP980785280, T6q, T6p);
			 T6u = T6s - T6t;
			 T6G = FNMS(KP995184726, T6F, T6E);
			 T6L = FNMS(KP995184726, T6K, T6J);
			 T6y = FMA(KP995184726, T6l, T6e);
		    }
		    {
			 E T6H, T6M, T6D, T6I;
			 T6D = W[64];
			 T6H = T6D * T6G;
			 T6M = T6D * T6L;
			 T6I = W[65];
			 cr[WS(rs, 33)] = FNMS(T6I, T6L, T6H);
			 ci[WS(rs, 33)] = FMA(T6I, T6G, T6M);
		    }
		    {
			 E T6P, T6S, T6N, T6Q;
			 T6N = W[0];
			 T6P = T6N * T6O;
			 T6S = T6N * T6R;
			 T6Q = W[1];
			 cr[WS(rs, 1)] = FNMS(T6Q, T6R, T6P);
			 ci[WS(rs, 1)] = FMA(T6Q, T6O, T6S);
		    }
		    {
			 E T6v, T6o, T6w, T6b, T6n;
			 T6v = FNMS(KP995184726, T6u, T6r);
			 T6o = W[97];
			 T6w = T6o * T6m;
			 T6b = W[96];
			 T6n = T6b * T6m;
			 cr[WS(rs, 49)] = FNMS(T6o, T6v, T6n);
			 ci[WS(rs, 49)] = FMA(T6b, T6v, T6w);
		    }
		    {
			 E T6B, T6A, T6C, T6x, T6z;
			 T6B = FMA(KP995184726, T6u, T6r);
			 T6A = W[33];
			 T6C = T6A * T6y;
			 T6x = W[32];
			 T6z = T6x * T6y;
			 cr[WS(rs, 17)] = FNMS(T6A, T6B, T6z);
			 ci[WS(rs, 17)] = FMA(T6x, T6B, T6C);
		    }
	       }
	       {
		    E Tbw, Tc2, Tc5, TbF, TbI, TbU, TbZ, TbM;
		    {
			 E TbB, TbE, TbX, TbG, TbH, TbT, Tbg, TbS, Tbv, TbY;
			 TbB = FMA(KP923879532, TbA, Tbz);
			 TbE = TbC - TbD;
			 TbX = FNMS(KP980785280, TbE, TbB);
			 TbG = FMA(KP820678790, Tbj, Tbm);
			 TbH = FMA(KP820678790, Tbq, Tbt);
			 TbT = TbG + TbH;
			 {
			      E Tb8, Tbf, Tbn, Tbu;
			      Tb8 = FNMS(KP923879532, Tb7, Tb6);
			      Tbf = Tbb + Tbe;
			      Tbg = FNMS(KP980785280, Tbf, Tb8);
			      TbS = FMA(KP980785280, Tbf, Tb8);
			      Tbn = FNMS(KP820678790, Tbm, Tbj);
			      Tbu = FNMS(KP820678790, Tbt, Tbq);
			      Tbv = Tbn + Tbu;
			      TbY = Tbn - Tbu;
			 }
			 Tbw = FNMS(KP773010453, Tbv, Tbg);
			 Tc2 = FMA(KP773010453, TbT, TbS);
			 Tc5 = FNMS(KP773010453, TbY, TbX);
			 TbF = FMA(KP980785280, TbE, TbB);
			 TbI = TbG - TbH;
			 TbU = FNMS(KP773010453, TbT, TbS);
			 TbZ = FMA(KP773010453, TbY, TbX);
			 TbM = FMA(KP773010453, Tbv, Tbg);
		    }
		    {
			 E TbV, Tc0, TbR, TbW;
			 TbR = W[44];
			 TbV = TbR * TbU;
			 Tc0 = TbR * TbZ;
			 TbW = W[45];
			 cr[WS(rs, 23)] = FNMS(TbW, TbZ, TbV);
			 ci[WS(rs, 23)] = FMA(TbW, TbU, Tc0);
		    }
		    {
			 E Tc3, Tc6, Tc1, Tc4;
			 Tc1 = W[108];
			 Tc3 = Tc1 * Tc2;
			 Tc6 = Tc1 * Tc5;
			 Tc4 = W[109];
			 cr[WS(rs, 55)] = FNMS(Tc4, Tc5, Tc3);
			 ci[WS(rs, 55)] = FMA(Tc4, Tc2, Tc6);
		    }
		    {
			 E TbJ, Tby, TbK, Tb5, Tbx;
			 TbJ = FNMS(KP773010453, TbI, TbF);
			 Tby = W[77];
			 TbK = Tby * Tbw;
			 Tb5 = W[76];
			 Tbx = Tb5 * Tbw;
			 cr[WS(rs, 39)] = FNMS(Tby, TbJ, Tbx);
			 ci[WS(rs, 39)] = FMA(Tb5, TbJ, TbK);
		    }
		    {
			 E TbP, TbO, TbQ, TbL, TbN;
			 TbP = FMA(KP773010453, TbI, TbF);
			 TbO = W[13];
			 TbQ = TbO * TbM;
			 TbL = W[12];
			 TbN = TbL * TbM;
			 cr[WS(rs, 7)] = FNMS(TbO, TbP, TbN);
			 ci[WS(rs, 7)] = FMA(TbL, TbP, TbQ);
		    }
	       }
	       {
		    E Tay, Tb0, Tb3, TaD, TaG, TaS, TaX, TaK;
		    {
			 E TaB, TaC, TaV, TaE, TaF, TaR, Taq, TaQ, Tax, TaW;
			 TaB = FMA(KP923879532, T9Q, T9N);
			 TaC = T8V - T92;
			 TaV = FNMS(KP831469612, TaC, TaB);
			 TaE = FMA(KP303346683, Tar, Tas);
			 TaF = FMA(KP303346683, Tau, Tav);
			 TaR = TaE + TaF;
			 {
			      E Tao, Tap, Tat, Taw;
			      Tao = FNMS(KP923879532, T8N, T8G);
			      Tap = T9S + T9T;
			      Taq = FMA(KP831469612, Tap, Tao);
			      TaQ = FNMS(KP831469612, Tap, Tao);
			      Tat = FNMS(KP303346683, Tas, Tar);
			      Taw = FNMS(KP303346683, Tav, Tau);
			      Tax = Tat + Taw;
			      TaW = Tat - Taw;
			 }
			 Tay = FNMS(KP956940335, Tax, Taq);
			 Tb0 = FMA(KP956940335, TaR, TaQ);
			 Tb3 = FNMS(KP956940335, TaW, TaV);
			 TaD = FMA(KP831469612, TaC, TaB);
			 TaG = TaE - TaF;
			 TaS = FNMS(KP956940335, TaR, TaQ);
			 TaX = FMA(KP956940335, TaW, TaV);
			 TaK = FMA(KP956940335, Tax, Taq);
		    }
		    {
			 E TaT, TaY, TaP, TaU;
			 TaP = W[36];
			 TaT = TaP * TaS;
			 TaY = TaP * TaX;
			 TaU = W[37];
			 cr[WS(rs, 19)] = FNMS(TaU, TaX, TaT);
			 ci[WS(rs, 19)] = FMA(TaU, TaS, TaY);
		    }
		    {
			 E Tb1, Tb4, TaZ, Tb2;
			 TaZ = W[100];
			 Tb1 = TaZ * Tb0;
			 Tb4 = TaZ * Tb3;
			 Tb2 = W[101];
			 cr[WS(rs, 51)] = FNMS(Tb2, Tb3, Tb1);
			 ci[WS(rs, 51)] = FMA(Tb2, Tb0, Tb4);
		    }
		    {
			 E TaH, TaA, TaI, Tan, Taz;
			 TaH = FNMS(KP956940335, TaG, TaD);
			 TaA = W[69];
			 TaI = TaA * Tay;
			 Tan = W[68];
			 Taz = Tan * Tay;
			 cr[WS(rs, 35)] = FNMS(TaA, TaH, Taz);
			 ci[WS(rs, 35)] = FMA(Tan, TaH, TaI);
		    }
		    {
			 E TaN, TaM, TaO, TaJ, TaL;
			 TaN = FMA(KP956940335, TaG, TaD);
			 TaM = W[5];
			 TaO = TaM * TaK;
			 TaJ = W[4];
			 TaL = TaJ * TaK;
			 cr[WS(rs, 3)] = FNMS(TaM, TaN, TaL);
			 ci[WS(rs, 3)] = FMA(TaJ, TaN, TaO);
		    }
	       }
	       {
		    E Tfg, TfI, TfL, Tfl, Tfo, TfA, TfF, Tfs;
		    {
			 E Tfj, Tfk, TfD, Tfm, Tfn, Tfz, Tf8, Tfy, Tff, TfE;
			 Tfj = FNMS(KP707106781, Tey, Tev);
			 Tfk = Tds + Tdh;
			 TfD = FMA(KP923879532, Tfk, Tfj);
			 Tfm = FMA(KP198912367, Tfc, Tfd);
			 Tfn = FNMS(KP198912367, Tf9, Tfa);
			 Tfz = Tfm + Tfn;
			 {
			      E Tf6, Tf7, Tfb, Tfe;
			      Tf6 = FNMS(KP707106781, Td5, TcU);
			      Tf7 = TeA + TeB;
			      Tf8 = FNMS(KP923879532, Tf7, Tf6);
			      Tfy = FMA(KP923879532, Tf7, Tf6);
			      Tfb = FMA(KP198912367, Tfa, Tf9);
			      Tfe = FNMS(KP198912367, Tfd, Tfc);
			      Tff = Tfb - Tfe;
			      TfE = Tfe + Tfb;
			 }
			 Tfg = FNMS(KP980785280, Tff, Tf8);
			 TfI = FMA(KP980785280, Tfz, Tfy);
			 TfL = FMA(KP980785280, TfE, TfD);
			 Tfl = FNMS(KP923879532, Tfk, Tfj);
			 Tfo = Tfm - Tfn;
			 TfA = FNMS(KP980785280, Tfz, Tfy);
			 TfF = FNMS(KP980785280, TfE, TfD);
			 Tfs = FMA(KP980785280, Tff, Tf8);
		    }
		    {
			 E TfB, TfG, Tfx, TfC;
			 Tfx = W[58];
			 TfB = Tfx * TfA;
			 TfG = Tfx * TfF;
			 TfC = W[59];
			 cr[WS(rs, 30)] = FNMS(TfC, TfF, TfB);
			 ci[WS(rs, 30)] = FMA(TfC, TfA, TfG);
		    }
		    {
			 E TfJ, TfM, TfH, TfK;
			 TfH = W[122];
			 TfJ = TfH * TfI;
			 TfM = TfH * TfL;
			 TfK = W[123];
			 cr[WS(rs, 62)] = FNMS(TfK, TfL, TfJ);
			 ci[WS(rs, 62)] = FMA(TfK, TfI, TfM);
		    }
		    {
			 E Tfp, Tfi, Tfq, Tf5, Tfh;
			 Tfp = FNMS(KP980785280, Tfo, Tfl);
			 Tfi = W[91];
			 Tfq = Tfi * Tfg;
			 Tf5 = W[90];
			 Tfh = Tf5 * Tfg;
			 cr[WS(rs, 46)] = FNMS(Tfi, Tfp, Tfh);
			 ci[WS(rs, 46)] = FMA(Tf5, Tfp, Tfq);
		    }
		    {
			 E Tfv, Tfu, Tfw, Tfr, Tft;
			 Tfv = FMA(KP980785280, Tfo, Tfl);
			 Tfu = W[27];
			 Tfw = Tfu * Tfs;
			 Tfr = W[26];
			 Tft = Tfr * Tfs;
			 cr[WS(rs, 14)] = FNMS(Tfu, Tfv, Tft);
			 ci[WS(rs, 14)] = FMA(Tfr, Tfv, Tfw);
		    }
	       }
	       {
		    E T7k, T7Q, T7T, T7t, T7w, T7I, T7N, T7A;
		    {
			 E T7p, T7s, T7L, T7u, T7v, T7H, T74, T7G, T7j, T7M;
			 T7p = FMA(KP923879532, T7o, T7n);
			 T7s = T7q - T7r;
			 T7L = FNMS(KP831469612, T7s, T7p);
			 T7u = FMA(KP534511135, T77, T7a);
			 T7v = FNMS(KP534511135, T7e, T7h);
			 T7H = T7v - T7u;
			 {
			      E T6W, T73, T7b, T7i;
			      T6W = FMA(KP923879532, T6V, T6U);
			      T73 = T6Z - T72;
			      T74 = FMA(KP831469612, T73, T6W);
			      T7G = FNMS(KP831469612, T73, T6W);
			      T7b = FNMS(KP534511135, T7a, T77);
			      T7i = FMA(KP534511135, T7h, T7e);
			      T7j = T7b + T7i;
			      T7M = T7b - T7i;
			 }
			 T7k = FNMS(KP881921264, T7j, T74);
			 T7Q = FMA(KP881921264, T7H, T7G);
			 T7T = FMA(KP881921264, T7M, T7L);
			 T7t = FMA(KP831469612, T7s, T7p);
			 T7w = T7u + T7v;
			 T7I = FNMS(KP881921264, T7H, T7G);
			 T7N = FNMS(KP881921264, T7M, T7L);
			 T7A = FMA(KP881921264, T7j, T74);
		    }
		    {
			 E T7J, T7O, T7F, T7K;
			 T7F = W[104];
			 T7J = T7F * T7I;
			 T7O = T7F * T7N;
			 T7K = W[105];
			 cr[WS(rs, 53)] = FNMS(T7K, T7N, T7J);
			 ci[WS(rs, 53)] = FMA(T7K, T7I, T7O);
		    }
		    {
			 E T7R, T7U, T7P, T7S;
			 T7P = W[40];
			 T7R = T7P * T7Q;
			 T7U = T7P * T7T;
			 T7S = W[41];
			 cr[WS(rs, 21)] = FNMS(T7S, T7T, T7R);
			 ci[WS(rs, 21)] = FMA(T7S, T7Q, T7U);
		    }
		    {
			 E T7x, T7m, T7y, T6T, T7l;
			 T7x = FNMS(KP881921264, T7w, T7t);
			 T7m = W[73];
			 T7y = T7m * T7k;
			 T6T = W[72];
			 T7l = T6T * T7k;
			 cr[WS(rs, 37)] = FNMS(T7m, T7x, T7l);
			 ci[WS(rs, 37)] = FMA(T6T, T7x, T7y);
		    }
		    {
			 E T7D, T7C, T7E, T7z, T7B;
			 T7D = FMA(KP881921264, T7w, T7t);
			 T7C = W[9];
			 T7E = T7C * T7A;
			 T7z = W[8];
			 T7B = T7z * T7A;
			 cr[WS(rs, 5)] = FNMS(T7C, T7D, T7B);
			 ci[WS(rs, 5)] = FMA(T7z, T7D, T7E);
		    }
	       }
	       {
		    E T86, T8u, T8y, T8f, T8i, T8q, T8t, T8l;
		    {
			 E T81, T84, T85, T89, T8a, T8b, T7Y, T8o, T8e, T8p;
			 T81 = FMA(KP303346683, T80, T7Z);
			 T84 = FNMS(KP303346683, T83, T82);
			 T85 = T81 - T84;
			 T89 = FNMS(KP923879532, T7o, T7n);
			 T8a = T72 + T6Z;
			 T8b = FNMS(KP831469612, T8a, T89);
			 {
			      E T7W, T7X, T8c, T8d;
			      T7W = FNMS(KP923879532, T6V, T6U);
			      T7X = T7q + T7r;
			      T7Y = FNMS(KP831469612, T7X, T7W);
			      T8o = FMA(KP831469612, T7X, T7W);
			      T8c = FMA(KP303346683, T82, T83);
			      T8d = FNMS(KP303346683, T7Z, T80);
			      T8e = T8c - T8d;
			      T8p = T8c + T8d;
			 }
			 T86 = FNMS(KP956940335, T85, T7Y);
			 T8u = T84 + T81;
			 T8y = FMA(KP956940335, T8p, T8o);
			 T8f = FNMS(KP956940335, T8e, T8b);
			 T8i = FMA(KP956940335, T85, T7Y);
			 T8q = FNMS(KP956940335, T8p, T8o);
			 T8t = FMA(KP831469612, T8a, T89);
			 T8l = FMA(KP956940335, T8e, T8b);
		    }
		    {
			 E T87, T8g, T7V, T88;
			 T7V = W[88];
			 T87 = T7V * T86;
			 T8g = T7V * T8f;
			 T88 = W[89];
			 cr[WS(rs, 45)] = FNMS(T88, T8f, T87);
			 ci[WS(rs, 45)] = FMA(T88, T86, T8g);
		    }
		    {
			 E T8j, T8m, T8h, T8k;
			 T8h = W[24];
			 T8j = T8h * T8i;
			 T8m = T8h * T8l;
			 T8k = W[25];
			 cr[WS(rs, 13)] = FNMS(T8k, T8l, T8j);
			 ci[WS(rs, 13)] = FMA(T8k, T8i, T8m);
		    }
		    {
			 E T8v, T8s, T8w, T8n, T8r;
			 T8v = FNMS(KP956940335, T8u, T8t);
			 T8s = W[57];
			 T8w = T8s * T8q;
			 T8n = W[56];
			 T8r = T8n * T8q;
			 cr[WS(rs, 29)] = FNMS(T8s, T8v, T8r);
			 ci[WS(rs, 29)] = FMA(T8n, T8v, T8w);
		    }
		    {
			 E T8B, T8A, T8C, T8x, T8z;
			 T8B = FMA(KP956940335, T8u, T8t);
			 T8A = W[121];
			 T8C = T8A * T8y;
			 T8x = W[120];
			 T8z = T8x * T8y;
			 cr[WS(rs, 61)] = FNMS(T8A, T8B, T8z);
			 ci[WS(rs, 61)] = FMA(T8x, T8B, T8C);
		    }
	       }
	       {
		    E T9I, Tai, Tal, T9V, T9Y, Taa, Taf, Ta2;
		    {
			 E T9R, T9U, Tad, T9W, T9X, Ta9, T94, Ta8, T9H, Tae;
			 T9R = FNMS(KP923879532, T9Q, T9N);
			 T9U = T9S - T9T;
			 Tad = FNMS(KP831469612, T9U, T9R);
			 T9W = FMA(KP534511135, T9f, T9m);
			 T9X = FMA(KP534511135, T9y, T9F);
			 Ta9 = T9W + T9X;
			 {
			      E T8O, T93, T9n, T9G;
			      T8O = FMA(KP923879532, T8N, T8G);
			      T93 = T8V + T92;
			      T94 = FNMS(KP831469612, T93, T8O);
			      Ta8 = FMA(KP831469612, T93, T8O);
			      T9n = FNMS(KP534511135, T9m, T9f);
			      T9G = FNMS(KP534511135, T9F, T9y);
			      T9H = T9n + T9G;
			      Tae = T9G - T9n;
			 }
			 T9I = FMA(KP881921264, T9H, T94);
			 Tai = FMA(KP881921264, Ta9, Ta8);
			 Tal = FNMS(KP881921264, Tae, Tad);
			 T9V = FMA(KP831469612, T9U, T9R);
			 T9Y = T9W - T9X;
			 Taa = FNMS(KP881921264, Ta9, Ta8);
			 Taf = FMA(KP881921264, Tae, Tad);
			 Ta2 = FNMS(KP881921264, T9H, T94);
		    }
		    {
			 E Tab, Tag, Ta7, Tac;
			 Ta7 = W[52];
			 Tab = Ta7 * Taa;
			 Tag = Ta7 * Taf;
			 Tac = W[53];
			 cr[WS(rs, 27)] = FNMS(Tac, Taf, Tab);
			 ci[WS(rs, 27)] = FMA(Tac, Taa, Tag);
		    }
		    {
			 E Taj, Tam, Tah, Tak;
			 Tah = W[116];
			 Taj = Tah * Tai;
			 Tam = Tah * Tal;
			 Tak = W[117];
			 cr[WS(rs, 59)] = FNMS(Tak, Tal, Taj);
			 ci[WS(rs, 59)] = FMA(Tak, Tai, Tam);
		    }
		    {
			 E T9Z, T9K, Ta0, T8D, T9J;
			 T9Z = FNMS(KP881921264, T9Y, T9V);
			 T9K = W[85];
			 Ta0 = T9K * T9I;
			 T8D = W[84];
			 T9J = T8D * T9I;
			 cr[WS(rs, 43)] = FNMS(T9K, T9Z, T9J);
			 ci[WS(rs, 43)] = FMA(T8D, T9Z, Ta0);
		    }
		    {
			 E Ta5, Ta4, Ta6, Ta1, Ta3;
			 Ta5 = FMA(KP881921264, T9Y, T9V);
			 Ta4 = W[21];
			 Ta6 = Ta4 * Ta2;
			 Ta1 = W[20];
			 Ta3 = Ta1 * Ta2;
			 cr[WS(rs, 11)] = FNMS(Ta4, Ta5, Ta3);
			 ci[WS(rs, 11)] = FMA(Ta1, Ta5, Ta6);
		    }
	       }
	       {
		    E Teo, Tf0, Tf3, TeD, TeG, TeS, TeX, TeK;
		    {
			 E Tez, TeC, TeV, TeE, TeF, TeR, Tdu, TeQ, Ten, TeW;
			 Tez = FMA(KP707106781, Tey, Tev);
			 TeC = TeA - TeB;
			 TeV = FMA(KP923879532, TeC, Tez);
			 TeE = FNMS(KP668178637, Tec, Tel);
			 TeF = FMA(KP668178637, TdL, TdU);
			 TeR = TeE + TeF;
			 {
			      E Td6, Tdt, TdV, Tem;
			      Td6 = FMA(KP707106781, Td5, TcU);
			      Tdt = Tdh - Tds;
			      Tdu = FNMS(KP923879532, Tdt, Td6);
			      TeQ = FMA(KP923879532, Tdt, Td6);
			      TdV = FNMS(KP668178637, TdU, TdL);
			      Tem = FMA(KP668178637, Tel, Tec);
			      Ten = TdV - Tem;
			      TeW = Tem + TdV;
			 }
			 Teo = FNMS(KP831469612, Ten, Tdu);
			 Tf0 = FMA(KP831469612, TeR, TeQ);
			 Tf3 = FMA(KP831469612, TeW, TeV);
			 TeD = FNMS(KP923879532, TeC, Tez);
			 TeG = TeE - TeF;
			 TeS = FNMS(KP831469612, TeR, TeQ);
			 TeX = FNMS(KP831469612, TeW, TeV);
			 TeK = FMA(KP831469612, Ten, Tdu);
		    }
		    {
			 E TeT, TeY, TeP, TeU;
			 TeP = W[74];
			 TeT = TeP * TeS;
			 TeY = TeP * TeX;
			 TeU = W[75];
			 cr[WS(rs, 38)] = FNMS(TeU, TeX, TeT);
			 ci[WS(rs, 38)] = FMA(TeU, TeS, TeY);
		    }
		    {
			 E Tf1, Tf4, TeZ, Tf2;
			 TeZ = W[10];
			 Tf1 = TeZ * Tf0;
			 Tf4 = TeZ * Tf3;
			 Tf2 = W[11];
			 cr[WS(rs, 6)] = FNMS(Tf2, Tf3, Tf1);
			 ci[WS(rs, 6)] = FMA(Tf2, Tf0, Tf4);
		    }
		    {
			 E TeH, Teq, TeI, TcP, Tep;
			 TeH = FNMS(KP831469612, TeG, TeD);
			 Teq = W[107];
			 TeI = Teq * Teo;
			 TcP = W[106];
			 Tep = TcP * Teo;
			 cr[WS(rs, 54)] = FNMS(Teq, TeH, Tep);
			 ci[WS(rs, 54)] = FMA(TcP, TeH, TeI);
		    }
		    {
			 E TeN, TeM, TeO, TeJ, TeL;
			 TeN = FMA(KP831469612, TeG, TeD);
			 TeM = W[43];
			 TeO = TeM * TeK;
			 TeJ = W[42];
			 TeL = TeJ * TeK;
			 cr[WS(rs, 22)] = FNMS(TeM, TeN, TeL);
			 ci[WS(rs, 22)] = FMA(TeJ, TeN, TeO);
		    }
	       }
	       {
		    E Tci, TcK, TcN, Tcn, Tcq, TcC, TcH, Tcu;
		    {
			 E Tcl, Tcm, TcF, Tco, Tcp, TcB, Tca, TcA, Tch, TcG;
			 Tcl = FNMS(KP923879532, TbA, Tbz);
			 Tcm = Tbe - Tbb;
			 TcF = FNMS(KP980785280, Tcm, Tcl);
			 Tco = FMA(KP098491403, Tcb, Tcc);
			 Tcp = FMA(KP098491403, Tce, Tcf);
			 TcB = Tco + Tcp;
			 {
			      E Tc8, Tc9, Tcd, Tcg;
			      Tc8 = FMA(KP923879532, Tb7, Tb6);
			      Tc9 = TbC + TbD;
			      Tca = FNMS(KP980785280, Tc9, Tc8);
			      TcA = FMA(KP980785280, Tc9, Tc8);
			      Tcd = FNMS(KP098491403, Tcc, Tcb);
			      Tcg = FNMS(KP098491403, Tcf, Tce);
			      Tch = Tcd + Tcg;
			      TcG = Tcg - Tcd;
			 }
			 Tci = FMA(KP995184726, Tch, Tca);
			 TcK = FMA(KP995184726, TcB, TcA);
			 TcN = FNMS(KP995184726, TcG, TcF);
			 Tcn = FMA(KP980785280, Tcm, Tcl);
			 Tcq = Tco - Tcp;
			 TcC = FNMS(KP995184726, TcB, TcA);
			 TcH = FMA(KP995184726, TcG, TcF);
			 Tcu = FNMS(KP995184726, Tch, Tca);
		    }
		    {
			 E TcD, TcI, Tcz, TcE;
			 Tcz = W[60];
			 TcD = Tcz * TcC;
			 TcI = Tcz * TcH;
			 TcE = W[61];
			 cr[WS(rs, 31)] = FNMS(TcE, TcH, TcD);
			 ci[WS(rs, 31)] = FMA(TcE, TcC, TcI);
		    }
		    {
			 E TcL, TcO, TcJ, TcM;
			 TcJ = W[124];
			 TcL = TcJ * TcK;
			 TcO = TcJ * TcN;
			 TcM = W[125];
			 cr[WS(rs, 63)] = FNMS(TcM, TcN, TcL);
			 ci[WS(rs, 63)] = FMA(TcM, TcK, TcO);
		    }
		    {
			 E Tcr, Tck, Tcs, Tc7, Tcj;
			 Tcr = FNMS(KP995184726, Tcq, Tcn);
			 Tck = W[93];
			 Tcs = Tck * Tci;
			 Tc7 = W[92];
			 Tcj = Tc7 * Tci;
			 cr[WS(rs, 47)] = FNMS(Tck, Tcr, Tcj);
			 ci[WS(rs, 47)] = FMA(Tc7, Tcr, Tcs);
		    }
		    {
			 E Tcx, Tcw, Tcy, Tct, Tcv;
			 Tcx = FMA(KP995184726, Tcq, Tcn);
			 Tcw = W[29];
			 Tcy = Tcw * Tcu;
			 Tct = W[28];
			 Tcv = Tct * Tcu;
			 cr[WS(rs, 15)] = FNMS(Tcw, Tcx, Tcv);
			 ci[WS(rs, 15)] = FMA(Tct, Tcx, Tcy);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hb_64", twinstr, &GENUS, {520, 126, 518, 0} };

void X(codelet_hb_64) (planner *p) {
     X(khc2hc_register) (p, hb_64, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -dif -name hb_64 -include rdft/scalar/hb.h */

/*
 * This function contains 1038 FP additions, 500 FP multiplications,
 * (or, 808 additions, 270 multiplications, 230 fused multiply/add),
 * 196 stack variables, 15 constants, and 256 memory accesses
 */
#include "rdft/scalar/hb.h"

static void hb_64(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 126); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 126, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tf, T8C, Tfa, Thk, Tgg, ThM, T2c, T5O, T4K, T6g, Tag, TdE, TcA, Te6, T7P;
	       E T94, TK, T7o, T38, T4P, Tfv, Thn, T5W, T6j, Tb0, TdK, Tfs, Tho, T8K, T97;
	       E Tb7, TdL, TZ, T7l, T2P, T4Q, Tfo, Thq, T5T, T6k, TaH, TdH, Tfl, Thr, T8H;
	       E T98, TaO, TdI, Tu, T95, Tfh, ThN, Tgj, Thl, T2v, T6h, T4N, T5P, Tav, Te7;
	       E TcD, TdF, T7S, T8D, T1L, T20, T7A, T7D, T7G, T7H, T40, T62, Tg1, Thv, Tg8;
	       E Thz, Tg5, Thw, T4t, T5Z, T4j, T60, T4w, T63, TbY, TdS, Tcd, TdQ, TfU, Thy;
	       E T8P, T9z, T8S, T9A, Tcl, TdP, Tco, TdT, T1g, T1v, T7r, T7u, T7x, T7y, T3j;
	       E T69, TfI, ThD, TfP, ThG, TfM, ThC, T3M, T66, T3C, T67, T3P, T6a, Tbl, TdZ;
	       E TbA, TdX, TfB, ThF, T8W, T9C, T8Z, T9D, TbI, TdW, TbL, Te0;
	       {
		    E T3, Ta6, T6, Tcu, T4I, Ta7, T4F, Tcv, Td, Tcy, T27, Tae, Ta, Tcx, T2a;
		    E Tab;
		    {
			 E T1, T2, T4D, T4E;
			 T1 = cr[0];
			 T2 = ci[WS(rs, 31)];
			 T3 = T1 + T2;
			 Ta6 = T1 - T2;
			 {
			      E T4, T5, T4G, T4H;
			      T4 = cr[WS(rs, 16)];
			      T5 = ci[WS(rs, 15)];
			      T6 = T4 + T5;
			      Tcu = T4 - T5;
			      T4G = ci[WS(rs, 47)];
			      T4H = cr[WS(rs, 48)];
			      T4I = T4G - T4H;
			      Ta7 = T4G + T4H;
			 }
			 T4D = ci[WS(rs, 63)];
			 T4E = cr[WS(rs, 32)];
			 T4F = T4D - T4E;
			 Tcv = T4D + T4E;
			 {
			      E Tb, Tc, Tac, T25, T26, Tad;
			      Tb = ci[WS(rs, 7)];
			      Tc = cr[WS(rs, 24)];
			      Tac = Tb - Tc;
			      T25 = ci[WS(rs, 39)];
			      T26 = cr[WS(rs, 56)];
			      Tad = T25 + T26;
			      Td = Tb + Tc;
			      Tcy = Tac + Tad;
			      T27 = T25 - T26;
			      Tae = Tac - Tad;
			 }
			 {
			      E T8, T9, Ta9, T28, T29, Taa;
			      T8 = cr[WS(rs, 8)];
			      T9 = ci[WS(rs, 23)];
			      Ta9 = T8 - T9;
			      T28 = ci[WS(rs, 55)];
			      T29 = cr[WS(rs, 40)];
			      Taa = T28 + T29;
			      Ta = T8 + T9;
			      Tcx = Ta9 + Taa;
			      T2a = T28 - T29;
			      Tab = Ta9 - Taa;
			 }
		    }
		    {
			 E T7, Te, Tf8, Tf9;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 T8C = T7 - Te;
			 Tf8 = Ta6 + Ta7;
			 Tf9 = KP707106781 * (Tcx + Tcy);
			 Tfa = Tf8 - Tf9;
			 Thk = Tf8 + Tf9;
		    }
		    {
			 E Tge, Tgf, T24, T2b;
			 Tge = Tcv - Tcu;
			 Tgf = KP707106781 * (Tab - Tae);
			 Tgg = Tge + Tgf;
			 ThM = Tge - Tgf;
			 T24 = T3 - T6;
			 T2b = T27 - T2a;
			 T2c = T24 + T2b;
			 T5O = T24 - T2b;
		    }
		    {
			 E T4C, T4J, Ta8, Taf;
			 T4C = Ta - Td;
			 T4J = T4F - T4I;
			 T4K = T4C + T4J;
			 T6g = T4J - T4C;
			 Ta8 = Ta6 - Ta7;
			 Taf = KP707106781 * (Tab + Tae);
			 Tag = Ta8 - Taf;
			 TdE = Ta8 + Taf;
		    }
		    {
			 E Tcw, Tcz, T7N, T7O;
			 Tcw = Tcu + Tcv;
			 Tcz = KP707106781 * (Tcx - Tcy);
			 TcA = Tcw - Tcz;
			 Te6 = Tcw + Tcz;
			 T7N = T4F + T4I;
			 T7O = T2a + T27;
			 T7P = T7N + T7O;
			 T94 = T7N - T7O;
		    }
	       }
	       {
		    E TC, Tb1, T2Z, TaQ, T2X, Tb2, T7m, TaR, TJ, Tb4, Tb5, T2Q, T36, TaV, TaY;
		    E T7n, Tfq, Tfr;
		    {
			 E Tw, Tx, Ty, Tz, TA, TB;
			 Tw = cr[WS(rs, 2)];
			 Tx = ci[WS(rs, 29)];
			 Ty = Tw + Tx;
			 Tz = cr[WS(rs, 18)];
			 TA = ci[WS(rs, 13)];
			 TB = Tz + TA;
			 TC = Ty + TB;
			 Tb1 = Tz - TA;
			 T2Z = Ty - TB;
			 TaQ = Tw - Tx;
		    }
		    {
			 E T2R, T2S, T2T, T2U, T2V, T2W;
			 T2R = ci[WS(rs, 61)];
			 T2S = cr[WS(rs, 34)];
			 T2T = T2R - T2S;
			 T2U = ci[WS(rs, 45)];
			 T2V = cr[WS(rs, 50)];
			 T2W = T2U - T2V;
			 T2X = T2T - T2W;
			 Tb2 = T2R + T2S;
			 T7m = T2T + T2W;
			 TaR = T2U + T2V;
		    }
		    {
			 E TF, TaT, T35, TaU, TI, TaW, T32, TaX;
			 {
			      E TD, TE, T33, T34;
			      TD = cr[WS(rs, 10)];
			      TE = ci[WS(rs, 21)];
			      TF = TD + TE;
			      TaT = TD - TE;
			      T33 = ci[WS(rs, 53)];
			      T34 = cr[WS(rs, 42)];
			      T35 = T33 - T34;
			      TaU = T33 + T34;
			 }
			 {
			      E TG, TH, T30, T31;
			      TG = ci[WS(rs, 5)];
			      TH = cr[WS(rs, 26)];
			      TI = TG + TH;
			      TaW = TG - TH;
			      T30 = ci[WS(rs, 37)];
			      T31 = cr[WS(rs, 58)];
			      T32 = T30 - T31;
			      TaX = T30 + T31;
			 }
			 TJ = TF + TI;
			 Tb4 = TaT + TaU;
			 Tb5 = TaW + TaX;
			 T2Q = TF - TI;
			 T36 = T32 - T35;
			 TaV = TaT - TaU;
			 TaY = TaW - TaX;
			 T7n = T35 + T32;
		    }
		    TK = TC + TJ;
		    T7o = T7m + T7n;
		    {
			 E T2Y, T37, Tft, Tfu;
			 T2Y = T2Q + T2X;
			 T37 = T2Z + T36;
			 T38 = FMA(KP923879532, T2Y, KP382683432 * T37);
			 T4P = FNMS(KP382683432, T2Y, KP923879532 * T37);
			 Tft = TaQ + TaR;
			 Tfu = KP707106781 * (Tb4 + Tb5);
			 Tfv = Tft - Tfu;
			 Thn = Tft + Tfu;
		    }
		    {
			 E T5U, T5V, TaS, TaZ;
			 T5U = T2X - T2Q;
			 T5V = T2Z - T36;
			 T5W = FMA(KP382683432, T5U, KP923879532 * T5V);
			 T6j = FNMS(KP923879532, T5U, KP382683432 * T5V);
			 TaS = TaQ - TaR;
			 TaZ = KP707106781 * (TaV + TaY);
			 Tb0 = TaS - TaZ;
			 TdK = TaS + TaZ;
		    }
		    Tfq = Tb2 - Tb1;
		    Tfr = KP707106781 * (TaV - TaY);
		    Tfs = Tfq + Tfr;
		    Tho = Tfq - Tfr;
		    {
			 E T8I, T8J, Tb3, Tb6;
			 T8I = TC - TJ;
			 T8J = T7m - T7n;
			 T8K = T8I + T8J;
			 T97 = T8I - T8J;
			 Tb3 = Tb1 + Tb2;
			 Tb6 = KP707106781 * (Tb4 - Tb5);
			 Tb7 = Tb3 - Tb6;
			 TdL = Tb3 + Tb6;
		    }
	       }
	       {
		    E TR, TaI, T2G, Tax, T2E, TaJ, T7j, Tay, TY, TaL, TaM, T2x, T2N, TaC, TaF;
		    E T7k, Tfj, Tfk;
		    {
			 E TL, TM, TN, TO, TP, TQ;
			 TL = ci[WS(rs, 1)];
			 TM = cr[WS(rs, 30)];
			 TN = TL + TM;
			 TO = cr[WS(rs, 14)];
			 TP = ci[WS(rs, 17)];
			 TQ = TO + TP;
			 TR = TN + TQ;
			 TaI = TL - TM;
			 T2G = TN - TQ;
			 Tax = TO - TP;
		    }
		    {
			 E T2y, T2z, T2A, T2B, T2C, T2D;
			 T2y = ci[WS(rs, 33)];
			 T2z = cr[WS(rs, 62)];
			 T2A = T2y - T2z;
			 T2B = ci[WS(rs, 49)];
			 T2C = cr[WS(rs, 46)];
			 T2D = T2B - T2C;
			 T2E = T2A - T2D;
			 TaJ = T2B + T2C;
			 T7j = T2A + T2D;
			 Tay = T2y + T2z;
		    }
		    {
			 E TU, TaA, T2M, TaB, TX, TaD, T2J, TaE;
			 {
			      E TS, TT, T2K, T2L;
			      TS = cr[WS(rs, 6)];
			      TT = ci[WS(rs, 25)];
			      TU = TS + TT;
			      TaA = TS - TT;
			      T2K = ci[WS(rs, 57)];
			      T2L = cr[WS(rs, 38)];
			      T2M = T2K - T2L;
			      TaB = T2K + T2L;
			 }
			 {
			      E TV, TW, T2H, T2I;
			      TV = ci[WS(rs, 9)];
			      TW = cr[WS(rs, 22)];
			      TX = TV + TW;
			      TaD = TV - TW;
			      T2H = ci[WS(rs, 41)];
			      T2I = cr[WS(rs, 54)];
			      T2J = T2H - T2I;
			      TaE = T2H + T2I;
			 }
			 TY = TU + TX;
			 TaL = TaA - TaB;
			 TaM = TaD - TaE;
			 T2x = TU - TX;
			 T2N = T2J - T2M;
			 TaC = TaA + TaB;
			 TaF = TaD + TaE;
			 T7k = T2M + T2J;
		    }
		    TZ = TR + TY;
		    T7l = T7j + T7k;
		    {
			 E T2F, T2O, Tfm, Tfn;
			 T2F = T2x + T2E;
			 T2O = T2G + T2N;
			 T2P = FNMS(KP382683432, T2O, KP923879532 * T2F);
			 T4Q = FMA(KP382683432, T2F, KP923879532 * T2O);
			 Tfm = TaI + TaJ;
			 Tfn = KP707106781 * (TaC + TaF);
			 Tfo = Tfm - Tfn;
			 Thq = Tfm + Tfn;
		    }
		    {
			 E T5R, T5S, Taz, TaG;
			 T5R = T2E - T2x;
			 T5S = T2G - T2N;
			 T5T = FNMS(KP923879532, T5S, KP382683432 * T5R);
			 T6k = FMA(KP923879532, T5R, KP382683432 * T5S);
			 Taz = Tax - Tay;
			 TaG = KP707106781 * (TaC - TaF);
			 TaH = Taz - TaG;
			 TdH = Taz + TaG;
		    }
		    Tfj = KP707106781 * (TaL - TaM);
		    Tfk = Tax + Tay;
		    Tfl = Tfj - Tfk;
		    Thr = Tfk + Tfj;
		    {
			 E T8F, T8G, TaK, TaN;
			 T8F = T7j - T7k;
			 T8G = TR - TY;
			 T8H = T8F - T8G;
			 T98 = T8G + T8F;
			 TaK = TaI - TaJ;
			 TaN = KP707106781 * (TaL + TaM);
			 TaO = TaK - TaN;
			 TdI = TaK + TaN;
		    }
	       }
	       {
		    E Ti, T2j, Tl, T2g, T2d, T2k, Tfc, Tfb, Tat, Taq, Tp, T2s, Ts, T2p, T2m;
		    E T2t, Tff, Tfe, Tam, Taj;
		    {
			 E Tar, Tas, Tao, Tap;
			 {
			      E Tg, Th, T2h, T2i;
			      Tg = cr[WS(rs, 4)];
			      Th = ci[WS(rs, 27)];
			      Ti = Tg + Th;
			      Tar = Tg - Th;
			      T2h = ci[WS(rs, 43)];
			      T2i = cr[WS(rs, 52)];
			      T2j = T2h - T2i;
			      Tas = T2h + T2i;
			 }
			 {
			      E Tj, Tk, T2e, T2f;
			      Tj = cr[WS(rs, 20)];
			      Tk = ci[WS(rs, 11)];
			      Tl = Tj + Tk;
			      Tao = Tj - Tk;
			      T2e = ci[WS(rs, 59)];
			      T2f = cr[WS(rs, 36)];
			      T2g = T2e - T2f;
			      Tap = T2e + T2f;
			 }
			 T2d = Ti - Tl;
			 T2k = T2g - T2j;
			 Tfc = Tap - Tao;
			 Tfb = Tar + Tas;
			 Tat = Tar - Tas;
			 Taq = Tao + Tap;
		    }
		    {
			 E Tak, Tal, Tah, Tai;
			 {
			      E Tn, To, T2q, T2r;
			      Tn = ci[WS(rs, 3)];
			      To = cr[WS(rs, 28)];
			      Tp = Tn + To;
			      Tak = Tn - To;
			      T2q = ci[WS(rs, 51)];
			      T2r = cr[WS(rs, 44)];
			      T2s = T2q - T2r;
			      Tal = T2q + T2r;
			 }
			 {
			      E Tq, Tr, T2n, T2o;
			      Tq = cr[WS(rs, 12)];
			      Tr = ci[WS(rs, 19)];
			      Ts = Tq + Tr;
			      Tah = Tq - Tr;
			      T2n = ci[WS(rs, 35)];
			      T2o = cr[WS(rs, 60)];
			      T2p = T2n - T2o;
			      Tai = T2n + T2o;
			 }
			 T2m = Tp - Ts;
			 T2t = T2p - T2s;
			 Tff = Tah + Tai;
			 Tfe = Tak + Tal;
			 Tam = Tak - Tal;
			 Taj = Tah - Tai;
		    }
		    {
			 E Tm, Tt, Tfd, Tfg;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 T95 = Tm - Tt;
			 Tfd = FNMS(KP923879532, Tfc, KP382683432 * Tfb);
			 Tfg = FNMS(KP923879532, Tff, KP382683432 * Tfe);
			 Tfh = Tfd + Tfg;
			 ThN = Tfd - Tfg;
		    }
		    {
			 E Tgh, Tgi, T2l, T2u;
			 Tgh = FMA(KP382683432, Tfc, KP923879532 * Tfb);
			 Tgi = FMA(KP382683432, Tff, KP923879532 * Tfe);
			 Tgj = Tgh - Tgi;
			 Thl = Tgh + Tgi;
			 T2l = T2d - T2k;
			 T2u = T2m + T2t;
			 T2v = KP707106781 * (T2l + T2u);
			 T6h = KP707106781 * (T2l - T2u);
		    }
		    {
			 E T4L, T4M, Tan, Tau;
			 T4L = T2d + T2k;
			 T4M = T2t - T2m;
			 T4N = KP707106781 * (T4L + T4M);
			 T5P = KP707106781 * (T4M - T4L);
			 Tan = FNMS(KP382683432, Tam, KP923879532 * Taj);
			 Tau = FMA(KP923879532, Taq, KP382683432 * Tat);
			 Tav = Tan - Tau;
			 Te7 = Tau + Tan;
		    }
		    {
			 E TcB, TcC, T7Q, T7R;
			 TcB = FNMS(KP382683432, Taq, KP923879532 * Tat);
			 TcC = FMA(KP382683432, Taj, KP923879532 * Tam);
			 TcD = TcB - TcC;
			 TdF = TcB + TcC;
			 T7Q = T2g + T2j;
			 T7R = T2p + T2s;
			 T7S = T7Q + T7R;
			 T8D = T7R - T7Q;
		    }
	       }
	       {
		    E T1z, T1C, T1D, Tcf, TbO, T4o, T4r, T7B, Tcg, TbP, T1G, T3Y, T1J, T3V, T1K;
		    E T7C, Tcj, Tci, TbW, TbT, T1S, TfV, TfW, T41, T48, Tc8, Tcb, T7E, T1Z, TfY;
		    E TfZ, T4a, T4h, Tc1, Tc4, T7F;
		    {
			 E T1x, T1y, T1A, T1B;
			 T1x = ci[0];
			 T1y = cr[WS(rs, 31)];
			 T1z = T1x + T1y;
			 T1A = cr[WS(rs, 15)];
			 T1B = ci[WS(rs, 16)];
			 T1C = T1A + T1B;
			 T1D = T1z + T1C;
			 Tcf = T1A - T1B;
			 TbO = T1x - T1y;
		    }
		    {
			 E T4m, T4n, T4p, T4q;
			 T4m = ci[WS(rs, 32)];
			 T4n = cr[WS(rs, 63)];
			 T4o = T4m - T4n;
			 T4p = ci[WS(rs, 48)];
			 T4q = cr[WS(rs, 47)];
			 T4r = T4p - T4q;
			 T7B = T4o + T4r;
			 Tcg = T4m + T4n;
			 TbP = T4p + T4q;
		    }
		    {
			 E TbR, TbS, TbU, TbV;
			 {
			      E T1E, T1F, T3W, T3X;
			      T1E = cr[WS(rs, 7)];
			      T1F = ci[WS(rs, 24)];
			      T1G = T1E + T1F;
			      TbR = T1E - T1F;
			      T3W = ci[WS(rs, 56)];
			      T3X = cr[WS(rs, 39)];
			      T3Y = T3W - T3X;
			      TbS = T3W + T3X;
			 }
			 {
			      E T1H, T1I, T3T, T3U;
			      T1H = ci[WS(rs, 8)];
			      T1I = cr[WS(rs, 23)];
			      T1J = T1H + T1I;
			      TbU = T1H - T1I;
			      T3T = ci[WS(rs, 40)];
			      T3U = cr[WS(rs, 55)];
			      T3V = T3T - T3U;
			      TbV = T3T + T3U;
			 }
			 T1K = T1G + T1J;
			 T7C = T3Y + T3V;
			 Tcj = TbU + TbV;
			 Tci = TbR + TbS;
			 TbW = TbU - TbV;
			 TbT = TbR - TbS;
		    }
		    {
			 E T1O, Tc9, T47, Tca, T1R, Tc6, T44, Tc7;
			 {
			      E T1M, T1N, T45, T46;
			      T1M = cr[WS(rs, 3)];
			      T1N = ci[WS(rs, 28)];
			      T1O = T1M + T1N;
			      Tc9 = T1M - T1N;
			      T45 = ci[WS(rs, 44)];
			      T46 = cr[WS(rs, 51)];
			      T47 = T45 - T46;
			      Tca = T45 + T46;
			 }
			 {
			      E T1P, T1Q, T42, T43;
			      T1P = cr[WS(rs, 19)];
			      T1Q = ci[WS(rs, 12)];
			      T1R = T1P + T1Q;
			      Tc6 = T1P - T1Q;
			      T42 = ci[WS(rs, 60)];
			      T43 = cr[WS(rs, 35)];
			      T44 = T42 - T43;
			      Tc7 = T42 + T43;
			 }
			 T1S = T1O + T1R;
			 TfV = Tc9 + Tca;
			 TfW = Tc7 - Tc6;
			 T41 = T1O - T1R;
			 T48 = T44 - T47;
			 Tc8 = Tc6 + Tc7;
			 Tcb = Tc9 - Tca;
			 T7E = T44 + T47;
		    }
		    {
			 E T1V, Tc2, T4g, Tc3, T1Y, TbZ, T4d, Tc0;
			 {
			      E T1T, T1U, T4e, T4f;
			      T1T = ci[WS(rs, 4)];
			      T1U = cr[WS(rs, 27)];
			      T1V = T1T + T1U;
			      Tc2 = T1T - T1U;
			      T4e = ci[WS(rs, 52)];
			      T4f = cr[WS(rs, 43)];
			      T4g = T4e - T4f;
			      Tc3 = T4e + T4f;
			 }
			 {
			      E T1W, T1X, T4b, T4c;
			      T1W = cr[WS(rs, 11)];
			      T1X = ci[WS(rs, 20)];
			      T1Y = T1W + T1X;
			      TbZ = T1W - T1X;
			      T4b = ci[WS(rs, 36)];
			      T4c = cr[WS(rs, 59)];
			      T4d = T4b - T4c;
			      Tc0 = T4b + T4c;
			 }
			 T1Z = T1V + T1Y;
			 TfY = Tc2 + Tc3;
			 TfZ = TbZ + Tc0;
			 T4a = T1V - T1Y;
			 T4h = T4d - T4g;
			 Tc1 = TbZ - Tc0;
			 Tc4 = Tc2 - Tc3;
			 T7F = T4d + T4g;
		    }
		    T1L = T1D + T1K;
		    T20 = T1S + T1Z;
		    T7A = T1L - T20;
		    T7D = T7B + T7C;
		    T7G = T7E + T7F;
		    T7H = T7D - T7G;
		    {
			 E T3S, T3Z, TfX, Tg0;
			 T3S = T1z - T1C;
			 T3Z = T3V - T3Y;
			 T40 = T3S + T3Z;
			 T62 = T3S - T3Z;
			 TfX = FNMS(KP923879532, TfW, KP382683432 * TfV);
			 Tg0 = FNMS(KP923879532, TfZ, KP382683432 * TfY);
			 Tg1 = TfX + Tg0;
			 Thv = TfX - Tg0;
		    }
		    {
			 E Tg6, Tg7, Tg3, Tg4;
			 Tg6 = FMA(KP382683432, TfW, KP923879532 * TfV);
			 Tg7 = FMA(KP382683432, TfZ, KP923879532 * TfY);
			 Tg8 = Tg6 - Tg7;
			 Thz = Tg6 + Tg7;
			 Tg3 = KP707106781 * (TbT - TbW);
			 Tg4 = Tcf + Tcg;
			 Tg5 = Tg3 - Tg4;
			 Thw = Tg4 + Tg3;
		    }
		    {
			 E T4l, T4s, T49, T4i;
			 T4l = T1G - T1J;
			 T4s = T4o - T4r;
			 T4t = T4l + T4s;
			 T5Z = T4s - T4l;
			 T49 = T41 - T48;
			 T4i = T4a + T4h;
			 T4j = KP707106781 * (T49 + T4i);
			 T60 = KP707106781 * (T49 - T4i);
		    }
		    {
			 E T4u, T4v, TbQ, TbX;
			 T4u = T41 + T48;
			 T4v = T4h - T4a;
			 T4w = KP707106781 * (T4u + T4v);
			 T63 = KP707106781 * (T4v - T4u);
			 TbQ = TbO - TbP;
			 TbX = KP707106781 * (TbT + TbW);
			 TbY = TbQ - TbX;
			 TdS = TbQ + TbX;
		    }
		    {
			 E Tc5, Tcc, TfS, TfT;
			 Tc5 = FNMS(KP382683432, Tc4, KP923879532 * Tc1);
			 Tcc = FMA(KP923879532, Tc8, KP382683432 * Tcb);
			 Tcd = Tc5 - Tcc;
			 TdQ = Tcc + Tc5;
			 TfS = TbO + TbP;
			 TfT = KP707106781 * (Tci + Tcj);
			 TfU = TfS - TfT;
			 Thy = TfS + TfT;
		    }
		    {
			 E T8N, T8O, T8Q, T8R;
			 T8N = T7B - T7C;
			 T8O = T1S - T1Z;
			 T8P = T8N - T8O;
			 T9z = T8O + T8N;
			 T8Q = T1D - T1K;
			 T8R = T7F - T7E;
			 T8S = T8Q - T8R;
			 T9A = T8Q + T8R;
		    }
		    {
			 E Tch, Tck, Tcm, Tcn;
			 Tch = Tcf - Tcg;
			 Tck = KP707106781 * (Tci - Tcj);
			 Tcl = Tch - Tck;
			 TdP = Tch + Tck;
			 Tcm = FNMS(KP382683432, Tc8, KP923879532 * Tcb);
			 Tcn = FMA(KP382683432, Tc1, KP923879532 * Tc4);
			 Tco = Tcm - Tcn;
			 TdT = Tcm + Tcn;
		    }
	       }
	       {
		    E T14, T17, T18, TbC, Tbb, T3H, T3K, T7s, TbD, Tbc, T1b, T3h, T1e, T3e, T1f;
		    E T7t, TbG, TbF, Tbj, Tbg, T1n, TfC, TfD, T3k, T3r, Tbv, Tby, T7v, T1u, TfF;
		    E TfG, T3t, T3A, Tbo, Tbr, T7w;
		    {
			 E T12, T13, T15, T16;
			 T12 = cr[WS(rs, 1)];
			 T13 = ci[WS(rs, 30)];
			 T14 = T12 + T13;
			 T15 = cr[WS(rs, 17)];
			 T16 = ci[WS(rs, 14)];
			 T17 = T15 + T16;
			 T18 = T14 + T17;
			 TbC = T15 - T16;
			 Tbb = T12 - T13;
		    }
		    {
			 E T3F, T3G, T3I, T3J;
			 T3F = ci[WS(rs, 62)];
			 T3G = cr[WS(rs, 33)];
			 T3H = T3F - T3G;
			 T3I = ci[WS(rs, 46)];
			 T3J = cr[WS(rs, 49)];
			 T3K = T3I - T3J;
			 T7s = T3H + T3K;
			 TbD = T3F + T3G;
			 Tbc = T3I + T3J;
		    }
		    {
			 E Tbe, Tbf, Tbh, Tbi;
			 {
			      E T19, T1a, T3f, T3g;
			      T19 = cr[WS(rs, 9)];
			      T1a = ci[WS(rs, 22)];
			      T1b = T19 + T1a;
			      Tbe = T19 - T1a;
			      T3f = ci[WS(rs, 54)];
			      T3g = cr[WS(rs, 41)];
			      T3h = T3f - T3g;
			      Tbf = T3f + T3g;
			 }
			 {
			      E T1c, T1d, T3c, T3d;
			      T1c = ci[WS(rs, 6)];
			      T1d = cr[WS(rs, 25)];
			      T1e = T1c + T1d;
			      Tbh = T1c - T1d;
			      T3c = ci[WS(rs, 38)];
			      T3d = cr[WS(rs, 57)];
			      T3e = T3c - T3d;
			      Tbi = T3c + T3d;
			 }
			 T1f = T1b + T1e;
			 T7t = T3h + T3e;
			 TbG = Tbh + Tbi;
			 TbF = Tbe + Tbf;
			 Tbj = Tbh - Tbi;
			 Tbg = Tbe - Tbf;
		    }
		    {
			 E T1j, Tbw, T3q, Tbx, T1m, Tbt, T3n, Tbu;
			 {
			      E T1h, T1i, T3o, T3p;
			      T1h = cr[WS(rs, 5)];
			      T1i = ci[WS(rs, 26)];
			      T1j = T1h + T1i;
			      Tbw = T1h - T1i;
			      T3o = ci[WS(rs, 42)];
			      T3p = cr[WS(rs, 53)];
			      T3q = T3o - T3p;
			      Tbx = T3o + T3p;
			 }
			 {
			      E T1k, T1l, T3l, T3m;
			      T1k = cr[WS(rs, 21)];
			      T1l = ci[WS(rs, 10)];
			      T1m = T1k + T1l;
			      Tbt = T1k - T1l;
			      T3l = ci[WS(rs, 58)];
			      T3m = cr[WS(rs, 37)];
			      T3n = T3l - T3m;
			      Tbu = T3l + T3m;
			 }
			 T1n = T1j + T1m;
			 TfC = Tbw + Tbx;
			 TfD = Tbu - Tbt;
			 T3k = T1j - T1m;
			 T3r = T3n - T3q;
			 Tbv = Tbt + Tbu;
			 Tby = Tbw - Tbx;
			 T7v = T3n + T3q;
		    }
		    {
			 E T1q, Tbp, T3z, Tbq, T1t, Tbm, T3w, Tbn;
			 {
			      E T1o, T1p, T3x, T3y;
			      T1o = ci[WS(rs, 2)];
			      T1p = cr[WS(rs, 29)];
			      T1q = T1o + T1p;
			      Tbp = T1o - T1p;
			      T3x = ci[WS(rs, 50)];
			      T3y = cr[WS(rs, 45)];
			      T3z = T3x - T3y;
			      Tbq = T3x + T3y;
			 }
			 {
			      E T1r, T1s, T3u, T3v;
			      T1r = cr[WS(rs, 13)];
			      T1s = ci[WS(rs, 18)];
			      T1t = T1r + T1s;
			      Tbm = T1r - T1s;
			      T3u = ci[WS(rs, 34)];
			      T3v = cr[WS(rs, 61)];
			      T3w = T3u - T3v;
			      Tbn = T3u + T3v;
			 }
			 T1u = T1q + T1t;
			 TfF = Tbp + Tbq;
			 TfG = Tbm + Tbn;
			 T3t = T1q - T1t;
			 T3A = T3w - T3z;
			 Tbo = Tbm - Tbn;
			 Tbr = Tbp - Tbq;
			 T7w = T3w + T3z;
		    }
		    T1g = T18 + T1f;
		    T1v = T1n + T1u;
		    T7r = T1g - T1v;
		    T7u = T7s + T7t;
		    T7x = T7v + T7w;
		    T7y = T7u - T7x;
		    {
			 E T3b, T3i, TfE, TfH;
			 T3b = T14 - T17;
			 T3i = T3e - T3h;
			 T3j = T3b + T3i;
			 T69 = T3b - T3i;
			 TfE = FNMS(KP923879532, TfD, KP382683432 * TfC);
			 TfH = FNMS(KP923879532, TfG, KP382683432 * TfF);
			 TfI = TfE + TfH;
			 ThD = TfE - TfH;
		    }
		    {
			 E TfN, TfO, TfK, TfL;
			 TfN = FMA(KP382683432, TfD, KP923879532 * TfC);
			 TfO = FMA(KP382683432, TfG, KP923879532 * TfF);
			 TfP = TfN - TfO;
			 ThG = TfN + TfO;
			 TfK = TbD - TbC;
			 TfL = KP707106781 * (Tbg - Tbj);
			 TfM = TfK + TfL;
			 ThC = TfK - TfL;
		    }
		    {
			 E T3E, T3L, T3s, T3B;
			 T3E = T1b - T1e;
			 T3L = T3H - T3K;
			 T3M = T3E + T3L;
			 T66 = T3L - T3E;
			 T3s = T3k - T3r;
			 T3B = T3t + T3A;
			 T3C = KP707106781 * (T3s + T3B);
			 T67 = KP707106781 * (T3s - T3B);
		    }
		    {
			 E T3N, T3O, Tbd, Tbk;
			 T3N = T3k + T3r;
			 T3O = T3A - T3t;
			 T3P = KP707106781 * (T3N + T3O);
			 T6a = KP707106781 * (T3O - T3N);
			 Tbd = Tbb - Tbc;
			 Tbk = KP707106781 * (Tbg + Tbj);
			 Tbl = Tbd - Tbk;
			 TdZ = Tbd + Tbk;
		    }
		    {
			 E Tbs, Tbz, Tfz, TfA;
			 Tbs = FNMS(KP382683432, Tbr, KP923879532 * Tbo);
			 Tbz = FMA(KP923879532, Tbv, KP382683432 * Tby);
			 TbA = Tbs - Tbz;
			 TdX = Tbz + Tbs;
			 Tfz = Tbb + Tbc;
			 TfA = KP707106781 * (TbF + TbG);
			 TfB = Tfz - TfA;
			 ThF = Tfz + TfA;
		    }
		    {
			 E T8U, T8V, T8X, T8Y;
			 T8U = T7s - T7t;
			 T8V = T1n - T1u;
			 T8W = T8U - T8V;
			 T9C = T8V + T8U;
			 T8X = T18 - T1f;
			 T8Y = T7w - T7v;
			 T8Z = T8X - T8Y;
			 T9D = T8X + T8Y;
		    }
		    {
			 E TbE, TbH, TbJ, TbK;
			 TbE = TbC + TbD;
			 TbH = KP707106781 * (TbF - TbG);
			 TbI = TbE - TbH;
			 TdW = TbE + TbH;
			 TbJ = FNMS(KP382683432, Tbv, KP923879532 * Tby);
			 TbK = FMA(KP382683432, Tbo, KP923879532 * Tbr);
			 TbL = TbJ - TbK;
			 Te0 = TbJ + TbK;
		    }
	       }
	       {
		    E T11, T8q, T8n, T8r, T22, T8v, T8k, T8u;
		    {
			 E Tv, T10, T8l, T8m;
			 Tv = Tf + Tu;
			 T10 = TK + TZ;
			 T11 = Tv + T10;
			 T8q = Tv - T10;
			 T8l = T7u + T7x;
			 T8m = T7D + T7G;
			 T8n = T8l + T8m;
			 T8r = T8m - T8l;
		    }
		    {
			 E T1w, T21, T8i, T8j;
			 T1w = T1g + T1v;
			 T21 = T1L + T20;
			 T22 = T1w + T21;
			 T8v = T1w - T21;
			 T8i = T7P + T7S;
			 T8j = T7o + T7l;
			 T8k = T8i + T8j;
			 T8u = T8i - T8j;
		    }
		    cr[0] = T11 + T22;
		    ci[0] = T8k + T8n;
		    {
			 E T8g, T8o, T8f, T8h;
			 T8g = T11 - T22;
			 T8o = T8k - T8n;
			 T8f = W[62];
			 T8h = W[63];
			 cr[WS(rs, 32)] = FNMS(T8h, T8o, T8f * T8g);
			 ci[WS(rs, 32)] = FMA(T8h, T8g, T8f * T8o);
		    }
		    {
			 E T8s, T8w, T8p, T8t;
			 T8s = T8q - T8r;
			 T8w = T8u - T8v;
			 T8p = W[94];
			 T8t = W[95];
			 cr[WS(rs, 48)] = FNMS(T8t, T8w, T8p * T8s);
			 ci[WS(rs, 48)] = FMA(T8p, T8w, T8t * T8s);
		    }
		    {
			 E T8y, T8A, T8x, T8z;
			 T8y = T8q + T8r;
			 T8A = T8v + T8u;
			 T8x = W[30];
			 T8z = W[31];
			 cr[WS(rs, 16)] = FNMS(T8z, T8A, T8x * T8y);
			 ci[WS(rs, 16)] = FMA(T8x, T8A, T8z * T8y);
		    }
	       }
	       {
		    E T9y, T9U, T9N, T9V, T9F, T9Z, T9K, T9Y;
		    {
			 E T9w, T9x, T9L, T9M;
			 T9w = T8C + T8D;
			 T9x = KP707106781 * (T97 + T98);
			 T9y = T9w - T9x;
			 T9U = T9w + T9x;
			 T9L = FNMS(KP382683432, T9C, KP923879532 * T9D);
			 T9M = FMA(KP382683432, T9z, KP923879532 * T9A);
			 T9N = T9L - T9M;
			 T9V = T9L + T9M;
		    }
		    {
			 E T9B, T9E, T9I, T9J;
			 T9B = FNMS(KP382683432, T9A, KP923879532 * T9z);
			 T9E = FMA(KP923879532, T9C, KP382683432 * T9D);
			 T9F = T9B - T9E;
			 T9Z = T9E + T9B;
			 T9I = T95 + T94;
			 T9J = KP707106781 * (T8K + T8H);
			 T9K = T9I - T9J;
			 T9Y = T9I + T9J;
		    }
		    {
			 E T9G, T9O, T9v, T9H;
			 T9G = T9y - T9F;
			 T9O = T9K - T9N;
			 T9v = W[102];
			 T9H = W[103];
			 cr[WS(rs, 52)] = FNMS(T9H, T9O, T9v * T9G);
			 ci[WS(rs, 52)] = FMA(T9H, T9G, T9v * T9O);
		    }
		    {
			 E Ta2, Ta4, Ta1, Ta3;
			 Ta2 = T9U + T9V;
			 Ta4 = T9Y + T9Z;
			 Ta1 = W[6];
			 Ta3 = W[7];
			 cr[WS(rs, 4)] = FNMS(Ta3, Ta4, Ta1 * Ta2);
			 ci[WS(rs, 4)] = FMA(Ta1, Ta4, Ta3 * Ta2);
		    }
		    {
			 E T9Q, T9S, T9P, T9R;
			 T9Q = T9y + T9F;
			 T9S = T9K + T9N;
			 T9P = W[38];
			 T9R = W[39];
			 cr[WS(rs, 20)] = FNMS(T9R, T9S, T9P * T9Q);
			 ci[WS(rs, 20)] = FMA(T9R, T9Q, T9P * T9S);
		    }
		    {
			 E T9W, Ta0, T9T, T9X;
			 T9W = T9U - T9V;
			 Ta0 = T9Y - T9Z;
			 T9T = W[70];
			 T9X = W[71];
			 cr[WS(rs, 36)] = FNMS(T9X, Ta0, T9T * T9W);
			 ci[WS(rs, 36)] = FMA(T9T, Ta0, T9X * T9W);
		    }
	       }
	       {
		    E T8M, T9k, T9d, T9l, T91, T9p, T9a, T9o;
		    {
			 E T8E, T8L, T9b, T9c;
			 T8E = T8C - T8D;
			 T8L = KP707106781 * (T8H - T8K);
			 T8M = T8E - T8L;
			 T9k = T8E + T8L;
			 T9b = FNMS(KP923879532, T8W, KP382683432 * T8Z);
			 T9c = FMA(KP923879532, T8P, KP382683432 * T8S);
			 T9d = T9b - T9c;
			 T9l = T9b + T9c;
		    }
		    {
			 E T8T, T90, T96, T99;
			 T8T = FNMS(KP923879532, T8S, KP382683432 * T8P);
			 T90 = FMA(KP382683432, T8W, KP923879532 * T8Z);
			 T91 = T8T - T90;
			 T9p = T90 + T8T;
			 T96 = T94 - T95;
			 T99 = KP707106781 * (T97 - T98);
			 T9a = T96 - T99;
			 T9o = T96 + T99;
		    }
		    {
			 E T92, T9e, T8B, T93;
			 T92 = T8M - T91;
			 T9e = T9a - T9d;
			 T8B = W[118];
			 T93 = W[119];
			 cr[WS(rs, 60)] = FNMS(T93, T9e, T8B * T92);
			 ci[WS(rs, 60)] = FMA(T93, T92, T8B * T9e);
		    }
		    {
			 E T9s, T9u, T9r, T9t;
			 T9s = T9k + T9l;
			 T9u = T9o + T9p;
			 T9r = W[22];
			 T9t = W[23];
			 cr[WS(rs, 12)] = FNMS(T9t, T9u, T9r * T9s);
			 ci[WS(rs, 12)] = FMA(T9r, T9u, T9t * T9s);
		    }
		    {
			 E T9g, T9i, T9f, T9h;
			 T9g = T8M + T91;
			 T9i = T9a + T9d;
			 T9f = W[54];
			 T9h = W[55];
			 cr[WS(rs, 28)] = FNMS(T9h, T9i, T9f * T9g);
			 ci[WS(rs, 28)] = FMA(T9h, T9g, T9f * T9i);
		    }
		    {
			 E T9m, T9q, T9j, T9n;
			 T9m = T9k - T9l;
			 T9q = T9o - T9p;
			 T9j = W[86];
			 T9n = W[87];
			 cr[WS(rs, 44)] = FNMS(T9n, T9q, T9j * T9m);
			 ci[WS(rs, 44)] = FMA(T9j, T9q, T9n * T9m);
		    }
	       }
	       {
		    E T7q, T84, T7X, T85, T7J, T89, T7U, T88;
		    {
			 E T7i, T7p, T7V, T7W;
			 T7i = Tf - Tu;
			 T7p = T7l - T7o;
			 T7q = T7i + T7p;
			 T84 = T7i - T7p;
			 T7V = T7r + T7y;
			 T7W = T7H - T7A;
			 T7X = KP707106781 * (T7V + T7W);
			 T85 = KP707106781 * (T7W - T7V);
		    }
		    {
			 E T7z, T7I, T7M, T7T;
			 T7z = T7r - T7y;
			 T7I = T7A + T7H;
			 T7J = KP707106781 * (T7z + T7I);
			 T89 = KP707106781 * (T7z - T7I);
			 T7M = TK - TZ;
			 T7T = T7P - T7S;
			 T7U = T7M + T7T;
			 T88 = T7T - T7M;
		    }
		    {
			 E T7K, T7Y, T7h, T7L;
			 T7K = T7q - T7J;
			 T7Y = T7U - T7X;
			 T7h = W[78];
			 T7L = W[79];
			 cr[WS(rs, 40)] = FNMS(T7L, T7Y, T7h * T7K);
			 ci[WS(rs, 40)] = FMA(T7L, T7K, T7h * T7Y);
		    }
		    {
			 E T8c, T8e, T8b, T8d;
			 T8c = T84 + T85;
			 T8e = T88 + T89;
			 T8b = W[46];
			 T8d = W[47];
			 cr[WS(rs, 24)] = FNMS(T8d, T8e, T8b * T8c);
			 ci[WS(rs, 24)] = FMA(T8b, T8e, T8d * T8c);
		    }
		    {
			 E T80, T82, T7Z, T81;
			 T80 = T7q + T7J;
			 T82 = T7U + T7X;
			 T7Z = W[14];
			 T81 = W[15];
			 cr[WS(rs, 8)] = FNMS(T81, T82, T7Z * T80);
			 ci[WS(rs, 8)] = FMA(T81, T80, T7Z * T82);
		    }
		    {
			 E T86, T8a, T83, T87;
			 T86 = T84 - T85;
			 T8a = T88 - T89;
			 T83 = W[110];
			 T87 = W[111];
			 cr[WS(rs, 56)] = FNMS(T87, T8a, T83 * T86);
			 ci[WS(rs, 56)] = FMA(T83, T8a, T87 * T86);
		    }
	       }
	       {
		    E T6K, T76, T6W, T7a, T6R, T7b, T6Z, T77;
		    {
			 E T6I, T6J, T6U, T6V;
			 T6I = T5O + T5P;
			 T6J = T6j + T6k;
			 T6K = T6I - T6J;
			 T76 = T6I + T6J;
			 T6U = T6g + T6h;
			 T6V = T5W + T5T;
			 T6W = T6U - T6V;
			 T7a = T6U + T6V;
			 {
			      E T6N, T6Y, T6Q, T6X;
			      {
				   E T6L, T6M, T6O, T6P;
				   T6L = T5Z + T60;
				   T6M = T62 + T63;
				   T6N = FNMS(KP555570233, T6M, KP831469612 * T6L);
				   T6Y = FMA(KP555570233, T6L, KP831469612 * T6M);
				   T6O = T66 + T67;
				   T6P = T69 + T6a;
				   T6Q = FMA(KP831469612, T6O, KP555570233 * T6P);
				   T6X = FNMS(KP555570233, T6O, KP831469612 * T6P);
			      }
			      T6R = T6N - T6Q;
			      T7b = T6Q + T6N;
			      T6Z = T6X - T6Y;
			      T77 = T6X + T6Y;
			 }
		    }
		    {
			 E T6S, T70, T6H, T6T;
			 T6S = T6K - T6R;
			 T70 = T6W - T6Z;
			 T6H = W[106];
			 T6T = W[107];
			 cr[WS(rs, 54)] = FNMS(T6T, T70, T6H * T6S);
			 ci[WS(rs, 54)] = FMA(T6T, T6S, T6H * T70);
		    }
		    {
			 E T7e, T7g, T7d, T7f;
			 T7e = T76 + T77;
			 T7g = T7a + T7b;
			 T7d = W[10];
			 T7f = W[11];
			 cr[WS(rs, 6)] = FNMS(T7f, T7g, T7d * T7e);
			 ci[WS(rs, 6)] = FMA(T7d, T7g, T7f * T7e);
		    }
		    {
			 E T72, T74, T71, T73;
			 T72 = T6K + T6R;
			 T74 = T6W + T6Z;
			 T71 = W[42];
			 T73 = W[43];
			 cr[WS(rs, 22)] = FNMS(T73, T74, T71 * T72);
			 ci[WS(rs, 22)] = FMA(T73, T72, T71 * T74);
		    }
		    {
			 E T78, T7c, T75, T79;
			 T78 = T76 - T77;
			 T7c = T7a - T7b;
			 T75 = W[74];
			 T79 = W[75];
			 cr[WS(rs, 38)] = FNMS(T79, T7c, T75 * T78);
			 ci[WS(rs, 38)] = FMA(T75, T7c, T79 * T78);
		    }
	       }
	       {
		    E T3a, T52, T4S, T56, T4z, T57, T4V, T53;
		    {
			 E T2w, T39, T4O, T4R;
			 T2w = T2c - T2v;
			 T39 = T2P - T38;
			 T3a = T2w + T39;
			 T52 = T2w - T39;
			 T4O = T4K - T4N;
			 T4R = T4P - T4Q;
			 T4S = T4O + T4R;
			 T56 = T4O - T4R;
			 {
			      E T3R, T4T, T4y, T4U;
			      {
				   E T3D, T3Q, T4k, T4x;
				   T3D = T3j - T3C;
				   T3Q = T3M - T3P;
				   T3R = FNMS(KP831469612, T3Q, KP555570233 * T3D);
				   T4T = FMA(KP831469612, T3D, KP555570233 * T3Q);
				   T4k = T40 - T4j;
				   T4x = T4t - T4w;
				   T4y = FMA(KP555570233, T4k, KP831469612 * T4x);
				   T4U = FNMS(KP831469612, T4k, KP555570233 * T4x);
			      }
			      T4z = T3R + T4y;
			      T57 = T3R - T4y;
			      T4V = T4T + T4U;
			      T53 = T4U - T4T;
			 }
		    }
		    {
			 E T4A, T4W, T23, T4B;
			 T4A = T3a - T4z;
			 T4W = T4S - T4V;
			 T23 = W[82];
			 T4B = W[83];
			 cr[WS(rs, 42)] = FNMS(T4B, T4W, T23 * T4A);
			 ci[WS(rs, 42)] = FMA(T4B, T4A, T23 * T4W);
		    }
		    {
			 E T5a, T5c, T59, T5b;
			 T5a = T52 + T53;
			 T5c = T56 + T57;
			 T59 = W[50];
			 T5b = W[51];
			 cr[WS(rs, 26)] = FNMS(T5b, T5c, T59 * T5a);
			 ci[WS(rs, 26)] = FMA(T59, T5c, T5b * T5a);
		    }
		    {
			 E T4Y, T50, T4X, T4Z;
			 T4Y = T3a + T4z;
			 T50 = T4S + T4V;
			 T4X = W[18];
			 T4Z = W[19];
			 cr[WS(rs, 10)] = FNMS(T4Z, T50, T4X * T4Y);
			 ci[WS(rs, 10)] = FMA(T4Z, T4Y, T4X * T50);
		    }
		    {
			 E T54, T58, T51, T55;
			 T54 = T52 - T53;
			 T58 = T56 - T57;
			 T51 = W[114];
			 T55 = W[115];
			 cr[WS(rs, 58)] = FNMS(T55, T58, T51 * T54);
			 ci[WS(rs, 58)] = FMA(T51, T58, T55 * T54);
		    }
	       }
	       {
		    E T5g, T5C, T5s, T5G, T5n, T5H, T5v, T5D;
		    {
			 E T5e, T5f, T5q, T5r;
			 T5e = T2c + T2v;
			 T5f = T4P + T4Q;
			 T5g = T5e + T5f;
			 T5C = T5e - T5f;
			 T5q = T4K + T4N;
			 T5r = T38 + T2P;
			 T5s = T5q + T5r;
			 T5G = T5q - T5r;
			 {
			      E T5j, T5t, T5m, T5u;
			      {
				   E T5h, T5i, T5k, T5l;
				   T5h = T3j + T3C;
				   T5i = T3M + T3P;
				   T5j = FNMS(KP195090322, T5i, KP980785280 * T5h);
				   T5t = FMA(KP195090322, T5h, KP980785280 * T5i);
				   T5k = T40 + T4j;
				   T5l = T4t + T4w;
				   T5m = FMA(KP980785280, T5k, KP195090322 * T5l);
				   T5u = FNMS(KP195090322, T5k, KP980785280 * T5l);
			      }
			      T5n = T5j + T5m;
			      T5H = T5j - T5m;
			      T5v = T5t + T5u;
			      T5D = T5u - T5t;
			 }
		    }
		    {
			 E T5o, T5w, T5d, T5p;
			 T5o = T5g - T5n;
			 T5w = T5s - T5v;
			 T5d = W[66];
			 T5p = W[67];
			 cr[WS(rs, 34)] = FNMS(T5p, T5w, T5d * T5o);
			 ci[WS(rs, 34)] = FMA(T5p, T5o, T5d * T5w);
		    }
		    {
			 E T5K, T5M, T5J, T5L;
			 T5K = T5C + T5D;
			 T5M = T5G + T5H;
			 T5J = W[34];
			 T5L = W[35];
			 cr[WS(rs, 18)] = FNMS(T5L, T5M, T5J * T5K);
			 ci[WS(rs, 18)] = FMA(T5J, T5M, T5L * T5K);
		    }
		    {
			 E T5y, T5A, T5x, T5z;
			 T5y = T5g + T5n;
			 T5A = T5s + T5v;
			 T5x = W[2];
			 T5z = W[3];
			 cr[WS(rs, 2)] = FNMS(T5z, T5A, T5x * T5y);
			 ci[WS(rs, 2)] = FMA(T5z, T5y, T5x * T5A);
		    }
		    {
			 E T5E, T5I, T5B, T5F;
			 T5E = T5C - T5D;
			 T5I = T5G - T5H;
			 T5B = W[98];
			 T5F = W[99];
			 cr[WS(rs, 50)] = FNMS(T5F, T5I, T5B * T5E);
			 ci[WS(rs, 50)] = FMA(T5B, T5I, T5F * T5E);
		    }
	       }
	       {
		    E T5Y, T6w, T6m, T6A, T6d, T6B, T6p, T6x;
		    {
			 E T5Q, T5X, T6i, T6l;
			 T5Q = T5O - T5P;
			 T5X = T5T - T5W;
			 T5Y = T5Q - T5X;
			 T6w = T5Q + T5X;
			 T6i = T6g - T6h;
			 T6l = T6j - T6k;
			 T6m = T6i - T6l;
			 T6A = T6i + T6l;
			 {
			      E T65, T6o, T6c, T6n;
			      {
				   E T61, T64, T68, T6b;
				   T61 = T5Z - T60;
				   T64 = T62 - T63;
				   T65 = FNMS(KP980785280, T64, KP195090322 * T61);
				   T6o = FMA(KP980785280, T61, KP195090322 * T64);
				   T68 = T66 - T67;
				   T6b = T69 - T6a;
				   T6c = FMA(KP195090322, T68, KP980785280 * T6b);
				   T6n = FNMS(KP980785280, T68, KP195090322 * T6b);
			      }
			      T6d = T65 - T6c;
			      T6B = T6c + T65;
			      T6p = T6n - T6o;
			      T6x = T6n + T6o;
			 }
		    }
		    {
			 E T6e, T6q, T5N, T6f;
			 T6e = T5Y - T6d;
			 T6q = T6m - T6p;
			 T5N = W[122];
			 T6f = W[123];
			 cr[WS(rs, 62)] = FNMS(T6f, T6q, T5N * T6e);
			 ci[WS(rs, 62)] = FMA(T6f, T6e, T5N * T6q);
		    }
		    {
			 E T6E, T6G, T6D, T6F;
			 T6E = T6w + T6x;
			 T6G = T6A + T6B;
			 T6D = W[26];
			 T6F = W[27];
			 cr[WS(rs, 14)] = FNMS(T6F, T6G, T6D * T6E);
			 ci[WS(rs, 14)] = FMA(T6D, T6G, T6F * T6E);
		    }
		    {
			 E T6s, T6u, T6r, T6t;
			 T6s = T5Y + T6d;
			 T6u = T6m + T6p;
			 T6r = W[58];
			 T6t = W[59];
			 cr[WS(rs, 30)] = FNMS(T6t, T6u, T6r * T6s);
			 ci[WS(rs, 30)] = FMA(T6t, T6s, T6r * T6u);
		    }
		    {
			 E T6y, T6C, T6v, T6z;
			 T6y = T6w - T6x;
			 T6C = T6A - T6B;
			 T6v = W[90];
			 T6z = W[91];
			 cr[WS(rs, 46)] = FNMS(T6z, T6C, T6v * T6y);
			 ci[WS(rs, 46)] = FMA(T6v, T6C, T6z * T6y);
		    }
	       }
	       {
		    E Tba, Tdw, TcS, Tdi, TcI, Tds, TcW, Td6, Tcr, TcX, TcL, TcT, Tdd, Tdx, Tdl;
		    E Tdt;
		    {
			 E Taw, Tdg, Tb9, Tdh, TaP, Tb8;
			 Taw = Tag - Tav;
			 Tdg = TcA + TcD;
			 TaP = FNMS(KP831469612, TaO, KP555570233 * TaH);
			 Tb8 = FMA(KP831469612, Tb0, KP555570233 * Tb7);
			 Tb9 = TaP - Tb8;
			 Tdh = Tb8 + TaP;
			 Tba = Taw + Tb9;
			 Tdw = Tdg - Tdh;
			 TcS = Taw - Tb9;
			 Tdi = Tdg + Tdh;
		    }
		    {
			 E TcE, Td4, TcH, Td5, TcF, TcG;
			 TcE = TcA - TcD;
			 Td4 = Tag + Tav;
			 TcF = FNMS(KP831469612, Tb7, KP555570233 * Tb0);
			 TcG = FMA(KP555570233, TaO, KP831469612 * TaH);
			 TcH = TcF - TcG;
			 Td5 = TcF + TcG;
			 TcI = TcE + TcH;
			 Tds = Td4 - Td5;
			 TcW = TcE - TcH;
			 Td6 = Td4 + Td5;
		    }
		    {
			 E TbN, TcJ, Tcq, TcK;
			 {
			      E TbB, TbM, Tce, Tcp;
			      TbB = Tbl - TbA;
			      TbM = TbI - TbL;
			      TbN = FNMS(KP956940335, TbM, KP290284677 * TbB);
			      TcJ = FMA(KP956940335, TbB, KP290284677 * TbM);
			      Tce = TbY - Tcd;
			      Tcp = Tcl - Tco;
			      Tcq = FMA(KP290284677, Tce, KP956940335 * Tcp);
			      TcK = FNMS(KP956940335, Tce, KP290284677 * Tcp);
			 }
			 Tcr = TbN + Tcq;
			 TcX = TbN - Tcq;
			 TcL = TcJ + TcK;
			 TcT = TcK - TcJ;
		    }
		    {
			 E Td9, Tdj, Tdc, Tdk;
			 {
			      E Td7, Td8, Tda, Tdb;
			      Td7 = Tbl + TbA;
			      Td8 = TbI + TbL;
			      Td9 = FNMS(KP471396736, Td8, KP881921264 * Td7);
			      Tdj = FMA(KP471396736, Td7, KP881921264 * Td8);
			      Tda = TbY + Tcd;
			      Tdb = Tcl + Tco;
			      Tdc = FMA(KP881921264, Tda, KP471396736 * Tdb);
			      Tdk = FNMS(KP471396736, Tda, KP881921264 * Tdb);
			 }
			 Tdd = Td9 + Tdc;
			 Tdx = Td9 - Tdc;
			 Tdl = Tdj + Tdk;
			 Tdt = Tdk - Tdj;
		    }
		    {
			 E Tcs, TcM, Ta5, Tct;
			 Tcs = Tba - Tcr;
			 TcM = TcI - TcL;
			 Ta5 = W[88];
			 Tct = W[89];
			 cr[WS(rs, 45)] = FNMS(Tct, TcM, Ta5 * Tcs);
			 ci[WS(rs, 45)] = FMA(Tct, Tcs, Ta5 * TcM);
		    }
		    {
			 E Tdu, Tdy, Tdr, Tdv;
			 Tdu = Tds - Tdt;
			 Tdy = Tdw - Tdx;
			 Tdr = W[104];
			 Tdv = W[105];
			 cr[WS(rs, 53)] = FNMS(Tdv, Tdy, Tdr * Tdu);
			 ci[WS(rs, 53)] = FMA(Tdr, Tdy, Tdv * Tdu);
		    }
		    {
			 E TdA, TdC, Tdz, TdB;
			 TdA = Tds + Tdt;
			 TdC = Tdw + Tdx;
			 Tdz = W[40];
			 TdB = W[41];
			 cr[WS(rs, 21)] = FNMS(TdB, TdC, Tdz * TdA);
			 ci[WS(rs, 21)] = FMA(Tdz, TdC, TdB * TdA);
		    }
		    {
			 E TcO, TcQ, TcN, TcP;
			 TcO = Tba + Tcr;
			 TcQ = TcI + TcL;
			 TcN = W[24];
			 TcP = W[25];
			 cr[WS(rs, 13)] = FNMS(TcP, TcQ, TcN * TcO);
			 ci[WS(rs, 13)] = FMA(TcP, TcO, TcN * TcQ);
		    }
		    {
			 E TcU, TcY, TcR, TcV;
			 TcU = TcS - TcT;
			 TcY = TcW - TcX;
			 TcR = W[120];
			 TcV = W[121];
			 cr[WS(rs, 61)] = FNMS(TcV, TcY, TcR * TcU);
			 ci[WS(rs, 61)] = FMA(TcR, TcY, TcV * TcU);
		    }
		    {
			 E Tde, Tdm, Td3, Tdf;
			 Tde = Td6 - Tdd;
			 Tdm = Tdi - Tdl;
			 Td3 = W[72];
			 Tdf = W[73];
			 cr[WS(rs, 37)] = FNMS(Tdf, Tdm, Td3 * Tde);
			 ci[WS(rs, 37)] = FMA(Tdf, Tde, Td3 * Tdm);
		    }
		    {
			 E Tdo, Tdq, Tdn, Tdp;
			 Tdo = Td6 + Tdd;
			 Tdq = Tdi + Tdl;
			 Tdn = W[8];
			 Tdp = W[9];
			 cr[WS(rs, 5)] = FNMS(Tdp, Tdq, Tdn * Tdo);
			 ci[WS(rs, 5)] = FMA(Tdp, Tdo, Tdn * Tdq);
		    }
		    {
			 E Td0, Td2, TcZ, Td1;
			 Td0 = TcS + TcT;
			 Td2 = TcW + TcX;
			 TcZ = W[56];
			 Td1 = W[57];
			 cr[WS(rs, 29)] = FNMS(Td1, Td2, TcZ * Td0);
			 ci[WS(rs, 29)] = FMA(TcZ, Td2, Td1 * Td0);
		    }
	       }
	       {
		    E Tfy, Thc, Tgy, TgY, Tgo, Th8, TgC, TgM, Tgb, TgD, Tgr, Tgz, TgT, Thd, Th1;
		    E Th9;
		    {
			 E Tfi, TgW, Tfx, TgX, Tfp, Tfw;
			 Tfi = Tfa - Tfh;
			 TgW = Tgg + Tgj;
			 Tfp = FNMS(KP555570233, Tfo, KP831469612 * Tfl);
			 Tfw = FMA(KP831469612, Tfs, KP555570233 * Tfv);
			 Tfx = Tfp - Tfw;
			 TgX = Tfw + Tfp;
			 Tfy = Tfi + Tfx;
			 Thc = TgW - TgX;
			 Tgy = Tfi - Tfx;
			 TgY = TgW + TgX;
		    }
		    {
			 E Tgk, TgK, Tgn, TgL, Tgl, Tgm;
			 Tgk = Tgg - Tgj;
			 TgK = Tfa + Tfh;
			 Tgl = FNMS(KP555570233, Tfs, KP831469612 * Tfv);
			 Tgm = FMA(KP555570233, Tfl, KP831469612 * Tfo);
			 Tgn = Tgl - Tgm;
			 TgL = Tgl + Tgm;
			 Tgo = Tgk + Tgn;
			 Th8 = TgK - TgL;
			 TgC = Tgk - Tgn;
			 TgM = TgK + TgL;
		    }
		    {
			 E TfR, Tgp, Tga, Tgq;
			 {
			      E TfJ, TfQ, Tg2, Tg9;
			      TfJ = TfB - TfI;
			      TfQ = TfM - TfP;
			      TfR = FNMS(KP881921264, TfQ, KP471396736 * TfJ);
			      Tgp = FMA(KP881921264, TfJ, KP471396736 * TfQ);
			      Tg2 = TfU - Tg1;
			      Tg9 = Tg5 - Tg8;
			      Tga = FMA(KP471396736, Tg2, KP881921264 * Tg9);
			      Tgq = FNMS(KP881921264, Tg2, KP471396736 * Tg9);
			 }
			 Tgb = TfR + Tga;
			 TgD = TfR - Tga;
			 Tgr = Tgp + Tgq;
			 Tgz = Tgq - Tgp;
		    }
		    {
			 E TgP, TgZ, TgS, Th0;
			 {
			      E TgN, TgO, TgQ, TgR;
			      TgN = TfB + TfI;
			      TgO = TfM + TfP;
			      TgP = FNMS(KP290284677, TgO, KP956940335 * TgN);
			      TgZ = FMA(KP290284677, TgN, KP956940335 * TgO);
			      TgQ = TfU + Tg1;
			      TgR = Tg5 + Tg8;
			      TgS = FMA(KP956940335, TgQ, KP290284677 * TgR);
			      Th0 = FNMS(KP290284677, TgQ, KP956940335 * TgR);
			 }
			 TgT = TgP + TgS;
			 Thd = TgP - TgS;
			 Th1 = TgZ + Th0;
			 Th9 = Th0 - TgZ;
		    }
		    {
			 E Tgc, Tgs, Tf7, Tgd;
			 Tgc = Tfy - Tgb;
			 Tgs = Tgo - Tgr;
			 Tf7 = W[84];
			 Tgd = W[85];
			 cr[WS(rs, 43)] = FNMS(Tgd, Tgs, Tf7 * Tgc);
			 ci[WS(rs, 43)] = FMA(Tgd, Tgc, Tf7 * Tgs);
		    }
		    {
			 E Tha, The, Th7, Thb;
			 Tha = Th8 - Th9;
			 The = Thc - Thd;
			 Th7 = W[100];
			 Thb = W[101];
			 cr[WS(rs, 51)] = FNMS(Thb, The, Th7 * Tha);
			 ci[WS(rs, 51)] = FMA(Th7, The, Thb * Tha);
		    }
		    {
			 E Thg, Thi, Thf, Thh;
			 Thg = Th8 + Th9;
			 Thi = Thc + Thd;
			 Thf = W[36];
			 Thh = W[37];
			 cr[WS(rs, 19)] = FNMS(Thh, Thi, Thf * Thg);
			 ci[WS(rs, 19)] = FMA(Thf, Thi, Thh * Thg);
		    }
		    {
			 E Tgu, Tgw, Tgt, Tgv;
			 Tgu = Tfy + Tgb;
			 Tgw = Tgo + Tgr;
			 Tgt = W[20];
			 Tgv = W[21];
			 cr[WS(rs, 11)] = FNMS(Tgv, Tgw, Tgt * Tgu);
			 ci[WS(rs, 11)] = FMA(Tgv, Tgu, Tgt * Tgw);
		    }
		    {
			 E TgA, TgE, Tgx, TgB;
			 TgA = Tgy - Tgz;
			 TgE = TgC - TgD;
			 Tgx = W[116];
			 TgB = W[117];
			 cr[WS(rs, 59)] = FNMS(TgB, TgE, Tgx * TgA);
			 ci[WS(rs, 59)] = FMA(Tgx, TgE, TgB * TgA);
		    }
		    {
			 E TgU, Th2, TgJ, TgV;
			 TgU = TgM - TgT;
			 Th2 = TgY - Th1;
			 TgJ = W[68];
			 TgV = W[69];
			 cr[WS(rs, 35)] = FNMS(TgV, Th2, TgJ * TgU);
			 ci[WS(rs, 35)] = FMA(TgV, TgU, TgJ * Th2);
		    }
		    {
			 E Th4, Th6, Th3, Th5;
			 Th4 = TgM + TgT;
			 Th6 = TgY + Th1;
			 Th3 = W[4];
			 Th5 = W[5];
			 cr[WS(rs, 3)] = FNMS(Th5, Th6, Th3 * Th4);
			 ci[WS(rs, 3)] = FMA(Th5, Th4, Th3 * Th6);
		    }
		    {
			 E TgG, TgI, TgF, TgH;
			 TgG = Tgy + Tgz;
			 TgI = TgC + TgD;
			 TgF = W[52];
			 TgH = W[53];
			 cr[WS(rs, 27)] = FNMS(TgH, TgI, TgF * TgG);
			 ci[WS(rs, 27)] = FMA(TgF, TgI, TgH * TgG);
		    }
	       }
	       {
		    E TdO, Tf0, Tem, TeM, Tec, TeW, Teq, TeA, Te3, Ter, Tef, Ten, TeH, Tf1, TeP;
		    E TeX;
		    {
			 E TdG, TeK, TdN, TeL, TdJ, TdM;
			 TdG = TdE - TdF;
			 TeK = Te6 + Te7;
			 TdJ = FNMS(KP195090322, TdI, KP980785280 * TdH);
			 TdM = FMA(KP195090322, TdK, KP980785280 * TdL);
			 TdN = TdJ - TdM;
			 TeL = TdM + TdJ;
			 TdO = TdG - TdN;
			 Tf0 = TeK + TeL;
			 Tem = TdG + TdN;
			 TeM = TeK - TeL;
		    }
		    {
			 E Te8, Tey, Teb, Tez, Te9, Tea;
			 Te8 = Te6 - Te7;
			 Tey = TdE + TdF;
			 Te9 = FNMS(KP195090322, TdL, KP980785280 * TdK);
			 Tea = FMA(KP980785280, TdI, KP195090322 * TdH);
			 Teb = Te9 - Tea;
			 Tez = Te9 + Tea;
			 Tec = Te8 - Teb;
			 TeW = Tey + Tez;
			 Teq = Te8 + Teb;
			 TeA = Tey - Tez;
		    }
		    {
			 E TdV, Tee, Te2, Ted;
			 {
			      E TdR, TdU, TdY, Te1;
			      TdR = TdP - TdQ;
			      TdU = TdS - TdT;
			      TdV = FNMS(KP773010453, TdU, KP634393284 * TdR);
			      Tee = FMA(KP773010453, TdR, KP634393284 * TdU);
			      TdY = TdW - TdX;
			      Te1 = TdZ - Te0;
			      Te2 = FMA(KP634393284, TdY, KP773010453 * Te1);
			      Ted = FNMS(KP773010453, TdY, KP634393284 * Te1);
			 }
			 Te3 = TdV - Te2;
			 Ter = Te2 + TdV;
			 Tef = Ted - Tee;
			 Ten = Ted + Tee;
		    }
		    {
			 E TeD, TeO, TeG, TeN;
			 {
			      E TeB, TeC, TeE, TeF;
			      TeB = TdP + TdQ;
			      TeC = TdS + TdT;
			      TeD = FNMS(KP098017140, TeC, KP995184726 * TeB);
			      TeO = FMA(KP098017140, TeB, KP995184726 * TeC);
			      TeE = TdW + TdX;
			      TeF = TdZ + Te0;
			      TeG = FMA(KP995184726, TeE, KP098017140 * TeF);
			      TeN = FNMS(KP098017140, TeE, KP995184726 * TeF);
			 }
			 TeH = TeD - TeG;
			 Tf1 = TeG + TeD;
			 TeP = TeN - TeO;
			 TeX = TeN + TeO;
		    }
		    {
			 E Te4, Teg, TdD, Te5;
			 Te4 = TdO - Te3;
			 Teg = Tec - Tef;
			 TdD = W[112];
			 Te5 = W[113];
			 cr[WS(rs, 57)] = FNMS(Te5, Teg, TdD * Te4);
			 ci[WS(rs, 57)] = FMA(Te5, Te4, TdD * Teg);
		    }
		    {
			 E TeY, Tf2, TeV, TeZ;
			 TeY = TeW - TeX;
			 Tf2 = Tf0 - Tf1;
			 TeV = W[64];
			 TeZ = W[65];
			 cr[WS(rs, 33)] = FNMS(TeZ, Tf2, TeV * TeY);
			 ci[WS(rs, 33)] = FMA(TeV, Tf2, TeZ * TeY);
		    }
		    {
			 E Tf4, Tf6, Tf3, Tf5;
			 Tf4 = TeW + TeX;
			 Tf6 = Tf0 + Tf1;
			 Tf3 = W[0];
			 Tf5 = W[1];
			 cr[WS(rs, 1)] = FNMS(Tf5, Tf6, Tf3 * Tf4);
			 ci[WS(rs, 1)] = FMA(Tf3, Tf6, Tf5 * Tf4);
		    }
		    {
			 E Tei, Tek, Teh, Tej;
			 Tei = TdO + Te3;
			 Tek = Tec + Tef;
			 Teh = W[48];
			 Tej = W[49];
			 cr[WS(rs, 25)] = FNMS(Tej, Tek, Teh * Tei);
			 ci[WS(rs, 25)] = FMA(Tej, Tei, Teh * Tek);
		    }
		    {
			 E Teo, Tes, Tel, Tep;
			 Teo = Tem - Ten;
			 Tes = Teq - Ter;
			 Tel = W[80];
			 Tep = W[81];
			 cr[WS(rs, 41)] = FNMS(Tep, Tes, Tel * Teo);
			 ci[WS(rs, 41)] = FMA(Tel, Tes, Tep * Teo);
		    }
		    {
			 E TeI, TeQ, Tex, TeJ;
			 TeI = TeA - TeH;
			 TeQ = TeM - TeP;
			 Tex = W[96];
			 TeJ = W[97];
			 cr[WS(rs, 49)] = FNMS(TeJ, TeQ, Tex * TeI);
			 ci[WS(rs, 49)] = FMA(TeJ, TeI, Tex * TeQ);
		    }
		    {
			 E TeS, TeU, TeR, TeT;
			 TeS = TeA + TeH;
			 TeU = TeM + TeP;
			 TeR = W[32];
			 TeT = W[33];
			 cr[WS(rs, 17)] = FNMS(TeT, TeU, TeR * TeS);
			 ci[WS(rs, 17)] = FMA(TeT, TeS, TeR * TeU);
		    }
		    {
			 E Teu, Tew, Tet, Tev;
			 Teu = Tem + Ten;
			 Tew = Teq + Ter;
			 Tet = W[16];
			 Tev = W[17];
			 cr[WS(rs, 9)] = FNMS(Tev, Tew, Tet * Teu);
			 ci[WS(rs, 9)] = FMA(Tet, Tew, Tev * Teu);
		    }
	       }
	       {
		    E Thu, TiG, Ti2, Tis, ThS, TiC, Ti6, Tig, ThJ, Ti7, ThV, Ti3, Tin, TiH, Tiv;
		    E TiD;
		    {
			 E Thm, Tiq, Tht, Tir, Thp, Ths;
			 Thm = Thk - Thl;
			 Tiq = ThM - ThN;
			 Thp = FNMS(KP980785280, Tho, KP195090322 * Thn);
			 Ths = FNMS(KP980785280, Thr, KP195090322 * Thq);
			 Tht = Thp + Ths;
			 Tir = Thp - Ths;
			 Thu = Thm - Tht;
			 TiG = Tiq - Tir;
			 Ti2 = Thm + Tht;
			 Tis = Tiq + Tir;
		    }
		    {
			 E ThO, Tie, ThR, Tif, ThP, ThQ;
			 ThO = ThM + ThN;
			 Tie = Thk + Thl;
			 ThP = FMA(KP195090322, Tho, KP980785280 * Thn);
			 ThQ = FMA(KP195090322, Thr, KP980785280 * Thq);
			 ThR = ThP - ThQ;
			 Tif = ThP + ThQ;
			 ThS = ThO - ThR;
			 TiC = Tie + Tif;
			 Ti6 = ThO + ThR;
			 Tig = Tie - Tif;
		    }
		    {
			 E ThB, ThU, ThI, ThT;
			 {
			      E Thx, ThA, ThE, ThH;
			      Thx = Thv - Thw;
			      ThA = Thy - Thz;
			      ThB = FNMS(KP634393284, ThA, KP773010453 * Thx);
			      ThU = FMA(KP634393284, Thx, KP773010453 * ThA);
			      ThE = ThC + ThD;
			      ThH = ThF - ThG;
			      ThI = FMA(KP773010453, ThE, KP634393284 * ThH);
			      ThT = FNMS(KP634393284, ThE, KP773010453 * ThH);
			 }
			 ThJ = ThB - ThI;
			 Ti7 = ThI + ThB;
			 ThV = ThT - ThU;
			 Ti3 = ThT + ThU;
		    }
		    {
			 E Tij, Tit, Tim, Tiu;
			 {
			      E Tih, Tii, Tik, Til;
			      Tih = ThF + ThG;
			      Tii = ThC - ThD;
			      Tij = FNMS(KP995184726, Tii, KP098017140 * Tih);
			      Tit = FMA(KP098017140, Tii, KP995184726 * Tih);
			      Tik = Thy + Thz;
			      Til = Thw + Thv;
			      Tim = FNMS(KP995184726, Til, KP098017140 * Tik);
			      Tiu = FMA(KP098017140, Til, KP995184726 * Tik);
			 }
			 Tin = Tij + Tim;
			 TiH = Tij - Tim;
			 Tiv = Tit - Tiu;
			 TiD = Tit + Tiu;
		    }
		    {
			 E ThK, ThW, Thj, ThL;
			 ThK = Thu - ThJ;
			 ThW = ThS - ThV;
			 Thj = W[108];
			 ThL = W[109];
			 cr[WS(rs, 55)] = FNMS(ThL, ThW, Thj * ThK);
			 ci[WS(rs, 55)] = FMA(ThL, ThK, Thj * ThW);
		    }
		    {
			 E TiE, TiI, TiB, TiF;
			 TiE = TiC - TiD;
			 TiI = TiG + TiH;
			 TiB = W[60];
			 TiF = W[61];
			 cr[WS(rs, 31)] = FNMS(TiF, TiI, TiB * TiE);
			 ci[WS(rs, 31)] = FMA(TiB, TiI, TiF * TiE);
		    }
		    {
			 E TiK, TiM, TiJ, TiL;
			 TiK = TiC + TiD;
			 TiM = TiG - TiH;
			 TiJ = W[124];
			 TiL = W[125];
			 cr[WS(rs, 63)] = FNMS(TiL, TiM, TiJ * TiK);
			 ci[WS(rs, 63)] = FMA(TiJ, TiM, TiL * TiK);
		    }
		    {
			 E ThY, Ti0, ThX, ThZ;
			 ThY = Thu + ThJ;
			 Ti0 = ThS + ThV;
			 ThX = W[44];
			 ThZ = W[45];
			 cr[WS(rs, 23)] = FNMS(ThZ, Ti0, ThX * ThY);
			 ci[WS(rs, 23)] = FMA(ThZ, ThY, ThX * Ti0);
		    }
		    {
			 E Ti4, Ti8, Ti1, Ti5;
			 Ti4 = Ti2 - Ti3;
			 Ti8 = Ti6 - Ti7;
			 Ti1 = W[76];
			 Ti5 = W[77];
			 cr[WS(rs, 39)] = FNMS(Ti5, Ti8, Ti1 * Ti4);
			 ci[WS(rs, 39)] = FMA(Ti1, Ti8, Ti5 * Ti4);
		    }
		    {
			 E Tio, Tiw, Tid, Tip;
			 Tio = Tig - Tin;
			 Tiw = Tis - Tiv;
			 Tid = W[92];
			 Tip = W[93];
			 cr[WS(rs, 47)] = FNMS(Tip, Tiw, Tid * Tio);
			 ci[WS(rs, 47)] = FMA(Tip, Tio, Tid * Tiw);
		    }
		    {
			 E Tiy, TiA, Tix, Tiz;
			 Tiy = Tig + Tin;
			 TiA = Tis + Tiv;
			 Tix = W[28];
			 Tiz = W[29];
			 cr[WS(rs, 15)] = FNMS(Tiz, TiA, Tix * Tiy);
			 ci[WS(rs, 15)] = FMA(Tiz, Tiy, Tix * TiA);
		    }
		    {
			 E Tia, Tic, Ti9, Tib;
			 Tia = Ti2 + Ti3;
			 Tic = Ti6 + Ti7;
			 Ti9 = W[12];
			 Tib = W[13];
			 cr[WS(rs, 7)] = FNMS(Tib, Tic, Ti9 * Tia);
			 ci[WS(rs, 7)] = FMA(Ti9, Tic, Tib * Tia);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hb_64", twinstr, &GENUS, {808, 270, 230, 0} };

void X(codelet_hb_64) (planner *p) {
     X(khc2hc_register) (p, hb_64, &desc);
}
#endif
