import { BinaryView, Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gsub } from "@ot-builder/ot-layout";
import { LookupReader, LookupWriter, SubtableReadingContext, SubtableWriteContext } from "../gsub-gpos-shared/general";
declare class GsubMultiAlternateReaderBase {
    parseSubtable(view: BinaryView, lookup: Gsub.Multiple | Gsub.Alternate, context: SubtableReadingContext<Gsub.Lookup>): void;
}
declare class State {
    mapping: Map<OtGlyph, ReadonlyArray<OtGlyph>>;
    size: number;
    tryAddMapping(from: OtGlyph, to: ReadonlyArray<OtGlyph>): boolean;
}
declare class GsubMultiAlternateWriterBase {
    flush(frags: Frag[], state: State, ctx: SubtableWriteContext<Gsub.Lookup>): void;
    createSubtableFragments(lookup: Gsub.Multiple | Gsub.Alternate, ctx: SubtableWriteContext<Gsub.Lookup>): Frag[];
}
export declare class GsubMultiReader extends GsubMultiAlternateReaderBase implements LookupReader<Gsub.Lookup, Gsub.Multiple> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gsub.LookupType.Multi, Gsub.MultipleAlternateProp>;
}
export declare class GsubAlternateReader extends GsubMultiAlternateReaderBase implements LookupReader<Gsub.Lookup, Gsub.Alternate> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gsub.LookupType.Alternate, Gsub.MultipleAlternateProp>;
}
export declare class GsubMultiWriter extends GsubMultiAlternateWriterBase implements LookupWriter<Gsub.Lookup, Gsub.Multiple> {
    canBeUsed(l: Gsub.Lookup): l is Gsub.Multiple;
    getLookupTypeSymbol(): symbol;
    getLookupType(): number;
}
export declare class GsubAlternateWriter extends GsubMultiAlternateWriterBase implements LookupWriter<Gsub.Lookup, Gsub.Alternate> {
    canBeUsed(l: Gsub.Lookup): l is Gsub.Alternate;
    getLookupTypeSymbol(): symbol;
    getLookupType(): number;
}
export {};
//# sourceMappingURL=gsub-multi-alternate.d.ts.map