/***************************************************************************
 *            gbemol-net.c
 *  Functions to download files, using curl
 *  Mon Oct 29 23:43:20 2007
 *  Copyright  2007  felipe
 *  <felipe.weckx@gmail.com>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <curl/curl.h>

#include "gbemol-net.h"

gchar *gbemol_net_escape (const gchar * string)
{
	const gchar *p;
	GString *escaped;

	escaped = g_string_new (NULL);
	p = string;

	/* simply escape all chars which are not [A-Z][a-z][0-9] */
	while (*p != '\0') {
		if (*p < 0x30 || (*p > 0x39 && *p < 0x41) || (*p > 0x5a && *p < 0x61) || *p > 0x7a) {
			g_string_append_printf (escaped, "%%%02X", (guchar) *p);
		} else {
			g_string_append_c (escaped, *p);
		}
		p++;
	}
	return g_string_free (escaped, FALSE);
}


/**
 * Download a file from url and save it on local_path
 */
gboolean gbemol_net_download_file(gchar *url, gchar *local_path, GError **err)
{
	FILE *fp;
	CURL *curl;
	CURLcode res;
	gboolean ret = TRUE;
   	
	/* Attempt to create local file */
	if ((fp = g_fopen (local_path, "w+")) == NULL) 
	{
		g_set_error (err, 0, 0, "Error creating cover file: '%s': %s.", local_path, g_strerror (errno));		
		ret = FALSE;
	}
	
	/* Attempt to download file */
	curl = curl_easy_init();   	
	if(curl) 	
	{
    	curl_easy_setopt(curl, CURLOPT_URL, url);
		curl_easy_setopt (curl, CURLOPT_WRITEDATA, fp);
     	res = curl_easy_perform(curl);
 		
     	/* cleanup */
     	curl_easy_cleanup(curl);
   	} 
	else 
	{
		ret = FALSE;
	}
	
	fclose(fp);
	
	return ret;
}
	

 
