/* { dg-do compile { target lp64 } } */
/* { dg-require-effective-target powerpc_p9vector_ok } */
/* { dg-options "-mdejagnu-cpu=power9 -O2" } */

/* Verify that the XXBR{H,W} instructions are generated if the value is
   forced to be in a vector register, and XXBRD is generated all of the
   time for register bswap64's.  */

unsigned short
do_bswap16_mem (unsigned short *p)
{
  return __builtin_bswap16 (*p);	/* LHBRX.  */
}

unsigned short
do_bswap16_reg (unsigned short a)
{
  return __builtin_bswap16 (a);		/* gpr sequences.  */
}

void
do_bswap16_store (unsigned short *p, unsigned short a)
{
  *p = __builtin_bswap16 (a);		/* STHBRX.  */
}

unsigned short
do_bswap16_vect (unsigned short a)
{
  __asm__ (" # %x0" : "+v" (a));
  return __builtin_bswap16 (a);		/* XXBRW.  */
}

unsigned int
do_bswap32_mem (unsigned int *p)
{
  return __builtin_bswap32 (*p);	/* LWBRX.  */
}

unsigned int
do_bswap32_reg (unsigned int a)
{
  return __builtin_bswap32 (a);		/* gpr sequences.  */
}

void
do_bswap32_store (unsigned int *p, unsigned int a)
{
  *p = __builtin_bswap32 (a);		/* STWBRX.  */
}

unsigned int
do_bswap32_vect (unsigned int a)
{
  __asm__ (" # %x0" : "+v" (a));
  return __builtin_bswap32 (a);		/* XXBRW.  */
}

unsigned long
do_bswap64_mem (unsigned long *p)
{
  return __builtin_bswap64 (*p);	/* LDBRX.  */
}

unsigned long
do_bswap64_reg (unsigned long a)
{
  return __builtin_bswap64 (a);		/* gpr sequences.  */
}

void
do_bswap64_store (unsigned long *p, unsigned int a)
{
  *p = __builtin_bswap64 (a);		/* STDBRX.  */
}

double
do_bswap64_double (unsigned long a)
{
  return (double) __builtin_bswap64 (a);	/* XXBRD.  */
}

unsigned long
do_bswap64_vect (unsigned long a)
{
  __asm__ (" # %x0" : "+v" (a));	/* XXBRD.  */
  return __builtin_bswap64 (a);
}

/* Make sure XXBR{H,W,D} is not generated by default.  */
/* { dg-final { scan-assembler-times "xxbrd"  3  } } */
/* { dg-final { scan-assembler-times "xxbrh"  1  } } */
/* { dg-final { scan-assembler-times "xxbrw"  1  } } */
/* { dg-final { scan-assembler-times "ldbrx"  1  } } */
/* { dg-final { scan-assembler-times "lhbrx"  1  } } */
/* { dg-final { scan-assembler-times "lwbrx"  1  } } */
/* { dg-final { scan-assembler-times "stdbrx" 1  } } */
/* { dg-final { scan-assembler-times "sthbrx" 1  } } */
/* { dg-final { scan-assembler-times "stwbrx" 1  } } */
