/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>
#include <shumate/shumate.h>

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_SUBMISSION_MARKER (geoclue_stumbler_submission_marker_get_type())
G_DECLARE_FINAL_TYPE (GeoclueStumblerSubmissionMarker, geoclue_stumbler_submission_marker, GEOCLUE_STUMBLER, SUBMISSION_MARKER, ShumateMarker)

GeoclueStumblerSubmissionMarker *geoclue_stumbler_submission_marker_new (void);

void geoclue_stumbler_submission_marker_set_wifi_aps (GeoclueStumblerSubmissionMarker *self,
                                                      double wifi_aps);

void geoclue_stumbler_submission_marker_set_cell_towers (GeoclueStumblerSubmissionMarker *self,
                                                         double cell_towers);

void geoclue_stumbler_submission_marker_set_time_str (GeoclueStumblerSubmissionMarker *self,
                                                      const char *time_str);

G_END_DECLS
