library ieee;
use ieee.std_logic_1164.all;


library ieee;
use ieee.numeric_std.all;

entity bit_set_mask is
	port (
		clk : in  std_logic;
		ra0_addr : in  std_logic_vector(4 downto 0);
		ra0_data : out std_logic_vector(31 downto 0)
	);
end bit_set_mask;
architecture augh of bit_set_mask is

	-- Embedded RAM

	type ram_type is array (0 to 31) of std_logic_vector(31 downto 0);
	signal ram : ram_type := (
		"00000000000000000000000000000001", "00000000000000000000000000000010", "00000000000000000000000000000100",
		"00000000000000000000000000001000", "00000000000000000000000000010000", "00000000000000000000000000100000",
		"00000000000000000000000001000000", "00000000000000000000000010000000", "00000000000000000000000100000000",
		"00000000000000000000001000000000", "00000000000000000000010000000000", "00000000000000000000100000000000",
		"00000000000000000001000000000000", "00000000000000000010000000000000", "00000000000000000100000000000000",
		"00000000000000001000000000000000", "00000000000000010000000000000000", "00000000000000100000000000000000",
		"00000000000001000000000000000000", "00000000000010000000000000000000", "00000000000100000000000000000000",
		"00000000001000000000000000000000", "00000000010000000000000000000000", "00000000100000000000000000000000",
		"00000001000000000000000000000000", "00000010000000000000000000000000", "00000100000000000000000000000000",
		"00001000000000000000000000000000", "00010000000000000000000000000000", "00100000000000000000000000000000",
		"01000000000000000000000000000000", "10000000000000000000000000000000"
	);


	-- Little utility functions to make VHDL syntactically correct
	--   with the syntax to_integer(unsigned(vector)) when 'vector' is a std_logic.
	--   This happens when accessing arrays with <= 2 cells, for example.

	function to_integer(B: std_logic) return integer is
		variable V: std_logic_vector(0 to 0);
	begin
		V(0) := B;
		return to_integer(unsigned(V));
	end;

	function to_integer(V: std_logic_vector) return integer is
	begin
		return to_integer(unsigned(V));
	end;

begin

	-- The component is a ROM.
	-- There is no Write side.

	-- The Read side (the outputs)

	ra0_data <= ram( to_integer(ra0_addr) );

end architecture;
