/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpcontext_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"


/**
 * SECTION: gimpcontext
 * @title: gimpcontext
 * @short_description: Functions to manipulate a plug-in's context.
 *
 * Functions to manipulate a plug-in's context.
 **/


/**
 * gimp_context_push:
 *
 * Pushes a context to the top of the plug-in's context stack.
 *
 * This procedure creates a new context by copying the current context.
 * This copy becomes the new current context for the calling plug-in
 * until it is popped again using gimp_context_pop().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_push (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-push",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_pop:
 *
 * Pops the topmost context from the plug-in's context stack.
 *
 * This procedure removes the topmost context from the plug-in's
 * context stack. The context that was active before the corresponding
 * call to gimp_context_push() becomes the new current context of the
 * plug-in.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_pop (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-pop",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_defaults:
 *
 * Reset context settings to their default values.
 *
 * This procedure resets context settings used by various procedures to
 * their default value. This procedure will usually be called after a
 * context push so that a script which calls procedures affected by
 * context settings will not be affected by changes in the global
 * context.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_defaults (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-defaults",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_list_paint_methods:
 * @num_paint_methods: The number of the available paint methods.
 * @paint_methods: The names of the available paint methods.
 *
 * Lists the available paint methods.
 *
 * This procedure lists the names of the available paint methods. Any
 * of the results can be used for gimp_context_set_paint_method().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_context_list_paint_methods (gint    *num_paint_methods,
                                 gchar ***paint_methods)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;
  gint i;

  return_vals = gimp_run_procedure ("gimp-context-list-paint-methods",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  *num_paint_methods = 0;
  *paint_methods = NULL;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_paint_methods = return_vals[1].data.d_int32;
      if (*num_paint_methods > 0)
        {
          *paint_methods = g_new0 (gchar *, *num_paint_methods + 1);
          for (i = 0; i < *num_paint_methods; i++)
            (*paint_methods)[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
        }
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_paint_method:
 *
 * Retrieve the currently active paint method.
 *
 * This procedure returns the name of the currently active paint
 * method.
 *
 * Returns: The name of the active paint method.
 *
 * Since: 2.4
 **/
gchar *
gimp_context_get_paint_method (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-paint-method",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_paint_method:
 * @name: The name of the paint method.
 *
 * Set the specified paint method as the active paint method.
 *
 * This procedure allows the active paint method to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the available paint methods. If there is no
 * matching method found, this procedure will return an error.
 * Otherwise, the specified method becomes active and will be used in
 * all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_context_set_paint_method (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-paint-method",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_stroke_method:
 *
 * Retrieve the currently active stroke method.
 *
 * This procedure returns the currently active stroke method.
 *
 * Returns: The active stroke method.
 *
 * Since: 2.10
 **/
GimpStrokeMethod
gimp_context_get_stroke_method (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpStrokeMethod stroke_method = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-stroke-method",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    stroke_method = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return stroke_method;
}

/**
 * gimp_context_set_stroke_method:
 * @stroke_method: The new stroke method.
 *
 * Set the specified stroke method as the active stroke method.
 *
 * This procedure set the specified stroke method as the active stroke
 * method. The new method will be used in all subsequent stroke
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_stroke_method (GimpStrokeMethod stroke_method)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-stroke-method",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, stroke_method,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_foreground:
 * @foreground: The foreground color.
 *
 * Get the current GIMP foreground color.
 *
 * This procedure returns the current GIMP foreground color. The
 * foreground color is used in a variety of tools such as paint tools,
 * blending, and bucket fill.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_get_foreground (GimpRGB *foreground)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-foreground",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *foreground = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_foreground:
 * @foreground: The foreground color.
 *
 * Set the current GIMP foreground color.
 *
 * This procedure sets the current GIMP foreground color. After this is
 * set, operations which use foreground such as paint tools, blending,
 * and bucket fill will use the new value.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_foreground (const GimpRGB *foreground)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-foreground",
                                    &nreturn_vals,
                                    GIMP_PDB_COLOR, foreground,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_background:
 * @background: The background color.
 *
 * Get the current GIMP background color.
 *
 * This procedure returns the current GIMP background color. The
 * background color is used in a variety of tools such as blending,
 * erasing (with non-alpha images), and image filling.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_get_background (GimpRGB *background)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-background",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *background = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_background:
 * @background: The background color.
 *
 * Set the current GIMP background color.
 *
 * This procedure sets the current GIMP background color. After this is
 * set, operations which use background such as blending, filling
 * images, clearing, and erasing (in non-alpha images) will use the new
 * value.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_background (const GimpRGB *background)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-background",
                                    &nreturn_vals,
                                    GIMP_PDB_COLOR, background,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_default_colors:
 *
 * Set the current GIMP foreground and background colors to black and
 * white.
 *
 * This procedure sets the current GIMP foreground and background
 * colors to their initial default values, black and white.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_default_colors (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-default-colors",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_swap_colors:
 *
 * Swap the current GIMP foreground and background colors.
 *
 * This procedure swaps the current GIMP foreground and background
 * colors, so that the new foreground color becomes the old background
 * color and vice versa.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_swap_colors (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-swap-colors",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_opacity:
 *
 * Get the opacity.
 *
 * This procedure returns the opacity setting. The return value is a
 * floating point number between 0 and 100.
 *
 * Returns: The opacity.
 *
 * Since: 2.2
 **/
gdouble
gimp_context_get_opacity (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble opacity = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-opacity",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    opacity = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return opacity;
}

/**
 * gimp_context_set_opacity:
 * @opacity: The opacity.
 *
 * Set the opacity.
 *
 * This procedure modifies the opacity setting. The value should be a
 * floating point number between 0 and 100.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_opacity (gdouble opacity)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-opacity",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, opacity,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_paint_mode:
 *
 * Get the paint mode.
 *
 * This procedure returns the paint-mode setting. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The paint mode.
 *
 * Since: 2.2
 **/
GimpLayerMode
gimp_context_get_paint_mode (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpLayerMode paint_mode = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-paint-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    paint_mode = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return paint_mode;
}

/**
 * gimp_context_set_paint_mode:
 * @paint_mode: The paint mode.
 *
 * Set the paint mode.
 *
 * This procedure modifies the paint_mode setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_paint_mode (GimpLayerMode paint_mode)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-paint-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, paint_mode,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_width:
 *
 * Get the line width setting.
 *
 * This procedure returns the line width setting.
 *
 * Returns: The line width setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_width (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble line_width = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-width",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    line_width = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return line_width;
}

/**
 * gimp_context_set_line_width:
 * @line_width: The line width setting.
 *
 * Set the line width setting.
 *
 * This procedure modifies the line width setting for stroking lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_width (gdouble line_width)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-width",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, line_width,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_width_unit:
 *
 * Get the line width unit setting.
 *
 * This procedure returns the line width unit setting.
 *
 * Returns: The line width unit setting.
 *
 * Since: 2.10
 **/
GimpUnit
gimp_context_get_line_width_unit (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpUnit line_width_unit = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-width-unit",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    line_width_unit = return_vals[1].data.d_unit;

  gimp_destroy_params (return_vals, nreturn_vals);

  return line_width_unit;
}

/**
 * gimp_context_set_line_width_unit:
 * @line_width_unit: The line width setting unit.
 *
 * Set the line width unit setting.
 *
 * This procedure modifies the line width unit setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_width_unit (GimpUnit line_width_unit)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-width-unit",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, line_width_unit,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_cap_style:
 *
 * Get the line cap style setting.
 *
 * This procedure returns the line cap style setting.
 *
 * Returns: The line cap style setting.
 *
 * Since: 2.10
 **/
GimpCapStyle
gimp_context_get_line_cap_style (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpCapStyle cap_style = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-cap-style",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    cap_style = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return cap_style;
}

/**
 * gimp_context_set_line_cap_style:
 * @cap_style: The line cap style setting.
 *
 * Set the line cap style setting.
 *
 * This procedure modifies the line cap style setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_cap_style (GimpCapStyle cap_style)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-cap-style",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, cap_style,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_join_style:
 *
 * Get the line join style setting.
 *
 * This procedure returns the line join style setting.
 *
 * Returns: The line join style setting.
 *
 * Since: 2.10
 **/
GimpJoinStyle
gimp_context_get_line_join_style (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpJoinStyle join_style = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-join-style",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    join_style = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return join_style;
}

/**
 * gimp_context_set_line_join_style:
 * @join_style: The line join style setting.
 *
 * Set the line join style setting.
 *
 * This procedure modifies the line join style setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_join_style (GimpJoinStyle join_style)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-join-style",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, join_style,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_miter_limit:
 *
 * Get the line miter limit setting.
 *
 * This procedure returns the line miter limit setting.
 *
 * Returns: The line miter limit setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_miter_limit (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble miter_limit = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-miter-limit",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    miter_limit = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return miter_limit;
}

/**
 * gimp_context_set_line_miter_limit:
 * @miter_limit: The line miter limit setting.
 *
 * Set the line miter limit setting.
 *
 * This procedure modifies the line miter limit setting for stroking
 * lines.
 * A mitered join is converted to a bevelled join if the miter would
 * extend to a distance of more than (miter-limit * line-width) from
 * the actual join point.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_miter_limit (gdouble miter_limit)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-miter-limit",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, miter_limit,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_dash_offset:
 *
 * Get the line dash offset setting.
 *
 * This procedure returns the line dash offset setting.
 *
 * Returns: The line dash offset setting.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_line_dash_offset (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble dash_offset = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-line-dash-offset",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    dash_offset = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return dash_offset;
}

/**
 * gimp_context_set_line_dash_offset:
 * @dash_offset: The line dash offset setting.
 *
 * Set the line dash offset setting.
 *
 * This procedure modifies the line dash offset setting for stroking
 * lines.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_dash_offset (gdouble dash_offset)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-dash-offset",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, dash_offset,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_line_dash_pattern:
 * @num_dashes: The number of dashes in the dash_pattern array.
 * @dashes: The line dash pattern setting.
 *
 * Get the line dash pattern setting.
 *
 * This procedure returns the line dash pattern setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_line_dash_pattern (gint     *num_dashes,
                                    gdouble **dashes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-line-dash-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  *num_dashes = 0;
  *dashes = NULL;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_dashes = return_vals[1].data.d_int32;
      *dashes = g_new (gdouble, *num_dashes);
      memcpy (*dashes,
              return_vals[2].data.d_floatarray,
              *num_dashes * sizeof (gdouble));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_line_dash_pattern:
 * @num_dashes: The number of dashes in the dash_pattern array.
 * @dashes: The line dash pattern setting.
 *
 * Set the line dash pattern setting.
 *
 * This procedure modifies the line dash pattern setting for stroking
 * lines.
 *
 * The unit of the dash pattern segments is the actual line width used
 * for the stroke operation, in other words a segment length of 1.0
 * results in a square segment shape (or gap shape).
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_stroke_selection_(),
 * gimp_drawable_edit_stroke_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_line_dash_pattern (gint           num_dashes,
                                    const gdouble *dashes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-line-dash-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, num_dashes,
                                    GIMP_PDB_FLOATARRAY, dashes,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush:
 *
 * Retrieve the currently active brush.
 *
 * This procedure returns the name of the currently active brush. All
 * paint operations and stroke operations use this brush to control the
 * application of paint to the image.
 *
 * Returns: The name of the active brush.
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_brush (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_brush:
 * @name: The name of the brush.
 *
 * Set the specified brush as the active brush.
 *
 * This procedure allows the active brush to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed brushes. If there is no matching brush found,
 * this procedure will return an error. Otherwise, the specified brush
 * becomes active and will be used in all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_brush (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_size:
 *
 * Get brush size in pixels.
 *
 * Get the brush size in pixels for brush based paint tools.
 *
 * Returns: Brush size in pixels.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_size (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble size = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-size",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    size = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return size;
}

/**
 * gimp_context_set_brush_size:
 * @size: Brush size in pixels.
 *
 * Set brush size in pixels.
 *
 * Set the brush size in pixels for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_size (gdouble size)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-size",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, size,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_size:
 *
 * Set brush size to its default.
 *
 * Set the brush size to the default (max of width and height) for
 * paintbrush, airbrush, or pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_default_size (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-default-size",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_aspect_ratio:
 *
 * Get brush aspect ratio.
 *
 * Set the aspect ratio for brush based paint tools.
 *
 * Returns: Aspect ratio.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_aspect_ratio (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble aspect = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-aspect-ratio",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    aspect = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return aspect;
}

/**
 * gimp_context_set_brush_aspect_ratio:
 * @aspect: Aspect ratio.
 *
 * Set brush aspect ratio.
 *
 * Set the aspect ratio for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_aspect_ratio (gdouble aspect)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-aspect-ratio",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, aspect,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_angle:
 *
 * Get brush angle in degrees.
 *
 * Set the angle in degrees for brush based paint tools.
 *
 * Returns: Angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_brush_angle (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble angle = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    angle = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return angle;
}

/**
 * gimp_context_set_brush_angle:
 * @angle: Angle in degrees.
 *
 * Set brush angle in degrees.
 *
 * Set the angle in degrees for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_brush_angle (gdouble angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, angle,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_spacing:
 *
 * Get brush spacing as percent of size.
 *
 * Get the brush spacing as percent of size for brush based paint
 * tools.
 *
 * Returns: Brush spacing as fraction of size.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_spacing (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble spacing = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    spacing = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return spacing;
}

/**
 * gimp_context_set_brush_spacing:
 * @spacing: Brush spacing as fraction of size.
 *
 * Set brush spacing as percent of size.
 *
 * Set the brush spacing as percent of size for brush based paint
 * tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_spacing (gdouble spacing)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, spacing,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_spacing:
 *
 * Set brush spacing to its default.
 *
 * Set the brush spacing to the default for paintbrush, airbrush, or
 * pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_default_spacing (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-default-spacing",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_hardness:
 *
 * Get brush hardness in paint options.
 *
 * Get the brush hardness for brush based paint tools.
 *
 * Returns: Brush hardness.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_hardness (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble hardness = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-hardness",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    hardness = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return hardness;
}

/**
 * gimp_context_set_brush_hardness:
 * @hardness: Brush hardness.
 *
 * Set brush hardness.
 *
 * Set the brush hardness for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_hardness (gdouble hardness)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-hardness",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, hardness,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_brush_default_hardness:
 *
 * Set brush spacing to its default.
 *
 * Set the brush spacing to the default for paintbrush, airbrush, or
 * pencil tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_default_hardness (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-default-hardness",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_brush_force:
 *
 * Get brush force in paint options.
 *
 * Get the brush application force for brush based paint tools.
 *
 * Returns: Brush application force.
 *
 * Since: 2.10
 **/
gdouble
gimp_context_get_brush_force (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble force = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-brush-force",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    force = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return force;
}

/**
 * gimp_context_set_brush_force:
 * @force: Brush application force.
 *
 * Set brush application force.
 *
 * Set the brush application force for brush based paint tools.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_brush_force (gdouble force)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-brush-force",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, force,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_dynamics:
 *
 * Retrieve the currently active paint dynamics.
 *
 * This procedure returns the name of the currently active paint
 * dynamics. All paint operations and stroke operations use this paint
 * dynamics to control the application of paint to the image.
 *
 * Returns: The name of the active paint dynamics.
 *
 * Since: 2.8
 **/
gchar *
gimp_context_get_dynamics (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-dynamics",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_dynamics:
 * @name: The name of the paint dynamics.
 *
 * Set the specified paint dynamics as the active paint dynamics.
 *
 * This procedure allows the active paint dynamics to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the installed paint dynamics. If there is no
 * matching paint dynamics found, this procedure will return an error.
 * Otherwise, the specified paint dynamics becomes active and will be
 * used in all subsequent paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_dynamics (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-dynamics",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_mypaint_brush:
 *
 * Retrieve the currently active MyPaint brush.
 *
 * This procedure returns the name of the currently active MyPaint
 * brush.
 *
 * Returns: The name of the active MyPaint brush.
 *
 * Since: 2.10
 **/
gchar *
gimp_context_get_mypaint_brush (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-mypaint-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_mypaint_brush:
 * @name: The name of the MyPaint brush.
 *
 * Set the specified MyPaint brush as the active MyPaint brush.
 *
 * This procedure allows the active MyPaint brush to be set by
 * specifying its name. The name is simply a string which corresponds
 * to one of the names of the installed MyPaint brushes. If there is no
 * matching MyPaint brush found, this procedure will return an error.
 * Otherwise, the specified MyPaint brush becomes active and will be
 * used in all subsequent MyPaint paint operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_mypaint_brush (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-mypaint-brush",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_pattern:
 *
 * Retrieve the currently active pattern.
 *
 * This procedure returns name of the the currently active pattern. All
 * clone and bucket-fill operations with patterns will use this pattern
 * to control the application of paint to the image.
 *
 * Returns: The name of the active pattern.
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_pattern (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_pattern:
 * @name: The name of the pattern.
 *
 * Set the specified pattern as the active pattern.
 *
 * This procedure allows the active pattern to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed patterns. If there is no matching pattern
 * found, this procedure will return an error. Otherwise, the specified
 * pattern becomes active and will be used in all subsequent paint
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_pattern (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-pattern",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_gradient:
 *
 * Retrieve the currently active gradient.
 *
 * This procedure returns the name of the currently active gradient.
 *
 * Returns: The name of the active gradient.
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_gradient (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-gradient",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_gradient:
 * @name: The name of the gradient.
 *
 * Sets the specified gradient as the active gradient.
 *
 * This procedure lets you set the specified gradient as the active or
 * \"current\" one. The name is simply a string which corresponds to
 * one of the loaded gradients. If no matching gradient is found, this
 * procedure will return an error. Otherwise, the specified gradient
 * will become active and will be used for subsequent custom gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_gradient (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_rgb:
 *
 * Sets the built-in FG-BG RGB gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG RGB gradient as the active
 * gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_rgb (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-fg-bg-rgb",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_hsv_cw:
 *
 * Sets the built-in FG-BG HSV (cw) gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG HSV (cw) gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_hsv_cw (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-fg-bg-hsv-cw",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_bg_hsv_ccw:
 *
 * Sets the built-in FG-BG HSV (ccw) gradient as the active gradient.
 *
 * This procedure sets the built-in FG-BG HSV (ccw) gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_bg_hsv_ccw (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-fg-bg-hsv-ccw",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_gradient_fg_transparent:
 *
 * Sets the built-in FG-Transparent gradient as the active gradient.
 *
 * This procedure sets the built-in FG-Transparent gradient as the
 * active gradient. The gradient will be used for subsequent gradient
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_fg_transparent (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-fg-transparent",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_gradient_blend_color_space:
 *
 * Get the gradient blend color space.
 *
 * Get the gradient blend color space for paint tools and the gradient
 * tool.
 *
 * Returns: Color blend space.
 *
 * Since: 2.10
 **/
GimpGradientBlendColorSpace
gimp_context_get_gradient_blend_color_space (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpGradientBlendColorSpace blend_color_space = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-gradient-blend-color-space",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    blend_color_space = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return blend_color_space;
}

/**
 * gimp_context_set_gradient_blend_color_space:
 * @blend_color_space: Blend color space.
 *
 * Set the gradient blend color space.
 *
 * Set the gradient blend color space for paint tools and the gradient
 * tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_blend_color_space (GimpGradientBlendColorSpace blend_color_space)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-blend-color-space",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, blend_color_space,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_gradient_repeat_mode:
 *
 * Get the gradient repeat mode.
 *
 * Get the gradient repeat mode for paint tools and the gradient tool.
 *
 * Returns: Repeat mode.
 *
 * Since: 2.10
 **/
GimpRepeatMode
gimp_context_get_gradient_repeat_mode (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpRepeatMode repeat_mode = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-gradient-repeat-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    repeat_mode = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return repeat_mode;
}

/**
 * gimp_context_set_gradient_repeat_mode:
 * @repeat_mode: Repeat mode.
 *
 * Set the gradient repeat mode.
 *
 * Set the gradient repeat mode for paint tools and the gradient tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_repeat_mode (GimpRepeatMode repeat_mode)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-repeat-mode",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, repeat_mode,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_gradient_reverse:
 *
 * Get the gradient reverse setting.
 *
 * Get the gradient reverse setting for paint tools and the gradient
 * tool.
 *
 * Returns: Reverse.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_gradient_reverse (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean reverse = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-gradient-reverse",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    reverse = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return reverse;
}

/**
 * gimp_context_set_gradient_reverse:
 * @reverse: Reverse.
 *
 * Set the gradient reverse setting.
 *
 * Set the gradient reverse setting for paint tools and the gradient
 * tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_gradient_reverse (gboolean reverse)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-gradient-reverse",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, reverse,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_palette:
 *
 * Retrieve the currently active palette.
 *
 * This procedure returns the name of the the currently active palette.
 *
 * Returns: The name of the active palette.
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_palette (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-palette",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_palette:
 * @name: The name of the palette.
 *
 * Set the specified palette as the active palette.
 *
 * This procedure allows the active palette to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed palettes. If no matching palette is found,
 * this procedure will return an error. Otherwise, the specified
 * palette becomes active and will be used in all subsequent palette
 * operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_palette (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-palette",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_font:
 *
 * Retrieve the currently active font.
 *
 * This procedure returns the name of the currently active font.
 *
 * Returns: The name of the active font.
 *
 * Since: 2.2
 **/
gchar *
gimp_context_get_font (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp-context-get-font",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

/**
 * gimp_context_set_font:
 * @name: The name of the font.
 *
 * Set the specified font as the active font.
 *
 * This procedure allows the active font to be set by specifying its
 * name. The name is simply a string which corresponds to one of the
 * names of the installed fonts. If no matching font is found, this
 * procedure will return an error. Otherwise, the specified font
 * becomes active and will be used in all subsequent font operations.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_context_set_font (const gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-font",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_antialias:
 *
 * Get the antialias setting.
 *
 * This procedure returns the antialias setting.
 *
 * Returns: The antialias setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_antialias (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean antialias = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-antialias",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    antialias = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return antialias;
}

/**
 * gimp_context_set_antialias:
 * @antialias: The antialias setting.
 *
 * Set the antialias setting.
 *
 * This procedure modifies the antialias setting. If antialiasing is
 * turned on, the edges of selected region will contain intermediate
 * values which give the appearance of a sharper, less pixelized edge.
 * This should be set as TRUE most of the time unless a binary-only
 * selection is wanted.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_image_select_round_rectangle(), gimp_image_select_ellipse(),
 * gimp_image_select_polygon(), gimp_image_select_item(),
 * gimp_drawable_edit_bucket_fill(), gimp_drawable_edit_stroke_item(),
 * gimp_drawable_edit_stroke_selection().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_antialias (gboolean antialias)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-antialias",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, antialias,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_feather:
 *
 * Get the feather setting.
 *
 * This procedure returns the feather setting.
 *
 * Returns: The feather setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_feather (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean feather = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-feather",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    feather = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return feather;
}

/**
 * gimp_context_set_feather:
 * @feather: The feather setting.
 *
 * Set the feather setting.
 *
 * This procedure modifies the feather setting. If the feather option
 * is enabled, selections will be blurred before combining. The blur is
 * a gaussian blur; its radii can be controlled using
 * gimp_context_set_feather_radius().
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_image_select_rectangle(), gimp_image_select_round_rectangle(),
 * gimp_image_select_ellipse(), gimp_image_select_polygon(),
 * gimp_image_select_item().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_feather (gboolean feather)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-feather",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, feather,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_feather_radius:
 * @feather_radius_x: The horizontal feather radius.
 * @feather_radius_y: The vertical feather radius.
 *
 * Get the feather radius setting.
 *
 * This procedure returns the feather radius setting.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_feather_radius (gdouble *feather_radius_x,
                                 gdouble *feather_radius_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-get-feather-radius",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  *feather_radius_x = 0.0;
  *feather_radius_y = 0.0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *feather_radius_x = return_vals[1].data.d_float;
      *feather_radius_y = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_set_feather_radius:
 * @feather_radius_x: The horizontal feather radius.
 * @feather_radius_y: The vertical feather radius.
 *
 * Set the feather radius setting.
 *
 * This procedure modifies the feather radius setting.
 *
 * This setting affects all procedures that are affected by
 * gimp_context_set_feather().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_feather_radius (gdouble feather_radius_x,
                                 gdouble feather_radius_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-feather-radius",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, feather_radius_x,
                                    GIMP_PDB_FLOAT, feather_radius_y,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_merged:
 *
 * Get the sample merged setting.
 *
 * This procedure returns the sample merged setting.
 *
 * Returns: The sample merged setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_sample_merged (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean sample_merged = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-merged",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_merged = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_merged;
}

/**
 * gimp_context_set_sample_merged:
 * @sample_merged: The sample merged setting.
 *
 * Set the sample merged setting.
 *
 * This procedure modifies the sample merged setting. If an operation
 * depends on the colors of the pixels present in a drawable, like when
 * doing a seed fill, this setting controls whether the pixel data from
 * the specified drawable is used ('sample-merged' is FALSE), or the
 * pixel data from the composite image ('sample-merged' is TRUE. This
 * is equivalent to sampling for colors after merging all visible
 * layers).
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_merged (gboolean sample_merged)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-merged",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_merged,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_criterion:
 *
 * Get the sample criterion setting.
 *
 * This procedure returns the sample criterion setting.
 *
 * Returns: The sample criterion setting.
 *
 * Since: 2.8
 **/
GimpSelectCriterion
gimp_context_get_sample_criterion (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpSelectCriterion sample_criterion = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-criterion",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_criterion = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_criterion;
}

/**
 * gimp_context_set_sample_criterion:
 * @sample_criterion: The sample criterion setting.
 *
 * Set the sample criterion setting.
 *
 * This procedure modifies the sample criterion setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls how color
 * similarity is determined. SELECT_CRITERION_COMPOSITE is the default
 * value.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_criterion (GimpSelectCriterion sample_criterion)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-criterion",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_criterion,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold:
 *
 * Get the sample threshold setting.
 *
 * This procedure returns the sample threshold setting.
 *
 * Returns: The sample threshold setting.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_sample_threshold (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble sample_threshold = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-threshold",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_threshold = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting.
 *
 * This procedure modifies the sample threshold setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls what is
 * \"sufficiently close\" to be considered a similar color. If the
 * sample threshold has not been set explicitly, the default threshold
 * set in gimprc will be used.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_threshold (gdouble sample_threshold)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-threshold",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, sample_threshold,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_threshold_int:
 *
 * Get the sample threshold setting as an integer value.
 *
 * This procedure returns the sample threshold setting as an integer
 * value. See gimp_context_get_sample_threshold().
 *
 * Returns: The sample threshold setting.
 *
 * Since: 2.8
 **/
gint
gimp_context_get_sample_threshold_int (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint sample_threshold = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-threshold-int",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_threshold = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_threshold;
}

/**
 * gimp_context_set_sample_threshold_int:
 * @sample_threshold: The sample threshold setting.
 *
 * Set the sample threshold setting as an integer value.
 *
 * This procedure modifies the sample threshold setting as an integer
 * value. See gimp_context_set_sample_threshold().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_threshold_int (gint sample_threshold)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-threshold-int",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_threshold,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_sample_transparent:
 *
 * Get the sample transparent setting.
 *
 * This procedure returns the sample transparent setting.
 *
 * Returns: The sample transparent setting.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_get_sample_transparent (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean sample_transparent = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-sample-transparent",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    sample_transparent = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return sample_transparent;
}

/**
 * gimp_context_set_sample_transparent:
 * @sample_transparent: The sample transparent setting.
 *
 * Set the sample transparent setting.
 *
 * This procedure modifies the sample transparent setting. If an
 * operation depends on the colors of the pixels present in a drawable,
 * like when doing a seed fill, this setting controls whether
 * transparency is considered to be a unique selectable color. When
 * this setting is TRUE, transparent areas can be selected or filled.
 *
 * This setting affects the following procedures:
 * gimp_image_select_color(), gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_sample_transparent (gboolean sample_transparent)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-sample-transparent",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, sample_transparent,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_diagonal_neighbors:
 *
 * Get the diagonal neighbors setting.
 *
 * This procedure returns the diagonal neighbors setting.
 *
 * Returns: The diagonal neighbors setting.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_get_diagonal_neighbors (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean diagonal_neighbors = FALSE;

  return_vals = gimp_run_procedure ("gimp-context-get-diagonal-neighbors",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    diagonal_neighbors = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return diagonal_neighbors;
}

/**
 * gimp_context_set_diagonal_neighbors:
 * @diagonal_neighbors: The diagonal neighbors setting.
 *
 * Set the diagonal neighbors setting.
 *
 * This procedure modifies the diagonal neighbors setting. If the
 * affected region of an operation is based on a seed point, like when
 * doing a seed fill, then, when this setting is TRUE, all eight
 * neighbors of each pixel are considered when calculating the affected
 * region; in contrast, when this setting is FALSE, only the four
 * orthogonal neighbors of each pixel are considered.
 *
 * This setting affects the following procedures:
 * gimp_image_select_contiguous_color(),
 * gimp_drawable_edit_bucket_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_diagonal_neighbors (gboolean diagonal_neighbors)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-diagonal-neighbors",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, diagonal_neighbors,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_distance_metric:
 *
 * Get the distance metric used in some computations.
 *
 * This procedure returns the distance metric in the current context.
 * See gimp_context_set_distance_metric() to know more about its usage.
 *
 * Returns: The distance metric.
 *
 * Since: 2.10
 **/
GeglDistanceMetric
gimp_context_get_distance_metric (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GeglDistanceMetric metric = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-distance-metric",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    metric = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return metric;
}

/**
 * gimp_context_set_distance_metric:
 * @metric: The distance metric.
 *
 * Set the distance metric used in some computations.
 *
 * This procedure modifies the distance metric used in some
 * computations, such as gimp_drawable_edit_gradient_fill(). In
 * particular, it does not change the metric used in generic distance
 * computation on canvas, as in the Measure tool.
 *
 * This setting affects the following procedures:
 * gimp_drawable_edit_gradient_fill().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_context_set_distance_metric (GeglDistanceMetric metric)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-distance-metric",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, metric,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_interpolation:
 *
 * Get the interpolation type.
 *
 * This procedure returns the interpolation setting. The return value
 * is an integer which corresponds to the values listed in the argument
 * description. If the interpolation has not been set explicitly by
 * gimp_context_set_interpolation(), the default interpolation set in
 * gimprc will be used.
 *
 * Returns: The interpolation type.
 *
 * Since: 2.8
 **/
GimpInterpolationType
gimp_context_get_interpolation (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpInterpolationType interpolation = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-interpolation",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    interpolation = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return interpolation;
}

/**
 * gimp_context_set_interpolation:
 * @interpolation: The interpolation type.
 *
 * Set the interpolation type.
 *
 * This procedure modifies the interpolation setting.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix(), gimp_image_scale(),
 * gimp_layer_scale().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_interpolation (GimpInterpolationType interpolation)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-interpolation",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_direction:
 *
 * Get the transform direction.
 *
 * This procedure returns the transform direction. The return value is
 * an integer which corresponds to the values listed in the argument
 * description.
 *
 * Returns: The transform direction.
 *
 * Since: 2.8
 **/
GimpTransformDirection
gimp_context_get_transform_direction (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpTransformDirection transform_direction = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-direction",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_direction = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_direction;
}

/**
 * gimp_context_set_transform_direction:
 * @transform_direction: The transform direction.
 *
 * Set the transform direction.
 *
 * This procedure modifies the transform direction setting.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_perspective(),
 * gimp_item_transform_rotate(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_transform_direction (GimpTransformDirection transform_direction)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-direction",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_direction,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_resize:
 *
 * Get the transform resize type.
 *
 * This procedure returns the transform resize setting. The return
 * value is an integer which corresponds to the values listed in the
 * argument description.
 *
 * Returns: The transform resize type.
 *
 * Since: 2.8
 **/
GimpTransformResize
gimp_context_get_transform_resize (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpTransformResize transform_resize = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-resize",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_resize = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_resize;
}

/**
 * gimp_context_set_transform_resize:
 * @transform_resize: The transform resize type.
 *
 * Set the transform resize type.
 *
 * This procedure modifies the transform resize setting. When
 * transforming pixels, if the result of a transform operation has a
 * different size than the original area, this setting determines how
 * the resulting area is sized.
 *
 * This setting affects affects the following procedures:
 * gimp_item_transform_flip(), gimp_item_transform_flip_simple(),
 * gimp_item_transform_perspective(), gimp_item_transform_rotate(),
 * gimp_item_transform_rotate_simple(), gimp_item_transform_scale(),
 * gimp_item_transform_shear(), gimp_item_transform_2d(),
 * gimp_item_transform_matrix().
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_transform_resize (GimpTransformResize transform_resize)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-resize",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_resize,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_transform_recursion:
 *
 * Deprecated: There is no replacement for this procedure.
 *
 * Returns: This returns always 3 and is meaningless.
 **/
gint
gimp_context_get_transform_recursion (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint transform_recursion = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-transform-recursion",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    transform_recursion = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return transform_recursion;
}

/**
 * gimp_context_set_transform_recursion:
 * @transform_recursion: This parameter is ignored.
 *
 * Deprecated: There is no replacement for this procedure.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_context_set_transform_recursion (gint transform_recursion)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-transform-recursion",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, transform_recursion,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_size:
 *
 * Get ink blob size in pixels.
 *
 * Get the ink blob size in pixels for ink tool.
 *
 * Returns: ink blob size in pixels.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_size (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble size = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-size",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    size = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return size;
}

/**
 * gimp_context_set_ink_size:
 * @size: ink blob size in pixels.
 *
 * Set ink blob size in pixels.
 *
 * Set the ink blob size in pixels for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_size (gdouble size)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-size",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, size,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_angle:
 *
 * Get ink angle in degrees.
 *
 * Get the ink angle in degrees for ink tool.
 *
 * Returns: ink angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_angle (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble angle = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    angle = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return angle;
}

/**
 * gimp_context_set_ink_angle:
 * @angle: ink angle in degrees.
 *
 * Set ink angle in degrees.
 *
 * Set the ink angle in degrees for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_angle (gdouble angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, angle,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_size_sensitivity:
 *
 * Get ink size sensitivity.
 *
 * Get the ink size sensitivity for ink tool.
 *
 * Returns: ink size sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_size_sensitivity (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble size = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-size-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    size = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return size;
}

/**
 * gimp_context_set_ink_size_sensitivity:
 * @size: ink size sensitivity.
 *
 * Set ink size sensitivity.
 *
 * Set the ink size sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_size_sensitivity (gdouble size)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-size-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, size,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_tilt_sensitivity:
 *
 * Get ink tilt sensitivity.
 *
 * Get the ink tilt sensitivity for ink tool.
 *
 * Returns: ink tilt sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_tilt_sensitivity (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble tilt = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-tilt-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    tilt = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return tilt;
}

/**
 * gimp_context_set_ink_tilt_sensitivity:
 * @tilt: ink tilt sensitivity.
 *
 * Set ink tilt sensitivity.
 *
 * Set the ink tilt sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_tilt_sensitivity (gdouble tilt)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-tilt-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, tilt,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_speed_sensitivity:
 *
 * Get ink speed sensitivity.
 *
 * Get the ink speed sensitivity for ink tool.
 *
 * Returns: ink speed sensitivity.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_speed_sensitivity (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble speed = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-speed-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    speed = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return speed;
}

/**
 * gimp_context_set_ink_speed_sensitivity:
 * @speed: ink speed sensitivity.
 *
 * Set ink speed sensitivity.
 *
 * Set the ink speed sensitivity for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_speed_sensitivity (gdouble speed)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-speed-sensitivity",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, speed,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_type:
 *
 * Get ink blob type.
 *
 * Get the ink blob type for ink tool.
 *
 * Returns: Ink blob type.
 *
 * Since: 2.8
 **/
GimpInkBlobType
gimp_context_get_ink_blob_type (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpInkBlobType type = 0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-blob-type",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    type = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return type;
}

/**
 * gimp_context_set_ink_blob_type:
 * @type: Ink blob type.
 *
 * Set ink blob type.
 *
 * Set the ink blob type for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_type (GimpInkBlobType type)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-blob-type",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, type,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_aspect_ratio:
 *
 * Get ink blob aspect ratio.
 *
 * Get the ink blob aspect ratio for ink tool.
 *
 * Returns: ink blob aspect ratio.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_blob_aspect_ratio (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble aspect = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-blob-aspect-ratio",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    aspect = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return aspect;
}

/**
 * gimp_context_set_ink_blob_aspect_ratio:
 * @aspect: ink blob aspect ratio.
 *
 * Set ink blob aspect ratio.
 *
 * Set the ink blob aspect ratio for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_aspect_ratio (gdouble aspect)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-blob-aspect-ratio",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, aspect,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_context_get_ink_blob_angle:
 *
 * Get ink blob angle in degrees.
 *
 * Get the ink blob angle in degrees for ink tool.
 *
 * Returns: ink blob angle in degrees.
 *
 * Since: 2.8
 **/
gdouble
gimp_context_get_ink_blob_angle (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble angle = 0.0;

  return_vals = gimp_run_procedure ("gimp-context-get-ink-blob-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    angle = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return angle;
}

/**
 * gimp_context_set_ink_blob_angle:
 * @angle: ink blob angle in degrees.
 *
 * Set ink blob angle in degrees.
 *
 * Set the ink blob angle in degrees for ink tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_context_set_ink_blob_angle (gdouble angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-context-set-ink-blob-angle",
                                    &nreturn_vals,
                                    GIMP_PDB_FLOAT, angle,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
