// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/aiplatform/v1/explanation.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The format of the input example instances.
type Examples_ExampleGcsSource_DataFormat int32

const (
	// Format unspecified, used when unset.
	Examples_ExampleGcsSource_DATA_FORMAT_UNSPECIFIED Examples_ExampleGcsSource_DataFormat = 0
	// Examples are stored in JSONL files.
	Examples_ExampleGcsSource_JSONL Examples_ExampleGcsSource_DataFormat = 1
)

// Enum value maps for Examples_ExampleGcsSource_DataFormat.
var (
	Examples_ExampleGcsSource_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "JSONL",
	}
	Examples_ExampleGcsSource_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"JSONL":                   1,
	}
)

func (x Examples_ExampleGcsSource_DataFormat) Enum() *Examples_ExampleGcsSource_DataFormat {
	p := new(Examples_ExampleGcsSource_DataFormat)
	*p = x
	return p
}

func (x Examples_ExampleGcsSource_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Examples_ExampleGcsSource_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[0].Descriptor()
}

func (Examples_ExampleGcsSource_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[0]
}

func (x Examples_ExampleGcsSource_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Examples_ExampleGcsSource_DataFormat.Descriptor instead.
func (Examples_ExampleGcsSource_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{12, 0, 0}
}

// Preset option controlling parameters for query speed-precision trade-off
type Presets_Query int32

const (
	// More precise neighbors as a trade-off against slower response.
	Presets_PRECISE Presets_Query = 0
	// Faster response as a trade-off against less precise neighbors.
	Presets_FAST Presets_Query = 1
)

// Enum value maps for Presets_Query.
var (
	Presets_Query_name = map[int32]string{
		0: "PRECISE",
		1: "FAST",
	}
	Presets_Query_value = map[string]int32{
		"PRECISE": 0,
		"FAST":    1,
	}
)

func (x Presets_Query) Enum() *Presets_Query {
	p := new(Presets_Query)
	*p = x
	return p
}

func (x Presets_Query) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Presets_Query) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[1].Descriptor()
}

func (Presets_Query) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[1]
}

func (x Presets_Query) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Presets_Query.Descriptor instead.
func (Presets_Query) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{13, 0}
}

// Preset option controlling parameters for different modalities
type Presets_Modality int32

const (
	// Should not be set. Added as a recommended best practice for enums
	Presets_MODALITY_UNSPECIFIED Presets_Modality = 0
	// IMAGE modality
	Presets_IMAGE Presets_Modality = 1
	// TEXT modality
	Presets_TEXT Presets_Modality = 2
	// TABULAR modality
	Presets_TABULAR Presets_Modality = 3
)

// Enum value maps for Presets_Modality.
var (
	Presets_Modality_name = map[int32]string{
		0: "MODALITY_UNSPECIFIED",
		1: "IMAGE",
		2: "TEXT",
		3: "TABULAR",
	}
	Presets_Modality_value = map[string]int32{
		"MODALITY_UNSPECIFIED": 0,
		"IMAGE":                1,
		"TEXT":                 2,
		"TABULAR":              3,
	}
)

func (x Presets_Modality) Enum() *Presets_Modality {
	p := new(Presets_Modality)
	*p = x
	return p
}

func (x Presets_Modality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Presets_Modality) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[2].Descriptor()
}

func (Presets_Modality) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[2]
}

func (x Presets_Modality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Presets_Modality.Descriptor instead.
func (Presets_Modality) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{13, 1}
}

// Data format enum.
type ExamplesOverride_DataFormat int32

const (
	// Unspecified format. Must not be used.
	ExamplesOverride_DATA_FORMAT_UNSPECIFIED ExamplesOverride_DataFormat = 0
	// Provided data is a set of model inputs.
	ExamplesOverride_INSTANCES ExamplesOverride_DataFormat = 1
	// Provided data is a set of embeddings.
	ExamplesOverride_EMBEDDINGS ExamplesOverride_DataFormat = 2
)

// Enum value maps for ExamplesOverride_DataFormat.
var (
	ExamplesOverride_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "INSTANCES",
		2: "EMBEDDINGS",
	}
	ExamplesOverride_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"INSTANCES":               1,
		"EMBEDDINGS":              2,
	}
)

func (x ExamplesOverride_DataFormat) Enum() *ExamplesOverride_DataFormat {
	p := new(ExamplesOverride_DataFormat)
	*p = x
	return p
}

func (x ExamplesOverride_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExamplesOverride_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[3].Descriptor()
}

func (ExamplesOverride_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_explanation_proto_enumTypes[3]
}

func (x ExamplesOverride_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExamplesOverride_DataFormat.Descriptor instead.
func (ExamplesOverride_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{16, 0}
}

// Explanation of a prediction (provided in
// [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions])
// produced by the Model on a given
// [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
type Explanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Feature attributions grouped by predicted outputs.
	//
	// For Models that predict only one output, such as regression Models that
	// predict only one score, there is only one attibution that explains the
	// predicted output. For Models that predict multiple outputs, such as
	// multiclass Models that predict multiple classes, each element explains one
	// specific item.
	// [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
	// can be used to identify which output this attribution is explaining.
	//
	// By default, we provide Shapley values for the predicted class. However,
	// you can configure the explanation request to generate Shapley values for
	// any other classes too. For example, if a model predicts a probability of
	// `0.4` for approving a loan application, the model's decision is to reject
	// the application since `p(reject) = 0.6 > p(approve) = 0.4`, and the default
	// Shapley values would be computed for rejection decision and not approval,
	// even though the latter might be the positive class.
	//
	// If users set
	// [ExplanationParameters.top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k],
	// the attributions are sorted by
	// [instance_output_value][Attributions.instance_output_value] in descending
	// order. If
	// [ExplanationParameters.output_indices][google.cloud.aiplatform.v1.ExplanationParameters.output_indices]
	// is specified, the attributions are stored by
	// [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
	// in the same order as they appear in the output_indices.
	Attributions []*Attribution `protobuf:"bytes,1,rep,name=attributions,proto3" json:"attributions,omitempty"`
	// Output only. List of the nearest neighbors for example-based explanations.
	//
	// For models deployed with the examples explanations feature enabled, the
	// attributions field is empty and instead the neighbors field is populated.
	Neighbors []*Neighbor `protobuf:"bytes,2,rep,name=neighbors,proto3" json:"neighbors,omitempty"`
}

func (x *Explanation) Reset() {
	*x = Explanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Explanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Explanation) ProtoMessage() {}

func (x *Explanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Explanation.ProtoReflect.Descriptor instead.
func (*Explanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{0}
}

func (x *Explanation) GetAttributions() []*Attribution {
	if x != nil {
		return x.Attributions
	}
	return nil
}

func (x *Explanation) GetNeighbors() []*Neighbor {
	if x != nil {
		return x.Neighbors
	}
	return nil
}

// Aggregated explanation metrics for a Model over a set of instances.
type ModelExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Aggregated attributions explaining the Model's prediction
	// outputs over the set of instances. The attributions are grouped by outputs.
	//
	// For Models that predict only one output, such as regression Models that
	// predict only one score, there is only one attibution that explains the
	// predicted output. For Models that predict multiple outputs, such as
	// multiclass Models that predict multiple classes, each element explains one
	// specific item.
	// [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
	// can be used to identify which output this attribution is explaining.
	//
	// The
	// [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
	// [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
	// and
	// [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
	// fields are averaged over the test data.
	//
	// NOTE: Currently AutoML tabular classification Models produce only one
	// attribution, which averages attributions over all the classes it predicts.
	// [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
	// is not populated.
	MeanAttributions []*Attribution `protobuf:"bytes,1,rep,name=mean_attributions,json=meanAttributions,proto3" json:"mean_attributions,omitempty"`
}

func (x *ModelExplanation) Reset() {
	*x = ModelExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelExplanation) ProtoMessage() {}

func (x *ModelExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelExplanation.ProtoReflect.Descriptor instead.
func (*ModelExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{1}
}

func (x *ModelExplanation) GetMeanAttributions() []*Attribution {
	if x != nil {
		return x.MeanAttributions
	}
	return nil
}

// Attribution that explains a particular prediction output.
type Attribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Model predicted output if the input instance is constructed
	// from the baselines of all the features defined in
	// [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
	// The field name of the output is determined by the key in
	// [ExplanationMetadata.outputs][google.cloud.aiplatform.v1.ExplanationMetadata.outputs].
	//
	// If the Model's predicted output has multiple dimensions (rank > 1), this is
	// the value in the output located by
	// [output_index][google.cloud.aiplatform.v1.Attribution.output_index].
	//
	// If there are multiple baselines, their output values are averaged.
	BaselineOutputValue float64 `protobuf:"fixed64,1,opt,name=baseline_output_value,json=baselineOutputValue,proto3" json:"baseline_output_value,omitempty"`
	// Output only. Model predicted output on the corresponding [explanation
	// instance][ExplainRequest.instances]. The field name of the output is
	// determined by the key in
	// [ExplanationMetadata.outputs][google.cloud.aiplatform.v1.ExplanationMetadata.outputs].
	//
	// If the Model predicted output has multiple dimensions, this is the value in
	// the output located by
	// [output_index][google.cloud.aiplatform.v1.Attribution.output_index].
	InstanceOutputValue float64 `protobuf:"fixed64,2,opt,name=instance_output_value,json=instanceOutputValue,proto3" json:"instance_output_value,omitempty"`
	// Output only. Attributions of each explained feature. Features are extracted
	// from the [prediction
	// instances][google.cloud.aiplatform.v1.ExplainRequest.instances] according
	// to [explanation metadata for
	// inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
	//
	// The value is a struct, whose keys are the name of the feature. The values
	// are how much the feature in the
	// [instance][google.cloud.aiplatform.v1.ExplainRequest.instances] contributed
	// to the predicted result.
	//
	// The format of the value is determined by the feature's input format:
	//
	//   - If the feature is a scalar value, the attribution value is a
	//     [floating number][google.protobuf.Value.number_value].
	//
	//   - If the feature is an array of scalar values, the attribution value is
	//     an [array][google.protobuf.Value.list_value].
	//
	//   - If the feature is a struct, the attribution value is a
	//     [struct][google.protobuf.Value.struct_value]. The keys in the
	//     attribution value struct are the same as the keys in the feature
	//     struct. The formats of the values in the attribution struct are
	//     determined by the formats of the values in the feature struct.
	//
	// The
	// [ExplanationMetadata.feature_attributions_schema_uri][google.cloud.aiplatform.v1.ExplanationMetadata.feature_attributions_schema_uri]
	// field, pointed to by the
	// [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] field of the
	// [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
	// object, points to the schema file that describes the features and their
	// attribution values (if it is populated).
	FeatureAttributions *structpb.Value `protobuf:"bytes,3,opt,name=feature_attributions,json=featureAttributions,proto3" json:"feature_attributions,omitempty"`
	// Output only. The index that locates the explained prediction output.
	//
	// If the prediction output is a scalar value, output_index is not populated.
	// If the prediction output has multiple dimensions, the length of the
	// output_index list is the same as the number of dimensions of the output.
	// The i-th element in output_index is the element index of the i-th dimension
	// of the output vector. Indices start from 0.
	OutputIndex []int32 `protobuf:"varint,4,rep,packed,name=output_index,json=outputIndex,proto3" json:"output_index,omitempty"`
	// Output only. The display name of the output identified by
	// [output_index][google.cloud.aiplatform.v1.Attribution.output_index]. For
	// example, the predicted class name by a multi-classification Model.
	//
	// This field is only populated iff the Model predicts display names as a
	// separate field along with the explained output. The predicted display name
	// must has the same shape of the explained output, and can be located using
	// output_index.
	OutputDisplayName string `protobuf:"bytes,5,opt,name=output_display_name,json=outputDisplayName,proto3" json:"output_display_name,omitempty"`
	// Output only. Error of
	// [feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
	// caused by approximation used in the explanation method. Lower value means
	// more precise attributions.
	//
	// * For Sampled Shapley
	// [attribution][google.cloud.aiplatform.v1.ExplanationParameters.sampled_shapley_attribution],
	// increasing
	// [path_count][google.cloud.aiplatform.v1.SampledShapleyAttribution.path_count]
	// might reduce the error.
	// * For Integrated Gradients
	// [attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
	// increasing
	// [step_count][google.cloud.aiplatform.v1.IntegratedGradientsAttribution.step_count]
	// might reduce the error.
	// * For [XRAI
	// attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
	// increasing
	// [step_count][google.cloud.aiplatform.v1.XraiAttribution.step_count] might
	// reduce the error.
	//
	// See [this introduction](/vertex-ai/docs/explainable-ai/overview)
	// for more information.
	ApproximationError float64 `protobuf:"fixed64,6,opt,name=approximation_error,json=approximationError,proto3" json:"approximation_error,omitempty"`
	// Output only. Name of the explain output. Specified as the key in
	// [ExplanationMetadata.outputs][google.cloud.aiplatform.v1.ExplanationMetadata.outputs].
	OutputName string `protobuf:"bytes,7,opt,name=output_name,json=outputName,proto3" json:"output_name,omitempty"`
}

func (x *Attribution) Reset() {
	*x = Attribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attribution) ProtoMessage() {}

func (x *Attribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attribution.ProtoReflect.Descriptor instead.
func (*Attribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{2}
}

func (x *Attribution) GetBaselineOutputValue() float64 {
	if x != nil {
		return x.BaselineOutputValue
	}
	return 0
}

func (x *Attribution) GetInstanceOutputValue() float64 {
	if x != nil {
		return x.InstanceOutputValue
	}
	return 0
}

func (x *Attribution) GetFeatureAttributions() *structpb.Value {
	if x != nil {
		return x.FeatureAttributions
	}
	return nil
}

func (x *Attribution) GetOutputIndex() []int32 {
	if x != nil {
		return x.OutputIndex
	}
	return nil
}

func (x *Attribution) GetOutputDisplayName() string {
	if x != nil {
		return x.OutputDisplayName
	}
	return ""
}

func (x *Attribution) GetApproximationError() float64 {
	if x != nil {
		return x.ApproximationError
	}
	return 0
}

func (x *Attribution) GetOutputName() string {
	if x != nil {
		return x.OutputName
	}
	return ""
}

// Neighbors for example-based explanations.
type Neighbor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The neighbor id.
	NeighborId string `protobuf:"bytes,1,opt,name=neighbor_id,json=neighborId,proto3" json:"neighbor_id,omitempty"`
	// Output only. The neighbor distance.
	NeighborDistance float64 `protobuf:"fixed64,2,opt,name=neighbor_distance,json=neighborDistance,proto3" json:"neighbor_distance,omitempty"`
}

func (x *Neighbor) Reset() {
	*x = Neighbor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Neighbor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Neighbor) ProtoMessage() {}

func (x *Neighbor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Neighbor.ProtoReflect.Descriptor instead.
func (*Neighbor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{3}
}

func (x *Neighbor) GetNeighborId() string {
	if x != nil {
		return x.NeighborId
	}
	return ""
}

func (x *Neighbor) GetNeighborDistance() float64 {
	if x != nil {
		return x.NeighborDistance
	}
	return 0
}

// Specification of Model explanation.
type ExplanationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parameters that configure explaining of the Model's predictions.
	Parameters *ExplanationParameters `protobuf:"bytes,1,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. Metadata describing the Model's input and output for explanation.
	Metadata *ExplanationMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ExplanationSpec) Reset() {
	*x = ExplanationSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationSpec) ProtoMessage() {}

func (x *ExplanationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationSpec.ProtoReflect.Descriptor instead.
func (*ExplanationSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{4}
}

func (x *ExplanationSpec) GetParameters() *ExplanationParameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ExplanationSpec) GetMetadata() *ExplanationMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Parameters to configure explaining for Model's predictions.
type ExplanationParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Method:
	//
	//	*ExplanationParameters_SampledShapleyAttribution
	//	*ExplanationParameters_IntegratedGradientsAttribution
	//	*ExplanationParameters_XraiAttribution
	//	*ExplanationParameters_Examples
	Method isExplanationParameters_Method `protobuf_oneof:"method"`
	// If populated, returns attributions for top K indices of outputs
	// (defaults to 1). Only applies to Models that predicts more than one outputs
	// (e,g, multi-class Models). When set to -1, returns explanations for all
	// outputs.
	TopK int32 `protobuf:"varint,4,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
	// If populated, only returns attributions that have
	// [output_index][google.cloud.aiplatform.v1.Attribution.output_index]
	// contained in output_indices. It must be an ndarray of integers, with the
	// same shape of the output it's explaining.
	//
	// If not populated, returns attributions for
	// [top_k][google.cloud.aiplatform.v1.ExplanationParameters.top_k] indices of
	// outputs. If neither top_k nor output_indices is populated, returns the
	// argmax index of the outputs.
	//
	// Only applicable to Models that predict multiple outputs (e,g, multi-class
	// Models that predict multiple classes).
	OutputIndices *structpb.ListValue `protobuf:"bytes,5,opt,name=output_indices,json=outputIndices,proto3" json:"output_indices,omitempty"`
}

func (x *ExplanationParameters) Reset() {
	*x = ExplanationParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationParameters) ProtoMessage() {}

func (x *ExplanationParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationParameters.ProtoReflect.Descriptor instead.
func (*ExplanationParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{5}
}

func (m *ExplanationParameters) GetMethod() isExplanationParameters_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (x *ExplanationParameters) GetSampledShapleyAttribution() *SampledShapleyAttribution {
	if x, ok := x.GetMethod().(*ExplanationParameters_SampledShapleyAttribution); ok {
		return x.SampledShapleyAttribution
	}
	return nil
}

func (x *ExplanationParameters) GetIntegratedGradientsAttribution() *IntegratedGradientsAttribution {
	if x, ok := x.GetMethod().(*ExplanationParameters_IntegratedGradientsAttribution); ok {
		return x.IntegratedGradientsAttribution
	}
	return nil
}

func (x *ExplanationParameters) GetXraiAttribution() *XraiAttribution {
	if x, ok := x.GetMethod().(*ExplanationParameters_XraiAttribution); ok {
		return x.XraiAttribution
	}
	return nil
}

func (x *ExplanationParameters) GetExamples() *Examples {
	if x, ok := x.GetMethod().(*ExplanationParameters_Examples); ok {
		return x.Examples
	}
	return nil
}

func (x *ExplanationParameters) GetTopK() int32 {
	if x != nil {
		return x.TopK
	}
	return 0
}

func (x *ExplanationParameters) GetOutputIndices() *structpb.ListValue {
	if x != nil {
		return x.OutputIndices
	}
	return nil
}

type isExplanationParameters_Method interface {
	isExplanationParameters_Method()
}

type ExplanationParameters_SampledShapleyAttribution struct {
	// An attribution method that approximates Shapley values for features that
	// contribute to the label being predicted. A sampling strategy is used to
	// approximate the value rather than considering all subsets of features.
	// Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
	SampledShapleyAttribution *SampledShapleyAttribution `protobuf:"bytes,1,opt,name=sampled_shapley_attribution,json=sampledShapleyAttribution,proto3,oneof"`
}

type ExplanationParameters_IntegratedGradientsAttribution struct {
	// An attribution method that computes Aumann-Shapley values taking
	// advantage of the model's fully differentiable structure. Refer to this
	// paper for more details: https://arxiv.org/abs/1703.01365
	IntegratedGradientsAttribution *IntegratedGradientsAttribution `protobuf:"bytes,2,opt,name=integrated_gradients_attribution,json=integratedGradientsAttribution,proto3,oneof"`
}

type ExplanationParameters_XraiAttribution struct {
	// An attribution method that redistributes Integrated Gradients
	// attribution to segmented regions, taking advantage of the model's fully
	// differentiable structure. Refer to this paper for
	// more details: https://arxiv.org/abs/1906.02825
	//
	// XRAI currently performs better on natural images, like a picture of a
	// house or an animal. If the images are taken in artificial environments,
	// like a lab or manufacturing line, or from diagnostic equipment, like
	// x-rays or quality-control cameras, use Integrated Gradients instead.
	XraiAttribution *XraiAttribution `protobuf:"bytes,3,opt,name=xrai_attribution,json=xraiAttribution,proto3,oneof"`
}

type ExplanationParameters_Examples struct {
	// Example-based explanations that returns the nearest neighbors from the
	// provided dataset.
	Examples *Examples `protobuf:"bytes,7,opt,name=examples,proto3,oneof"`
}

func (*ExplanationParameters_SampledShapleyAttribution) isExplanationParameters_Method() {}

func (*ExplanationParameters_IntegratedGradientsAttribution) isExplanationParameters_Method() {}

func (*ExplanationParameters_XraiAttribution) isExplanationParameters_Method() {}

func (*ExplanationParameters_Examples) isExplanationParameters_Method() {}

// An attribution method that approximates Shapley values for features that
// contribute to the label being predicted. A sampling strategy is used to
// approximate the value rather than considering all subsets of features.
type SampledShapleyAttribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of feature permutations to consider when approximating
	// the Shapley values.
	//
	// Valid range of its value is [1, 50], inclusively.
	PathCount int32 `protobuf:"varint,1,opt,name=path_count,json=pathCount,proto3" json:"path_count,omitempty"`
}

func (x *SampledShapleyAttribution) Reset() {
	*x = SampledShapleyAttribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampledShapleyAttribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampledShapleyAttribution) ProtoMessage() {}

func (x *SampledShapleyAttribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampledShapleyAttribution.ProtoReflect.Descriptor instead.
func (*SampledShapleyAttribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{6}
}

func (x *SampledShapleyAttribution) GetPathCount() int32 {
	if x != nil {
		return x.PathCount
	}
	return 0
}

// An attribution method that computes the Aumann-Shapley value taking advantage
// of the model's fully differentiable structure. Refer to this paper for
// more details: https://arxiv.org/abs/1703.01365
type IntegratedGradientsAttribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of steps for approximating the path integral.
	// A good value to start is 50 and gradually increase until the
	// sum to diff property is within the desired error range.
	//
	// Valid range of its value is [1, 100], inclusively.
	StepCount int32 `protobuf:"varint,1,opt,name=step_count,json=stepCount,proto3" json:"step_count,omitempty"`
	// Config for SmoothGrad approximation of gradients.
	//
	// When enabled, the gradients are approximated by averaging the gradients
	// from noisy samples in the vicinity of the inputs. Adding
	// noise can help improve the computed gradients. Refer to this paper for more
	// details: https://arxiv.org/pdf/1706.03825.pdf
	SmoothGradConfig *SmoothGradConfig `protobuf:"bytes,2,opt,name=smooth_grad_config,json=smoothGradConfig,proto3" json:"smooth_grad_config,omitempty"`
	// Config for IG with blur baseline.
	//
	// When enabled, a linear path from the maximally blurred image to the input
	// image is created. Using a blurred baseline instead of zero (black image) is
	// motivated by the BlurIG approach explained here:
	// https://arxiv.org/abs/2004.03383
	BlurBaselineConfig *BlurBaselineConfig `protobuf:"bytes,3,opt,name=blur_baseline_config,json=blurBaselineConfig,proto3" json:"blur_baseline_config,omitempty"`
}

func (x *IntegratedGradientsAttribution) Reset() {
	*x = IntegratedGradientsAttribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntegratedGradientsAttribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntegratedGradientsAttribution) ProtoMessage() {}

func (x *IntegratedGradientsAttribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntegratedGradientsAttribution.ProtoReflect.Descriptor instead.
func (*IntegratedGradientsAttribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{7}
}

func (x *IntegratedGradientsAttribution) GetStepCount() int32 {
	if x != nil {
		return x.StepCount
	}
	return 0
}

func (x *IntegratedGradientsAttribution) GetSmoothGradConfig() *SmoothGradConfig {
	if x != nil {
		return x.SmoothGradConfig
	}
	return nil
}

func (x *IntegratedGradientsAttribution) GetBlurBaselineConfig() *BlurBaselineConfig {
	if x != nil {
		return x.BlurBaselineConfig
	}
	return nil
}

// An explanation method that redistributes Integrated Gradients
// attributions to segmented regions, taking advantage of the model's fully
// differentiable structure. Refer to this paper for more details:
// https://arxiv.org/abs/1906.02825
//
// Supported only by image Models.
type XraiAttribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of steps for approximating the path integral.
	// A good value to start is 50 and gradually increase until the
	// sum to diff property is met within the desired error range.
	//
	// Valid range of its value is [1, 100], inclusively.
	StepCount int32 `protobuf:"varint,1,opt,name=step_count,json=stepCount,proto3" json:"step_count,omitempty"`
	// Config for SmoothGrad approximation of gradients.
	//
	// When enabled, the gradients are approximated by averaging the gradients
	// from noisy samples in the vicinity of the inputs. Adding
	// noise can help improve the computed gradients. Refer to this paper for more
	// details: https://arxiv.org/pdf/1706.03825.pdf
	SmoothGradConfig *SmoothGradConfig `protobuf:"bytes,2,opt,name=smooth_grad_config,json=smoothGradConfig,proto3" json:"smooth_grad_config,omitempty"`
	// Config for XRAI with blur baseline.
	//
	// When enabled, a linear path from the maximally blurred image to the input
	// image is created. Using a blurred baseline instead of zero (black image) is
	// motivated by the BlurIG approach explained here:
	// https://arxiv.org/abs/2004.03383
	BlurBaselineConfig *BlurBaselineConfig `protobuf:"bytes,3,opt,name=blur_baseline_config,json=blurBaselineConfig,proto3" json:"blur_baseline_config,omitempty"`
}

func (x *XraiAttribution) Reset() {
	*x = XraiAttribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *XraiAttribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*XraiAttribution) ProtoMessage() {}

func (x *XraiAttribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use XraiAttribution.ProtoReflect.Descriptor instead.
func (*XraiAttribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{8}
}

func (x *XraiAttribution) GetStepCount() int32 {
	if x != nil {
		return x.StepCount
	}
	return 0
}

func (x *XraiAttribution) GetSmoothGradConfig() *SmoothGradConfig {
	if x != nil {
		return x.SmoothGradConfig
	}
	return nil
}

func (x *XraiAttribution) GetBlurBaselineConfig() *BlurBaselineConfig {
	if x != nil {
		return x.BlurBaselineConfig
	}
	return nil
}

// Config for SmoothGrad approximation of gradients.
//
// When enabled, the gradients are approximated by averaging the gradients from
// noisy samples in the vicinity of the inputs. Adding noise can help improve
// the computed gradients. Refer to this paper for more details:
// https://arxiv.org/pdf/1706.03825.pdf
type SmoothGradConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the standard deviation of the gaussian kernel
	// that will be used to add noise to the interpolated inputs
	// prior to computing gradients.
	//
	// Types that are assignable to GradientNoiseSigma:
	//
	//	*SmoothGradConfig_NoiseSigma
	//	*SmoothGradConfig_FeatureNoiseSigma
	GradientNoiseSigma isSmoothGradConfig_GradientNoiseSigma `protobuf_oneof:"GradientNoiseSigma"`
	// The number of gradient samples to use for
	// approximation. The higher this number, the more accurate the gradient
	// is, but the runtime complexity increases by this factor as well.
	// Valid range of its value is [1, 50]. Defaults to 3.
	NoisySampleCount int32 `protobuf:"varint,3,opt,name=noisy_sample_count,json=noisySampleCount,proto3" json:"noisy_sample_count,omitempty"`
}

func (x *SmoothGradConfig) Reset() {
	*x = SmoothGradConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmoothGradConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmoothGradConfig) ProtoMessage() {}

func (x *SmoothGradConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmoothGradConfig.ProtoReflect.Descriptor instead.
func (*SmoothGradConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{9}
}

func (m *SmoothGradConfig) GetGradientNoiseSigma() isSmoothGradConfig_GradientNoiseSigma {
	if m != nil {
		return m.GradientNoiseSigma
	}
	return nil
}

func (x *SmoothGradConfig) GetNoiseSigma() float32 {
	if x, ok := x.GetGradientNoiseSigma().(*SmoothGradConfig_NoiseSigma); ok {
		return x.NoiseSigma
	}
	return 0
}

func (x *SmoothGradConfig) GetFeatureNoiseSigma() *FeatureNoiseSigma {
	if x, ok := x.GetGradientNoiseSigma().(*SmoothGradConfig_FeatureNoiseSigma); ok {
		return x.FeatureNoiseSigma
	}
	return nil
}

func (x *SmoothGradConfig) GetNoisySampleCount() int32 {
	if x != nil {
		return x.NoisySampleCount
	}
	return 0
}

type isSmoothGradConfig_GradientNoiseSigma interface {
	isSmoothGradConfig_GradientNoiseSigma()
}

type SmoothGradConfig_NoiseSigma struct {
	// This is a single float value and will be used to add noise to all the
	// features. Use this field when all features are normalized to have the
	// same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
	// features are normalized to have 0-mean and 1-variance. Learn more about
	// [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
	//
	// For best results the recommended value is about 10% - 20% of the standard
	// deviation of the input feature. Refer to section 3.2 of the SmoothGrad
	// paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
	//
	// If the distribution is different per feature, set
	// [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
	// instead for each feature.
	NoiseSigma float32 `protobuf:"fixed32,1,opt,name=noise_sigma,json=noiseSigma,proto3,oneof"`
}

type SmoothGradConfig_FeatureNoiseSigma struct {
	// This is similar to
	// [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
	// but provides additional flexibility. A separate noise sigma can be
	// provided for each feature, which is useful if their distributions are
	// different. No noise is added to features that are not set. If this field
	// is unset,
	// [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
	// will be used for all features.
	FeatureNoiseSigma *FeatureNoiseSigma `protobuf:"bytes,2,opt,name=feature_noise_sigma,json=featureNoiseSigma,proto3,oneof"`
}

func (*SmoothGradConfig_NoiseSigma) isSmoothGradConfig_GradientNoiseSigma() {}

func (*SmoothGradConfig_FeatureNoiseSigma) isSmoothGradConfig_GradientNoiseSigma() {}

// Noise sigma by features. Noise sigma represents the standard deviation of the
// gaussian kernel that will be used to add noise to interpolated inputs prior
// to computing gradients.
type FeatureNoiseSigma struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Noise sigma per feature. No noise is added to features that are not set.
	NoiseSigma []*FeatureNoiseSigma_NoiseSigmaForFeature `protobuf:"bytes,1,rep,name=noise_sigma,json=noiseSigma,proto3" json:"noise_sigma,omitempty"`
}

func (x *FeatureNoiseSigma) Reset() {
	*x = FeatureNoiseSigma{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureNoiseSigma) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureNoiseSigma) ProtoMessage() {}

func (x *FeatureNoiseSigma) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureNoiseSigma.ProtoReflect.Descriptor instead.
func (*FeatureNoiseSigma) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{10}
}

func (x *FeatureNoiseSigma) GetNoiseSigma() []*FeatureNoiseSigma_NoiseSigmaForFeature {
	if x != nil {
		return x.NoiseSigma
	}
	return nil
}

// Config for blur baseline.
//
// When enabled, a linear path from the maximally blurred image to the input
// image is created. Using a blurred baseline instead of zero (black image) is
// motivated by the BlurIG approach explained here:
// https://arxiv.org/abs/2004.03383
type BlurBaselineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The standard deviation of the blur kernel for the blurred baseline. The
	// same blurring parameter is used for both the height and the width
	// dimension. If not set, the method defaults to the zero (i.e. black for
	// images) baseline.
	MaxBlurSigma float32 `protobuf:"fixed32,1,opt,name=max_blur_sigma,json=maxBlurSigma,proto3" json:"max_blur_sigma,omitempty"`
}

func (x *BlurBaselineConfig) Reset() {
	*x = BlurBaselineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlurBaselineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlurBaselineConfig) ProtoMessage() {}

func (x *BlurBaselineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlurBaselineConfig.ProtoReflect.Descriptor instead.
func (*BlurBaselineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{11}
}

func (x *BlurBaselineConfig) GetMaxBlurSigma() float32 {
	if x != nil {
		return x.MaxBlurSigma
	}
	return 0
}

// Example-based explainability that returns the nearest neighbors from the
// provided dataset.
type Examples struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*Examples_ExampleGcsSource_
	Source isExamples_Source `protobuf_oneof:"source"`
	// Types that are assignable to Config:
	//
	//	*Examples_NearestNeighborSearchConfig
	//	*Examples_Presets
	Config isExamples_Config `protobuf_oneof:"config"`
	// The number of neighbors to return when querying for examples.
	NeighborCount int32 `protobuf:"varint,3,opt,name=neighbor_count,json=neighborCount,proto3" json:"neighbor_count,omitempty"`
}

func (x *Examples) Reset() {
	*x = Examples{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Examples) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Examples) ProtoMessage() {}

func (x *Examples) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Examples.ProtoReflect.Descriptor instead.
func (*Examples) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{12}
}

func (m *Examples) GetSource() isExamples_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Examples) GetExampleGcsSource() *Examples_ExampleGcsSource {
	if x, ok := x.GetSource().(*Examples_ExampleGcsSource_); ok {
		return x.ExampleGcsSource
	}
	return nil
}

func (m *Examples) GetConfig() isExamples_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *Examples) GetNearestNeighborSearchConfig() *structpb.Value {
	if x, ok := x.GetConfig().(*Examples_NearestNeighborSearchConfig); ok {
		return x.NearestNeighborSearchConfig
	}
	return nil
}

func (x *Examples) GetPresets() *Presets {
	if x, ok := x.GetConfig().(*Examples_Presets); ok {
		return x.Presets
	}
	return nil
}

func (x *Examples) GetNeighborCount() int32 {
	if x != nil {
		return x.NeighborCount
	}
	return 0
}

type isExamples_Source interface {
	isExamples_Source()
}

type Examples_ExampleGcsSource_ struct {
	// The Cloud Storage input instances.
	ExampleGcsSource *Examples_ExampleGcsSource `protobuf:"bytes,5,opt,name=example_gcs_source,json=exampleGcsSource,proto3,oneof"`
}

func (*Examples_ExampleGcsSource_) isExamples_Source() {}

type isExamples_Config interface {
	isExamples_Config()
}

type Examples_NearestNeighborSearchConfig struct {
	// The full configuration for the generated index, the semantics are the
	// same as [metadata][google.cloud.aiplatform.v1.Index.metadata] and should
	// match
	// [NearestNeighborSearchConfig](https://cloud.google.com/vertex-ai/docs/explainable-ai/configuring-explanations-example-based#nearest-neighbor-search-config).
	NearestNeighborSearchConfig *structpb.Value `protobuf:"bytes,2,opt,name=nearest_neighbor_search_config,json=nearestNeighborSearchConfig,proto3,oneof"`
}

type Examples_Presets struct {
	// Simplified preset configuration, which automatically sets configuration
	// values based on the desired query speed-precision trade-off and modality.
	Presets *Presets `protobuf:"bytes,4,opt,name=presets,proto3,oneof"`
}

func (*Examples_NearestNeighborSearchConfig) isExamples_Config() {}

func (*Examples_Presets) isExamples_Config() {}

// Preset configuration for example-based explanations
type Presets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Preset option controlling parameters for speed-precision trade-off when
	// querying for examples. If omitted, defaults to `PRECISE`.
	Query *Presets_Query `protobuf:"varint,1,opt,name=query,proto3,enum=google.cloud.aiplatform.v1.Presets_Query,oneof" json:"query,omitempty"`
	// The modality of the uploaded model, which automatically configures the
	// distance measurement and feature normalization for the underlying example
	// index and queries. If your model does not precisely fit one of these types,
	// it is okay to choose the closest type.
	Modality Presets_Modality `protobuf:"varint,2,opt,name=modality,proto3,enum=google.cloud.aiplatform.v1.Presets_Modality" json:"modality,omitempty"`
}

func (x *Presets) Reset() {
	*x = Presets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Presets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Presets) ProtoMessage() {}

func (x *Presets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Presets.ProtoReflect.Descriptor instead.
func (*Presets) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{13}
}

func (x *Presets) GetQuery() Presets_Query {
	if x != nil && x.Query != nil {
		return *x.Query
	}
	return Presets_PRECISE
}

func (x *Presets) GetModality() Presets_Modality {
	if x != nil {
		return x.Modality
	}
	return Presets_MODALITY_UNSPECIFIED
}

// The [ExplanationSpec][google.cloud.aiplatform.v1.ExplanationSpec] entries
// that can be overridden at [online
// explanation][google.cloud.aiplatform.v1.PredictionService.Explain] time.
type ExplanationSpecOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parameters to be overridden. Note that the
	// attribution method cannot be changed. If not specified,
	// no parameter is overridden.
	Parameters *ExplanationParameters `protobuf:"bytes,1,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The metadata to be overridden. If not specified, no metadata is overridden.
	Metadata *ExplanationMetadataOverride `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The example-based explanations parameter overrides.
	ExamplesOverride *ExamplesOverride `protobuf:"bytes,3,opt,name=examples_override,json=examplesOverride,proto3" json:"examples_override,omitempty"`
}

func (x *ExplanationSpecOverride) Reset() {
	*x = ExplanationSpecOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationSpecOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationSpecOverride) ProtoMessage() {}

func (x *ExplanationSpecOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationSpecOverride.ProtoReflect.Descriptor instead.
func (*ExplanationSpecOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{14}
}

func (x *ExplanationSpecOverride) GetParameters() *ExplanationParameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ExplanationSpecOverride) GetMetadata() *ExplanationMetadataOverride {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ExplanationSpecOverride) GetExamplesOverride() *ExamplesOverride {
	if x != nil {
		return x.ExamplesOverride
	}
	return nil
}

// The [ExplanationMetadata][google.cloud.aiplatform.v1.ExplanationMetadata]
// entries that can be overridden at [online
// explanation][google.cloud.aiplatform.v1.PredictionService.Explain] time.
type ExplanationMetadataOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Overrides the [input
	// metadata][google.cloud.aiplatform.v1.ExplanationMetadata.inputs] of the
	// features. The key is the name of the feature to be overridden. The keys
	// specified here must exist in the input metadata to be overridden. If a
	// feature is not specified here, the corresponding feature's input metadata
	// is not overridden.
	Inputs map[string]*ExplanationMetadataOverride_InputMetadataOverride `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ExplanationMetadataOverride) Reset() {
	*x = ExplanationMetadataOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadataOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadataOverride) ProtoMessage() {}

func (x *ExplanationMetadataOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadataOverride.ProtoReflect.Descriptor instead.
func (*ExplanationMetadataOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{15}
}

func (x *ExplanationMetadataOverride) GetInputs() map[string]*ExplanationMetadataOverride_InputMetadataOverride {
	if x != nil {
		return x.Inputs
	}
	return nil
}

// Overrides for example-based explanations.
type ExamplesOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of neighbors to return.
	NeighborCount int32 `protobuf:"varint,1,opt,name=neighbor_count,json=neighborCount,proto3" json:"neighbor_count,omitempty"`
	// The number of neighbors to return that have the same crowding tag.
	CrowdingCount int32 `protobuf:"varint,2,opt,name=crowding_count,json=crowdingCount,proto3" json:"crowding_count,omitempty"`
	// Restrict the resulting nearest neighbors to respect these constraints.
	Restrictions []*ExamplesRestrictionsNamespace `protobuf:"bytes,3,rep,name=restrictions,proto3" json:"restrictions,omitempty"`
	// If true, return the embeddings instead of neighbors.
	ReturnEmbeddings bool `protobuf:"varint,4,opt,name=return_embeddings,json=returnEmbeddings,proto3" json:"return_embeddings,omitempty"`
	// The format of the data being provided with each call.
	DataFormat ExamplesOverride_DataFormat `protobuf:"varint,5,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.aiplatform.v1.ExamplesOverride_DataFormat" json:"data_format,omitempty"`
}

func (x *ExamplesOverride) Reset() {
	*x = ExamplesOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExamplesOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExamplesOverride) ProtoMessage() {}

func (x *ExamplesOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExamplesOverride.ProtoReflect.Descriptor instead.
func (*ExamplesOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{16}
}

func (x *ExamplesOverride) GetNeighborCount() int32 {
	if x != nil {
		return x.NeighborCount
	}
	return 0
}

func (x *ExamplesOverride) GetCrowdingCount() int32 {
	if x != nil {
		return x.CrowdingCount
	}
	return 0
}

func (x *ExamplesOverride) GetRestrictions() []*ExamplesRestrictionsNamespace {
	if x != nil {
		return x.Restrictions
	}
	return nil
}

func (x *ExamplesOverride) GetReturnEmbeddings() bool {
	if x != nil {
		return x.ReturnEmbeddings
	}
	return false
}

func (x *ExamplesOverride) GetDataFormat() ExamplesOverride_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExamplesOverride_DATA_FORMAT_UNSPECIFIED
}

// Restrictions namespace for example-based explanations overrides.
type ExamplesRestrictionsNamespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The namespace name.
	NamespaceName string `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	// The list of allowed tags.
	Allow []string `protobuf:"bytes,2,rep,name=allow,proto3" json:"allow,omitempty"`
	// The list of deny tags.
	Deny []string `protobuf:"bytes,3,rep,name=deny,proto3" json:"deny,omitempty"`
}

func (x *ExamplesRestrictionsNamespace) Reset() {
	*x = ExamplesRestrictionsNamespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExamplesRestrictionsNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExamplesRestrictionsNamespace) ProtoMessage() {}

func (x *ExamplesRestrictionsNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExamplesRestrictionsNamespace.ProtoReflect.Descriptor instead.
func (*ExamplesRestrictionsNamespace) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{17}
}

func (x *ExamplesRestrictionsNamespace) GetNamespaceName() string {
	if x != nil {
		return x.NamespaceName
	}
	return ""
}

func (x *ExamplesRestrictionsNamespace) GetAllow() []string {
	if x != nil {
		return x.Allow
	}
	return nil
}

func (x *ExamplesRestrictionsNamespace) GetDeny() []string {
	if x != nil {
		return x.Deny
	}
	return nil
}

// Noise sigma for a single feature.
type FeatureNoiseSigma_NoiseSigmaForFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the input feature for which noise sigma is provided. The
	// features are defined in
	// [explanation metadata
	// inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This represents the standard deviation of the Gaussian kernel that will
	// be used to add noise to the feature prior to computing gradients. Similar
	// to [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
	// but represents the noise added to the current feature. Defaults to 0.1.
	Sigma float32 `protobuf:"fixed32,2,opt,name=sigma,proto3" json:"sigma,omitempty"`
}

func (x *FeatureNoiseSigma_NoiseSigmaForFeature) Reset() {
	*x = FeatureNoiseSigma_NoiseSigmaForFeature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureNoiseSigma_NoiseSigmaForFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureNoiseSigma_NoiseSigmaForFeature) ProtoMessage() {}

func (x *FeatureNoiseSigma_NoiseSigmaForFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureNoiseSigma_NoiseSigmaForFeature.ProtoReflect.Descriptor instead.
func (*FeatureNoiseSigma_NoiseSigmaForFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{10, 0}
}

func (x *FeatureNoiseSigma_NoiseSigmaForFeature) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FeatureNoiseSigma_NoiseSigmaForFeature) GetSigma() float32 {
	if x != nil {
		return x.Sigma
	}
	return 0
}

// The Cloud Storage input instances.
type Examples_ExampleGcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The format in which instances are given, if not specified, assume it's
	// JSONL format. Currently only JSONL format is supported.
	DataFormat Examples_ExampleGcsSource_DataFormat `protobuf:"varint,1,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.aiplatform.v1.Examples_ExampleGcsSource_DataFormat" json:"data_format,omitempty"`
	// The Cloud Storage location for the input instances.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
}

func (x *Examples_ExampleGcsSource) Reset() {
	*x = Examples_ExampleGcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Examples_ExampleGcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Examples_ExampleGcsSource) ProtoMessage() {}

func (x *Examples_ExampleGcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Examples_ExampleGcsSource.ProtoReflect.Descriptor instead.
func (*Examples_ExampleGcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Examples_ExampleGcsSource) GetDataFormat() Examples_ExampleGcsSource_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return Examples_ExampleGcsSource_DATA_FORMAT_UNSPECIFIED
}

func (x *Examples_ExampleGcsSource) GetGcsSource() *GcsSource {
	if x != nil {
		return x.GcsSource
	}
	return nil
}

// The [input
// metadata][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata]
// entries to be overridden.
type ExplanationMetadataOverride_InputMetadataOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Baseline inputs for this feature.
	//
	// This overrides the `input_baseline` field of the
	// [ExplanationMetadata.InputMetadata][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata]
	// object of the corresponding feature's input metadata. If it's not
	// specified, the original baselines are not overridden.
	InputBaselines []*structpb.Value `protobuf:"bytes,1,rep,name=input_baselines,json=inputBaselines,proto3" json:"input_baselines,omitempty"`
}

func (x *ExplanationMetadataOverride_InputMetadataOverride) Reset() {
	*x = ExplanationMetadataOverride_InputMetadataOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadataOverride_InputMetadataOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadataOverride_InputMetadataOverride) ProtoMessage() {}

func (x *ExplanationMetadataOverride_InputMetadataOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadataOverride_InputMetadataOverride.ProtoReflect.Descriptor instead.
func (*ExplanationMetadataOverride_InputMetadataOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP(), []int{15, 0}
}

func (x *ExplanationMetadataOverride_InputMetadataOverride) GetInputBaselines() []*structpb.Value {
	if x != nil {
		return x.InputBaselines
	}
	return nil
}

var File_google_cloud_aiplatform_v1_explanation_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_explanation_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x09, 0x6e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73,
	0x22, 0x6d, 0x0a, 0x10, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x11, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d,
	0x65, 0x61, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x88, 0x03, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x37, 0x0a, 0x15, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x4e, 0x0a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x04, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x33, 0x0a, 0x13, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34,
	0x0a, 0x13, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x08, 0x4e, 0x65,
	0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x11,
	0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6e, 0x65,
	0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xbb,
	0x01, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x56, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x50, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x99, 0x04, 0x0a,
	0x15, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x77, 0x0a, 0x1b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x64, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x6c, 0x65, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64,
	0x53, 0x68, 0x61, 0x70, 0x6c, 0x65, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x53, 0x68, 0x61,
	0x70, 0x6c, 0x65, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x86, 0x01, 0x0a, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x67,
	0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x47, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x47, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x10, 0x78, 0x72, 0x61, 0x69,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x58, 0x72, 0x61, 0x69, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0f, 0x78, 0x72, 0x61, 0x69, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x08, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x13, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x12, 0x41, 0x0a, 0x0e, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x42, 0x08,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x3f, 0x0a, 0x19, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x64, 0x53, 0x68, 0x61, 0x70, 0x6c, 0x65, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x61, 0x74, 0x68, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x82, 0x02, 0x0a, 0x1e, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x47, 0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x74,
	0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x5a, 0x0a, 0x12, 0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x5f, 0x67, 0x72, 0x61, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6d, 0x6f, 0x6f, 0x74, 0x68,
	0x47, 0x72, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x73, 0x6d, 0x6f, 0x6f,
	0x74, 0x68, 0x47, 0x72, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x14,
	0x62, 0x6c, 0x75, 0x72, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x72, 0x42, 0x61, 0x73, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x62, 0x6c, 0x75, 0x72,
	0x42, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf3,
	0x01, 0x0a, 0x0f, 0x58, 0x72, 0x61, 0x69, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x65,
	0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x12, 0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68,
	0x5f, 0x67, 0x72, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x47, 0x72, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x10, 0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x47, 0x72, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x60, 0x0a, 0x14, 0x62, 0x6c, 0x75, 0x72, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c,
	0x75, 0x72, 0x42, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x12, 0x62, 0x6c, 0x75, 0x72, 0x42, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xda, 0x01, 0x0a, 0x10, 0x53, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x47,
	0x72, 0x61, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0b, 0x6e, 0x6f, 0x69,
	0x73, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00,
	0x52, 0x0a, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x12, 0x5f, 0x0a, 0x13,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x5f, 0x73, 0x69,
	0x67, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x11, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x12, 0x2c, 0x0a,
	0x12, 0x6e, 0x6f, 0x69, 0x73, 0x79, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6e, 0x6f, 0x69, 0x73, 0x79,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x47,
	0x72, 0x61, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d,
	0x61, 0x22, 0xba, 0x01, 0x0a, 0x11, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x69,
	0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x12, 0x63, 0x0a, 0x0b, 0x6e, 0x6f, 0x69, 0x73, 0x65,
	0x5f, 0x73, 0x69, 0x67, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x2e, 0x4e, 0x6f, 0x69, 0x73,
	0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x46, 0x6f, 0x72, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x52, 0x0a, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x1a, 0x40, 0x0a, 0x14,
	0x4e, 0x6f, 0x69, 0x73, 0x65, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x46, 0x6f, 0x72, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x69, 0x67, 0x6d,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x69, 0x67, 0x6d, 0x61, 0x22, 0x3a,
	0x0a, 0x12, 0x42, 0x6c, 0x75, 0x72, 0x42, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x6c, 0x75, 0x72,
	0x5f, 0x73, 0x69, 0x67, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x6d, 0x61,
	0x78, 0x42, 0x6c, 0x75, 0x72, 0x53, 0x69, 0x67, 0x6d, 0x61, 0x22, 0xc0, 0x04, 0x0a, 0x08, 0x45,
	0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x12, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5d,
	0x0a, 0x1e, 0x6e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x01,
	0x52, 0x1b, 0x6e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f,
	0x72, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a,
	0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x73, 0x48, 0x01, 0x52, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xf1, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x61, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x47, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x44, 0x0a,
	0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x34, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x4a, 0x53, 0x4f, 0x4e, 0x4c, 0x10, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8b, 0x02,
	0x0a, 0x07, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x48, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x65, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x08, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x1e, 0x0a, 0x05, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x45, 0x43, 0x49, 0x53, 0x45, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x46, 0x41, 0x53, 0x54, 0x10, 0x01, 0x22, 0x46, 0x0a, 0x08, 0x4d, 0x6f, 0x64,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x4f, 0x44, 0x41, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45,
	0x58, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x41, 0x42, 0x55, 0x4c, 0x41, 0x52, 0x10,
	0x03, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x9c, 0x02, 0x0a, 0x17,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x59, 0x0a, 0x11, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x10, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x22, 0xe4, 0x02, 0x0a, 0x1b, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x60, 0x0a, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x1a, 0x58, 0x0a, 0x15,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x3f, 0x0a, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x62,
	0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x61, 0x73,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x1a, 0x88, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x63, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x90, 0x03, 0x0a, 0x10, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x63, 0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x72, 0x6f, 0x77, 0x64, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x58, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x48, 0x0a, 0x0a, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x53, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4d, 0x42, 0x45, 0x44, 0x44, 0x49, 0x4e,
	0x47, 0x53, 0x10, 0x02, 0x22, 0x70, 0x0a, 0x1d, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x65, 0x6e, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x04, 0x64, 0x65, 0x6e, 0x79, 0x42, 0xce, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x45, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_explanation_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_explanation_proto_rawDescData = file_google_cloud_aiplatform_v1_explanation_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_explanation_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_explanation_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_explanation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_explanation_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_explanation_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_explanation_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_aiplatform_v1_explanation_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_aiplatform_v1_explanation_proto_goTypes = []interface{}{
	(Examples_ExampleGcsSource_DataFormat)(0),                 // 0: google.cloud.aiplatform.v1.Examples.ExampleGcsSource.DataFormat
	(Presets_Query)(0),                                        // 1: google.cloud.aiplatform.v1.Presets.Query
	(Presets_Modality)(0),                                     // 2: google.cloud.aiplatform.v1.Presets.Modality
	(ExamplesOverride_DataFormat)(0),                          // 3: google.cloud.aiplatform.v1.ExamplesOverride.DataFormat
	(*Explanation)(nil),                                       // 4: google.cloud.aiplatform.v1.Explanation
	(*ModelExplanation)(nil),                                  // 5: google.cloud.aiplatform.v1.ModelExplanation
	(*Attribution)(nil),                                       // 6: google.cloud.aiplatform.v1.Attribution
	(*Neighbor)(nil),                                          // 7: google.cloud.aiplatform.v1.Neighbor
	(*ExplanationSpec)(nil),                                   // 8: google.cloud.aiplatform.v1.ExplanationSpec
	(*ExplanationParameters)(nil),                             // 9: google.cloud.aiplatform.v1.ExplanationParameters
	(*SampledShapleyAttribution)(nil),                         // 10: google.cloud.aiplatform.v1.SampledShapleyAttribution
	(*IntegratedGradientsAttribution)(nil),                    // 11: google.cloud.aiplatform.v1.IntegratedGradientsAttribution
	(*XraiAttribution)(nil),                                   // 12: google.cloud.aiplatform.v1.XraiAttribution
	(*SmoothGradConfig)(nil),                                  // 13: google.cloud.aiplatform.v1.SmoothGradConfig
	(*FeatureNoiseSigma)(nil),                                 // 14: google.cloud.aiplatform.v1.FeatureNoiseSigma
	(*BlurBaselineConfig)(nil),                                // 15: google.cloud.aiplatform.v1.BlurBaselineConfig
	(*Examples)(nil),                                          // 16: google.cloud.aiplatform.v1.Examples
	(*Presets)(nil),                                           // 17: google.cloud.aiplatform.v1.Presets
	(*ExplanationSpecOverride)(nil),                           // 18: google.cloud.aiplatform.v1.ExplanationSpecOverride
	(*ExplanationMetadataOverride)(nil),                       // 19: google.cloud.aiplatform.v1.ExplanationMetadataOverride
	(*ExamplesOverride)(nil),                                  // 20: google.cloud.aiplatform.v1.ExamplesOverride
	(*ExamplesRestrictionsNamespace)(nil),                     // 21: google.cloud.aiplatform.v1.ExamplesRestrictionsNamespace
	(*FeatureNoiseSigma_NoiseSigmaForFeature)(nil),            // 22: google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
	(*Examples_ExampleGcsSource)(nil),                         // 23: google.cloud.aiplatform.v1.Examples.ExampleGcsSource
	(*ExplanationMetadataOverride_InputMetadataOverride)(nil), // 24: google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputMetadataOverride
	nil,                         // 25: google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputsEntry
	(*structpb.Value)(nil),      // 26: google.protobuf.Value
	(*ExplanationMetadata)(nil), // 27: google.cloud.aiplatform.v1.ExplanationMetadata
	(*structpb.ListValue)(nil),  // 28: google.protobuf.ListValue
	(*GcsSource)(nil),           // 29: google.cloud.aiplatform.v1.GcsSource
}
var file_google_cloud_aiplatform_v1_explanation_proto_depIdxs = []int32{
	6,  // 0: google.cloud.aiplatform.v1.Explanation.attributions:type_name -> google.cloud.aiplatform.v1.Attribution
	7,  // 1: google.cloud.aiplatform.v1.Explanation.neighbors:type_name -> google.cloud.aiplatform.v1.Neighbor
	6,  // 2: google.cloud.aiplatform.v1.ModelExplanation.mean_attributions:type_name -> google.cloud.aiplatform.v1.Attribution
	26, // 3: google.cloud.aiplatform.v1.Attribution.feature_attributions:type_name -> google.protobuf.Value
	9,  // 4: google.cloud.aiplatform.v1.ExplanationSpec.parameters:type_name -> google.cloud.aiplatform.v1.ExplanationParameters
	27, // 5: google.cloud.aiplatform.v1.ExplanationSpec.metadata:type_name -> google.cloud.aiplatform.v1.ExplanationMetadata
	10, // 6: google.cloud.aiplatform.v1.ExplanationParameters.sampled_shapley_attribution:type_name -> google.cloud.aiplatform.v1.SampledShapleyAttribution
	11, // 7: google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution:type_name -> google.cloud.aiplatform.v1.IntegratedGradientsAttribution
	12, // 8: google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution:type_name -> google.cloud.aiplatform.v1.XraiAttribution
	16, // 9: google.cloud.aiplatform.v1.ExplanationParameters.examples:type_name -> google.cloud.aiplatform.v1.Examples
	28, // 10: google.cloud.aiplatform.v1.ExplanationParameters.output_indices:type_name -> google.protobuf.ListValue
	13, // 11: google.cloud.aiplatform.v1.IntegratedGradientsAttribution.smooth_grad_config:type_name -> google.cloud.aiplatform.v1.SmoothGradConfig
	15, // 12: google.cloud.aiplatform.v1.IntegratedGradientsAttribution.blur_baseline_config:type_name -> google.cloud.aiplatform.v1.BlurBaselineConfig
	13, // 13: google.cloud.aiplatform.v1.XraiAttribution.smooth_grad_config:type_name -> google.cloud.aiplatform.v1.SmoothGradConfig
	15, // 14: google.cloud.aiplatform.v1.XraiAttribution.blur_baseline_config:type_name -> google.cloud.aiplatform.v1.BlurBaselineConfig
	14, // 15: google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma:type_name -> google.cloud.aiplatform.v1.FeatureNoiseSigma
	22, // 16: google.cloud.aiplatform.v1.FeatureNoiseSigma.noise_sigma:type_name -> google.cloud.aiplatform.v1.FeatureNoiseSigma.NoiseSigmaForFeature
	23, // 17: google.cloud.aiplatform.v1.Examples.example_gcs_source:type_name -> google.cloud.aiplatform.v1.Examples.ExampleGcsSource
	26, // 18: google.cloud.aiplatform.v1.Examples.nearest_neighbor_search_config:type_name -> google.protobuf.Value
	17, // 19: google.cloud.aiplatform.v1.Examples.presets:type_name -> google.cloud.aiplatform.v1.Presets
	1,  // 20: google.cloud.aiplatform.v1.Presets.query:type_name -> google.cloud.aiplatform.v1.Presets.Query
	2,  // 21: google.cloud.aiplatform.v1.Presets.modality:type_name -> google.cloud.aiplatform.v1.Presets.Modality
	9,  // 22: google.cloud.aiplatform.v1.ExplanationSpecOverride.parameters:type_name -> google.cloud.aiplatform.v1.ExplanationParameters
	19, // 23: google.cloud.aiplatform.v1.ExplanationSpecOverride.metadata:type_name -> google.cloud.aiplatform.v1.ExplanationMetadataOverride
	20, // 24: google.cloud.aiplatform.v1.ExplanationSpecOverride.examples_override:type_name -> google.cloud.aiplatform.v1.ExamplesOverride
	25, // 25: google.cloud.aiplatform.v1.ExplanationMetadataOverride.inputs:type_name -> google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputsEntry
	21, // 26: google.cloud.aiplatform.v1.ExamplesOverride.restrictions:type_name -> google.cloud.aiplatform.v1.ExamplesRestrictionsNamespace
	3,  // 27: google.cloud.aiplatform.v1.ExamplesOverride.data_format:type_name -> google.cloud.aiplatform.v1.ExamplesOverride.DataFormat
	0,  // 28: google.cloud.aiplatform.v1.Examples.ExampleGcsSource.data_format:type_name -> google.cloud.aiplatform.v1.Examples.ExampleGcsSource.DataFormat
	29, // 29: google.cloud.aiplatform.v1.Examples.ExampleGcsSource.gcs_source:type_name -> google.cloud.aiplatform.v1.GcsSource
	26, // 30: google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputMetadataOverride.input_baselines:type_name -> google.protobuf.Value
	24, // 31: google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputsEntry.value:type_name -> google.cloud.aiplatform.v1.ExplanationMetadataOverride.InputMetadataOverride
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_explanation_proto_init() }
func file_google_cloud_aiplatform_v1_explanation_proto_init() {
	if File_google_cloud_aiplatform_v1_explanation_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_explanation_metadata_proto_init()
	file_google_cloud_aiplatform_v1_io_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Explanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Neighbor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampledShapleyAttribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntegratedGradientsAttribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*XraiAttribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmoothGradConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureNoiseSigma); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlurBaselineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Examples); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Presets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationSpecOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadataOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExamplesOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExamplesRestrictionsNamespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureNoiseSigma_NoiseSigmaForFeature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Examples_ExampleGcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadataOverride_InputMetadataOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ExplanationParameters_SampledShapleyAttribution)(nil),
		(*ExplanationParameters_IntegratedGradientsAttribution)(nil),
		(*ExplanationParameters_XraiAttribution)(nil),
		(*ExplanationParameters_Examples)(nil),
	}
	file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*SmoothGradConfig_NoiseSigma)(nil),
		(*SmoothGradConfig_FeatureNoiseSigma)(nil),
	}
	file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Examples_ExampleGcsSource_)(nil),
		(*Examples_NearestNeighborSearchConfig)(nil),
		(*Examples_Presets)(nil),
	}
	file_google_cloud_aiplatform_v1_explanation_proto_msgTypes[13].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_explanation_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_explanation_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_explanation_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_explanation_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_explanation_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_explanation_proto = out.File
	file_google_cloud_aiplatform_v1_explanation_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_explanation_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_explanation_proto_depIdxs = nil
}
