// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/privacy/dlp/v2/dlp.proto

package dlppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum of possible outcomes of transformations. SUCCESS if transformation and
// storing of transformation was successful, otherwise, reason for not
// transforming.
type TransformationResultStatusType int32

const (
	// Unused.
	TransformationResultStatusType_STATE_TYPE_UNSPECIFIED TransformationResultStatusType = 0
	// This will be set when a finding could not be transformed (i.e. outside user
	// set bucket range).
	TransformationResultStatusType_INVALID_TRANSFORM TransformationResultStatusType = 1
	// This will be set when a BigQuery transformation was successful but could
	// not be stored back in BigQuery because the transformed row exceeds
	// BigQuery's max row size.
	TransformationResultStatusType_BIGQUERY_MAX_ROW_SIZE_EXCEEDED TransformationResultStatusType = 2
	// This will be set when there is a finding in the custom metadata of a file,
	// but at the write time of the transformed file, this key / value pair is
	// unretrievable.
	TransformationResultStatusType_METADATA_UNRETRIEVABLE TransformationResultStatusType = 3
	// This will be set when the transformation and storing of it is successful.
	TransformationResultStatusType_SUCCESS TransformationResultStatusType = 4
)

// Enum value maps for TransformationResultStatusType.
var (
	TransformationResultStatusType_name = map[int32]string{
		0: "STATE_TYPE_UNSPECIFIED",
		1: "INVALID_TRANSFORM",
		2: "BIGQUERY_MAX_ROW_SIZE_EXCEEDED",
		3: "METADATA_UNRETRIEVABLE",
		4: "SUCCESS",
	}
	TransformationResultStatusType_value = map[string]int32{
		"STATE_TYPE_UNSPECIFIED":         0,
		"INVALID_TRANSFORM":              1,
		"BIGQUERY_MAX_ROW_SIZE_EXCEEDED": 2,
		"METADATA_UNRETRIEVABLE":         3,
		"SUCCESS":                        4,
	}
)

func (x TransformationResultStatusType) Enum() *TransformationResultStatusType {
	p := new(TransformationResultStatusType)
	*p = x
	return p
}

func (x TransformationResultStatusType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransformationResultStatusType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[0].Descriptor()
}

func (TransformationResultStatusType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[0]
}

func (x TransformationResultStatusType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransformationResultStatusType.Descriptor instead.
func (TransformationResultStatusType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{0}
}

// Describes functionality of a given container in its original format.
type TransformationContainerType int32

const (
	// Unused.
	TransformationContainerType_TRANSFORM_UNKNOWN_CONTAINER TransformationContainerType = 0
	// Body of a file.
	TransformationContainerType_TRANSFORM_BODY TransformationContainerType = 1
	// Metadata for a file.
	TransformationContainerType_TRANSFORM_METADATA TransformationContainerType = 2
	// A table.
	TransformationContainerType_TRANSFORM_TABLE TransformationContainerType = 3
)

// Enum value maps for TransformationContainerType.
var (
	TransformationContainerType_name = map[int32]string{
		0: "TRANSFORM_UNKNOWN_CONTAINER",
		1: "TRANSFORM_BODY",
		2: "TRANSFORM_METADATA",
		3: "TRANSFORM_TABLE",
	}
	TransformationContainerType_value = map[string]int32{
		"TRANSFORM_UNKNOWN_CONTAINER": 0,
		"TRANSFORM_BODY":              1,
		"TRANSFORM_METADATA":          2,
		"TRANSFORM_TABLE":             3,
	}
)

func (x TransformationContainerType) Enum() *TransformationContainerType {
	p := new(TransformationContainerType)
	*p = x
	return p
}

func (x TransformationContainerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransformationContainerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[1].Descriptor()
}

func (TransformationContainerType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[1]
}

func (x TransformationContainerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransformationContainerType.Descriptor instead.
func (TransformationContainerType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{1}
}

// An enum of rules that can be used to transform a value. Can be a
// record suppression, or one of the transformation rules specified under
// `PrimitiveTransformation`.
type TransformationType int32

const (
	// Unused
	TransformationType_TRANSFORMATION_TYPE_UNSPECIFIED TransformationType = 0
	// Record suppression
	TransformationType_RECORD_SUPPRESSION TransformationType = 1
	// Replace value
	TransformationType_REPLACE_VALUE TransformationType = 2
	// Replace value using a dictionary.
	TransformationType_REPLACE_DICTIONARY TransformationType = 15
	// Redact
	TransformationType_REDACT TransformationType = 3
	// Character mask
	TransformationType_CHARACTER_MASK TransformationType = 4
	// FFX-FPE
	TransformationType_CRYPTO_REPLACE_FFX_FPE TransformationType = 5
	// Fixed size bucketing
	TransformationType_FIXED_SIZE_BUCKETING TransformationType = 6
	// Bucketing
	TransformationType_BUCKETING TransformationType = 7
	// Replace with info type
	TransformationType_REPLACE_WITH_INFO_TYPE TransformationType = 8
	// Time part
	TransformationType_TIME_PART TransformationType = 9
	// Crypto hash
	TransformationType_CRYPTO_HASH TransformationType = 10
	// Date shift
	TransformationType_DATE_SHIFT TransformationType = 12
	// Deterministic crypto
	TransformationType_CRYPTO_DETERMINISTIC_CONFIG TransformationType = 13
	// Redact image
	TransformationType_REDACT_IMAGE TransformationType = 14
)

// Enum value maps for TransformationType.
var (
	TransformationType_name = map[int32]string{
		0:  "TRANSFORMATION_TYPE_UNSPECIFIED",
		1:  "RECORD_SUPPRESSION",
		2:  "REPLACE_VALUE",
		15: "REPLACE_DICTIONARY",
		3:  "REDACT",
		4:  "CHARACTER_MASK",
		5:  "CRYPTO_REPLACE_FFX_FPE",
		6:  "FIXED_SIZE_BUCKETING",
		7:  "BUCKETING",
		8:  "REPLACE_WITH_INFO_TYPE",
		9:  "TIME_PART",
		10: "CRYPTO_HASH",
		12: "DATE_SHIFT",
		13: "CRYPTO_DETERMINISTIC_CONFIG",
		14: "REDACT_IMAGE",
	}
	TransformationType_value = map[string]int32{
		"TRANSFORMATION_TYPE_UNSPECIFIED": 0,
		"RECORD_SUPPRESSION":              1,
		"REPLACE_VALUE":                   2,
		"REPLACE_DICTIONARY":              15,
		"REDACT":                          3,
		"CHARACTER_MASK":                  4,
		"CRYPTO_REPLACE_FFX_FPE":          5,
		"FIXED_SIZE_BUCKETING":            6,
		"BUCKETING":                       7,
		"REPLACE_WITH_INFO_TYPE":          8,
		"TIME_PART":                       9,
		"CRYPTO_HASH":                     10,
		"DATE_SHIFT":                      12,
		"CRYPTO_DETERMINISTIC_CONFIG":     13,
		"REDACT_IMAGE":                    14,
	}
)

func (x TransformationType) Enum() *TransformationType {
	p := new(TransformationType)
	*p = x
	return p
}

func (x TransformationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransformationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[2].Descriptor()
}

func (TransformationType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[2]
}

func (x TransformationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransformationType.Descriptor instead.
func (TransformationType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{2}
}

// Over time new types may be added. Currently VIEW, MATERIALIZED_VIEW,
// and SNAPSHOT are not supported.
type BigQueryTableTypeCollection int32

const (
	// Unused.
	BigQueryTableTypeCollection_BIG_QUERY_COLLECTION_UNSPECIFIED BigQueryTableTypeCollection = 0
	// Automatically generate profiles for all tables, even if the table type is
	// not yet fully supported for analysis. Profiles for unsupported tables will
	// be generated with errors to indicate their partial support. When full
	// support is added, the tables will automatically be profiled during the next
	// scheduled run.
	BigQueryTableTypeCollection_BIG_QUERY_COLLECTION_ALL_TYPES BigQueryTableTypeCollection = 1
	// Only those types fully supported will be profiled. Will expand
	// automatically as Cloud DLP adds support for new table types. Unsupported
	// table types will not have partial profiles generated.
	BigQueryTableTypeCollection_BIG_QUERY_COLLECTION_ONLY_SUPPORTED_TYPES BigQueryTableTypeCollection = 2
)

// Enum value maps for BigQueryTableTypeCollection.
var (
	BigQueryTableTypeCollection_name = map[int32]string{
		0: "BIG_QUERY_COLLECTION_UNSPECIFIED",
		1: "BIG_QUERY_COLLECTION_ALL_TYPES",
		2: "BIG_QUERY_COLLECTION_ONLY_SUPPORTED_TYPES",
	}
	BigQueryTableTypeCollection_value = map[string]int32{
		"BIG_QUERY_COLLECTION_UNSPECIFIED":          0,
		"BIG_QUERY_COLLECTION_ALL_TYPES":            1,
		"BIG_QUERY_COLLECTION_ONLY_SUPPORTED_TYPES": 2,
	}
)

func (x BigQueryTableTypeCollection) Enum() *BigQueryTableTypeCollection {
	p := new(BigQueryTableTypeCollection)
	*p = x
	return p
}

func (x BigQueryTableTypeCollection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryTableTypeCollection) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[3].Descriptor()
}

func (BigQueryTableTypeCollection) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[3]
}

func (x BigQueryTableTypeCollection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryTableTypeCollection.Descriptor instead.
func (BigQueryTableTypeCollection) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{3}
}

// Over time new types may be added. Currently VIEW, MATERIALIZED_VIEW,
// SNAPSHOT, and non-BigLake external tables are not supported.
type BigQueryTableType int32

const (
	// Unused.
	BigQueryTableType_BIG_QUERY_TABLE_TYPE_UNSPECIFIED BigQueryTableType = 0
	// A normal BigQuery table.
	BigQueryTableType_BIG_QUERY_TABLE_TYPE_TABLE BigQueryTableType = 1
	// A table that references data stored in Cloud Storage.
	BigQueryTableType_BIG_QUERY_TABLE_TYPE_EXTERNAL_BIG_LAKE BigQueryTableType = 2
)

// Enum value maps for BigQueryTableType.
var (
	BigQueryTableType_name = map[int32]string{
		0: "BIG_QUERY_TABLE_TYPE_UNSPECIFIED",
		1: "BIG_QUERY_TABLE_TYPE_TABLE",
		2: "BIG_QUERY_TABLE_TYPE_EXTERNAL_BIG_LAKE",
	}
	BigQueryTableType_value = map[string]int32{
		"BIG_QUERY_TABLE_TYPE_UNSPECIFIED":       0,
		"BIG_QUERY_TABLE_TYPE_TABLE":             1,
		"BIG_QUERY_TABLE_TYPE_EXTERNAL_BIG_LAKE": 2,
	}
)

func (x BigQueryTableType) Enum() *BigQueryTableType {
	p := new(BigQueryTableType)
	*p = x
	return p
}

func (x BigQueryTableType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryTableType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[4].Descriptor()
}

func (BigQueryTableType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[4]
}

func (x BigQueryTableType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryTableType.Descriptor instead.
func (BigQueryTableType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4}
}

// How frequently data profiles can be updated. New options can be added at a
// later time.
type DataProfileUpdateFrequency int32

const (
	// Unspecified.
	DataProfileUpdateFrequency_UPDATE_FREQUENCY_UNSPECIFIED DataProfileUpdateFrequency = 0
	// After the data profile is created, it will never be updated.
	DataProfileUpdateFrequency_UPDATE_FREQUENCY_NEVER DataProfileUpdateFrequency = 1
	// The data profile can be updated up to once every 24 hours.
	DataProfileUpdateFrequency_UPDATE_FREQUENCY_DAILY DataProfileUpdateFrequency = 2
	// The data profile can be updated up to once every 30 days. Default.
	DataProfileUpdateFrequency_UPDATE_FREQUENCY_MONTHLY DataProfileUpdateFrequency = 4
)

// Enum value maps for DataProfileUpdateFrequency.
var (
	DataProfileUpdateFrequency_name = map[int32]string{
		0: "UPDATE_FREQUENCY_UNSPECIFIED",
		1: "UPDATE_FREQUENCY_NEVER",
		2: "UPDATE_FREQUENCY_DAILY",
		4: "UPDATE_FREQUENCY_MONTHLY",
	}
	DataProfileUpdateFrequency_value = map[string]int32{
		"UPDATE_FREQUENCY_UNSPECIFIED": 0,
		"UPDATE_FREQUENCY_NEVER":       1,
		"UPDATE_FREQUENCY_DAILY":       2,
		"UPDATE_FREQUENCY_MONTHLY":     4,
	}
)

func (x DataProfileUpdateFrequency) Enum() *DataProfileUpdateFrequency {
	p := new(DataProfileUpdateFrequency)
	*p = x
	return p
}

func (x DataProfileUpdateFrequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfileUpdateFrequency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[5].Descriptor()
}

func (DataProfileUpdateFrequency) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[5]
}

func (x DataProfileUpdateFrequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfileUpdateFrequency.Descriptor instead.
func (DataProfileUpdateFrequency) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5}
}

// Attributes evaluated to determine if a table has been modified. New values
// may be added at a later time.
type BigQueryTableModification int32

const (
	// Unused.
	BigQueryTableModification_TABLE_MODIFICATION_UNSPECIFIED BigQueryTableModification = 0
	// A table will be considered modified when the last_modified_time from
	// BigQuery has been updated.
	BigQueryTableModification_TABLE_MODIFIED_TIMESTAMP BigQueryTableModification = 1
)

// Enum value maps for BigQueryTableModification.
var (
	BigQueryTableModification_name = map[int32]string{
		0: "TABLE_MODIFICATION_UNSPECIFIED",
		1: "TABLE_MODIFIED_TIMESTAMP",
	}
	BigQueryTableModification_value = map[string]int32{
		"TABLE_MODIFICATION_UNSPECIFIED": 0,
		"TABLE_MODIFIED_TIMESTAMP":       1,
	}
)

func (x BigQueryTableModification) Enum() *BigQueryTableModification {
	p := new(BigQueryTableModification)
	*p = x
	return p
}

func (x BigQueryTableModification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryTableModification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[6].Descriptor()
}

func (BigQueryTableModification) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[6]
}

func (x BigQueryTableModification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryTableModification.Descriptor instead.
func (BigQueryTableModification) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{6}
}

// Attributes evaluated to determine if a schema has been modified. New values
// may be added at a later time.
type BigQuerySchemaModification int32

const (
	// Unused
	BigQuerySchemaModification_SCHEMA_MODIFICATION_UNSPECIFIED BigQuerySchemaModification = 0
	// Profiles should be regenerated when new columns are added to the table.
	// Default.
	BigQuerySchemaModification_SCHEMA_NEW_COLUMNS BigQuerySchemaModification = 1
	// Profiles should be regenerated when columns are removed from the table.
	BigQuerySchemaModification_SCHEMA_REMOVED_COLUMNS BigQuerySchemaModification = 2
)

// Enum value maps for BigQuerySchemaModification.
var (
	BigQuerySchemaModification_name = map[int32]string{
		0: "SCHEMA_MODIFICATION_UNSPECIFIED",
		1: "SCHEMA_NEW_COLUMNS",
		2: "SCHEMA_REMOVED_COLUMNS",
	}
	BigQuerySchemaModification_value = map[string]int32{
		"SCHEMA_MODIFICATION_UNSPECIFIED": 0,
		"SCHEMA_NEW_COLUMNS":              1,
		"SCHEMA_REMOVED_COLUMNS":          2,
	}
)

func (x BigQuerySchemaModification) Enum() *BigQuerySchemaModification {
	p := new(BigQuerySchemaModification)
	*p = x
	return p
}

func (x BigQuerySchemaModification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQuerySchemaModification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[7].Descriptor()
}

func (BigQuerySchemaModification) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[7]
}

func (x BigQuerySchemaModification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQuerySchemaModification.Descriptor instead.
func (BigQuerySchemaModification) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{7}
}

// Operators available for comparing the value of fields.
type RelationalOperator int32

const (
	// Unused
	RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED RelationalOperator = 0
	// Equal. Attempts to match even with incompatible types.
	RelationalOperator_EQUAL_TO RelationalOperator = 1
	// Not equal to. Attempts to match even with incompatible types.
	RelationalOperator_NOT_EQUAL_TO RelationalOperator = 2
	// Greater than.
	RelationalOperator_GREATER_THAN RelationalOperator = 3
	// Less than.
	RelationalOperator_LESS_THAN RelationalOperator = 4
	// Greater than or equals.
	RelationalOperator_GREATER_THAN_OR_EQUALS RelationalOperator = 5
	// Less than or equals.
	RelationalOperator_LESS_THAN_OR_EQUALS RelationalOperator = 6
	// Exists
	RelationalOperator_EXISTS RelationalOperator = 7
)

// Enum value maps for RelationalOperator.
var (
	RelationalOperator_name = map[int32]string{
		0: "RELATIONAL_OPERATOR_UNSPECIFIED",
		1: "EQUAL_TO",
		2: "NOT_EQUAL_TO",
		3: "GREATER_THAN",
		4: "LESS_THAN",
		5: "GREATER_THAN_OR_EQUALS",
		6: "LESS_THAN_OR_EQUALS",
		7: "EXISTS",
	}
	RelationalOperator_value = map[string]int32{
		"RELATIONAL_OPERATOR_UNSPECIFIED": 0,
		"EQUAL_TO":                        1,
		"NOT_EQUAL_TO":                    2,
		"GREATER_THAN":                    3,
		"LESS_THAN":                       4,
		"GREATER_THAN_OR_EQUALS":          5,
		"LESS_THAN_OR_EQUALS":             6,
		"EXISTS":                          7,
	}
)

func (x RelationalOperator) Enum() *RelationalOperator {
	p := new(RelationalOperator)
	*p = x
	return p
}

func (x RelationalOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelationalOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[8].Descriptor()
}

func (RelationalOperator) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[8]
}

func (x RelationalOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelationalOperator.Descriptor instead.
func (RelationalOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{8}
}

// Type of the match which can be applied to different ways of matching, like
// Dictionary, regular expression and intersecting with findings of another
// info type.
type MatchingType int32

const (
	// Invalid.
	MatchingType_MATCHING_TYPE_UNSPECIFIED MatchingType = 0
	// Full match.
	//
	// - Dictionary: join of Dictionary results matched complete finding quote
	// - Regex: all regex matches fill a finding quote start to end
	// - Exclude info type: completely inside affecting info types findings
	MatchingType_MATCHING_TYPE_FULL_MATCH MatchingType = 1
	// Partial match.
	//
	// - Dictionary: at least one of the tokens in the finding matches
	// - Regex: substring of the finding matches
	// - Exclude info type: intersects with affecting info types findings
	MatchingType_MATCHING_TYPE_PARTIAL_MATCH MatchingType = 2
	// Inverse match.
	//
	// - Dictionary: no tokens in the finding match the dictionary
	// - Regex: finding doesn't match the regex
	// - Exclude info type: no intersection with affecting info types findings
	MatchingType_MATCHING_TYPE_INVERSE_MATCH MatchingType = 3
)

// Enum value maps for MatchingType.
var (
	MatchingType_name = map[int32]string{
		0: "MATCHING_TYPE_UNSPECIFIED",
		1: "MATCHING_TYPE_FULL_MATCH",
		2: "MATCHING_TYPE_PARTIAL_MATCH",
		3: "MATCHING_TYPE_INVERSE_MATCH",
	}
	MatchingType_value = map[string]int32{
		"MATCHING_TYPE_UNSPECIFIED":   0,
		"MATCHING_TYPE_FULL_MATCH":    1,
		"MATCHING_TYPE_PARTIAL_MATCH": 2,
		"MATCHING_TYPE_INVERSE_MATCH": 3,
	}
)

func (x MatchingType) Enum() *MatchingType {
	p := new(MatchingType)
	*p = x
	return p
}

func (x MatchingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MatchingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[9].Descriptor()
}

func (MatchingType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[9]
}

func (x MatchingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MatchingType.Descriptor instead.
func (MatchingType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{9}
}

// Deprecated and unused.
type ContentOption int32

const (
	// Includes entire content of a file or a data stream.
	ContentOption_CONTENT_UNSPECIFIED ContentOption = 0
	// Text content within the data, excluding any metadata.
	ContentOption_CONTENT_TEXT ContentOption = 1
	// Images found in the data.
	ContentOption_CONTENT_IMAGE ContentOption = 2
)

// Enum value maps for ContentOption.
var (
	ContentOption_name = map[int32]string{
		0: "CONTENT_UNSPECIFIED",
		1: "CONTENT_TEXT",
		2: "CONTENT_IMAGE",
	}
	ContentOption_value = map[string]int32{
		"CONTENT_UNSPECIFIED": 0,
		"CONTENT_TEXT":        1,
		"CONTENT_IMAGE":       2,
	}
)

func (x ContentOption) Enum() *ContentOption {
	p := new(ContentOption)
	*p = x
	return p
}

func (x ContentOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[10].Descriptor()
}

func (ContentOption) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[10]
}

func (x ContentOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentOption.Descriptor instead.
func (ContentOption) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{10}
}

// Type of metadata containing the finding.
type MetadataType int32

const (
	// Unused
	MetadataType_METADATATYPE_UNSPECIFIED MetadataType = 0
	// General file metadata provided by Cloud Storage.
	MetadataType_STORAGE_METADATA MetadataType = 2
)

// Enum value maps for MetadataType.
var (
	MetadataType_name = map[int32]string{
		0: "METADATATYPE_UNSPECIFIED",
		2: "STORAGE_METADATA",
	}
	MetadataType_value = map[string]int32{
		"METADATATYPE_UNSPECIFIED": 0,
		"STORAGE_METADATA":         2,
	}
)

func (x MetadataType) Enum() *MetadataType {
	p := new(MetadataType)
	*p = x
	return p
}

func (x MetadataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[11].Descriptor()
}

func (MetadataType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[11]
}

func (x MetadataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataType.Descriptor instead.
func (MetadataType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{11}
}

// Parts of the APIs which use certain infoTypes.
type InfoTypeSupportedBy int32

const (
	// Unused.
	InfoTypeSupportedBy_ENUM_TYPE_UNSPECIFIED InfoTypeSupportedBy = 0
	// Supported by the inspect operations.
	InfoTypeSupportedBy_INSPECT InfoTypeSupportedBy = 1
	// Supported by the risk analysis operations.
	InfoTypeSupportedBy_RISK_ANALYSIS InfoTypeSupportedBy = 2
)

// Enum value maps for InfoTypeSupportedBy.
var (
	InfoTypeSupportedBy_name = map[int32]string{
		0: "ENUM_TYPE_UNSPECIFIED",
		1: "INSPECT",
		2: "RISK_ANALYSIS",
	}
	InfoTypeSupportedBy_value = map[string]int32{
		"ENUM_TYPE_UNSPECIFIED": 0,
		"INSPECT":               1,
		"RISK_ANALYSIS":         2,
	}
)

func (x InfoTypeSupportedBy) Enum() *InfoTypeSupportedBy {
	p := new(InfoTypeSupportedBy)
	*p = x
	return p
}

func (x InfoTypeSupportedBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoTypeSupportedBy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[12].Descriptor()
}

func (InfoTypeSupportedBy) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[12]
}

func (x InfoTypeSupportedBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoTypeSupportedBy.Descriptor instead.
func (InfoTypeSupportedBy) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{12}
}

// An enum to represent the various types of DLP jobs.
type DlpJobType int32

const (
	// Defaults to INSPECT_JOB.
	DlpJobType_DLP_JOB_TYPE_UNSPECIFIED DlpJobType = 0
	// The job inspected Google Cloud for sensitive data.
	DlpJobType_INSPECT_JOB DlpJobType = 1
	// The job executed a Risk Analysis computation.
	DlpJobType_RISK_ANALYSIS_JOB DlpJobType = 2
)

// Enum value maps for DlpJobType.
var (
	DlpJobType_name = map[int32]string{
		0: "DLP_JOB_TYPE_UNSPECIFIED",
		1: "INSPECT_JOB",
		2: "RISK_ANALYSIS_JOB",
	}
	DlpJobType_value = map[string]int32{
		"DLP_JOB_TYPE_UNSPECIFIED": 0,
		"INSPECT_JOB":              1,
		"RISK_ANALYSIS_JOB":        2,
	}
)

func (x DlpJobType) Enum() *DlpJobType {
	p := new(DlpJobType)
	*p = x
	return p
}

func (x DlpJobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DlpJobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[13].Descriptor()
}

func (DlpJobType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[13]
}

func (x DlpJobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DlpJobType.Descriptor instead.
func (DlpJobType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{13}
}

// State of a StoredInfoType version.
type StoredInfoTypeState int32

const (
	// Unused
	StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED StoredInfoTypeState = 0
	// StoredInfoType version is being created.
	StoredInfoTypeState_PENDING StoredInfoTypeState = 1
	// StoredInfoType version is ready for use.
	StoredInfoTypeState_READY StoredInfoTypeState = 2
	// StoredInfoType creation failed. All relevant error messages are returned in
	// the `StoredInfoTypeVersion` message.
	StoredInfoTypeState_FAILED StoredInfoTypeState = 3
	// StoredInfoType is no longer valid because artifacts stored in
	// user-controlled storage were modified. To fix an invalid StoredInfoType,
	// use the `UpdateStoredInfoType` method to create a new version.
	StoredInfoTypeState_INVALID StoredInfoTypeState = 4
)

// Enum value maps for StoredInfoTypeState.
var (
	StoredInfoTypeState_name = map[int32]string{
		0: "STORED_INFO_TYPE_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "READY",
		3: "FAILED",
		4: "INVALID",
	}
	StoredInfoTypeState_value = map[string]int32{
		"STORED_INFO_TYPE_STATE_UNSPECIFIED": 0,
		"PENDING":                            1,
		"READY":                              2,
		"FAILED":                             3,
		"INVALID":                            4,
	}
)

func (x StoredInfoTypeState) Enum() *StoredInfoTypeState {
	p := new(StoredInfoTypeState)
	*p = x
	return p
}

func (x StoredInfoTypeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoredInfoTypeState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[14].Descriptor()
}

func (StoredInfoTypeState) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[14]
}

func (x StoredInfoTypeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoredInfoTypeState.Descriptor instead.
func (StoredInfoTypeState) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{14}
}

// How broadly the data in the resource has been shared. New items may be added
// over time. A higher number means more restricted.
type ResourceVisibility int32

const (
	// Unused.
	ResourceVisibility_RESOURCE_VISIBILITY_UNSPECIFIED ResourceVisibility = 0
	// Visible to any user.
	ResourceVisibility_RESOURCE_VISIBILITY_PUBLIC ResourceVisibility = 10
	// Visible only to specific users.
	ResourceVisibility_RESOURCE_VISIBILITY_RESTRICTED ResourceVisibility = 20
)

// Enum value maps for ResourceVisibility.
var (
	ResourceVisibility_name = map[int32]string{
		0:  "RESOURCE_VISIBILITY_UNSPECIFIED",
		10: "RESOURCE_VISIBILITY_PUBLIC",
		20: "RESOURCE_VISIBILITY_RESTRICTED",
	}
	ResourceVisibility_value = map[string]int32{
		"RESOURCE_VISIBILITY_UNSPECIFIED": 0,
		"RESOURCE_VISIBILITY_PUBLIC":      10,
		"RESOURCE_VISIBILITY_RESTRICTED":  20,
	}
)

func (x ResourceVisibility) Enum() *ResourceVisibility {
	p := new(ResourceVisibility)
	*p = x
	return p
}

func (x ResourceVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[15].Descriptor()
}

func (ResourceVisibility) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[15]
}

func (x ResourceVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceVisibility.Descriptor instead.
func (ResourceVisibility) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{15}
}

// How a resource is encrypted.
type EncryptionStatus int32

const (
	// Unused.
	EncryptionStatus_ENCRYPTION_STATUS_UNSPECIFIED EncryptionStatus = 0
	// Google manages server-side encryption keys on your behalf.
	EncryptionStatus_ENCRYPTION_GOOGLE_MANAGED EncryptionStatus = 1
	// Customer provides the key.
	EncryptionStatus_ENCRYPTION_CUSTOMER_MANAGED EncryptionStatus = 2
)

// Enum value maps for EncryptionStatus.
var (
	EncryptionStatus_name = map[int32]string{
		0: "ENCRYPTION_STATUS_UNSPECIFIED",
		1: "ENCRYPTION_GOOGLE_MANAGED",
		2: "ENCRYPTION_CUSTOMER_MANAGED",
	}
	EncryptionStatus_value = map[string]int32{
		"ENCRYPTION_STATUS_UNSPECIFIED": 0,
		"ENCRYPTION_GOOGLE_MANAGED":     1,
		"ENCRYPTION_CUSTOMER_MANAGED":   2,
	}
)

func (x EncryptionStatus) Enum() *EncryptionStatus {
	p := new(EncryptionStatus)
	*p = x
	return p
}

func (x EncryptionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[16].Descriptor()
}

func (EncryptionStatus) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[16]
}

func (x EncryptionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionStatus.Descriptor instead.
func (EncryptionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{16}
}

// Bucketized nullness percentage levels. A higher level means a higher
// percentage of the column is null.
type NullPercentageLevel int32

const (
	// Unused.
	NullPercentageLevel_NULL_PERCENTAGE_LEVEL_UNSPECIFIED NullPercentageLevel = 0
	// Very few null entries.
	NullPercentageLevel_NULL_PERCENTAGE_VERY_LOW NullPercentageLevel = 1
	// Some null entries.
	NullPercentageLevel_NULL_PERCENTAGE_LOW NullPercentageLevel = 2
	// A few null entries.
	NullPercentageLevel_NULL_PERCENTAGE_MEDIUM NullPercentageLevel = 3
	// A lot of null entries.
	NullPercentageLevel_NULL_PERCENTAGE_HIGH NullPercentageLevel = 4
)

// Enum value maps for NullPercentageLevel.
var (
	NullPercentageLevel_name = map[int32]string{
		0: "NULL_PERCENTAGE_LEVEL_UNSPECIFIED",
		1: "NULL_PERCENTAGE_VERY_LOW",
		2: "NULL_PERCENTAGE_LOW",
		3: "NULL_PERCENTAGE_MEDIUM",
		4: "NULL_PERCENTAGE_HIGH",
	}
	NullPercentageLevel_value = map[string]int32{
		"NULL_PERCENTAGE_LEVEL_UNSPECIFIED": 0,
		"NULL_PERCENTAGE_VERY_LOW":          1,
		"NULL_PERCENTAGE_LOW":               2,
		"NULL_PERCENTAGE_MEDIUM":            3,
		"NULL_PERCENTAGE_HIGH":              4,
	}
)

func (x NullPercentageLevel) Enum() *NullPercentageLevel {
	p := new(NullPercentageLevel)
	*p = x
	return p
}

func (x NullPercentageLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NullPercentageLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[17].Descriptor()
}

func (NullPercentageLevel) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[17]
}

func (x NullPercentageLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NullPercentageLevel.Descriptor instead.
func (NullPercentageLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{17}
}

// Bucketized uniqueness score levels. A higher uniqueness score is a strong
// signal that the column may contain a unique identifier like user id. A low
// value indicates that the column contains few unique values like booleans or
// other classifiers.
type UniquenessScoreLevel int32

const (
	// Some columns do not have estimated uniqueness. Possible reasons include
	// having too few values.
	UniquenessScoreLevel_UNIQUENESS_SCORE_LEVEL_UNSPECIFIED UniquenessScoreLevel = 0
	// Low uniqueness, possibly a boolean, enum or similiarly typed column.
	UniquenessScoreLevel_UNIQUENESS_SCORE_LOW UniquenessScoreLevel = 1
	// Medium uniqueness.
	UniquenessScoreLevel_UNIQUENESS_SCORE_MEDIUM UniquenessScoreLevel = 2
	// High uniqueness, possibly a column of free text or unique identifiers.
	UniquenessScoreLevel_UNIQUENESS_SCORE_HIGH UniquenessScoreLevel = 3
)

// Enum value maps for UniquenessScoreLevel.
var (
	UniquenessScoreLevel_name = map[int32]string{
		0: "UNIQUENESS_SCORE_LEVEL_UNSPECIFIED",
		1: "UNIQUENESS_SCORE_LOW",
		2: "UNIQUENESS_SCORE_MEDIUM",
		3: "UNIQUENESS_SCORE_HIGH",
	}
	UniquenessScoreLevel_value = map[string]int32{
		"UNIQUENESS_SCORE_LEVEL_UNSPECIFIED": 0,
		"UNIQUENESS_SCORE_LOW":               1,
		"UNIQUENESS_SCORE_MEDIUM":            2,
		"UNIQUENESS_SCORE_HIGH":              3,
	}
)

func (x UniquenessScoreLevel) Enum() *UniquenessScoreLevel {
	p := new(UniquenessScoreLevel)
	*p = x
	return p
}

func (x UniquenessScoreLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UniquenessScoreLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[18].Descriptor()
}

func (UniquenessScoreLevel) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[18]
}

func (x UniquenessScoreLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UniquenessScoreLevel.Descriptor instead.
func (UniquenessScoreLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{18}
}

// The type of data being sent for inspection. To learn more, see
// [Supported file
// types](https://cloud.google.com/sensitive-data-protection/docs/supported-file-types).
type ByteContentItem_BytesType int32

const (
	// Unused
	ByteContentItem_BYTES_TYPE_UNSPECIFIED ByteContentItem_BytesType = 0
	// Any image type.
	ByteContentItem_IMAGE ByteContentItem_BytesType = 6
	// jpeg
	ByteContentItem_IMAGE_JPEG ByteContentItem_BytesType = 1
	// bmp
	ByteContentItem_IMAGE_BMP ByteContentItem_BytesType = 2
	// png
	ByteContentItem_IMAGE_PNG ByteContentItem_BytesType = 3
	// svg
	ByteContentItem_IMAGE_SVG ByteContentItem_BytesType = 4
	// plain text
	ByteContentItem_TEXT_UTF8 ByteContentItem_BytesType = 5
	// docx, docm, dotx, dotm
	ByteContentItem_WORD_DOCUMENT ByteContentItem_BytesType = 7
	// pdf
	ByteContentItem_PDF ByteContentItem_BytesType = 8
	// pptx, pptm, potx, potm, pot
	ByteContentItem_POWERPOINT_DOCUMENT ByteContentItem_BytesType = 9
	// xlsx, xlsm, xltx, xltm
	ByteContentItem_EXCEL_DOCUMENT ByteContentItem_BytesType = 10
	// avro
	ByteContentItem_AVRO ByteContentItem_BytesType = 11
	// csv
	ByteContentItem_CSV ByteContentItem_BytesType = 12
	// tsv
	ByteContentItem_TSV ByteContentItem_BytesType = 13
)

// Enum value maps for ByteContentItem_BytesType.
var (
	ByteContentItem_BytesType_name = map[int32]string{
		0:  "BYTES_TYPE_UNSPECIFIED",
		6:  "IMAGE",
		1:  "IMAGE_JPEG",
		2:  "IMAGE_BMP",
		3:  "IMAGE_PNG",
		4:  "IMAGE_SVG",
		5:  "TEXT_UTF8",
		7:  "WORD_DOCUMENT",
		8:  "PDF",
		9:  "POWERPOINT_DOCUMENT",
		10: "EXCEL_DOCUMENT",
		11: "AVRO",
		12: "CSV",
		13: "TSV",
	}
	ByteContentItem_BytesType_value = map[string]int32{
		"BYTES_TYPE_UNSPECIFIED": 0,
		"IMAGE":                  6,
		"IMAGE_JPEG":             1,
		"IMAGE_BMP":              2,
		"IMAGE_PNG":              3,
		"IMAGE_SVG":              4,
		"TEXT_UTF8":              5,
		"WORD_DOCUMENT":          7,
		"PDF":                    8,
		"POWERPOINT_DOCUMENT":    9,
		"EXCEL_DOCUMENT":         10,
		"AVRO":                   11,
		"CSV":                    12,
		"TSV":                    13,
	}
)

func (x ByteContentItem_BytesType) Enum() *ByteContentItem_BytesType {
	p := new(ByteContentItem_BytesType)
	*p = x
	return p
}

func (x ByteContentItem_BytesType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ByteContentItem_BytesType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[19].Descriptor()
}

func (ByteContentItem_BytesType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[19]
}

func (x ByteContentItem_BytesType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ByteContentItem_BytesType.Descriptor instead.
func (ByteContentItem_BytesType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{6, 0}
}

// Predefined schemas for storing findings.
// Only for use with external storage.
type OutputStorageConfig_OutputSchema int32

const (
	// Unused.
	OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED OutputStorageConfig_OutputSchema = 0
	// Basic schema including only `info_type`, `quote`, `certainty`, and
	// `timestamp`.
	OutputStorageConfig_BASIC_COLUMNS OutputStorageConfig_OutputSchema = 1
	// Schema tailored to findings from scanning Cloud Storage.
	OutputStorageConfig_GCS_COLUMNS OutputStorageConfig_OutputSchema = 2
	// Schema tailored to findings from scanning Google Datastore.
	OutputStorageConfig_DATASTORE_COLUMNS OutputStorageConfig_OutputSchema = 3
	// Schema tailored to findings from scanning Google BigQuery.
	OutputStorageConfig_BIG_QUERY_COLUMNS OutputStorageConfig_OutputSchema = 4
	// Schema containing all columns.
	OutputStorageConfig_ALL_COLUMNS OutputStorageConfig_OutputSchema = 5
)

// Enum value maps for OutputStorageConfig_OutputSchema.
var (
	OutputStorageConfig_OutputSchema_name = map[int32]string{
		0: "OUTPUT_SCHEMA_UNSPECIFIED",
		1: "BASIC_COLUMNS",
		2: "GCS_COLUMNS",
		3: "DATASTORE_COLUMNS",
		4: "BIG_QUERY_COLUMNS",
		5: "ALL_COLUMNS",
	}
	OutputStorageConfig_OutputSchema_value = map[string]int32{
		"OUTPUT_SCHEMA_UNSPECIFIED": 0,
		"BASIC_COLUMNS":             1,
		"GCS_COLUMNS":               2,
		"DATASTORE_COLUMNS":         3,
		"BIG_QUERY_COLUMNS":         4,
		"ALL_COLUMNS":               5,
	}
)

func (x OutputStorageConfig_OutputSchema) Enum() *OutputStorageConfig_OutputSchema {
	p := new(OutputStorageConfig_OutputSchema)
	*p = x
	return p
}

func (x OutputStorageConfig_OutputSchema) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputStorageConfig_OutputSchema) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[20].Descriptor()
}

func (OutputStorageConfig_OutputSchema) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[20]
}

func (x OutputStorageConfig_OutputSchema) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputStorageConfig_OutputSchema.Descriptor instead.
func (OutputStorageConfig_OutputSchema) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{31, 0}
}

// Enum of the current locations.
// We might add more locations in the future.
type InfoTypeCategory_LocationCategory int32

const (
	// Unused location
	InfoTypeCategory_LOCATION_UNSPECIFIED InfoTypeCategory_LocationCategory = 0
	// The infoType is not issued by or tied to a specific region, but is used
	// almost everywhere.
	InfoTypeCategory_GLOBAL InfoTypeCategory_LocationCategory = 1
	// The infoType is typically used in Argentina.
	InfoTypeCategory_ARGENTINA InfoTypeCategory_LocationCategory = 2
	// The infoType is typically used in Australia.
	InfoTypeCategory_AUSTRALIA InfoTypeCategory_LocationCategory = 3
	// The infoType is typically used in Belgium.
	InfoTypeCategory_BELGIUM InfoTypeCategory_LocationCategory = 4
	// The infoType is typically used in Brazil.
	InfoTypeCategory_BRAZIL InfoTypeCategory_LocationCategory = 5
	// The infoType is typically used in Canada.
	InfoTypeCategory_CANADA InfoTypeCategory_LocationCategory = 6
	// The infoType is typically used in Chile.
	InfoTypeCategory_CHILE InfoTypeCategory_LocationCategory = 7
	// The infoType is typically used in China.
	InfoTypeCategory_CHINA InfoTypeCategory_LocationCategory = 8
	// The infoType is typically used in Colombia.
	InfoTypeCategory_COLOMBIA InfoTypeCategory_LocationCategory = 9
	// The infoType is typically used in Croatia.
	InfoTypeCategory_CROATIA InfoTypeCategory_LocationCategory = 42
	// The infoType is typically used in Denmark.
	InfoTypeCategory_DENMARK InfoTypeCategory_LocationCategory = 10
	// The infoType is typically used in France.
	InfoTypeCategory_FRANCE InfoTypeCategory_LocationCategory = 11
	// The infoType is typically used in Finland.
	InfoTypeCategory_FINLAND InfoTypeCategory_LocationCategory = 12
	// The infoType is typically used in Germany.
	InfoTypeCategory_GERMANY InfoTypeCategory_LocationCategory = 13
	// The infoType is typically used in Hong Kong.
	InfoTypeCategory_HONG_KONG InfoTypeCategory_LocationCategory = 14
	// The infoType is typically used in India.
	InfoTypeCategory_INDIA InfoTypeCategory_LocationCategory = 15
	// The infoType is typically used in Indonesia.
	InfoTypeCategory_INDONESIA InfoTypeCategory_LocationCategory = 16
	// The infoType is typically used in Ireland.
	InfoTypeCategory_IRELAND InfoTypeCategory_LocationCategory = 17
	// The infoType is typically used in Israel.
	InfoTypeCategory_ISRAEL InfoTypeCategory_LocationCategory = 18
	// The infoType is typically used in Italy.
	InfoTypeCategory_ITALY InfoTypeCategory_LocationCategory = 19
	// The infoType is typically used in Japan.
	InfoTypeCategory_JAPAN InfoTypeCategory_LocationCategory = 20
	// The infoType is typically used in Korea.
	InfoTypeCategory_KOREA InfoTypeCategory_LocationCategory = 21
	// The infoType is typically used in Mexico.
	InfoTypeCategory_MEXICO InfoTypeCategory_LocationCategory = 22
	// The infoType is typically used in the Netherlands.
	InfoTypeCategory_THE_NETHERLANDS InfoTypeCategory_LocationCategory = 23
	// The infoType is typically used in New Zealand.
	InfoTypeCategory_NEW_ZEALAND InfoTypeCategory_LocationCategory = 41
	// The infoType is typically used in Norway.
	InfoTypeCategory_NORWAY InfoTypeCategory_LocationCategory = 24
	// The infoType is typically used in Paraguay.
	InfoTypeCategory_PARAGUAY InfoTypeCategory_LocationCategory = 25
	// The infoType is typically used in Peru.
	InfoTypeCategory_PERU InfoTypeCategory_LocationCategory = 26
	// The infoType is typically used in Poland.
	InfoTypeCategory_POLAND InfoTypeCategory_LocationCategory = 27
	// The infoType is typically used in Portugal.
	InfoTypeCategory_PORTUGAL InfoTypeCategory_LocationCategory = 28
	// The infoType is typically used in Singapore.
	InfoTypeCategory_SINGAPORE InfoTypeCategory_LocationCategory = 29
	// The infoType is typically used in South Africa.
	InfoTypeCategory_SOUTH_AFRICA InfoTypeCategory_LocationCategory = 30
	// The infoType is typically used in Spain.
	InfoTypeCategory_SPAIN InfoTypeCategory_LocationCategory = 31
	// The infoType is typically used in Sweden.
	InfoTypeCategory_SWEDEN InfoTypeCategory_LocationCategory = 32
	// The infoType is typically used in Switzerland.
	InfoTypeCategory_SWITZERLAND InfoTypeCategory_LocationCategory = 43
	// The infoType is typically used in Taiwan.
	InfoTypeCategory_TAIWAN InfoTypeCategory_LocationCategory = 33
	// The infoType is typically used in Thailand.
	InfoTypeCategory_THAILAND InfoTypeCategory_LocationCategory = 34
	// The infoType is typically used in Turkey.
	InfoTypeCategory_TURKEY InfoTypeCategory_LocationCategory = 35
	// The infoType is typically used in the United Kingdom.
	InfoTypeCategory_UNITED_KINGDOM InfoTypeCategory_LocationCategory = 36
	// The infoType is typically used in the United States.
	InfoTypeCategory_UNITED_STATES InfoTypeCategory_LocationCategory = 37
	// The infoType is typically used in Uruguay.
	InfoTypeCategory_URUGUAY InfoTypeCategory_LocationCategory = 38
	// The infoType is typically used in Venezuela.
	InfoTypeCategory_VENEZUELA InfoTypeCategory_LocationCategory = 39
	// The infoType is typically used in Google internally.
	InfoTypeCategory_INTERNAL InfoTypeCategory_LocationCategory = 40
)

// Enum value maps for InfoTypeCategory_LocationCategory.
var (
	InfoTypeCategory_LocationCategory_name = map[int32]string{
		0:  "LOCATION_UNSPECIFIED",
		1:  "GLOBAL",
		2:  "ARGENTINA",
		3:  "AUSTRALIA",
		4:  "BELGIUM",
		5:  "BRAZIL",
		6:  "CANADA",
		7:  "CHILE",
		8:  "CHINA",
		9:  "COLOMBIA",
		42: "CROATIA",
		10: "DENMARK",
		11: "FRANCE",
		12: "FINLAND",
		13: "GERMANY",
		14: "HONG_KONG",
		15: "INDIA",
		16: "INDONESIA",
		17: "IRELAND",
		18: "ISRAEL",
		19: "ITALY",
		20: "JAPAN",
		21: "KOREA",
		22: "MEXICO",
		23: "THE_NETHERLANDS",
		41: "NEW_ZEALAND",
		24: "NORWAY",
		25: "PARAGUAY",
		26: "PERU",
		27: "POLAND",
		28: "PORTUGAL",
		29: "SINGAPORE",
		30: "SOUTH_AFRICA",
		31: "SPAIN",
		32: "SWEDEN",
		43: "SWITZERLAND",
		33: "TAIWAN",
		34: "THAILAND",
		35: "TURKEY",
		36: "UNITED_KINGDOM",
		37: "UNITED_STATES",
		38: "URUGUAY",
		39: "VENEZUELA",
		40: "INTERNAL",
	}
	InfoTypeCategory_LocationCategory_value = map[string]int32{
		"LOCATION_UNSPECIFIED": 0,
		"GLOBAL":               1,
		"ARGENTINA":            2,
		"AUSTRALIA":            3,
		"BELGIUM":              4,
		"BRAZIL":               5,
		"CANADA":               6,
		"CHILE":                7,
		"CHINA":                8,
		"COLOMBIA":             9,
		"CROATIA":              42,
		"DENMARK":              10,
		"FRANCE":               11,
		"FINLAND":              12,
		"GERMANY":              13,
		"HONG_KONG":            14,
		"INDIA":                15,
		"INDONESIA":            16,
		"IRELAND":              17,
		"ISRAEL":               18,
		"ITALY":                19,
		"JAPAN":                20,
		"KOREA":                21,
		"MEXICO":               22,
		"THE_NETHERLANDS":      23,
		"NEW_ZEALAND":          41,
		"NORWAY":               24,
		"PARAGUAY":             25,
		"PERU":                 26,
		"POLAND":               27,
		"PORTUGAL":             28,
		"SINGAPORE":            29,
		"SOUTH_AFRICA":         30,
		"SPAIN":                31,
		"SWEDEN":               32,
		"SWITZERLAND":          43,
		"TAIWAN":               33,
		"THAILAND":             34,
		"TURKEY":               35,
		"UNITED_KINGDOM":       36,
		"UNITED_STATES":        37,
		"URUGUAY":              38,
		"VENEZUELA":            39,
		"INTERNAL":             40,
	}
)

func (x InfoTypeCategory_LocationCategory) Enum() *InfoTypeCategory_LocationCategory {
	p := new(InfoTypeCategory_LocationCategory)
	*p = x
	return p
}

func (x InfoTypeCategory_LocationCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoTypeCategory_LocationCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[21].Descriptor()
}

func (InfoTypeCategory_LocationCategory) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[21]
}

func (x InfoTypeCategory_LocationCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoTypeCategory_LocationCategory.Descriptor instead.
func (InfoTypeCategory_LocationCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 0}
}

// Enum of the current industries in the category.
// We might add more industries in the future.
type InfoTypeCategory_IndustryCategory int32

const (
	// Unused industry
	InfoTypeCategory_INDUSTRY_UNSPECIFIED InfoTypeCategory_IndustryCategory = 0
	// The infoType is typically used in the finance industry.
	InfoTypeCategory_FINANCE InfoTypeCategory_IndustryCategory = 1
	// The infoType is typically used in the health industry.
	InfoTypeCategory_HEALTH InfoTypeCategory_IndustryCategory = 2
	// The infoType is typically used in the telecommunications industry.
	InfoTypeCategory_TELECOMMUNICATIONS InfoTypeCategory_IndustryCategory = 3
)

// Enum value maps for InfoTypeCategory_IndustryCategory.
var (
	InfoTypeCategory_IndustryCategory_name = map[int32]string{
		0: "INDUSTRY_UNSPECIFIED",
		1: "FINANCE",
		2: "HEALTH",
		3: "TELECOMMUNICATIONS",
	}
	InfoTypeCategory_IndustryCategory_value = map[string]int32{
		"INDUSTRY_UNSPECIFIED": 0,
		"FINANCE":              1,
		"HEALTH":               2,
		"TELECOMMUNICATIONS":   3,
	}
)

func (x InfoTypeCategory_IndustryCategory) Enum() *InfoTypeCategory_IndustryCategory {
	p := new(InfoTypeCategory_IndustryCategory)
	*p = x
	return p
}

func (x InfoTypeCategory_IndustryCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoTypeCategory_IndustryCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[22].Descriptor()
}

func (InfoTypeCategory_IndustryCategory) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[22]
}

func (x InfoTypeCategory_IndustryCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoTypeCategory_IndustryCategory.Descriptor instead.
func (InfoTypeCategory_IndustryCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 1}
}

// Enum of the current types in the category.
// We might add more types in the future.
type InfoTypeCategory_TypeCategory int32

const (
	// Unused type
	InfoTypeCategory_TYPE_UNSPECIFIED InfoTypeCategory_TypeCategory = 0
	// Personally identifiable information, for example, a
	// name or phone number
	InfoTypeCategory_PII InfoTypeCategory_TypeCategory = 1
	// Personally identifiable information that is especially sensitive, for
	// example, a passport number.
	InfoTypeCategory_SPII InfoTypeCategory_TypeCategory = 2
	// Attributes that can partially identify someone, especially in
	// combination with other attributes, like age, height, and gender.
	InfoTypeCategory_DEMOGRAPHIC InfoTypeCategory_TypeCategory = 3
	// Confidential or secret information, for example, a password.
	InfoTypeCategory_CREDENTIAL InfoTypeCategory_TypeCategory = 4
	// An identification document issued by a government.
	InfoTypeCategory_GOVERNMENT_ID InfoTypeCategory_TypeCategory = 5
	// A document, for example, a resume or source code.
	InfoTypeCategory_DOCUMENT InfoTypeCategory_TypeCategory = 6
	// Information that is not sensitive on its own, but provides details about
	// the circumstances surrounding an entity or an event.
	InfoTypeCategory_CONTEXTUAL_INFORMATION InfoTypeCategory_TypeCategory = 7
)

// Enum value maps for InfoTypeCategory_TypeCategory.
var (
	InfoTypeCategory_TypeCategory_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PII",
		2: "SPII",
		3: "DEMOGRAPHIC",
		4: "CREDENTIAL",
		5: "GOVERNMENT_ID",
		6: "DOCUMENT",
		7: "CONTEXTUAL_INFORMATION",
	}
	InfoTypeCategory_TypeCategory_value = map[string]int32{
		"TYPE_UNSPECIFIED":       0,
		"PII":                    1,
		"SPII":                   2,
		"DEMOGRAPHIC":            3,
		"CREDENTIAL":             4,
		"GOVERNMENT_ID":          5,
		"DOCUMENT":               6,
		"CONTEXTUAL_INFORMATION": 7,
	}
)

func (x InfoTypeCategory_TypeCategory) Enum() *InfoTypeCategory_TypeCategory {
	p := new(InfoTypeCategory_TypeCategory)
	*p = x
	return p
}

func (x InfoTypeCategory_TypeCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoTypeCategory_TypeCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[23].Descriptor()
}

func (InfoTypeCategory_TypeCategory) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[23]
}

func (x InfoTypeCategory_TypeCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoTypeCategory_TypeCategory.Descriptor instead.
func (InfoTypeCategory_TypeCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 2}
}

// Components that make up time.
type TimePartConfig_TimePart int32

const (
	// Unused
	TimePartConfig_TIME_PART_UNSPECIFIED TimePartConfig_TimePart = 0
	// [0-9999]
	TimePartConfig_YEAR TimePartConfig_TimePart = 1
	// [1-12]
	TimePartConfig_MONTH TimePartConfig_TimePart = 2
	// [1-31]
	TimePartConfig_DAY_OF_MONTH TimePartConfig_TimePart = 3
	// [1-7]
	TimePartConfig_DAY_OF_WEEK TimePartConfig_TimePart = 4
	// [1-53]
	TimePartConfig_WEEK_OF_YEAR TimePartConfig_TimePart = 5
	// [0-23]
	TimePartConfig_HOUR_OF_DAY TimePartConfig_TimePart = 6
)

// Enum value maps for TimePartConfig_TimePart.
var (
	TimePartConfig_TimePart_name = map[int32]string{
		0: "TIME_PART_UNSPECIFIED",
		1: "YEAR",
		2: "MONTH",
		3: "DAY_OF_MONTH",
		4: "DAY_OF_WEEK",
		5: "WEEK_OF_YEAR",
		6: "HOUR_OF_DAY",
	}
	TimePartConfig_TimePart_value = map[string]int32{
		"TIME_PART_UNSPECIFIED": 0,
		"YEAR":                  1,
		"MONTH":                 2,
		"DAY_OF_MONTH":          3,
		"DAY_OF_WEEK":           4,
		"WEEK_OF_YEAR":          5,
		"HOUR_OF_DAY":           6,
	}
)

func (x TimePartConfig_TimePart) Enum() *TimePartConfig_TimePart {
	p := new(TimePartConfig_TimePart)
	*p = x
	return p
}

func (x TimePartConfig_TimePart) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimePartConfig_TimePart) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[24].Descriptor()
}

func (TimePartConfig_TimePart) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[24]
}

func (x TimePartConfig_TimePart) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimePartConfig_TimePart.Descriptor instead.
func (TimePartConfig_TimePart) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{57, 0}
}

// Convenience enum for indicating common characters to not transform.
type CharsToIgnore_CommonCharsToIgnore int32

const (
	// Unused.
	CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED CharsToIgnore_CommonCharsToIgnore = 0
	// 0-9
	CharsToIgnore_NUMERIC CharsToIgnore_CommonCharsToIgnore = 1
	// A-Z
	CharsToIgnore_ALPHA_UPPER_CASE CharsToIgnore_CommonCharsToIgnore = 2
	// a-z
	CharsToIgnore_ALPHA_LOWER_CASE CharsToIgnore_CommonCharsToIgnore = 3
	// US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
	CharsToIgnore_PUNCTUATION CharsToIgnore_CommonCharsToIgnore = 4
	// Whitespace character, one of [ \t\n\x0B\f\r]
	CharsToIgnore_WHITESPACE CharsToIgnore_CommonCharsToIgnore = 5
)

// Enum value maps for CharsToIgnore_CommonCharsToIgnore.
var (
	CharsToIgnore_CommonCharsToIgnore_name = map[int32]string{
		0: "COMMON_CHARS_TO_IGNORE_UNSPECIFIED",
		1: "NUMERIC",
		2: "ALPHA_UPPER_CASE",
		3: "ALPHA_LOWER_CASE",
		4: "PUNCTUATION",
		5: "WHITESPACE",
	}
	CharsToIgnore_CommonCharsToIgnore_value = map[string]int32{
		"COMMON_CHARS_TO_IGNORE_UNSPECIFIED": 0,
		"NUMERIC":                            1,
		"ALPHA_UPPER_CASE":                   2,
		"ALPHA_LOWER_CASE":                   3,
		"PUNCTUATION":                        4,
		"WHITESPACE":                         5,
	}
)

func (x CharsToIgnore_CommonCharsToIgnore) Enum() *CharsToIgnore_CommonCharsToIgnore {
	p := new(CharsToIgnore_CommonCharsToIgnore)
	*p = x
	return p
}

func (x CharsToIgnore_CommonCharsToIgnore) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CharsToIgnore_CommonCharsToIgnore) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[25].Descriptor()
}

func (CharsToIgnore_CommonCharsToIgnore) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[25]
}

func (x CharsToIgnore_CommonCharsToIgnore) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CharsToIgnore_CommonCharsToIgnore.Descriptor instead.
func (CharsToIgnore_CommonCharsToIgnore) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{64, 0}
}

// These are commonly used subsets of the alphabet that the FFX mode
// natively supports. In the algorithm, the alphabet is selected using
// the "radix". Therefore each corresponds to a particular radix.
type CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet int32

const (
	// Unused.
	CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 0
	// `[0-9]` (radix of 10)
	CryptoReplaceFfxFpeConfig_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 1
	// `[0-9A-F]` (radix of 16)
	CryptoReplaceFfxFpeConfig_HEXADECIMAL CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 2
	// `[0-9A-Z]` (radix of 36)
	CryptoReplaceFfxFpeConfig_UPPER_CASE_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 3
	// `[0-9A-Za-z]` (radix of 62)
	CryptoReplaceFfxFpeConfig_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 4
)

// Enum value maps for CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet.
var (
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name = map[int32]string{
		0: "FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED",
		1: "NUMERIC",
		2: "HEXADECIMAL",
		3: "UPPER_CASE_ALPHA_NUMERIC",
		4: "ALPHA_NUMERIC",
	}
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value = map[string]int32{
		"FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED": 0,
		"NUMERIC":                                1,
		"HEXADECIMAL":                            2,
		"UPPER_CASE_ALPHA_NUMERIC":               3,
		"ALPHA_NUMERIC":                          4,
	}
)

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Enum() *CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet {
	p := new(CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet)
	*p = x
	return p
}

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[26].Descriptor()
}

func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[26]
}

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet.Descriptor instead.
func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{68, 0}
}

// Logical operators for conditional checks.
type RecordCondition_Expressions_LogicalOperator int32

const (
	// Unused
	RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED RecordCondition_Expressions_LogicalOperator = 0
	// Conditional AND
	RecordCondition_Expressions_AND RecordCondition_Expressions_LogicalOperator = 1
)

// Enum value maps for RecordCondition_Expressions_LogicalOperator.
var (
	RecordCondition_Expressions_LogicalOperator_name = map[int32]string{
		0: "LOGICAL_OPERATOR_UNSPECIFIED",
		1: "AND",
	}
	RecordCondition_Expressions_LogicalOperator_value = map[string]int32{
		"LOGICAL_OPERATOR_UNSPECIFIED": 0,
		"AND":                          1,
	}
)

func (x RecordCondition_Expressions_LogicalOperator) Enum() *RecordCondition_Expressions_LogicalOperator {
	p := new(RecordCondition_Expressions_LogicalOperator)
	*p = x
	return p
}

func (x RecordCondition_Expressions_LogicalOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecordCondition_Expressions_LogicalOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[27].Descriptor()
}

func (RecordCondition_Expressions_LogicalOperator) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[27]
}

func (x RecordCondition_Expressions_LogicalOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecordCondition_Expressions_LogicalOperator.Descriptor instead.
func (RecordCondition_Expressions_LogicalOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 2, 0}
}

// Possible outcomes of transformations.
type TransformationSummary_TransformationResultCode int32

const (
	// Unused
	TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED TransformationSummary_TransformationResultCode = 0
	// Transformation completed without an error.
	TransformationSummary_SUCCESS TransformationSummary_TransformationResultCode = 1
	// Transformation had an error.
	TransformationSummary_ERROR TransformationSummary_TransformationResultCode = 2
)

// Enum value maps for TransformationSummary_TransformationResultCode.
var (
	TransformationSummary_TransformationResultCode_name = map[int32]string{
		0: "TRANSFORMATION_RESULT_CODE_UNSPECIFIED",
		1: "SUCCESS",
		2: "ERROR",
	}
	TransformationSummary_TransformationResultCode_value = map[string]int32{
		"TRANSFORMATION_RESULT_CODE_UNSPECIFIED": 0,
		"SUCCESS":                                1,
		"ERROR":                                  2,
	}
)

func (x TransformationSummary_TransformationResultCode) Enum() *TransformationSummary_TransformationResultCode {
	p := new(TransformationSummary_TransformationResultCode)
	*p = x
	return p
}

func (x TransformationSummary_TransformationResultCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransformationSummary_TransformationResultCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[28].Descriptor()
}

func (TransformationSummary_TransformationResultCode) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[28]
}

func (x TransformationSummary_TransformationResultCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransformationSummary_TransformationResultCode.Descriptor instead.
func (TransformationSummary_TransformationResultCode) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{80, 0}
}

// Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
// will be created with this configuration. The service may automatically
// pause triggers experiencing frequent errors. To restart a job, set the
// status to HEALTHY after correcting user errors.
type JobTrigger_Status int32

const (
	// Unused.
	JobTrigger_STATUS_UNSPECIFIED JobTrigger_Status = 0
	// Trigger is healthy.
	JobTrigger_HEALTHY JobTrigger_Status = 1
	// Trigger is temporarily paused.
	JobTrigger_PAUSED JobTrigger_Status = 2
	// Trigger is cancelled and can not be resumed.
	JobTrigger_CANCELLED JobTrigger_Status = 3
)

// Enum value maps for JobTrigger_Status.
var (
	JobTrigger_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "HEALTHY",
		2: "PAUSED",
		3: "CANCELLED",
	}
	JobTrigger_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"HEALTHY":            1,
		"PAUSED":             2,
		"CANCELLED":          3,
	}
)

func (x JobTrigger_Status) Enum() *JobTrigger_Status {
	p := new(JobTrigger_Status)
	*p = x
	return p
}

func (x JobTrigger_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobTrigger_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[29].Descriptor()
}

func (JobTrigger_Status) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[29]
}

func (x JobTrigger_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobTrigger_Status.Descriptor instead.
func (JobTrigger_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{92, 0}
}

// Types of event that can trigger an action.
type DataProfileAction_EventType int32

const (
	// Unused.
	DataProfileAction_EVENT_TYPE_UNSPECIFIED DataProfileAction_EventType = 0
	// New profile (not a re-profile).
	DataProfileAction_NEW_PROFILE DataProfileAction_EventType = 1
	// Changed one of the following profile metrics:
	// * Table data risk score
	// * Table sensitivity score
	// * Table resource visibility
	// * Table encryption type
	// * Table predicted infoTypes
	// * Table other infoTypes
	DataProfileAction_CHANGED_PROFILE DataProfileAction_EventType = 2
	// Table data risk score or sensitivity score increased.
	DataProfileAction_SCORE_INCREASED DataProfileAction_EventType = 3
	// A user (non-internal) error occurred.
	DataProfileAction_ERROR_CHANGED DataProfileAction_EventType = 4
)

// Enum value maps for DataProfileAction_EventType.
var (
	DataProfileAction_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "NEW_PROFILE",
		2: "CHANGED_PROFILE",
		3: "SCORE_INCREASED",
		4: "ERROR_CHANGED",
	}
	DataProfileAction_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"NEW_PROFILE":            1,
		"CHANGED_PROFILE":        2,
		"SCORE_INCREASED":        3,
		"ERROR_CHANGED":          4,
	}
)

func (x DataProfileAction_EventType) Enum() *DataProfileAction_EventType {
	p := new(DataProfileAction_EventType)
	*p = x
	return p
}

func (x DataProfileAction_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfileAction_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[30].Descriptor()
}

func (DataProfileAction_EventType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[30]
}

func (x DataProfileAction_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfileAction_EventType.Descriptor instead.
func (DataProfileAction_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116, 0}
}

// The levels of detail that can be included in the Pub/Sub message.
type DataProfileAction_PubSubNotification_DetailLevel int32

const (
	// Unused.
	DataProfileAction_PubSubNotification_DETAIL_LEVEL_UNSPECIFIED DataProfileAction_PubSubNotification_DetailLevel = 0
	// The full table data profile.
	DataProfileAction_PubSubNotification_TABLE_PROFILE DataProfileAction_PubSubNotification_DetailLevel = 1
	// The resource name of the table.
	DataProfileAction_PubSubNotification_RESOURCE_NAME DataProfileAction_PubSubNotification_DetailLevel = 2
)

// Enum value maps for DataProfileAction_PubSubNotification_DetailLevel.
var (
	DataProfileAction_PubSubNotification_DetailLevel_name = map[int32]string{
		0: "DETAIL_LEVEL_UNSPECIFIED",
		1: "TABLE_PROFILE",
		2: "RESOURCE_NAME",
	}
	DataProfileAction_PubSubNotification_DetailLevel_value = map[string]int32{
		"DETAIL_LEVEL_UNSPECIFIED": 0,
		"TABLE_PROFILE":            1,
		"RESOURCE_NAME":            2,
	}
)

func (x DataProfileAction_PubSubNotification_DetailLevel) Enum() *DataProfileAction_PubSubNotification_DetailLevel {
	p := new(DataProfileAction_PubSubNotification_DetailLevel)
	*p = x
	return p
}

func (x DataProfileAction_PubSubNotification_DetailLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfileAction_PubSubNotification_DetailLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[31].Descriptor()
}

func (DataProfileAction_PubSubNotification_DetailLevel) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[31]
}

func (x DataProfileAction_PubSubNotification_DetailLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfileAction_PubSubNotification_DetailLevel.Descriptor instead.
func (DataProfileAction_PubSubNotification_DetailLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116, 1, 0}
}

// Whether the discovery config is currently active. New options may be added
// at a later time.
type DiscoveryConfig_Status int32

const (
	// Unused
	DiscoveryConfig_STATUS_UNSPECIFIED DiscoveryConfig_Status = 0
	// The discovery config is currently active.
	DiscoveryConfig_RUNNING DiscoveryConfig_Status = 1
	// The discovery config is paused temporarily.
	DiscoveryConfig_PAUSED DiscoveryConfig_Status = 2
)

// Enum value maps for DiscoveryConfig_Status.
var (
	DiscoveryConfig_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "RUNNING",
		2: "PAUSED",
	}
	DiscoveryConfig_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"RUNNING":            1,
		"PAUSED":             2,
	}
)

func (x DiscoveryConfig_Status) Enum() *DiscoveryConfig_Status {
	p := new(DiscoveryConfig_Status)
	*p = x
	return p
}

func (x DiscoveryConfig_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiscoveryConfig_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[32].Descriptor()
}

func (DiscoveryConfig_Status) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[32]
}

func (x DiscoveryConfig_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiscoveryConfig_Status.Descriptor instead.
func (DiscoveryConfig_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{123, 0}
}

// Possible states of a job. New items may be added.
type DlpJob_JobState int32

const (
	// Unused.
	DlpJob_JOB_STATE_UNSPECIFIED DlpJob_JobState = 0
	// The job has not yet started.
	DlpJob_PENDING DlpJob_JobState = 1
	// The job is currently running. Once a job has finished it will transition
	// to FAILED or DONE.
	DlpJob_RUNNING DlpJob_JobState = 2
	// The job is no longer running.
	DlpJob_DONE DlpJob_JobState = 3
	// The job was canceled before it could be completed.
	DlpJob_CANCELED DlpJob_JobState = 4
	// The job had an error and did not complete.
	DlpJob_FAILED DlpJob_JobState = 5
	// The job is currently accepting findings via hybridInspect.
	// A hybrid job in ACTIVE state may continue to have findings added to it
	// through the calling of hybridInspect. After the job has finished no more
	// calls to hybridInspect may be made. ACTIVE jobs can transition to DONE.
	DlpJob_ACTIVE DlpJob_JobState = 6
)

// Enum value maps for DlpJob_JobState.
var (
	DlpJob_JobState_name = map[int32]string{
		0: "JOB_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
		4: "CANCELED",
		5: "FAILED",
		6: "ACTIVE",
	}
	DlpJob_JobState_value = map[string]int32{
		"JOB_STATE_UNSPECIFIED": 0,
		"PENDING":               1,
		"RUNNING":               2,
		"DONE":                  3,
		"CANCELED":              4,
		"FAILED":                5,
		"ACTIVE":                6,
	}
)

func (x DlpJob_JobState) Enum() *DlpJob_JobState {
	p := new(DlpJob_JobState)
	*p = x
	return p
}

func (x DlpJob_JobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DlpJob_JobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[33].Descriptor()
}

func (DlpJob_JobState) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[33]
}

func (x DlpJob_JobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DlpJob_JobState.Descriptor instead.
func (DlpJob_JobState) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{133, 0}
}

// Various score levels for resources.
type DataRiskLevel_DataRiskLevelScore int32

const (
	// Unused.
	DataRiskLevel_RISK_SCORE_UNSPECIFIED DataRiskLevel_DataRiskLevelScore = 0
	// Low risk - Lower indication of sensitive data that appears to have
	// additional access restrictions in place or no indication of sensitive
	// data found.
	DataRiskLevel_RISK_LOW DataRiskLevel_DataRiskLevelScore = 10
	// Medium risk - Sensitive data may be present but additional access or fine
	// grain access restrictions appear to be present.  Consider limiting
	// access even further or transform data to mask.
	DataRiskLevel_RISK_MODERATE DataRiskLevel_DataRiskLevelScore = 20
	// High risk – SPII may be present. Access controls may include public
	// ACLs. Exfiltration of data may lead to user data loss. Re-identification
	// of users may be possible. Consider limiting usage and or removing SPII.
	DataRiskLevel_RISK_HIGH DataRiskLevel_DataRiskLevelScore = 30
)

// Enum value maps for DataRiskLevel_DataRiskLevelScore.
var (
	DataRiskLevel_DataRiskLevelScore_name = map[int32]string{
		0:  "RISK_SCORE_UNSPECIFIED",
		10: "RISK_LOW",
		20: "RISK_MODERATE",
		30: "RISK_HIGH",
	}
	DataRiskLevel_DataRiskLevelScore_value = map[string]int32{
		"RISK_SCORE_UNSPECIFIED": 0,
		"RISK_LOW":               10,
		"RISK_MODERATE":          20,
		"RISK_HIGH":              30,
	}
)

func (x DataRiskLevel_DataRiskLevelScore) Enum() *DataRiskLevel_DataRiskLevelScore {
	p := new(DataRiskLevel_DataRiskLevelScore)
	*p = x
	return p
}

func (x DataRiskLevel_DataRiskLevelScore) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataRiskLevel_DataRiskLevelScore) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[34].Descriptor()
}

func (DataRiskLevel_DataRiskLevelScore) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[34]
}

func (x DataRiskLevel_DataRiskLevelScore) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataRiskLevel_DataRiskLevelScore.Descriptor instead.
func (DataRiskLevel_DataRiskLevelScore) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{169, 0}
}

// Possible states of a profile. New items may be added.
type TableDataProfile_State int32

const (
	// Unused.
	TableDataProfile_STATE_UNSPECIFIED TableDataProfile_State = 0
	// The profile is currently running. Once a profile has finished it will
	// transition to DONE.
	TableDataProfile_RUNNING TableDataProfile_State = 1
	// The profile is no longer generating.
	// If profile_status.status.code is 0, the profile succeeded, otherwise, it
	// failed.
	TableDataProfile_DONE TableDataProfile_State = 2
)

// Enum value maps for TableDataProfile_State.
var (
	TableDataProfile_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "DONE",
	}
	TableDataProfile_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"DONE":              2,
	}
)

func (x TableDataProfile_State) Enum() *TableDataProfile_State {
	p := new(TableDataProfile_State)
	*p = x
	return p
}

func (x TableDataProfile_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TableDataProfile_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[35].Descriptor()
}

func (TableDataProfile_State) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[35]
}

func (x TableDataProfile_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TableDataProfile_State.Descriptor instead.
func (TableDataProfile_State) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{172, 0}
}

// Possible states of a profile. New items may be added.
type ColumnDataProfile_State int32

const (
	// Unused.
	ColumnDataProfile_STATE_UNSPECIFIED ColumnDataProfile_State = 0
	// The profile is currently running. Once a profile has finished it will
	// transition to DONE.
	ColumnDataProfile_RUNNING ColumnDataProfile_State = 1
	// The profile is no longer generating.
	// If profile_status.status.code is 0, the profile succeeded, otherwise, it
	// failed.
	ColumnDataProfile_DONE ColumnDataProfile_State = 2
)

// Enum value maps for ColumnDataProfile_State.
var (
	ColumnDataProfile_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "DONE",
	}
	ColumnDataProfile_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"DONE":              2,
	}
)

func (x ColumnDataProfile_State) Enum() *ColumnDataProfile_State {
	p := new(ColumnDataProfile_State)
	*p = x
	return p
}

func (x ColumnDataProfile_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ColumnDataProfile_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[36].Descriptor()
}

func (ColumnDataProfile_State) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[36]
}

func (x ColumnDataProfile_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ColumnDataProfile_State.Descriptor instead.
func (ColumnDataProfile_State) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{176, 0}
}

// Data types of the data in a column. Types may be added over time.
type ColumnDataProfile_ColumnDataType int32

const (
	// Invalid type.
	ColumnDataProfile_COLUMN_DATA_TYPE_UNSPECIFIED ColumnDataProfile_ColumnDataType = 0
	// Encoded as a string in decimal format.
	ColumnDataProfile_TYPE_INT64 ColumnDataProfile_ColumnDataType = 1
	// Encoded as a boolean "false" or "true".
	ColumnDataProfile_TYPE_BOOL ColumnDataProfile_ColumnDataType = 2
	// Encoded as a number, or string "NaN", "Infinity" or "-Infinity".
	ColumnDataProfile_TYPE_FLOAT64 ColumnDataProfile_ColumnDataType = 3
	// Encoded as a string value.
	ColumnDataProfile_TYPE_STRING ColumnDataProfile_ColumnDataType = 4
	// Encoded as a base64 string per RFC 4648, section 4.
	ColumnDataProfile_TYPE_BYTES ColumnDataProfile_ColumnDataType = 5
	// Encoded as an RFC 3339 timestamp with mandatory "Z" time zone string:
	// 1985-04-12T23:20:50.52Z
	ColumnDataProfile_TYPE_TIMESTAMP ColumnDataProfile_ColumnDataType = 6
	// Encoded as RFC 3339 full-date format string: 1985-04-12
	ColumnDataProfile_TYPE_DATE ColumnDataProfile_ColumnDataType = 7
	// Encoded as RFC 3339 partial-time format string: 23:20:50.52
	ColumnDataProfile_TYPE_TIME ColumnDataProfile_ColumnDataType = 8
	// Encoded as RFC 3339 full-date "T" partial-time: 1985-04-12T23:20:50.52
	ColumnDataProfile_TYPE_DATETIME ColumnDataProfile_ColumnDataType = 9
	// Encoded as WKT
	ColumnDataProfile_TYPE_GEOGRAPHY ColumnDataProfile_ColumnDataType = 10
	// Encoded as a decimal string.
	ColumnDataProfile_TYPE_NUMERIC ColumnDataProfile_ColumnDataType = 11
	// Container of ordered fields, each with a type and field name.
	ColumnDataProfile_TYPE_RECORD ColumnDataProfile_ColumnDataType = 12
	// Decimal type.
	ColumnDataProfile_TYPE_BIGNUMERIC ColumnDataProfile_ColumnDataType = 13
	// Json type.
	ColumnDataProfile_TYPE_JSON ColumnDataProfile_ColumnDataType = 14
)

// Enum value maps for ColumnDataProfile_ColumnDataType.
var (
	ColumnDataProfile_ColumnDataType_name = map[int32]string{
		0:  "COLUMN_DATA_TYPE_UNSPECIFIED",
		1:  "TYPE_INT64",
		2:  "TYPE_BOOL",
		3:  "TYPE_FLOAT64",
		4:  "TYPE_STRING",
		5:  "TYPE_BYTES",
		6:  "TYPE_TIMESTAMP",
		7:  "TYPE_DATE",
		8:  "TYPE_TIME",
		9:  "TYPE_DATETIME",
		10: "TYPE_GEOGRAPHY",
		11: "TYPE_NUMERIC",
		12: "TYPE_RECORD",
		13: "TYPE_BIGNUMERIC",
		14: "TYPE_JSON",
	}
	ColumnDataProfile_ColumnDataType_value = map[string]int32{
		"COLUMN_DATA_TYPE_UNSPECIFIED": 0,
		"TYPE_INT64":                   1,
		"TYPE_BOOL":                    2,
		"TYPE_FLOAT64":                 3,
		"TYPE_STRING":                  4,
		"TYPE_BYTES":                   5,
		"TYPE_TIMESTAMP":               6,
		"TYPE_DATE":                    7,
		"TYPE_TIME":                    8,
		"TYPE_DATETIME":                9,
		"TYPE_GEOGRAPHY":               10,
		"TYPE_NUMERIC":                 11,
		"TYPE_RECORD":                  12,
		"TYPE_BIGNUMERIC":              13,
		"TYPE_JSON":                    14,
	}
)

func (x ColumnDataProfile_ColumnDataType) Enum() *ColumnDataProfile_ColumnDataType {
	p := new(ColumnDataProfile_ColumnDataType)
	*p = x
	return p
}

func (x ColumnDataProfile_ColumnDataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ColumnDataProfile_ColumnDataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[37].Descriptor()
}

func (ColumnDataProfile_ColumnDataType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[37]
}

func (x ColumnDataProfile_ColumnDataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ColumnDataProfile_ColumnDataType.Descriptor instead.
func (ColumnDataProfile_ColumnDataType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{176, 1}
}

// The possible policy states for a column.
type ColumnDataProfile_ColumnPolicyState int32

const (
	// No policy tags.
	ColumnDataProfile_COLUMN_POLICY_STATE_UNSPECIFIED ColumnDataProfile_ColumnPolicyState = 0
	// Column has policy tag applied.
	ColumnDataProfile_COLUMN_POLICY_TAGGED ColumnDataProfile_ColumnPolicyState = 1
)

// Enum value maps for ColumnDataProfile_ColumnPolicyState.
var (
	ColumnDataProfile_ColumnPolicyState_name = map[int32]string{
		0: "COLUMN_POLICY_STATE_UNSPECIFIED",
		1: "COLUMN_POLICY_TAGGED",
	}
	ColumnDataProfile_ColumnPolicyState_value = map[string]int32{
		"COLUMN_POLICY_STATE_UNSPECIFIED": 0,
		"COLUMN_POLICY_TAGGED":            1,
	}
)

func (x ColumnDataProfile_ColumnPolicyState) Enum() *ColumnDataProfile_ColumnPolicyState {
	p := new(ColumnDataProfile_ColumnPolicyState)
	*p = x
	return p
}

func (x ColumnDataProfile_ColumnPolicyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ColumnDataProfile_ColumnPolicyState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[38].Descriptor()
}

func (ColumnDataProfile_ColumnPolicyState) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[38]
}

func (x ColumnDataProfile_ColumnPolicyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ColumnDataProfile_ColumnPolicyState.Descriptor instead.
func (ColumnDataProfile_ColumnPolicyState) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{176, 2}
}

// Various score levels for resources.
type DataProfilePubSubCondition_ProfileScoreBucket int32

const (
	// Unused.
	DataProfilePubSubCondition_PROFILE_SCORE_BUCKET_UNSPECIFIED DataProfilePubSubCondition_ProfileScoreBucket = 0
	// High risk/sensitivity detected.
	DataProfilePubSubCondition_HIGH DataProfilePubSubCondition_ProfileScoreBucket = 1
	// Medium or high risk/sensitivity detected.
	DataProfilePubSubCondition_MEDIUM_OR_HIGH DataProfilePubSubCondition_ProfileScoreBucket = 2
)

// Enum value maps for DataProfilePubSubCondition_ProfileScoreBucket.
var (
	DataProfilePubSubCondition_ProfileScoreBucket_name = map[int32]string{
		0: "PROFILE_SCORE_BUCKET_UNSPECIFIED",
		1: "HIGH",
		2: "MEDIUM_OR_HIGH",
	}
	DataProfilePubSubCondition_ProfileScoreBucket_value = map[string]int32{
		"PROFILE_SCORE_BUCKET_UNSPECIFIED": 0,
		"HIGH":                             1,
		"MEDIUM_OR_HIGH":                   2,
	}
)

func (x DataProfilePubSubCondition_ProfileScoreBucket) Enum() *DataProfilePubSubCondition_ProfileScoreBucket {
	p := new(DataProfilePubSubCondition_ProfileScoreBucket)
	*p = x
	return p
}

func (x DataProfilePubSubCondition_ProfileScoreBucket) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfilePubSubCondition_ProfileScoreBucket) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[39].Descriptor()
}

func (DataProfilePubSubCondition_ProfileScoreBucket) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[39]
}

func (x DataProfilePubSubCondition_ProfileScoreBucket) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfilePubSubCondition_ProfileScoreBucket.Descriptor instead.
func (DataProfilePubSubCondition_ProfileScoreBucket) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{180, 0}
}

// Logical operators for conditional checks.
type DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator int32

const (
	// Unused.
	DataProfilePubSubCondition_PubSubExpressions_LOGICAL_OPERATOR_UNSPECIFIED DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator = 0
	// Conditional OR.
	DataProfilePubSubCondition_PubSubExpressions_OR DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator = 1
	// Conditional AND.
	DataProfilePubSubCondition_PubSubExpressions_AND DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator = 2
)

// Enum value maps for DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator.
var (
	DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_name = map[int32]string{
		0: "LOGICAL_OPERATOR_UNSPECIFIED",
		1: "OR",
		2: "AND",
	}
	DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_value = map[string]int32{
		"LOGICAL_OPERATOR_UNSPECIFIED": 0,
		"OR":                           1,
		"AND":                          2,
	}
)

func (x DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) Enum() *DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator {
	p := new(DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator)
	*p = x
	return p
}

func (x DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[40].Descriptor()
}

func (DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[40]
}

func (x DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator.Descriptor instead.
func (DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{180, 1, 0}
}

// List of excluded infoTypes.
type ExcludeInfoTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// InfoType list in ExclusionRule rule drops a finding when it overlaps or
	// contained within with a finding of an infoType from this list. For
	// example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"` and
	// `exclusion_rule` containing `exclude_info_types.info_types` with
	// "EMAIL_ADDRESS" the phone number findings are dropped if they overlap
	// with EMAIL_ADDRESS finding.
	// That leads to "555-222-2222@example.org" to generate only a single
	// finding, namely email address.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *ExcludeInfoTypes) Reset() {
	*x = ExcludeInfoTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExcludeInfoTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExcludeInfoTypes) ProtoMessage() {}

func (x *ExcludeInfoTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExcludeInfoTypes.ProtoReflect.Descriptor instead.
func (*ExcludeInfoTypes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{0}
}

func (x *ExcludeInfoTypes) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// The rule to exclude findings based on a hotword. For record inspection of
// tables, column names are considered hotwords. An example of this is to
// exclude a finding if it belongs to a BigQuery column that matches a specific
// pattern.
type ExcludeByHotword struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regular expression pattern defining what qualifies as a hotword.
	HotwordRegex *CustomInfoType_Regex `protobuf:"bytes,1,opt,name=hotword_regex,json=hotwordRegex,proto3" json:"hotword_regex,omitempty"`
	// Range of characters within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters.
	// The windowBefore property in proximity should be set to 1 if the hotword
	// needs to be included in a column header.
	Proximity *CustomInfoType_DetectionRule_Proximity `protobuf:"bytes,2,opt,name=proximity,proto3" json:"proximity,omitempty"`
}

func (x *ExcludeByHotword) Reset() {
	*x = ExcludeByHotword{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExcludeByHotword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExcludeByHotword) ProtoMessage() {}

func (x *ExcludeByHotword) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExcludeByHotword.ProtoReflect.Descriptor instead.
func (*ExcludeByHotword) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{1}
}

func (x *ExcludeByHotword) GetHotwordRegex() *CustomInfoType_Regex {
	if x != nil {
		return x.HotwordRegex
	}
	return nil
}

func (x *ExcludeByHotword) GetProximity() *CustomInfoType_DetectionRule_Proximity {
	if x != nil {
		return x.Proximity
	}
	return nil
}

// The rule that specifies conditions when findings of infoTypes specified in
// `InspectionRuleSet` are removed from results.
type ExclusionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exclusion rule types.
	//
	// Types that are assignable to Type:
	//
	//	*ExclusionRule_Dictionary
	//	*ExclusionRule_Regex
	//	*ExclusionRule_ExcludeInfoTypes
	//	*ExclusionRule_ExcludeByHotword
	Type isExclusionRule_Type `protobuf_oneof:"type"`
	// How the rule is applied, see MatchingType documentation for details.
	MatchingType MatchingType `protobuf:"varint,4,opt,name=matching_type,json=matchingType,proto3,enum=google.privacy.dlp.v2.MatchingType" json:"matching_type,omitempty"`
}

func (x *ExclusionRule) Reset() {
	*x = ExclusionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExclusionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExclusionRule) ProtoMessage() {}

func (x *ExclusionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExclusionRule.ProtoReflect.Descriptor instead.
func (*ExclusionRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{2}
}

func (m *ExclusionRule) GetType() isExclusionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ExclusionRule) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := x.GetType().(*ExclusionRule_Dictionary); ok {
		return x.Dictionary
	}
	return nil
}

func (x *ExclusionRule) GetRegex() *CustomInfoType_Regex {
	if x, ok := x.GetType().(*ExclusionRule_Regex); ok {
		return x.Regex
	}
	return nil
}

func (x *ExclusionRule) GetExcludeInfoTypes() *ExcludeInfoTypes {
	if x, ok := x.GetType().(*ExclusionRule_ExcludeInfoTypes); ok {
		return x.ExcludeInfoTypes
	}
	return nil
}

func (x *ExclusionRule) GetExcludeByHotword() *ExcludeByHotword {
	if x, ok := x.GetType().(*ExclusionRule_ExcludeByHotword); ok {
		return x.ExcludeByHotword
	}
	return nil
}

func (x *ExclusionRule) GetMatchingType() MatchingType {
	if x != nil {
		return x.MatchingType
	}
	return MatchingType_MATCHING_TYPE_UNSPECIFIED
}

type isExclusionRule_Type interface {
	isExclusionRule_Type()
}

type ExclusionRule_Dictionary struct {
	// Dictionary which defines the rule.
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,1,opt,name=dictionary,proto3,oneof"`
}

type ExclusionRule_Regex struct {
	// Regular expression which defines the rule.
	Regex *CustomInfoType_Regex `protobuf:"bytes,2,opt,name=regex,proto3,oneof"`
}

type ExclusionRule_ExcludeInfoTypes struct {
	// Set of infoTypes for which findings would affect this rule.
	ExcludeInfoTypes *ExcludeInfoTypes `protobuf:"bytes,3,opt,name=exclude_info_types,json=excludeInfoTypes,proto3,oneof"`
}

type ExclusionRule_ExcludeByHotword struct {
	// Drop if the hotword rule is contained in the proximate context. For
	// tabular data, the context includes the column name.
	ExcludeByHotword *ExcludeByHotword `protobuf:"bytes,5,opt,name=exclude_by_hotword,json=excludeByHotword,proto3,oneof"`
}

func (*ExclusionRule_Dictionary) isExclusionRule_Type() {}

func (*ExclusionRule_Regex) isExclusionRule_Type() {}

func (*ExclusionRule_ExcludeInfoTypes) isExclusionRule_Type() {}

func (*ExclusionRule_ExcludeByHotword) isExclusionRule_Type() {}

// A single inspection rule to be applied to infoTypes, specified in
// `InspectionRuleSet`.
type InspectionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Inspection rule types.
	//
	// Types that are assignable to Type:
	//
	//	*InspectionRule_HotwordRule
	//	*InspectionRule_ExclusionRule
	Type isInspectionRule_Type `protobuf_oneof:"type"`
}

func (x *InspectionRule) Reset() {
	*x = InspectionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectionRule) ProtoMessage() {}

func (x *InspectionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectionRule.ProtoReflect.Descriptor instead.
func (*InspectionRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{3}
}

func (m *InspectionRule) GetType() isInspectionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *InspectionRule) GetHotwordRule() *CustomInfoType_DetectionRule_HotwordRule {
	if x, ok := x.GetType().(*InspectionRule_HotwordRule); ok {
		return x.HotwordRule
	}
	return nil
}

func (x *InspectionRule) GetExclusionRule() *ExclusionRule {
	if x, ok := x.GetType().(*InspectionRule_ExclusionRule); ok {
		return x.ExclusionRule
	}
	return nil
}

type isInspectionRule_Type interface {
	isInspectionRule_Type()
}

type InspectionRule_HotwordRule struct {
	// Hotword-based detection rule.
	HotwordRule *CustomInfoType_DetectionRule_HotwordRule `protobuf:"bytes,1,opt,name=hotword_rule,json=hotwordRule,proto3,oneof"`
}

type InspectionRule_ExclusionRule struct {
	// Exclusion rule.
	ExclusionRule *ExclusionRule `protobuf:"bytes,2,opt,name=exclusion_rule,json=exclusionRule,proto3,oneof"`
}

func (*InspectionRule_HotwordRule) isInspectionRule_Type() {}

func (*InspectionRule_ExclusionRule) isInspectionRule_Type() {}

// Rule set for modifying a set of infoTypes to alter behavior under certain
// circumstances, depending on the specific details of the rules within the set.
type InspectionRuleSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of infoTypes this rule set is applied to.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Set of rules to be applied to infoTypes. The rules are applied in order.
	Rules []*InspectionRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *InspectionRuleSet) Reset() {
	*x = InspectionRuleSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectionRuleSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectionRuleSet) ProtoMessage() {}

func (x *InspectionRuleSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectionRuleSet.ProtoReflect.Descriptor instead.
func (*InspectionRuleSet) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4}
}

func (x *InspectionRuleSet) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InspectionRuleSet) GetRules() []*InspectionRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Configuration description of the scanning process.
// When used with redactContent only info_types and min_likelihood are currently
// used.
type InspectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Restricts what info_types to look for. The values must correspond to
	// InfoType values returned by ListInfoTypes or listed at
	// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference.
	//
	// When no InfoTypes or CustomInfoTypes are specified in a request, the
	// system may automatically choose a default list of detectors to run, which
	// may change over time.
	//
	// If you need precise control and predictability as to what detectors are
	// run you should specify specific InfoTypes listed in the reference,
	// otherwise a default list will be used, which may change over time.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Only returns findings equal to or above this threshold. The default is
	// POSSIBLE.
	//
	// In general, the highest likelihood setting yields the fewest findings in
	// results and the lowest chance of a false positive. For more information,
	// see [Match
	// likelihood](https://cloud.google.com/sensitive-data-protection/docs/likelihood).
	MinLikelihood Likelihood `protobuf:"varint,2,opt,name=min_likelihood,json=minLikelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"min_likelihood,omitempty"`
	// Minimum likelihood per infotype. For each infotype, a user can specify a
	// minimum likelihood. The system only returns a finding if its likelihood is
	// above this threshold. If this field is not set, the system uses the
	// InspectConfig min_likelihood.
	MinLikelihoodPerInfoType []*InspectConfig_InfoTypeLikelihood `protobuf:"bytes,11,rep,name=min_likelihood_per_info_type,json=minLikelihoodPerInfoType,proto3" json:"min_likelihood_per_info_type,omitempty"`
	// Configuration to control the number of findings returned.
	// This is not used for data profiling.
	//
	// When redacting sensitive data from images, finding limits don't apply. They
	// can cause unexpected or inconsistent results, where only some data is
	// redacted. Don't include finding limits in
	// [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
	// requests. Otherwise, Cloud DLP returns an error.
	//
	// When set within an
	// [InspectJobConfig][google.privacy.dlp.v2.InspectJobConfig], the specified
	// maximum values aren't hard limits. If an inspection job reaches these
	// limits, the job ends gradually, not abruptly. Therefore, the actual number
	// of findings that Cloud DLP returns can be multiple times higher than these
	// maximum values.
	Limits *InspectConfig_FindingLimits `protobuf:"bytes,3,opt,name=limits,proto3" json:"limits,omitempty"`
	// When true, a contextual quote from the data that triggered a finding is
	// included in the response; see
	// [Finding.quote][google.privacy.dlp.v2.Finding.quote]. This is not used for
	// data profiling.
	IncludeQuote bool `protobuf:"varint,4,opt,name=include_quote,json=includeQuote,proto3" json:"include_quote,omitempty"`
	// When true, excludes type information of the findings.
	// This is not used for data profiling.
	ExcludeInfoTypes bool `protobuf:"varint,5,opt,name=exclude_info_types,json=excludeInfoTypes,proto3" json:"exclude_info_types,omitempty"`
	// CustomInfoTypes provided by the user. See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes
	// to learn more.
	CustomInfoTypes []*CustomInfoType `protobuf:"bytes,6,rep,name=custom_info_types,json=customInfoTypes,proto3" json:"custom_info_types,omitempty"`
	// Deprecated and unused.
	ContentOptions []ContentOption `protobuf:"varint,8,rep,packed,name=content_options,json=contentOptions,proto3,enum=google.privacy.dlp.v2.ContentOption" json:"content_options,omitempty"`
	// Set of rules to apply to the findings for this InspectConfig.
	// Exclusion rules, contained in the set are executed in the end, other
	// rules are executed in the order they are specified for each info type.
	RuleSet []*InspectionRuleSet `protobuf:"bytes,10,rep,name=rule_set,json=ruleSet,proto3" json:"rule_set,omitempty"`
}

func (x *InspectConfig) Reset() {
	*x = InspectConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig) ProtoMessage() {}

func (x *InspectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig.ProtoReflect.Descriptor instead.
func (*InspectConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5}
}

func (x *InspectConfig) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InspectConfig) GetMinLikelihood() Likelihood {
	if x != nil {
		return x.MinLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (x *InspectConfig) GetMinLikelihoodPerInfoType() []*InspectConfig_InfoTypeLikelihood {
	if x != nil {
		return x.MinLikelihoodPerInfoType
	}
	return nil
}

func (x *InspectConfig) GetLimits() *InspectConfig_FindingLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *InspectConfig) GetIncludeQuote() bool {
	if x != nil {
		return x.IncludeQuote
	}
	return false
}

func (x *InspectConfig) GetExcludeInfoTypes() bool {
	if x != nil {
		return x.ExcludeInfoTypes
	}
	return false
}

func (x *InspectConfig) GetCustomInfoTypes() []*CustomInfoType {
	if x != nil {
		return x.CustomInfoTypes
	}
	return nil
}

func (x *InspectConfig) GetContentOptions() []ContentOption {
	if x != nil {
		return x.ContentOptions
	}
	return nil
}

func (x *InspectConfig) GetRuleSet() []*InspectionRuleSet {
	if x != nil {
		return x.RuleSet
	}
	return nil
}

// Container for bytes to inspect or redact.
type ByteContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of data stored in the bytes string. Default will be TEXT_UTF8.
	Type ByteContentItem_BytesType `protobuf:"varint,1,opt,name=type,proto3,enum=google.privacy.dlp.v2.ByteContentItem_BytesType" json:"type,omitempty"`
	// Content data to inspect or redact.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ByteContentItem) Reset() {
	*x = ByteContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ByteContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ByteContentItem) ProtoMessage() {}

func (x *ByteContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ByteContentItem.ProtoReflect.Descriptor instead.
func (*ByteContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{6}
}

func (x *ByteContentItem) GetType() ByteContentItem_BytesType {
	if x != nil {
		return x.Type
	}
	return ByteContentItem_BYTES_TYPE_UNSPECIFIED
}

func (x *ByteContentItem) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Type of content to inspect.
type ContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data of the item either in the byte array or UTF-8 string form, or table.
	//
	// Types that are assignable to DataItem:
	//
	//	*ContentItem_Value
	//	*ContentItem_Table
	//	*ContentItem_ByteItem
	DataItem isContentItem_DataItem `protobuf_oneof:"data_item"`
}

func (x *ContentItem) Reset() {
	*x = ContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentItem) ProtoMessage() {}

func (x *ContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentItem.ProtoReflect.Descriptor instead.
func (*ContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{7}
}

func (m *ContentItem) GetDataItem() isContentItem_DataItem {
	if m != nil {
		return m.DataItem
	}
	return nil
}

func (x *ContentItem) GetValue() string {
	if x, ok := x.GetDataItem().(*ContentItem_Value); ok {
		return x.Value
	}
	return ""
}

func (x *ContentItem) GetTable() *Table {
	if x, ok := x.GetDataItem().(*ContentItem_Table); ok {
		return x.Table
	}
	return nil
}

func (x *ContentItem) GetByteItem() *ByteContentItem {
	if x, ok := x.GetDataItem().(*ContentItem_ByteItem); ok {
		return x.ByteItem
	}
	return nil
}

type isContentItem_DataItem interface {
	isContentItem_DataItem()
}

type ContentItem_Value struct {
	// String data to inspect or redact.
	Value string `protobuf:"bytes,3,opt,name=value,proto3,oneof"`
}

type ContentItem_Table struct {
	// Structured content for inspection. See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-text#inspecting_a_table
	// to learn more.
	Table *Table `protobuf:"bytes,4,opt,name=table,proto3,oneof"`
}

type ContentItem_ByteItem struct {
	// Content data to inspect or redact. Replaces `type` and `data`.
	ByteItem *ByteContentItem `protobuf:"bytes,5,opt,name=byte_item,json=byteItem,proto3,oneof"`
}

func (*ContentItem_Value) isContentItem_DataItem() {}

func (*ContentItem_Table) isContentItem_DataItem() {}

func (*ContentItem_ByteItem) isContentItem_DataItem() {}

// Structured content to inspect. Up to 50,000 `Value`s per request allowed. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-structured-text#inspecting_a_table
// to learn more.
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Headers of the table.
	Headers []*FieldId `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
	// Rows of the table.
	Rows []*Table_Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{8}
}

func (x *Table) GetHeaders() []*FieldId {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *Table) GetRows() []*Table_Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// All the findings for a single scanned item.
type InspectResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of findings for an item.
	Findings []*Finding `protobuf:"bytes,1,rep,name=findings,proto3" json:"findings,omitempty"`
	// If true, then this item might have more findings than were returned,
	// and the findings returned are an arbitrary subset of all findings.
	// The findings list might be truncated because the input items were too
	// large, or because the server reached the maximum amount of resources
	// allowed for a single API call. For best results, divide the input into
	// smaller batches.
	FindingsTruncated bool `protobuf:"varint,2,opt,name=findings_truncated,json=findingsTruncated,proto3" json:"findings_truncated,omitempty"`
}

func (x *InspectResult) Reset() {
	*x = InspectResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectResult) ProtoMessage() {}

func (x *InspectResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectResult.ProtoReflect.Descriptor instead.
func (*InspectResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{9}
}

func (x *InspectResult) GetFindings() []*Finding {
	if x != nil {
		return x.Findings
	}
	return nil
}

func (x *InspectResult) GetFindingsTruncated() bool {
	if x != nil {
		return x.FindingsTruncated
	}
	return false
}

// Represents a piece of potentially sensitive content.
type Finding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name in format
	// projects/{project}/locations/{location}/findings/{finding} Populated only
	// when viewing persisted findings.
	Name string `protobuf:"bytes,14,opt,name=name,proto3" json:"name,omitempty"`
	// The content that was found. Even if the content is not textual, it
	// may be converted to a textual representation here.
	// Provided if `include_quote` is true and the finding is
	// less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
	// in length, the quote may be omitted.
	Quote string `protobuf:"bytes,1,opt,name=quote,proto3" json:"quote,omitempty"`
	// The type of content that might have been found.
	// Provided if `excluded_types` is false.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Confidence of how likely it is that the `info_type` is correct.
	Likelihood Likelihood `protobuf:"varint,3,opt,name=likelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"likelihood,omitempty"`
	// Where the content was found.
	Location *Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// Timestamp when finding was detected.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Contains data parsed from quotes. Only populated if include_quote was set
	// to true and a supported infoType was requested. Currently supported
	// infoTypes: DATE, DATE_OF_BIRTH and TIME.
	QuoteInfo *QuoteInfo `protobuf:"bytes,7,opt,name=quote_info,json=quoteInfo,proto3" json:"quote_info,omitempty"`
	// The job that stored the finding.
	ResourceName string `protobuf:"bytes,8,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Job trigger name, if applicable, for this finding.
	TriggerName string `protobuf:"bytes,9,opt,name=trigger_name,json=triggerName,proto3" json:"trigger_name,omitempty"`
	// The labels associated with this `Finding`.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// Label values must be between 0 and 63 characters long and must conform
	// to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//
	// No more than 10 labels can be associated with a given finding.
	//
	// Examples:
	// * `"environment" : "production"`
	// * `"pipeline" : "etl"`
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Time the job started that produced this finding.
	JobCreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=job_create_time,json=jobCreateTime,proto3" json:"job_create_time,omitempty"`
	// The job that stored the finding.
	JobName string `protobuf:"bytes,13,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// The unique finding id.
	FindingId string `protobuf:"bytes,15,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
}

func (x *Finding) Reset() {
	*x = Finding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Finding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding) ProtoMessage() {}

func (x *Finding) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding.ProtoReflect.Descriptor instead.
func (*Finding) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{10}
}

func (x *Finding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Finding) GetQuote() string {
	if x != nil {
		return x.Quote
	}
	return ""
}

func (x *Finding) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *Finding) GetLikelihood() Likelihood {
	if x != nil {
		return x.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (x *Finding) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Finding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Finding) GetQuoteInfo() *QuoteInfo {
	if x != nil {
		return x.QuoteInfo
	}
	return nil
}

func (x *Finding) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Finding) GetTriggerName() string {
	if x != nil {
		return x.TriggerName
	}
	return ""
}

func (x *Finding) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Finding) GetJobCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.JobCreateTime
	}
	return nil
}

func (x *Finding) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *Finding) GetFindingId() string {
	if x != nil {
		return x.FindingId
	}
	return ""
}

// Specifies the location of the finding.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based byte offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Note that when the content is not textual, this references
	// the UTF-8 encoded textual representation of the content.
	// Omitted if content is an image.
	ByteRange *Range `protobuf:"bytes,1,opt,name=byte_range,json=byteRange,proto3" json:"byte_range,omitempty"`
	// Unicode character offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Provided when the content is text.
	CodepointRange *Range `protobuf:"bytes,2,opt,name=codepoint_range,json=codepointRange,proto3" json:"codepoint_range,omitempty"`
	// List of nested objects pointing to the precise location of the finding
	// within the file or record.
	ContentLocations []*ContentLocation `protobuf:"bytes,7,rep,name=content_locations,json=contentLocations,proto3" json:"content_locations,omitempty"`
	// Information about the container where this finding occurred, if available.
	Container *Container `protobuf:"bytes,8,opt,name=container,proto3" json:"container,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{11}
}

func (x *Location) GetByteRange() *Range {
	if x != nil {
		return x.ByteRange
	}
	return nil
}

func (x *Location) GetCodepointRange() *Range {
	if x != nil {
		return x.CodepointRange
	}
	return nil
}

func (x *Location) GetContentLocations() []*ContentLocation {
	if x != nil {
		return x.ContentLocations
	}
	return nil
}

func (x *Location) GetContainer() *Container {
	if x != nil {
		return x.Container
	}
	return nil
}

// Precise location of the finding within a document, record, image, or metadata
// container.
type ContentLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the container where the finding is located.
	// The top level name is the source file name or table name. Names of some
	// common storage containers are formatted as follows:
	//
	// * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
	// * Cloud Storage files: `gs://{bucket}/{path}`
	// * Datastore namespace: {namespace}
	//
	// Nested names could be absent if the embedded object has no string
	// identifier (for example, an image contained within a document).
	ContainerName string `protobuf:"bytes,1,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	// Type of the container within the file with location of the finding.
	//
	// Types that are assignable to Location:
	//
	//	*ContentLocation_RecordLocation
	//	*ContentLocation_ImageLocation
	//	*ContentLocation_DocumentLocation
	//	*ContentLocation_MetadataLocation
	Location isContentLocation_Location `protobuf_oneof:"location"`
	// Finding container modification timestamp, if applicable. For Cloud Storage,
	// this field contains the last file modification timestamp. For a BigQuery
	// table, this field contains the last_modified_time property. For Datastore,
	// this field isn't populated.
	ContainerTimestamp *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=container_timestamp,json=containerTimestamp,proto3" json:"container_timestamp,omitempty"`
	// Finding container version, if available
	// ("generation" for Cloud Storage).
	ContainerVersion string `protobuf:"bytes,7,opt,name=container_version,json=containerVersion,proto3" json:"container_version,omitempty"`
}

func (x *ContentLocation) Reset() {
	*x = ContentLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentLocation) ProtoMessage() {}

func (x *ContentLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentLocation.ProtoReflect.Descriptor instead.
func (*ContentLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{12}
}

func (x *ContentLocation) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (m *ContentLocation) GetLocation() isContentLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *ContentLocation) GetRecordLocation() *RecordLocation {
	if x, ok := x.GetLocation().(*ContentLocation_RecordLocation); ok {
		return x.RecordLocation
	}
	return nil
}

func (x *ContentLocation) GetImageLocation() *ImageLocation {
	if x, ok := x.GetLocation().(*ContentLocation_ImageLocation); ok {
		return x.ImageLocation
	}
	return nil
}

func (x *ContentLocation) GetDocumentLocation() *DocumentLocation {
	if x, ok := x.GetLocation().(*ContentLocation_DocumentLocation); ok {
		return x.DocumentLocation
	}
	return nil
}

func (x *ContentLocation) GetMetadataLocation() *MetadataLocation {
	if x, ok := x.GetLocation().(*ContentLocation_MetadataLocation); ok {
		return x.MetadataLocation
	}
	return nil
}

func (x *ContentLocation) GetContainerTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.ContainerTimestamp
	}
	return nil
}

func (x *ContentLocation) GetContainerVersion() string {
	if x != nil {
		return x.ContainerVersion
	}
	return ""
}

type isContentLocation_Location interface {
	isContentLocation_Location()
}

type ContentLocation_RecordLocation struct {
	// Location within a row or record of a database table.
	RecordLocation *RecordLocation `protobuf:"bytes,2,opt,name=record_location,json=recordLocation,proto3,oneof"`
}

type ContentLocation_ImageLocation struct {
	// Location within an image's pixels.
	ImageLocation *ImageLocation `protobuf:"bytes,3,opt,name=image_location,json=imageLocation,proto3,oneof"`
}

type ContentLocation_DocumentLocation struct {
	// Location data for document files.
	DocumentLocation *DocumentLocation `protobuf:"bytes,5,opt,name=document_location,json=documentLocation,proto3,oneof"`
}

type ContentLocation_MetadataLocation struct {
	// Location within the metadata for inspected content.
	MetadataLocation *MetadataLocation `protobuf:"bytes,8,opt,name=metadata_location,json=metadataLocation,proto3,oneof"`
}

func (*ContentLocation_RecordLocation) isContentLocation_Location() {}

func (*ContentLocation_ImageLocation) isContentLocation_Location() {}

func (*ContentLocation_DocumentLocation) isContentLocation_Location() {}

func (*ContentLocation_MetadataLocation) isContentLocation_Location() {}

// Metadata Location
type MetadataLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of metadata containing the finding.
	Type MetadataType `protobuf:"varint,1,opt,name=type,proto3,enum=google.privacy.dlp.v2.MetadataType" json:"type,omitempty"`
	// Label of the piece of metadata containing the finding, for example -
	// latitude, author, caption.
	//
	// Types that are assignable to Label:
	//
	//	*MetadataLocation_StorageLabel
	Label isMetadataLocation_Label `protobuf_oneof:"label"`
}

func (x *MetadataLocation) Reset() {
	*x = MetadataLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataLocation) ProtoMessage() {}

func (x *MetadataLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataLocation.ProtoReflect.Descriptor instead.
func (*MetadataLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{13}
}

func (x *MetadataLocation) GetType() MetadataType {
	if x != nil {
		return x.Type
	}
	return MetadataType_METADATATYPE_UNSPECIFIED
}

func (m *MetadataLocation) GetLabel() isMetadataLocation_Label {
	if m != nil {
		return m.Label
	}
	return nil
}

func (x *MetadataLocation) GetStorageLabel() *StorageMetadataLabel {
	if x, ok := x.GetLabel().(*MetadataLocation_StorageLabel); ok {
		return x.StorageLabel
	}
	return nil
}

type isMetadataLocation_Label interface {
	isMetadataLocation_Label()
}

type MetadataLocation_StorageLabel struct {
	// Storage metadata.
	StorageLabel *StorageMetadataLabel `protobuf:"bytes,3,opt,name=storage_label,json=storageLabel,proto3,oneof"`
}

func (*MetadataLocation_StorageLabel) isMetadataLocation_Label() {}

// Storage metadata label to indicate which metadata entry contains findings.
type StorageMetadataLabel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Label name.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *StorageMetadataLabel) Reset() {
	*x = StorageMetadataLabel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageMetadataLabel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageMetadataLabel) ProtoMessage() {}

func (x *StorageMetadataLabel) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageMetadataLabel.ProtoReflect.Descriptor instead.
func (*StorageMetadataLabel) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{14}
}

func (x *StorageMetadataLabel) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Location of a finding within a document.
type DocumentLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offset of the line, from the beginning of the file, where the finding
	// is located.
	FileOffset int64 `protobuf:"varint,1,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
}

func (x *DocumentLocation) Reset() {
	*x = DocumentLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentLocation) ProtoMessage() {}

func (x *DocumentLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentLocation.ProtoReflect.Descriptor instead.
func (*DocumentLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{15}
}

func (x *DocumentLocation) GetFileOffset() int64 {
	if x != nil {
		return x.FileOffset
	}
	return 0
}

// Location of a finding within a row or record.
type RecordLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the finding.
	RecordKey *RecordKey `protobuf:"bytes,1,opt,name=record_key,json=recordKey,proto3" json:"record_key,omitempty"`
	// Field id of the field containing the finding.
	FieldId *FieldId `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Location within a `ContentItem.Table`.
	TableLocation *TableLocation `protobuf:"bytes,3,opt,name=table_location,json=tableLocation,proto3" json:"table_location,omitempty"`
}

func (x *RecordLocation) Reset() {
	*x = RecordLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordLocation) ProtoMessage() {}

func (x *RecordLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordLocation.ProtoReflect.Descriptor instead.
func (*RecordLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{16}
}

func (x *RecordLocation) GetRecordKey() *RecordKey {
	if x != nil {
		return x.RecordKey
	}
	return nil
}

func (x *RecordLocation) GetFieldId() *FieldId {
	if x != nil {
		return x.FieldId
	}
	return nil
}

func (x *RecordLocation) GetTableLocation() *TableLocation {
	if x != nil {
		return x.TableLocation
	}
	return nil
}

// Location of a finding within a table.
type TableLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The zero-based index of the row where the finding is located. Only
	// populated for resources that have a natural ordering, not BigQuery. In
	// BigQuery, to identify the row a finding came from, populate
	// BigQueryOptions.identifying_fields with your primary key column names and
	// when you store the findings the value of those columns will be stored
	// inside of Finding.
	RowIndex int64 `protobuf:"varint,1,opt,name=row_index,json=rowIndex,proto3" json:"row_index,omitempty"`
}

func (x *TableLocation) Reset() {
	*x = TableLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableLocation) ProtoMessage() {}

func (x *TableLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableLocation.ProtoReflect.Descriptor instead.
func (*TableLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{17}
}

func (x *TableLocation) GetRowIndex() int64 {
	if x != nil {
		return x.RowIndex
	}
	return 0
}

// Represents a container that may contain DLP findings.
// Examples of a container include a file, table, or database record.
type Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container type, for example BigQuery or Cloud Storage.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Project where the finding was found.
	// Can be different from the project that owns the finding.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A string representation of the full container name.
	// Examples:
	// - BigQuery: 'Project:DataSetId.TableId'
	// - Cloud Storage: 'gs://Bucket/folders/filename.txt'
	FullPath string `protobuf:"bytes,3,opt,name=full_path,json=fullPath,proto3" json:"full_path,omitempty"`
	// The root of the container.
	// Examples:
	//
	//   - For BigQuery table `project_id:dataset_id.table_id`, the root is
	//     `dataset_id`
	//   - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
	//     is `gs://bucket`
	RootPath string `protobuf:"bytes,4,opt,name=root_path,json=rootPath,proto3" json:"root_path,omitempty"`
	// The rest of the path after the root.
	// Examples:
	//
	//   - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
	//     `table_id`
	//   - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
	//     path is `folder/filename.txt`
	RelativePath string `protobuf:"bytes,5,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// Findings container modification timestamp, if applicable. For Cloud
	// Storage, this field contains the last file modification timestamp. For a
	// BigQuery table, this field contains the last_modified_time property. For
	// Datastore, this field isn't populated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Findings container version, if available
	// ("generation" for Cloud Storage).
	Version string `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Container) Reset() {
	*x = Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{18}
}

func (x *Container) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Container) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Container) GetFullPath() string {
	if x != nil {
		return x.FullPath
	}
	return ""
}

func (x *Container) GetRootPath() string {
	if x != nil {
		return x.RootPath
	}
	return ""
}

func (x *Container) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *Container) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Container) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Generic half-open interval [start, end)
type Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the first character of the range (inclusive).
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// Index of the last character of the range (exclusive).
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Range) Reset() {
	*x = Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{19}
}

func (x *Range) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Range) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

// Location of the finding within an image.
type ImageLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bounding boxes locating the pixels within the image containing the finding.
	BoundingBoxes []*BoundingBox `protobuf:"bytes,1,rep,name=bounding_boxes,json=boundingBoxes,proto3" json:"bounding_boxes,omitempty"`
}

func (x *ImageLocation) Reset() {
	*x = ImageLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageLocation) ProtoMessage() {}

func (x *ImageLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageLocation.ProtoReflect.Descriptor instead.
func (*ImageLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{20}
}

func (x *ImageLocation) GetBoundingBoxes() []*BoundingBox {
	if x != nil {
		return x.BoundingBoxes
	}
	return nil
}

// Bounding box encompassing detected text within an image.
type BoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Top coordinate of the bounding box. (0,0) is upper left.
	Top int32 `protobuf:"varint,1,opt,name=top,proto3" json:"top,omitempty"`
	// Left coordinate of the bounding box. (0,0) is upper left.
	Left int32 `protobuf:"varint,2,opt,name=left,proto3" json:"left,omitempty"`
	// Width of the bounding box in pixels.
	Width int32 `protobuf:"varint,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the bounding box in pixels.
	Height int32 `protobuf:"varint,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *BoundingBox) Reset() {
	*x = BoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingBox) ProtoMessage() {}

func (x *BoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingBox.ProtoReflect.Descriptor instead.
func (*BoundingBox) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{21}
}

func (x *BoundingBox) GetTop() int32 {
	if x != nil {
		return x.Top
	}
	return 0
}

func (x *BoundingBox) GetLeft() int32 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *BoundingBox) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *BoundingBox) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// Request to search for potentially sensitive info in an image and redact it
// by covering it with a colored rectangle.
type RedactImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,8,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The configuration for specifying what content to redact from images.
	ImageRedactionConfigs []*RedactImageRequest_ImageRedactionConfig `protobuf:"bytes,5,rep,name=image_redaction_configs,json=imageRedactionConfigs,proto3" json:"image_redaction_configs,omitempty"`
	// Whether the response should include findings along with the redacted
	// image.
	IncludeFindings bool `protobuf:"varint,6,opt,name=include_findings,json=includeFindings,proto3" json:"include_findings,omitempty"`
	// The content must be PNG, JPEG, SVG or BMP.
	ByteItem *ByteContentItem `protobuf:"bytes,7,opt,name=byte_item,json=byteItem,proto3" json:"byte_item,omitempty"`
}

func (x *RedactImageRequest) Reset() {
	*x = RedactImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageRequest) ProtoMessage() {}

func (x *RedactImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageRequest.ProtoReflect.Descriptor instead.
func (*RedactImageRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{22}
}

func (x *RedactImageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RedactImageRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

func (x *RedactImageRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *RedactImageRequest) GetImageRedactionConfigs() []*RedactImageRequest_ImageRedactionConfig {
	if x != nil {
		return x.ImageRedactionConfigs
	}
	return nil
}

func (x *RedactImageRequest) GetIncludeFindings() bool {
	if x != nil {
		return x.IncludeFindings
	}
	return false
}

func (x *RedactImageRequest) GetByteItem() *ByteContentItem {
	if x != nil {
		return x.ByteItem
	}
	return nil
}

// Represents a color in the RGB color space.
type Color struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of red in the color as a value in the interval [0, 1].
	Red float32 `protobuf:"fixed32,1,opt,name=red,proto3" json:"red,omitempty"`
	// The amount of green in the color as a value in the interval [0, 1].
	Green float32 `protobuf:"fixed32,2,opt,name=green,proto3" json:"green,omitempty"`
	// The amount of blue in the color as a value in the interval [0, 1].
	Blue float32 `protobuf:"fixed32,3,opt,name=blue,proto3" json:"blue,omitempty"`
}

func (x *Color) Reset() {
	*x = Color{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Color) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Color) ProtoMessage() {}

func (x *Color) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Color.ProtoReflect.Descriptor instead.
func (*Color) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{23}
}

func (x *Color) GetRed() float32 {
	if x != nil {
		return x.Red
	}
	return 0
}

func (x *Color) GetGreen() float32 {
	if x != nil {
		return x.Green
	}
	return 0
}

func (x *Color) GetBlue() float32 {
	if x != nil {
		return x.Blue
	}
	return 0
}

// Results of redacting an image.
type RedactImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The redacted image. The type will be the same as the original image.
	RedactedImage []byte `protobuf:"bytes,1,opt,name=redacted_image,json=redactedImage,proto3" json:"redacted_image,omitempty"`
	// If an image was being inspected and the InspectConfig's include_quote was
	// set to true, then this field will include all text, if any, that was found
	// in the image.
	ExtractedText string `protobuf:"bytes,2,opt,name=extracted_text,json=extractedText,proto3" json:"extracted_text,omitempty"`
	// The findings. Populated when include_findings in the request is true.
	InspectResult *InspectResult `protobuf:"bytes,3,opt,name=inspect_result,json=inspectResult,proto3" json:"inspect_result,omitempty"`
}

func (x *RedactImageResponse) Reset() {
	*x = RedactImageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageResponse) ProtoMessage() {}

func (x *RedactImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageResponse.ProtoReflect.Descriptor instead.
func (*RedactImageResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{24}
}

func (x *RedactImageResponse) GetRedactedImage() []byte {
	if x != nil {
		return x.RedactedImage
	}
	return nil
}

func (x *RedactImageResponse) GetExtractedText() string {
	if x != nil {
		return x.ExtractedText
	}
	return ""
}

func (x *RedactImageResponse) GetInspectResult() *InspectResult {
	if x != nil {
		return x.InspectResult
	}
	return nil
}

// Request to de-identify a ContentItem.
type DeidentifyContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the de-identification of the content item.
	// Items specified here will override the template referenced by the
	// deidentify_template_name argument.
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=deidentify_config,json=deidentifyConfig,proto3" json:"deidentify_config,omitempty"`
	// Configuration for the inspector.
	// Items specified here will override the template referenced by the
	// inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to de-identify. Will be treated as text.
	//
	// This value must be of type
	// [Table][google.privacy.dlp.v2.Table] if your
	// [deidentify_config][google.privacy.dlp.v2.DeidentifyContentRequest.deidentify_config]
	// is a
	// [RecordTransformations][google.privacy.dlp.v2.RecordTransformations]
	// object.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Template to use. Any configuration directly specified in
	// deidentify_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	DeidentifyTemplateName string `protobuf:"bytes,6,opt,name=deidentify_template_name,json=deidentifyTemplateName,proto3" json:"deidentify_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *DeidentifyContentRequest) Reset() {
	*x = DeidentifyContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyContentRequest) ProtoMessage() {}

func (x *DeidentifyContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyContentRequest.ProtoReflect.Descriptor instead.
func (*DeidentifyContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{25}
}

func (x *DeidentifyContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *DeidentifyContentRequest) GetDeidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.DeidentifyConfig
	}
	return nil
}

func (x *DeidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *DeidentifyContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *DeidentifyContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *DeidentifyContentRequest) GetDeidentifyTemplateName() string {
	if x != nil {
		return x.DeidentifyTemplateName
	}
	return ""
}

func (x *DeidentifyContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of de-identifying a ContentItem.
type DeidentifyContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The de-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// An overview of the changes that were made on the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *DeidentifyContentResponse) Reset() {
	*x = DeidentifyContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyContentResponse) ProtoMessage() {}

func (x *DeidentifyContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyContentResponse.ProtoReflect.Descriptor instead.
func (*DeidentifyContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{26}
}

func (x *DeidentifyContentResponse) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *DeidentifyContentResponse) GetOverview() *TransformationOverview {
	if x != nil {
		return x.Overview
	}
	return nil
}

// Request to re-identify an item.
type ReidentifyContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the re-identification of the content item.
	// This field shares the same proto message type that is used for
	// de-identification, however its usage here is for the reversal of the
	// previous de-identification. Re-identification is performed by examining
	// the transformations used to de-identify the items and executing the
	// reverse. This requires that only reversible transformations
	// be provided here. The reversible transformations are:
	//
	//   - `CryptoDeterministicConfig`
	//   - `CryptoReplaceFfxFpeConfig`
	ReidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=reidentify_config,json=reidentifyConfig,proto3" json:"reidentify_config,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to re-identify. Will be treated as text.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Template to use. References an instance of `DeidentifyTemplate`.
	// Any configuration directly specified in `reidentify_config` or
	// `inspect_config` will override those set in the template. The
	// `DeidentifyTemplate` used must include only reversible transformations.
	// Singular fields that are set in this request will replace their
	// corresponding fields in the template. Repeated fields are appended.
	// Singular sub-messages and groups are recursively merged.
	ReidentifyTemplateName string `protobuf:"bytes,6,opt,name=reidentify_template_name,json=reidentifyTemplateName,proto3" json:"reidentify_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ReidentifyContentRequest) Reset() {
	*x = ReidentifyContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReidentifyContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReidentifyContentRequest) ProtoMessage() {}

func (x *ReidentifyContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReidentifyContentRequest.ProtoReflect.Descriptor instead.
func (*ReidentifyContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{27}
}

func (x *ReidentifyContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReidentifyContentRequest) GetReidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.ReidentifyConfig
	}
	return nil
}

func (x *ReidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *ReidentifyContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *ReidentifyContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *ReidentifyContentRequest) GetReidentifyTemplateName() string {
	if x != nil {
		return x.ReidentifyTemplateName
	}
	return ""
}

func (x *ReidentifyContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of re-identifying an item.
type ReidentifyContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The re-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// An overview of the changes that were made to the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *ReidentifyContentResponse) Reset() {
	*x = ReidentifyContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReidentifyContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReidentifyContentResponse) ProtoMessage() {}

func (x *ReidentifyContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReidentifyContentResponse.ProtoReflect.Descriptor instead.
func (*ReidentifyContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{28}
}

func (x *ReidentifyContentResponse) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *ReidentifyContentResponse) GetOverview() *TransformationOverview {
	if x != nil {
		return x.Overview
	}
	return nil
}

// Request to search for potentially sensitive info in a ContentItem.
type InspectContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the inspector. What specified here will override
	// the template referenced by the inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to inspect.
	Item *ContentItem `protobuf:"bytes,3,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,4,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *InspectContentRequest) Reset() {
	*x = InspectContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectContentRequest) ProtoMessage() {}

func (x *InspectContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectContentRequest.ProtoReflect.Descriptor instead.
func (*InspectContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{29}
}

func (x *InspectContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InspectContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *InspectContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *InspectContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *InspectContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of inspecting an item.
type InspectContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The findings.
	Result *InspectResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *InspectContentResponse) Reset() {
	*x = InspectContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectContentResponse) ProtoMessage() {}

func (x *InspectContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectContentResponse.ProtoReflect.Descriptor instead.
func (*InspectContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{30}
}

func (x *InspectContentResponse) GetResult() *InspectResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// Cloud repository for storing output.
type OutputStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output storage types.
	//
	// Types that are assignable to Type:
	//
	//	*OutputStorageConfig_Table
	Type isOutputStorageConfig_Type `protobuf_oneof:"type"`
	// Schema used for writing the findings for Inspect jobs. This field is only
	// used for Inspect and must be unspecified for Risk jobs. Columns are derived
	// from the `Finding` object. If appending to an existing table, any columns
	// from the predefined schema that are missing will be added. No columns in
	// the existing table will be deleted.
	//
	// If unspecified, then all available columns will be used for a new table or
	// an (existing) table with no schema, and no changes will be made to an
	// existing table that has a schema.
	// Only for use with external storage.
	OutputSchema OutputStorageConfig_OutputSchema `protobuf:"varint,3,opt,name=output_schema,json=outputSchema,proto3,enum=google.privacy.dlp.v2.OutputStorageConfig_OutputSchema" json:"output_schema,omitempty"`
}

func (x *OutputStorageConfig) Reset() {
	*x = OutputStorageConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputStorageConfig) ProtoMessage() {}

func (x *OutputStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputStorageConfig.ProtoReflect.Descriptor instead.
func (*OutputStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{31}
}

func (m *OutputStorageConfig) GetType() isOutputStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *OutputStorageConfig) GetTable() *BigQueryTable {
	if x, ok := x.GetType().(*OutputStorageConfig_Table); ok {
		return x.Table
	}
	return nil
}

func (x *OutputStorageConfig) GetOutputSchema() OutputStorageConfig_OutputSchema {
	if x != nil {
		return x.OutputSchema
	}
	return OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED
}

type isOutputStorageConfig_Type interface {
	isOutputStorageConfig_Type()
}

type OutputStorageConfig_Table struct {
	// Store findings in an existing table or a new table in an existing
	// dataset. If table_id is not set a new one will be generated
	// for you with the following format:
	// dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
	// for generating the date details.
	//
	// For Inspect, each column in an existing output table must have the same
	// name, type, and mode of a field in the `Finding` object.
	//
	// For Risk, an existing output table should be the output of a previous
	// Risk analysis job run on the same source table, with the same privacy
	// metric and quasi-identifiers. Risk jobs that analyze the same table but
	// compute a different privacy metric, or use different sets of
	// quasi-identifiers, cannot store their results in the same table.
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,proto3,oneof"`
}

func (*OutputStorageConfig_Table) isOutputStorageConfig_Type() {}

// Statistics regarding a specific InfoType.
type InfoTypeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of finding this stat is for.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Number of findings for this infoType.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *InfoTypeStats) Reset() {
	*x = InfoTypeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeStats) ProtoMessage() {}

func (x *InfoTypeStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeStats.ProtoReflect.Descriptor instead.
func (*InfoTypeStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{32}
}

func (x *InfoTypeStats) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *InfoTypeStats) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// The results of an inspect DataSource job.
type InspectDataSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration used for this job.
	RequestedOptions *InspectDataSourceDetails_RequestedOptions `protobuf:"bytes,2,opt,name=requested_options,json=requestedOptions,proto3" json:"requested_options,omitempty"`
	// A summary of the outcome of this inspection job.
	Result *InspectDataSourceDetails_Result `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *InspectDataSourceDetails) Reset() {
	*x = InspectDataSourceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails) ProtoMessage() {}

func (x *InspectDataSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{33}
}

func (x *InspectDataSourceDetails) GetRequestedOptions() *InspectDataSourceDetails_RequestedOptions {
	if x != nil {
		return x.RequestedOptions
	}
	return nil
}

func (x *InspectDataSourceDetails) GetResult() *InspectDataSourceDetails_Result {
	if x != nil {
		return x.Result
	}
	return nil
}

// The schema of data to be saved to the BigQuery table when the
// `DataProfileAction` is enabled.
type DataProfileBigQueryRowSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data profile type.
	//
	// Types that are assignable to DataProfile:
	//
	//	*DataProfileBigQueryRowSchema_TableProfile
	//	*DataProfileBigQueryRowSchema_ColumnProfile
	DataProfile isDataProfileBigQueryRowSchema_DataProfile `protobuf_oneof:"data_profile"`
}

func (x *DataProfileBigQueryRowSchema) Reset() {
	*x = DataProfileBigQueryRowSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileBigQueryRowSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileBigQueryRowSchema) ProtoMessage() {}

func (x *DataProfileBigQueryRowSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileBigQueryRowSchema.ProtoReflect.Descriptor instead.
func (*DataProfileBigQueryRowSchema) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{34}
}

func (m *DataProfileBigQueryRowSchema) GetDataProfile() isDataProfileBigQueryRowSchema_DataProfile {
	if m != nil {
		return m.DataProfile
	}
	return nil
}

func (x *DataProfileBigQueryRowSchema) GetTableProfile() *TableDataProfile {
	if x, ok := x.GetDataProfile().(*DataProfileBigQueryRowSchema_TableProfile); ok {
		return x.TableProfile
	}
	return nil
}

func (x *DataProfileBigQueryRowSchema) GetColumnProfile() *ColumnDataProfile {
	if x, ok := x.GetDataProfile().(*DataProfileBigQueryRowSchema_ColumnProfile); ok {
		return x.ColumnProfile
	}
	return nil
}

type isDataProfileBigQueryRowSchema_DataProfile interface {
	isDataProfileBigQueryRowSchema_DataProfile()
}

type DataProfileBigQueryRowSchema_TableProfile struct {
	// Table data profile column
	TableProfile *TableDataProfile `protobuf:"bytes,1,opt,name=table_profile,json=tableProfile,proto3,oneof"`
}

type DataProfileBigQueryRowSchema_ColumnProfile struct {
	// Column data profile column
	ColumnProfile *ColumnDataProfile `protobuf:"bytes,2,opt,name=column_profile,json=columnProfile,proto3,oneof"`
}

func (*DataProfileBigQueryRowSchema_TableProfile) isDataProfileBigQueryRowSchema_DataProfile() {}

func (*DataProfileBigQueryRowSchema_ColumnProfile) isDataProfileBigQueryRowSchema_DataProfile() {}

// Statistics related to processing hybrid inspect requests.
type HybridInspectStatistics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of hybrid inspection requests processed within this job.
	ProcessedCount int64 `protobuf:"varint,1,opt,name=processed_count,json=processedCount,proto3" json:"processed_count,omitempty"`
	// The number of hybrid inspection requests aborted because the job ran
	// out of quota or was ended before they could be processed.
	AbortedCount int64 `protobuf:"varint,2,opt,name=aborted_count,json=abortedCount,proto3" json:"aborted_count,omitempty"`
	// The number of hybrid requests currently being processed. Only populated
	// when called via method `getDlpJob`.
	// A burst of traffic may cause hybrid inspect requests to be enqueued.
	// Processing will take place as quickly as possible, but resource limitations
	// may impact how long a request is enqueued for.
	PendingCount int64 `protobuf:"varint,3,opt,name=pending_count,json=pendingCount,proto3" json:"pending_count,omitempty"`
}

func (x *HybridInspectStatistics) Reset() {
	*x = HybridInspectStatistics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectStatistics) ProtoMessage() {}

func (x *HybridInspectStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectStatistics.ProtoReflect.Descriptor instead.
func (*HybridInspectStatistics) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{35}
}

func (x *HybridInspectStatistics) GetProcessedCount() int64 {
	if x != nil {
		return x.ProcessedCount
	}
	return 0
}

func (x *HybridInspectStatistics) GetAbortedCount() int64 {
	if x != nil {
		return x.AbortedCount
	}
	return 0
}

func (x *HybridInspectStatistics) GetPendingCount() int64 {
	if x != nil {
		return x.PendingCount
	}
	return 0
}

// The results of an [Action][google.privacy.dlp.v2.Action].
type ActionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Summary of what occurred in the actions.
	//
	// Types that are assignable to Details:
	//
	//	*ActionDetails_DeidentifyDetails
	Details isActionDetails_Details `protobuf_oneof:"details"`
}

func (x *ActionDetails) Reset() {
	*x = ActionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionDetails) ProtoMessage() {}

func (x *ActionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionDetails.ProtoReflect.Descriptor instead.
func (*ActionDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{36}
}

func (m *ActionDetails) GetDetails() isActionDetails_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *ActionDetails) GetDeidentifyDetails() *DeidentifyDataSourceDetails {
	if x, ok := x.GetDetails().(*ActionDetails_DeidentifyDetails); ok {
		return x.DeidentifyDetails
	}
	return nil
}

type isActionDetails_Details interface {
	isActionDetails_Details()
}

type ActionDetails_DeidentifyDetails struct {
	// Outcome of a de-identification action.
	DeidentifyDetails *DeidentifyDataSourceDetails `protobuf:"bytes,1,opt,name=deidentify_details,json=deidentifyDetails,proto3,oneof"`
}

func (*ActionDetails_DeidentifyDetails) isActionDetails_Details() {}

// Summary of what was modified during a transformation.
type DeidentifyDataSourceStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,1,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
	// Number of successfully applied transformations.
	TransformationCount int64 `protobuf:"varint,2,opt,name=transformation_count,json=transformationCount,proto3" json:"transformation_count,omitempty"`
	// Number of errors encountered while trying to apply transformations.
	TransformationErrorCount int64 `protobuf:"varint,3,opt,name=transformation_error_count,json=transformationErrorCount,proto3" json:"transformation_error_count,omitempty"`
}

func (x *DeidentifyDataSourceStats) Reset() {
	*x = DeidentifyDataSourceStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyDataSourceStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyDataSourceStats) ProtoMessage() {}

func (x *DeidentifyDataSourceStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyDataSourceStats.ProtoReflect.Descriptor instead.
func (*DeidentifyDataSourceStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{37}
}

func (x *DeidentifyDataSourceStats) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

func (x *DeidentifyDataSourceStats) GetTransformationCount() int64 {
	if x != nil {
		return x.TransformationCount
	}
	return 0
}

func (x *DeidentifyDataSourceStats) GetTransformationErrorCount() int64 {
	if x != nil {
		return x.TransformationErrorCount
	}
	return 0
}

// The results of a [Deidentify][google.privacy.dlp.v2.Action.Deidentify] action
// from an inspect job.
type DeidentifyDataSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// De-identification config used for the request.
	RequestedOptions *DeidentifyDataSourceDetails_RequestedDeidentifyOptions `protobuf:"bytes,1,opt,name=requested_options,json=requestedOptions,proto3" json:"requested_options,omitempty"`
	// Stats about the de-identification operation.
	DeidentifyStats *DeidentifyDataSourceStats `protobuf:"bytes,2,opt,name=deidentify_stats,json=deidentifyStats,proto3" json:"deidentify_stats,omitempty"`
}

func (x *DeidentifyDataSourceDetails) Reset() {
	*x = DeidentifyDataSourceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyDataSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyDataSourceDetails) ProtoMessage() {}

func (x *DeidentifyDataSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyDataSourceDetails.ProtoReflect.Descriptor instead.
func (*DeidentifyDataSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{38}
}

func (x *DeidentifyDataSourceDetails) GetRequestedOptions() *DeidentifyDataSourceDetails_RequestedDeidentifyOptions {
	if x != nil {
		return x.RequestedOptions
	}
	return nil
}

func (x *DeidentifyDataSourceDetails) GetDeidentifyStats() *DeidentifyDataSourceStats {
	if x != nil {
		return x.DeidentifyStats
	}
	return nil
}

// InfoType description.
type InfoTypeDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal name of the infoType.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable form of the infoType name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Which parts of the API supports this InfoType.
	SupportedBy []InfoTypeSupportedBy `protobuf:"varint,3,rep,packed,name=supported_by,json=supportedBy,proto3,enum=google.privacy.dlp.v2.InfoTypeSupportedBy" json:"supported_by,omitempty"`
	// Description of the infotype. Translated when language is provided in the
	// request.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// A list of available versions for the infotype.
	Versions []*VersionDescription `protobuf:"bytes,9,rep,name=versions,proto3" json:"versions,omitempty"`
	// The category of the infoType.
	Categories []*InfoTypeCategory `protobuf:"bytes,10,rep,name=categories,proto3" json:"categories,omitempty"`
	// The default sensitivity of the infoType.
	SensitivityScore *SensitivityScore `protobuf:"bytes,11,opt,name=sensitivity_score,json=sensitivityScore,proto3" json:"sensitivity_score,omitempty"`
}

func (x *InfoTypeDescription) Reset() {
	*x = InfoTypeDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeDescription) ProtoMessage() {}

func (x *InfoTypeDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeDescription.ProtoReflect.Descriptor instead.
func (*InfoTypeDescription) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{39}
}

func (x *InfoTypeDescription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InfoTypeDescription) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InfoTypeDescription) GetSupportedBy() []InfoTypeSupportedBy {
	if x != nil {
		return x.SupportedBy
	}
	return nil
}

func (x *InfoTypeDescription) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InfoTypeDescription) GetVersions() []*VersionDescription {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *InfoTypeDescription) GetCategories() []*InfoTypeCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *InfoTypeDescription) GetSensitivityScore() *SensitivityScore {
	if x != nil {
		return x.SensitivityScore
	}
	return nil
}

// Classification of infoTypes to organize them according to geographic
// location, industry, and data type.
type InfoTypeCategory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Categories of infotypes.
	//
	// Types that are assignable to Category:
	//
	//	*InfoTypeCategory_LocationCategory_
	//	*InfoTypeCategory_IndustryCategory_
	//	*InfoTypeCategory_TypeCategory_
	Category isInfoTypeCategory_Category `protobuf_oneof:"category"`
}

func (x *InfoTypeCategory) Reset() {
	*x = InfoTypeCategory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeCategory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeCategory) ProtoMessage() {}

func (x *InfoTypeCategory) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeCategory.ProtoReflect.Descriptor instead.
func (*InfoTypeCategory) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40}
}

func (m *InfoTypeCategory) GetCategory() isInfoTypeCategory_Category {
	if m != nil {
		return m.Category
	}
	return nil
}

func (x *InfoTypeCategory) GetLocationCategory() InfoTypeCategory_LocationCategory {
	if x, ok := x.GetCategory().(*InfoTypeCategory_LocationCategory_); ok {
		return x.LocationCategory
	}
	return InfoTypeCategory_LOCATION_UNSPECIFIED
}

func (x *InfoTypeCategory) GetIndustryCategory() InfoTypeCategory_IndustryCategory {
	if x, ok := x.GetCategory().(*InfoTypeCategory_IndustryCategory_); ok {
		return x.IndustryCategory
	}
	return InfoTypeCategory_INDUSTRY_UNSPECIFIED
}

func (x *InfoTypeCategory) GetTypeCategory() InfoTypeCategory_TypeCategory {
	if x, ok := x.GetCategory().(*InfoTypeCategory_TypeCategory_); ok {
		return x.TypeCategory
	}
	return InfoTypeCategory_TYPE_UNSPECIFIED
}

type isInfoTypeCategory_Category interface {
	isInfoTypeCategory_Category()
}

type InfoTypeCategory_LocationCategory_ struct {
	// The region or country that issued the ID or document represented by the
	// infoType.
	LocationCategory InfoTypeCategory_LocationCategory `protobuf:"varint,1,opt,name=location_category,json=locationCategory,proto3,enum=google.privacy.dlp.v2.InfoTypeCategory_LocationCategory,oneof"`
}

type InfoTypeCategory_IndustryCategory_ struct {
	// The group of relevant businesses where this infoType is commonly used
	IndustryCategory InfoTypeCategory_IndustryCategory `protobuf:"varint,2,opt,name=industry_category,json=industryCategory,proto3,enum=google.privacy.dlp.v2.InfoTypeCategory_IndustryCategory,oneof"`
}

type InfoTypeCategory_TypeCategory_ struct {
	// The class of identifiers where this infoType belongs
	TypeCategory InfoTypeCategory_TypeCategory `protobuf:"varint,3,opt,name=type_category,json=typeCategory,proto3,enum=google.privacy.dlp.v2.InfoTypeCategory_TypeCategory,oneof"`
}

func (*InfoTypeCategory_LocationCategory_) isInfoTypeCategory_Category() {}

func (*InfoTypeCategory_IndustryCategory_) isInfoTypeCategory_Category() {}

func (*InfoTypeCategory_TypeCategory_) isInfoTypeCategory_Category() {}

// Details about each available version for an infotype.
type VersionDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the version
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Description of the version.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *VersionDescription) Reset() {
	*x = VersionDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionDescription) ProtoMessage() {}

func (x *VersionDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionDescription.ProtoReflect.Descriptor instead.
func (*VersionDescription) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41}
}

func (x *VersionDescription) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionDescription) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Request for the list of infoTypes.
type ListInfoTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name.
	//
	// The format of this value is as follows:
	//
	//	locations/<var>LOCATION_ID</var>
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// BCP-47 language code for localized infoType friendly
	// names. If omitted, or if localized strings are not available,
	// en-US strings will be returned.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// filter to only return infoTypes supported by certain parts of the
	// API. Defaults to supported_by=INSPECT.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,3,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListInfoTypesRequest) Reset() {
	*x = ListInfoTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInfoTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInfoTypesRequest) ProtoMessage() {}

func (x *ListInfoTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInfoTypesRequest.ProtoReflect.Descriptor instead.
func (*ListInfoTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{42}
}

func (x *ListInfoTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInfoTypesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListInfoTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInfoTypesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response to the ListInfoTypes request.
type ListInfoTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of sensitive infoTypes.
	InfoTypes []*InfoTypeDescription `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *ListInfoTypesResponse) Reset() {
	*x = ListInfoTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInfoTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInfoTypesResponse) ProtoMessage() {}

func (x *ListInfoTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInfoTypesResponse.ProtoReflect.Descriptor instead.
func (*ListInfoTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{43}
}

func (x *ListInfoTypesResponse) GetInfoTypes() []*InfoTypeDescription {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// Configuration for a risk analysis job. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-risk-analysis
// to learn more.
type RiskAnalysisJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Privacy metric to compute.
	PrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=privacy_metric,json=privacyMetric,proto3" json:"privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	SourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	// Actions to execute at the completion of the job. Are executed in the order
	// provided.
	Actions []*Action `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *RiskAnalysisJobConfig) Reset() {
	*x = RiskAnalysisJobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RiskAnalysisJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RiskAnalysisJobConfig) ProtoMessage() {}

func (x *RiskAnalysisJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RiskAnalysisJobConfig.ProtoReflect.Descriptor instead.
func (*RiskAnalysisJobConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{44}
}

func (x *RiskAnalysisJobConfig) GetPrivacyMetric() *PrivacyMetric {
	if x != nil {
		return x.PrivacyMetric
	}
	return nil
}

func (x *RiskAnalysisJobConfig) GetSourceTable() *BigQueryTable {
	if x != nil {
		return x.SourceTable
	}
	return nil
}

func (x *RiskAnalysisJobConfig) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// A column with a semantic tag attached.
type QuasiId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Semantic tag that identifies what a column contains, to determine which
	// statistical model to use to estimate the reidentifiability of each
	// value. [required]
	//
	// Types that are assignable to Tag:
	//
	//	*QuasiId_InfoType
	//	*QuasiId_CustomTag
	//	*QuasiId_Inferred
	Tag isQuasiId_Tag `protobuf_oneof:"tag"`
}

func (x *QuasiId) Reset() {
	*x = QuasiId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuasiId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuasiId) ProtoMessage() {}

func (x *QuasiId) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuasiId.ProtoReflect.Descriptor instead.
func (*QuasiId) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{45}
}

func (x *QuasiId) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (m *QuasiId) GetTag() isQuasiId_Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (x *QuasiId) GetInfoType() *InfoType {
	if x, ok := x.GetTag().(*QuasiId_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *QuasiId) GetCustomTag() string {
	if x, ok := x.GetTag().(*QuasiId_CustomTag); ok {
		return x.CustomTag
	}
	return ""
}

func (x *QuasiId) GetInferred() *emptypb.Empty {
	if x, ok := x.GetTag().(*QuasiId_Inferred); ok {
		return x.Inferred
	}
	return nil
}

type isQuasiId_Tag interface {
	isQuasiId_Tag()
}

type QuasiId_InfoType struct {
	// A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We
	// currently support US ZIP codes, region codes, ages and genders.
	// To programmatically obtain the list of supported InfoTypes, use
	// ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3,oneof"`
}

type QuasiId_CustomTag struct {
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,3,opt,name=custom_tag,json=customTag,proto3,oneof"`
}

type QuasiId_Inferred struct {
	// If no semantic tag is indicated, we infer the statistical model from
	// the distribution of values in the input data
	Inferred *emptypb.Empty `protobuf:"bytes,4,opt,name=inferred,proto3,oneof"`
}

func (*QuasiId_InfoType) isQuasiId_Tag() {}

func (*QuasiId_CustomTag) isQuasiId_Tag() {}

func (*QuasiId_Inferred) isQuasiId_Tag() {}

// An auxiliary table containing statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple.
// If a tuple is present in the data but not in the auxiliary table, the
// corresponding relative frequency is assumed to be zero (and thus, the
// tuple is highly reidentifiable).
type StatisticalTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Auxiliary table location.
	Table *BigQueryTable `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// Required. Quasi-identifier columns.
	QuasiIds []*StatisticalTable_QuasiIdentifierField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Required. The relative frequency column must contain a floating-point
	// number between 0 and 1 (inclusive). Null values are assumed to be zero.
	RelativeFrequency *FieldId `protobuf:"bytes,2,opt,name=relative_frequency,json=relativeFrequency,proto3" json:"relative_frequency,omitempty"`
}

func (x *StatisticalTable) Reset() {
	*x = StatisticalTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatisticalTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticalTable) ProtoMessage() {}

func (x *StatisticalTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticalTable.ProtoReflect.Descriptor instead.
func (*StatisticalTable) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{46}
}

func (x *StatisticalTable) GetTable() *BigQueryTable {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *StatisticalTable) GetQuasiIds() []*StatisticalTable_QuasiIdentifierField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *StatisticalTable) GetRelativeFrequency() *FieldId {
	if x != nil {
		return x.RelativeFrequency
	}
	return nil
}

// Privacy metric to compute for reidentification risk analysis.
type PrivacyMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types of analysis.
	//
	// Types that are assignable to Type:
	//
	//	*PrivacyMetric_NumericalStatsConfig_
	//	*PrivacyMetric_CategoricalStatsConfig_
	//	*PrivacyMetric_KAnonymityConfig_
	//	*PrivacyMetric_LDiversityConfig_
	//	*PrivacyMetric_KMapEstimationConfig_
	//	*PrivacyMetric_DeltaPresenceEstimationConfig_
	Type isPrivacyMetric_Type `protobuf_oneof:"type"`
}

func (x *PrivacyMetric) Reset() {
	*x = PrivacyMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric) ProtoMessage() {}

func (x *PrivacyMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric.ProtoReflect.Descriptor instead.
func (*PrivacyMetric) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47}
}

func (m *PrivacyMetric) GetType() isPrivacyMetric_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *PrivacyMetric) GetNumericalStatsConfig() *PrivacyMetric_NumericalStatsConfig {
	if x, ok := x.GetType().(*PrivacyMetric_NumericalStatsConfig_); ok {
		return x.NumericalStatsConfig
	}
	return nil
}

func (x *PrivacyMetric) GetCategoricalStatsConfig() *PrivacyMetric_CategoricalStatsConfig {
	if x, ok := x.GetType().(*PrivacyMetric_CategoricalStatsConfig_); ok {
		return x.CategoricalStatsConfig
	}
	return nil
}

func (x *PrivacyMetric) GetKAnonymityConfig() *PrivacyMetric_KAnonymityConfig {
	if x, ok := x.GetType().(*PrivacyMetric_KAnonymityConfig_); ok {
		return x.KAnonymityConfig
	}
	return nil
}

func (x *PrivacyMetric) GetLDiversityConfig() *PrivacyMetric_LDiversityConfig {
	if x, ok := x.GetType().(*PrivacyMetric_LDiversityConfig_); ok {
		return x.LDiversityConfig
	}
	return nil
}

func (x *PrivacyMetric) GetKMapEstimationConfig() *PrivacyMetric_KMapEstimationConfig {
	if x, ok := x.GetType().(*PrivacyMetric_KMapEstimationConfig_); ok {
		return x.KMapEstimationConfig
	}
	return nil
}

func (x *PrivacyMetric) GetDeltaPresenceEstimationConfig() *PrivacyMetric_DeltaPresenceEstimationConfig {
	if x, ok := x.GetType().(*PrivacyMetric_DeltaPresenceEstimationConfig_); ok {
		return x.DeltaPresenceEstimationConfig
	}
	return nil
}

type isPrivacyMetric_Type interface {
	isPrivacyMetric_Type()
}

type PrivacyMetric_NumericalStatsConfig_ struct {
	// Numerical stats
	NumericalStatsConfig *PrivacyMetric_NumericalStatsConfig `protobuf:"bytes,1,opt,name=numerical_stats_config,json=numericalStatsConfig,proto3,oneof"`
}

type PrivacyMetric_CategoricalStatsConfig_ struct {
	// Categorical stats
	CategoricalStatsConfig *PrivacyMetric_CategoricalStatsConfig `protobuf:"bytes,2,opt,name=categorical_stats_config,json=categoricalStatsConfig,proto3,oneof"`
}

type PrivacyMetric_KAnonymityConfig_ struct {
	// K-anonymity
	KAnonymityConfig *PrivacyMetric_KAnonymityConfig `protobuf:"bytes,3,opt,name=k_anonymity_config,json=kAnonymityConfig,proto3,oneof"`
}

type PrivacyMetric_LDiversityConfig_ struct {
	// l-diversity
	LDiversityConfig *PrivacyMetric_LDiversityConfig `protobuf:"bytes,4,opt,name=l_diversity_config,json=lDiversityConfig,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_ struct {
	// k-map
	KMapEstimationConfig *PrivacyMetric_KMapEstimationConfig `protobuf:"bytes,5,opt,name=k_map_estimation_config,json=kMapEstimationConfig,proto3,oneof"`
}

type PrivacyMetric_DeltaPresenceEstimationConfig_ struct {
	// delta-presence
	DeltaPresenceEstimationConfig *PrivacyMetric_DeltaPresenceEstimationConfig `protobuf:"bytes,6,opt,name=delta_presence_estimation_config,json=deltaPresenceEstimationConfig,proto3,oneof"`
}

func (*PrivacyMetric_NumericalStatsConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_CategoricalStatsConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_KAnonymityConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_LDiversityConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_KMapEstimationConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_DeltaPresenceEstimationConfig_) isPrivacyMetric_Type() {}

// Result of a risk analysis operation request.
type AnalyzeDataSourceRiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Privacy metric to compute.
	RequestedPrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=requested_privacy_metric,json=requestedPrivacyMetric,proto3" json:"requested_privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	RequestedSourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=requested_source_table,json=requestedSourceTable,proto3" json:"requested_source_table,omitempty"`
	// Values associated with this metric.
	//
	// Types that are assignable to Result:
	//
	//	*AnalyzeDataSourceRiskDetails_NumericalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_KAnonymityResult_
	//	*AnalyzeDataSourceRiskDetails_LDiversityResult_
	//	*AnalyzeDataSourceRiskDetails_KMapEstimationResult_
	//	*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_
	Result isAnalyzeDataSourceRiskDetails_Result `protobuf_oneof:"result"`
	// The configuration used for this job.
	RequestedOptions *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions `protobuf:"bytes,10,opt,name=requested_options,json=requestedOptions,proto3" json:"requested_options,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails) Reset() {
	*x = AnalyzeDataSourceRiskDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48}
}

func (x *AnalyzeDataSourceRiskDetails) GetRequestedPrivacyMetric() *PrivacyMetric {
	if x != nil {
		return x.RequestedPrivacyMetric
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetRequestedSourceTable() *BigQueryTable {
	if x != nil {
		return x.RequestedSourceTable
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetResult() isAnalyzeDataSourceRiskDetails_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetNumericalStatsResult() *AnalyzeDataSourceRiskDetails_NumericalStatsResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_NumericalStatsResult_); ok {
		return x.NumericalStatsResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetCategoricalStatsResult() *AnalyzeDataSourceRiskDetails_CategoricalStatsResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_); ok {
		return x.CategoricalStatsResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetKAnonymityResult() *AnalyzeDataSourceRiskDetails_KAnonymityResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_KAnonymityResult_); ok {
		return x.KAnonymityResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetLDiversityResult() *AnalyzeDataSourceRiskDetails_LDiversityResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_LDiversityResult_); ok {
		return x.LDiversityResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetKMapEstimationResult() *AnalyzeDataSourceRiskDetails_KMapEstimationResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_); ok {
		return x.KMapEstimationResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetDeltaPresenceEstimationResult() *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_); ok {
		return x.DeltaPresenceEstimationResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetRequestedOptions() *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions {
	if x != nil {
		return x.RequestedOptions
	}
	return nil
}

type isAnalyzeDataSourceRiskDetails_Result interface {
	isAnalyzeDataSourceRiskDetails_Result()
}

type AnalyzeDataSourceRiskDetails_NumericalStatsResult_ struct {
	// Numerical stats result
	NumericalStatsResult *AnalyzeDataSourceRiskDetails_NumericalStatsResult `protobuf:"bytes,3,opt,name=numerical_stats_result,json=numericalStatsResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_ struct {
	// Categorical stats result
	CategoricalStatsResult *AnalyzeDataSourceRiskDetails_CategoricalStatsResult `protobuf:"bytes,4,opt,name=categorical_stats_result,json=categoricalStatsResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_KAnonymityResult_ struct {
	// K-anonymity result
	KAnonymityResult *AnalyzeDataSourceRiskDetails_KAnonymityResult `protobuf:"bytes,5,opt,name=k_anonymity_result,json=kAnonymityResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_LDiversityResult_ struct {
	// L-divesity result
	LDiversityResult *AnalyzeDataSourceRiskDetails_LDiversityResult `protobuf:"bytes,6,opt,name=l_diversity_result,json=lDiversityResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_KMapEstimationResult_ struct {
	// K-map result
	KMapEstimationResult *AnalyzeDataSourceRiskDetails_KMapEstimationResult `protobuf:"bytes,7,opt,name=k_map_estimation_result,json=kMapEstimationResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_ struct {
	// Delta-presence result
	DeltaPresenceEstimationResult *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult `protobuf:"bytes,9,opt,name=delta_presence_estimation_result,json=deltaPresenceEstimationResult,proto3,oneof"`
}

func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_) isAnalyzeDataSourceRiskDetails_Result() {
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_) isAnalyzeDataSourceRiskDetails_Result() {
}

// A value of a field, including its frequency.
type ValueFrequency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A value contained in the field in question.
	Value *Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// How many times the value is contained in the field.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *ValueFrequency) Reset() {
	*x = ValueFrequency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueFrequency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueFrequency) ProtoMessage() {}

func (x *ValueFrequency) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueFrequency.ProtoReflect.Descriptor instead.
func (*ValueFrequency) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{49}
}

func (x *ValueFrequency) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ValueFrequency) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Set of primitive values supported by the system.
// Note that for the purposes of inspection or transformation, the number
// of bytes considered to comprise a 'Value' is based on its representation
// as a UTF-8 encoded string. For example, if 'integer_value' is set to
// 123456789, the number of bytes would be counted as 9, even though an
// int64 only holds up to 8 bytes of data.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value types
	//
	// Types that are assignable to Type:
	//
	//	*Value_IntegerValue
	//	*Value_FloatValue
	//	*Value_StringValue
	//	*Value_BooleanValue
	//	*Value_TimestampValue
	//	*Value_TimeValue
	//	*Value_DateValue
	//	*Value_DayOfWeekValue
	Type isValue_Type `protobuf_oneof:"type"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{50}
}

func (m *Value) GetType() isValue_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Value) GetIntegerValue() int64 {
	if x, ok := x.GetType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *Value) GetFloatValue() float64 {
	if x, ok := x.GetType().(*Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetBooleanValue() bool {
	if x, ok := x.GetType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (x *Value) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *Value) GetTimeValue() *timeofday.TimeOfDay {
	if x, ok := x.GetType().(*Value_TimeValue); ok {
		return x.TimeValue
	}
	return nil
}

func (x *Value) GetDateValue() *date.Date {
	if x, ok := x.GetType().(*Value_DateValue); ok {
		return x.DateValue
	}
	return nil
}

func (x *Value) GetDayOfWeekValue() dayofweek.DayOfWeek {
	if x, ok := x.GetType().(*Value_DayOfWeekValue); ok {
		return x.DayOfWeekValue
	}
	return dayofweek.DayOfWeek(0)
}

type isValue_Type interface {
	isValue_Type()
}

type Value_IntegerValue struct {
	// integer
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type Value_FloatValue struct {
	// float
	FloatValue float64 `protobuf:"fixed64,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type Value_StringValue struct {
	// string
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_BooleanValue struct {
	// boolean
	BooleanValue bool `protobuf:"varint,4,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

type Value_TimestampValue struct {
	// timestamp
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type Value_TimeValue struct {
	// time of day
	TimeValue *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=time_value,json=timeValue,proto3,oneof"`
}

type Value_DateValue struct {
	// date
	DateValue *date.Date `protobuf:"bytes,7,opt,name=date_value,json=dateValue,proto3,oneof"`
}

type Value_DayOfWeekValue struct {
	// day of week
	DayOfWeekValue dayofweek.DayOfWeek `protobuf:"varint,8,opt,name=day_of_week_value,json=dayOfWeekValue,proto3,enum=google.type.DayOfWeek,oneof"`
}

func (*Value_IntegerValue) isValue_Type() {}

func (*Value_FloatValue) isValue_Type() {}

func (*Value_StringValue) isValue_Type() {}

func (*Value_BooleanValue) isValue_Type() {}

func (*Value_TimestampValue) isValue_Type() {}

func (*Value_TimeValue) isValue_Type() {}

func (*Value_DateValue) isValue_Type() {}

func (*Value_DayOfWeekValue) isValue_Type() {}

// Message for infoType-dependent details parsed from quote.
type QuoteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Object representation of the quote.
	//
	// Types that are assignable to ParsedQuote:
	//
	//	*QuoteInfo_DateTime
	ParsedQuote isQuoteInfo_ParsedQuote `protobuf_oneof:"parsed_quote"`
}

func (x *QuoteInfo) Reset() {
	*x = QuoteInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuoteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuoteInfo) ProtoMessage() {}

func (x *QuoteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuoteInfo.ProtoReflect.Descriptor instead.
func (*QuoteInfo) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{51}
}

func (m *QuoteInfo) GetParsedQuote() isQuoteInfo_ParsedQuote {
	if m != nil {
		return m.ParsedQuote
	}
	return nil
}

func (x *QuoteInfo) GetDateTime() *DateTime {
	if x, ok := x.GetParsedQuote().(*QuoteInfo_DateTime); ok {
		return x.DateTime
	}
	return nil
}

type isQuoteInfo_ParsedQuote interface {
	isQuoteInfo_ParsedQuote()
}

type QuoteInfo_DateTime struct {
	// The date time indicated by the quote.
	DateTime *DateTime `protobuf:"bytes,2,opt,name=date_time,json=dateTime,proto3,oneof"`
}

func (*QuoteInfo_DateTime) isQuoteInfo_ParsedQuote() {}

// Message for a date time object.
// e.g. 2018-01-01, 5th August.
type DateTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more of the following must be set.
	// Must be a valid date or time value.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Day of week
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	// Time of day
	Time *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Time zone
	TimeZone *DateTime_TimeZone `protobuf:"bytes,4,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *DateTime) Reset() {
	*x = DateTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTime) ProtoMessage() {}

func (x *DateTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTime.ProtoReflect.Descriptor instead.
func (*DateTime) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{52}
}

func (x *DateTime) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *DateTime) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek(0)
}

func (x *DateTime) GetTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DateTime) GetTimeZone() *DateTime_TimeZone {
	if x != nil {
		return x.TimeZone
	}
	return nil
}

// The configuration that controls how the data will change.
type DeidentifyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of transformation
	//
	// Types that are assignable to Transformation:
	//
	//	*DeidentifyConfig_InfoTypeTransformations
	//	*DeidentifyConfig_RecordTransformations
	//	*DeidentifyConfig_ImageTransformations
	Transformation isDeidentifyConfig_Transformation `protobuf_oneof:"transformation"`
	// Mode for handling transformation errors. If left unspecified, the default
	// mode is `TransformationErrorHandling.ThrowError`.
	TransformationErrorHandling *TransformationErrorHandling `protobuf:"bytes,3,opt,name=transformation_error_handling,json=transformationErrorHandling,proto3" json:"transformation_error_handling,omitempty"`
}

func (x *DeidentifyConfig) Reset() {
	*x = DeidentifyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyConfig) ProtoMessage() {}

func (x *DeidentifyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyConfig.ProtoReflect.Descriptor instead.
func (*DeidentifyConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{53}
}

func (m *DeidentifyConfig) GetTransformation() isDeidentifyConfig_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *DeidentifyConfig) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := x.GetTransformation().(*DeidentifyConfig_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

func (x *DeidentifyConfig) GetRecordTransformations() *RecordTransformations {
	if x, ok := x.GetTransformation().(*DeidentifyConfig_RecordTransformations); ok {
		return x.RecordTransformations
	}
	return nil
}

func (x *DeidentifyConfig) GetImageTransformations() *ImageTransformations {
	if x, ok := x.GetTransformation().(*DeidentifyConfig_ImageTransformations); ok {
		return x.ImageTransformations
	}
	return nil
}

func (x *DeidentifyConfig) GetTransformationErrorHandling() *TransformationErrorHandling {
	if x != nil {
		return x.TransformationErrorHandling
	}
	return nil
}

type isDeidentifyConfig_Transformation interface {
	isDeidentifyConfig_Transformation()
}

type DeidentifyConfig_InfoTypeTransformations struct {
	// Treat the dataset as free-form text and apply the same free text
	// transformation everywhere.
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,1,opt,name=info_type_transformations,json=infoTypeTransformations,proto3,oneof"`
}

type DeidentifyConfig_RecordTransformations struct {
	// Treat the dataset as structured. Transformations can be applied to
	// specific locations within structured datasets, such as transforming
	// a column within a table.
	RecordTransformations *RecordTransformations `protobuf:"bytes,2,opt,name=record_transformations,json=recordTransformations,proto3,oneof"`
}

type DeidentifyConfig_ImageTransformations struct {
	// Treat the dataset as an image and redact.
	ImageTransformations *ImageTransformations `protobuf:"bytes,4,opt,name=image_transformations,json=imageTransformations,proto3,oneof"`
}

func (*DeidentifyConfig_InfoTypeTransformations) isDeidentifyConfig_Transformation() {}

func (*DeidentifyConfig_RecordTransformations) isDeidentifyConfig_Transformation() {}

func (*DeidentifyConfig_ImageTransformations) isDeidentifyConfig_Transformation() {}

// A type of transformation that is applied over images.
type ImageTransformations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of transforms to make.
	Transforms []*ImageTransformations_ImageTransformation `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty"`
}

func (x *ImageTransformations) Reset() {
	*x = ImageTransformations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageTransformations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageTransformations) ProtoMessage() {}

func (x *ImageTransformations) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageTransformations.ProtoReflect.Descriptor instead.
func (*ImageTransformations) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54}
}

func (x *ImageTransformations) GetTransforms() []*ImageTransformations_ImageTransformation {
	if x != nil {
		return x.Transforms
	}
	return nil
}

// How to handle transformation errors during de-identification. A
// transformation error occurs when the requested transformation is incompatible
// with the data. For example, trying to de-identify an IP address using a
// `DateShift` transformation would result in a transformation error, since date
// info cannot be extracted from an IP address.
// Information about any incompatible transformations, and how they were
// handled, is returned in the response as part of the
// `TransformationOverviews`.
type TransformationErrorHandling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How transformation errors should be handled.
	//
	// Types that are assignable to Mode:
	//
	//	*TransformationErrorHandling_ThrowError_
	//	*TransformationErrorHandling_LeaveUntransformed_
	Mode isTransformationErrorHandling_Mode `protobuf_oneof:"mode"`
}

func (x *TransformationErrorHandling) Reset() {
	*x = TransformationErrorHandling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling) ProtoMessage() {}

func (x *TransformationErrorHandling) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{55}
}

func (m *TransformationErrorHandling) GetMode() isTransformationErrorHandling_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *TransformationErrorHandling) GetThrowError() *TransformationErrorHandling_ThrowError {
	if x, ok := x.GetMode().(*TransformationErrorHandling_ThrowError_); ok {
		return x.ThrowError
	}
	return nil
}

func (x *TransformationErrorHandling) GetLeaveUntransformed() *TransformationErrorHandling_LeaveUntransformed {
	if x, ok := x.GetMode().(*TransformationErrorHandling_LeaveUntransformed_); ok {
		return x.LeaveUntransformed
	}
	return nil
}

type isTransformationErrorHandling_Mode interface {
	isTransformationErrorHandling_Mode()
}

type TransformationErrorHandling_ThrowError_ struct {
	// Throw an error
	ThrowError *TransformationErrorHandling_ThrowError `protobuf:"bytes,1,opt,name=throw_error,json=throwError,proto3,oneof"`
}

type TransformationErrorHandling_LeaveUntransformed_ struct {
	// Ignore errors
	LeaveUntransformed *TransformationErrorHandling_LeaveUntransformed `protobuf:"bytes,2,opt,name=leave_untransformed,json=leaveUntransformed,proto3,oneof"`
}

func (*TransformationErrorHandling_ThrowError_) isTransformationErrorHandling_Mode() {}

func (*TransformationErrorHandling_LeaveUntransformed_) isTransformationErrorHandling_Mode() {}

// A rule for transforming a value.
type PrimitiveTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of transformation.
	//
	// Types that are assignable to Transformation:
	//
	//	*PrimitiveTransformation_ReplaceConfig
	//	*PrimitiveTransformation_RedactConfig
	//	*PrimitiveTransformation_CharacterMaskConfig
	//	*PrimitiveTransformation_CryptoReplaceFfxFpeConfig
	//	*PrimitiveTransformation_FixedSizeBucketingConfig
	//	*PrimitiveTransformation_BucketingConfig
	//	*PrimitiveTransformation_ReplaceWithInfoTypeConfig
	//	*PrimitiveTransformation_TimePartConfig
	//	*PrimitiveTransformation_CryptoHashConfig
	//	*PrimitiveTransformation_DateShiftConfig
	//	*PrimitiveTransformation_CryptoDeterministicConfig
	//	*PrimitiveTransformation_ReplaceDictionaryConfig
	Transformation isPrimitiveTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (x *PrimitiveTransformation) Reset() {
	*x = PrimitiveTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrimitiveTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimitiveTransformation) ProtoMessage() {}

func (x *PrimitiveTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimitiveTransformation.ProtoReflect.Descriptor instead.
func (*PrimitiveTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{56}
}

func (m *PrimitiveTransformation) GetTransformation() isPrimitiveTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *PrimitiveTransformation) GetReplaceConfig() *ReplaceValueConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_ReplaceConfig); ok {
		return x.ReplaceConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetRedactConfig() *RedactConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_RedactConfig); ok {
		return x.RedactConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCharacterMaskConfig() *CharacterMaskConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CharacterMaskConfig); ok {
		return x.CharacterMaskConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoReplaceFfxFpeConfig() *CryptoReplaceFfxFpeConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoReplaceFfxFpeConfig); ok {
		return x.CryptoReplaceFfxFpeConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetFixedSizeBucketingConfig() *FixedSizeBucketingConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_FixedSizeBucketingConfig); ok {
		return x.FixedSizeBucketingConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetBucketingConfig() *BucketingConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_BucketingConfig); ok {
		return x.BucketingConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetReplaceWithInfoTypeConfig() *ReplaceWithInfoTypeConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_ReplaceWithInfoTypeConfig); ok {
		return x.ReplaceWithInfoTypeConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetTimePartConfig() *TimePartConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_TimePartConfig); ok {
		return x.TimePartConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoHashConfig() *CryptoHashConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoHashConfig); ok {
		return x.CryptoHashConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetDateShiftConfig() *DateShiftConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_DateShiftConfig); ok {
		return x.DateShiftConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoDeterministicConfig() *CryptoDeterministicConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoDeterministicConfig); ok {
		return x.CryptoDeterministicConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetReplaceDictionaryConfig() *ReplaceDictionaryConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_ReplaceDictionaryConfig); ok {
		return x.ReplaceDictionaryConfig
	}
	return nil
}

type isPrimitiveTransformation_Transformation interface {
	isPrimitiveTransformation_Transformation()
}

type PrimitiveTransformation_ReplaceConfig struct {
	// Replace with a specified value.
	ReplaceConfig *ReplaceValueConfig `protobuf:"bytes,1,opt,name=replace_config,json=replaceConfig,proto3,oneof"`
}

type PrimitiveTransformation_RedactConfig struct {
	// Redact
	RedactConfig *RedactConfig `protobuf:"bytes,2,opt,name=redact_config,json=redactConfig,proto3,oneof"`
}

type PrimitiveTransformation_CharacterMaskConfig struct {
	// Mask
	CharacterMaskConfig *CharacterMaskConfig `protobuf:"bytes,3,opt,name=character_mask_config,json=characterMaskConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoReplaceFfxFpeConfig struct {
	// Ffx-Fpe
	CryptoReplaceFfxFpeConfig *CryptoReplaceFfxFpeConfig `protobuf:"bytes,4,opt,name=crypto_replace_ffx_fpe_config,json=cryptoReplaceFfxFpeConfig,proto3,oneof"`
}

type PrimitiveTransformation_FixedSizeBucketingConfig struct {
	// Fixed size bucketing
	FixedSizeBucketingConfig *FixedSizeBucketingConfig `protobuf:"bytes,5,opt,name=fixed_size_bucketing_config,json=fixedSizeBucketingConfig,proto3,oneof"`
}

type PrimitiveTransformation_BucketingConfig struct {
	// Bucketing
	BucketingConfig *BucketingConfig `protobuf:"bytes,6,opt,name=bucketing_config,json=bucketingConfig,proto3,oneof"`
}

type PrimitiveTransformation_ReplaceWithInfoTypeConfig struct {
	// Replace with infotype
	ReplaceWithInfoTypeConfig *ReplaceWithInfoTypeConfig `protobuf:"bytes,7,opt,name=replace_with_info_type_config,json=replaceWithInfoTypeConfig,proto3,oneof"`
}

type PrimitiveTransformation_TimePartConfig struct {
	// Time extraction
	TimePartConfig *TimePartConfig `protobuf:"bytes,8,opt,name=time_part_config,json=timePartConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoHashConfig struct {
	// Crypto
	CryptoHashConfig *CryptoHashConfig `protobuf:"bytes,9,opt,name=crypto_hash_config,json=cryptoHashConfig,proto3,oneof"`
}

type PrimitiveTransformation_DateShiftConfig struct {
	// Date Shift
	DateShiftConfig *DateShiftConfig `protobuf:"bytes,11,opt,name=date_shift_config,json=dateShiftConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoDeterministicConfig struct {
	// Deterministic Crypto
	CryptoDeterministicConfig *CryptoDeterministicConfig `protobuf:"bytes,12,opt,name=crypto_deterministic_config,json=cryptoDeterministicConfig,proto3,oneof"`
}

type PrimitiveTransformation_ReplaceDictionaryConfig struct {
	// Replace with a value randomly drawn (with replacement) from a dictionary.
	ReplaceDictionaryConfig *ReplaceDictionaryConfig `protobuf:"bytes,13,opt,name=replace_dictionary_config,json=replaceDictionaryConfig,proto3,oneof"`
}

func (*PrimitiveTransformation_ReplaceConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_RedactConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CharacterMaskConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoReplaceFfxFpeConfig) isPrimitiveTransformation_Transformation() {
}

func (*PrimitiveTransformation_FixedSizeBucketingConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_BucketingConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_ReplaceWithInfoTypeConfig) isPrimitiveTransformation_Transformation() {
}

func (*PrimitiveTransformation_TimePartConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoHashConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_DateShiftConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoDeterministicConfig) isPrimitiveTransformation_Transformation() {
}

func (*PrimitiveTransformation_ReplaceDictionaryConfig) isPrimitiveTransformation_Transformation() {}

// For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
// portion of the value.
type TimePartConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The part of the time to keep.
	PartToExtract TimePartConfig_TimePart `protobuf:"varint,1,opt,name=part_to_extract,json=partToExtract,proto3,enum=google.privacy.dlp.v2.TimePartConfig_TimePart" json:"part_to_extract,omitempty"`
}

func (x *TimePartConfig) Reset() {
	*x = TimePartConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimePartConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimePartConfig) ProtoMessage() {}

func (x *TimePartConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimePartConfig.ProtoReflect.Descriptor instead.
func (*TimePartConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{57}
}

func (x *TimePartConfig) GetPartToExtract() TimePartConfig_TimePart {
	if x != nil {
		return x.PartToExtract
	}
	return TimePartConfig_TIME_PART_UNSPECIFIED
}

// Pseudonymization method that generates surrogates via cryptographic hashing.
// Uses SHA-256.
// The key size must be either 32 or 64 bytes.
// Outputs a base64 encoded representation of the hashed output
// (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=).
// Currently, only string and integer values can be hashed.
// See https://cloud.google.com/sensitive-data-protection/docs/pseudonymization
// to learn more.
type CryptoHashConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used by the hash function.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
}

func (x *CryptoHashConfig) Reset() {
	*x = CryptoHashConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoHashConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoHashConfig) ProtoMessage() {}

func (x *CryptoHashConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoHashConfig.ProtoReflect.Descriptor instead.
func (*CryptoHashConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{58}
}

func (x *CryptoHashConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

// Pseudonymization method that generates deterministic encryption for the given
// input. Outputs a base64 encoded representation of the encrypted output.
// Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
type CryptoDeterministicConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used by the encryption function. For deterministic encryption
	// using AES-SIV, the provided key is internally expanded to 64 bytes prior to
	// use.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// The custom info type to annotate the surrogate with.
	// This annotation will be applied to the surrogate by prefixing it with
	// the name of the custom info type followed by the number of
	// characters comprising the surrogate. The following scheme defines the
	// format: {info type name}({surrogate character count}):{surrogate}
	//
	// For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
	// the surrogate is 'abc', the full replacement value
	// will be: 'MY_TOKEN_INFO_TYPE(3):abc'
	//
	// This annotation identifies the surrogate when inspecting content using the
	// custom info type 'Surrogate'. This facilitates reversal of the
	// surrogate when it occurs in free text.
	//
	// Note: For record transformations where the entire cell in a table is being
	// transformed, surrogates are not mandatory. Surrogates are used to denote
	// the location of the token and are necessary for re-identification in free
	// form text.
	//
	// In order for inspection to work properly, the name of this info type must
	// not occur naturally anywhere in your data; otherwise, inspection may either
	//
	// - reverse a surrogate that does not correspond to an actual identifier
	// - be unable to parse the surrogate and result in an error
	//
	// Therefore, choose your custom info type name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data.
	// For example, assuming your data is entered from a regular ASCII keyboard,
	// the symbol with the hex code point 29DD might be used like so:
	// ⧝MY_TOKEN_TYPE.
	SurrogateInfoType *InfoType `protobuf:"bytes,2,opt,name=surrogate_info_type,json=surrogateInfoType,proto3" json:"surrogate_info_type,omitempty"`
	// A context may be used for higher security and maintaining
	// referential integrity such that the same identifier in two different
	// contexts will be given a distinct surrogate. The context is appended to
	// plaintext value being encrypted. On decryption the provided context is
	// validated against the value used during encryption. If a context was
	// provided during encryption, same context must be provided during decryption
	// as well.
	//
	// If the context is not set, plaintext would be used as is for encryption.
	// If the context is set but:
	//
	// 1. there is no record present when transforming a given value or
	// 2. the field is not present when transforming a given value,
	//
	// plaintext would be used as is for encryption.
	//
	// Note that case (1) is expected when an `InfoTypeTransformation` is
	// applied to both structured and unstructured `ContentItem`s.
	Context *FieldId `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *CryptoDeterministicConfig) Reset() {
	*x = CryptoDeterministicConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoDeterministicConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoDeterministicConfig) ProtoMessage() {}

func (x *CryptoDeterministicConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoDeterministicConfig.ProtoReflect.Descriptor instead.
func (*CryptoDeterministicConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{59}
}

func (x *CryptoDeterministicConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

func (x *CryptoDeterministicConfig) GetSurrogateInfoType() *InfoType {
	if x != nil {
		return x.SurrogateInfoType
	}
	return nil
}

func (x *CryptoDeterministicConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

// Replace each input value with a given `Value`.
type ReplaceValueConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value to replace it with.
	NewValue *Value `protobuf:"bytes,1,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
}

func (x *ReplaceValueConfig) Reset() {
	*x = ReplaceValueConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceValueConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceValueConfig) ProtoMessage() {}

func (x *ReplaceValueConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceValueConfig.ProtoReflect.Descriptor instead.
func (*ReplaceValueConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{60}
}

func (x *ReplaceValueConfig) GetNewValue() *Value {
	if x != nil {
		return x.NewValue
	}
	return nil
}

// Replace each input value with a value randomly selected from the dictionary.
type ReplaceDictionaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of dictionary.
	//
	// Types that are assignable to Type:
	//
	//	*ReplaceDictionaryConfig_WordList
	Type isReplaceDictionaryConfig_Type `protobuf_oneof:"type"`
}

func (x *ReplaceDictionaryConfig) Reset() {
	*x = ReplaceDictionaryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceDictionaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceDictionaryConfig) ProtoMessage() {}

func (x *ReplaceDictionaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceDictionaryConfig.ProtoReflect.Descriptor instead.
func (*ReplaceDictionaryConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{61}
}

func (m *ReplaceDictionaryConfig) GetType() isReplaceDictionaryConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ReplaceDictionaryConfig) GetWordList() *CustomInfoType_Dictionary_WordList {
	if x, ok := x.GetType().(*ReplaceDictionaryConfig_WordList); ok {
		return x.WordList
	}
	return nil
}

type isReplaceDictionaryConfig_Type interface {
	isReplaceDictionaryConfig_Type()
}

type ReplaceDictionaryConfig_WordList struct {
	// A list of words to select from for random replacement. The
	// [limits](https://cloud.google.com/sensitive-data-protection/limits) page
	// contains details about the size limits of dictionaries.
	WordList *CustomInfoType_Dictionary_WordList `protobuf:"bytes,1,opt,name=word_list,json=wordList,proto3,oneof"`
}

func (*ReplaceDictionaryConfig_WordList) isReplaceDictionaryConfig_Type() {}

// Replace each matching finding with the name of the info_type.
type ReplaceWithInfoTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReplaceWithInfoTypeConfig) Reset() {
	*x = ReplaceWithInfoTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceWithInfoTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceWithInfoTypeConfig) ProtoMessage() {}

func (x *ReplaceWithInfoTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceWithInfoTypeConfig.ProtoReflect.Descriptor instead.
func (*ReplaceWithInfoTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{62}
}

// Redact a given value. For example, if used with an `InfoTypeTransformation`
// transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the
// output would be 'My phone number is '.
type RedactConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RedactConfig) Reset() {
	*x = RedactConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactConfig) ProtoMessage() {}

func (x *RedactConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactConfig.ProtoReflect.Descriptor instead.
func (*RedactConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{63}
}

// Characters to skip when doing deidentification of a value. These will be left
// alone and skipped.
type CharsToIgnore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of characters to skip.
	//
	// Types that are assignable to Characters:
	//
	//	*CharsToIgnore_CharactersToSkip
	//	*CharsToIgnore_CommonCharactersToIgnore
	Characters isCharsToIgnore_Characters `protobuf_oneof:"characters"`
}

func (x *CharsToIgnore) Reset() {
	*x = CharsToIgnore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CharsToIgnore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CharsToIgnore) ProtoMessage() {}

func (x *CharsToIgnore) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CharsToIgnore.ProtoReflect.Descriptor instead.
func (*CharsToIgnore) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{64}
}

func (m *CharsToIgnore) GetCharacters() isCharsToIgnore_Characters {
	if m != nil {
		return m.Characters
	}
	return nil
}

func (x *CharsToIgnore) GetCharactersToSkip() string {
	if x, ok := x.GetCharacters().(*CharsToIgnore_CharactersToSkip); ok {
		return x.CharactersToSkip
	}
	return ""
}

func (x *CharsToIgnore) GetCommonCharactersToIgnore() CharsToIgnore_CommonCharsToIgnore {
	if x, ok := x.GetCharacters().(*CharsToIgnore_CommonCharactersToIgnore); ok {
		return x.CommonCharactersToIgnore
	}
	return CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED
}

type isCharsToIgnore_Characters interface {
	isCharsToIgnore_Characters()
}

type CharsToIgnore_CharactersToSkip struct {
	// Characters to not transform when masking.
	CharactersToSkip string `protobuf:"bytes,1,opt,name=characters_to_skip,json=charactersToSkip,proto3,oneof"`
}

type CharsToIgnore_CommonCharactersToIgnore struct {
	// Common characters to not transform when masking. Useful to avoid removing
	// punctuation.
	CommonCharactersToIgnore CharsToIgnore_CommonCharsToIgnore `protobuf:"varint,2,opt,name=common_characters_to_ignore,json=commonCharactersToIgnore,proto3,enum=google.privacy.dlp.v2.CharsToIgnore_CommonCharsToIgnore,oneof"`
}

func (*CharsToIgnore_CharactersToSkip) isCharsToIgnore_Characters() {}

func (*CharsToIgnore_CommonCharactersToIgnore) isCharsToIgnore_Characters() {}

// Partially mask a string by replacing a given number of characters with a
// fixed character. Masking can start from the beginning or end of the string.
// This can be used on data of any type (numbers, longs, and so on) and when
// de-identifying structured data we'll attempt to preserve the original data's
// type. (This allows you to take a long like 123 and modify it to a string like
// **3.
type CharacterMaskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Character to use to mask the sensitive values&mdash;for example, `*` for an
	// alphabetic string such as a name, or `0` for a numeric string such as ZIP
	// code or credit card number. This string must have a length of 1. If not
	// supplied, this value defaults to `*` for strings, and `0` for digits.
	MaskingCharacter string `protobuf:"bytes,1,opt,name=masking_character,json=maskingCharacter,proto3" json:"masking_character,omitempty"`
	// Number of characters to mask. If not set, all matching chars will be
	// masked. Skipped characters do not count towards this tally.
	//
	// If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
	// masks all but a number of characters.
	// For example, suppose you have the following values:
	//
	// - `masking_character` is `*`
	// - `number_to_mask` is `-4`
	// - `reverse_order` is `false`
	// - `CharsToIgnore` includes `-`
	// - Input string is `1234-5678-9012-3456`
	//
	// The resulting de-identified string is
	// `****-****-****-3456`. Cloud DLP masks all but the last four characters.
	// If `reverse_order` is `true`, all but the first four characters are masked
	// as `1234-****-****-****`.
	NumberToMask int32 `protobuf:"varint,2,opt,name=number_to_mask,json=numberToMask,proto3" json:"number_to_mask,omitempty"`
	// Mask characters in reverse order. For example, if `masking_character` is
	// `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
	// input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
	// If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
	// is `true`, then the string `12345` is masked as `12***`.
	ReverseOrder bool `protobuf:"varint,3,opt,name=reverse_order,json=reverseOrder,proto3" json:"reverse_order,omitempty"`
	// When masking a string, items in this list will be skipped when replacing
	// characters. For example, if the input string is `555-555-5555` and you
	// instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
	// returns `***-**5-5555`.
	CharactersToIgnore []*CharsToIgnore `protobuf:"bytes,4,rep,name=characters_to_ignore,json=charactersToIgnore,proto3" json:"characters_to_ignore,omitempty"`
}

func (x *CharacterMaskConfig) Reset() {
	*x = CharacterMaskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CharacterMaskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CharacterMaskConfig) ProtoMessage() {}

func (x *CharacterMaskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CharacterMaskConfig.ProtoReflect.Descriptor instead.
func (*CharacterMaskConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{65}
}

func (x *CharacterMaskConfig) GetMaskingCharacter() string {
	if x != nil {
		return x.MaskingCharacter
	}
	return ""
}

func (x *CharacterMaskConfig) GetNumberToMask() int32 {
	if x != nil {
		return x.NumberToMask
	}
	return 0
}

func (x *CharacterMaskConfig) GetReverseOrder() bool {
	if x != nil {
		return x.ReverseOrder
	}
	return false
}

func (x *CharacterMaskConfig) GetCharactersToIgnore() []*CharsToIgnore {
	if x != nil {
		return x.CharactersToIgnore
	}
	return nil
}

// Buckets values based on fixed size ranges. The
// Bucketing transformation can provide all of this functionality,
// but requires more configuration. This message is provided as a convenience to
// the user for simple bucketing strategies.
//
// The transformed value will be a hyphenated string of
// {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and upper_bound
// = 20, all values that are within this bucket will be replaced with "10-20".
//
// This can be used on data of type: double, long.
//
// If the bound Value type differs from the type of data
// being transformed, we will first attempt converting the type of the data to
// be transformed to match the type of the bound before comparing.
//
// See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
// learn more.
type FixedSizeBucketingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lower bound value of buckets. All values less than `lower_bound`
	// are grouped together into a single bucket; for example if `lower_bound` =
	// 10, then all values less than 10 are replaced with the value "-10".
	LowerBound *Value `protobuf:"bytes,1,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Required. Upper bound value of buckets. All values greater than upper_bound
	// are grouped together into a single bucket; for example if `upper_bound` =
	// 89, then all values greater than 89 are replaced with the value "89+".
	UpperBound *Value `protobuf:"bytes,2,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
	// Required. Size of each bucket (except for minimum and maximum buckets). So
	// if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
	// following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
	// 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
	BucketSize float64 `protobuf:"fixed64,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
}

func (x *FixedSizeBucketingConfig) Reset() {
	*x = FixedSizeBucketingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FixedSizeBucketingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FixedSizeBucketingConfig) ProtoMessage() {}

func (x *FixedSizeBucketingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FixedSizeBucketingConfig.ProtoReflect.Descriptor instead.
func (*FixedSizeBucketingConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{66}
}

func (x *FixedSizeBucketingConfig) GetLowerBound() *Value {
	if x != nil {
		return x.LowerBound
	}
	return nil
}

func (x *FixedSizeBucketingConfig) GetUpperBound() *Value {
	if x != nil {
		return x.UpperBound
	}
	return nil
}

func (x *FixedSizeBucketingConfig) GetBucketSize() float64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

// Generalization function that buckets values based on ranges. The ranges and
// replacement values are dynamically provided by the user for custom behavior,
// such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH
// This can be used on
// data of type: number, long, string, timestamp.
// If the bound `Value` type differs from the type of data being transformed, we
// will first attempt converting the type of the data to be transformed to match
// the type of the bound before comparing.
// See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
// learn more.
type BucketingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of buckets. Ranges must be non-overlapping.
	Buckets []*BucketingConfig_Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *BucketingConfig) Reset() {
	*x = BucketingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketingConfig) ProtoMessage() {}

func (x *BucketingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketingConfig.ProtoReflect.Descriptor instead.
func (*BucketingConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{67}
}

func (x *BucketingConfig) GetBuckets() []*BucketingConfig_Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Replaces an identifier with a surrogate using Format Preserving Encryption
// (FPE) with the FFX mode of operation; however when used in the
// `ReidentifyContent` API method, it serves the opposite function by reversing
// the surrogate back into the original identifier. The identifier must be
// encoded as ASCII. For a given crypto key and context, the same identifier
// will be replaced with the same surrogate. Identifiers must be at least two
// characters long. In the case that the identifier is the empty string, it will
// be skipped. See
// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
// learn more.
//
// Note: We recommend using  CryptoDeterministicConfig for all use cases which
// do not require preserving the input alphabet space and size, plus warrant
// referential integrity.
type CryptoReplaceFfxFpeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key used by the encryption algorithm.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// The 'tweak', a context may be used for higher security since the same
	// identifier in two different contexts won't be given the same surrogate. If
	// the context is not set, a default tweak will be used.
	//
	// If the context is set but:
	//
	// 1. there is no record present when transforming a given value or
	// 1. the field is not present when transforming a given value,
	//
	// a default tweak will be used.
	//
	// Note that case (1) is expected when an `InfoTypeTransformation` is
	// applied to both structured and unstructured `ContentItem`s.
	// Currently, the referenced field may be of value type integer or string.
	//
	// The tweak is constructed as a sequence of bytes in big endian byte order
	// such that:
	//
	// - a 64 bit integer is encoded followed by a single byte of value 1
	// - a string is encoded in UTF-8 format followed by a single byte of value 2
	Context *FieldId `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
	// Choose an alphabet which the data being transformed will be made up of.
	//
	// Types that are assignable to Alphabet:
	//
	//	*CryptoReplaceFfxFpeConfig_CommonAlphabet
	//	*CryptoReplaceFfxFpeConfig_CustomAlphabet
	//	*CryptoReplaceFfxFpeConfig_Radix
	Alphabet isCryptoReplaceFfxFpeConfig_Alphabet `protobuf_oneof:"alphabet"`
	// The custom infoType to annotate the surrogate with.
	// This annotation will be applied to the surrogate by prefixing it with
	// the name of the custom infoType followed by the number of
	// characters comprising the surrogate. The following scheme defines the
	// format: info_type_name(surrogate_character_count):surrogate
	//
	// For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
	// the surrogate is 'abc', the full replacement value
	// will be: 'MY_TOKEN_INFO_TYPE(3):abc'
	//
	// This annotation identifies the surrogate when inspecting content using the
	// custom infoType
	// [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
	// This facilitates reversal of the surrogate when it occurs in free text.
	//
	// In order for inspection to work properly, the name of this infoType must
	// not occur naturally anywhere in your data; otherwise, inspection may
	// find a surrogate that does not correspond to an actual identifier.
	// Therefore, choose your custom infoType name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data.
	// For example, assuming your data is entered from a regular ASCII keyboard,
	// the symbol with the hex code point 29DD might be used like so:
	// ⧝MY_TOKEN_TYPE
	SurrogateInfoType *InfoType `protobuf:"bytes,8,opt,name=surrogate_info_type,json=surrogateInfoType,proto3" json:"surrogate_info_type,omitempty"`
}

func (x *CryptoReplaceFfxFpeConfig) Reset() {
	*x = CryptoReplaceFfxFpeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoReplaceFfxFpeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoReplaceFfxFpeConfig) ProtoMessage() {}

func (x *CryptoReplaceFfxFpeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoReplaceFfxFpeConfig.ProtoReflect.Descriptor instead.
func (*CryptoReplaceFfxFpeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{68}
}

func (x *CryptoReplaceFfxFpeConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

func (x *CryptoReplaceFfxFpeConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

func (m *CryptoReplaceFfxFpeConfig) GetAlphabet() isCryptoReplaceFfxFpeConfig_Alphabet {
	if m != nil {
		return m.Alphabet
	}
	return nil
}

func (x *CryptoReplaceFfxFpeConfig) GetCommonAlphabet() CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CommonAlphabet); ok {
		return x.CommonAlphabet
	}
	return CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED
}

func (x *CryptoReplaceFfxFpeConfig) GetCustomAlphabet() string {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CustomAlphabet); ok {
		return x.CustomAlphabet
	}
	return ""
}

func (x *CryptoReplaceFfxFpeConfig) GetRadix() int32 {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_Radix); ok {
		return x.Radix
	}
	return 0
}

func (x *CryptoReplaceFfxFpeConfig) GetSurrogateInfoType() *InfoType {
	if x != nil {
		return x.SurrogateInfoType
	}
	return nil
}

type isCryptoReplaceFfxFpeConfig_Alphabet interface {
	isCryptoReplaceFfxFpeConfig_Alphabet()
}

type CryptoReplaceFfxFpeConfig_CommonAlphabet struct {
	// Common alphabets.
	CommonAlphabet CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet `protobuf:"varint,4,opt,name=common_alphabet,json=commonAlphabet,proto3,enum=google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet,oneof"`
}

type CryptoReplaceFfxFpeConfig_CustomAlphabet struct {
	// This is supported by mapping these to the alphanumeric characters
	// that the FFX mode natively supports. This happens before/after
	// encryption/decryption.
	// Each character listed must appear only once.
	// Number of characters must be in the range [2, 95].
	// This must be encoded as ASCII.
	// The order of characters does not matter.
	// The full list of allowed characters is:
	// <code>0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
	// ~`!@#$%^&*()_-+={[}]|\:;"'<,>.?/</code>
	CustomAlphabet string `protobuf:"bytes,5,opt,name=custom_alphabet,json=customAlphabet,proto3,oneof"`
}

type CryptoReplaceFfxFpeConfig_Radix struct {
	// The native way to select the alphabet. Must be in the range [2, 95].
	Radix int32 `protobuf:"varint,6,opt,name=radix,proto3,oneof"`
}

func (*CryptoReplaceFfxFpeConfig_CommonAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}

func (*CryptoReplaceFfxFpeConfig_CustomAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}

func (*CryptoReplaceFfxFpeConfig_Radix) isCryptoReplaceFfxFpeConfig_Alphabet() {}

// This is a data encryption key (DEK) (as opposed to
// a key encryption key (KEK) stored by Cloud Key Management Service
// (Cloud KMS).
// When using Cloud KMS to wrap or unwrap a DEK, be sure to set an appropriate
// IAM policy on the KEK to ensure an attacker cannot
// unwrap the DEK.
type CryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources of crypto keys.
	//
	// Types that are assignable to Source:
	//
	//	*CryptoKey_Transient
	//	*CryptoKey_Unwrapped
	//	*CryptoKey_KmsWrapped
	Source isCryptoKey_Source `protobuf_oneof:"source"`
}

func (x *CryptoKey) Reset() {
	*x = CryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKey) ProtoMessage() {}

func (x *CryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKey.ProtoReflect.Descriptor instead.
func (*CryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69}
}

func (m *CryptoKey) GetSource() isCryptoKey_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CryptoKey) GetTransient() *TransientCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_Transient); ok {
		return x.Transient
	}
	return nil
}

func (x *CryptoKey) GetUnwrapped() *UnwrappedCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_Unwrapped); ok {
		return x.Unwrapped
	}
	return nil
}

func (x *CryptoKey) GetKmsWrapped() *KmsWrappedCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_KmsWrapped); ok {
		return x.KmsWrapped
	}
	return nil
}

type isCryptoKey_Source interface {
	isCryptoKey_Source()
}

type CryptoKey_Transient struct {
	// Transient crypto key
	Transient *TransientCryptoKey `protobuf:"bytes,1,opt,name=transient,proto3,oneof"`
}

type CryptoKey_Unwrapped struct {
	// Unwrapped crypto key
	Unwrapped *UnwrappedCryptoKey `protobuf:"bytes,2,opt,name=unwrapped,proto3,oneof"`
}

type CryptoKey_KmsWrapped struct {
	// Key wrapped using Cloud KMS
	KmsWrapped *KmsWrappedCryptoKey `protobuf:"bytes,3,opt,name=kms_wrapped,json=kmsWrapped,proto3,oneof"`
}

func (*CryptoKey_Transient) isCryptoKey_Source() {}

func (*CryptoKey_Unwrapped) isCryptoKey_Source() {}

func (*CryptoKey_KmsWrapped) isCryptoKey_Source() {}

// Use this to have a random data crypto key generated.
// It will be discarded after the request finishes.
type TransientCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the key.
	// This is an arbitrary string used to differentiate different keys.
	// A unique key is generated per name: two separate `TransientCryptoKey`
	// protos share the same generated key if their names are the same.
	// When the data crypto key is generated, this name is not used in any way
	// (repeating the api call will result in a different key being generated).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *TransientCryptoKey) Reset() {
	*x = TransientCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransientCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransientCryptoKey) ProtoMessage() {}

func (x *TransientCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransientCryptoKey.ProtoReflect.Descriptor instead.
func (*TransientCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{70}
}

func (x *TransientCryptoKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Using raw keys is prone to security risks due to accidentally
// leaking the key. Choose another type of key if possible.
type UnwrappedCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A 128/192/256 bit key.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *UnwrappedCryptoKey) Reset() {
	*x = UnwrappedCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnwrappedCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnwrappedCryptoKey) ProtoMessage() {}

func (x *UnwrappedCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnwrappedCryptoKey.ProtoReflect.Descriptor instead.
func (*UnwrappedCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{71}
}

func (x *UnwrappedCryptoKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

// Include to use an existing data crypto key wrapped by KMS.
// The wrapped key must be a 128-, 192-, or 256-bit key.
// Authorization requires the following IAM permissions when sending a request
// to perform a crypto transformation using a KMS-wrapped crypto key:
// dlp.kms.encrypt
//
// For more information, see [Creating a wrapped key]
// (https://cloud.google.com/sensitive-data-protection/docs/create-wrapped-key).
//
// Note: When you use Cloud KMS for cryptographic operations,
// [charges apply](https://cloud.google.com/kms/pricing).
type KmsWrappedCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The wrapped data crypto key.
	WrappedKey []byte `protobuf:"bytes,1,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
	// Required. The resource name of the KMS CryptoKey to use for unwrapping.
	CryptoKeyName string `protobuf:"bytes,2,opt,name=crypto_key_name,json=cryptoKeyName,proto3" json:"crypto_key_name,omitempty"`
}

func (x *KmsWrappedCryptoKey) Reset() {
	*x = KmsWrappedCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KmsWrappedCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsWrappedCryptoKey) ProtoMessage() {}

func (x *KmsWrappedCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsWrappedCryptoKey.ProtoReflect.Descriptor instead.
func (*KmsWrappedCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{72}
}

func (x *KmsWrappedCryptoKey) GetWrappedKey() []byte {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

func (x *KmsWrappedCryptoKey) GetCryptoKeyName() string {
	if x != nil {
		return x.CryptoKeyName
	}
	return ""
}

// Shifts dates by random number of days, with option to be consistent for the
// same context. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-date-shifting
// to learn more.
type DateShiftConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Range of shift in days. Actual shift will be selected at random
	// within this range (inclusive ends). Negative means shift to earlier in
	// time. Must not be more than 365250 days (1000 years) each direction.
	//
	// For example, 3 means shift date to at most 3 days into the future.
	UpperBoundDays int32 `protobuf:"varint,1,opt,name=upper_bound_days,json=upperBoundDays,proto3" json:"upper_bound_days,omitempty"`
	// Required. For example, -5 means shift date to at most 5 days back in the
	// past.
	LowerBoundDays int32 `protobuf:"varint,2,opt,name=lower_bound_days,json=lowerBoundDays,proto3" json:"lower_bound_days,omitempty"`
	// Points to the field that contains the context, for example, an entity id.
	// If set, must also set cryptoKey. If set, shift will be consistent for the
	// given context.
	Context *FieldId `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
	// Method for calculating shift that takes context into consideration. If
	// set, must also set context. Can only be applied to table items.
	//
	// Types that are assignable to Method:
	//
	//	*DateShiftConfig_CryptoKey
	Method isDateShiftConfig_Method `protobuf_oneof:"method"`
}

func (x *DateShiftConfig) Reset() {
	*x = DateShiftConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateShiftConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateShiftConfig) ProtoMessage() {}

func (x *DateShiftConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateShiftConfig.ProtoReflect.Descriptor instead.
func (*DateShiftConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{73}
}

func (x *DateShiftConfig) GetUpperBoundDays() int32 {
	if x != nil {
		return x.UpperBoundDays
	}
	return 0
}

func (x *DateShiftConfig) GetLowerBoundDays() int32 {
	if x != nil {
		return x.LowerBoundDays
	}
	return 0
}

func (x *DateShiftConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

func (m *DateShiftConfig) GetMethod() isDateShiftConfig_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (x *DateShiftConfig) GetCryptoKey() *CryptoKey {
	if x, ok := x.GetMethod().(*DateShiftConfig_CryptoKey); ok {
		return x.CryptoKey
	}
	return nil
}

type isDateShiftConfig_Method interface {
	isDateShiftConfig_Method()
}

type DateShiftConfig_CryptoKey struct {
	// Causes the shift to be computed based on this key and the context. This
	// results in the same shift for the same context and crypto_key. If
	// set, must also set context. Can only be applied to table items.
	CryptoKey *CryptoKey `protobuf:"bytes,4,opt,name=crypto_key,json=cryptoKey,proto3,oneof"`
}

func (*DateShiftConfig_CryptoKey) isDateShiftConfig_Method() {}

// A type of transformation that will scan unstructured text and
// apply various `PrimitiveTransformation`s to each finding, where the
// transformation is applied to only values that were identified as a specific
// info_type.
type InfoTypeTransformations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transformation for each infoType. Cannot specify more than one
	// for a given infoType.
	Transformations []*InfoTypeTransformations_InfoTypeTransformation `protobuf:"bytes,1,rep,name=transformations,proto3" json:"transformations,omitempty"`
}

func (x *InfoTypeTransformations) Reset() {
	*x = InfoTypeTransformations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeTransformations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeTransformations) ProtoMessage() {}

func (x *InfoTypeTransformations) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeTransformations.ProtoReflect.Descriptor instead.
func (*InfoTypeTransformations) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{74}
}

func (x *InfoTypeTransformations) GetTransformations() []*InfoTypeTransformations_InfoTypeTransformation {
	if x != nil {
		return x.Transformations
	}
	return nil
}

// The transformation to apply to the field.
type FieldTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input field(s) to apply the transformation to.
	// When you have columns that reference their position within a list,
	// omit the index from the FieldId. FieldId name matching ignores the index.
	// For example, instead of "contact.nums[0].type", use "contact.nums.type".
	Fields []*FieldId `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	// Only apply the transformation if the condition evaluates to true for the
	// given `RecordCondition`. The conditions are allowed to reference fields
	// that are not used in the actual transformation.
	//
	// Example Use Cases:
	//
	// - Apply a different bucket transformation to an age column if the zip code
	// column for the same record is within a specific range.
	// - Redact a field if the date of birth field is greater than 85.
	Condition *RecordCondition `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Transformation to apply. [required]
	//
	// Types that are assignable to Transformation:
	//
	//	*FieldTransformation_PrimitiveTransformation
	//	*FieldTransformation_InfoTypeTransformations
	Transformation isFieldTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (x *FieldTransformation) Reset() {
	*x = FieldTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldTransformation) ProtoMessage() {}

func (x *FieldTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldTransformation.ProtoReflect.Descriptor instead.
func (*FieldTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{75}
}

func (x *FieldTransformation) GetFields() []*FieldId {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *FieldTransformation) GetCondition() *RecordCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (m *FieldTransformation) GetTransformation() isFieldTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *FieldTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if x, ok := x.GetTransformation().(*FieldTransformation_PrimitiveTransformation); ok {
		return x.PrimitiveTransformation
	}
	return nil
}

func (x *FieldTransformation) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := x.GetTransformation().(*FieldTransformation_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

type isFieldTransformation_Transformation interface {
	isFieldTransformation_Transformation()
}

type FieldTransformation_PrimitiveTransformation struct {
	// Apply the transformation to the entire field.
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,4,opt,name=primitive_transformation,json=primitiveTransformation,proto3,oneof"`
}

type FieldTransformation_InfoTypeTransformations struct {
	// Treat the contents of the field as free text, and selectively
	// transform content that matches an `InfoType`.
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,5,opt,name=info_type_transformations,json=infoTypeTransformations,proto3,oneof"`
}

func (*FieldTransformation_PrimitiveTransformation) isFieldTransformation_Transformation() {}

func (*FieldTransformation_InfoTypeTransformations) isFieldTransformation_Transformation() {}

// A type of transformation that is applied over structured data such as a
// table.
type RecordTransformations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transform the record by applying various field transformations.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,1,rep,name=field_transformations,json=fieldTransformations,proto3" json:"field_transformations,omitempty"`
	// Configuration defining which records get suppressed entirely. Records that
	// match any suppression rule are omitted from the output.
	RecordSuppressions []*RecordSuppression `protobuf:"bytes,2,rep,name=record_suppressions,json=recordSuppressions,proto3" json:"record_suppressions,omitempty"`
}

func (x *RecordTransformations) Reset() {
	*x = RecordTransformations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordTransformations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordTransformations) ProtoMessage() {}

func (x *RecordTransformations) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordTransformations.ProtoReflect.Descriptor instead.
func (*RecordTransformations) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{76}
}

func (x *RecordTransformations) GetFieldTransformations() []*FieldTransformation {
	if x != nil {
		return x.FieldTransformations
	}
	return nil
}

func (x *RecordTransformations) GetRecordSuppressions() []*RecordSuppression {
	if x != nil {
		return x.RecordSuppressions
	}
	return nil
}

// Configuration to suppress records whose suppression conditions evaluate to
// true.
type RecordSuppression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A condition that when it evaluates to true will result in the record being
	// evaluated to be suppressed from the transformed content.
	Condition *RecordCondition `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *RecordSuppression) Reset() {
	*x = RecordSuppression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordSuppression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordSuppression) ProtoMessage() {}

func (x *RecordSuppression) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordSuppression.ProtoReflect.Descriptor instead.
func (*RecordSuppression) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{77}
}

func (x *RecordSuppression) GetCondition() *RecordCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// A condition for determining whether a transformation should be applied to
// a field.
type RecordCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression.
	Expressions *RecordCondition_Expressions `protobuf:"bytes,3,opt,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *RecordCondition) Reset() {
	*x = RecordCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition) ProtoMessage() {}

func (x *RecordCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition.ProtoReflect.Descriptor instead.
func (*RecordCondition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78}
}

func (x *RecordCondition) GetExpressions() *RecordCondition_Expressions {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// Overview of the modifications that occurred.
type TransformationOverview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,2,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
	// Transformations applied to the dataset.
	TransformationSummaries []*TransformationSummary `protobuf:"bytes,3,rep,name=transformation_summaries,json=transformationSummaries,proto3" json:"transformation_summaries,omitempty"`
}

func (x *TransformationOverview) Reset() {
	*x = TransformationOverview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationOverview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationOverview) ProtoMessage() {}

func (x *TransformationOverview) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationOverview.ProtoReflect.Descriptor instead.
func (*TransformationOverview) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{79}
}

func (x *TransformationOverview) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

func (x *TransformationOverview) GetTransformationSummaries() []*TransformationSummary {
	if x != nil {
		return x.TransformationSummaries
	}
	return nil
}

// Summary of a single transformation.
// Only one of 'transformation', 'field_transformation', or 'record_suppress'
// will be set.
type TransformationSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set if the transformation was limited to a specific InfoType.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Set if the transformation was limited to a specific FieldId.
	Field *FieldId `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// The specific transformation these stats apply to.
	Transformation *PrimitiveTransformation `protobuf:"bytes,3,opt,name=transformation,proto3" json:"transformation,omitempty"`
	// The field transformation that was applied.
	// If multiple field transformations are requested for a single field,
	// this list will contain all of them; otherwise, only one is supplied.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,5,rep,name=field_transformations,json=fieldTransformations,proto3" json:"field_transformations,omitempty"`
	// The specific suppression option these stats apply to.
	RecordSuppress *RecordSuppression `protobuf:"bytes,6,opt,name=record_suppress,json=recordSuppress,proto3" json:"record_suppress,omitempty"`
	// Collection of all transformations that took place or had an error.
	Results []*TransformationSummary_SummaryResult `protobuf:"bytes,4,rep,name=results,proto3" json:"results,omitempty"`
	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,7,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
}

func (x *TransformationSummary) Reset() {
	*x = TransformationSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationSummary) ProtoMessage() {}

func (x *TransformationSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationSummary.ProtoReflect.Descriptor instead.
func (*TransformationSummary) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{80}
}

func (x *TransformationSummary) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *TransformationSummary) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *TransformationSummary) GetTransformation() *PrimitiveTransformation {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *TransformationSummary) GetFieldTransformations() []*FieldTransformation {
	if x != nil {
		return x.FieldTransformations
	}
	return nil
}

func (x *TransformationSummary) GetRecordSuppress() *RecordSuppression {
	if x != nil {
		return x.RecordSuppress
	}
	return nil
}

func (x *TransformationSummary) GetResults() []*TransformationSummary_SummaryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *TransformationSummary) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

// A flattened description of a `PrimitiveTransformation` or
// `RecordSuppression`.
type TransformationDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transformation type.
	Type TransformationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.privacy.dlp.v2.TransformationType" json:"type,omitempty"`
	// A description of the transformation. This is empty for a
	// RECORD_SUPPRESSION, or is the output of calling toString() on the
	// `PrimitiveTransformation` protocol buffer message for any other type of
	// transformation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A human-readable string representation of the `RecordCondition`
	// corresponding to this transformation. Set if a `RecordCondition` was used
	// to determine whether or not to apply this transformation.
	//
	// Examples:
	//   - (age_field > 85)
	//   - (age_field <= 18)
	//   - (zip_field exists)
	//   - (zip_field == 01234) && (city_field != "Springville")
	//   - (zip_field == 01234) && (age_field <= 18) && (city_field exists)
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Set if the transformation was limited to a specific `InfoType`.
	InfoType *InfoType `protobuf:"bytes,4,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
}

func (x *TransformationDescription) Reset() {
	*x = TransformationDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationDescription) ProtoMessage() {}

func (x *TransformationDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationDescription.ProtoReflect.Descriptor instead.
func (*TransformationDescription) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{81}
}

func (x *TransformationDescription) GetType() TransformationType {
	if x != nil {
		return x.Type
	}
	return TransformationType_TRANSFORMATION_TYPE_UNSPECIFIED
}

func (x *TransformationDescription) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransformationDescription) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *TransformationDescription) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

// Details about a single transformation. This object contains a description of
// the transformation, information about whether the transformation was
// successfully applied, and the precise location where the transformation
// occurred. These details are stored in a user-specified BigQuery table.
type TransformationDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the job that completed the transformation.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The top level name of the container where the transformation is located
	// (this will be the source file name or table name).
	ContainerName string `protobuf:"bytes,2,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	// Description of transformation. This would only contain more than one
	// element if there were multiple matching transformations and which one to
	// apply was ambiguous. Not set for states that contain no transformation,
	// currently only state that contains no transformation is
	// TransformationResultStateType.METADATA_UNRETRIEVABLE.
	Transformation []*TransformationDescription `protobuf:"bytes,3,rep,name=transformation,proto3" json:"transformation,omitempty"`
	// Status of the transformation, if transformation was not successful, this
	// will specify what caused it to fail, otherwise it will show that the
	// transformation was successful.
	StatusDetails *TransformationResultStatus `protobuf:"bytes,4,opt,name=status_details,json=statusDetails,proto3" json:"status_details,omitempty"`
	// The number of bytes that were transformed. If transformation was
	// unsuccessful or did not take place because there was no content to
	// transform, this will be zero.
	TransformedBytes int64 `protobuf:"varint,5,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
	// The precise location of the transformed content in the original container.
	TransformationLocation *TransformationLocation `protobuf:"bytes,6,opt,name=transformation_location,json=transformationLocation,proto3" json:"transformation_location,omitempty"`
}

func (x *TransformationDetails) Reset() {
	*x = TransformationDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationDetails) ProtoMessage() {}

func (x *TransformationDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationDetails.ProtoReflect.Descriptor instead.
func (*TransformationDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{82}
}

func (x *TransformationDetails) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *TransformationDetails) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (x *TransformationDetails) GetTransformation() []*TransformationDescription {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *TransformationDetails) GetStatusDetails() *TransformationResultStatus {
	if x != nil {
		return x.StatusDetails
	}
	return nil
}

func (x *TransformationDetails) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

func (x *TransformationDetails) GetTransformationLocation() *TransformationLocation {
	if x != nil {
		return x.TransformationLocation
	}
	return nil
}

// Specifies the location of a transformation.
type TransformationLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location type.
	//
	// Types that are assignable to LocationType:
	//
	//	*TransformationLocation_FindingId
	//	*TransformationLocation_RecordTransformation
	LocationType isTransformationLocation_LocationType `protobuf_oneof:"location_type"`
	// Information about the functionality of the container where this finding
	// occurred, if available.
	ContainerType TransformationContainerType `protobuf:"varint,3,opt,name=container_type,json=containerType,proto3,enum=google.privacy.dlp.v2.TransformationContainerType" json:"container_type,omitempty"`
}

func (x *TransformationLocation) Reset() {
	*x = TransformationLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationLocation) ProtoMessage() {}

func (x *TransformationLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationLocation.ProtoReflect.Descriptor instead.
func (*TransformationLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{83}
}

func (m *TransformationLocation) GetLocationType() isTransformationLocation_LocationType {
	if m != nil {
		return m.LocationType
	}
	return nil
}

func (x *TransformationLocation) GetFindingId() string {
	if x, ok := x.GetLocationType().(*TransformationLocation_FindingId); ok {
		return x.FindingId
	}
	return ""
}

func (x *TransformationLocation) GetRecordTransformation() *RecordTransformation {
	if x, ok := x.GetLocationType().(*TransformationLocation_RecordTransformation); ok {
		return x.RecordTransformation
	}
	return nil
}

func (x *TransformationLocation) GetContainerType() TransformationContainerType {
	if x != nil {
		return x.ContainerType
	}
	return TransformationContainerType_TRANSFORM_UNKNOWN_CONTAINER
}

type isTransformationLocation_LocationType interface {
	isTransformationLocation_LocationType()
}

type TransformationLocation_FindingId struct {
	// For infotype transformations, link to the corresponding findings ID so
	// that location information does not need to be duplicated. Each findings
	// ID correlates to an entry in the findings output table, this table only
	// gets created when users specify to save findings (add the save findings
	// action to the request).
	FindingId string `protobuf:"bytes,1,opt,name=finding_id,json=findingId,proto3,oneof"`
}

type TransformationLocation_RecordTransformation struct {
	// For record transformations, provide a field and container information.
	RecordTransformation *RecordTransformation `protobuf:"bytes,2,opt,name=record_transformation,json=recordTransformation,proto3,oneof"`
}

func (*TransformationLocation_FindingId) isTransformationLocation_LocationType() {}

func (*TransformationLocation_RecordTransformation) isTransformationLocation_LocationType() {}

// The field in a record to transform.
type RecordTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For record transformations, provide a field.
	FieldId *FieldId `protobuf:"bytes,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Findings container modification timestamp, if applicable.
	ContainerTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=container_timestamp,json=containerTimestamp,proto3" json:"container_timestamp,omitempty"`
	// Container version, if available ("generation" for Cloud Storage).
	ContainerVersion string `protobuf:"bytes,3,opt,name=container_version,json=containerVersion,proto3" json:"container_version,omitempty"`
}

func (x *RecordTransformation) Reset() {
	*x = RecordTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordTransformation) ProtoMessage() {}

func (x *RecordTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordTransformation.ProtoReflect.Descriptor instead.
func (*RecordTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{84}
}

func (x *RecordTransformation) GetFieldId() *FieldId {
	if x != nil {
		return x.FieldId
	}
	return nil
}

func (x *RecordTransformation) GetContainerTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.ContainerTimestamp
	}
	return nil
}

func (x *RecordTransformation) GetContainerVersion() string {
	if x != nil {
		return x.ContainerVersion
	}
	return ""
}

// The outcome of a transformation.
type TransformationResultStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transformation result status type, this will be either SUCCESS, or it will
	// be the reason for why the transformation was not completely successful.
	ResultStatusType TransformationResultStatusType `protobuf:"varint,1,opt,name=result_status_type,json=resultStatusType,proto3,enum=google.privacy.dlp.v2.TransformationResultStatusType" json:"result_status_type,omitempty"`
	// Detailed error codes and messages
	Details *status.Status `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *TransformationResultStatus) Reset() {
	*x = TransformationResultStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationResultStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationResultStatus) ProtoMessage() {}

func (x *TransformationResultStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationResultStatus.ProtoReflect.Descriptor instead.
func (*TransformationResultStatus) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{85}
}

func (x *TransformationResultStatus) GetResultStatusType() TransformationResultStatusType {
	if x != nil {
		return x.ResultStatusType
	}
	return TransformationResultStatusType_STATE_TYPE_UNSPECIFIED
}

func (x *TransformationResultStatus) GetDetails() *status.Status {
	if x != nil {
		return x.Details
	}
	return nil
}

// Config for storing transformation details.
type TransformationDetailsStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location to store the transformation summary.
	//
	// Types that are assignable to Type:
	//
	//	*TransformationDetailsStorageConfig_Table
	Type isTransformationDetailsStorageConfig_Type `protobuf_oneof:"type"`
}

func (x *TransformationDetailsStorageConfig) Reset() {
	*x = TransformationDetailsStorageConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationDetailsStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationDetailsStorageConfig) ProtoMessage() {}

func (x *TransformationDetailsStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationDetailsStorageConfig.ProtoReflect.Descriptor instead.
func (*TransformationDetailsStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{86}
}

func (m *TransformationDetailsStorageConfig) GetType() isTransformationDetailsStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *TransformationDetailsStorageConfig) GetTable() *BigQueryTable {
	if x, ok := x.GetType().(*TransformationDetailsStorageConfig_Table); ok {
		return x.Table
	}
	return nil
}

type isTransformationDetailsStorageConfig_Type interface {
	isTransformationDetailsStorageConfig_Type()
}

type TransformationDetailsStorageConfig_Table struct {
	// The BigQuery table in which to store the output. This may be an existing
	// table or in a new table in an existing dataset.
	// If table_id is not set a new one will be generated for you with the
	// following format:
	// dlp_googleapis_transformation_details_yyyy_mm_dd_[dlp_job_id]. Pacific
	// time zone will be used for generating the date details.
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,proto3,oneof"`
}

func (*TransformationDetailsStorageConfig_Table) isTransformationDetailsStorageConfig_Type() {}

// Schedule for inspect job triggers.
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of schedule.
	//
	// Types that are assignable to Option:
	//
	//	*Schedule_RecurrencePeriodDuration
	Option isSchedule_Option `protobuf_oneof:"option"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{87}
}

func (m *Schedule) GetOption() isSchedule_Option {
	if m != nil {
		return m.Option
	}
	return nil
}

func (x *Schedule) GetRecurrencePeriodDuration() *durationpb.Duration {
	if x, ok := x.GetOption().(*Schedule_RecurrencePeriodDuration); ok {
		return x.RecurrencePeriodDuration
	}
	return nil
}

type isSchedule_Option interface {
	isSchedule_Option()
}

type Schedule_RecurrencePeriodDuration struct {
	// With this option a job is started on a regular periodic basis. For
	// example: every day (86400 seconds).
	//
	// A scheduled start time will be skipped if the previous
	// execution has not ended when its scheduled time occurs.
	//
	// This value must be set to a time duration greater than or equal
	// to 1 day and can be no longer than 60 days.
	RecurrencePeriodDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=recurrence_period_duration,json=recurrencePeriodDuration,proto3,oneof"`
}

func (*Schedule_RecurrencePeriodDuration) isSchedule_Option() {}

// Job trigger option for hybrid jobs. Jobs must be manually created
// and finished.
type Manual struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Manual) Reset() {
	*x = Manual{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manual) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manual) ProtoMessage() {}

func (x *Manual) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manual.ProtoReflect.Descriptor instead.
func (*Manual) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{88}
}

// The inspectTemplate contains a configuration (set of types of sensitive data
// to be detected) to be used anywhere you otherwise would normally specify
// InspectConfig. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-templates to
// learn more.
type InspectTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The template name.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of an inspectTemplate.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of an inspectTemplate.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The core content of the template. Configuration of the scanning process.
	InspectConfig *InspectConfig `protobuf:"bytes,6,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
}

func (x *InspectTemplate) Reset() {
	*x = InspectTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectTemplate) ProtoMessage() {}

func (x *InspectTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectTemplate.ProtoReflect.Descriptor instead.
func (*InspectTemplate) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{89}
}

func (x *InspectTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InspectTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InspectTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InspectTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InspectTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InspectTemplate) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

// DeidentifyTemplates contains instructions on how to de-identify content.
// See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-templates to
// learn more.
type DeidentifyTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The template name.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of an inspectTemplate.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of an inspectTemplate.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The core content of the template.
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,6,opt,name=deidentify_config,json=deidentifyConfig,proto3" json:"deidentify_config,omitempty"`
}

func (x *DeidentifyTemplate) Reset() {
	*x = DeidentifyTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyTemplate) ProtoMessage() {}

func (x *DeidentifyTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyTemplate.ProtoReflect.Descriptor instead.
func (*DeidentifyTemplate) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{90}
}

func (x *DeidentifyTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeidentifyTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DeidentifyTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DeidentifyTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeidentifyTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DeidentifyTemplate) GetDeidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.DeidentifyConfig
	}
	return nil
}

// Details information about an error encountered during job execution or
// the results of an unsuccessful activation of the JobTrigger.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detailed error codes and messages.
	Details *status.Status `protobuf:"bytes,1,opt,name=details,proto3" json:"details,omitempty"`
	// The times the error occurred. List includes the oldest timestamp and the
	// last 9 timestamps.
	Timestamps []*timestamppb.Timestamp `protobuf:"bytes,2,rep,name=timestamps,proto3" json:"timestamps,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{91}
}

func (x *Error) GetDetails() *status.Status {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Error) GetTimestamps() []*timestamppb.Timestamp {
	if x != nil {
		return x.Timestamps
	}
	return nil
}

// Contains a configuration to make dlp api calls on a repeating basis.
// See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-job-triggers
// to learn more.
type JobTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique resource name for the triggeredJob, assigned by the service when the
	// triggeredJob is created, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 100 chars)
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User provided description (max 256 chars)
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration details for the specific type of job to run.
	//
	// Types that are assignable to Job:
	//
	//	*JobTrigger_InspectJob
	Job isJobTrigger_Job `protobuf_oneof:"job"`
	// A list of triggers which will be OR'ed together. Only one in the list
	// needs to trigger for a job to be started. The list may contain only
	// a single Schedule trigger and must have at least one object.
	Triggers []*JobTrigger_Trigger `protobuf:"bytes,5,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Output only. A stream of errors encountered when the trigger was activated.
	// Repeated errors may result in the JobTrigger automatically being paused.
	// Will return the last 100 errors. Whenever the JobTrigger is modified
	// this list will be cleared.
	Errors []*Error `protobuf:"bytes,6,rep,name=errors,proto3" json:"errors,omitempty"`
	// Output only. The creation timestamp of a triggeredJob.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a triggeredJob.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The timestamp of the last time this trigger executed.
	LastRunTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_run_time,json=lastRunTime,proto3" json:"last_run_time,omitempty"`
	// Required. A status for this trigger.
	Status JobTrigger_Status `protobuf:"varint,10,opt,name=status,proto3,enum=google.privacy.dlp.v2.JobTrigger_Status" json:"status,omitempty"`
}

func (x *JobTrigger) Reset() {
	*x = JobTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTrigger) ProtoMessage() {}

func (x *JobTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTrigger.ProtoReflect.Descriptor instead.
func (*JobTrigger) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{92}
}

func (x *JobTrigger) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobTrigger) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *JobTrigger) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *JobTrigger) GetJob() isJobTrigger_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (x *JobTrigger) GetInspectJob() *InspectJobConfig {
	if x, ok := x.GetJob().(*JobTrigger_InspectJob); ok {
		return x.InspectJob
	}
	return nil
}

func (x *JobTrigger) GetTriggers() []*JobTrigger_Trigger {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *JobTrigger) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *JobTrigger) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *JobTrigger) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *JobTrigger) GetLastRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRunTime
	}
	return nil
}

func (x *JobTrigger) GetStatus() JobTrigger_Status {
	if x != nil {
		return x.Status
	}
	return JobTrigger_STATUS_UNSPECIFIED
}

type isJobTrigger_Job interface {
	isJobTrigger_Job()
}

type JobTrigger_InspectJob struct {
	// For inspect jobs, a snapshot of the configuration.
	InspectJob *InspectJobConfig `protobuf:"bytes,4,opt,name=inspect_job,json=inspectJob,proto3,oneof"`
}

func (*JobTrigger_InspectJob) isJobTrigger_Job() {}

// A task to execute on the completion of a job.
// See https://cloud.google.com/sensitive-data-protection/docs/concepts-actions
// to learn more.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Extra events to execute after the job has finished.
	//
	// Types that are assignable to Action:
	//
	//	*Action_SaveFindings_
	//	*Action_PubSub
	//	*Action_PublishSummaryToCscc_
	//	*Action_PublishFindingsToCloudDataCatalog_
	//	*Action_Deidentify_
	//	*Action_JobNotificationEmails_
	//	*Action_PublishToStackdriver_
	Action isAction_Action `protobuf_oneof:"action"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93}
}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Action) GetSaveFindings() *Action_SaveFindings {
	if x, ok := x.GetAction().(*Action_SaveFindings_); ok {
		return x.SaveFindings
	}
	return nil
}

func (x *Action) GetPubSub() *Action_PublishToPubSub {
	if x, ok := x.GetAction().(*Action_PubSub); ok {
		return x.PubSub
	}
	return nil
}

func (x *Action) GetPublishSummaryToCscc() *Action_PublishSummaryToCscc {
	if x, ok := x.GetAction().(*Action_PublishSummaryToCscc_); ok {
		return x.PublishSummaryToCscc
	}
	return nil
}

func (x *Action) GetPublishFindingsToCloudDataCatalog() *Action_PublishFindingsToCloudDataCatalog {
	if x, ok := x.GetAction().(*Action_PublishFindingsToCloudDataCatalog_); ok {
		return x.PublishFindingsToCloudDataCatalog
	}
	return nil
}

func (x *Action) GetDeidentify() *Action_Deidentify {
	if x, ok := x.GetAction().(*Action_Deidentify_); ok {
		return x.Deidentify
	}
	return nil
}

func (x *Action) GetJobNotificationEmails() *Action_JobNotificationEmails {
	if x, ok := x.GetAction().(*Action_JobNotificationEmails_); ok {
		return x.JobNotificationEmails
	}
	return nil
}

func (x *Action) GetPublishToStackdriver() *Action_PublishToStackdriver {
	if x, ok := x.GetAction().(*Action_PublishToStackdriver_); ok {
		return x.PublishToStackdriver
	}
	return nil
}

type isAction_Action interface {
	isAction_Action()
}

type Action_SaveFindings_ struct {
	// Save resulting findings in a provided location.
	SaveFindings *Action_SaveFindings `protobuf:"bytes,1,opt,name=save_findings,json=saveFindings,proto3,oneof"`
}

type Action_PubSub struct {
	// Publish a notification to a Pub/Sub topic.
	PubSub *Action_PublishToPubSub `protobuf:"bytes,2,opt,name=pub_sub,json=pubSub,proto3,oneof"`
}

type Action_PublishSummaryToCscc_ struct {
	// Publish summary to Cloud Security Command Center (Alpha).
	PublishSummaryToCscc *Action_PublishSummaryToCscc `protobuf:"bytes,3,opt,name=publish_summary_to_cscc,json=publishSummaryToCscc,proto3,oneof"`
}

type Action_PublishFindingsToCloudDataCatalog_ struct {
	// Publish findings to Cloud Datahub.
	PublishFindingsToCloudDataCatalog *Action_PublishFindingsToCloudDataCatalog `protobuf:"bytes,5,opt,name=publish_findings_to_cloud_data_catalog,json=publishFindingsToCloudDataCatalog,proto3,oneof"`
}

type Action_Deidentify_ struct {
	// Create a de-identified copy of the input data.
	Deidentify *Action_Deidentify `protobuf:"bytes,7,opt,name=deidentify,proto3,oneof"`
}

type Action_JobNotificationEmails_ struct {
	// Sends an email when the job completes. The email goes to IAM project
	// owners and technical [Essential
	// Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
	JobNotificationEmails *Action_JobNotificationEmails `protobuf:"bytes,8,opt,name=job_notification_emails,json=jobNotificationEmails,proto3,oneof"`
}

type Action_PublishToStackdriver_ struct {
	// Enable Stackdriver metric dlp.googleapis.com/finding_count.
	PublishToStackdriver *Action_PublishToStackdriver `protobuf:"bytes,9,opt,name=publish_to_stackdriver,json=publishToStackdriver,proto3,oneof"`
}

func (*Action_SaveFindings_) isAction_Action() {}

func (*Action_PubSub) isAction_Action() {}

func (*Action_PublishSummaryToCscc_) isAction_Action() {}

func (*Action_PublishFindingsToCloudDataCatalog_) isAction_Action() {}

func (*Action_Deidentify_) isAction_Action() {}

func (*Action_JobNotificationEmails_) isAction_Action() {}

func (*Action_PublishToStackdriver_) isAction_Action() {}

// User specified templates and configs for how to deidentify structured,
// unstructures, and image files. User must provide either a unstructured
// deidentify template or at least one redact image config.
type TransformationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// De-identify template.
	// If this template is specified, it will serve as the default de-identify
	// template. This template cannot contain `record_transformations` since it
	// can be used for unstructured content such as free-form text files. If this
	// template is not set, a default `ReplaceWithInfoTypeConfig` will be used to
	// de-identify unstructured content.
	DeidentifyTemplate string `protobuf:"bytes,1,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// Structured de-identify template.
	// If this template is specified, it will serve as the de-identify template
	// for structured content such as delimited files and tables. If this template
	// is not set but the `deidentify_template` is set, then `deidentify_template`
	// will also apply to the structured content. If neither template is set, a
	// default `ReplaceWithInfoTypeConfig` will be used to de-identify structured
	// content.
	StructuredDeidentifyTemplate string `protobuf:"bytes,2,opt,name=structured_deidentify_template,json=structuredDeidentifyTemplate,proto3" json:"structured_deidentify_template,omitempty"`
	// Image redact template.
	// If this template is specified, it will serve as the de-identify template
	// for images. If this template is not set, all findings in the image will be
	// redacted with a black box.
	ImageRedactTemplate string `protobuf:"bytes,4,opt,name=image_redact_template,json=imageRedactTemplate,proto3" json:"image_redact_template,omitempty"`
}

func (x *TransformationConfig) Reset() {
	*x = TransformationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationConfig) ProtoMessage() {}

func (x *TransformationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationConfig.ProtoReflect.Descriptor instead.
func (*TransformationConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{94}
}

func (x *TransformationConfig) GetDeidentifyTemplate() string {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return ""
}

func (x *TransformationConfig) GetStructuredDeidentifyTemplate() string {
	if x != nil {
		return x.StructuredDeidentifyTemplate
	}
	return ""
}

func (x *TransformationConfig) GetImageRedactTemplate() string {
	if x != nil {
		return x.ImageRedactTemplate
	}
	return ""
}

// Request message for CreateInspectTemplate.
type CreateInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//   - Organizations scope, location specified:<br/>
	//     `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Organizations scope, no location specified (defaults to global):<br/>
	//     `organizations/`<var>ORG_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The InspectTemplate to create.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateInspectTemplateRequest) Reset() {
	*x = CreateInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInspectTemplateRequest) ProtoMessage() {}

func (x *CreateInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{95}
}

func (x *CreateInspectTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.InspectTemplate
	}
	return nil
}

func (x *CreateInspectTemplateRequest) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

func (x *CreateInspectTemplateRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateInspectTemplate.
type UpdateInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and inspectTemplate to be updated,
	// for example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New InspectTemplate value.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateInspectTemplateRequest) Reset() {
	*x = UpdateInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInspectTemplateRequest) ProtoMessage() {}

func (x *UpdateInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{96}
}

func (x *UpdateInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.InspectTemplate
	}
	return nil
}

func (x *UpdateInspectTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetInspectTemplate.
type GetInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and inspectTemplate to be read,
	// for example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInspectTemplateRequest) Reset() {
	*x = GetInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInspectTemplateRequest) ProtoMessage() {}

func (x *GetInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{97}
}

func (x *GetInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListInspectTemplates.
type ListInspectTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//   - Organizations scope, location specified:<br/>
	//     `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Organizations scope, no location specified (defaults to global):<br/>
	//     `organizations/`<var>ORG_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from the previous call
	// to `ListInspectTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to the time the template was created.
	// - `update_time`: corresponds to the time the template was last updated.
	// - `name`: corresponds to the template's name.
	// - `display_name`: corresponds to the template's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListInspectTemplatesRequest) Reset() {
	*x = ListInspectTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInspectTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInspectTemplatesRequest) ProtoMessage() {}

func (x *ListInspectTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInspectTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListInspectTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{98}
}

func (x *ListInspectTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInspectTemplatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListInspectTemplates.
type ListInspectTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of inspectTemplates, up to page_size in ListInspectTemplatesRequest.
	InspectTemplates []*InspectTemplate `protobuf:"bytes,1,rep,name=inspect_templates,json=inspectTemplates,proto3" json:"inspect_templates,omitempty"`
	// If the next page is available then the next page token to be used in the
	// following ListInspectTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInspectTemplatesResponse) Reset() {
	*x = ListInspectTemplatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInspectTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInspectTemplatesResponse) ProtoMessage() {}

func (x *ListInspectTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInspectTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListInspectTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{99}
}

func (x *ListInspectTemplatesResponse) GetInspectTemplates() []*InspectTemplate {
	if x != nil {
		return x.InspectTemplates
	}
	return nil
}

func (x *ListInspectTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteInspectTemplate.
type DeleteInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and inspectTemplate to be
	// deleted, for example `organizations/433245324/inspectTemplates/432452342`
	// or projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteInspectTemplateRequest) Reset() {
	*x = DeleteInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInspectTemplateRequest) ProtoMessage() {}

func (x *DeleteInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{100}
}

func (x *DeleteInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateJobTrigger.
type CreateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The JobTrigger to create.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger,proto3" json:"job_trigger,omitempty"`
	// The trigger id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TriggerId string `protobuf:"bytes,3,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateJobTriggerRequest) Reset() {
	*x = CreateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobTriggerRequest) ProtoMessage() {}

func (x *CreateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*CreateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{101}
}

func (x *CreateJobTriggerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if x != nil {
		return x.JobTrigger
	}
	return nil
}

func (x *CreateJobTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *CreateJobTriggerRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for ActivateJobTrigger.
type ActivateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the trigger to activate, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ActivateJobTriggerRequest) Reset() {
	*x = ActivateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateJobTriggerRequest) ProtoMessage() {}

func (x *ActivateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*ActivateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{102}
}

func (x *ActivateJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateJobTrigger.
type UpdateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New JobTrigger value.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger,proto3" json:"job_trigger,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateJobTriggerRequest) Reset() {
	*x = UpdateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateJobTriggerRequest) ProtoMessage() {}

func (x *UpdateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*UpdateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{103}
}

func (x *UpdateJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if x != nil {
		return x.JobTrigger
	}
	return nil
}

func (x *UpdateJobTriggerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetJobTrigger.
type GetJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobTriggerRequest) Reset() {
	*x = GetJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobTriggerRequest) ProtoMessage() {}

func (x *GetJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*GetJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{104}
}

func (x *GetJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDiscoveryConfig.
type CreateDiscoveryConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value is as follows:
	// `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DiscoveryConfig to create.
	DiscoveryConfig *DiscoveryConfig `protobuf:"bytes,2,opt,name=discovery_config,json=discoveryConfig,proto3" json:"discovery_config,omitempty"`
	// The config ID can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
}

func (x *CreateDiscoveryConfigRequest) Reset() {
	*x = CreateDiscoveryConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDiscoveryConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDiscoveryConfigRequest) ProtoMessage() {}

func (x *CreateDiscoveryConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDiscoveryConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateDiscoveryConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{105}
}

func (x *CreateDiscoveryConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDiscoveryConfigRequest) GetDiscoveryConfig() *DiscoveryConfig {
	if x != nil {
		return x.DiscoveryConfig
	}
	return nil
}

func (x *CreateDiscoveryConfigRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

// Request message for UpdateDiscoveryConfig.
type UpdateDiscoveryConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the configuration, for example
	// `projects/dlp-test-project/discoveryConfigs/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New DiscoveryConfig value.
	DiscoveryConfig *DiscoveryConfig `protobuf:"bytes,2,opt,name=discovery_config,json=discoveryConfig,proto3" json:"discovery_config,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDiscoveryConfigRequest) Reset() {
	*x = UpdateDiscoveryConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDiscoveryConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDiscoveryConfigRequest) ProtoMessage() {}

func (x *UpdateDiscoveryConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDiscoveryConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateDiscoveryConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{106}
}

func (x *UpdateDiscoveryConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateDiscoveryConfigRequest) GetDiscoveryConfig() *DiscoveryConfig {
	if x != nil {
		return x.DiscoveryConfig
	}
	return nil
}

func (x *UpdateDiscoveryConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDiscoveryConfig.
type GetDiscoveryConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the configuration, for example
	// `projects/dlp-test-project/discoveryConfigs/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDiscoveryConfigRequest) Reset() {
	*x = GetDiscoveryConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDiscoveryConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDiscoveryConfigRequest) ProtoMessage() {}

func (x *GetDiscoveryConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDiscoveryConfigRequest.ProtoReflect.Descriptor instead.
func (*GetDiscoveryConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{107}
}

func (x *GetDiscoveryConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDiscoveryConfigs.
type ListDiscoveryConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value is as follows:
	// `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from the previous call
	// to ListDiscoveryConfigs. `order_by` field must not
	// change for subsequent calls.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by a server.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of config fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `last_run_time`: corresponds to the last time the DiscoveryConfig ran.
	// - `name`: corresponds to the DiscoveryConfig's name.
	// - `status`: corresponds to DiscoveryConfig's status.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDiscoveryConfigsRequest) Reset() {
	*x = ListDiscoveryConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDiscoveryConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDiscoveryConfigsRequest) ProtoMessage() {}

func (x *ListDiscoveryConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDiscoveryConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListDiscoveryConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{108}
}

func (x *ListDiscoveryConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDiscoveryConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDiscoveryConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDiscoveryConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListDiscoveryConfigs.
type ListDiscoveryConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of configs, up to page_size in ListDiscoveryConfigsRequest.
	DiscoveryConfigs []*DiscoveryConfig `protobuf:"bytes,1,rep,name=discovery_configs,json=discoveryConfigs,proto3" json:"discovery_configs,omitempty"`
	// If the next page is available then this value is the next page token to be
	// used in the following ListDiscoveryConfigs request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDiscoveryConfigsResponse) Reset() {
	*x = ListDiscoveryConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDiscoveryConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDiscoveryConfigsResponse) ProtoMessage() {}

func (x *ListDiscoveryConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDiscoveryConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListDiscoveryConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{109}
}

func (x *ListDiscoveryConfigsResponse) GetDiscoveryConfigs() []*DiscoveryConfig {
	if x != nil {
		return x.DiscoveryConfigs
	}
	return nil
}

func (x *ListDiscoveryConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteDiscoveryConfig.
type DeleteDiscoveryConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the config, for example
	// `projects/dlp-test-project/discoveryConfigs/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDiscoveryConfigRequest) Reset() {
	*x = DeleteDiscoveryConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDiscoveryConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDiscoveryConfigRequest) ProtoMessage() {}

func (x *DeleteDiscoveryConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDiscoveryConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteDiscoveryConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{110}
}

func (x *DeleteDiscoveryConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDlpJobRequest. Used to initiate long running
// jobs such as calculating risk metrics or inspecting Google Cloud
// Storage.
type CreateDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration details for the specific type of job to run.
	//
	// Types that are assignable to Job:
	//
	//	*CreateDlpJobRequest_InspectJob
	//	*CreateDlpJobRequest_RiskJob
	Job isCreateDlpJobRequest_Job `protobuf_oneof:"job"`
	// The job id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	JobId string `protobuf:"bytes,4,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateDlpJobRequest) Reset() {
	*x = CreateDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDlpJobRequest) ProtoMessage() {}

func (x *CreateDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDlpJobRequest.ProtoReflect.Descriptor instead.
func (*CreateDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{111}
}

func (x *CreateDlpJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *CreateDlpJobRequest) GetJob() isCreateDlpJobRequest_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (x *CreateDlpJobRequest) GetInspectJob() *InspectJobConfig {
	if x, ok := x.GetJob().(*CreateDlpJobRequest_InspectJob); ok {
		return x.InspectJob
	}
	return nil
}

func (x *CreateDlpJobRequest) GetRiskJob() *RiskAnalysisJobConfig {
	if x, ok := x.GetJob().(*CreateDlpJobRequest_RiskJob); ok {
		return x.RiskJob
	}
	return nil
}

func (x *CreateDlpJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *CreateDlpJobRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

type isCreateDlpJobRequest_Job interface {
	isCreateDlpJobRequest_Job()
}

type CreateDlpJobRequest_InspectJob struct {
	// An inspection job scans a storage repository for InfoTypes.
	InspectJob *InspectJobConfig `protobuf:"bytes,2,opt,name=inspect_job,json=inspectJob,proto3,oneof"`
}

type CreateDlpJobRequest_RiskJob struct {
	// A risk analysis job calculates re-identification risk metrics for a
	// BigQuery table.
	RiskJob *RiskAnalysisJobConfig `protobuf:"bytes,3,opt,name=risk_job,json=riskJob,proto3,oneof"`
}

func (*CreateDlpJobRequest_InspectJob) isCreateDlpJobRequest_Job() {}

func (*CreateDlpJobRequest_RiskJob) isCreateDlpJobRequest_Job() {}

// Request message for ListJobTriggers.
type ListJobTriggersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from the previous call
	// to ListJobTriggers. `order_by` field must not
	// change for subsequent calls.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by a server.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of triggeredJob fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to the time the JobTrigger was created.
	// - `update_time`: corresponds to the time the JobTrigger was last updated.
	// - `last_run_time`: corresponds to the last time the JobTrigger ran.
	// - `name`: corresponds to the JobTrigger's name.
	// - `display_name`: corresponds to the JobTrigger's display name.
	// - `status`: corresponds to JobTrigger's status.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values for inspect triggers:
	//   - `status` - HEALTHY|PAUSED|CANCELLED
	//   - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
	//   - 'last_run_time` - RFC 3339 formatted timestamp, surrounded by
	//     quotation marks. Nanoseconds are ignored.
	//   - 'error_count' - Number of errors that have occurred while running.
	//
	// * The operator must be `=` or `!=` for status and inspected_storage.
	//
	// Examples:
	//
	// * inspected_storage = cloud_storage AND status = HEALTHY
	// * inspected_storage = cloud_storage OR inspected_storage = bigquery
	// * inspected_storage = cloud_storage AND (state = PAUSED OR state = HEALTHY)
	// * last_run_time > \"2017-12-12T00:00:00+00:00\"
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// The type of jobs. Will use `DlpJobType.INSPECT` if not set.
	Type DlpJobType `protobuf:"varint,6,opt,name=type,proto3,enum=google.privacy.dlp.v2.DlpJobType" json:"type,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListJobTriggersRequest) Reset() {
	*x = ListJobTriggersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobTriggersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobTriggersRequest) ProtoMessage() {}

func (x *ListJobTriggersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobTriggersRequest.ProtoReflect.Descriptor instead.
func (*ListJobTriggersRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{112}
}

func (x *ListJobTriggersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobTriggersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobTriggersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobTriggersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListJobTriggersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobTriggersRequest) GetType() DlpJobType {
	if x != nil {
		return x.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (x *ListJobTriggersRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListJobTriggers.
type ListJobTriggersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of triggeredJobs, up to page_size in ListJobTriggersRequest.
	JobTriggers []*JobTrigger `protobuf:"bytes,1,rep,name=job_triggers,json=jobTriggers,proto3" json:"job_triggers,omitempty"`
	// If the next page is available then this value is the next page token to be
	// used in the following ListJobTriggers request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListJobTriggersResponse) Reset() {
	*x = ListJobTriggersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobTriggersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobTriggersResponse) ProtoMessage() {}

func (x *ListJobTriggersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobTriggersResponse.ProtoReflect.Descriptor instead.
func (*ListJobTriggersResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{113}
}

func (x *ListJobTriggersResponse) GetJobTriggers() []*JobTrigger {
	if x != nil {
		return x.JobTriggers
	}
	return nil
}

func (x *ListJobTriggersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteJobTrigger.
type DeleteJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteJobTriggerRequest) Reset() {
	*x = DeleteJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteJobTriggerRequest) ProtoMessage() {}

func (x *DeleteJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*DeleteJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{114}
}

func (x *DeleteJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Controls what and how to inspect for findings.
type InspectJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data to scan.
	StorageConfig *StorageConfig `protobuf:"bytes,1,opt,name=storage_config,json=storageConfig,proto3" json:"storage_config,omitempty"`
	// How and what to scan for.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// If provided, will be used as the default for all values in InspectConfig.
	// `inspect_config` will be merged into the values persisted as part of the
	// template.
	InspectTemplateName string `protobuf:"bytes,3,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Actions to execute at the completion of the job.
	Actions []*Action `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *InspectJobConfig) Reset() {
	*x = InspectJobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectJobConfig) ProtoMessage() {}

func (x *InspectJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectJobConfig.ProtoReflect.Descriptor instead.
func (*InspectJobConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{115}
}

func (x *InspectJobConfig) GetStorageConfig() *StorageConfig {
	if x != nil {
		return x.StorageConfig
	}
	return nil
}

func (x *InspectJobConfig) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *InspectJobConfig) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *InspectJobConfig) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// A task to execute when a data profile has been generated.
type DataProfileAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of action to execute when a profile is generated.
	//
	// Types that are assignable to Action:
	//
	//	*DataProfileAction_ExportData
	//	*DataProfileAction_PubSubNotification_
	Action isDataProfileAction_Action `protobuf_oneof:"action"`
}

func (x *DataProfileAction) Reset() {
	*x = DataProfileAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileAction) ProtoMessage() {}

func (x *DataProfileAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileAction.ProtoReflect.Descriptor instead.
func (*DataProfileAction) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116}
}

func (m *DataProfileAction) GetAction() isDataProfileAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *DataProfileAction) GetExportData() *DataProfileAction_Export {
	if x, ok := x.GetAction().(*DataProfileAction_ExportData); ok {
		return x.ExportData
	}
	return nil
}

func (x *DataProfileAction) GetPubSubNotification() *DataProfileAction_PubSubNotification {
	if x, ok := x.GetAction().(*DataProfileAction_PubSubNotification_); ok {
		return x.PubSubNotification
	}
	return nil
}

type isDataProfileAction_Action interface {
	isDataProfileAction_Action()
}

type DataProfileAction_ExportData struct {
	// Export data profiles into a provided location.
	ExportData *DataProfileAction_Export `protobuf:"bytes,1,opt,name=export_data,json=exportData,proto3,oneof"`
}

type DataProfileAction_PubSubNotification_ struct {
	// Publish a message into the Pub/Sub topic.
	PubSubNotification *DataProfileAction_PubSubNotification `protobuf:"bytes,2,opt,name=pub_sub_notification,json=pubSubNotification,proto3,oneof"`
}

func (*DataProfileAction_ExportData) isDataProfileAction_Action() {}

func (*DataProfileAction_PubSubNotification_) isDataProfileAction_Action() {}

// Configuration for setting up a job to scan resources for profile generation.
// Only one data profile configuration may exist per organization, folder,
// or project.
//
// The generated data profiles are retained according to the
// [data retention policy]
// (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
type DataProfileJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data to scan.
	Location *DataProfileLocation `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The project that will run the scan. The DLP service
	// account that exists within this project must have access to all resources
	// that are profiled, and the Cloud DLP API must be enabled.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Detection logic for profile generation.
	//
	// Not all template features are used by profiles. FindingLimits,
	// include_quote and exclude_info_types have no impact on
	// data profiling.
	//
	// Multiple templates may be provided if there is data in multiple regions.
	// At most one template must be specified per-region (including "global").
	// Each region is scanned using the applicable template. If no region-specific
	// template is specified, but a "global" template is specified, it will be
	// copied to that region and used instead. If no global or region-specific
	// template is provided for a region with data, that region's data will not be
	// scanned.
	//
	// For more information, see
	// https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
	InspectTemplates []string `protobuf:"bytes,7,rep,name=inspect_templates,json=inspectTemplates,proto3" json:"inspect_templates,omitempty"`
	// Actions to execute at the completion of the job.
	DataProfileActions []*DataProfileAction `protobuf:"bytes,6,rep,name=data_profile_actions,json=dataProfileActions,proto3" json:"data_profile_actions,omitempty"`
}

func (x *DataProfileJobConfig) Reset() {
	*x = DataProfileJobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileJobConfig) ProtoMessage() {}

func (x *DataProfileJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileJobConfig.ProtoReflect.Descriptor instead.
func (*DataProfileJobConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{117}
}

func (x *DataProfileJobConfig) GetLocation() *DataProfileLocation {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *DataProfileJobConfig) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DataProfileJobConfig) GetInspectTemplates() []string {
	if x != nil {
		return x.InspectTemplates
	}
	return nil
}

func (x *DataProfileJobConfig) GetDataProfileActions() []*DataProfileAction {
	if x != nil {
		return x.DataProfileActions
	}
	return nil
}

// A pattern to match against one or more tables, datasets, or projects that
// contain BigQuery tables. At least one pattern must be specified.
// Regular expressions use RE2
// [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
// under the google/re2 repository on GitHub.
type BigQueryRegex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For organizations, if unset, will match all projects. Has no effect
	// for data profile configurations created within a project.
	ProjectIdRegex string `protobuf:"bytes,1,opt,name=project_id_regex,json=projectIdRegex,proto3" json:"project_id_regex,omitempty"`
	// If unset, this property matches all datasets.
	DatasetIdRegex string `protobuf:"bytes,2,opt,name=dataset_id_regex,json=datasetIdRegex,proto3" json:"dataset_id_regex,omitempty"`
	// If unset, this property matches all tables.
	TableIdRegex string `protobuf:"bytes,3,opt,name=table_id_regex,json=tableIdRegex,proto3" json:"table_id_regex,omitempty"`
}

func (x *BigQueryRegex) Reset() {
	*x = BigQueryRegex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryRegex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryRegex) ProtoMessage() {}

func (x *BigQueryRegex) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryRegex.ProtoReflect.Descriptor instead.
func (*BigQueryRegex) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{118}
}

func (x *BigQueryRegex) GetProjectIdRegex() string {
	if x != nil {
		return x.ProjectIdRegex
	}
	return ""
}

func (x *BigQueryRegex) GetDatasetIdRegex() string {
	if x != nil {
		return x.DatasetIdRegex
	}
	return ""
}

func (x *BigQueryRegex) GetTableIdRegex() string {
	if x != nil {
		return x.TableIdRegex
	}
	return ""
}

// A collection of regular expressions to determine what tables to match
// against.
type BigQueryRegexes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A single BigQuery regular expression pattern to match against one or more
	// tables, datasets, or projects that contain BigQuery tables.
	Patterns []*BigQueryRegex `protobuf:"bytes,1,rep,name=patterns,proto3" json:"patterns,omitempty"`
}

func (x *BigQueryRegexes) Reset() {
	*x = BigQueryRegexes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryRegexes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryRegexes) ProtoMessage() {}

func (x *BigQueryRegexes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryRegexes.ProtoReflect.Descriptor instead.
func (*BigQueryRegexes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{119}
}

func (x *BigQueryRegexes) GetPatterns() []*BigQueryRegex {
	if x != nil {
		return x.Patterns
	}
	return nil
}

// The types of BigQuery tables supported by Cloud DLP.
type BigQueryTableTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of BigQuery table types.
	Types []BigQueryTableType `protobuf:"varint,1,rep,packed,name=types,proto3,enum=google.privacy.dlp.v2.BigQueryTableType" json:"types,omitempty"`
}

func (x *BigQueryTableTypes) Reset() {
	*x = BigQueryTableTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryTableTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryTableTypes) ProtoMessage() {}

func (x *BigQueryTableTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryTableTypes.ProtoReflect.Descriptor instead.
func (*BigQueryTableTypes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{120}
}

func (x *BigQueryTableTypes) GetTypes() []BigQueryTableType {
	if x != nil {
		return x.Types
	}
	return nil
}

// Do not profile the tables.
type Disabled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Disabled) Reset() {
	*x = Disabled{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Disabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Disabled) ProtoMessage() {}

func (x *Disabled) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Disabled.ProtoReflect.Descriptor instead.
func (*Disabled) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{121}
}

// The data that will be profiled.
type DataProfileLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location to be scanned.
	//
	// Types that are assignable to Location:
	//
	//	*DataProfileLocation_OrganizationId
	//	*DataProfileLocation_FolderId
	Location isDataProfileLocation_Location `protobuf_oneof:"location"`
}

func (x *DataProfileLocation) Reset() {
	*x = DataProfileLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileLocation) ProtoMessage() {}

func (x *DataProfileLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileLocation.ProtoReflect.Descriptor instead.
func (*DataProfileLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{122}
}

func (m *DataProfileLocation) GetLocation() isDataProfileLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *DataProfileLocation) GetOrganizationId() int64 {
	if x, ok := x.GetLocation().(*DataProfileLocation_OrganizationId); ok {
		return x.OrganizationId
	}
	return 0
}

func (x *DataProfileLocation) GetFolderId() int64 {
	if x, ok := x.GetLocation().(*DataProfileLocation_FolderId); ok {
		return x.FolderId
	}
	return 0
}

type isDataProfileLocation_Location interface {
	isDataProfileLocation_Location()
}

type DataProfileLocation_OrganizationId struct {
	// The ID of an organization to scan.
	OrganizationId int64 `protobuf:"varint,1,opt,name=organization_id,json=organizationId,proto3,oneof"`
}

type DataProfileLocation_FolderId struct {
	// The ID of the Folder within an organization to scan.
	FolderId int64 `protobuf:"varint,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

func (*DataProfileLocation_OrganizationId) isDataProfileLocation_Location() {}

func (*DataProfileLocation_FolderId) isDataProfileLocation_Location() {}

// Configuration for discovery to scan resources for profile generation.
// Only one discovery configuration may exist per organization, folder,
// or project.
//
// The generated data profiles are retained according to the
// [data retention policy]
// (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
type DiscoveryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique resource name for the DiscoveryConfig, assigned by the service when
	// the DiscoveryConfig is created, for example
	// `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 100 chars)
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Only set when the parent is an org.
	OrgConfig *DiscoveryConfig_OrgConfig `protobuf:"bytes,2,opt,name=org_config,json=orgConfig,proto3" json:"org_config,omitempty"`
	// Detection logic for profile generation.
	//
	// Not all template features are used by Discovery. FindingLimits,
	// include_quote and exclude_info_types have no impact on
	// Discovery.
	//
	// Multiple templates may be provided if there is data in multiple regions.
	// At most one template must be specified per-region (including "global").
	// Each region is scanned using the applicable template. If no region-specific
	// template is specified, but a "global" template is specified, it will be
	// copied to that region and used instead. If no global or region-specific
	// template is provided for a region with data, that region's data will not be
	// scanned.
	//
	// For more information, see
	// https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
	InspectTemplates []string `protobuf:"bytes,3,rep,name=inspect_templates,json=inspectTemplates,proto3" json:"inspect_templates,omitempty"`
	// Actions to execute at the completion of scanning.
	Actions []*DataProfileAction `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
	// Target to match against for determining what to scan and how frequently.
	Targets []*DiscoveryTarget `protobuf:"bytes,5,rep,name=targets,proto3" json:"targets,omitempty"`
	// Output only. A stream of errors encountered when the config was activated.
	// Repeated errors may result in the config automatically being paused. Output
	// only field. Will return the last 100 errors. Whenever the config is
	// modified this list will be cleared.
	Errors []*Error `protobuf:"bytes,6,rep,name=errors,proto3" json:"errors,omitempty"`
	// Output only. The creation timestamp of a DiscoveryConfig.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a DiscoveryConfig.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The timestamp of the last time this config was executed.
	LastRunTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_run_time,json=lastRunTime,proto3" json:"last_run_time,omitempty"`
	// Required. A status for this configuration.
	Status DiscoveryConfig_Status `protobuf:"varint,10,opt,name=status,proto3,enum=google.privacy.dlp.v2.DiscoveryConfig_Status" json:"status,omitempty"`
}

func (x *DiscoveryConfig) Reset() {
	*x = DiscoveryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryConfig) ProtoMessage() {}

func (x *DiscoveryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryConfig.ProtoReflect.Descriptor instead.
func (*DiscoveryConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{123}
}

func (x *DiscoveryConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DiscoveryConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DiscoveryConfig) GetOrgConfig() *DiscoveryConfig_OrgConfig {
	if x != nil {
		return x.OrgConfig
	}
	return nil
}

func (x *DiscoveryConfig) GetInspectTemplates() []string {
	if x != nil {
		return x.InspectTemplates
	}
	return nil
}

func (x *DiscoveryConfig) GetActions() []*DataProfileAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

func (x *DiscoveryConfig) GetTargets() []*DiscoveryTarget {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *DiscoveryConfig) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *DiscoveryConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DiscoveryConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DiscoveryConfig) GetLastRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRunTime
	}
	return nil
}

func (x *DiscoveryConfig) GetStatus() DiscoveryConfig_Status {
	if x != nil {
		return x.Status
	}
	return DiscoveryConfig_STATUS_UNSPECIFIED
}

// Target used to match against for Discovery.
type DiscoveryTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A target to match against for Discovery.
	//
	// Types that are assignable to Target:
	//
	//	*DiscoveryTarget_BigQueryTarget
	Target isDiscoveryTarget_Target `protobuf_oneof:"target"`
}

func (x *DiscoveryTarget) Reset() {
	*x = DiscoveryTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryTarget) ProtoMessage() {}

func (x *DiscoveryTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryTarget.ProtoReflect.Descriptor instead.
func (*DiscoveryTarget) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{124}
}

func (m *DiscoveryTarget) GetTarget() isDiscoveryTarget_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *DiscoveryTarget) GetBigQueryTarget() *BigQueryDiscoveryTarget {
	if x, ok := x.GetTarget().(*DiscoveryTarget_BigQueryTarget); ok {
		return x.BigQueryTarget
	}
	return nil
}

type isDiscoveryTarget_Target interface {
	isDiscoveryTarget_Target()
}

type DiscoveryTarget_BigQueryTarget struct {
	// BigQuery target for Discovery. The first target to match a table will be
	// the one applied.
	BigQueryTarget *BigQueryDiscoveryTarget `protobuf:"bytes,1,opt,name=big_query_target,json=bigQueryTarget,proto3,oneof"`
}

func (*DiscoveryTarget_BigQueryTarget) isDiscoveryTarget_Target() {}

// Target used to match against for discovery with BigQuery tables
type BigQueryDiscoveryTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tables the discovery cadence applies to. The first target
	// with a matching filter will be the one to apply to a table.
	Filter *DiscoveryBigQueryFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// In addition to matching the filter, these conditions must be true
	// before a profile is generated.
	Conditions *DiscoveryBigQueryConditions `protobuf:"bytes,2,opt,name=conditions,proto3" json:"conditions,omitempty"`
	// The generation rule includes the logic on how frequently
	// to update the data profiles. If not specified, discovery will re-run and
	// update no more than once a month if new columns appear in the table.
	//
	// Types that are assignable to Frequency:
	//
	//	*BigQueryDiscoveryTarget_Cadence
	//	*BigQueryDiscoveryTarget_Disabled
	Frequency isBigQueryDiscoveryTarget_Frequency `protobuf_oneof:"frequency"`
}

func (x *BigQueryDiscoveryTarget) Reset() {
	*x = BigQueryDiscoveryTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDiscoveryTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDiscoveryTarget) ProtoMessage() {}

func (x *BigQueryDiscoveryTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDiscoveryTarget.ProtoReflect.Descriptor instead.
func (*BigQueryDiscoveryTarget) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{125}
}

func (x *BigQueryDiscoveryTarget) GetFilter() *DiscoveryBigQueryFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *BigQueryDiscoveryTarget) GetConditions() *DiscoveryBigQueryConditions {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (m *BigQueryDiscoveryTarget) GetFrequency() isBigQueryDiscoveryTarget_Frequency {
	if m != nil {
		return m.Frequency
	}
	return nil
}

func (x *BigQueryDiscoveryTarget) GetCadence() *DiscoveryGenerationCadence {
	if x, ok := x.GetFrequency().(*BigQueryDiscoveryTarget_Cadence); ok {
		return x.Cadence
	}
	return nil
}

func (x *BigQueryDiscoveryTarget) GetDisabled() *Disabled {
	if x, ok := x.GetFrequency().(*BigQueryDiscoveryTarget_Disabled); ok {
		return x.Disabled
	}
	return nil
}

type isBigQueryDiscoveryTarget_Frequency interface {
	isBigQueryDiscoveryTarget_Frequency()
}

type BigQueryDiscoveryTarget_Cadence struct {
	// How often and when to update profiles. New tables that match both the
	// filter and conditions are scanned as quickly as possible depending on
	// system capacity.
	Cadence *DiscoveryGenerationCadence `protobuf:"bytes,3,opt,name=cadence,proto3,oneof"`
}

type BigQueryDiscoveryTarget_Disabled struct {
	// Tables that match this filter will not have profiles created.
	Disabled *Disabled `protobuf:"bytes,4,opt,name=disabled,proto3,oneof"`
}

func (*BigQueryDiscoveryTarget_Cadence) isBigQueryDiscoveryTarget_Frequency() {}

func (*BigQueryDiscoveryTarget_Disabled) isBigQueryDiscoveryTarget_Frequency() {}

// Determines what tables will have profiles generated within an organization
// or project. Includes the ability to filter by regular expression patterns
// on project ID, dataset ID, and table ID.
type DiscoveryBigQueryFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the filter applies to a specific set of tables or all other tables
	// within the location being profiled. The first filter to match will be
	// applied, regardless of the condition. If none is set, will default to
	// `other_tables`.
	//
	// Types that are assignable to Filter:
	//
	//	*DiscoveryBigQueryFilter_Tables
	//	*DiscoveryBigQueryFilter_OtherTables
	Filter isDiscoveryBigQueryFilter_Filter `protobuf_oneof:"filter"`
}

func (x *DiscoveryBigQueryFilter) Reset() {
	*x = DiscoveryBigQueryFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryBigQueryFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryBigQueryFilter) ProtoMessage() {}

func (x *DiscoveryBigQueryFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryBigQueryFilter.ProtoReflect.Descriptor instead.
func (*DiscoveryBigQueryFilter) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{126}
}

func (m *DiscoveryBigQueryFilter) GetFilter() isDiscoveryBigQueryFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (x *DiscoveryBigQueryFilter) GetTables() *BigQueryTableCollection {
	if x, ok := x.GetFilter().(*DiscoveryBigQueryFilter_Tables); ok {
		return x.Tables
	}
	return nil
}

func (x *DiscoveryBigQueryFilter) GetOtherTables() *DiscoveryBigQueryFilter_AllOtherBigQueryTables {
	if x, ok := x.GetFilter().(*DiscoveryBigQueryFilter_OtherTables); ok {
		return x.OtherTables
	}
	return nil
}

type isDiscoveryBigQueryFilter_Filter interface {
	isDiscoveryBigQueryFilter_Filter()
}

type DiscoveryBigQueryFilter_Tables struct {
	// A specific set of tables for this filter to apply to. A table collection
	// must be specified in only one filter per config.
	// If a table id or dataset is empty, Cloud DLP assumes all tables in that
	// collection must be profiled. Must specify a project ID.
	Tables *BigQueryTableCollection `protobuf:"bytes,1,opt,name=tables,proto3,oneof"`
}

type DiscoveryBigQueryFilter_OtherTables struct {
	// Catch-all. This should always be the last filter in the list because
	// anything above it will apply first. Should only appear once in a
	// configuration. If none is specified, a default one will be added
	// automatically.
	OtherTables *DiscoveryBigQueryFilter_AllOtherBigQueryTables `protobuf:"bytes,2,opt,name=other_tables,json=otherTables,proto3,oneof"`
}

func (*DiscoveryBigQueryFilter_Tables) isDiscoveryBigQueryFilter_Filter() {}

func (*DiscoveryBigQueryFilter_OtherTables) isDiscoveryBigQueryFilter_Filter() {}

// Specifies a collection of BigQuery tables. Used for Discovery.
type BigQueryTableCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum of 100 entries.
	// The first filter containing a pattern that matches a table will be used.
	//
	// Types that are assignable to Pattern:
	//
	//	*BigQueryTableCollection_IncludeRegexes
	Pattern isBigQueryTableCollection_Pattern `protobuf_oneof:"pattern"`
}

func (x *BigQueryTableCollection) Reset() {
	*x = BigQueryTableCollection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryTableCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryTableCollection) ProtoMessage() {}

func (x *BigQueryTableCollection) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryTableCollection.ProtoReflect.Descriptor instead.
func (*BigQueryTableCollection) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{127}
}

func (m *BigQueryTableCollection) GetPattern() isBigQueryTableCollection_Pattern {
	if m != nil {
		return m.Pattern
	}
	return nil
}

func (x *BigQueryTableCollection) GetIncludeRegexes() *BigQueryRegexes {
	if x, ok := x.GetPattern().(*BigQueryTableCollection_IncludeRegexes); ok {
		return x.IncludeRegexes
	}
	return nil
}

type isBigQueryTableCollection_Pattern interface {
	isBigQueryTableCollection_Pattern()
}

type BigQueryTableCollection_IncludeRegexes struct {
	// A collection of regular expressions to match a BigQuery table against.
	IncludeRegexes *BigQueryRegexes `protobuf:"bytes,1,opt,name=include_regexes,json=includeRegexes,proto3,oneof"`
}

func (*BigQueryTableCollection_IncludeRegexes) isBigQueryTableCollection_Pattern() {}

// Requirements that must be true before a table is scanned in discovery for the
// first time. There is an AND relationship between the top-level attributes.
// Additionally, minimum conditions with an OR relationship that must be met
// before Cloud DLP scans a table can be set (like a minimum row count or a
// minimum table age).
type DiscoveryBigQueryConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery table must have been created after this date. Used to avoid
	// backfilling.
	CreatedAfter *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=created_after,json=createdAfter,proto3" json:"created_after,omitempty"`
	// The type of BigQuery tables to scan. If nothing is set the default
	// behavior is to scan only tables of type TABLE and to give errors
	// for all unsupported tables.
	//
	// Types that are assignable to IncludedTypes:
	//
	//	*DiscoveryBigQueryConditions_Types
	//	*DiscoveryBigQueryConditions_TypeCollection
	IncludedTypes isDiscoveryBigQueryConditions_IncludedTypes `protobuf_oneof:"included_types"`
	// At least one of the conditions must be true for a table to be scanned.
	OrConditions *DiscoveryBigQueryConditions_OrConditions `protobuf:"bytes,4,opt,name=or_conditions,json=orConditions,proto3" json:"or_conditions,omitempty"`
}

func (x *DiscoveryBigQueryConditions) Reset() {
	*x = DiscoveryBigQueryConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryBigQueryConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryBigQueryConditions) ProtoMessage() {}

func (x *DiscoveryBigQueryConditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryBigQueryConditions.ProtoReflect.Descriptor instead.
func (*DiscoveryBigQueryConditions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{128}
}

func (x *DiscoveryBigQueryConditions) GetCreatedAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAfter
	}
	return nil
}

func (m *DiscoveryBigQueryConditions) GetIncludedTypes() isDiscoveryBigQueryConditions_IncludedTypes {
	if m != nil {
		return m.IncludedTypes
	}
	return nil
}

func (x *DiscoveryBigQueryConditions) GetTypes() *BigQueryTableTypes {
	if x, ok := x.GetIncludedTypes().(*DiscoveryBigQueryConditions_Types); ok {
		return x.Types
	}
	return nil
}

func (x *DiscoveryBigQueryConditions) GetTypeCollection() BigQueryTableTypeCollection {
	if x, ok := x.GetIncludedTypes().(*DiscoveryBigQueryConditions_TypeCollection); ok {
		return x.TypeCollection
	}
	return BigQueryTableTypeCollection_BIG_QUERY_COLLECTION_UNSPECIFIED
}

func (x *DiscoveryBigQueryConditions) GetOrConditions() *DiscoveryBigQueryConditions_OrConditions {
	if x != nil {
		return x.OrConditions
	}
	return nil
}

type isDiscoveryBigQueryConditions_IncludedTypes interface {
	isDiscoveryBigQueryConditions_IncludedTypes()
}

type DiscoveryBigQueryConditions_Types struct {
	// Restrict discovery to specific table types.
	Types *BigQueryTableTypes `protobuf:"bytes,2,opt,name=types,proto3,oneof"`
}

type DiscoveryBigQueryConditions_TypeCollection struct {
	// Restrict discovery to categories of table types.
	TypeCollection BigQueryTableTypeCollection `protobuf:"varint,3,opt,name=type_collection,json=typeCollection,proto3,enum=google.privacy.dlp.v2.BigQueryTableTypeCollection,oneof"`
}

func (*DiscoveryBigQueryConditions_Types) isDiscoveryBigQueryConditions_IncludedTypes() {}

func (*DiscoveryBigQueryConditions_TypeCollection) isDiscoveryBigQueryConditions_IncludedTypes() {}

// What must take place for a profile to be updated and how
// frequently it should occur.
// New tables are scanned as quickly as possible depending on system
// capacity.
type DiscoveryGenerationCadence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Governs when to update data profiles when a schema is modified.
	SchemaModifiedCadence *DiscoverySchemaModifiedCadence `protobuf:"bytes,1,opt,name=schema_modified_cadence,json=schemaModifiedCadence,proto3" json:"schema_modified_cadence,omitempty"`
	// Governs when to update data profiles when a table is modified.
	TableModifiedCadence *DiscoveryTableModifiedCadence `protobuf:"bytes,2,opt,name=table_modified_cadence,json=tableModifiedCadence,proto3" json:"table_modified_cadence,omitempty"`
}

func (x *DiscoveryGenerationCadence) Reset() {
	*x = DiscoveryGenerationCadence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryGenerationCadence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryGenerationCadence) ProtoMessage() {}

func (x *DiscoveryGenerationCadence) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryGenerationCadence.ProtoReflect.Descriptor instead.
func (*DiscoveryGenerationCadence) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{129}
}

func (x *DiscoveryGenerationCadence) GetSchemaModifiedCadence() *DiscoverySchemaModifiedCadence {
	if x != nil {
		return x.SchemaModifiedCadence
	}
	return nil
}

func (x *DiscoveryGenerationCadence) GetTableModifiedCadence() *DiscoveryTableModifiedCadence {
	if x != nil {
		return x.TableModifiedCadence
	}
	return nil
}

// The cadence at which to update data profiles when a table is modified.
type DiscoveryTableModifiedCadence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of events to consider when deciding if the table has been
	// modified and should have the profile updated. Defaults to
	// MODIFIED_TIMESTAMP.
	Types []BigQueryTableModification `protobuf:"varint,1,rep,packed,name=types,proto3,enum=google.privacy.dlp.v2.BigQueryTableModification" json:"types,omitempty"`
	// How frequently data profiles can be updated when tables are modified.
	// Defaults to never.
	Frequency DataProfileUpdateFrequency `protobuf:"varint,2,opt,name=frequency,proto3,enum=google.privacy.dlp.v2.DataProfileUpdateFrequency" json:"frequency,omitempty"`
}

func (x *DiscoveryTableModifiedCadence) Reset() {
	*x = DiscoveryTableModifiedCadence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryTableModifiedCadence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryTableModifiedCadence) ProtoMessage() {}

func (x *DiscoveryTableModifiedCadence) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryTableModifiedCadence.ProtoReflect.Descriptor instead.
func (*DiscoveryTableModifiedCadence) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{130}
}

func (x *DiscoveryTableModifiedCadence) GetTypes() []BigQueryTableModification {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *DiscoveryTableModifiedCadence) GetFrequency() DataProfileUpdateFrequency {
	if x != nil {
		return x.Frequency
	}
	return DataProfileUpdateFrequency_UPDATE_FREQUENCY_UNSPECIFIED
}

// The cadence at which to update data profiles when a schema is modified.
type DiscoverySchemaModifiedCadence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of events to consider when deciding if the table's schema
	// has been modified and should have the profile updated. Defaults to
	// NEW_COLUMNS.
	Types []BigQuerySchemaModification `protobuf:"varint,1,rep,packed,name=types,proto3,enum=google.privacy.dlp.v2.BigQuerySchemaModification" json:"types,omitempty"`
	// How frequently profiles may be updated when schemas are
	// modified. Defaults to monthly.
	Frequency DataProfileUpdateFrequency `protobuf:"varint,2,opt,name=frequency,proto3,enum=google.privacy.dlp.v2.DataProfileUpdateFrequency" json:"frequency,omitempty"`
}

func (x *DiscoverySchemaModifiedCadence) Reset() {
	*x = DiscoverySchemaModifiedCadence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoverySchemaModifiedCadence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoverySchemaModifiedCadence) ProtoMessage() {}

func (x *DiscoverySchemaModifiedCadence) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoverySchemaModifiedCadence.ProtoReflect.Descriptor instead.
func (*DiscoverySchemaModifiedCadence) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{131}
}

func (x *DiscoverySchemaModifiedCadence) GetTypes() []BigQuerySchemaModification {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *DiscoverySchemaModifiedCadence) GetFrequency() DataProfileUpdateFrequency {
	if x != nil {
		return x.Frequency
	}
	return DataProfileUpdateFrequency_UPDATE_FREQUENCY_UNSPECIFIED
}

// The location to begin a discovery scan. Denotes an organization ID or folder
// ID within an organization.
type DiscoveryStartingLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location to be scanned.
	//
	// Types that are assignable to Location:
	//
	//	*DiscoveryStartingLocation_OrganizationId
	//	*DiscoveryStartingLocation_FolderId
	Location isDiscoveryStartingLocation_Location `protobuf_oneof:"location"`
}

func (x *DiscoveryStartingLocation) Reset() {
	*x = DiscoveryStartingLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryStartingLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryStartingLocation) ProtoMessage() {}

func (x *DiscoveryStartingLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryStartingLocation.ProtoReflect.Descriptor instead.
func (*DiscoveryStartingLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{132}
}

func (m *DiscoveryStartingLocation) GetLocation() isDiscoveryStartingLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *DiscoveryStartingLocation) GetOrganizationId() int64 {
	if x, ok := x.GetLocation().(*DiscoveryStartingLocation_OrganizationId); ok {
		return x.OrganizationId
	}
	return 0
}

func (x *DiscoveryStartingLocation) GetFolderId() int64 {
	if x, ok := x.GetLocation().(*DiscoveryStartingLocation_FolderId); ok {
		return x.FolderId
	}
	return 0
}

type isDiscoveryStartingLocation_Location interface {
	isDiscoveryStartingLocation_Location()
}

type DiscoveryStartingLocation_OrganizationId struct {
	// The ID of an organization to scan.
	OrganizationId int64 `protobuf:"varint,1,opt,name=organization_id,json=organizationId,proto3,oneof"`
}

type DiscoveryStartingLocation_FolderId struct {
	// The ID of the Folder within an organization to scan.
	FolderId int64 `protobuf:"varint,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

func (*DiscoveryStartingLocation_OrganizationId) isDiscoveryStartingLocation_Location() {}

func (*DiscoveryStartingLocation_FolderId) isDiscoveryStartingLocation_Location() {}

// Combines all of the information about a DLP job.
type DlpJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-assigned name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of job.
	Type DlpJobType `protobuf:"varint,2,opt,name=type,proto3,enum=google.privacy.dlp.v2.DlpJobType" json:"type,omitempty"`
	// State of a job.
	State DlpJob_JobState `protobuf:"varint,3,opt,name=state,proto3,enum=google.privacy.dlp.v2.DlpJob_JobState" json:"state,omitempty"`
	// Job details.
	//
	// Types that are assignable to Details:
	//
	//	*DlpJob_RiskDetails
	//	*DlpJob_InspectDetails
	Details isDlpJob_Details `protobuf_oneof:"details"`
	// Time when the job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the job started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time when the job finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Time when the job was last modified by the system.
	LastModified *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=last_modified,json=lastModified,proto3" json:"last_modified,omitempty"`
	// If created by a job trigger, the resource name of the trigger that
	// instantiated the job.
	JobTriggerName string `protobuf:"bytes,10,opt,name=job_trigger_name,json=jobTriggerName,proto3" json:"job_trigger_name,omitempty"`
	// A stream of errors encountered running the job.
	Errors []*Error `protobuf:"bytes,11,rep,name=errors,proto3" json:"errors,omitempty"`
	// Events that should occur after the job has completed.
	ActionDetails []*ActionDetails `protobuf:"bytes,12,rep,name=action_details,json=actionDetails,proto3" json:"action_details,omitempty"`
}

func (x *DlpJob) Reset() {
	*x = DlpJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DlpJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DlpJob) ProtoMessage() {}

func (x *DlpJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DlpJob.ProtoReflect.Descriptor instead.
func (*DlpJob) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{133}
}

func (x *DlpJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DlpJob) GetType() DlpJobType {
	if x != nil {
		return x.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (x *DlpJob) GetState() DlpJob_JobState {
	if x != nil {
		return x.State
	}
	return DlpJob_JOB_STATE_UNSPECIFIED
}

func (m *DlpJob) GetDetails() isDlpJob_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *DlpJob) GetRiskDetails() *AnalyzeDataSourceRiskDetails {
	if x, ok := x.GetDetails().(*DlpJob_RiskDetails); ok {
		return x.RiskDetails
	}
	return nil
}

func (x *DlpJob) GetInspectDetails() *InspectDataSourceDetails {
	if x, ok := x.GetDetails().(*DlpJob_InspectDetails); ok {
		return x.InspectDetails
	}
	return nil
}

func (x *DlpJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DlpJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DlpJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DlpJob) GetLastModified() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModified
	}
	return nil
}

func (x *DlpJob) GetJobTriggerName() string {
	if x != nil {
		return x.JobTriggerName
	}
	return ""
}

func (x *DlpJob) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *DlpJob) GetActionDetails() []*ActionDetails {
	if x != nil {
		return x.ActionDetails
	}
	return nil
}

type isDlpJob_Details interface {
	isDlpJob_Details()
}

type DlpJob_RiskDetails struct {
	// Results from analyzing risk of a data source.
	RiskDetails *AnalyzeDataSourceRiskDetails `protobuf:"bytes,4,opt,name=risk_details,json=riskDetails,proto3,oneof"`
}

type DlpJob_InspectDetails struct {
	// Results from inspecting a data source.
	InspectDetails *InspectDataSourceDetails `protobuf:"bytes,5,opt,name=inspect_details,json=inspectDetails,proto3,oneof"`
}

func (*DlpJob_RiskDetails) isDlpJob_Details() {}

func (*DlpJob_InspectDetails) isDlpJob_Details() {}

// The request message for [DlpJobs.GetDlpJob][].
type GetDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDlpJobRequest) Reset() {
	*x = GetDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDlpJobRequest) ProtoMessage() {}

func (x *GetDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDlpJobRequest.ProtoReflect.Descriptor instead.
func (*GetDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{134}
}

func (x *GetDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for listing DLP jobs.
type ListDlpJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on whether you have [specified a
	// processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values for inspect jobs:
	//   - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
	//   - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
	//   - `trigger_name` - The name of the trigger that created the job.
	//   - 'end_time` - Corresponds to the time the job finished.
	//   - 'start_time` - Corresponds to the time the job finished.
	//
	// * Supported fields for risk analysis jobs:
	//   - `state` - RUNNING|CANCELED|FINISHED|FAILED
	//   - 'end_time` - Corresponds to the time the job finished.
	//   - 'start_time` - Corresponds to the time the job finished.
	//
	// * The operator must be `=` or `!=`.
	//
	// Examples:
	//
	// * inspected_storage = cloud_storage AND state = done
	// * inspected_storage = cloud_storage OR inspected_storage = bigquery
	// * inspected_storage = cloud_storage AND (state = done OR state = canceled)
	// * end_time > \"2017-12-12T00:00:00+00:00\"
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The type of job. Defaults to `DlpJobType.INSPECT`
	Type DlpJobType `protobuf:"varint,5,opt,name=type,proto3,enum=google.privacy.dlp.v2.DlpJobType" json:"type,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc, end_time asc, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to the time the job was created.
	// - `end_time`: corresponds to the time the job ended.
	// - `name`: corresponds to the job's name.
	// - `state`: corresponds to `state`
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListDlpJobsRequest) Reset() {
	*x = ListDlpJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDlpJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDlpJobsRequest) ProtoMessage() {}

func (x *ListDlpJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDlpJobsRequest.ProtoReflect.Descriptor instead.
func (*ListDlpJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{135}
}

func (x *ListDlpJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDlpJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDlpJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDlpJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDlpJobsRequest) GetType() DlpJobType {
	if x != nil {
		return x.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (x *ListDlpJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListDlpJobsRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// The response message for listing DLP jobs.
type ListDlpJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of DlpJobs that matches the specified filter in the request.
	Jobs []*DlpJob `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDlpJobsResponse) Reset() {
	*x = ListDlpJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDlpJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDlpJobsResponse) ProtoMessage() {}

func (x *ListDlpJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDlpJobsResponse.ProtoReflect.Descriptor instead.
func (*ListDlpJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{136}
}

func (x *ListDlpJobsResponse) GetJobs() []*DlpJob {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *ListDlpJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for canceling a DLP job.
type CancelDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be cancelled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDlpJobRequest) Reset() {
	*x = CancelDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDlpJobRequest) ProtoMessage() {}

func (x *CancelDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDlpJobRequest.ProtoReflect.Descriptor instead.
func (*CancelDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{137}
}

func (x *CancelDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for finishing a DLP hybrid job.
type FinishDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be finished.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FinishDlpJobRequest) Reset() {
	*x = FinishDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinishDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinishDlpJobRequest) ProtoMessage() {}

func (x *FinishDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinishDlpJobRequest.ProtoReflect.Descriptor instead.
func (*FinishDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{138}
}

func (x *FinishDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for deleting a DLP job.
type DeleteDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDlpJobRequest) Reset() {
	*x = DeleteDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDlpJobRequest) ProtoMessage() {}

func (x *DeleteDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDlpJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{139}
}

func (x *DeleteDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDeidentifyTemplate.
type CreateDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//   - Organizations scope, location specified:<br/>
	//     `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Organizations scope, no location specified (defaults to global):<br/>
	//     `organizations/`<var>ORG_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DeidentifyTemplate to create.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateDeidentifyTemplateRequest) Reset() {
	*x = CreateDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeidentifyTemplateRequest) ProtoMessage() {}

func (x *CreateDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{140}
}

func (x *CreateDeidentifyTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return nil
}

func (x *CreateDeidentifyTemplateRequest) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

func (x *CreateDeidentifyTemplateRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateDeidentifyTemplate.
type UpdateDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and deidentify template to be
	// updated, for example
	// `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New DeidentifyTemplate value.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDeidentifyTemplateRequest) Reset() {
	*x = UpdateDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeidentifyTemplateRequest) ProtoMessage() {}

func (x *UpdateDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{141}
}

func (x *UpdateDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return nil
}

func (x *UpdateDeidentifyTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDeidentifyTemplate.
type GetDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and deidentify template to be
	// read, for example `organizations/433245324/deidentifyTemplates/432452342`
	// or projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeidentifyTemplateRequest) Reset() {
	*x = GetDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeidentifyTemplateRequest) ProtoMessage() {}

func (x *GetDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{142}
}

func (x *GetDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//   - Organizations scope, location specified:<br/>
	//     `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Organizations scope, no location specified (defaults to global):<br/>
	//     `organizations/`<var>ORG_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from the previous call
	// to `ListDeidentifyTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to the time the template was created.
	// - `update_time`: corresponds to the time the template was last updated.
	// - `name`: corresponds to the template's name.
	// - `display_name`: corresponds to the template's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListDeidentifyTemplatesRequest) Reset() {
	*x = ListDeidentifyTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeidentifyTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeidentifyTemplatesRequest) ProtoMessage() {}

func (x *ListDeidentifyTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeidentifyTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListDeidentifyTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{143}
}

func (x *ListDeidentifyTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeidentifyTemplatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of deidentify templates, up to page_size in
	// ListDeidentifyTemplatesRequest.
	DeidentifyTemplates []*DeidentifyTemplate `protobuf:"bytes,1,rep,name=deidentify_templates,json=deidentifyTemplates,proto3" json:"deidentify_templates,omitempty"`
	// If the next page is available then the next page token to be used in the
	// following ListDeidentifyTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeidentifyTemplatesResponse) Reset() {
	*x = ListDeidentifyTemplatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeidentifyTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeidentifyTemplatesResponse) ProtoMessage() {}

func (x *ListDeidentifyTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeidentifyTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListDeidentifyTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{144}
}

func (x *ListDeidentifyTemplatesResponse) GetDeidentifyTemplates() []*DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplates
	}
	return nil
}

func (x *ListDeidentifyTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteDeidentifyTemplate.
type DeleteDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and deidentify template to be
	// deleted, for example
	// `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDeidentifyTemplateRequest) Reset() {
	*x = DeleteDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeidentifyTemplateRequest) ProtoMessage() {}

func (x *DeleteDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{145}
}

func (x *DeleteDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration for a custom dictionary created from a data source of any size
// up to the maximum size defined in the
// [limits](https://cloud.google.com/sensitive-data-protection/limits) page. The
// artifacts of dictionary creation are stored in the specified Cloud Storage
// location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries
// that satisfy the size requirements.
type LargeCustomDictionaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location to store dictionary artifacts in Cloud Storage. These files
	// will only be accessible by project owners and the DLP API. If any of these
	// artifacts are modified, the dictionary is considered invalid and can no
	// longer be used.
	OutputPath *CloudStoragePath `protobuf:"bytes,1,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// Source of the dictionary.
	//
	// Types that are assignable to Source:
	//
	//	*LargeCustomDictionaryConfig_CloudStorageFileSet
	//	*LargeCustomDictionaryConfig_BigQueryField
	Source isLargeCustomDictionaryConfig_Source `protobuf_oneof:"source"`
}

func (x *LargeCustomDictionaryConfig) Reset() {
	*x = LargeCustomDictionaryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LargeCustomDictionaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCustomDictionaryConfig) ProtoMessage() {}

func (x *LargeCustomDictionaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCustomDictionaryConfig.ProtoReflect.Descriptor instead.
func (*LargeCustomDictionaryConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{146}
}

func (x *LargeCustomDictionaryConfig) GetOutputPath() *CloudStoragePath {
	if x != nil {
		return x.OutputPath
	}
	return nil
}

func (m *LargeCustomDictionaryConfig) GetSource() isLargeCustomDictionaryConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *LargeCustomDictionaryConfig) GetCloudStorageFileSet() *CloudStorageFileSet {
	if x, ok := x.GetSource().(*LargeCustomDictionaryConfig_CloudStorageFileSet); ok {
		return x.CloudStorageFileSet
	}
	return nil
}

func (x *LargeCustomDictionaryConfig) GetBigQueryField() *BigQueryField {
	if x, ok := x.GetSource().(*LargeCustomDictionaryConfig_BigQueryField); ok {
		return x.BigQueryField
	}
	return nil
}

type isLargeCustomDictionaryConfig_Source interface {
	isLargeCustomDictionaryConfig_Source()
}

type LargeCustomDictionaryConfig_CloudStorageFileSet struct {
	// Set of files containing newline-delimited lists of dictionary phrases.
	CloudStorageFileSet *CloudStorageFileSet `protobuf:"bytes,2,opt,name=cloud_storage_file_set,json=cloudStorageFileSet,proto3,oneof"`
}

type LargeCustomDictionaryConfig_BigQueryField struct {
	// Field in a BigQuery table where each cell represents a dictionary phrase.
	BigQueryField *BigQueryField `protobuf:"bytes,3,opt,name=big_query_field,json=bigQueryField,proto3,oneof"`
}

func (*LargeCustomDictionaryConfig_CloudStorageFileSet) isLargeCustomDictionaryConfig_Source() {}

func (*LargeCustomDictionaryConfig_BigQueryField) isLargeCustomDictionaryConfig_Source() {}

// Summary statistics of a custom dictionary.
type LargeCustomDictionaryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approximate number of distinct phrases in the dictionary.
	ApproxNumPhrases int64 `protobuf:"varint,1,opt,name=approx_num_phrases,json=approxNumPhrases,proto3" json:"approx_num_phrases,omitempty"`
}

func (x *LargeCustomDictionaryStats) Reset() {
	*x = LargeCustomDictionaryStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LargeCustomDictionaryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCustomDictionaryStats) ProtoMessage() {}

func (x *LargeCustomDictionaryStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCustomDictionaryStats.ProtoReflect.Descriptor instead.
func (*LargeCustomDictionaryStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{147}
}

func (x *LargeCustomDictionaryStats) GetApproxNumPhrases() int64 {
	if x != nil {
		return x.ApproxNumPhrases
	}
	return 0
}

// Configuration for stored infoTypes. All fields and subfield are provided
// by the user. For more information, see
// https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes.
type StoredInfoTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of the StoredInfoType (max 256 characters).
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the StoredInfoType (max 256 characters).
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Stored infotype types.
	//
	// Types that are assignable to Type:
	//
	//	*StoredInfoTypeConfig_LargeCustomDictionary
	//	*StoredInfoTypeConfig_Dictionary
	//	*StoredInfoTypeConfig_Regex
	Type isStoredInfoTypeConfig_Type `protobuf_oneof:"type"`
}

func (x *StoredInfoTypeConfig) Reset() {
	*x = StoredInfoTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeConfig) ProtoMessage() {}

func (x *StoredInfoTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeConfig.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{148}
}

func (x *StoredInfoTypeConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *StoredInfoTypeConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *StoredInfoTypeConfig) GetType() isStoredInfoTypeConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetLargeCustomDictionary() *LargeCustomDictionaryConfig {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_LargeCustomDictionary); ok {
		return x.LargeCustomDictionary
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_Dictionary); ok {
		return x.Dictionary
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetRegex() *CustomInfoType_Regex {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_Regex); ok {
		return x.Regex
	}
	return nil
}

type isStoredInfoTypeConfig_Type interface {
	isStoredInfoTypeConfig_Type()
}

type StoredInfoTypeConfig_LargeCustomDictionary struct {
	// StoredInfoType where findings are defined by a dictionary of phrases.
	LargeCustomDictionary *LargeCustomDictionaryConfig `protobuf:"bytes,3,opt,name=large_custom_dictionary,json=largeCustomDictionary,proto3,oneof"`
}

type StoredInfoTypeConfig_Dictionary struct {
	// Store dictionary-based CustomInfoType.
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,4,opt,name=dictionary,proto3,oneof"`
}

type StoredInfoTypeConfig_Regex struct {
	// Store regular expression-based StoredInfoType.
	Regex *CustomInfoType_Regex `protobuf:"bytes,5,opt,name=regex,proto3,oneof"`
}

func (*StoredInfoTypeConfig_LargeCustomDictionary) isStoredInfoTypeConfig_Type() {}

func (*StoredInfoTypeConfig_Dictionary) isStoredInfoTypeConfig_Type() {}

func (*StoredInfoTypeConfig_Regex) isStoredInfoTypeConfig_Type() {}

// Statistics for a StoredInfoType.
type StoredInfoTypeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stat types
	//
	// Types that are assignable to Type:
	//
	//	*StoredInfoTypeStats_LargeCustomDictionary
	Type isStoredInfoTypeStats_Type `protobuf_oneof:"type"`
}

func (x *StoredInfoTypeStats) Reset() {
	*x = StoredInfoTypeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeStats) ProtoMessage() {}

func (x *StoredInfoTypeStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeStats.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{149}
}

func (m *StoredInfoTypeStats) GetType() isStoredInfoTypeStats_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StoredInfoTypeStats) GetLargeCustomDictionary() *LargeCustomDictionaryStats {
	if x, ok := x.GetType().(*StoredInfoTypeStats_LargeCustomDictionary); ok {
		return x.LargeCustomDictionary
	}
	return nil
}

type isStoredInfoTypeStats_Type interface {
	isStoredInfoTypeStats_Type()
}

type StoredInfoTypeStats_LargeCustomDictionary struct {
	// StoredInfoType where findings are defined by a dictionary of phrases.
	LargeCustomDictionary *LargeCustomDictionaryStats `protobuf:"bytes,1,opt,name=large_custom_dictionary,json=largeCustomDictionary,proto3,oneof"`
}

func (*StoredInfoTypeStats_LargeCustomDictionary) isStoredInfoTypeStats_Type() {}

// Version of a StoredInfoType, including the configuration used to build it,
// create timestamp, and current state.
type StoredInfoTypeVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// StoredInfoType configuration.
	Config *StoredInfoTypeConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Create timestamp of the version. Read-only, determined by the system
	// when the version is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Stored info type version state. Read-only, updated by the system
	// during dictionary creation.
	State StoredInfoTypeState `protobuf:"varint,3,opt,name=state,proto3,enum=google.privacy.dlp.v2.StoredInfoTypeState" json:"state,omitempty"`
	// Errors that occurred when creating this storedInfoType version, or
	// anomalies detected in the storedInfoType data that render it unusable. Only
	// the five most recent errors will be displayed, with the most recent error
	// appearing first.
	//
	// For example, some of the data for stored custom dictionaries is put in
	// the user's Cloud Storage bucket, and if this data is modified or
	// deleted by the user or another system, the dictionary becomes invalid.
	//
	// If any errors occur, fix the problem indicated by the error message and
	// use the UpdateStoredInfoType API method to create another version of the
	// storedInfoType to continue using it, reusing the same `config` if it was
	// not the source of the error.
	Errors []*Error `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
	// Statistics about this storedInfoType version.
	Stats *StoredInfoTypeStats `protobuf:"bytes,5,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *StoredInfoTypeVersion) Reset() {
	*x = StoredInfoTypeVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeVersion) ProtoMessage() {}

func (x *StoredInfoTypeVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeVersion.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeVersion) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{150}
}

func (x *StoredInfoTypeVersion) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetState() StoredInfoTypeState {
	if x != nil {
		return x.State
	}
	return StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED
}

func (x *StoredInfoTypeVersion) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetStats() *StoredInfoTypeStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// StoredInfoType resource message that contains information about the current
// version and any pending updates.
type StoredInfoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Current version of the stored info type.
	CurrentVersion *StoredInfoTypeVersion `protobuf:"bytes,2,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	// Pending versions of the stored info type. Empty if no versions are
	// pending.
	PendingVersions []*StoredInfoTypeVersion `protobuf:"bytes,3,rep,name=pending_versions,json=pendingVersions,proto3" json:"pending_versions,omitempty"`
}

func (x *StoredInfoType) Reset() {
	*x = StoredInfoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoType) ProtoMessage() {}

func (x *StoredInfoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoType.ProtoReflect.Descriptor instead.
func (*StoredInfoType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{151}
}

func (x *StoredInfoType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StoredInfoType) GetCurrentVersion() *StoredInfoTypeVersion {
	if x != nil {
		return x.CurrentVersion
	}
	return nil
}

func (x *StoredInfoType) GetPendingVersions() []*StoredInfoTypeVersion {
	if x != nil {
		return x.PendingVersions
	}
	return nil
}

// Request message for CreateStoredInfoType.
type CreateStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//   - Organizations scope, location specified:<br/>
	//     `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Organizations scope, no location specified (defaults to global):<br/>
	//     `organizations/`<var>ORG_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Configuration of the storedInfoType to create.
	Config *StoredInfoTypeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The storedInfoType ID can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	StoredInfoTypeId string `protobuf:"bytes,3,opt,name=stored_info_type_id,json=storedInfoTypeId,proto3" json:"stored_info_type_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateStoredInfoTypeRequest) Reset() {
	*x = CreateStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStoredInfoTypeRequest) ProtoMessage() {}

func (x *CreateStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{152}
}

func (x *CreateStoredInfoTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateStoredInfoTypeRequest) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateStoredInfoTypeRequest) GetStoredInfoTypeId() string {
	if x != nil {
		return x.StoredInfoTypeId
	}
	return ""
}

func (x *CreateStoredInfoTypeRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateStoredInfoType.
type UpdateStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and storedInfoType to be updated,
	// for example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Updated configuration for the storedInfoType. If not provided, a new
	// version of the storedInfoType will be created with the existing
	// configuration.
	Config *StoredInfoTypeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateStoredInfoTypeRequest) Reset() {
	*x = UpdateStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStoredInfoTypeRequest) ProtoMessage() {}

func (x *UpdateStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{153}
}

func (x *UpdateStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateStoredInfoTypeRequest) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *UpdateStoredInfoTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetStoredInfoType.
type GetStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and storedInfoType to be read,
	// for example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStoredInfoTypeRequest) Reset() {
	*x = GetStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoredInfoTypeRequest) ProtoMessage() {}

func (x *GetStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*GetStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{154}
}

func (x *GetStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListStoredInfoTypes.
type ListStoredInfoTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	//
	// The format of this value varies depending on the scope of the request
	// (project or organization) and whether you have [specified a processing
	// location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
	//
	//   - Projects scope, location specified:<br/>
	//     `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
	//   - Projects scope, no location specified (defaults to global):<br/>
	//     `projects/`<var>PROJECT_ID</var>
	//
	// The following example `parent` string specifies a parent project with the
	// identifier `example-project`, and specifies the `europe-west3` location
	// for processing data:
	//
	//	parent=projects/example-project/locations/europe-west3
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from the previous call
	// to `ListStoredInfoTypes`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case insensitive. The
	// default sorting order is ascending. Redundant space characters are
	// insignificant.
	//
	// Example: `name asc, display_name, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to the time the most recent version of the
	// resource was created.
	// - `state`: corresponds to the state of the resource.
	// - `name`: corresponds to resource name.
	// - `display_name`: corresponds to info type's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListStoredInfoTypesRequest) Reset() {
	*x = ListStoredInfoTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStoredInfoTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoredInfoTypesRequest) ProtoMessage() {}

func (x *ListStoredInfoTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoredInfoTypesRequest.ProtoReflect.Descriptor instead.
func (*ListStoredInfoTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{155}
}

func (x *ListStoredInfoTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListStoredInfoTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListStoredInfoTypes.
type ListStoredInfoTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of storedInfoTypes, up to page_size in ListStoredInfoTypesRequest.
	StoredInfoTypes []*StoredInfoType `protobuf:"bytes,1,rep,name=stored_info_types,json=storedInfoTypes,proto3" json:"stored_info_types,omitempty"`
	// If the next page is available then the next page token to be used
	// in the following ListStoredInfoTypes request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListStoredInfoTypesResponse) Reset() {
	*x = ListStoredInfoTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStoredInfoTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoredInfoTypesResponse) ProtoMessage() {}

func (x *ListStoredInfoTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoredInfoTypesResponse.ProtoReflect.Descriptor instead.
func (*ListStoredInfoTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{156}
}

func (x *ListStoredInfoTypesResponse) GetStoredInfoTypes() []*StoredInfoType {
	if x != nil {
		return x.StoredInfoTypes
	}
	return nil
}

func (x *ListStoredInfoTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteStoredInfoType.
type DeleteStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and storedInfoType to be
	// deleted, for example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteStoredInfoTypeRequest) Reset() {
	*x = DeleteStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStoredInfoTypeRequest) ProtoMessage() {}

func (x *DeleteStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{157}
}

func (x *DeleteStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to search for potentially sensitive info in a custom location.
type HybridInspectJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the trigger to execute a hybrid inspect on, for
	// example `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The item to inspect.
	HybridItem *HybridContentItem `protobuf:"bytes,3,opt,name=hybrid_item,json=hybridItem,proto3" json:"hybrid_item,omitempty"`
}

func (x *HybridInspectJobTriggerRequest) Reset() {
	*x = HybridInspectJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectJobTriggerRequest) ProtoMessage() {}

func (x *HybridInspectJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*HybridInspectJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{158}
}

func (x *HybridInspectJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HybridInspectJobTriggerRequest) GetHybridItem() *HybridContentItem {
	if x != nil {
		return x.HybridItem
	}
	return nil
}

// Request to search for potentially sensitive info in a custom location.
type HybridInspectDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the job to execute a hybrid inspect on, for
	// example `projects/dlp-test-project/dlpJob/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The item to inspect.
	HybridItem *HybridContentItem `protobuf:"bytes,3,opt,name=hybrid_item,json=hybridItem,proto3" json:"hybrid_item,omitempty"`
}

func (x *HybridInspectDlpJobRequest) Reset() {
	*x = HybridInspectDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[159]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectDlpJobRequest) ProtoMessage() {}

func (x *HybridInspectDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[159]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectDlpJobRequest.ProtoReflect.Descriptor instead.
func (*HybridInspectDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{159}
}

func (x *HybridInspectDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HybridInspectDlpJobRequest) GetHybridItem() *HybridContentItem {
	if x != nil {
		return x.HybridItem
	}
	return nil
}

// An individual hybrid item to inspect. Will be stored temporarily during
// processing.
type HybridContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The item to inspect.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// Supplementary information that will be added to each finding.
	FindingDetails *HybridFindingDetails `protobuf:"bytes,2,opt,name=finding_details,json=findingDetails,proto3" json:"finding_details,omitempty"`
}

func (x *HybridContentItem) Reset() {
	*x = HybridContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridContentItem) ProtoMessage() {}

func (x *HybridContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridContentItem.ProtoReflect.Descriptor instead.
func (*HybridContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{160}
}

func (x *HybridContentItem) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *HybridContentItem) GetFindingDetails() *HybridFindingDetails {
	if x != nil {
		return x.FindingDetails
	}
	return nil
}

// Populate to associate additional data with each finding.
type HybridFindingDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the container where the content being inspected is from.
	ContainerDetails *Container `protobuf:"bytes,1,opt,name=container_details,json=containerDetails,proto3" json:"container_details,omitempty"`
	// Offset in bytes of the line, from the beginning of the file, where the
	// finding  is located. Populate if the item being scanned is only part of a
	// bigger item, such as a shard of a file and you want to track the absolute
	// position of the finding.
	FileOffset int64 `protobuf:"varint,2,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
	// Offset of the row for tables. Populate if the row(s) being scanned are
	// part of a bigger dataset and you want to keep track of their absolute
	// position.
	RowOffset int64 `protobuf:"varint,3,opt,name=row_offset,json=rowOffset,proto3" json:"row_offset,omitempty"`
	// If the container is a table, additional information to make findings
	// meaningful such as the columns that are primary keys. If not known ahead
	// of time, can also be set within each inspect hybrid call and the two
	// will be merged. Note that identifying_fields will only be stored to
	// BigQuery, and only if the BigQuery action has been included.
	TableOptions *TableOptions `protobuf:"bytes,4,opt,name=table_options,json=tableOptions,proto3" json:"table_options,omitempty"`
	// Labels to represent user provided metadata about the data being inspected.
	// If configured by the job, some key values may be required.
	// The labels associated with `Finding`'s produced by hybrid
	// inspection.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// Label values must be between 0 and 63 characters long and must conform
	// to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//
	// No more than 10 labels can be associated with a given finding.
	//
	// Examples:
	// * `"environment" : "production"`
	// * `"pipeline" : "etl"`
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *HybridFindingDetails) Reset() {
	*x = HybridFindingDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[161]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridFindingDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridFindingDetails) ProtoMessage() {}

func (x *HybridFindingDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[161]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridFindingDetails.ProtoReflect.Descriptor instead.
func (*HybridFindingDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{161}
}

func (x *HybridFindingDetails) GetContainerDetails() *Container {
	if x != nil {
		return x.ContainerDetails
	}
	return nil
}

func (x *HybridFindingDetails) GetFileOffset() int64 {
	if x != nil {
		return x.FileOffset
	}
	return 0
}

func (x *HybridFindingDetails) GetRowOffset() int64 {
	if x != nil {
		return x.RowOffset
	}
	return 0
}

func (x *HybridFindingDetails) GetTableOptions() *TableOptions {
	if x != nil {
		return x.TableOptions
	}
	return nil
}

func (x *HybridFindingDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Quota exceeded errors will be thrown once quota has been met.
type HybridInspectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HybridInspectResponse) Reset() {
	*x = HybridInspectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[162]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectResponse) ProtoMessage() {}

func (x *HybridInspectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[162]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectResponse.ProtoReflect.Descriptor instead.
func (*HybridInspectResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{162}
}

// Request to list the profiles generated for a given organization or project.
type ListProjectDataProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. organizations/{org_id}/locations/{loc_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero, server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by, followed by `asc` or `desc`
	// postfix. This list is case insensitive. The default sorting order is
	// ascending. Redundant space characters are insignificant. Only one order
	// field at a time is allowed.
	//
	// Examples:
	// * `project_id`
	// * `sensitivity_level desc`
	//
	// Supported fields are:
	//
	// - `project_id`: GCP project ID
	// - `sensitivity_level`: How sensitive the data in a project is, at most.
	// - `data_risk_level`: How much risk is associated with this data.
	// - `profile_last_generated`: When the profile was last updated in epoch
	// seconds.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values:
	//   - `sensitivity_level` - HIGH|MODERATE|LOW
	//   - `data_risk_level` - HIGH|MODERATE|LOW
	//   - `status_code` - an RPC status code as defined in
	//     https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
	//
	// * The operator must be `=` or `!=`.
	//
	// Examples:
	//
	// * `project_id = 12345 AND status_code = 1`
	// * `project_id = 12345 AND sensitivity_level = HIGH`
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListProjectDataProfilesRequest) Reset() {
	*x = ListProjectDataProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProjectDataProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProjectDataProfilesRequest) ProtoMessage() {}

func (x *ListProjectDataProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProjectDataProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListProjectDataProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{163}
}

func (x *ListProjectDataProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProjectDataProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProjectDataProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProjectDataProfilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListProjectDataProfilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List of profiles generated for a given organization or project.
type ListProjectDataProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of data profiles.
	ProjectDataProfiles []*ProjectDataProfile `protobuf:"bytes,1,rep,name=project_data_profiles,json=projectDataProfiles,proto3" json:"project_data_profiles,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProjectDataProfilesResponse) Reset() {
	*x = ListProjectDataProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProjectDataProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProjectDataProfilesResponse) ProtoMessage() {}

func (x *ListProjectDataProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProjectDataProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListProjectDataProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{164}
}

func (x *ListProjectDataProfilesResponse) GetProjectDataProfiles() []*ProjectDataProfile {
	if x != nil {
		return x.ProjectDataProfiles
	}
	return nil
}

func (x *ListProjectDataProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to list the profiles generated for a given organization or project.
type ListTableDataProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization or project, for
	// example `organizations/433245324/locations/europe` or
	// `projects/project-id/locations/asia`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero, server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by, followed by `asc` or `desc`
	// postfix. This list is case insensitive. The default sorting order is
	// ascending. Redundant space characters are insignificant. Only one order
	// field at a time is allowed.
	//
	// Examples:
	// * `project_id asc`
	// * `table_id`
	// * `sensitivity_level desc`
	//
	// Supported fields are:
	//
	// - `project_id`: The GCP project ID.
	// - `dataset_id`: The ID of a BigQuery dataset.
	// - `table_id`: The ID of a BigQuery table.
	// - `sensitivity_level`: How sensitive the data in a table is, at most.
	// - `data_risk_level`: How much risk is associated with this data.
	// - `profile_last_generated`: When the profile was last updated in epoch
	// seconds.
	// - `last_modified`: The last time the resource was modified.
	// - `resource_visibility`: Visibility restriction for this resource.
	// - `row_count`: Number of rows in this resource.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values:
	//   - `project_id` - The GCP project ID.
	//   - `dataset_id` - The BigQuery dataset ID.
	//   - `table_id` - The ID of the BigQuery table.
	//   - `sensitivity_level` - HIGH|MODERATE|LOW
	//   - `data_risk_level` - HIGH|MODERATE|LOW
	//   - `resource_visibility`: PUBLIC|RESTRICTED
	//   - `status_code` - an RPC status code as defined in
	//     https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
	//
	// * The operator must be `=` or `!=`.
	//
	// Examples:
	//
	// * `project_id = 12345 AND status_code = 1`
	// * `project_id = 12345 AND sensitivity_level = HIGH`
	// * `project_id = 12345 AND resource_visibility = PUBLIC`
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListTableDataProfilesRequest) Reset() {
	*x = ListTableDataProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTableDataProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTableDataProfilesRequest) ProtoMessage() {}

func (x *ListTableDataProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTableDataProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListTableDataProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{165}
}

func (x *ListTableDataProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTableDataProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTableDataProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTableDataProfilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListTableDataProfilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List of profiles generated for a given organization or project.
type ListTableDataProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of data profiles.
	TableDataProfiles []*TableDataProfile `protobuf:"bytes,1,rep,name=table_data_profiles,json=tableDataProfiles,proto3" json:"table_data_profiles,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTableDataProfilesResponse) Reset() {
	*x = ListTableDataProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTableDataProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTableDataProfilesResponse) ProtoMessage() {}

func (x *ListTableDataProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTableDataProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListTableDataProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{166}
}

func (x *ListTableDataProfilesResponse) GetTableDataProfiles() []*TableDataProfile {
	if x != nil {
		return x.TableDataProfiles
	}
	return nil
}

func (x *ListTableDataProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to list the profiles generated for a given organization or project.
type ListColumnDataProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization or project, for
	// example `organizations/433245324/locations/europe` or
	// `projects/project-id/locations/asia`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page. This value can be limited by the server. If zero, server
	// returns a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by, followed by `asc` or `desc`
	// postfix. This list is case insensitive. The default sorting order is
	// ascending. Redundant space characters are insignificant. Only one order
	// field at a time is allowed.
	//
	// Examples:
	// * `project_id asc`
	// * `table_id`
	// * `sensitivity_level desc`
	//
	// Supported fields are:
	//
	// - `project_id`: The Google Cloud project ID.
	// - `dataset_id`: The ID of a BigQuery dataset.
	// - `table_id`: The ID of a BigQuery table.
	// - `sensitivity_level`: How sensitive the data in a column is, at most.
	// - `data_risk_level`: How much risk is associated with this data.
	// - `profile_last_generated`: When the profile was last updated in epoch
	// seconds.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values:
	//   - `table_data_profile_name` - The name of the related table data
	//     profile.
	//   - `project_id` - The Google Cloud project ID. (REQUIRED)
	//   - `dataset_id` - The BigQuery dataset ID. (REQUIRED)
	//   - `table_id` - The BigQuery table ID. (REQUIRED)
	//   - `field_id` - The ID of the BigQuery field.
	//   - `info_type` - The infotype detected in the resource.
	//   - `sensitivity_level` - HIGH|MEDIUM|LOW
	//   - `data_risk_level`: How much risk is associated with this data.
	//   - `status_code` - an RPC status code as defined in
	//     https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
	//   - The operator must be `=` for project_id, dataset_id, and table_id. Other
	//     filters also support `!=`.
	//
	// Examples:
	//
	// * project_id = 12345 AND status_code = 1
	// * project_id = 12345 AND sensitivity_level = HIGH
	// * project_id = 12345 AND info_type = STREET_ADDRESS
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListColumnDataProfilesRequest) Reset() {
	*x = ListColumnDataProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListColumnDataProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListColumnDataProfilesRequest) ProtoMessage() {}

func (x *ListColumnDataProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListColumnDataProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListColumnDataProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{167}
}

func (x *ListColumnDataProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListColumnDataProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListColumnDataProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListColumnDataProfilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListColumnDataProfilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List of profiles generated for a given organization or project.
type ListColumnDataProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of data profiles.
	ColumnDataProfiles []*ColumnDataProfile `protobuf:"bytes,1,rep,name=column_data_profiles,json=columnDataProfiles,proto3" json:"column_data_profiles,omitempty"`
	// The next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListColumnDataProfilesResponse) Reset() {
	*x = ListColumnDataProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListColumnDataProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListColumnDataProfilesResponse) ProtoMessage() {}

func (x *ListColumnDataProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListColumnDataProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListColumnDataProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{168}
}

func (x *ListColumnDataProfilesResponse) GetColumnDataProfiles() []*ColumnDataProfile {
	if x != nil {
		return x.ColumnDataProfiles
	}
	return nil
}

func (x *ListColumnDataProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Score is a summary of all elements in the data profile.
// A higher number means more risk.
type DataRiskLevel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The score applied to the resource.
	Score DataRiskLevel_DataRiskLevelScore `protobuf:"varint,1,opt,name=score,proto3,enum=google.privacy.dlp.v2.DataRiskLevel_DataRiskLevelScore" json:"score,omitempty"`
}

func (x *DataRiskLevel) Reset() {
	*x = DataRiskLevel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[169]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataRiskLevel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataRiskLevel) ProtoMessage() {}

func (x *DataRiskLevel) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[169]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataRiskLevel.ProtoReflect.Descriptor instead.
func (*DataRiskLevel) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{169}
}

func (x *DataRiskLevel) GetScore() DataRiskLevel_DataRiskLevelScore {
	if x != nil {
		return x.Score
	}
	return DataRiskLevel_RISK_SCORE_UNSPECIFIED
}

// An aggregated profile for this project, based on the resources profiled
// within it.
type ProjectDataProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the profile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Project ID that was profiled.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The last time the profile was generated.
	ProfileLastGenerated *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=profile_last_generated,json=profileLastGenerated,proto3" json:"profile_last_generated,omitempty"`
	// The sensitivity score of this project.
	SensitivityScore *SensitivityScore `protobuf:"bytes,4,opt,name=sensitivity_score,json=sensitivityScore,proto3" json:"sensitivity_score,omitempty"`
	// The data risk level of this project.
	DataRiskLevel *DataRiskLevel `protobuf:"bytes,5,opt,name=data_risk_level,json=dataRiskLevel,proto3" json:"data_risk_level,omitempty"`
	// Success or error status of the last attempt to profile the project.
	ProfileStatus *ProfileStatus `protobuf:"bytes,7,opt,name=profile_status,json=profileStatus,proto3" json:"profile_status,omitempty"`
}

func (x *ProjectDataProfile) Reset() {
	*x = ProjectDataProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[170]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectDataProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectDataProfile) ProtoMessage() {}

func (x *ProjectDataProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[170]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectDataProfile.ProtoReflect.Descriptor instead.
func (*ProjectDataProfile) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{170}
}

func (x *ProjectDataProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProjectDataProfile) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ProjectDataProfile) GetProfileLastGenerated() *timestamppb.Timestamp {
	if x != nil {
		return x.ProfileLastGenerated
	}
	return nil
}

func (x *ProjectDataProfile) GetSensitivityScore() *SensitivityScore {
	if x != nil {
		return x.SensitivityScore
	}
	return nil
}

func (x *ProjectDataProfile) GetDataRiskLevel() *DataRiskLevel {
	if x != nil {
		return x.DataRiskLevel
	}
	return nil
}

func (x *ProjectDataProfile) GetProfileStatus() *ProfileStatus {
	if x != nil {
		return x.ProfileStatus
	}
	return nil
}

// Snapshot of the configurations used to generate the profile.
type DataProfileConfigSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A copy of the inspection config used to generate this profile. This
	// is a copy of the inspect_template specified in `DataProfileJobConfig`.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// A copy of the configuration used to generate this profile. This is
	// deprecated, and the DiscoveryConfig field is preferred moving forward.
	// DataProfileJobConfig will still be written here for Discovery in BigQuery
	// for backwards compatibility, but will not be updated with new fields, while
	// DiscoveryConfig will.
	//
	// Deprecated: Marked as deprecated in google/privacy/dlp/v2/dlp.proto.
	DataProfileJob *DataProfileJobConfig `protobuf:"bytes,3,opt,name=data_profile_job,json=dataProfileJob,proto3" json:"data_profile_job,omitempty"`
	// A copy of the configuration used to generate this profile.
	DiscoveryConfig *DiscoveryConfig `protobuf:"bytes,4,opt,name=discovery_config,json=discoveryConfig,proto3" json:"discovery_config,omitempty"`
	// Name of the inspection template used to generate this profile
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Timestamp when the template was modified
	InspectTemplateModifiedTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=inspect_template_modified_time,json=inspectTemplateModifiedTime,proto3" json:"inspect_template_modified_time,omitempty"`
}

func (x *DataProfileConfigSnapshot) Reset() {
	*x = DataProfileConfigSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[171]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileConfigSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileConfigSnapshot) ProtoMessage() {}

func (x *DataProfileConfigSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[171]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileConfigSnapshot.ProtoReflect.Descriptor instead.
func (*DataProfileConfigSnapshot) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{171}
}

func (x *DataProfileConfigSnapshot) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/privacy/dlp/v2/dlp.proto.
func (x *DataProfileConfigSnapshot) GetDataProfileJob() *DataProfileJobConfig {
	if x != nil {
		return x.DataProfileJob
	}
	return nil
}

func (x *DataProfileConfigSnapshot) GetDiscoveryConfig() *DiscoveryConfig {
	if x != nil {
		return x.DiscoveryConfig
	}
	return nil
}

func (x *DataProfileConfigSnapshot) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *DataProfileConfigSnapshot) GetInspectTemplateModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InspectTemplateModifiedTime
	}
	return nil
}

// The profile for a scanned table.
type TableDataProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the profile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource type that was profiled.
	DataSourceType *DataSourceType `protobuf:"bytes,36,opt,name=data_source_type,json=dataSourceType,proto3" json:"data_source_type,omitempty"`
	// The resource name to the project data profile for this table.
	ProjectDataProfile string `protobuf:"bytes,2,opt,name=project_data_profile,json=projectDataProfile,proto3" json:"project_data_profile,omitempty"`
	// The Google Cloud project ID that owns the resource.
	DatasetProjectId string `protobuf:"bytes,24,opt,name=dataset_project_id,json=datasetProjectId,proto3" json:"dataset_project_id,omitempty"`
	// If supported, the location where the dataset's data is stored.
	// See https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	DatasetLocation string `protobuf:"bytes,29,opt,name=dataset_location,json=datasetLocation,proto3" json:"dataset_location,omitempty"`
	// If the resource is BigQuery, the  dataset ID.
	DatasetId string `protobuf:"bytes,25,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// If the resource is BigQuery, the BigQuery table ID.
	TableId string `protobuf:"bytes,26,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// The resource name of the resource profiled.
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	FullResource string `protobuf:"bytes,3,opt,name=full_resource,json=fullResource,proto3" json:"full_resource,omitempty"`
	// Success or error status from the most recent profile generation attempt.
	// May be empty if the profile is still being generated.
	ProfileStatus *ProfileStatus `protobuf:"bytes,21,opt,name=profile_status,json=profileStatus,proto3" json:"profile_status,omitempty"`
	// State of a profile.
	State TableDataProfile_State `protobuf:"varint,22,opt,name=state,proto3,enum=google.privacy.dlp.v2.TableDataProfile_State" json:"state,omitempty"`
	// The sensitivity score of this table.
	SensitivityScore *SensitivityScore `protobuf:"bytes,5,opt,name=sensitivity_score,json=sensitivityScore,proto3" json:"sensitivity_score,omitempty"`
	// The data risk level of this table.
	DataRiskLevel *DataRiskLevel `protobuf:"bytes,6,opt,name=data_risk_level,json=dataRiskLevel,proto3" json:"data_risk_level,omitempty"`
	// The infoTypes predicted from this table's data.
	PredictedInfoTypes []*InfoTypeSummary `protobuf:"bytes,27,rep,name=predicted_info_types,json=predictedInfoTypes,proto3" json:"predicted_info_types,omitempty"`
	// Other infoTypes found in this table's data.
	OtherInfoTypes []*OtherInfoTypeSummary `protobuf:"bytes,28,rep,name=other_info_types,json=otherInfoTypes,proto3" json:"other_info_types,omitempty"`
	// The snapshot of the configurations used to generate the profile.
	ConfigSnapshot *DataProfileConfigSnapshot `protobuf:"bytes,7,opt,name=config_snapshot,json=configSnapshot,proto3" json:"config_snapshot,omitempty"`
	// The time when this table was last modified
	LastModifiedTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Optional. The time when this table expires.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// The number of columns profiled in the table.
	ScannedColumnCount int64 `protobuf:"varint,10,opt,name=scanned_column_count,json=scannedColumnCount,proto3" json:"scanned_column_count,omitempty"`
	// The number of columns skipped in the table because of an error.
	FailedColumnCount int64 `protobuf:"varint,11,opt,name=failed_column_count,json=failedColumnCount,proto3" json:"failed_column_count,omitempty"`
	// The size of the table when the profile was generated.
	TableSizeBytes int64 `protobuf:"varint,12,opt,name=table_size_bytes,json=tableSizeBytes,proto3" json:"table_size_bytes,omitempty"`
	// Number of rows in the table when the profile was generated.
	// This will not be populated for BigLake tables.
	RowCount int64 `protobuf:"varint,13,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// How the table is encrypted.
	EncryptionStatus EncryptionStatus `protobuf:"varint,14,opt,name=encryption_status,json=encryptionStatus,proto3,enum=google.privacy.dlp.v2.EncryptionStatus" json:"encryption_status,omitempty"`
	// How broadly a resource has been shared.
	ResourceVisibility ResourceVisibility `protobuf:"varint,15,opt,name=resource_visibility,json=resourceVisibility,proto3,enum=google.privacy.dlp.v2.ResourceVisibility" json:"resource_visibility,omitempty"`
	// The last time the profile was generated.
	ProfileLastGenerated *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=profile_last_generated,json=profileLastGenerated,proto3" json:"profile_last_generated,omitempty"`
	// The labels applied to the resource at the time the profile was generated.
	ResourceLabels map[string]string `protobuf:"bytes,17,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The time at which the table was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,23,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *TableDataProfile) Reset() {
	*x = TableDataProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[172]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableDataProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableDataProfile) ProtoMessage() {}

func (x *TableDataProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[172]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableDataProfile.ProtoReflect.Descriptor instead.
func (*TableDataProfile) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{172}
}

func (x *TableDataProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TableDataProfile) GetDataSourceType() *DataSourceType {
	if x != nil {
		return x.DataSourceType
	}
	return nil
}

func (x *TableDataProfile) GetProjectDataProfile() string {
	if x != nil {
		return x.ProjectDataProfile
	}
	return ""
}

func (x *TableDataProfile) GetDatasetProjectId() string {
	if x != nil {
		return x.DatasetProjectId
	}
	return ""
}

func (x *TableDataProfile) GetDatasetLocation() string {
	if x != nil {
		return x.DatasetLocation
	}
	return ""
}

func (x *TableDataProfile) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *TableDataProfile) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *TableDataProfile) GetFullResource() string {
	if x != nil {
		return x.FullResource
	}
	return ""
}

func (x *TableDataProfile) GetProfileStatus() *ProfileStatus {
	if x != nil {
		return x.ProfileStatus
	}
	return nil
}

func (x *TableDataProfile) GetState() TableDataProfile_State {
	if x != nil {
		return x.State
	}
	return TableDataProfile_STATE_UNSPECIFIED
}

func (x *TableDataProfile) GetSensitivityScore() *SensitivityScore {
	if x != nil {
		return x.SensitivityScore
	}
	return nil
}

func (x *TableDataProfile) GetDataRiskLevel() *DataRiskLevel {
	if x != nil {
		return x.DataRiskLevel
	}
	return nil
}

func (x *TableDataProfile) GetPredictedInfoTypes() []*InfoTypeSummary {
	if x != nil {
		return x.PredictedInfoTypes
	}
	return nil
}

func (x *TableDataProfile) GetOtherInfoTypes() []*OtherInfoTypeSummary {
	if x != nil {
		return x.OtherInfoTypes
	}
	return nil
}

func (x *TableDataProfile) GetConfigSnapshot() *DataProfileConfigSnapshot {
	if x != nil {
		return x.ConfigSnapshot
	}
	return nil
}

func (x *TableDataProfile) GetLastModifiedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedTime
	}
	return nil
}

func (x *TableDataProfile) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *TableDataProfile) GetScannedColumnCount() int64 {
	if x != nil {
		return x.ScannedColumnCount
	}
	return 0
}

func (x *TableDataProfile) GetFailedColumnCount() int64 {
	if x != nil {
		return x.FailedColumnCount
	}
	return 0
}

func (x *TableDataProfile) GetTableSizeBytes() int64 {
	if x != nil {
		return x.TableSizeBytes
	}
	return 0
}

func (x *TableDataProfile) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *TableDataProfile) GetEncryptionStatus() EncryptionStatus {
	if x != nil {
		return x.EncryptionStatus
	}
	return EncryptionStatus_ENCRYPTION_STATUS_UNSPECIFIED
}

func (x *TableDataProfile) GetResourceVisibility() ResourceVisibility {
	if x != nil {
		return x.ResourceVisibility
	}
	return ResourceVisibility_RESOURCE_VISIBILITY_UNSPECIFIED
}

func (x *TableDataProfile) GetProfileLastGenerated() *timestamppb.Timestamp {
	if x != nil {
		return x.ProfileLastGenerated
	}
	return nil
}

func (x *TableDataProfile) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *TableDataProfile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Success or errors for the profile generation.
type ProfileStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Profiling status code and optional message. The `status.code` value is 0
	// (default value) for OK.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Time when the profile generation status was updated
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *ProfileStatus) Reset() {
	*x = ProfileStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[173]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProfileStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProfileStatus) ProtoMessage() {}

func (x *ProfileStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[173]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProfileStatus.ProtoReflect.Descriptor instead.
func (*ProfileStatus) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{173}
}

func (x *ProfileStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ProfileStatus) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// The infoType details for this column.
type InfoTypeSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The infoType.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Not populated for predicted infotypes.
	//
	// Deprecated: Marked as deprecated in google/privacy/dlp/v2/dlp.proto.
	EstimatedPrevalence int32 `protobuf:"varint,2,opt,name=estimated_prevalence,json=estimatedPrevalence,proto3" json:"estimated_prevalence,omitempty"`
}

func (x *InfoTypeSummary) Reset() {
	*x = InfoTypeSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[174]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeSummary) ProtoMessage() {}

func (x *InfoTypeSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[174]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeSummary.ProtoReflect.Descriptor instead.
func (*InfoTypeSummary) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{174}
}

func (x *InfoTypeSummary) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

// Deprecated: Marked as deprecated in google/privacy/dlp/v2/dlp.proto.
func (x *InfoTypeSummary) GetEstimatedPrevalence() int32 {
	if x != nil {
		return x.EstimatedPrevalence
	}
	return 0
}

// Infotype details for other infoTypes found within a column.
type OtherInfoTypeSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The other infoType.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Approximate percentage of non-null rows that contained data detected by
	// this infotype.
	EstimatedPrevalence int32 `protobuf:"varint,2,opt,name=estimated_prevalence,json=estimatedPrevalence,proto3" json:"estimated_prevalence,omitempty"`
	// Whether this infoType was excluded from sensitivity and risk analysis due
	// to factors such as low prevalence (subject to change).
	ExcludedFromAnalysis bool `protobuf:"varint,3,opt,name=excluded_from_analysis,json=excludedFromAnalysis,proto3" json:"excluded_from_analysis,omitempty"`
}

func (x *OtherInfoTypeSummary) Reset() {
	*x = OtherInfoTypeSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[175]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OtherInfoTypeSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OtherInfoTypeSummary) ProtoMessage() {}

func (x *OtherInfoTypeSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[175]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OtherInfoTypeSummary.ProtoReflect.Descriptor instead.
func (*OtherInfoTypeSummary) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{175}
}

func (x *OtherInfoTypeSummary) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *OtherInfoTypeSummary) GetEstimatedPrevalence() int32 {
	if x != nil {
		return x.EstimatedPrevalence
	}
	return 0
}

func (x *OtherInfoTypeSummary) GetExcludedFromAnalysis() bool {
	if x != nil {
		return x.ExcludedFromAnalysis
	}
	return false
}

// The profile for a scanned column within a table.
type ColumnDataProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the profile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Success or error status from the most recent profile generation attempt.
	// May be empty if the profile is still being generated.
	ProfileStatus *ProfileStatus `protobuf:"bytes,17,opt,name=profile_status,json=profileStatus,proto3" json:"profile_status,omitempty"`
	// State of a profile.
	State ColumnDataProfile_State `protobuf:"varint,18,opt,name=state,proto3,enum=google.privacy.dlp.v2.ColumnDataProfile_State" json:"state,omitempty"`
	// The last time the profile was generated.
	ProfileLastGenerated *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=profile_last_generated,json=profileLastGenerated,proto3" json:"profile_last_generated,omitempty"`
	// The resource name of the table data profile.
	TableDataProfile string `protobuf:"bytes,4,opt,name=table_data_profile,json=tableDataProfile,proto3" json:"table_data_profile,omitempty"`
	// The resource name of the resource this column is within.
	TableFullResource string `protobuf:"bytes,5,opt,name=table_full_resource,json=tableFullResource,proto3" json:"table_full_resource,omitempty"`
	// The Google Cloud project ID that owns the profiled resource.
	DatasetProjectId string `protobuf:"bytes,19,opt,name=dataset_project_id,json=datasetProjectId,proto3" json:"dataset_project_id,omitempty"`
	// The BigQuery location where the dataset's data is stored.
	// See https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	DatasetLocation string `protobuf:"bytes,20,opt,name=dataset_location,json=datasetLocation,proto3" json:"dataset_location,omitempty"`
	// The BigQuery dataset ID.
	DatasetId string `protobuf:"bytes,21,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The BigQuery table ID.
	TableId string `protobuf:"bytes,22,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// The name of the column.
	Column string `protobuf:"bytes,6,opt,name=column,proto3" json:"column,omitempty"`
	// The sensitivity of this column.
	SensitivityScore *SensitivityScore `protobuf:"bytes,7,opt,name=sensitivity_score,json=sensitivityScore,proto3" json:"sensitivity_score,omitempty"`
	// The data risk level for this column.
	DataRiskLevel *DataRiskLevel `protobuf:"bytes,8,opt,name=data_risk_level,json=dataRiskLevel,proto3" json:"data_risk_level,omitempty"`
	// If it's been determined this column can be identified as a single type,
	// this will be set. Otherwise the column either has unidentifiable content
	// or mixed types.
	ColumnInfoType *InfoTypeSummary `protobuf:"bytes,9,opt,name=column_info_type,json=columnInfoType,proto3" json:"column_info_type,omitempty"`
	// Other types found within this column. List will be unordered.
	OtherMatches []*OtherInfoTypeSummary `protobuf:"bytes,10,rep,name=other_matches,json=otherMatches,proto3" json:"other_matches,omitempty"`
	// Approximate percentage of entries being null in the column.
	EstimatedNullPercentage NullPercentageLevel `protobuf:"varint,23,opt,name=estimated_null_percentage,json=estimatedNullPercentage,proto3,enum=google.privacy.dlp.v2.NullPercentageLevel" json:"estimated_null_percentage,omitempty"`
	// Approximate uniqueness of the column.
	EstimatedUniquenessScore UniquenessScoreLevel `protobuf:"varint,24,opt,name=estimated_uniqueness_score,json=estimatedUniquenessScore,proto3,enum=google.privacy.dlp.v2.UniquenessScoreLevel" json:"estimated_uniqueness_score,omitempty"`
	// The likelihood that this column contains free-form text.
	// A value close to 1 may indicate the column is likely to contain
	// free-form or natural language text.
	// Range in 0-1.
	FreeTextScore float64 `protobuf:"fixed64,13,opt,name=free_text_score,json=freeTextScore,proto3" json:"free_text_score,omitempty"`
	// The data type of a given column.
	ColumnType ColumnDataProfile_ColumnDataType `protobuf:"varint,14,opt,name=column_type,json=columnType,proto3,enum=google.privacy.dlp.v2.ColumnDataProfile_ColumnDataType" json:"column_type,omitempty"`
	// Indicates if a policy tag has been applied to the column.
	PolicyState ColumnDataProfile_ColumnPolicyState `protobuf:"varint,15,opt,name=policy_state,json=policyState,proto3,enum=google.privacy.dlp.v2.ColumnDataProfile_ColumnPolicyState" json:"policy_state,omitempty"`
}

func (x *ColumnDataProfile) Reset() {
	*x = ColumnDataProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[176]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnDataProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnDataProfile) ProtoMessage() {}

func (x *ColumnDataProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[176]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnDataProfile.ProtoReflect.Descriptor instead.
func (*ColumnDataProfile) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{176}
}

func (x *ColumnDataProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnDataProfile) GetProfileStatus() *ProfileStatus {
	if x != nil {
		return x.ProfileStatus
	}
	return nil
}

func (x *ColumnDataProfile) GetState() ColumnDataProfile_State {
	if x != nil {
		return x.State
	}
	return ColumnDataProfile_STATE_UNSPECIFIED
}

func (x *ColumnDataProfile) GetProfileLastGenerated() *timestamppb.Timestamp {
	if x != nil {
		return x.ProfileLastGenerated
	}
	return nil
}

func (x *ColumnDataProfile) GetTableDataProfile() string {
	if x != nil {
		return x.TableDataProfile
	}
	return ""
}

func (x *ColumnDataProfile) GetTableFullResource() string {
	if x != nil {
		return x.TableFullResource
	}
	return ""
}

func (x *ColumnDataProfile) GetDatasetProjectId() string {
	if x != nil {
		return x.DatasetProjectId
	}
	return ""
}

func (x *ColumnDataProfile) GetDatasetLocation() string {
	if x != nil {
		return x.DatasetLocation
	}
	return ""
}

func (x *ColumnDataProfile) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *ColumnDataProfile) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *ColumnDataProfile) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *ColumnDataProfile) GetSensitivityScore() *SensitivityScore {
	if x != nil {
		return x.SensitivityScore
	}
	return nil
}

func (x *ColumnDataProfile) GetDataRiskLevel() *DataRiskLevel {
	if x != nil {
		return x.DataRiskLevel
	}
	return nil
}

func (x *ColumnDataProfile) GetColumnInfoType() *InfoTypeSummary {
	if x != nil {
		return x.ColumnInfoType
	}
	return nil
}

func (x *ColumnDataProfile) GetOtherMatches() []*OtherInfoTypeSummary {
	if x != nil {
		return x.OtherMatches
	}
	return nil
}

func (x *ColumnDataProfile) GetEstimatedNullPercentage() NullPercentageLevel {
	if x != nil {
		return x.EstimatedNullPercentage
	}
	return NullPercentageLevel_NULL_PERCENTAGE_LEVEL_UNSPECIFIED
}

func (x *ColumnDataProfile) GetEstimatedUniquenessScore() UniquenessScoreLevel {
	if x != nil {
		return x.EstimatedUniquenessScore
	}
	return UniquenessScoreLevel_UNIQUENESS_SCORE_LEVEL_UNSPECIFIED
}

func (x *ColumnDataProfile) GetFreeTextScore() float64 {
	if x != nil {
		return x.FreeTextScore
	}
	return 0
}

func (x *ColumnDataProfile) GetColumnType() ColumnDataProfile_ColumnDataType {
	if x != nil {
		return x.ColumnType
	}
	return ColumnDataProfile_COLUMN_DATA_TYPE_UNSPECIFIED
}

func (x *ColumnDataProfile) GetPolicyState() ColumnDataProfile_ColumnPolicyState {
	if x != nil {
		return x.PolicyState
	}
	return ColumnDataProfile_COLUMN_POLICY_STATE_UNSPECIFIED
}

// Request to get a project data profile.
type GetProjectDataProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name, for example
	// `organizations/12345/locations/us/projectDataProfiles/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProjectDataProfileRequest) Reset() {
	*x = GetProjectDataProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[177]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProjectDataProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProjectDataProfileRequest) ProtoMessage() {}

func (x *GetProjectDataProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[177]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProjectDataProfileRequest.ProtoReflect.Descriptor instead.
func (*GetProjectDataProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{177}
}

func (x *GetProjectDataProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get a table data profile.
type GetTableDataProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name, for example
	// `organizations/12345/locations/us/tableDataProfiles/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTableDataProfileRequest) Reset() {
	*x = GetTableDataProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[178]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTableDataProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTableDataProfileRequest) ProtoMessage() {}

func (x *GetTableDataProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[178]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTableDataProfileRequest.ProtoReflect.Descriptor instead.
func (*GetTableDataProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{178}
}

func (x *GetTableDataProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get a column data profile.
type GetColumnDataProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name, for example
	// `organizations/12345/locations/us/columnDataProfiles/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetColumnDataProfileRequest) Reset() {
	*x = GetColumnDataProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[179]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetColumnDataProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetColumnDataProfileRequest) ProtoMessage() {}

func (x *GetColumnDataProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[179]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetColumnDataProfileRequest.ProtoReflect.Descriptor instead.
func (*GetColumnDataProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{179}
}

func (x *GetColumnDataProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A condition for determining whether a Pub/Sub should be triggered.
type DataProfilePubSubCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression.
	Expressions *DataProfilePubSubCondition_PubSubExpressions `protobuf:"bytes,1,opt,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *DataProfilePubSubCondition) Reset() {
	*x = DataProfilePubSubCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[180]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfilePubSubCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfilePubSubCondition) ProtoMessage() {}

func (x *DataProfilePubSubCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[180]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfilePubSubCondition.ProtoReflect.Descriptor instead.
func (*DataProfilePubSubCondition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{180}
}

func (x *DataProfilePubSubCondition) GetExpressions() *DataProfilePubSubCondition_PubSubExpressions {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// Pub/Sub topic message for a DataProfileAction.PubSubNotification event.
// To receive a message of protocol buffer schema type, convert the message data
// to an object of this proto class.
type DataProfilePubSubMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `DetailLevel` is `TABLE_PROFILE` this will be fully populated.
	// Otherwise, if `DetailLevel` is `RESOURCE_NAME`, then only `name` and
	// `full_resource` will be populated.
	Profile *TableDataProfile `protobuf:"bytes,1,opt,name=profile,proto3" json:"profile,omitempty"`
	// The event that caused the Pub/Sub message to be sent.
	Event DataProfileAction_EventType `protobuf:"varint,2,opt,name=event,proto3,enum=google.privacy.dlp.v2.DataProfileAction_EventType" json:"event,omitempty"`
}

func (x *DataProfilePubSubMessage) Reset() {
	*x = DataProfilePubSubMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[181]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfilePubSubMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfilePubSubMessage) ProtoMessage() {}

func (x *DataProfilePubSubMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[181]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfilePubSubMessage.ProtoReflect.Descriptor instead.
func (*DataProfilePubSubMessage) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{181}
}

func (x *DataProfilePubSubMessage) GetProfile() *TableDataProfile {
	if x != nil {
		return x.Profile
	}
	return nil
}

func (x *DataProfilePubSubMessage) GetEvent() DataProfileAction_EventType {
	if x != nil {
		return x.Event
	}
	return DataProfileAction_EVENT_TYPE_UNSPECIFIED
}

// Message used to identify the type of resource being profiled.
type DataSourceType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An identifying string to the type of resource being profiled.
	// Current values: google/bigquery/table, google/project
	DataSource string `protobuf:"bytes,1,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
}

func (x *DataSourceType) Reset() {
	*x = DataSourceType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[182]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSourceType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceType) ProtoMessage() {}

func (x *DataSourceType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[182]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceType.ProtoReflect.Descriptor instead.
func (*DataSourceType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{182}
}

func (x *DataSourceType) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

// Configuration for setting a minimum likelihood per infotype. Used to
// customize the minimum likelihood level for specific infotypes in the
// request. For example, use this if you want to lower the precision for
// PERSON_NAME without lowering the precision for the other infotypes in the
// request.
type InspectConfig_InfoTypeLikelihood struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of information the likelihood threshold applies to. Only one
	// likelihood per info_type should be provided. If InfoTypeLikelihood does
	// not have an info_type, the configuration fails.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Only returns findings equal to or above this threshold. This field is
	// required or else the configuration fails.
	MinLikelihood Likelihood `protobuf:"varint,2,opt,name=min_likelihood,json=minLikelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"min_likelihood,omitempty"`
}

func (x *InspectConfig_InfoTypeLikelihood) Reset() {
	*x = InspectConfig_InfoTypeLikelihood{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[183]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig_InfoTypeLikelihood) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig_InfoTypeLikelihood) ProtoMessage() {}

func (x *InspectConfig_InfoTypeLikelihood) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[183]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig_InfoTypeLikelihood.ProtoReflect.Descriptor instead.
func (*InspectConfig_InfoTypeLikelihood) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5, 0}
}

func (x *InspectConfig_InfoTypeLikelihood) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *InspectConfig_InfoTypeLikelihood) GetMinLikelihood() Likelihood {
	if x != nil {
		return x.MinLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Configuration to control the number of findings returned for inspection.
// This is not used for de-identification or data profiling.
//
// When redacting sensitive data from images, finding limits don't apply. They
// can cause unexpected or inconsistent results, where only some data is
// redacted. Don't include finding limits in
// [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
// requests. Otherwise, Cloud DLP returns an error.
type InspectConfig_FindingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max number of findings that are returned for each item scanned.
	//
	// When set within an
	// [InspectContentRequest][google.privacy.dlp.v2.InspectContentRequest],
	// this field is ignored.
	//
	// This value isn't a hard limit. If the number of findings for an item
	// reaches this limit, the inspection of that item ends gradually, not
	// abruptly. Therefore, the actual number of findings that Cloud DLP returns
	// for the item can be multiple times higher than this value.
	MaxFindingsPerItem int32 `protobuf:"varint,1,opt,name=max_findings_per_item,json=maxFindingsPerItem,proto3" json:"max_findings_per_item,omitempty"`
	// Max number of findings that are returned per request or job.
	//
	// If you set this field in an
	// [InspectContentRequest][google.privacy.dlp.v2.InspectContentRequest], the
	// resulting maximum value is the value that you set or 3,000, whichever is
	// lower.
	//
	// This value isn't a hard limit. If an inspection reaches this limit, the
	// inspection ends gradually, not abruptly. Therefore, the actual number of
	// findings that Cloud DLP returns can be multiple times higher than this
	// value.
	MaxFindingsPerRequest int32 `protobuf:"varint,2,opt,name=max_findings_per_request,json=maxFindingsPerRequest,proto3" json:"max_findings_per_request,omitempty"`
	// Configuration of findings limit given for specified infoTypes.
	MaxFindingsPerInfoType []*InspectConfig_FindingLimits_InfoTypeLimit `protobuf:"bytes,3,rep,name=max_findings_per_info_type,json=maxFindingsPerInfoType,proto3" json:"max_findings_per_info_type,omitempty"`
}

func (x *InspectConfig_FindingLimits) Reset() {
	*x = InspectConfig_FindingLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[184]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig_FindingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig_FindingLimits) ProtoMessage() {}

func (x *InspectConfig_FindingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[184]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig_FindingLimits.ProtoReflect.Descriptor instead.
func (*InspectConfig_FindingLimits) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5, 1}
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerItem() int32 {
	if x != nil {
		return x.MaxFindingsPerItem
	}
	return 0
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerRequest() int32 {
	if x != nil {
		return x.MaxFindingsPerRequest
	}
	return 0
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerInfoType() []*InspectConfig_FindingLimits_InfoTypeLimit {
	if x != nil {
		return x.MaxFindingsPerInfoType
	}
	return nil
}

// Max findings configuration per infoType, per content item or long
// running DlpJob.
type InspectConfig_FindingLimits_InfoTypeLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of information the findings limit applies to. Only one limit per
	// info_type should be provided. If InfoTypeLimit does not have an
	// info_type, the DLP API applies the limit against all info_types that
	// are found but not specified in another InfoTypeLimit.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Max findings limit for the given infoType.
	MaxFindings int32 `protobuf:"varint,2,opt,name=max_findings,json=maxFindings,proto3" json:"max_findings,omitempty"`
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) Reset() {
	*x = InspectConfig_FindingLimits_InfoTypeLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[185]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig_FindingLimits_InfoTypeLimit) ProtoMessage() {}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[185]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig_FindingLimits_InfoTypeLimit.ProtoReflect.Descriptor instead.
func (*InspectConfig_FindingLimits_InfoTypeLimit) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5, 1, 0}
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) GetMaxFindings() int32 {
	if x != nil {
		return x.MaxFindings
	}
	return 0
}

// Values of the row.
type Table_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual cells.
	Values []*Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Table_Row) Reset() {
	*x = Table_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[186]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table_Row) ProtoMessage() {}

func (x *Table_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[186]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table_Row.ProtoReflect.Descriptor instead.
func (*Table_Row) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Table_Row) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

// Configuration for determining how redaction of images should occur.
type RedactImageRequest_ImageRedactionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of information to redact from images.
	//
	// Types that are assignable to Target:
	//
	//	*RedactImageRequest_ImageRedactionConfig_InfoType
	//	*RedactImageRequest_ImageRedactionConfig_RedactAllText
	Target isRedactImageRequest_ImageRedactionConfig_Target `protobuf_oneof:"target"`
	// The color to use when redacting content from an image. If not specified,
	// the default is black.
	RedactionColor *Color `protobuf:"bytes,3,opt,name=redaction_color,json=redactionColor,proto3" json:"redaction_color,omitempty"`
}

func (x *RedactImageRequest_ImageRedactionConfig) Reset() {
	*x = RedactImageRequest_ImageRedactionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[188]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageRequest_ImageRedactionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageRequest_ImageRedactionConfig) ProtoMessage() {}

func (x *RedactImageRequest_ImageRedactionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[188]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageRequest_ImageRedactionConfig.ProtoReflect.Descriptor instead.
func (*RedactImageRequest_ImageRedactionConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{22, 0}
}

func (m *RedactImageRequest_ImageRedactionConfig) GetTarget() isRedactImageRequest_ImageRedactionConfig_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *RedactImageRequest_ImageRedactionConfig) GetInfoType() *InfoType {
	if x, ok := x.GetTarget().(*RedactImageRequest_ImageRedactionConfig_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *RedactImageRequest_ImageRedactionConfig) GetRedactAllText() bool {
	if x, ok := x.GetTarget().(*RedactImageRequest_ImageRedactionConfig_RedactAllText); ok {
		return x.RedactAllText
	}
	return false
}

func (x *RedactImageRequest_ImageRedactionConfig) GetRedactionColor() *Color {
	if x != nil {
		return x.RedactionColor
	}
	return nil
}

type isRedactImageRequest_ImageRedactionConfig_Target interface {
	isRedactImageRequest_ImageRedactionConfig_Target()
}

type RedactImageRequest_ImageRedactionConfig_InfoType struct {
	// Only one per info_type should be provided per request. If not
	// specified, and redact_all_text is false, the DLP API will redact all
	// text that it matches against all info_types that are found, but not
	// specified in another ImageRedactionConfig.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3,oneof"`
}

type RedactImageRequest_ImageRedactionConfig_RedactAllText struct {
	// If true, all text found in the image, regardless whether it matches an
	// info_type, is redacted. Only one should be provided.
	RedactAllText bool `protobuf:"varint,2,opt,name=redact_all_text,json=redactAllText,proto3,oneof"`
}

func (*RedactImageRequest_ImageRedactionConfig_InfoType) isRedactImageRequest_ImageRedactionConfig_Target() {
}

func (*RedactImageRequest_ImageRedactionConfig_RedactAllText) isRedactImageRequest_ImageRedactionConfig_Target() {
}

// Snapshot of the inspection configuration.
type InspectDataSourceDetails_RequestedOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If run with an InspectTemplate, a snapshot of its state at the time of
	// this run.
	SnapshotInspectTemplate *InspectTemplate `protobuf:"bytes,1,opt,name=snapshot_inspect_template,json=snapshotInspectTemplate,proto3" json:"snapshot_inspect_template,omitempty"`
	// Inspect config.
	JobConfig *InspectJobConfig `protobuf:"bytes,3,opt,name=job_config,json=jobConfig,proto3" json:"job_config,omitempty"`
}

func (x *InspectDataSourceDetails_RequestedOptions) Reset() {
	*x = InspectDataSourceDetails_RequestedOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[189]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails_RequestedOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails_RequestedOptions) ProtoMessage() {}

func (x *InspectDataSourceDetails_RequestedOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[189]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails_RequestedOptions.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails_RequestedOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{33, 0}
}

func (x *InspectDataSourceDetails_RequestedOptions) GetSnapshotInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.SnapshotInspectTemplate
	}
	return nil
}

func (x *InspectDataSourceDetails_RequestedOptions) GetJobConfig() *InspectJobConfig {
	if x != nil {
		return x.JobConfig
	}
	return nil
}

// All result fields mentioned below are updated while the job is processing.
type InspectDataSourceDetails_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size in bytes that were processed.
	ProcessedBytes int64 `protobuf:"varint,1,opt,name=processed_bytes,json=processedBytes,proto3" json:"processed_bytes,omitempty"`
	// Estimate of the number of bytes to process.
	TotalEstimatedBytes int64 `protobuf:"varint,2,opt,name=total_estimated_bytes,json=totalEstimatedBytes,proto3" json:"total_estimated_bytes,omitempty"`
	// Statistics of how many instances of each info type were found during
	// inspect job.
	InfoTypeStats []*InfoTypeStats `protobuf:"bytes,3,rep,name=info_type_stats,json=infoTypeStats,proto3" json:"info_type_stats,omitempty"`
	// Statistics related to the processing of hybrid inspect.
	HybridStats *HybridInspectStatistics `protobuf:"bytes,7,opt,name=hybrid_stats,json=hybridStats,proto3" json:"hybrid_stats,omitempty"`
}

func (x *InspectDataSourceDetails_Result) Reset() {
	*x = InspectDataSourceDetails_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[190]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails_Result) ProtoMessage() {}

func (x *InspectDataSourceDetails_Result) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[190]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails_Result.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails_Result) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{33, 1}
}

func (x *InspectDataSourceDetails_Result) GetProcessedBytes() int64 {
	if x != nil {
		return x.ProcessedBytes
	}
	return 0
}

func (x *InspectDataSourceDetails_Result) GetTotalEstimatedBytes() int64 {
	if x != nil {
		return x.TotalEstimatedBytes
	}
	return 0
}

func (x *InspectDataSourceDetails_Result) GetInfoTypeStats() []*InfoTypeStats {
	if x != nil {
		return x.InfoTypeStats
	}
	return nil
}

func (x *InspectDataSourceDetails_Result) GetHybridStats() *HybridInspectStatistics {
	if x != nil {
		return x.HybridStats
	}
	return nil
}

// De-identification options.
type DeidentifyDataSourceDetails_RequestedDeidentifyOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Snapshot of the state of the `DeidentifyTemplate` from the
	// [Deidentify][google.privacy.dlp.v2.Action.Deidentify] action at the time
	// this job was run.
	SnapshotDeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,1,opt,name=snapshot_deidentify_template,json=snapshotDeidentifyTemplate,proto3" json:"snapshot_deidentify_template,omitempty"`
	// Snapshot of the state of the structured `DeidentifyTemplate` from the
	// `Deidentify` action at the time this job was run.
	SnapshotStructuredDeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=snapshot_structured_deidentify_template,json=snapshotStructuredDeidentifyTemplate,proto3" json:"snapshot_structured_deidentify_template,omitempty"`
	// Snapshot of the state of the image transformation `DeidentifyTemplate`
	// from the `Deidentify` action at the time this job was run.
	SnapshotImageRedactTemplate *DeidentifyTemplate `protobuf:"bytes,3,opt,name=snapshot_image_redact_template,json=snapshotImageRedactTemplate,proto3" json:"snapshot_image_redact_template,omitempty"`
}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) Reset() {
	*x = DeidentifyDataSourceDetails_RequestedDeidentifyOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[191]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyDataSourceDetails_RequestedDeidentifyOptions) ProtoMessage() {}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[191]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyDataSourceDetails_RequestedDeidentifyOptions.ProtoReflect.Descriptor instead.
func (*DeidentifyDataSourceDetails_RequestedDeidentifyOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{38, 0}
}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) GetSnapshotDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.SnapshotDeidentifyTemplate
	}
	return nil
}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) GetSnapshotStructuredDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.SnapshotStructuredDeidentifyTemplate
	}
	return nil
}

func (x *DeidentifyDataSourceDetails_RequestedDeidentifyOptions) GetSnapshotImageRedactTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.SnapshotImageRedactTemplate
	}
	return nil
}

// A quasi-identifier column has a custom_tag, used to know which column
// in the data corresponds to which column in the statistical model.
type StatisticalTable_QuasiIdentifierField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,2,opt,name=custom_tag,json=customTag,proto3" json:"custom_tag,omitempty"`
}

func (x *StatisticalTable_QuasiIdentifierField) Reset() {
	*x = StatisticalTable_QuasiIdentifierField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[192]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatisticalTable_QuasiIdentifierField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticalTable_QuasiIdentifierField) ProtoMessage() {}

func (x *StatisticalTable_QuasiIdentifierField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[192]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticalTable_QuasiIdentifierField.ProtoReflect.Descriptor instead.
func (*StatisticalTable_QuasiIdentifierField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{46, 0}
}

func (x *StatisticalTable_QuasiIdentifierField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *StatisticalTable_QuasiIdentifierField) GetCustomTag() string {
	if x != nil {
		return x.CustomTag
	}
	return ""
}

// Compute numerical stats over an individual column, including
// min, max, and quantiles.
type PrivacyMetric_NumericalStatsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field to compute numerical stats on. Supported types are
	// integer, float, date, datetime, timestamp, time.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *PrivacyMetric_NumericalStatsConfig) Reset() {
	*x = PrivacyMetric_NumericalStatsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[193]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_NumericalStatsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_NumericalStatsConfig) ProtoMessage() {}

func (x *PrivacyMetric_NumericalStatsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[193]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_NumericalStatsConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_NumericalStatsConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 0}
}

func (x *PrivacyMetric_NumericalStatsConfig) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// Compute numerical stats over an individual column, including
// number of distinct values and value count distribution.
type PrivacyMetric_CategoricalStatsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field to compute categorical stats on. All column types are
	// supported except for arrays and structs. However, it may be more
	// informative to use NumericalStats when the field type is supported,
	// depending on the data.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *PrivacyMetric_CategoricalStatsConfig) Reset() {
	*x = PrivacyMetric_CategoricalStatsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[194]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_CategoricalStatsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_CategoricalStatsConfig) ProtoMessage() {}

func (x *PrivacyMetric_CategoricalStatsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[194]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_CategoricalStatsConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_CategoricalStatsConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 1}
}

func (x *PrivacyMetric_CategoricalStatsConfig) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// k-anonymity metric, used for analysis of reidentification risk.
type PrivacyMetric_KAnonymityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of fields to compute k-anonymity over. When multiple fields are
	// specified, they are considered a single composite key. Structs and
	// repeated data types are not supported; however, nested fields are
	// supported so long as they are not structs themselves or nested within
	// a repeated field.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Message indicating that multiple rows might be associated to a
	// single individual. If the same entity_id is associated to multiple
	// quasi-identifier tuples over distinct rows, we consider the entire
	// collection of tuples as the composite quasi-identifier. This collection
	// is a multiset: the order in which the different tuples appear in the
	// dataset is ignored, but their frequency is taken into account.
	//
	// Important note: a maximum of 1000 rows can be associated to a single
	// entity ID. If more rows are associated with the same entity ID, some
	// might be ignored.
	EntityId *EntityId `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
}

func (x *PrivacyMetric_KAnonymityConfig) Reset() {
	*x = PrivacyMetric_KAnonymityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[195]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KAnonymityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KAnonymityConfig) ProtoMessage() {}

func (x *PrivacyMetric_KAnonymityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[195]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KAnonymityConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KAnonymityConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 2}
}

func (x *PrivacyMetric_KAnonymityConfig) GetQuasiIds() []*FieldId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KAnonymityConfig) GetEntityId() *EntityId {
	if x != nil {
		return x.EntityId
	}
	return nil
}

// l-diversity metric, used for analysis of reidentification risk.
type PrivacyMetric_LDiversityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of quasi-identifiers indicating how equivalence classes are
	// defined for the l-diversity computation. When multiple fields are
	// specified, they are considered a single composite key.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Sensitive field for computing the l-value.
	SensitiveAttribute *FieldId `protobuf:"bytes,2,opt,name=sensitive_attribute,json=sensitiveAttribute,proto3" json:"sensitive_attribute,omitempty"`
}

func (x *PrivacyMetric_LDiversityConfig) Reset() {
	*x = PrivacyMetric_LDiversityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[196]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_LDiversityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_LDiversityConfig) ProtoMessage() {}

func (x *PrivacyMetric_LDiversityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[196]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_LDiversityConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_LDiversityConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 3}
}

func (x *PrivacyMetric_LDiversityConfig) GetQuasiIds() []*FieldId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_LDiversityConfig) GetSensitiveAttribute() *FieldId {
	if x != nil {
		return x.SensitiveAttribute
	}
	return nil
}

// Reidentifiability metric. This corresponds to a risk model similar to what
// is called "journalist risk" in the literature, except the attack dataset is
// statistically modeled instead of being perfectly known. This can be done
// using publicly available data (like the US Census), or using a custom
// statistical model (indicated as one or several BigQuery tables), or by
// extrapolating from the distribution of values in the input dataset.
type PrivacyMetric_KMapEstimationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fields considered to be quasi-identifiers. No two columns can
	// have the same tag.
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_TaggedField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// ISO 3166-1 alpha-2 region code to use in the statistical modeling.
	// Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Several auxiliary tables can be used in the analysis. Each custom_tag
	// used to tag a quasi-identifiers column must appear in exactly one column
	// of one auxiliary table.
	AuxiliaryTables []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable `protobuf:"bytes,3,rep,name=auxiliary_tables,json=auxiliaryTables,proto3" json:"auxiliary_tables,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[197]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[197]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 4}
}

func (x *PrivacyMetric_KMapEstimationConfig) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_TaggedField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *PrivacyMetric_KMapEstimationConfig) GetAuxiliaryTables() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable {
	if x != nil {
		return x.AuxiliaryTables
	}
	return nil
}

// δ-presence metric, used to estimate how likely it is for an attacker to
// figure out that one given individual appears in a de-identified dataset.
// Similarly to the k-map metric, we cannot compute δ-presence exactly without
// knowing the attack dataset, so we use a statistical model instead.
type PrivacyMetric_DeltaPresenceEstimationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fields considered to be quasi-identifiers. No two fields can
	// have the same tag.
	QuasiIds []*QuasiId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// ISO 3166-1 alpha-2 region code to use in the statistical modeling.
	// Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Several auxiliary tables can be used in the analysis. Each custom_tag
	// used to tag a quasi-identifiers field must appear in exactly one
	// field of one auxiliary table.
	AuxiliaryTables []*StatisticalTable `protobuf:"bytes,3,rep,name=auxiliary_tables,json=auxiliaryTables,proto3" json:"auxiliary_tables,omitempty"`
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) Reset() {
	*x = PrivacyMetric_DeltaPresenceEstimationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[198]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_DeltaPresenceEstimationConfig) ProtoMessage() {}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[198]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_DeltaPresenceEstimationConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_DeltaPresenceEstimationConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 5}
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetQuasiIds() []*QuasiId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetAuxiliaryTables() []*StatisticalTable {
	if x != nil {
		return x.AuxiliaryTables
	}
	return nil
}

// A column with a semantic tag attached.
type PrivacyMetric_KMapEstimationConfig_TaggedField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Semantic tag that identifies what a column contains, to determine which
	// statistical model to use to estimate the reidentifiability of each
	// value. [required]
	//
	// Types that are assignable to Tag:
	//
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred
	Tag isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag `protobuf_oneof:"tag"`
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_TaggedField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[199]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[199]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_TaggedField.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_TaggedField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 4, 0}
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetTag() isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInfoType() *InfoType {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetCustomTag() string {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag); ok {
		return x.CustomTag
	}
	return ""
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInferred() *emptypb.Empty {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred); ok {
		return x.Inferred
	}
	return nil
}

type isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag interface {
	isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag()
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType struct {
	// A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We
	// currently support US ZIP codes, region codes, ages and genders.
	// To programmatically obtain the list of supported InfoTypes, use
	// ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag struct {
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,3,opt,name=custom_tag,json=customTag,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred struct {
	// If no semantic tag is indicated, we infer the statistical model from
	// the distribution of values in the input data
	Inferred *emptypb.Empty `protobuf:"bytes,4,opt,name=inferred,proto3,oneof"`
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

// An auxiliary table contains statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple.
// If a tuple is present in the data but not in the auxiliary table, the
// corresponding relative frequency is assumed to be zero (and thus, the
// tuple is highly reidentifiable).
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Auxiliary table location.
	Table *BigQueryTable `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// Required. Quasi-identifier columns.
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Required. The relative frequency column must contain a floating-point
	// number between 0 and 1 (inclusive). Null values are assumed to be zero.
	RelativeFrequency *FieldId `protobuf:"bytes,2,opt,name=relative_frequency,json=relativeFrequency,proto3" json:"relative_frequency,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[200]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[200]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_AuxiliaryTable.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 4, 1}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetTable() *BigQueryTable {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetRelativeFrequency() *FieldId {
	if x != nil {
		return x.RelativeFrequency
	}
	return nil
}

// A quasi-identifier column has a custom_tag, used to know which column
// in the data corresponds to which column in the statistical model.
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A auxiliary field.
	CustomTag string `protobuf:"bytes,2,opt,name=custom_tag,json=customTag,proto3" json:"custom_tag,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[201]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[201]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 4, 1, 0}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetCustomTag() string {
	if x != nil {
		return x.CustomTag
	}
	return ""
}

// Result of the numerical stats computation.
type AnalyzeDataSourceRiskDetails_NumericalStatsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum value appearing in the column.
	MinValue *Value `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Maximum value appearing in the column.
	MaxValue *Value `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// List of 99 values that partition the set of field values into 100 equal
	// sized buckets.
	QuantileValues []*Value `protobuf:"bytes,4,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_NumericalStatsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[202]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[202]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_NumericalStatsResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 0}
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMinValue() *Value {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMaxValue() *Value {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetQuantileValues() []*Value {
	if x != nil {
		return x.QuantileValues
	}
	return nil
}

// Result of the categorical stats computation.
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of value frequencies in the column.
	ValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket `protobuf:"bytes,5,rep,name=value_frequency_histogram_buckets,json=valueFrequencyHistogramBuckets,proto3" json:"value_frequency_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_CategoricalStatsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[203]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[203]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_CategoricalStatsResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 1}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) GetValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket {
	if x != nil {
		return x.ValueFrequencyHistogramBuckets
	}
	return nil
}

// Result of the k-anonymity computation.
type AnalyzeDataSourceRiskDetails_KAnonymityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of k-anonymity equivalence classes.
	EquivalenceClassHistogramBuckets []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket `protobuf:"bytes,5,rep,name=equivalence_class_histogram_buckets,json=equivalenceClassHistogramBuckets,proto3" json:"equivalence_class_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[204]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[204]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 2}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) GetEquivalenceClassHistogramBuckets() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket {
	if x != nil {
		return x.EquivalenceClassHistogramBuckets
	}
	return nil
}

// Result of the l-diversity computation.
type AnalyzeDataSourceRiskDetails_LDiversityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of l-diversity equivalence class sensitive value frequencies.
	SensitiveValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket `protobuf:"bytes,5,rep,name=sensitive_value_frequency_histogram_buckets,json=sensitiveValueFrequencyHistogramBuckets,proto3" json:"sensitive_value_frequency_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[205]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[205]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 3}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) GetSensitiveValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket {
	if x != nil {
		return x.SensitiveValueFrequencyHistogramBuckets
	}
	return nil
}

// Result of the reidentifiability analysis. Note that these results are an
// estimation, not exact values.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intervals [min_anonymity, max_anonymity] do not overlap. If a value
	// doesn't correspond to any such interval, the associated frequency is
	// zero. For example, the following records:
	//
	//	{min_anonymity: 1, max_anonymity: 1, frequency: 17}
	//	{min_anonymity: 2, max_anonymity: 3, frequency: 42}
	//	{min_anonymity: 5, max_anonymity: 10, frequency: 99}
	//
	// mean that there are no record with an estimated anonymity of 4, 5, or
	// larger than 10.
	KMapEstimationHistogram []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket `protobuf:"bytes,1,rep,name=k_map_estimation_histogram,json=kMapEstimationHistogram,proto3" json:"k_map_estimation_histogram,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[206]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[206]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 4}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) GetKMapEstimationHistogram() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket {
	if x != nil {
		return x.KMapEstimationHistogram
	}
	return nil
}

// Result of the δ-presence computation. Note that these results are an
// estimation, not exact values.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intervals [min_probability, max_probability) do not overlap. If a
	// value doesn't correspond to any such interval, the associated frequency
	// is zero. For example, the following records:
	//
	//	{min_probability: 0, max_probability: 0.1, frequency: 17}
	//	{min_probability: 0.2, max_probability: 0.3, frequency: 42}
	//	{min_probability: 0.3, max_probability: 0.4, frequency: 99}
	//
	// mean that there are no record with an estimated probability in [0.1, 0.2)
	// nor larger or equal to 0.4.
	DeltaPresenceEstimationHistogram []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket `protobuf:"bytes,1,rep,name=delta_presence_estimation_histogram,json=deltaPresenceEstimationHistogram,proto3" json:"delta_presence_estimation_histogram,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[207]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[207]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 5}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) GetDeltaPresenceEstimationHistogram() []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket {
	if x != nil {
		return x.DeltaPresenceEstimationHistogram
	}
	return nil
}

// Risk analysis options.
type AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job config for the risk job.
	JobConfig *RiskAnalysisJobConfig `protobuf:"bytes,1,opt,name=job_config,json=jobConfig,proto3" json:"job_config,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) Reset() {
	*x = AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[208]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[208]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 6}
}

func (x *AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions) GetJobConfig() *RiskAnalysisJobConfig {
	if x != nil {
		return x.JobConfig
	}
	return nil
}

// Histogram of value frequencies in the column.
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the value frequency of the values in this bucket.
	ValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=value_frequency_lower_bound,json=valueFrequencyLowerBound,proto3" json:"value_frequency_lower_bound,omitempty"`
	// Upper bound on the value frequency of the values in this bucket.
	ValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=value_frequency_upper_bound,json=valueFrequencyUpperBound,proto3" json:"value_frequency_upper_bound,omitempty"`
	// Total number of values in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of value frequencies in this bucket. The total number of
	// values returned per bucket is capped at 20.
	BucketValues []*ValueFrequency `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct values in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[209]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[209]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 1, 0}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyLowerBound() int64 {
	if x != nil {
		return x.ValueFrequencyLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyUpperBound() int64 {
	if x != nil {
		return x.ValueFrequencyUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketValues() []*ValueFrequency {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// The set of columns' values that share the same ldiversity value
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of values defining the equivalence class. One value per
	// quasi-identifier column in the original KAnonymity metric message.
	// The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// Size of the equivalence class, for example number of rows with the
	// above set of values.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize,proto3" json:"equivalence_class_size,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[210]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[210]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 2, 0}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if x != nil {
		return x.EquivalenceClassSize
	}
	return 0
}

// Histogram of k-anonymity equivalence classes.
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeLowerBound int64 `protobuf:"varint,1,opt,name=equivalence_class_size_lower_bound,json=equivalenceClassSizeLowerBound,proto3" json:"equivalence_class_size_lower_bound,omitempty"`
	// Upper bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeUpperBound int64 `protobuf:"varint,2,opt,name=equivalence_class_size_upper_bound,json=equivalenceClassSizeUpperBound,proto3" json:"equivalence_class_size_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct equivalence classes in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[211]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[211]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 2, 1}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeLowerBound() int64 {
	if x != nil {
		return x.EquivalenceClassSizeLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeUpperBound() int64 {
	if x != nil {
		return x.EquivalenceClassSizeUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// The set of columns' values that share the same ldiversity value.
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quasi-identifier values defining the k-anonymity equivalence
	// class. The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// Size of the k-anonymity equivalence class.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize,proto3" json:"equivalence_class_size,omitempty"`
	// Number of distinct sensitive values in this equivalence class.
	NumDistinctSensitiveValues int64 `protobuf:"varint,3,opt,name=num_distinct_sensitive_values,json=numDistinctSensitiveValues,proto3" json:"num_distinct_sensitive_values,omitempty"`
	// Estimated frequencies of top sensitive values.
	TopSensitiveValues []*ValueFrequency `protobuf:"bytes,4,rep,name=top_sensitive_values,json=topSensitiveValues,proto3" json:"top_sensitive_values,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[212]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[212]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 3, 0}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if x != nil {
		return x.EquivalenceClassSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetNumDistinctSensitiveValues() int64 {
	if x != nil {
		return x.NumDistinctSensitiveValues
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetTopSensitiveValues() []*ValueFrequency {
	if x != nil {
		return x.TopSensitiveValues
	}
	return nil
}

// Histogram of l-diversity equivalence class sensitive value frequencies.
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=sensitive_value_frequency_lower_bound,json=sensitiveValueFrequencyLowerBound,proto3" json:"sensitive_value_frequency_lower_bound,omitempty"`
	// Upper bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=sensitive_value_frequency_upper_bound,json=sensitiveValueFrequencyUpperBound,proto3" json:"sensitive_value_frequency_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct equivalence classes in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[213]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[213]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 3, 1}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyLowerBound() int64 {
	if x != nil {
		return x.SensitiveValueFrequencyLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyUpperBound() int64 {
	if x != nil {
		return x.SensitiveValueFrequencyUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// A tuple of values for the quasi-identifier columns.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quasi-identifier values.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// The estimated anonymity for these quasi-identifier values.
	EstimatedAnonymity int64 `protobuf:"varint,2,opt,name=estimated_anonymity,json=estimatedAnonymity,proto3" json:"estimated_anonymity,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[214]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[214]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 4, 0}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetEstimatedAnonymity() int64 {
	if x != nil {
		return x.EstimatedAnonymity
	}
	return 0
}

// A KMapEstimationHistogramBucket message with the following values:
//
//	min_anonymity: 3
//	max_anonymity: 5
//	frequency: 42
//
// means that there are 42 records whose quasi-identifier values correspond
// to 3, 4 or 5 people in the overlying population. An important particular
// case is when min_anonymity = max_anonymity = 1: the frequency field then
// corresponds to the number of uniquely identifiable records.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always positive.
	MinAnonymity int64 `protobuf:"varint,1,opt,name=min_anonymity,json=minAnonymity,proto3" json:"min_anonymity,omitempty"`
	// Always greater than or equal to min_anonymity.
	MaxAnonymity int64 `protobuf:"varint,2,opt,name=max_anonymity,json=maxAnonymity,proto3" json:"max_anonymity,omitempty"`
	// Number of records within these anonymity bounds.
	BucketSize int64 `protobuf:"varint,5,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of quasi-identifier tuple values in this bucket. The total
	// number of classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues `protobuf:"bytes,6,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct quasi-identifier tuple values in this bucket.
	BucketValueCount int64 `protobuf:"varint,7,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[215]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[215]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 4, 1}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMinAnonymity() int64 {
	if x != nil {
		return x.MinAnonymity
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMaxAnonymity() int64 {
	if x != nil {
		return x.MaxAnonymity
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// A tuple of values for the quasi-identifier columns.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quasi-identifier values.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// The estimated probability that a given individual sharing these
	// quasi-identifier values is in the dataset. This value, typically
	// called δ, is the ratio between the number of records in the dataset
	// with these quasi-identifier values, and the total number of individuals
	// (inside *and* outside the dataset) with these quasi-identifier values.
	// For example, if there are 15 individuals in the dataset who share the
	// same quasi-identifier values, and an estimated 100 people in the entire
	// population with these values, then δ is 0.15.
	EstimatedProbability float64 `protobuf:"fixed64,2,opt,name=estimated_probability,json=estimatedProbability,proto3" json:"estimated_probability,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[216]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[216]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 5, 0}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) GetEstimatedProbability() float64 {
	if x != nil {
		return x.EstimatedProbability
	}
	return 0
}

// A DeltaPresenceEstimationHistogramBucket message with the following
// values:
//
//	min_probability: 0.1
//	max_probability: 0.2
//	frequency: 42
//
// means that there are 42 records for which δ is in [0.1, 0.2). An
// important particular case is when min_probability = max_probability = 1:
// then, every individual who shares this quasi-identifier combination is in
// the dataset.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Between 0 and 1.
	MinProbability float64 `protobuf:"fixed64,1,opt,name=min_probability,json=minProbability,proto3" json:"min_probability,omitempty"`
	// Always greater than or equal to min_probability.
	MaxProbability float64 `protobuf:"fixed64,2,opt,name=max_probability,json=maxProbability,proto3" json:"max_probability,omitempty"`
	// Number of records within these probability bounds.
	BucketSize int64 `protobuf:"varint,5,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of quasi-identifier tuple values in this bucket. The total
	// number of classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues `protobuf:"bytes,6,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct quasi-identifier tuple values in this bucket.
	BucketValueCount int64 `protobuf:"varint,7,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[217]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[217]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48, 5, 1}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetMinProbability() float64 {
	if x != nil {
		return x.MinProbability
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetMaxProbability() float64 {
	if x != nil {
		return x.MaxProbability
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// Time zone of the date time object.
type DateTime_TimeZone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set only if the offset can be determined. Positive for time ahead of UTC.
	// E.g. For "UTC-9", this value is -540.
	OffsetMinutes int32 `protobuf:"varint,1,opt,name=offset_minutes,json=offsetMinutes,proto3" json:"offset_minutes,omitempty"`
}

func (x *DateTime_TimeZone) Reset() {
	*x = DateTime_TimeZone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[218]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTime_TimeZone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTime_TimeZone) ProtoMessage() {}

func (x *DateTime_TimeZone) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[218]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTime_TimeZone.ProtoReflect.Descriptor instead.
func (*DateTime_TimeZone) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{52, 0}
}

func (x *DateTime_TimeZone) GetOffsetMinutes() int32 {
	if x != nil {
		return x.OffsetMinutes
	}
	return 0
}

// Configuration for determining how redaction of images should occur.
type ImageTransformations_ImageTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Part of the image to transform.
	//
	// Types that are assignable to Target:
	//
	//	*ImageTransformations_ImageTransformation_SelectedInfoTypes_
	//	*ImageTransformations_ImageTransformation_AllInfoTypes_
	//	*ImageTransformations_ImageTransformation_AllText_
	Target isImageTransformations_ImageTransformation_Target `protobuf_oneof:"target"`
	// The color to use when redacting content from an image. If not
	// specified, the default is black.
	RedactionColor *Color `protobuf:"bytes,3,opt,name=redaction_color,json=redactionColor,proto3" json:"redaction_color,omitempty"`
}

func (x *ImageTransformations_ImageTransformation) Reset() {
	*x = ImageTransformations_ImageTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[219]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageTransformations_ImageTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageTransformations_ImageTransformation) ProtoMessage() {}

func (x *ImageTransformations_ImageTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[219]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageTransformations_ImageTransformation.ProtoReflect.Descriptor instead.
func (*ImageTransformations_ImageTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54, 0}
}

func (m *ImageTransformations_ImageTransformation) GetTarget() isImageTransformations_ImageTransformation_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *ImageTransformations_ImageTransformation) GetSelectedInfoTypes() *ImageTransformations_ImageTransformation_SelectedInfoTypes {
	if x, ok := x.GetTarget().(*ImageTransformations_ImageTransformation_SelectedInfoTypes_); ok {
		return x.SelectedInfoTypes
	}
	return nil
}

func (x *ImageTransformations_ImageTransformation) GetAllInfoTypes() *ImageTransformations_ImageTransformation_AllInfoTypes {
	if x, ok := x.GetTarget().(*ImageTransformations_ImageTransformation_AllInfoTypes_); ok {
		return x.AllInfoTypes
	}
	return nil
}

func (x *ImageTransformations_ImageTransformation) GetAllText() *ImageTransformations_ImageTransformation_AllText {
	if x, ok := x.GetTarget().(*ImageTransformations_ImageTransformation_AllText_); ok {
		return x.AllText
	}
	return nil
}

func (x *ImageTransformations_ImageTransformation) GetRedactionColor() *Color {
	if x != nil {
		return x.RedactionColor
	}
	return nil
}

type isImageTransformations_ImageTransformation_Target interface {
	isImageTransformations_ImageTransformation_Target()
}

type ImageTransformations_ImageTransformation_SelectedInfoTypes_ struct {
	// Apply transformation to the selected info_types.
	SelectedInfoTypes *ImageTransformations_ImageTransformation_SelectedInfoTypes `protobuf:"bytes,4,opt,name=selected_info_types,json=selectedInfoTypes,proto3,oneof"`
}

type ImageTransformations_ImageTransformation_AllInfoTypes_ struct {
	// Apply transformation to all findings not specified in other
	// ImageTransformation's selected_info_types. Only one instance is allowed
	// within the ImageTransformations message.
	AllInfoTypes *ImageTransformations_ImageTransformation_AllInfoTypes `protobuf:"bytes,5,opt,name=all_info_types,json=allInfoTypes,proto3,oneof"`
}

type ImageTransformations_ImageTransformation_AllText_ struct {
	// Apply transformation to all text that doesn't match an infoType. Only
	// one instance is allowed within the ImageTransformations message.
	AllText *ImageTransformations_ImageTransformation_AllText `protobuf:"bytes,6,opt,name=all_text,json=allText,proto3,oneof"`
}

func (*ImageTransformations_ImageTransformation_SelectedInfoTypes_) isImageTransformations_ImageTransformation_Target() {
}

func (*ImageTransformations_ImageTransformation_AllInfoTypes_) isImageTransformations_ImageTransformation_Target() {
}

func (*ImageTransformations_ImageTransformation_AllText_) isImageTransformations_ImageTransformation_Target() {
}

// Apply transformation to the selected info_types.
type ImageTransformations_ImageTransformation_SelectedInfoTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. InfoTypes to apply the transformation to. Required. Provided
	// InfoType must be unique within the ImageTransformations message.
	InfoTypes []*InfoType `protobuf:"bytes,5,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *ImageTransformations_ImageTransformation_SelectedInfoTypes) Reset() {
	*x = ImageTransformations_ImageTransformation_SelectedInfoTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[220]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageTransformations_ImageTransformation_SelectedInfoTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageTransformations_ImageTransformation_SelectedInfoTypes) ProtoMessage() {}

func (x *ImageTransformations_ImageTransformation_SelectedInfoTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[220]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageTransformations_ImageTransformation_SelectedInfoTypes.ProtoReflect.Descriptor instead.
func (*ImageTransformations_ImageTransformation_SelectedInfoTypes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54, 0, 0}
}

func (x *ImageTransformations_ImageTransformation_SelectedInfoTypes) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// Apply transformation to all findings.
type ImageTransformations_ImageTransformation_AllInfoTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImageTransformations_ImageTransformation_AllInfoTypes) Reset() {
	*x = ImageTransformations_ImageTransformation_AllInfoTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[221]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageTransformations_ImageTransformation_AllInfoTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageTransformations_ImageTransformation_AllInfoTypes) ProtoMessage() {}

func (x *ImageTransformations_ImageTransformation_AllInfoTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[221]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageTransformations_ImageTransformation_AllInfoTypes.ProtoReflect.Descriptor instead.
func (*ImageTransformations_ImageTransformation_AllInfoTypes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54, 0, 1}
}

// Apply to all text.
type ImageTransformations_ImageTransformation_AllText struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImageTransformations_ImageTransformation_AllText) Reset() {
	*x = ImageTransformations_ImageTransformation_AllText{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[222]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageTransformations_ImageTransformation_AllText) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageTransformations_ImageTransformation_AllText) ProtoMessage() {}

func (x *ImageTransformations_ImageTransformation_AllText) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[222]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageTransformations_ImageTransformation_AllText.ProtoReflect.Descriptor instead.
func (*ImageTransformations_ImageTransformation_AllText) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54, 0, 2}
}

// Throw an error and fail the request when a transformation error occurs.
type TransformationErrorHandling_ThrowError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransformationErrorHandling_ThrowError) Reset() {
	*x = TransformationErrorHandling_ThrowError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[223]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling_ThrowError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling_ThrowError) ProtoMessage() {}

func (x *TransformationErrorHandling_ThrowError) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[223]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling_ThrowError.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling_ThrowError) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{55, 0}
}

// Skips the data without modifying it if the requested transformation would
// cause an error. For example, if a `DateShift` transformation were applied
// an an IP address, this mode would leave the IP address unchanged in the
// response.
type TransformationErrorHandling_LeaveUntransformed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransformationErrorHandling_LeaveUntransformed) Reset() {
	*x = TransformationErrorHandling_LeaveUntransformed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[224]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling_LeaveUntransformed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling_LeaveUntransformed) ProtoMessage() {}

func (x *TransformationErrorHandling_LeaveUntransformed) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[224]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling_LeaveUntransformed.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling_LeaveUntransformed) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{55, 1}
}

// Bucket is represented as a range, along with replacement values.
type BucketingConfig_Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound of the range, inclusive. Type should be the same as max if
	// used.
	Min *Value `protobuf:"bytes,1,opt,name=min,proto3" json:"min,omitempty"`
	// Upper bound of the range, exclusive; type must match min.
	Max *Value `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
	// Required. Replacement value for this bucket.
	ReplacementValue *Value `protobuf:"bytes,3,opt,name=replacement_value,json=replacementValue,proto3" json:"replacement_value,omitempty"`
}

func (x *BucketingConfig_Bucket) Reset() {
	*x = BucketingConfig_Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[225]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketingConfig_Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketingConfig_Bucket) ProtoMessage() {}

func (x *BucketingConfig_Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[225]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketingConfig_Bucket.ProtoReflect.Descriptor instead.
func (*BucketingConfig_Bucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{67, 0}
}

func (x *BucketingConfig_Bucket) GetMin() *Value {
	if x != nil {
		return x.Min
	}
	return nil
}

func (x *BucketingConfig_Bucket) GetMax() *Value {
	if x != nil {
		return x.Max
	}
	return nil
}

func (x *BucketingConfig_Bucket) GetReplacementValue() *Value {
	if x != nil {
		return x.ReplacementValue
	}
	return nil
}

// A transformation to apply to text that is identified as a specific
// info_type.
type InfoTypeTransformations_InfoTypeTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// InfoTypes to apply the transformation to. An empty list will cause
	// this transformation to apply to all findings that correspond to
	// infoTypes that were requested in `InspectConfig`.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Required. Primitive transformation to apply to the infoType.
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,2,opt,name=primitive_transformation,json=primitiveTransformation,proto3" json:"primitive_transformation,omitempty"`
}

func (x *InfoTypeTransformations_InfoTypeTransformation) Reset() {
	*x = InfoTypeTransformations_InfoTypeTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[226]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeTransformations_InfoTypeTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeTransformations_InfoTypeTransformation) ProtoMessage() {}

func (x *InfoTypeTransformations_InfoTypeTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[226]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeTransformations_InfoTypeTransformation.ProtoReflect.Descriptor instead.
func (*InfoTypeTransformations_InfoTypeTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{74, 0}
}

func (x *InfoTypeTransformations_InfoTypeTransformation) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InfoTypeTransformations_InfoTypeTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if x != nil {
		return x.PrimitiveTransformation
	}
	return nil
}

// The field type of `value` and `field` do not need to match to be
// considered equal, but not all comparisons are possible.
// EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
// but all other comparisons are invalid with incompatible types.
// A `value` of type:
//
// - `string` can be compared against all other types
// - `boolean` can only be compared against other booleans
// - `integer` can be compared against doubles or a string if the string value
// can be parsed as an integer.
// - `double` can be compared against integers or a string if the string can
// be parsed as a double.
// - `Timestamp` can be compared against strings in RFC 3339 date string
// format.
// - `TimeOfDay` can be compared against timestamps and strings in the format
// of 'HH:mm:ss'.
//
// If we fail to compare do to type mismatch, a warning will be given and
// the condition will evaluate to false.
type RecordCondition_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field within the record this condition is evaluated against.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Required. Operator used to compare the field or infoType to the value.
	Operator RelationalOperator `protobuf:"varint,3,opt,name=operator,proto3,enum=google.privacy.dlp.v2.RelationalOperator" json:"operator,omitempty"`
	// Value to compare against. [Mandatory, except for `EXISTS` tests.]
	Value *Value `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RecordCondition_Condition) Reset() {
	*x = RecordCondition_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[227]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Condition) ProtoMessage() {}

func (x *RecordCondition_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[227]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Condition.ProtoReflect.Descriptor instead.
func (*RecordCondition_Condition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 0}
}

func (x *RecordCondition_Condition) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *RecordCondition_Condition) GetOperator() RelationalOperator {
	if x != nil {
		return x.Operator
	}
	return RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED
}

func (x *RecordCondition_Condition) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// A collection of conditions.
type RecordCondition_Conditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of conditions.
	Conditions []*RecordCondition_Condition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *RecordCondition_Conditions) Reset() {
	*x = RecordCondition_Conditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[228]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Conditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Conditions) ProtoMessage() {}

func (x *RecordCondition_Conditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[228]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Conditions.ProtoReflect.Descriptor instead.
func (*RecordCondition_Conditions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 1}
}

func (x *RecordCondition_Conditions) GetConditions() []*RecordCondition_Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// An expression, consisting of an operator and conditions.
type RecordCondition_Expressions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operator to apply to the result of conditions. Default and currently
	// only supported value is `AND`.
	LogicalOperator RecordCondition_Expressions_LogicalOperator `protobuf:"varint,1,opt,name=logical_operator,json=logicalOperator,proto3,enum=google.privacy.dlp.v2.RecordCondition_Expressions_LogicalOperator" json:"logical_operator,omitempty"`
	// Expression types.
	//
	// Types that are assignable to Type:
	//
	//	*RecordCondition_Expressions_Conditions
	Type isRecordCondition_Expressions_Type `protobuf_oneof:"type"`
}

func (x *RecordCondition_Expressions) Reset() {
	*x = RecordCondition_Expressions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[229]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Expressions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Expressions) ProtoMessage() {}

func (x *RecordCondition_Expressions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[229]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Expressions.ProtoReflect.Descriptor instead.
func (*RecordCondition_Expressions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 2}
}

func (x *RecordCondition_Expressions) GetLogicalOperator() RecordCondition_Expressions_LogicalOperator {
	if x != nil {
		return x.LogicalOperator
	}
	return RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED
}

func (m *RecordCondition_Expressions) GetType() isRecordCondition_Expressions_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *RecordCondition_Expressions) GetConditions() *RecordCondition_Conditions {
	if x, ok := x.GetType().(*RecordCondition_Expressions_Conditions); ok {
		return x.Conditions
	}
	return nil
}

type isRecordCondition_Expressions_Type interface {
	isRecordCondition_Expressions_Type()
}

type RecordCondition_Expressions_Conditions struct {
	// Conditions to apply to the expression.
	Conditions *RecordCondition_Conditions `protobuf:"bytes,3,opt,name=conditions,proto3,oneof"`
}

func (*RecordCondition_Expressions_Conditions) isRecordCondition_Expressions_Type() {}

// A collection that informs the user the number of times a particular
// `TransformationResultCode` and error details occurred.
type TransformationSummary_SummaryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of transformations counted by this result.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Outcome of the transformation.
	Code TransformationSummary_TransformationResultCode `protobuf:"varint,2,opt,name=code,proto3,enum=google.privacy.dlp.v2.TransformationSummary_TransformationResultCode" json:"code,omitempty"`
	// A place for warnings or errors to show up if a transformation didn't
	// work as expected.
	Details string `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *TransformationSummary_SummaryResult) Reset() {
	*x = TransformationSummary_SummaryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[230]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationSummary_SummaryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationSummary_SummaryResult) ProtoMessage() {}

func (x *TransformationSummary_SummaryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[230]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationSummary_SummaryResult.ProtoReflect.Descriptor instead.
func (*TransformationSummary_SummaryResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{80, 0}
}

func (x *TransformationSummary_SummaryResult) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *TransformationSummary_SummaryResult) GetCode() TransformationSummary_TransformationResultCode {
	if x != nil {
		return x.Code
	}
	return TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED
}

func (x *TransformationSummary_SummaryResult) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// What event needs to occur for a new job to be started.
type JobTrigger_Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What event needs to occur for a new job to be started.
	//
	// Types that are assignable to Trigger:
	//
	//	*JobTrigger_Trigger_Schedule
	//	*JobTrigger_Trigger_Manual
	Trigger isJobTrigger_Trigger_Trigger `protobuf_oneof:"trigger"`
}

func (x *JobTrigger_Trigger) Reset() {
	*x = JobTrigger_Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[231]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTrigger_Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTrigger_Trigger) ProtoMessage() {}

func (x *JobTrigger_Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[231]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTrigger_Trigger.ProtoReflect.Descriptor instead.
func (*JobTrigger_Trigger) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{92, 0}
}

func (m *JobTrigger_Trigger) GetTrigger() isJobTrigger_Trigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *JobTrigger_Trigger) GetSchedule() *Schedule {
	if x, ok := x.GetTrigger().(*JobTrigger_Trigger_Schedule); ok {
		return x.Schedule
	}
	return nil
}

func (x *JobTrigger_Trigger) GetManual() *Manual {
	if x, ok := x.GetTrigger().(*JobTrigger_Trigger_Manual); ok {
		return x.Manual
	}
	return nil
}

type isJobTrigger_Trigger_Trigger interface {
	isJobTrigger_Trigger_Trigger()
}

type JobTrigger_Trigger_Schedule struct {
	// Create a job on a repeating basis based on the elapse of time.
	Schedule *Schedule `protobuf:"bytes,1,opt,name=schedule,proto3,oneof"`
}

type JobTrigger_Trigger_Manual struct {
	// For use with hybrid jobs. Jobs must be manually created and finished.
	Manual *Manual `protobuf:"bytes,2,opt,name=manual,proto3,oneof"`
}

func (*JobTrigger_Trigger_Schedule) isJobTrigger_Trigger_Trigger() {}

func (*JobTrigger_Trigger_Manual) isJobTrigger_Trigger_Trigger() {}

// If set, the detailed findings will be persisted to the specified
// OutputStorageConfig. Only a single instance of this action can be
// specified.
// Compatible with: Inspect, Risk
type Action_SaveFindings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location to store findings outside of DLP.
	OutputConfig *OutputStorageConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *Action_SaveFindings) Reset() {
	*x = Action_SaveFindings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[232]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_SaveFindings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_SaveFindings) ProtoMessage() {}

func (x *Action_SaveFindings) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[232]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_SaveFindings.ProtoReflect.Descriptor instead.
func (*Action_SaveFindings) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 0}
}

func (x *Action_SaveFindings) GetOutputConfig() *OutputStorageConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Publish a message into a given Pub/Sub topic when DlpJob has completed. The
// message contains a single field, `DlpJobName`, which is equal to the
// finished job's
// [`DlpJob.name`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
// Compatible with: Inspect, Risk
type Action_PublishToPubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Pub/Sub topic to send notifications to. The topic must have given
	// publishing access rights to the DLP API service account executing
	// the long running DlpJob sending the notifications.
	// Format is projects/{project}/topics/{topic}.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *Action_PublishToPubSub) Reset() {
	*x = Action_PublishToPubSub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[233]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishToPubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishToPubSub) ProtoMessage() {}

func (x *Action_PublishToPubSub) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[233]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishToPubSub.ProtoReflect.Descriptor instead.
func (*Action_PublishToPubSub) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 1}
}

func (x *Action_PublishToPubSub) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Publish the result summary of a DlpJob to [Security Command
// Center](https://cloud.google.com/security-command-center). This action is
// available for only projects that belong to an organization. This action
// publishes the count of finding instances and their infoTypes. The summary
// of findings are persisted in Security Command Center and are governed by
// [service-specific policies for Security Command
// Center](https://cloud.google.com/terms/service-terms). Only a single
// instance of this action can be specified. Compatible with: Inspect
type Action_PublishSummaryToCscc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishSummaryToCscc) Reset() {
	*x = Action_PublishSummaryToCscc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[234]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishSummaryToCscc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishSummaryToCscc) ProtoMessage() {}

func (x *Action_PublishSummaryToCscc) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[234]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishSummaryToCscc.ProtoReflect.Descriptor instead.
func (*Action_PublishSummaryToCscc) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 2}
}

// Publish findings of a DlpJob to Data Catalog. In Data Catalog, tag
// templates are applied to the resource that Cloud DLP scanned. Data
// Catalog tag templates are stored in the same project and region where the
// BigQuery table exists. For Cloud DLP to create and apply the tag template,
// the Cloud DLP service agent must have the
// `roles/datacatalog.tagTemplateOwner` permission on the project. The tag
// template contains fields summarizing the results of the DlpJob. Any field
// values previously written by another DlpJob are deleted. [InfoType naming
// patterns][google.privacy.dlp.v2.InfoType] are strictly enforced when using
// this feature.
//
// Findings are persisted in Data Catalog storage and are governed by
// service-specific policies for Data Catalog. For more information, see
// [Service Specific Terms](https://cloud.google.com/terms/service-terms).
//
// Only a single instance of this action can be specified. This action is
// allowed only if all resources being scanned are BigQuery tables.
// Compatible with: Inspect
type Action_PublishFindingsToCloudDataCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishFindingsToCloudDataCatalog) Reset() {
	*x = Action_PublishFindingsToCloudDataCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[235]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishFindingsToCloudDataCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishFindingsToCloudDataCatalog) ProtoMessage() {}

func (x *Action_PublishFindingsToCloudDataCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[235]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishFindingsToCloudDataCatalog.ProtoReflect.Descriptor instead.
func (*Action_PublishFindingsToCloudDataCatalog) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 3}
}

// Create a de-identified copy of the requested table or files.
//
// A TransformationDetail will be created for each transformation.
//
// If any rows in BigQuery are skipped during de-identification
// (transformation errors or row size exceeds BigQuery insert API limits) they
// are placed in the failure output table. If the original row exceeds
// the BigQuery insert API limit it will be truncated when written to the
// failure output table. The failure output table can be set in the
// action.deidentify.output.big_query_output.deidentified_failure_output_table
// field, if no table is set, a table will be automatically created in the
// same project and dataset as the original table.
//
// Compatible with: Inspect
type Action_Deidentify struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User specified deidentify templates and configs for structured,
	// unstructured, and image files.
	TransformationConfig *TransformationConfig `protobuf:"bytes,7,opt,name=transformation_config,json=transformationConfig,proto3" json:"transformation_config,omitempty"`
	// Config for storing transformation details. This is separate from the
	// de-identified content, and contains metadata about the successful
	// transformations and/or failures that occurred while de-identifying. This
	// needs to be set in order for users to access information about the status
	// of each transformation (see
	// [TransformationDetails][google.privacy.dlp.v2.TransformationDetails]
	// message for more information about what is noted).
	TransformationDetailsStorageConfig *TransformationDetailsStorageConfig `protobuf:"bytes,3,opt,name=transformation_details_storage_config,json=transformationDetailsStorageConfig,proto3" json:"transformation_details_storage_config,omitempty"`
	// Where to store the output.
	//
	// Types that are assignable to Output:
	//
	//	*Action_Deidentify_CloudStorageOutput
	Output isAction_Deidentify_Output `protobuf_oneof:"output"`
	// List of user-specified file type groups to transform. If specified, only
	// the files with these filetypes will be transformed. If empty, all
	// supported files will be transformed. Supported types may be automatically
	// added over time. If a file type is set in this field that isn't supported
	// by the Deidentify action then the job will fail and will not be
	// successfully created/started. Currently the only filetypes supported are:
	// IMAGES, TEXT_FILES, CSV, TSV.
	FileTypesToTransform []FileType `protobuf:"varint,8,rep,packed,name=file_types_to_transform,json=fileTypesToTransform,proto3,enum=google.privacy.dlp.v2.FileType" json:"file_types_to_transform,omitempty"`
}

func (x *Action_Deidentify) Reset() {
	*x = Action_Deidentify{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[236]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_Deidentify) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_Deidentify) ProtoMessage() {}

func (x *Action_Deidentify) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[236]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_Deidentify.ProtoReflect.Descriptor instead.
func (*Action_Deidentify) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 4}
}

func (x *Action_Deidentify) GetTransformationConfig() *TransformationConfig {
	if x != nil {
		return x.TransformationConfig
	}
	return nil
}

func (x *Action_Deidentify) GetTransformationDetailsStorageConfig() *TransformationDetailsStorageConfig {
	if x != nil {
		return x.TransformationDetailsStorageConfig
	}
	return nil
}

func (m *Action_Deidentify) GetOutput() isAction_Deidentify_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *Action_Deidentify) GetCloudStorageOutput() string {
	if x, ok := x.GetOutput().(*Action_Deidentify_CloudStorageOutput); ok {
		return x.CloudStorageOutput
	}
	return ""
}

func (x *Action_Deidentify) GetFileTypesToTransform() []FileType {
	if x != nil {
		return x.FileTypesToTransform
	}
	return nil
}

type isAction_Deidentify_Output interface {
	isAction_Deidentify_Output()
}

type Action_Deidentify_CloudStorageOutput struct {
	// Required. User settable Cloud Storage bucket and folders to store
	// de-identified files. This field must be set for cloud storage
	// deidentification. The output Cloud Storage bucket must be different
	// from the input bucket. De-identified files will overwrite files in the
	// output path.
	//
	// Form of: gs://bucket/folder/ or gs://bucket
	CloudStorageOutput string `protobuf:"bytes,9,opt,name=cloud_storage_output,json=cloudStorageOutput,proto3,oneof"`
}

func (*Action_Deidentify_CloudStorageOutput) isAction_Deidentify_Output() {}

// Sends an email when the job completes. The email goes to IAM project owners
// and technical [Essential
// Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
type Action_JobNotificationEmails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_JobNotificationEmails) Reset() {
	*x = Action_JobNotificationEmails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[237]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_JobNotificationEmails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_JobNotificationEmails) ProtoMessage() {}

func (x *Action_JobNotificationEmails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[237]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_JobNotificationEmails.ProtoReflect.Descriptor instead.
func (*Action_JobNotificationEmails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 5}
}

// Enable Stackdriver metric dlp.googleapis.com/finding_count. This
// will publish a metric to stack driver on each infotype requested and
// how many findings were found for it. CustomDetectors will be bucketed
// as 'Custom' under the Stackdriver label 'info_type'.
type Action_PublishToStackdriver struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishToStackdriver) Reset() {
	*x = Action_PublishToStackdriver{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[238]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishToStackdriver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishToStackdriver) ProtoMessage() {}

func (x *Action_PublishToStackdriver) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[238]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishToStackdriver.ProtoReflect.Descriptor instead.
func (*Action_PublishToStackdriver) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93, 6}
}

// If set, the detailed data profiles will be persisted to the location
// of your choice whenever updated.
type DataProfileAction_Export struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Store all table and column profiles in an existing table or a new table
	// in an existing dataset. Each re-generation will result in a new row in
	// BigQuery.
	ProfileTable *BigQueryTable `protobuf:"bytes,1,opt,name=profile_table,json=profileTable,proto3" json:"profile_table,omitempty"`
}

func (x *DataProfileAction_Export) Reset() {
	*x = DataProfileAction_Export{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[239]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileAction_Export) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileAction_Export) ProtoMessage() {}

func (x *DataProfileAction_Export) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[239]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileAction_Export.ProtoReflect.Descriptor instead.
func (*DataProfileAction_Export) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116, 0}
}

func (x *DataProfileAction_Export) GetProfileTable() *BigQueryTable {
	if x != nil {
		return x.ProfileTable
	}
	return nil
}

// Send a Pub/Sub message into the given Pub/Sub topic to connect other
// systems to data profile generation. The message payload data will
// be the byte serialization of `DataProfilePubSubMessage`.
type DataProfileAction_PubSubNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Pub/Sub topic to send notifications to.
	// Format is projects/{project}/topics/{topic}.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// The type of event that triggers a Pub/Sub. At most one
	// `PubSubNotification` per EventType is permitted.
	Event DataProfileAction_EventType `protobuf:"varint,2,opt,name=event,proto3,enum=google.privacy.dlp.v2.DataProfileAction_EventType" json:"event,omitempty"`
	// Conditions (e.g., data risk or sensitivity level) for triggering a
	// Pub/Sub.
	PubsubCondition *DataProfilePubSubCondition `protobuf:"bytes,3,opt,name=pubsub_condition,json=pubsubCondition,proto3" json:"pubsub_condition,omitempty"`
	// How much data to include in the Pub/Sub message. If the user wishes to
	// limit the size of the message, they can use resource_name and fetch the
	// profile fields they wish to. Per table profile (not per column).
	DetailOfMessage DataProfileAction_PubSubNotification_DetailLevel `protobuf:"varint,4,opt,name=detail_of_message,json=detailOfMessage,proto3,enum=google.privacy.dlp.v2.DataProfileAction_PubSubNotification_DetailLevel" json:"detail_of_message,omitempty"`
}

func (x *DataProfileAction_PubSubNotification) Reset() {
	*x = DataProfileAction_PubSubNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[240]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileAction_PubSubNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileAction_PubSubNotification) ProtoMessage() {}

func (x *DataProfileAction_PubSubNotification) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[240]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileAction_PubSubNotification.ProtoReflect.Descriptor instead.
func (*DataProfileAction_PubSubNotification) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116, 1}
}

func (x *DataProfileAction_PubSubNotification) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *DataProfileAction_PubSubNotification) GetEvent() DataProfileAction_EventType {
	if x != nil {
		return x.Event
	}
	return DataProfileAction_EVENT_TYPE_UNSPECIFIED
}

func (x *DataProfileAction_PubSubNotification) GetPubsubCondition() *DataProfilePubSubCondition {
	if x != nil {
		return x.PubsubCondition
	}
	return nil
}

func (x *DataProfileAction_PubSubNotification) GetDetailOfMessage() DataProfileAction_PubSubNotification_DetailLevel {
	if x != nil {
		return x.DetailOfMessage
	}
	return DataProfileAction_PubSubNotification_DETAIL_LEVEL_UNSPECIFIED
}

// Project and scan location information. Only set when the parent is an org.
type DiscoveryConfig_OrgConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data to scan: folder, org, or project
	Location *DiscoveryStartingLocation `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The project that will run the scan. The DLP service
	// account that exists within this project must have access to all resources
	// that are profiled, and the Cloud DLP API must be enabled.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DiscoveryConfig_OrgConfig) Reset() {
	*x = DiscoveryConfig_OrgConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[241]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryConfig_OrgConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryConfig_OrgConfig) ProtoMessage() {}

func (x *DiscoveryConfig_OrgConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[241]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryConfig_OrgConfig.ProtoReflect.Descriptor instead.
func (*DiscoveryConfig_OrgConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{123, 0}
}

func (x *DiscoveryConfig_OrgConfig) GetLocation() *DiscoveryStartingLocation {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *DiscoveryConfig_OrgConfig) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Catch-all for all other tables not specified by other filters. Should
// always be last, except for single-table configurations, which will only
// have a TableReference target.
type DiscoveryBigQueryFilter_AllOtherBigQueryTables struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DiscoveryBigQueryFilter_AllOtherBigQueryTables) Reset() {
	*x = DiscoveryBigQueryFilter_AllOtherBigQueryTables{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[242]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryBigQueryFilter_AllOtherBigQueryTables) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryBigQueryFilter_AllOtherBigQueryTables) ProtoMessage() {}

func (x *DiscoveryBigQueryFilter_AllOtherBigQueryTables) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[242]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryBigQueryFilter_AllOtherBigQueryTables.ProtoReflect.Descriptor instead.
func (*DiscoveryBigQueryFilter_AllOtherBigQueryTables) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{126, 0}
}

// There is an OR relationship between these attributes. They are used to
// determine if a table should be scanned or not in Discovery.
type DiscoveryBigQueryConditions_OrConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum number of rows that should be present before Cloud DLP
	// profiles a table
	MinRowCount int32 `protobuf:"varint,1,opt,name=min_row_count,json=minRowCount,proto3" json:"min_row_count,omitempty"`
	// Minimum age a table must have before Cloud DLP can profile it. Value must
	// be 1 hour or greater.
	MinAge *durationpb.Duration `protobuf:"bytes,2,opt,name=min_age,json=minAge,proto3" json:"min_age,omitempty"`
}

func (x *DiscoveryBigQueryConditions_OrConditions) Reset() {
	*x = DiscoveryBigQueryConditions_OrConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[243]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiscoveryBigQueryConditions_OrConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryBigQueryConditions_OrConditions) ProtoMessage() {}

func (x *DiscoveryBigQueryConditions_OrConditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[243]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryBigQueryConditions_OrConditions.ProtoReflect.Descriptor instead.
func (*DiscoveryBigQueryConditions_OrConditions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{128, 0}
}

func (x *DiscoveryBigQueryConditions_OrConditions) GetMinRowCount() int32 {
	if x != nil {
		return x.MinRowCount
	}
	return 0
}

func (x *DiscoveryBigQueryConditions_OrConditions) GetMinAge() *durationpb.Duration {
	if x != nil {
		return x.MinAge
	}
	return nil
}

// A condition consisting of a value.
type DataProfilePubSubCondition_PubSubCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value for the condition to trigger.
	//
	// Types that are assignable to Value:
	//
	//	*DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore
	//	*DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore
	Value isDataProfilePubSubCondition_PubSubCondition_Value `protobuf_oneof:"value"`
}

func (x *DataProfilePubSubCondition_PubSubCondition) Reset() {
	*x = DataProfilePubSubCondition_PubSubCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[246]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfilePubSubCondition_PubSubCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfilePubSubCondition_PubSubCondition) ProtoMessage() {}

func (x *DataProfilePubSubCondition_PubSubCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[246]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfilePubSubCondition_PubSubCondition.ProtoReflect.Descriptor instead.
func (*DataProfilePubSubCondition_PubSubCondition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{180, 0}
}

func (m *DataProfilePubSubCondition_PubSubCondition) GetValue() isDataProfilePubSubCondition_PubSubCondition_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *DataProfilePubSubCondition_PubSubCondition) GetMinimumRiskScore() DataProfilePubSubCondition_ProfileScoreBucket {
	if x, ok := x.GetValue().(*DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore); ok {
		return x.MinimumRiskScore
	}
	return DataProfilePubSubCondition_PROFILE_SCORE_BUCKET_UNSPECIFIED
}

func (x *DataProfilePubSubCondition_PubSubCondition) GetMinimumSensitivityScore() DataProfilePubSubCondition_ProfileScoreBucket {
	if x, ok := x.GetValue().(*DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore); ok {
		return x.MinimumSensitivityScore
	}
	return DataProfilePubSubCondition_PROFILE_SCORE_BUCKET_UNSPECIFIED
}

type isDataProfilePubSubCondition_PubSubCondition_Value interface {
	isDataProfilePubSubCondition_PubSubCondition_Value()
}

type DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore struct {
	// The minimum data risk score that triggers the condition.
	MinimumRiskScore DataProfilePubSubCondition_ProfileScoreBucket `protobuf:"varint,1,opt,name=minimum_risk_score,json=minimumRiskScore,proto3,enum=google.privacy.dlp.v2.DataProfilePubSubCondition_ProfileScoreBucket,oneof"`
}

type DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore struct {
	// The minimum sensitivity level that triggers the condition.
	MinimumSensitivityScore DataProfilePubSubCondition_ProfileScoreBucket `protobuf:"varint,2,opt,name=minimum_sensitivity_score,json=minimumSensitivityScore,proto3,enum=google.privacy.dlp.v2.DataProfilePubSubCondition_ProfileScoreBucket,oneof"`
}

func (*DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore) isDataProfilePubSubCondition_PubSubCondition_Value() {
}

func (*DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore) isDataProfilePubSubCondition_PubSubCondition_Value() {
}

// An expression, consisting of an operator and conditions.
type DataProfilePubSubCondition_PubSubExpressions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operator to apply to the collection of conditions.
	LogicalOperator DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator `protobuf:"varint,1,opt,name=logical_operator,json=logicalOperator,proto3,enum=google.privacy.dlp.v2.DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator" json:"logical_operator,omitempty"`
	// Conditions to apply to the expression.
	Conditions []*DataProfilePubSubCondition_PubSubCondition `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *DataProfilePubSubCondition_PubSubExpressions) Reset() {
	*x = DataProfilePubSubCondition_PubSubExpressions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[247]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfilePubSubCondition_PubSubExpressions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfilePubSubCondition_PubSubExpressions) ProtoMessage() {}

func (x *DataProfilePubSubCondition_PubSubExpressions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[247]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfilePubSubCondition_PubSubExpressions.ProtoReflect.Descriptor instead.
func (*DataProfilePubSubCondition_PubSubExpressions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{180, 1}
}

func (x *DataProfilePubSubCondition_PubSubExpressions) GetLogicalOperator() DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator {
	if x != nil {
		return x.LogicalOperator
	}
	return DataProfilePubSubCondition_PubSubExpressions_LOGICAL_OPERATOR_UNSPECIFIED
}

func (x *DataProfilePubSubCondition_PubSubExpressions) GetConditions() []*DataProfilePubSubCondition_PubSubCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

var File_google_privacy_dlp_v2_dlp_proto protoreflect.FileDescriptor

var file_google_privacy_dlp_v2_dlp_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2f, 0x64, 0x6c, 0x70, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x6c, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2f, 0x64, 0x6c, 0x70, 0x2f,
	0x76, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64,
	0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x52, 0x0a, 0x10, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22,
	0xc1, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x42, 0x79, 0x48, 0x6f, 0x74,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x50, 0x0a, 0x0d, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x2e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72,
	0x64, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x5b, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x50,
	0x72, 0x6f, 0x78, 0x69, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
	0x69, 0x74, 0x79, 0x22, 0xac, 0x03, 0x0a, 0x0d, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x52, 0x65, 0x67, 0x65, 0x78, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x57,
	0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x62, 0x79, 0x5f, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x42, 0x79, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x10,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x42, 0x79, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x48, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x0c, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65,
	0x2e, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b,
	0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xa5, 0x09, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c,
	0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f,
	0x6f, 0x64, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x12, 0x77, 0x0a, 0x1c, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x52, 0x18, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x50,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x11, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x08, 0x72,
	0x75, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x1a, 0x9c, 0x01, 0x0a, 0x12, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x1a,
	0xeb, 0x02, 0x0a, 0x0d, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x31, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x65, 0x72,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x37, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x50, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7c, 0x0a,
	0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x50, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x70, 0x0a, 0x0d, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x3c, 0x0a, 0x09,
	0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61,
	0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xd1, 0x02,
	0x0a, 0x0f, 0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe3, 0x01, 0x0a, 0x09,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x06,
	0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x50, 0x45, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x42, 0x4d, 0x50, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x56, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a,
	0x09, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x55, 0x54, 0x46, 0x38, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d,
	0x57, 0x4f, 0x52, 0x44, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x07, 0x12,
	0x07, 0x0a, 0x03, 0x50, 0x44, 0x46, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x4f, 0x57, 0x45,
	0x52, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x09, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x58, 0x43, 0x45, 0x4c, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x56, 0x52, 0x4f, 0x10, 0x0b, 0x12,
	0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10, 0x0c, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x53, 0x56, 0x10,
	0x0d, 0x22, 0xaf, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x45, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x48, 0x00, 0x52, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x22, 0xb4, 0x01, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x38, 0x0a,
	0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x34, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x1a, 0x3b, 0x0a,
	0x03, 0x52, 0x6f, 0x77, 0x12, 0x34, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x7a, 0x0a, 0x0d, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3a, 0x0a, 0x08, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0xf5, 0x06, 0x0a, 0x07, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x09,
	0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x6c, 0x69,
	0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x0a, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x3b, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x71,
	0x75, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1e, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a,
	0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x42, 0x0a, 0x0f, 0x6a, 0x6f, 0x62, 0x5f,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6a,
	0x6f, 0x62, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e,
	0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x3a, 0x5b, 0xea, 0x41, 0x58, 0x0a, 0x1a, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x22, 0xa3,
	0x02, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0a, 0x62,
	0x79, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x62,
	0x79, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x64, 0x65,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x0e, 0x63, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x53, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x22, 0x8f, 0x04, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x50, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4d, 0x0a, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x56, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x11, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2b, 0x0a,
	0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x10, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x22, 0x28, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x33, 0x0a, 0x10, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x22, 0xd9, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x4b, 0x65, 0x79, 0x12, 0x39, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12,
	0x4b, 0x0a, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2c, 0x0a, 0x0d,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x72, 0x6f, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xf4, 0x01, 0x0a, 0x09, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x66, 0x75, 0x6c, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x74,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x2f, 0x0a, 0x05, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65,
	0x6e, 0x64, 0x22, 0x5a, 0x0a, 0x0d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52,
	0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x65, 0x73, 0x22, 0x61,
	0x0a, 0x0b, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x10, 0x0a,
	0x03, 0x74, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x74, 0x6f, 0x70, 0x12,
	0x12, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6c,
	0x65, 0x66, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x22, 0xfa, 0x04, 0x0a, 0x12, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64,
	0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x76, 0x0a, 0x17, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x15, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d,
	0x52, 0x08, 0x62, 0x79, 0x74, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x1a, 0xd1, 0x01, 0x0a, 0x14, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x5f, 0x61, 0x6c,
	0x6c, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d,
	0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x12, 0x45, 0x0a,
	0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x0e, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x43,
	0x0a, 0x05, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x03, 0x72, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x65,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x62, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x62,
	0x6c, 0x75, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x65, 0x64, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0d, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xc0, 0x03, 0x0a, 0x18, 0x44, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x54, 0x0a, 0x11, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x10, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38,
	0x0a, 0x18, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x16, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x44, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12,
	0x49, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc3, 0x03, 0x0a, 0x18, 0x52,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12,
	0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x11, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x72, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65,
	0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65,
	0x6d, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x9e, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36,
	0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d,
	0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x49, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65,
	0x77, 0x22, 0xad, 0x02, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f,
	0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x32, 0x0a, 0x15,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0x56, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xcc, 0x02, 0x0a, 0x13, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3c, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x5c, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x90, 0x01,
	0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1d,
	0x0a, 0x19, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x43, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10,
	0x02, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x43,
	0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x49, 0x47, 0x5f,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x04, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x05,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x63, 0x0a, 0x0d, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa3, 0x05,
	0x0a, 0x18, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xbe, 0x01, 0x0a, 0x10, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62,
	0x0a, 0x19, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x17, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x6a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x86, 0x02, 0x0a, 0x06, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x0d, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x51, 0x0a, 0x0c, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48,
	0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x0b, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x22, 0xd1, 0x01, 0x0a, 0x1c, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x77, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x4e, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x17, 0x48, 0x79, 0x62, 0x72,
	0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x62, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0c, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x7f, 0x0a, 0x0d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x63, 0x0a, 0x12, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x11, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x09, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xb9, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x1a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0xf5, 0x04, 0x0a, 0x1b, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x7a, 0x0a, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5b, 0x0a, 0x10, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0f, 0x64, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0xfc, 0x02, 0x0a,
	0x1a, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6b, 0x0a, 0x1c, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x1a, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x80, 0x01, 0x0a, 0x27, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x5f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x24, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x6e, 0x0a, 0x1e, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x1b,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64,
	0x61, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xa3, 0x03, 0x0a, 0x13,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x42, 0x79, 0x52, 0x0b, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x08, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x47, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x11, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x52,
	0x10, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x22, 0xb9, 0x09, 0x0a, 0x10, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x67, 0x0a, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12,
	0x67, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x5b, 0x0a, 0x0d, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x79, 0x70, 0x65, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x22, 0xf2, 0x04, 0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x52, 0x47, 0x45, 0x4e, 0x54, 0x49, 0x4e, 0x41, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x41, 0x55, 0x53, 0x54, 0x52, 0x41, 0x4c, 0x49, 0x41, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x42, 0x45, 0x4c, 0x47, 0x49, 0x55, 0x4d, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x42,
	0x52, 0x41, 0x5a, 0x49, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41, 0x4e, 0x41, 0x44,
	0x41, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x48, 0x49, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x09,
	0x0a, 0x05, 0x43, 0x48, 0x49, 0x4e, 0x41, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4c,
	0x4f, 0x4d, 0x42, 0x49, 0x41, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x4f, 0x41, 0x54,
	0x49, 0x41, 0x10, 0x2a, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4e, 0x4d, 0x41, 0x52, 0x4b, 0x10,
	0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x0b, 0x12, 0x0b, 0x0a,
	0x07, 0x46, 0x49, 0x4e, 0x4c, 0x41, 0x4e, 0x44, 0x10, 0x0c, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x45,
	0x52, 0x4d, 0x41, 0x4e, 0x59, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x4f, 0x4e, 0x47, 0x5f,
	0x4b, 0x4f, 0x4e, 0x47, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x44, 0x49, 0x41, 0x10,
	0x0f, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x53, 0x49, 0x41, 0x10, 0x10,
	0x12, 0x0b, 0x0a, 0x07, 0x49, 0x52, 0x45, 0x4c, 0x41, 0x4e, 0x44, 0x10, 0x11, 0x12, 0x0a, 0x0a,
	0x06, 0x49, 0x53, 0x52, 0x41, 0x45, 0x4c, 0x10, 0x12, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x54, 0x41,
	0x4c, 0x59, 0x10, 0x13, 0x12, 0x09, 0x0a, 0x05, 0x4a, 0x41, 0x50, 0x41, 0x4e, 0x10, 0x14, 0x12,
	0x09, 0x0a, 0x05, 0x4b, 0x4f, 0x52, 0x45, 0x41, 0x10, 0x15, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45,
	0x58, 0x49, 0x43, 0x4f, 0x10, 0x16, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x48, 0x45, 0x5f, 0x4e, 0x45,
	0x54, 0x48, 0x45, 0x52, 0x4c, 0x41, 0x4e, 0x44, 0x53, 0x10, 0x17, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x45, 0x57, 0x5f, 0x5a, 0x45, 0x41, 0x4c, 0x41, 0x4e, 0x44, 0x10, 0x29, 0x12, 0x0a, 0x0a, 0x06,
	0x4e, 0x4f, 0x52, 0x57, 0x41, 0x59, 0x10, 0x18, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x41, 0x52, 0x41,
	0x47, 0x55, 0x41, 0x59, 0x10, 0x19, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x45, 0x52, 0x55, 0x10, 0x1a,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x4f, 0x4c, 0x41, 0x4e, 0x44, 0x10, 0x1b, 0x12, 0x0c, 0x0a, 0x08,
	0x50, 0x4f, 0x52, 0x54, 0x55, 0x47, 0x41, 0x4c, 0x10, 0x1c, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49,
	0x4e, 0x47, 0x41, 0x50, 0x4f, 0x52, 0x45, 0x10, 0x1d, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4f, 0x55,
	0x54, 0x48, 0x5f, 0x41, 0x46, 0x52, 0x49, 0x43, 0x41, 0x10, 0x1e, 0x12, 0x09, 0x0a, 0x05, 0x53,
	0x50, 0x41, 0x49, 0x4e, 0x10, 0x1f, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x57, 0x45, 0x44, 0x45, 0x4e,
	0x10, 0x20, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x57, 0x49, 0x54, 0x5a, 0x45, 0x52, 0x4c, 0x41, 0x4e,
	0x44, 0x10, 0x2b, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x49, 0x57, 0x41, 0x4e, 0x10, 0x21, 0x12,
	0x0c, 0x0a, 0x08, 0x54, 0x48, 0x41, 0x49, 0x4c, 0x41, 0x4e, 0x44, 0x10, 0x22, 0x12, 0x0a, 0x0a,
	0x06, 0x54, 0x55, 0x52, 0x4b, 0x45, 0x59, 0x10, 0x23, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x4e, 0x49,
	0x54, 0x45, 0x44, 0x5f, 0x4b, 0x49, 0x4e, 0x47, 0x44, 0x4f, 0x4d, 0x10, 0x24, 0x12, 0x11, 0x0a,
	0x0d, 0x55, 0x4e, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x53, 0x10, 0x25,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x52, 0x55, 0x47, 0x55, 0x41, 0x59, 0x10, 0x26, 0x12, 0x0d, 0x0a,
	0x09, 0x56, 0x45, 0x4e, 0x45, 0x5a, 0x55, 0x45, 0x4c, 0x41, 0x10, 0x27, 0x12, 0x0c, 0x0a, 0x08,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x28, 0x22, 0x5d, 0x0a, 0x10, 0x49, 0x6e,
	0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x18,
	0x0a, 0x14, 0x49, 0x4e, 0x44, 0x55, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4e, 0x41,
	0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x10,
	0x02, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x4e, 0x49,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x03, 0x22, 0x95, 0x01, 0x0a, 0x0c, 0x54, 0x79,
	0x70, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x50, 0x49, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x50, 0x49,
	0x49, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x4d, 0x4f, 0x47, 0x52, 0x41, 0x50, 0x48,
	0x49, 0x43, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49,
	0x41, 0x4c, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x49, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x4f, 0x43, 0x55, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x58, 0x54,
	0x55, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x07, 0x42, 0x0a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x22, 0x50, 0x0a,
	0x12, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8c, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a,
	0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x62,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x22, 0xe6, 0x01, 0x0a, 0x15, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x47, 0x0a, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe2, 0x01, 0x0a, 0x07,
	0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x3e, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x54, 0x61, 0x67, 0x12, 0x34, 0x0a, 0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52,
	0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x74, 0x61, 0x67,
	0x22, 0xf4, 0x02, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x5e, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x6b, 0x0a, 0x14, 0x51, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49,
	0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x22, 0x86, 0x12, 0x0a, 0x0d, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x71, 0x0a, 0x16, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e,
	0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77, 0x0a, 0x18,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x12, 0x6b, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x6b, 0x41, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x12,
	0x6c, 0x5f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4c,
	0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x10, 0x6c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x72, 0x0a, 0x17, 0x6b, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x14, 0x6b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8d, 0x01, 0x0a, 0x20, 0x64, 0x65, 0x6c, 0x74,
	0x61, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1d, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x50,
	0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x4c, 0x0a, 0x14, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x4e, 0x0a, 0x16, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x8d, 0x01, 0x0a, 0x10, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x09, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x08, 0x71,
	0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x1a, 0xa0, 0x01, 0x0a, 0x10, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x09, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x08, 0x71,
	0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x13, 0x73, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x52, 0x12, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x1a, 0x84, 0x07, 0x0a, 0x14, 0x4b, 0x4d, 0x61,
	0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x67, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x73, 0x0a, 0x10, 0x61,
	0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61, 0x70,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x0f, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x1a, 0xe6, 0x01, 0x0a, 0x0b, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x39, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3e, 0x0a, 0x09, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x12, 0x34, 0x0a, 0x08,
	0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x1a, 0x83, 0x03, 0x0a, 0x0e, 0x41, 0x75,
	0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3f, 0x0a, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x77, 0x0a,
	0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x78, 0x69,
	0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x51, 0x75, 0x61, 0x73, 0x69,
	0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x63, 0x0a, 0x0c, 0x51, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x1a,
	0xd6, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63,
	0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x40, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x61,
	0x73, 0x69, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x71, 0x75, 0x61, 0x73, 0x69,
	0x49, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x10, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72,
	0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0xff, 0x27, 0x0a, 0x1c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x5e, 0x0a, 0x18, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x5a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x80, 0x01,
	0x0a, 0x16, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14, 0x6e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x86, 0x01, 0x0a, 0x18, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x16, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x74, 0x0a, 0x12, 0x6b, 0x5f, 0x61,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6b,
	0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x74, 0x0a, 0x12, 0x6c, 0x5f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x17, 0x6b, 0x5f, 0x6d, 0x61, 0x70, 0x5f,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x4d, 0x61,
	0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x14, 0x6b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x9c, 0x01, 0x0a, 0x20, 0x64, 0x65,
	0x6c, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69,
	0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50,
	0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x64, 0x65, 0x6c, 0x74, 0x61,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7d, 0x0a, 0x11, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xd3, 0x01, 0x0a, 0x14, 0x4e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x39, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x61,
	0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69,
	0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x8d, 0x04,
	0x0a, 0x16, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xb5, 0x01, 0x0a, 0x21, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x68, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69,
	0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x1e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x1a, 0xba, 0x02, 0x0a, 0x1f, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x12, 0x3d, 0x0a, 0x1b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x55, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xeb, 0x05,
	0x0a, 0x10, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0xad, 0x01, 0x0a, 0x23, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74,
	0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x20, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x1a, 0x9a, 0x01, 0x0a, 0x1a, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74,
	0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x73, 0x69,
	0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x71, 0x75,
	0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x65, 0x71, 0x75, 0x69, 0x76,
	0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x1a,
	0x89, 0x03, 0x0a, 0x19, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x4a, 0x0a,
	0x22, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x65, 0x71, 0x75, 0x69, 0x76,
	0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x4c,
	0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x4a, 0x0a, 0x22, 0x65, 0x71, 0x75,
	0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x55, 0x70, 0x70, 0x65, 0x72,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x45,
	0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xa2, 0x07, 0x0a, 0x10,
	0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0xbc, 0x01, 0x0a, 0x2b, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x44, 0x69, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x44, 0x69,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x27, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a,
	0xb6, 0x02, 0x0a, 0x1a, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x45, 0x71,
	0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x46,
	0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61,
	0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65,
	0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x41, 0x0a, 0x1d,
	0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x1a, 0x6e, 0x75, 0x6d, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74,
	0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x57, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x95, 0x03, 0x0a, 0x19, 0x4c, 0x44, 0x69,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x25, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x21, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f,
	0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x50, 0x0a, 0x25, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x21, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x55, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x0d,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x74, 0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x9c, 0x05, 0x0a, 0x14, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xa3, 0x01, 0x0a, 0x1a, 0x6b, 0x5f,
	0x6d, 0x61, 0x70, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x66,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x17, 0x6b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x1a,
	0x96, 0x01, 0x0a, 0x1b, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64,
	0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x65, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x1a, 0xc4, 0x02, 0x0a, 0x1d, 0x4b, 0x4d, 0x61,
	0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69,
	0x6e, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x41, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a,
	0xf9, 0x05, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63,
	0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0xc7, 0x01, 0x0a, 0x23, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x20, 0x64, 0x65, 0x6c, 0x74, 0x61,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x1a, 0xa3, 0x01, 0x0a, 0x24,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x15,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x1a, 0xe7, 0x02, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65,
	0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x6f,
	0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e,
	0x6d, 0x61, 0x78, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1f,
	0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x9b, 0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x76, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x6c,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x6b, 0x0a, 0x1c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x0a, 0x6a,
	0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6a,
	0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x22, 0x5a, 0x0a, 0x0e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x9e,
	0x03, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65,
	0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x21, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x62, 0x6f, 0x6f, 0x6c, 0x65,
	0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45,
	0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61,
	0x79, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x32,
	0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x43, 0x0a, 0x11, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65,
	0x6b, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f,
	0x66, 0x57, 0x65, 0x65, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65,
	0x65, 0x6b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22,
	0x5b, 0x0a, 0x09, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3e, 0x0a, 0x09,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x48, 0x00, 0x52, 0x08, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c,
	0x70, 0x61, 0x72, 0x73, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x22, 0x8f, 0x02, 0x0a,
	0x08, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65,
	0x12, 0x36, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x09, 0x64,
	0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x2a, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x1a, 0x31, 0x0a, 0x08, 0x54,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x22, 0xd5,
	0x03, 0x0a, 0x10, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x19, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x65, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48,
	0x00, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a, 0x15, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x14, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x76, 0x0a, 0x1d,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x69, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x05, 0x0a, 0x14, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5f, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73,
	0x1a, 0xbd, 0x04, 0x0a, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x13, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x48, 0x00, 0x52, 0x11, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x74,
	0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x08, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x48,
	0x00, 0x52, 0x07, 0x61, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x52, 0x0e, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x1a, 0x58, 0x0a, 0x11, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x0e, 0x0a, 0x0c, 0x41,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x09, 0x0a, 0x07, 0x41,
	0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x22, 0xa5, 0x02, 0x0a, 0x1b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x60, 0x0a, 0x0b, 0x74, 0x68, 0x72, 0x6f, 0x77, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x68, 0x72, 0x6f, 0x77, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x68, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x78, 0x0a, 0x13, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x5f, 0x75, 0x6e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x55, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x48, 0x00, 0x52, 0x12, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x55,
	0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x1a, 0x0c, 0x0a, 0x0a,
	0x54, 0x68, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x14, 0x0a, 0x12, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x55, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64,
	0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xc4, 0x09, 0x0a, 0x17, 0x50, 0x72, 0x69,
	0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x0d, 0x72, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x13, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x1d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x66, 0x66, 0x78, 0x5f, 0x66, 0x70, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x19, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x1b,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x53,
	0x69, 0x7a, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x66, 0x69, 0x78, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53,
	0x0a, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x1d, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x77,
	0x69, 0x74, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x57, 0x69, 0x74, 0x68, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x57, 0x69, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69,
	0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x12,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x10, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x48, 0x61, 0x73, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68,
	0x69, 0x66, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68, 0x69,
	0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x68, 0x69, 0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x72, 0x0a, 0x1b, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x44,
	0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6c, 0x0a, 0x19, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x10, 0x0a,
	0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xeb, 0x01, 0x0a, 0x0e, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x52, 0x0d, 0x70, 0x61, 0x72,
	0x74, 0x54, 0x6f, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x22, 0x80, 0x01, 0x0a, 0x08, 0x54,
	0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x50, 0x41, 0x52, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x59, 0x5f, 0x4f,
	0x46, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x59,
	0x5f, 0x4f, 0x46, 0x5f, 0x57, 0x45, 0x45, 0x4b, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x57, 0x45,
	0x45, 0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b,
	0x48, 0x4f, 0x55, 0x52, 0x5f, 0x4f, 0x46, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x06, 0x22, 0x53, 0x0a,
	0x10, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3f, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b,
	0x65, 0x79, 0x22, 0xe7, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x44, 0x65, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3f, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x12, 0x4f, 0x0a, 0x13, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x11, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x38, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x49, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x4f, 0x0a, 0x12,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x39, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x7b, 0x0a,
	0x17, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x64,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x2e, 0x57, 0x6f,
	0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x57, 0x69, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x0e, 0x0a, 0x0c, 0x52, 0x65, 0x64, 0x61, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe2, 0x02, 0x0a, 0x0d, 0x43, 0x68, 0x61, 0x72,
	0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x63, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x73, 0x54, 0x6f, 0x53, 0x6b, 0x69, 0x70, 0x12, 0x79, 0x0a, 0x1b, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x74,
	0x6f, 0x5f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x73,
	0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43,
	0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x26, 0x0a, 0x22,
	0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x53, 0x5f, 0x54, 0x4f, 0x5f,
	0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52,
	0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4c, 0x50, 0x48, 0x41,
	0x5f, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x50, 0x55, 0x4e, 0x43, 0x54, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0e,
	0x0a, 0x0a, 0x57, 0x48, 0x49, 0x54, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x05, 0x42, 0x0c,
	0x0a, 0x0a, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x22, 0xe5, 0x01, 0x0a,
	0x13, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x54, 0x6f, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x14,
	0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x69, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x52, 0x12, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x18, 0x46, 0x69, 0x78, 0x65, 0x64, 0x53, 0x69,
	0x7a, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x42, 0x0a, 0x0b, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x0b, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x95, 0x02, 0x0a, 0x0f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0xb8, 0x01, 0x0a,
	0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2e, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x2e, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x12, 0x4e, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc7, 0x04, 0x0a, 0x19, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x73, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x46, 0x66, 0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x12, 0x29, 0x0a, 0x0f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0x62, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x72, 0x61, 0x64, 0x69, 0x78, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61, 0x64, 0x69, 0x78, 0x12, 0x4f, 0x0a,
	0x13, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x73, 0x75, 0x72,
	0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0x94,
	0x01, 0x0a, 0x17, 0x46, 0x66, 0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x26, 0x46, 0x46,
	0x58, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x5f, 0x4e, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f,
	0x41, 0x4c, 0x50, 0x48, 0x41, 0x42, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49,
	0x43, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x45, 0x58, 0x41, 0x44, 0x45, 0x43, 0x49, 0x4d,
	0x41, 0x4c, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x41,
	0x53, 0x45, 0x5f, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x4e, 0x55, 0x4d, 0x45,
	0x52, 0x49, 0x43, 0x10, 0x04, 0x42, 0x0a, 0x0a, 0x08, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65,
	0x74, 0x22, 0xfa, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12,
	0x49, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52,
	0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x75, 0x6e,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x09, 0x75, 0x6e, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4b, 0x6d, 0x73, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x57, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x2d,
	0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2b, 0x0a,
	0x12, 0x55, 0x6e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x68, 0x0a, 0x13, 0x4b, 0x6d,
	0x73, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x12, 0x24, 0x0a, 0x0b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x2b, 0x0a, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xf6, 0x01, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68, 0x69,
	0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x70, 0x70, 0x65,
	0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x38, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x41, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xda, 0x02,
	0x0a, 0x17, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x74, 0x0a, 0x0f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0xc8, 0x01, 0x0a, 0x16, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x18, 0x70, 0x72,
	0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x17, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x03, 0x0a, 0x13, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12,
	0x44, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x18, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x70, 0x72, 0x69, 0x6d, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x19, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xd3, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x15,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a,
	0x13, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x75, 0x70, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x59, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x05, 0x0a, 0x0f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xc6, 0x01,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x05, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x5e, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x97, 0x02, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6d, 0x0a, 0x10, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x53, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x3c, 0x0a, 0x0f, 0x4c, 0x6f,
	0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x20, 0x0a,
	0x1c, 0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0xae, 0x01, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x2b, 0x0a, 0x11, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65,
	0x73, 0x22, 0x97, 0x06, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x09, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12,
	0x56, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x15, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x9a,
	0x01, 0x0a, 0x0d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x5e, 0x0a, 0x18, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54,
	0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0xd8, 0x01, 0x0a, 0x19,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0xac, 0x03, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x66, 0x0a,
	0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x02, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49,
	0x64, 0x12, 0x62, 0x0a, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x14, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xcb, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x08, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xaf, 0x01, 0x0a, 0x1a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x63,
	0x0a, 0x12, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x22, 0x6a, 0x0a, 0x22, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x6f, 0x0a,
	0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x1a, 0x72, 0x65, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x08,
	0x0a, 0x06, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x22, 0x89, 0x05, 0x0a, 0x0f, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b,
	0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0xc6, 0x02, 0xea, 0x41,
	0xc2, 0x02, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x40, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d,
	0x12, 0x55, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x7d, 0x22, 0xb0, 0x05, 0x0a, 0x12, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x11, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x10, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x3a, 0xe1, 0x02, 0xea, 0x41, 0xdd, 0x02, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x46, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x7d, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x22, 0x71, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x2c, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3a,
	0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x22, 0xba, 0x07, 0x0a, 0x0a, 0x4a,
	0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x45,
	0x0a, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x08, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x75, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6c, 0x61,
	0x73, 0x74, 0x52, 0x75, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x1a, 0x8c, 0x01, 0x0a, 0x07, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x08,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x6d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x42, 0x09, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22,
	0x48, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41,
	0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x94, 0x01, 0xea, 0x41, 0x90, 0x01,
	0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12,
	0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x7d, 0x12, 0x41, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x7d,
	0x42, 0x05, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0xed, 0x0a, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0d, 0x73, 0x61, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x07, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x50,
	0x75, 0x62, 0x53, 0x75, 0x62, 0x48, 0x00, 0x52, 0x06, 0x70, 0x75, 0x62, 0x53, 0x75, 0x62, 0x12,
	0x6b, 0x0a, 0x17, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x73, 0x63, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x6f,
	0x43, 0x73, 0x63, 0x63, 0x48, 0x00, 0x52, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x6f, 0x43, 0x73, 0x63, 0x63, 0x12, 0x94, 0x01, 0x0a,
	0x26, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x6f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x48, 0x00,
	0x52, 0x21, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x54, 0x6f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x12, 0x4a, 0x0a, 0x0a, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x12,
	0x6d, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x15, 0x6a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6a,
	0x0a, 0x16, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x1a, 0x5f, 0x0a, 0x0c, 0x53, 0x61,
	0x76, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x27, 0x0a, 0x0f, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x1a, 0x16, 0x0a, 0x14, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x6f, 0x43, 0x73, 0x63, 0x63, 0x1a, 0x23, 0x0a, 0x21,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54,
	0x6f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x1a, 0x98, 0x03, 0x0a, 0x0a, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79,
	0x12, 0x60, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x8c, 0x01, 0x0a, 0x25, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x22, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x37, 0x0a, 0x14, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x56, 0x0a, 0x17, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14, 0x66, 0x69,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x54, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0x17, 0x0a, 0x15,
	0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x16, 0x0a, 0x14, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x54, 0x6f, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x42, 0x08, 0x0a,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0x0a, 0x14, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x44, 0x0a, 0x1e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1c, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64,
	0x61, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xfc, 0x01, 0x0a, 0x1c,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x56, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xee, 0x01, 0x0a, 0x1c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x10, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x19, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x12, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9b, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe1, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a,
	0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6a, 0x6f, 0x62, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x56, 0x0a, 0x19, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5,
	0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0a, 0x6a,
	0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x51, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x12, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56,
	0x0a, 0x10, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x49, 0x64, 0x22, 0xf3, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x19, 0x47, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22,
	0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0x9b, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x5e, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa6, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x12,
	0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x49,
	0x0a, 0x08, 0x72, 0x69, 0x73, 0x6b, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x07, 0x72, 0x69, 0x73, 0x6b, 0x4a, 0x6f, 0x62, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x42, 0x05, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x9e, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x87, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0b,
	0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x02, 0x0a, 0x10, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b,
	0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x07,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xcb, 0x06, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x6f, 0x0a, 0x14, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x70, 0x75,
	0x62, 0x53, 0x75, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x53, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x49, 0x0a, 0x0d, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x9a, 0x03, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x12, 0x48, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x10,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x11, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x4f, 0x66, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x51, 0x0a, 0x0b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1c,
	0x0a, 0x18, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45,
	0x10, 0x02, 0x22, 0x75, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x45, 0x57, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x10,
	0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x5f, 0x49, 0x4e, 0x43, 0x52, 0x45,
	0x41, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x04, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x86, 0x02, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x12, 0x5a, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x89, 0x01, 0x0a,
	0x0d, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x28,
	0x0a, 0x10, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x28, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x52, 0x65, 0x67,
	0x65, 0x78, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x49, 0x64, 0x52, 0x65, 0x67, 0x65, 0x78, 0x22, 0x53, 0x0a, 0x0f, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x67, 0x65, 0x78, 0x52, 0x08, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x22, 0x54, 0x0a,
	0x12, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x22, 0x0a, 0x0a, 0x08, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x6b, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x00, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x07, 0x0a,
	0x0f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x6f, 0x72, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4f, 0x72, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6f,
	0x72, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x07, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0d, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x78, 0x0a, 0x09, 0x4f,
	0x72, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x39, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02,
	0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0x77, 0x0a, 0x0f, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22,
	0xd5, 0x02, 0x0a, 0x17, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x07,
	0x63, 0x61, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x63, 0x61, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x08, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x22, 0xf3, 0x01, 0x0a, 0x17, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x6a, 0x0a,
	0x0c, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x41, 0x6c, 0x6c, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x1a, 0x18, 0x0a, 0x16, 0x41, 0x6c, 0x6c,
	0x4f, 0x74, 0x68, 0x65, 0x72, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x77, 0x0a,
	0x17, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0xe0, 0x03, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x0f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0d, 0x6f, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x0c, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x66, 0x0a, 0x0c, 0x4f, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x22, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x52, 0x6f, 0x7