//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbidedicated

import "time"

// AutoScaleVCore - Represents an instance of an auto scale v-core resource.
type AutoScaleVCore struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the auto scale v-core resource.
	SKU *AutoScaleVCoreSKU `json:"sku,omitempty"`

	// Properties of an auto scale v-core resource.
	Properties *AutoScaleVCoreProperties `json:"properties,omitempty"`

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AutoScaleVCoreListResult - An array of auto scale v-core resources.
type AutoScaleVCoreListResult struct {
	// REQUIRED; An array of auto scale v-core resources.
	Value []*AutoScaleVCore `json:"value,omitempty"`
}

// AutoScaleVCoreMutableProperties - An object that represents a set of mutable auto scale v-core resource properties.
type AutoScaleVCoreMutableProperties struct {
	// The maximum capacity of an auto scale v-core resource.
	CapacityLimit *int32 `json:"capacityLimit,omitempty"`
}

// AutoScaleVCoreProperties - Properties of an auto scale v-core resource.
type AutoScaleVCoreProperties struct {
	// The maximum capacity of an auto scale v-core resource.
	CapacityLimit *int32 `json:"capacityLimit,omitempty"`

	// The object ID of the capacity resource associated with the auto scale v-core resource.
	CapacityObjectID *string `json:"capacityObjectId,omitempty"`

	// READ-ONLY; The current deployment state of an auto scale v-core resource. The provisioningState is to indicate states for
	// resource provisioning.
	ProvisioningState *VCoreProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AutoScaleVCoreSKU - Represents the SKU name and Azure pricing tier for auto scale v-core resource.
type AutoScaleVCoreSKU struct {
	// REQUIRED; Name of the SKU level.
	Name *string `json:"name,omitempty"`

	// The capacity of an auto scale v-core resource.
	Capacity *int32 `json:"capacity,omitempty"`

	// The name of the Azure pricing tier to which the SKU applies.
	Tier *VCoreSKUTier `json:"tier,omitempty"`
}

// AutoScaleVCoreUpdateParameters - Update request specification
type AutoScaleVCoreUpdateParameters struct {
	// Properties of the update operation request.
	Properties *AutoScaleVCoreMutableProperties `json:"properties,omitempty"`

	// The SKU of the auto scale v-core resource.
	SKU *AutoScaleVCoreSKU `json:"sku,omitempty"`

	// Key-value pairs of additional provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AutoScaleVCoresClientCreateOptions contains the optional parameters for the AutoScaleVCoresClient.Create method.
type AutoScaleVCoresClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AutoScaleVCoresClientDeleteOptions contains the optional parameters for the AutoScaleVCoresClient.Delete method.
type AutoScaleVCoresClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AutoScaleVCoresClientGetOptions contains the optional parameters for the AutoScaleVCoresClient.Get method.
type AutoScaleVCoresClientGetOptions struct {
	// placeholder for future optional parameters
}

// AutoScaleVCoresClientListByResourceGroupOptions contains the optional parameters for the AutoScaleVCoresClient.ListByResourceGroup
// method.
type AutoScaleVCoresClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AutoScaleVCoresClientListBySubscriptionOptions contains the optional parameters for the AutoScaleVCoresClient.ListBySubscription
// method.
type AutoScaleVCoresClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AutoScaleVCoresClientUpdateOptions contains the optional parameters for the AutoScaleVCoresClient.Update method.
type AutoScaleVCoresClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientBeginCreateOptions contains the optional parameters for the CapacitiesClient.BeginCreate method.
type CapacitiesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacitiesClientBeginDeleteOptions contains the optional parameters for the CapacitiesClient.BeginDelete method.
type CapacitiesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacitiesClientBeginResumeOptions contains the optional parameters for the CapacitiesClient.BeginResume method.
type CapacitiesClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacitiesClientBeginSuspendOptions contains the optional parameters for the CapacitiesClient.BeginSuspend method.
type CapacitiesClientBeginSuspendOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacitiesClientBeginUpdateOptions contains the optional parameters for the CapacitiesClient.BeginUpdate method.
type CapacitiesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacitiesClientCheckNameAvailabilityOptions contains the optional parameters for the CapacitiesClient.CheckNameAvailability
// method.
type CapacitiesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientGetDetailsOptions contains the optional parameters for the CapacitiesClient.GetDetails method.
type CapacitiesClientGetDetailsOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientListByResourceGroupOptions contains the optional parameters for the CapacitiesClient.ListByResourceGroup
// method.
type CapacitiesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientListOptions contains the optional parameters for the CapacitiesClient.List method.
type CapacitiesClientListOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientListSKUsForCapacityOptions contains the optional parameters for the CapacitiesClient.ListSKUsForCapacity
// method.
type CapacitiesClientListSKUsForCapacityOptions struct {
	// placeholder for future optional parameters
}

// CapacitiesClientListSKUsOptions contains the optional parameters for the CapacitiesClient.ListSKUs method.
type CapacitiesClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// CapacitySKU - Represents the SKU name and Azure pricing tier for PowerBI Dedicated capacity resource.
type CapacitySKU struct {
	// REQUIRED; Name of the SKU level.
	Name *string `json:"name,omitempty"`

	// The capacity of the SKU.
	Capacity *int32 `json:"capacity,omitempty"`

	// The name of the Azure pricing tier to which the SKU applies.
	Tier *CapacitySKUTier `json:"tier,omitempty"`
}

// CheckCapacityNameAvailabilityParameters - Details of capacity name request body.
type CheckCapacityNameAvailabilityParameters struct {
	// Name for checking availability.
	Name *string `json:"name,omitempty"`

	// The resource type of PowerBI dedicated.
	Type *string `json:"type,omitempty"`
}

// CheckCapacityNameAvailabilityResult - The checking result of capacity name availability.
type CheckCapacityNameAvailabilityResult struct {
	// The detailed message of the request unavailability.
	Message *string `json:"message,omitempty"`

	// Indicator of availability of the capacity name.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason of unavailability.
	Reason *string `json:"reason,omitempty"`
}

// DedicatedCapacities - An array of Dedicated capacities resources.
type DedicatedCapacities struct {
	// REQUIRED; An array of Dedicated capacities resources.
	Value []*DedicatedCapacity `json:"value,omitempty"`
}

// DedicatedCapacity - Represents an instance of a Dedicated Capacity resource.
type DedicatedCapacity struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the PowerBI Dedicated capacity resource.
	SKU *CapacitySKU `json:"sku,omitempty"`

	// Properties of the provision operation request.
	Properties *DedicatedCapacityProperties `json:"properties,omitempty"`

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DedicatedCapacityAdministrators - An array of administrator user identities
type DedicatedCapacityAdministrators struct {
	// An array of administrator user identities.
	Members []*string `json:"members,omitempty"`
}

// DedicatedCapacityMutableProperties - An object that represents a set of mutable Dedicated capacity resource properties.
type DedicatedCapacityMutableProperties struct {
	// A collection of Dedicated capacity administrators
	Administration *DedicatedCapacityAdministrators `json:"administration,omitempty"`

	// Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used.
	// Learn More
	// [https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2]
	Mode *Mode `json:"mode,omitempty"`

	// READ-ONLY; Capacity name
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; Tenant ID for the capacity. Used for creating Pro Plus capacity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// DedicatedCapacityProperties - Properties of Dedicated Capacity resource.
type DedicatedCapacityProperties struct {
	// A collection of Dedicated capacity administrators
	Administration *DedicatedCapacityAdministrators `json:"administration,omitempty"`

	// Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used.
	// Learn More
	// [https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2]
	Mode *Mode `json:"mode,omitempty"`

	// READ-ONLY; Capacity name
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for
	// resource provisioning.
	ProvisioningState *CapacityProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning.
	State *State `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Tenant ID for the capacity. Used for creating Pro Plus capacity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// DedicatedCapacityUpdateParameters - Provision request specification
type DedicatedCapacityUpdateParameters struct {
	// Properties of the provision operation request.
	Properties *DedicatedCapacityMutableProperties `json:"properties,omitempty"`

	// The SKU of the Dedicated capacity resource.
	SKU *CapacitySKU `json:"sku,omitempty"`

	// Key-value pairs of additional provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// The error object
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - The error object
type ErrorResponseError struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// LogSpecification - Log specification for exposing diagnostic logs to shoebox.
type LogSpecification struct {
	// Localizable name of the log
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; Blob duration for the log
	BlobDuration *string `json:"blobDuration,omitempty" azure:"ro"`

	// READ-ONLY; Name of the log
	Name *string `json:"name,omitempty" azure:"ro"`
}

// MetricSpecification - Metric specification for exposing performance metrics to shoebox.
type MetricSpecification struct {
	// For describing multi dimensional metrics
	Dimensions []*MetricSpecificationDimensionsItem `json:"dimensions,omitempty"`

	// Localizable description of metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localizable metric name
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; Aggregation type for the metric
	AggregationType *string `json:"aggregationType,omitempty" azure:"ro"`

	// READ-ONLY; Pattern used to filter the metric
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty" azure:"ro"`

	// READ-ONLY; Metric name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Unit for the metric
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

type MetricSpecificationDimensionsItem struct {
	// Localizable dimension of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; Dimension of the metric
	Name *string `json:"name,omitempty" azure:"ro"`
}

// Operation - Capacities REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Additional properties to expose performance metrics to shoebox.
	Properties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Origin of the operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Localized description of the operation.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Operation type: create, update, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.PowerBIDedicated.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: capacity, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result listing capacities. It contains a list of operations and a URL link to get the next set of
// results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of capacities supported by the Microsoft.PowerBIDedicated resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationProperties - Additional properties to expose performance metrics to shoebox.
type OperationProperties struct {
	// Service specification for exposing performance metrics to shoebox.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - Represents an instance of an PowerBI Dedicated resource.
type Resource struct {
	// REQUIRED; Location of the PowerBI Dedicated resource.
	Location *string `json:"location,omitempty"`

	// Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`

	// Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; An identifier that represents the PowerBI Dedicated resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the PowerBI Dedicated resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the PowerBI Dedicated resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKUDetailsForExistingResource - An object that represents SKU details for existing resources
type SKUDetailsForExistingResource struct {
	// The resource type
	ResourceType *string `json:"resourceType,omitempty"`

	// The SKU in SKU details for existing resources.
	SKU *CapacitySKU `json:"sku,omitempty"`
}

// SKUEnumerationForExistingResourceResult - An object that represents enumerating SKUs for existing resources
type SKUEnumerationForExistingResourceResult struct {
	// The collection of available SKUs for existing resources
	Value []*SKUDetailsForExistingResource `json:"value,omitempty"`
}

// SKUEnumerationForNewResourceResult - An object that represents enumerating SKUs for new resources
type SKUEnumerationForNewResourceResult struct {
	// The collection of available SKUs for new resources
	Value []*CapacitySKU `json:"value,omitempty"`
}

// ServiceSpecification - Service specification for exposing performance metrics to shoebox.
type ServiceSpecification struct {
	// Log specifications for exposing diagnostic logs to shoebox.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications for exposing performance metrics to shoebox.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource
	CreatedByType *IdentityType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType `json:"lastModifiedByType,omitempty"`
}
