//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/videoanalyzer/armvideoanalyzer"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/access-policy-list.json
func ExampleAccessPoliciesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewAccessPoliciesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("testrg",
		"testaccount2",
		&armvideoanalyzer.AccessPoliciesClientListOptions{Top: to.Ptr[int32](2)})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/access-policy-get.json
func ExampleAccessPoliciesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewAccessPoliciesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"testrg",
		"testaccount2",
		"accessPolicyName1",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/access-policy-create.json
func ExampleAccessPoliciesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewAccessPoliciesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CreateOrUpdate(ctx,
		"testrg",
		"testaccount2",
		"accessPolicyName1",
		armvideoanalyzer.AccessPolicyEntity{
			Properties: &armvideoanalyzer.AccessPolicyProperties{
				Authentication: &armvideoanalyzer.JwtAuthentication{
					Type: to.Ptr("#Microsoft.VideoAnalyzer.JwtAuthentication"),
					Audiences: []*string{
						to.Ptr("audience1")},
					Claims: []*armvideoanalyzer.TokenClaim{
						{
							Name:  to.Ptr("claimname1"),
							Value: to.Ptr("claimvalue1"),
						},
						{
							Name:  to.Ptr("claimname2"),
							Value: to.Ptr("claimvalue2"),
						}},
					Issuers: []*string{
						to.Ptr("issuer1"),
						to.Ptr("issuer2")},
					Keys: []armvideoanalyzer.TokenKeyClassification{
						&armvideoanalyzer.RsaTokenKey{
							Type: to.Ptr("#Microsoft.VideoAnalyzer.RsaTokenKey"),
							Kid:  to.Ptr("123"),
							Alg:  to.Ptr(armvideoanalyzer.AccessPolicyRsaAlgoRS256),
							E:    to.Ptr("ZLFzZTY0IQ=="),
							N:    to.Ptr("YmFzZTY0IQ=="),
						},
						&armvideoanalyzer.EccTokenKey{
							Type: to.Ptr("#Microsoft.VideoAnalyzer.EccTokenKey"),
							Kid:  to.Ptr("124"),
							Alg:  to.Ptr(armvideoanalyzer.AccessPolicyEccAlgoES256),
							X:    to.Ptr("XX=="),
							Y:    to.Ptr("YY=="),
						}},
				},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/access-policy-delete.json
func ExampleAccessPoliciesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewAccessPoliciesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"testrg",
		"testaccount2",
		"accessPolicyName1",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/videoanalyzer/resource-manager/Microsoft.Media/preview/2021-11-01-preview/examples/access-policy-patch.json
func ExampleAccessPoliciesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armvideoanalyzer.NewAccessPoliciesClient("591e76c3-3e97-44db-879c-3e2b12961b62", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Update(ctx,
		"testrg",
		"testaccount2",
		"accessPolicyName1",
		armvideoanalyzer.AccessPolicyEntity{
			Properties: &armvideoanalyzer.AccessPolicyProperties{
				Authentication: &armvideoanalyzer.JwtAuthentication{
					Type: to.Ptr("#Microsoft.VideoAnalyzer.JwtAuthentication"),
					Audiences: []*string{
						to.Ptr("audience1")},
					Claims: []*armvideoanalyzer.TokenClaim{
						{
							Name:  to.Ptr("claimname1"),
							Value: to.Ptr("claimvalue1"),
						},
						{
							Name:  to.Ptr("claimname2"),
							Value: to.Ptr("claimvalue2"),
						}},
					Issuers: []*string{
						to.Ptr("issuer1"),
						to.Ptr("issuer2")},
					Keys: []armvideoanalyzer.TokenKeyClassification{
						&armvideoanalyzer.RsaTokenKey{
							Type: to.Ptr("#Microsoft.VideoAnalyzer.RsaTokenKey"),
							Kid:  to.Ptr("123"),
							Alg:  to.Ptr(armvideoanalyzer.AccessPolicyRsaAlgoRS256),
							E:    to.Ptr("ZLFzZTY0IQ=="),
							N:    to.Ptr("YmFzZTY0IQ=="),
						},
						&armvideoanalyzer.EccTokenKey{
							Type: to.Ptr("#Microsoft.VideoAnalyzer.EccTokenKey"),
							Kid:  to.Ptr("124"),
							Alg:  to.Ptr(armvideoanalyzer.AccessPolicyEccAlgoES256),
							X:    to.Ptr("XX=="),
							Y:    to.Ptr("YY=="),
						}},
				},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
