// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the VOD sources contained in a source location. A source represents a
// piece of content.
func (c *Client) ListVodSources(ctx context.Context, params *ListVodSourcesInput, optFns ...func(*Options)) (*ListVodSourcesOutput, error) {
	if params == nil {
		params = &ListVodSourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVodSources", params, optFns, c.addOperationListVodSourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVodSourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVodSourcesInput struct {

	// The name of the source location associated with this VOD Source list.
	//
	// This member is required.
	SourceLocationName *string

	//  The maximum number of VOD sources that you want MediaTailor to return in
	// response to the current request. If there are more than MaxResults VOD sources,
	// use the value of NextToken in the response to get the next page of results.
	MaxResults *int32

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVodSourcesOutput struct {

	// Lists the VOD sources.
	Items []types.VodSource

	// Pagination token returned by the list request when results exceed the maximum
	// allowed. Use the token to fetch the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVodSourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVodSources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVodSources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVodSources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListVodSourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVodSources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVodSourcesAPIClient is a client that implements the ListVodSources
// operation.
type ListVodSourcesAPIClient interface {
	ListVodSources(context.Context, *ListVodSourcesInput, ...func(*Options)) (*ListVodSourcesOutput, error)
}

var _ ListVodSourcesAPIClient = (*Client)(nil)

// ListVodSourcesPaginatorOptions is the paginator options for ListVodSources
type ListVodSourcesPaginatorOptions struct {
	//  The maximum number of VOD sources that you want MediaTailor to return in
	// response to the current request. If there are more than MaxResults VOD sources,
	// use the value of NextToken in the response to get the next page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVodSourcesPaginator is a paginator for ListVodSources
type ListVodSourcesPaginator struct {
	options   ListVodSourcesPaginatorOptions
	client    ListVodSourcesAPIClient
	params    *ListVodSourcesInput
	nextToken *string
	firstPage bool
}

// NewListVodSourcesPaginator returns a new ListVodSourcesPaginator
func NewListVodSourcesPaginator(client ListVodSourcesAPIClient, params *ListVodSourcesInput, optFns ...func(*ListVodSourcesPaginatorOptions)) *ListVodSourcesPaginator {
	if params == nil {
		params = &ListVodSourcesInput{}
	}

	options := ListVodSourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVodSourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVodSourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVodSources page.
func (p *ListVodSourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVodSourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListVodSources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVodSources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVodSources",
	}
}
