// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents action metadata added to an Action dataset using the PutActions API.
// For more information see [Importing actions individually].
//
// [Importing actions individually]: https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html
type Action struct {

	// The ID associated with the action.
	//
	// This member is required.
	ActionId *string

	// A string map of action-specific metadata. Each element in the map consists of a
	// key-value pair. For example, {"value": "100"} .
	//
	// The keys use camel case names that match the fields in the schema for the
	// Actions dataset. In the previous example, the value matches the 'VALUE' field
	// defined in the Actions schema. For categorical string data, to include multiple
	// categories for a single action, separate each category with a pipe separator ( |
	// ). For example, \"Deluxe|Premium\" .
	//
	// This value conforms to the media type: application/json
	Properties *string

	noSmithyDocumentSerde
}

// Represents an action interaction event sent using the PutActionInteractions API.
type ActionInteraction struct {

	// The ID of the action the user interacted with. This corresponds to the ACTION_ID
	// field of the Action interaction schema.
	//
	// This member is required.
	ActionId *string

	// The type of action interaction event. You can specify Viewed , Taken , and Not
	// Taken event types. For more information about action interaction event type
	// data, see [Event type data].
	//
	// [Event type data]: https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html
	//
	// This member is required.
	EventType *string

	// The ID associated with the user's visit. Your application generates a unique
	// sessionId when a user first visits your website or uses your application.
	//
	// This member is required.
	SessionId *string

	// The timestamp for when the action interaction event occurred. Timestamps must
	// be in Unix epoch time format, in seconds.
	//
	// This member is required.
	Timestamp *time.Time

	// An ID associated with the event. If an event ID is not provided, Amazon
	// Personalize generates a unique ID for the event. An event ID is not used as an
	// input to the model. Amazon Personalize uses the event ID to distinguish unique
	// events. Any subsequent events after the first with the same event ID are not
	// used in model training.
	EventId *string

	// A list of action IDs that represents the sequence of actions you have shown the
	// user. For example, ["actionId1", "actionId2", "actionId3"] . Amazon Personalize
	// doesn't use impressions data from action interaction events. Instead, record
	// multiple events for each action and use the Viewed event type.
	Impression []string

	// A string map of event-specific data that you might choose to record. For
	// example, if a user takes an action, other than the action ID, you might also
	// send the number of actions taken by the user.
	//
	// Each item in the map consists of a key-value pair. For example,
	//
	//     {"numberOfActions": "12"}
	//
	// The keys use camel case names that match the fields in the Action interactions
	// schema. In the above example, the numberOfActions would match the
	// 'NUMBER_OF_ACTIONS' field defined in the Action interactions schema.
	//
	// The following can't be included as a keyword for properties (case insensitive).
	//
	//   - userId
	//
	//   - sessionId
	//
	//   - eventType
	//
	//   - timestamp
	//
	//   - recommendationId
	//
	//   - impression
	//
	// This value conforms to the media type: application/json
	Properties *string

	// The ID of the list of recommendations that contains the action the user
	// interacted with.
	RecommendationId *string

	// The ID of the user who interacted with the action. This corresponds to the
	// USER_ID field of the Action interaction schema.
	UserId *string

	noSmithyDocumentSerde
}

// Represents item interaction event information sent using the PutEvents API.
type Event struct {

	// The type of event, such as click or download. This property corresponds to the
	// EVENT_TYPE field of your Item interactions dataset's schema and depends on the
	// types of events you are tracking.
	//
	// This member is required.
	EventType *string

	// The timestamp (in Unix time) on the client side when the event occurred.
	//
	// This member is required.
	SentAt *time.Time

	// An ID associated with the event. If an event ID is not provided, Amazon
	// Personalize generates a unique ID for the event. An event ID is not used as an
	// input to the model. Amazon Personalize uses the event ID to distinguish unique
	// events. Any subsequent events after the first with the same event ID are not
	// used in model training.
	EventId *string

	// The event value that corresponds to the EVENT_VALUE field of the Item
	// interactions schema.
	EventValue *float32

	// A list of item IDs that represents the sequence of items you have shown the
	// user. For example, ["itemId1", "itemId2", "itemId3"] . Provide a list of items
	// to manually record impressions data for an event. For more information on
	// recording impressions data, see [Recording impressions data].
	//
	// [Recording impressions data]: https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data
	Impression []string

	// The item ID key that corresponds to the ITEM_ID field of the Item interactions
	// dataset's schema.
	ItemId *string

	// Contains information about the metric attribution associated with an event. For
	// more information about metric attributions, see [Measuring impact of recommendations].
	//
	// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
	MetricAttribution *MetricAttribution

	// A string map of event-specific data that you might choose to record. For
	// example, if a user rates a movie on your site, other than movie ID ( itemId )
	// and rating ( eventValue ) , you might also send the number of movie ratings made
	// by the user.
	//
	// Each item in the map consists of a key-value pair. For example,
	//
	//     {"numberOfRatings": "12"}
	//
	// The keys use camel case names that match the fields in the Item interactions
	// dataset's schema. In the above example, the numberOfRatings would match the
	// 'NUMBER_OF_RATINGS' field defined in the Item interactions dataset's schema.
	//
	// The following can't be included as a keyword for properties (case insensitive).
	//
	//   - userId
	//
	//   - sessionId
	//
	//   - eventType
	//
	//   - timestamp
	//
	//   - recommendationId
	//
	//   - impression
	//
	// This value conforms to the media type: application/json
	Properties *string

	// The ID of the list of recommendations that contains the item the user
	// interacted with. Provide a recommendationId to have Amazon Personalize
	// implicitly record the recommendations you show your user as impressions data. Or
	// provide a recommendationId if you use a metric attribution to measure the
	// impact of recommendations.
	//
	// For more information on recording impressions data, see [Recording impressions data]. For more information
	// on creating a metric attribution see [Measuring impact of recommendations].
	//
	// [Recording impressions data]: https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html#putevents-including-impressions-data
	// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
	RecommendationId *string

	noSmithyDocumentSerde
}

// Represents item metadata added to an Items dataset using the PutItems API. For
// more information see [Importing items individually].
//
// [Importing items individually]: https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html
type Item struct {

	// The ID associated with the item.
	//
	// This member is required.
	ItemId *string

	// A string map of item-specific metadata. Each element in the map consists of a
	// key-value pair. For example, {"numberOfRatings": "12"} .
	//
	// The keys use camel case names that match the fields in the schema for the Items
	// dataset. In the previous example, the numberOfRatings matches the
	// 'NUMBER_OF_RATINGS' field defined in the Items schema. For categorical string
	// data, to include multiple categories for a single item, separate each category
	// with a pipe separator ( | ). For example, \"Horror|Action\" .
	//
	// This value conforms to the media type: application/json
	Properties *string

	noSmithyDocumentSerde
}

// Contains information about a metric attribution associated with an event. For
// more information about metric attributions, see [Measuring impact of recommendations].
//
// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
type MetricAttribution struct {

	// The source of the event, such as a third party.
	//
	// This member is required.
	EventAttributionSource *string

	noSmithyDocumentSerde
}

// Represents user metadata added to a Users dataset using the PutUsers API. For
// more information see [Importing users individually].
//
// [Importing users individually]: https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html
type User struct {

	// The ID associated with the user.
	//
	// This member is required.
	UserId *string

	// A string map of user-specific metadata. Each element in the map consists of a
	// key-value pair. For example, {"numberOfVideosWatched": "45"} .
	//
	// The keys use camel case names that match the fields in the schema for the Users
	// dataset. In the previous example, the numberOfVideosWatched matches the
	// 'NUMBER_OF_VIDEOS_WATCHED' field defined in the Users schema. For categorical
	// string data, to include multiple categories for a single user, separate each
	// category with a pipe separator ( | ). For example, \"Member|Frequent shopper\" .
	//
	// This value conforms to the media type: application/json
	Properties *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
