// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an set of chat controls configured for an existing Amazon Q Business
// application.
func (c *Client) UpdateChatControlsConfiguration(ctx context.Context, params *UpdateChatControlsConfigurationInput, optFns ...func(*Options)) (*UpdateChatControlsConfigurationOutput, error) {
	if params == nil {
		params = &UpdateChatControlsConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateChatControlsConfiguration", params, optFns, c.addOperationUpdateChatControlsConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateChatControlsConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateChatControlsConfigurationInput struct {

	// The identifier of the application for which the chat controls are configured.
	//
	// This member is required.
	ApplicationId *string

	// The phrases blocked from chat by your chat control configuration.
	BlockedPhrasesConfigurationUpdate *types.BlockedPhrasesConfigurationUpdate

	// A token that you provide to identify the request to update a Amazon Q Business
	// application chat configuration.
	ClientToken *string

	// The configuration details for CREATOR_MODE .
	CreatorModeConfiguration *types.CreatorModeConfiguration

	// The response scope configured for your application. This determines whether
	// your application uses its retrieval augmented generation (RAG) system to
	// generate answers only from your enterprise data, or also uses the large language
	// models (LLM) knowledge to respons to end user questions in chat.
	ResponseScope types.ResponseScope

	// The configured topic specific chat controls you want to update.
	TopicConfigurationsToCreateOrUpdate []types.TopicConfiguration

	// The configured topic specific chat controls you want to delete.
	TopicConfigurationsToDelete []types.TopicConfiguration

	noSmithyDocumentSerde
}

type UpdateChatControlsConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateChatControlsConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateChatControlsConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateChatControlsConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateChatControlsConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateChatControlsConfigurationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateChatControlsConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateChatControlsConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateChatControlsConfiguration struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateChatControlsConfiguration) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateChatControlsConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateChatControlsConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateChatControlsConfigurationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateChatControlsConfigurationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateChatControlsConfiguration{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateChatControlsConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateChatControlsConfiguration",
	}
}
