// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends an email message. You can use the Amazon SES API v2 to send the following
// types of messages:
//
//   - Simple – A standard email message. When you create this type of message,
//     you specify the sender, the recipient, and the message body, and Amazon SES
//     assembles the message for you.
//
//   - Raw – A raw, MIME-formatted email message. When you send this type of
//     email, you have to specify all of the message headers, as well as the message
//     body. You can use this message type to send messages that contain attachments.
//     The message that you specify has to be a valid MIME message.
//
//   - Templated – A message that contains personalization tags. When you send
//     this type of email, Amazon SES API v2 automatically replaces the tags with
//     values that you specify.
func (c *Client) SendEmail(ctx context.Context, params *SendEmailInput, optFns ...func(*Options)) (*SendEmailOutput, error) {
	if params == nil {
		params = &SendEmailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SendEmail", params, optFns, c.addOperationSendEmailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SendEmailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to send a single formatted email using Amazon SES. For
// more information, see the [Amazon SES Developer Guide].
//
// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html
type SendEmailInput struct {

	// An object that contains the body of the message. You can send either a Simple
	// message, Raw message, or a Templated message.
	//
	// This member is required.
	Content *types.EmailContent

	// The name of the configuration set to use when sending the email.
	ConfigurationSetName *string

	// An object that contains the recipients of the email message.
	Destination *types.Destination

	// A list of tags, in the form of name/value pairs, to apply to an email that you
	// send using the SendEmail operation. Tags correspond to characteristics of the
	// email that you define, so that you can publish email sending events.
	EmailTags []types.MessageTag

	// The address that you want bounce and complaint notifications to be sent to.
	FeedbackForwardingEmailAddress *string

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FeedbackForwardingEmailAddress
	// parameter.
	//
	// For example, if the owner of example.com (which has ARN
	// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it
	// that authorizes you to use feedback@example.com, then you would specify the
	// FeedbackForwardingEmailAddressIdentityArn to be
	// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
	// FeedbackForwardingEmailAddress to be feedback@example.com.
	//
	// For more information about sending authorization, see the [Amazon SES Developer Guide].
	//
	// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html
	FeedbackForwardingEmailAddressIdentityArn *string

	// The email address to use as the "From" address for the email. The address that
	// you specify has to be verified.
	FromEmailAddress *string

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FromEmailAddress parameter.
	//
	// For example, if the owner of example.com (which has ARN
	// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it
	// that authorizes you to use sender@example.com, then you would specify the
	// FromEmailAddressIdentityArn to be
	// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
	// FromEmailAddress to be sender@example.com.
	//
	// For more information about sending authorization, see the [Amazon SES Developer Guide].
	//
	// For Raw emails, the FromEmailAddressIdentityArn value overrides the
	// X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message
	// content.
	//
	// [Amazon SES Developer Guide]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html
	FromEmailAddressIdentityArn *string

	// An object used to specify a list or topic to which an email belongs, which will
	// be used when a contact chooses to unsubscribe.
	ListManagementOptions *types.ListManagementOptions

	// The "Reply-to" email addresses for the message. When the recipient replies to
	// the message, each Reply-to address receives the reply.
	ReplyToAddresses []string

	noSmithyDocumentSerde
}

// A unique message ID that you receive when an email is accepted for sending.
type SendEmailOutput struct {

	// A unique identifier for the message that is generated when the message is
	// accepted.
	//
	// It's possible for Amazon SES to accept a message without sending it. For
	// example, this can happen when the message that you're trying to send has an
	// attachment that contains a virus, or when you send a templated email that
	// contains invalid personalization content.
	MessageId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSendEmailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSendEmail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSendEmail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SendEmail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSendEmailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSendEmail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSendEmail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SendEmail",
	}
}
