// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmcontacts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmcontacts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List details about a specific contact channel.
func (c *Client) GetContactChannel(ctx context.Context, params *GetContactChannelInput, optFns ...func(*Options)) (*GetContactChannelOutput, error) {
	if params == nil {
		params = &GetContactChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetContactChannel", params, optFns, c.addOperationGetContactChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetContactChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetContactChannelInput struct {

	// The Amazon Resource Name (ARN) of the contact channel you want information
	// about.
	//
	// This member is required.
	ContactChannelId *string

	noSmithyDocumentSerde
}

type GetContactChannelOutput struct {

	// The ARN of the contact that the channel belongs to.
	//
	// This member is required.
	ContactArn *string

	// The ARN of the contact channel.
	//
	// This member is required.
	ContactChannelArn *string

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// This member is required.
	DeliveryAddress *types.ContactChannelAddress

	// The name of the contact channel
	//
	// This member is required.
	Name *string

	// The type of contact channel. The type is SMS , VOICE , or EMAIL .
	//
	// This member is required.
	Type types.ChannelType

	// A Boolean value indicating if the contact channel has been activated or not.
	ActivationStatus types.ActivationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetContactChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetContactChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetContactChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetContactChannel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetContactChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetContactChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetContactChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetContactChannel",
	}
}
