// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"context"
	"fmt"

	"code.forgejo.org/f3/gof3/v3/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

func NewProjectPathString[U, P any](owners string, user U, project P) string {
	return fmt.Sprintf("/forge/%s/%v/projects/%v", owners, user, project)
}

func NewProjectReference[U, P any](owners string, user U, project P) *f3.Reference {
	return f3.NewReference(NewProjectPathString(owners, user, project))
}

func ResolveProjectReference(ctx context.Context, tree generic.TreeInterface, r *f3.Reference) (string, string) {
	project := tree.Find(generic.NewPathFromString(r.Get()))
	if project == generic.NilNode {
		panic(fmt.Errorf("%s not found", r.Get()))
	}
	return GetOwnerName(project), GetProjectName(project)
}
