// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The health check for the instance that's specified by ServiceId and InstanceId
// isn't a custom health check.
type CustomHealthNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CustomHealthNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomHealthNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomHealthNotFound) ErrorCode() string             { return "CustomHealthNotFound" }
func (e *CustomHealthNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation is already in progress.
type DuplicateRequest struct {
	Message *string

	DuplicateOperationId *string

	noSmithyDocumentSerde
}

func (e *DuplicateRequest) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateRequest) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateRequest) ErrorCode() string             { return "DuplicateRequest" }
func (e *DuplicateRequest) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No instance exists with the specified ID, or the instance was recently
// registered, and information about the instance hasn't propagated yet.
type InstanceNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceNotFound) ErrorCode() string             { return "InstanceNotFound" }
func (e *InstanceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more specified values aren't valid. For example, a required value might
// be missing, a numeric value might be outside the allowed range, or a string
// value might exceed length constraints.
type InvalidInput struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidInput) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInput) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInput) ErrorCode() string             { return "InvalidInput" }
func (e *InvalidInput) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The namespace that you're trying to create already exists.
type NamespaceAlreadyExists struct {
	Message *string

	CreatorRequestId *string
	NamespaceId      *string

	noSmithyDocumentSerde
}

func (e *NamespaceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NamespaceAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NamespaceAlreadyExists) ErrorCode() string             { return "NamespaceAlreadyExists" }
func (e *NamespaceAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No namespace exists with the specified ID.
type NamespaceNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NamespaceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NamespaceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NamespaceNotFound) ErrorCode() string             { return "NamespaceNotFound" }
func (e *NamespaceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No operation exists with the specified ID.
type OperationNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OperationNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotFound) ErrorCode() string             { return "OperationNotFound" }
func (e *OperationNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation can't be completed because you've reached the quota for the number
// of requests. For more information, see Cloud Map API request throttling quota
// (https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html) in the Cloud
// Map Developer Guide.
type RequestLimitExceeded struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RequestLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RequestLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RequestLimitExceeded) ErrorCode() string             { return "RequestLimitExceeded" }
func (e *RequestLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource can't be deleted because it contains other resources. For
// example, you can't delete a service that contains any instances.
type ResourceInUse struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUse) ErrorCode() string             { return "ResourceInUse" }
func (e *ResourceInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource can't be created because you've reached the quota on the number of
// resources.
type ResourceLimitExceeded struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceLimitExceeded) ErrorCode() string             { return "ResourceLimitExceeded" }
func (e *ResourceLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation can't be completed because the resource was not found.
type ResourceNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The service can't be created because a service with the same name already
// exists.
type ServiceAlreadyExists struct {
	Message *string

	CreatorRequestId *string
	ServiceId        *string

	noSmithyDocumentSerde
}

func (e *ServiceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceAlreadyExists) ErrorCode() string             { return "ServiceAlreadyExists" }
func (e *ServiceAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No service exists with the specified ID.
type ServiceNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ServiceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceNotFound) ErrorCode() string             { return "ServiceNotFound" }
func (e *ServiceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The list of tags on the resource is over the quota. The maximum number of tags
// that can be applied to a resource is 50.
type TooManyTagsException struct {
	Message *string

	ResourceName *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string             { return "TooManyTagsException" }
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
