// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Call Analytics category. All categories are automatically applied
// to your Call Analytics jobs. Note that in order to apply your categories to your
// jobs, you must create them before submitting your job request, as categories
// cannot be applied retroactively. Call Analytics categories are composed of
// rules. For each category, you must create between 1 and 20 rules. Rules can
// include these parameters: , , , and . To update an existing category, see . To
// learn more about:
//
// * Call Analytics categories, see Creating categories
// (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html)
//
// *
// Using rules, see Rule criteria
// (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules)
// and refer to the data type
//
// * Call Analytics, see Analyzing call center audio
// with Call Analytics
// (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html)
func (c *Client) CreateCallAnalyticsCategory(ctx context.Context, params *CreateCallAnalyticsCategoryInput, optFns ...func(*Options)) (*CreateCallAnalyticsCategoryOutput, error) {
	if params == nil {
		params = &CreateCallAnalyticsCategoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCallAnalyticsCategory", params, optFns, c.addOperationCreateCallAnalyticsCategoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCallAnalyticsCategoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCallAnalyticsCategoryInput struct {

	// A unique name, chosen by you, for your Call Analytics category. It's helpful to
	// use a detailed naming system that will make sense to you in the future. For
	// example, it's better to use sentiment-positive-last30seconds for a category over
	// a generic name like test-category. Category names are case sensitive.
	//
	// This member is required.
	CategoryName *string

	// Rules define a Call Analytics category. When creating a new Call Analytics
	// category, you must create between 1 and 20 rules for that category. For each
	// rule, you specify a filter you want applied to the attributes of a call. For
	// example, you can choose a sentiment filter that detects if a customer's
	// sentiment was positive during the last 30 seconds of the call.
	//
	// This member is required.
	Rules []types.Rule

	noSmithyDocumentSerde
}

type CreateCallAnalyticsCategoryOutput struct {

	// Provides you with the properties of your new category, including its associated
	// rules.
	CategoryProperties *types.CategoryProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCallAnalyticsCategoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateCallAnalyticsCategory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateCallAnalyticsCategory{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateCallAnalyticsCategoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCallAnalyticsCategory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCallAnalyticsCategory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "CreateCallAnalyticsCategory",
	}
}
