// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains summary information about an actor in an AgentCore Memory resource.
type ActorSummary struct {

	// The unique identifier of the actor.
	//
	// This member is required.
	ActorId *string

	noSmithyDocumentSerde
}

// The configuration for a stream that enables programmatic control of a browser
// session in Amazon Bedrock. This stream provides a bidirectional communication
// channel for sending commands to the browser and receiving responses, allowing
// agents to automate web interactions such as navigation, form filling, and
// element clicking.
type AutomationStream struct {

	// The endpoint URL for the automation stream. This URL is used to establish a
	// WebSocket connection to the stream for sending commands and receiving responses.
	//
	// This member is required.
	StreamEndpoint *string

	// The current status of the automation stream. This indicates whether the stream
	// is available for use. Possible values include ACTIVE, CONNECTING, and
	// DISCONNECTED.
	//
	// This member is required.
	StreamStatus AutomationStreamStatus

	noSmithyDocumentSerde
}

// Contains information about an update to an automation stream.
type AutomationStreamUpdate struct {

	// The status of the automation stream.
	StreamStatus AutomationStreamStatus

	noSmithyDocumentSerde
}

// Contains information about a branch in an AgentCore Memory resource. Branches
// allow for organizing events into different conversation threads or paths.
type Branch struct {

	// The name of the branch.
	//
	// This member is required.
	Name *string

	// The identifier of the root event for this branch.
	RootEventId *string

	noSmithyDocumentSerde
}

// Contains filter criteria for branches when listing events.
type BranchFilter struct {

	// The name of the branch to filter by.
	//
	// This member is required.
	Name *string

	// Specifies whether to include parent branches in the results. Set to true to
	// include parent branches, or false to exclude them.
	IncludeParentBranches *bool

	noSmithyDocumentSerde
}

// The collection of streams associated with a browser session in Amazon Bedrock.
// These streams provide different ways to interact with and observe the browser
// session, including programmatic control and visual representation of the browser
// content.
type BrowserSessionStream struct {

	// The stream that enables programmatic control of the browser. This stream allows
	// agents to perform actions such as navigating to URLs, clicking elements, and
	// filling forms.
	//
	// This member is required.
	AutomationStream *AutomationStream

	// The stream that provides a visual representation of the browser content. This
	// stream allows agents to observe the current state of the browser, including
	// rendered web pages and visual elements.
	LiveViewStream *LiveViewStream

	noSmithyDocumentSerde
}

// A condensed representation of a browser session in Amazon Bedrock. This
// structure contains key information about a browser session, including
// identifiers, status, and timestamps, without the full details of the session
// configuration and streams.
type BrowserSessionSummary struct {

	// The unique identifier of the browser associated with the session. This
	// identifier specifies which browser environment is used for the session.
	//
	// This member is required.
	BrowserIdentifier *string

	// The timestamp when the browser session was created. This value is in ISO 8601
	// format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the browser session. This identifier is used in
	// operations that interact with the session.
	//
	// This member is required.
	SessionId *string

	// The current status of the browser session. Possible values include ACTIVE,
	// STOPPING, and STOPPED.
	//
	// This member is required.
	Status BrowserSessionStatus

	// The timestamp when the browser session was last updated. This value is in ISO
	// 8601 format.
	LastUpdatedAt *time.Time

	// The name of the browser session. This name helps identify and manage the
	// session.
	Name *string

	noSmithyDocumentSerde
}

// The output produced by executing code in a code interpreter session in Amazon
// Bedrock. This structure contains the results of code execution, including
// textual output, structured data, and error information. Agents use these results
// to generate responses that incorporate computation, data analysis, and
// visualization.
type CodeInterpreterResult struct {

	// The textual content of the execution result. This includes standard output from
	// the code execution, such as print statements, console output, and text
	// representations of results.
	//
	// This member is required.
	Content []ContentBlock

	// Indicates whether the result represents an error. If true, the content contains
	// error messages or exception information. If false, the content contains
	// successful execution results.
	IsError *bool

	// The structured content of the execution result. This includes additional
	// metadata about the execution, such as execution time, memory usage, and
	// structured representations of output data. The format depends on the specific
	// code interpreter and execution context.
	StructuredContent *ToolResultStructuredContent

	noSmithyDocumentSerde
}

// A condensed representation of a code interpreter session in Amazon Bedrock.
// This structure contains key information about a code interpreter session,
// including identifiers, status, and timestamps, without the full details of the
// session configuration.
type CodeInterpreterSessionSummary struct {

	// The unique identifier of the code interpreter associated with the session. This
	// identifier specifies which code interpreter environment is used for the session.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The timestamp when the code interpreter session was created. This value is in
	// ISO 8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the code interpreter session. This identifier is used
	// in operations that interact with the session.
	//
	// This member is required.
	SessionId *string

	// The current status of the code interpreter session. Possible values include
	// ACTIVE, STOPPING, and STOPPED.
	//
	// This member is required.
	Status CodeInterpreterSessionStatus

	// The timestamp when the code interpreter session was last updated. This value is
	// in ISO 8601 format.
	LastUpdatedAt *time.Time

	// The name of the code interpreter session. This name helps identify and manage
	// the session.
	Name *string

	noSmithyDocumentSerde
}

// Contains output from a code interpreter stream.
//
// The following types satisfy this interface:
//
//	CodeInterpreterStreamOutputMemberResult
type CodeInterpreterStreamOutput interface {
	isCodeInterpreterStreamOutput()
}

// The output produced by executing code in a code interpreter session in Amazon
// Bedrock. This structure contains the results of code execution, including
// textual output, structured data, and error information. Agents use these results
// to generate responses that incorporate computation, data analysis, and
// visualization.
type CodeInterpreterStreamOutputMemberResult struct {
	Value CodeInterpreterResult

	noSmithyDocumentSerde
}

func (*CodeInterpreterStreamOutputMemberResult) isCodeInterpreterStreamOutput() {}

// Contains the content of a memory item.
//
// The following types satisfy this interface:
//
//	ContentMemberText
type Content interface {
	isContent()
}

// The text content of the memory item.
type ContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentMemberText) isContent() {}

// A block of content in a response.
type ContentBlock struct {

	// The type of content in the block.
	//
	// This member is required.
	Type ContentBlockType

	// The binary data content of the block.
	Data []byte

	// The description of the content block.
	Description *string

	// The MIME type of the content.
	MimeType *string

	// The name of the content block.
	Name *string

	// The resource associated with the content block.
	Resource *ResourceContent

	// The size of the content in bytes.
	Size *int64

	// The text content of the block.
	Text *string

	// The URI of the content.
	Uri *string

	noSmithyDocumentSerde
}

// Contains conversational content for an event payload.
type Conversational struct {

	// The content of the conversation message.
	//
	// This member is required.
	Content Content

	// The role of the participant in the conversation (for example, "user" or
	// "assistant").
	//
	// This member is required.
	Role Role

	noSmithyDocumentSerde
}

// Contains information about an event in an AgentCore Memory resource.
type Event struct {

	// The identifier of the actor associated with the event.
	//
	// This member is required.
	ActorId *string

	// The unique identifier of the event.
	//
	// This member is required.
	EventId *string

	// The timestamp when the event occurred.
	//
	// This member is required.
	EventTimestamp *time.Time

	// The identifier of the AgentCore Memory resource containing the event.
	//
	// This member is required.
	MemoryId *string

	// The content payload of the event.
	//
	// This member is required.
	Payload []PayloadType

	// The identifier of the session containing the event.
	//
	// This member is required.
	SessionId *string

	// The branch information for the event.
	Branch *Branch

	noSmithyDocumentSerde
}

// Contains filter criteria for listing events.
type FilterInput struct {

	// The branch filter criteria to apply when listing events.
	Branch *BranchFilter

	noSmithyDocumentSerde
}

// A block of input content.
type InputContentBlock struct {

	// The path to the input content.
	//
	// This member is required.
	Path *string

	// The binary input content.
	Blob []byte

	// The text input content.
	Text *string

	noSmithyDocumentSerde
}

// The configuration for a stream that provides a visual representation of a
// browser session in Amazon Bedrock. This stream enables agents to observe the
// current state of the browser, including rendered web pages, visual elements, and
// the results of interactions.
type LiveViewStream struct {

	// The endpoint URL for the live view stream. This URL is used to establish a
	// connection to receive visual updates from the browser session.
	StreamEndpoint *string

	noSmithyDocumentSerde
}

// Contains the content of a memory record.
//
// The following types satisfy this interface:
//
//	MemoryContentMemberText
type MemoryContent interface {
	isMemoryContent()
}

// The text content of the memory record.
type MemoryContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemoryContentMemberText) isMemoryContent() {}

// Contains information about a memory record in an AgentCore Memory resource.
type MemoryRecord struct {

	// The content of the memory record.
	//
	// This member is required.
	Content MemoryContent

	// The timestamp when the memory record was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the memory record.
	//
	// This member is required.
	MemoryRecordId *string

	// The identifier of the memory strategy associated with this record.
	//
	// This member is required.
	MemoryStrategyId *string

	// The namespaces associated with this memory record. Namespaces help organize and
	// categorize memory records.
	//
	// This member is required.
	Namespaces []string

	noSmithyDocumentSerde
}

// Contains summary information about a memory record.
type MemoryRecordSummary struct {

	// The content of the memory record.
	//
	// This member is required.
	Content MemoryContent

	// The timestamp when the memory record was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the memory record.
	//
	// This member is required.
	MemoryRecordId *string

	// The identifier of the memory strategy associated with this record.
	//
	// This member is required.
	MemoryStrategyId *string

	// The namespaces associated with this memory record.
	//
	// This member is required.
	Namespaces []string

	// The relevance score of the memory record when returned as part of a search
	// result. Higher values indicate greater relevance to the search query.
	Score *float64

	noSmithyDocumentSerde
}

// Contains the payload content for an event.
//
// The following types satisfy this interface:
//
//	PayloadTypeMemberBlob
//	PayloadTypeMemberConversational
type PayloadType interface {
	isPayloadType()
}

// The binary content of the payload.
type PayloadTypeMemberBlob struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*PayloadTypeMemberBlob) isPayloadType() {}

// The conversational content of the payload.
type PayloadTypeMemberConversational struct {
	Value Conversational

	noSmithyDocumentSerde
}

func (*PayloadTypeMemberConversational) isPayloadType() {}

// Contains information about resource content.
type ResourceContent struct {

	// The type of resource content.
	//
	// This member is required.
	Type ResourceContentType

	// The binary resource content.
	Blob []byte

	// The MIME type of the resource content.
	MimeType *string

	// The text resource content.
	Text *string

	// The URI of the resource content.
	Uri *string

	noSmithyDocumentSerde
}

// Contains search criteria for retrieving memory records.
type SearchCriteria struct {

	// The search query to use for finding relevant memory records.
	//
	// This member is required.
	SearchQuery *string

	// The memory strategy identifier to filter memory records by.
	MemoryStrategyId *string

	// The maximum number of top-scoring memory records to return. This value is used
	// for semantic search ranking.
	TopK *int32

	noSmithyDocumentSerde
}

// Contains summary information about a session in an AgentCore Memory resource.
type SessionSummary struct {

	// The identifier of the actor associated with the session.
	//
	// This member is required.
	ActorId *string

	// The timestamp when the session was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the session.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

// Contains information about an update to a stream.
//
// The following types satisfy this interface:
//
//	StreamUpdateMemberAutomationStreamUpdate
type StreamUpdate interface {
	isStreamUpdate()
}

// The update to an automation stream.
type StreamUpdateMemberAutomationStreamUpdate struct {
	Value AutomationStreamUpdate

	noSmithyDocumentSerde
}

func (*StreamUpdateMemberAutomationStreamUpdate) isStreamUpdate() {}

// The collection of arguments that specify the operation to perform and its
// parameters when invoking a tool in Amazon Bedrock. Different tools require
// different arguments, and this structure provides a flexible way to pass the
// appropriate arguments to each tool type.
type ToolArguments struct {

	// Whether to clear the context for the tool.
	ClearContext *bool

	// The code to execute in a code interpreter session. This is the source code in
	// the specified programming language that will be executed by the code
	// interpreter.
	Code *string

	// The command to execute with the tool.
	Command *string

	// The content for the tool operation.
	Content []InputContentBlock

	// The directory path for the tool operation.
	DirectoryPath *string

	// The programming language of the code to execute. This tells the code
	// interpreter which language runtime to use for execution. Common values include
	// 'python', 'javascript', and 'r'.
	Language ProgrammingLanguage

	// The path for the tool operation.
	Path *string

	// The paths for the tool operation.
	Paths []string

	// The identifier of the task for the tool operation.
	TaskId *string

	noSmithyDocumentSerde
}

// Contains structured content from a tool result.
type ToolResultStructuredContent struct {

	// The execution time of the tool operation in milliseconds.
	ExecutionTime *float64

	// The exit code from the tool execution.
	ExitCode *int32

	// The standard error output from the tool execution.
	Stderr *string

	// The standard output from the tool execution.
	Stdout *string

	// The identifier of the task that produced the result.
	TaskId *string

	// The status of the task that produced the result.
	TaskStatus TaskStatus

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The configuration that defines the dimensions of a browser viewport in a
// browser session. The viewport determines the visible area of web content and
// affects how web pages are rendered and displayed. Proper viewport configuration
// ensures that web content is displayed correctly for the agent's browsing tasks.
type ViewPort struct {

	// The height of the viewport in pixels. This value determines the vertical
	// dimension of the visible area. Valid values range from 600 to 1080 pixels.
	//
	// This member is required.
	Height *int32

	// The width of the viewport in pixels. This value determines the horizontal
	// dimension of the visible area. Valid values range from 800 to 1920 pixels.
	//
	// This member is required.
	Width *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCodeInterpreterStreamOutput() {}
func (*UnknownUnionMember) isContent()                     {}
func (*UnknownUnionMember) isMemoryContent()               {}
func (*UnknownUnionMember) isPayloadType()                 {}
func (*UnknownUnionMember) isStreamUpdate()                {}
