// Code generated by smithy-go-codegen DO NOT EDIT.

package braket

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/braket/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the specified Amazon Braket hybrid job.
func (c *Client) GetJob(ctx context.Context, params *GetJobInput, optFns ...func(*Options)) (*GetJobOutput, error) {
	if params == nil {
		params = &GetJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetJob", params, optFns, c.addOperationGetJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetJobInput struct {

	// The ARN of the hybrid job to retrieve.
	//
	// This member is required.
	JobArn *string

	// A list of attributes to return additional information for. Only the QueueInfo
	// additional attribute name is currently supported.
	AdditionalAttributeNames []types.HybridJobAdditionalAttributeName

	noSmithyDocumentSerde
}

type GetJobOutput struct {

	// Definition of the Amazon Braket hybrid job created. Provides information about
	// the container image used, and the Python scripts used for training.
	//
	// This member is required.
	AlgorithmSpecification *types.AlgorithmSpecification

	// The time at which the Amazon Braket hybrid job was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The resource instances to use while running the hybrid job on Amazon Braket.
	//
	// This member is required.
	InstanceConfig *types.InstanceConfig

	// The ARN of the Amazon Braket hybrid job.
	//
	// This member is required.
	JobArn *string

	// The name of the Amazon Braket hybrid job.
	//
	// This member is required.
	JobName *string

	// The path to the S3 location where hybrid job artifacts are stored and the
	// encryption key used to store them there.
	//
	// This member is required.
	OutputDataConfig *types.JobOutputDataConfig

	// The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to
	// perform tasks on behalf of a user. It can access user resources, run an Amazon
	// Braket job container on behalf of user, and output results and other hybrid job
	// details to the s3 buckets of a user.
	//
	// This member is required.
	RoleArn *string

	// The status of the Amazon Braket hybrid job.
	//
	// This member is required.
	Status types.JobPrimaryStatus

	// The list of Amazon Braket resources associated with the hybrid job.
	Associations []types.Association

	// The billable time for which the Amazon Braket hybrid job used to complete.
	BillableDuration *int32

	// Information about the output locations for hybrid job checkpoint data.
	CheckpointConfig *types.JobCheckpointConfig

	// The primary device used by the Amazon Braket hybrid job.
	DeviceConfig *types.DeviceConfig

	// The time at which the Amazon Braket hybrid job ended.
	EndedAt *time.Time

	// Details about the time and type of events occurred related to the Amazon Braket
	// hybrid job.
	Events []types.JobEventDetails

	// A description of the reason why an Amazon Braket hybrid job failed, if it
	// failed.
	FailureReason *string

	// Algorithm-specific parameters used by an Amazon Braket hybrid job that
	// influence the quality of the traiing job. The values are set with a map of JSON
	// key:value pairs, where the key is the name of the hyperparameter and the value
	// is the value of th hyperparameter.
	HyperParameters map[string]string

	// A list of parameters that specify the name and type of input data and where it
	// is located.
	InputDataConfig []types.InputFileConfig

	// Queue information for the requested hybrid job. Only returned if QueueInfo is
	// specified in the additionalAttributeNames" field in the GetJob API request.
	QueueInfo *types.HybridJobQueueInfo

	// The time at which the Amazon Braket hybrid job was started.
	StartedAt *time.Time

	// The user-defined criteria that specifies when to stop a running hybrid job.
	StoppingCondition *types.JobStoppingCondition

	// The tags associated with this hybrid job.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetJob",
	}
}
