// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an edge in a Neptune Analytics graph.
type EdgeStructure struct {

	// The number of instances of the edge in the graph.
	Count *int64

	// A list of the properties associated with the edge.
	EdgeProperties []string

	noSmithyDocumentSerde
}

// This is the top-level field for specifying vertex or edge filters. If the
// ExportFilter is not provided, then all properties for all labels will be
// exported. If the ExportFilter is provided but is an empty object, then no data
// will be exported.
type ExportFilter struct {

	// Used to specify filters on a per-label basis for edges. This allows you to
	// control which edge labels and properties are included in the export.
	EdgeFilter map[string]ExportFilterElement

	// Used to specify filters on a per-label basis for vertices. This allows you to
	// control which vertex labels and properties are included in the export.
	VertexFilter map[string]ExportFilterElement

	noSmithyDocumentSerde
}

// Specifies whihc properties of that label should be included in the export.
type ExportFilterElement struct {

	// Each property is defined by a key-value pair, where the key is the desired
	// output property name (e.g. "name"), and the value is an object.
	Properties map[string]ExportFilterPropertyAttributes

	noSmithyDocumentSerde
}

// A structure representing a property's attributes. It is a map object of
// outputType, sourcePropertyName and multiValueHandling.
type ExportFilterPropertyAttributes struct {

	// Specifies how to handle properties that have multiple values. Can be either
	// TO_LIST to export all values as a list, or PICK_FIRST to export the first value
	// encountered. If not specified, the default value is PICK_FIRST .
	MultiValueHandling MultiValueHandlingType

	// Specifies the data type to use for the property in the exported data (e.g.
	// "String", "Int", "Float"). If a type is not provided, the export process will
	// determine the type. If a given property is present as multiple types (e.g. one
	// vertex has "height" stored as a double, and another edge has it stored as a
	// string), the type will be of Any type, otherwise, it will be the type of the
	// property as present in vertices.
	OutputType *string

	// The name of the property as it exists in the original graph data. If not
	// provided, it is assumed that the key matches the desired sourcePropertyName.
	SourcePropertyName *string

	noSmithyDocumentSerde
}

// Contains details about the specified export task.
type ExportTaskDetails struct {

	// The number of progress percentage of the export task.
	//
	// This member is required.
	ProgressPercentage *int32

	// The start time of the export task.
	//
	// This member is required.
	StartTime *time.Time

	// The time elapsed, in seconds, since the start time of the export task.
	//
	// This member is required.
	TimeElapsedSeconds *int64

	// The number of exported edges.
	NumEdgesWritten *int64

	// The number of exported vertices.
	NumVerticesWritten *int64

	noSmithyDocumentSerde
}

// Provides details about an export task.
type ExportTaskSummary struct {

	// The Amazon S3 URI of the export task where data will be exported to.
	//
	// This member is required.
	Destination *string

	// The format of the export task.
	//
	// This member is required.
	Format ExportFormat

	// The source graph identifier of the export task.
	//
	// This member is required.
	GraphId *string

	// The KMS key identifier of the export task.
	//
	// This member is required.
	KmsKeyIdentifier *string

	// The ARN of the IAM role that will allow the data to be exported to the
	// destination.
	//
	// This member is required.
	RoleArn *string

	// The current status of the export task.
	//
	// This member is required.
	Status ExportTaskStatus

	// The unique identifier of the export task.
	//
	// This member is required.
	TaskId *string

	// The parquet type of the export task.
	ParquetType ParquetType

	// The reason that the export task has this status value.
	StatusReason *string

	noSmithyDocumentSerde
}

// Summary information about the graph.
type GraphDataSummary struct {

	// A list of the edge labels in the graph.
	EdgeLabels []string

	// A list of the distinct edge properties in the graph, along with the count of
	// edges where each property is used.
	EdgeProperties []map[string]int64

	// This field is only present when the requested mode is DETAILED. It contains a
	// list of edge structures.
	EdgeStructures []EdgeStructure

	// A list of distinct node labels in the graph.
	NodeLabels []string

	// A list of the distinct node properties in the graph, along with the count of
	// nodes where each property is used.
	NodeProperties []map[string]int64

	// This field is only present when the requested mode is DETAILED. It contains a
	// list of node structures.
	NodeStructures []NodeStructure

	// The number of unique edge labels in the graph.
	NumEdgeLabels *int64

	// The number of edge properties in the graph.
	NumEdgeProperties *int64

	// The number of edges in the graph.
	NumEdges *int64

	// The number of distinct node labels in the graph.
	NumNodeLabels *int64

	// The number of distinct node properties in the graph.
	NumNodeProperties *int64

	// The number of nodes in the graph.
	NumNodes *int64

	// The total number of usages of all edge properties.
	TotalEdgePropertyValues *int64

	// The total number of usages of all node properties.
	TotalNodePropertyValues *int64

	noSmithyDocumentSerde
}

// Details about a graph snapshot.
type GraphSnapshotSummary struct {

	// The ARN of the graph snapshot.
	//
	// This member is required.
	Arn *string

	// The unique identifier of the graph snapshot.
	//
	// This member is required.
	Id *string

	// The snapshot name. For example: my-snapshot-1 .
	//
	// The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
	// character must be a letter. It cannot end with a hyphen or contain two
	// consecutive hyphens. Only lowercase letters are allowed.
	//
	// This member is required.
	Name *string

	// The ID of the KMS key used to encrypt and decrypt the snapshot.
	KmsKeyIdentifier *string

	// The time when the snapshot was created.
	SnapshotCreateTime *time.Time

	// The graph identifier for the graph for which a snapshot is to be created.
	SourceGraphId *string

	// The status of the graph snapshot.
	Status SnapshotStatus

	noSmithyDocumentSerde
}

// Summary details about a graph.
type GraphSummary struct {

	// The ARN associated with the graph.
	//
	// This member is required.
	Arn *string

	// The unique identifier of the graph.
	//
	// This member is required.
	Id *string

	// The name of the graph.
	//
	// This member is required.
	Name *string

	// If true , deletion protection is enabled for the graph.
	DeletionProtection *bool

	// The graph endpoint.
	Endpoint *string

	// The ID of the KMS key used to encrypt and decrypt graph data.
	KmsKeyIdentifier *string

	// The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the
	// graph.
	ProvisionedMemory *int32

	// If true , the graph has a public endpoint, otherwise not.
	PublicConnectivity *bool

	// The number of replicas for the graph.
	ReplicaCount *int32

	// The status of the graph.
	Status GraphStatus

	noSmithyDocumentSerde
}

// Options for how to perform an import.
//
// The following types satisfy this interface:
//
//	ImportOptionsMemberNeptune
type ImportOptions interface {
	isImportOptions()
}

// Options for importing data from a Neptune database.
type ImportOptionsMemberNeptune struct {
	Value NeptuneImportOptions

	noSmithyDocumentSerde
}

func (*ImportOptionsMemberNeptune) isImportOptions() {}

// Contains details about an import task.
type ImportTaskDetails struct {

	// The number of dictionary entries in the import task.
	//
	// This member is required.
	DictionaryEntryCount *int64

	// The number of errors encountered so far.
	//
	// This member is required.
	ErrorCount *int32

	// The percentage progress so far.
	//
	// This member is required.
	ProgressPercentage *int32

	// Time at which the import task started.
	//
	// This member is required.
	StartTime *time.Time

	// The number of statements in the import task.
	//
	// This member is required.
	StatementCount *int64

	// Status of the import task.
	//
	// This member is required.
	Status *string

	// Seconds elapsed since the import task started.
	//
	// This member is required.
	TimeElapsedSeconds *int64

	// Details about the errors that have been encountered.
	ErrorDetails *string

	noSmithyDocumentSerde
}

// Details about an import task.
type ImportTaskSummary struct {

	// The ARN of the IAM role that will allow access to the data that is to be
	// imported.
	//
	// This member is required.
	RoleArn *string

	// A URL identifying to the location of the data to be imported. This can be an
	// Amazon S3 path, or can point to a Neptune database endpoint or snapshot
	//
	// This member is required.
	Source *string

	// Status of the import task.
	//
	// This member is required.
	Status ImportTaskStatus

	// The unique identifier of the import task.
	//
	// This member is required.
	TaskId *string

	// Specifies the format of S3 data to be imported. Valid values are CSV , which
	// identifies the [Gremlin CSV format]or OPENCYPHER , which identies the [openCypher load format].
	//
	// [Gremlin CSV format]: https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html
	// [openCypher load format]: https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html
	Format Format

	// The unique identifier of the Neptune Analytics graph.
	GraphId *string

	// The parquet type of the import task.
	ParquetType ParquetType

	noSmithyDocumentSerde
}

// Options for how to import Neptune data.
type NeptuneImportOptions struct {

	// The KMS key to use to encrypt data in the S3 bucket where the graph data is
	// exported
	//
	// This member is required.
	S3ExportKmsKeyId *string

	// The path to an S3 bucket from which to import data.
	//
	// This member is required.
	S3ExportPath *string

	// Neptune Analytics supports label-less vertices and no labels are assigned
	// unless one is explicitly provided. Neptune assigns default labels when none is
	// explicitly provided. When importing the data into Neptune Analytics, the default
	// vertex labels can be omitted by setting preserveDefaultVertexLabels to false.
	// Note that if the vertex only has default labels, and has no other properties or
	// edges, then the vertex will effectively not get imported into Neptune Analytics
	// when preserveDefaultVertexLabels is set to false.
	PreserveDefaultVertexLabels *bool

	// Neptune Analytics currently does not support user defined edge ids. The edge
	// ids are not imported by default. They are imported if preserveEdgeIds is set to
	// true, and ids are stored as properties on the relationships with the property
	// name neptuneEdgeId.
	PreserveEdgeIds *bool

	noSmithyDocumentSerde
}

// Information about a node.
type NodeStructure struct {

	// The number of instances of this node.
	Count *int64

	// The outgoing edge labels associated with this node.
	DistinctOutgoingEdgeLabels []string

	// Properties associated with this node.
	NodeProperties []string

	noSmithyDocumentSerde
}

// Details about a private graph endpoint.
type PrivateGraphEndpointSummary struct {

	// The status of the private graph endpoint.
	//
	// This member is required.
	Status PrivateGraphEndpointStatus

	// The subnet IDs associated with the private graph endpoint.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the VPC in which the private graph endpoint is located.
	//
	// This member is required.
	VpcId *string

	// The ID of the VPC endpoint.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// Details of the query listed.
type QuerySummary struct {

	// The running time of the query, in milliseconds.
	Elapsed *int32

	// A string representation of the id of the query.
	Id *string

	// The actual query text. The queryString may be truncated if the actual query
	// string is too long.
	QueryString *string

	// State of the query.
	State QueryState

	// The amount of time, in milliseconds, the query has waited in the queue before
	// being picked up by a worker thread.
	Waited *int32

	noSmithyDocumentSerde
}

// Specifies the number of dimensions for vector embeddings loaded into the graph.
// Max = 65535
type VectorSearchConfiguration struct {

	// The number of dimensions.
	//
	// This member is required.
	Dimension *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isImportOptions() {}
