// Code generated by smithy-go-codegen DO NOT EDIT.

package verifiedpermissions

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/verifiedpermissions/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson10_serializeOpBatchGetPolicy struct {
}

func (*awsAwsjson10_serializeOpBatchGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpBatchGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.BatchGetPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentBatchGetPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpBatchIsAuthorized struct {
}

func (*awsAwsjson10_serializeOpBatchIsAuthorized) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpBatchIsAuthorized) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchIsAuthorizedInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.BatchIsAuthorized")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentBatchIsAuthorizedInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpBatchIsAuthorizedWithToken struct {
}

func (*awsAwsjson10_serializeOpBatchIsAuthorizedWithToken) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpBatchIsAuthorizedWithToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchIsAuthorizedWithTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.BatchIsAuthorizedWithToken")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentBatchIsAuthorizedWithTokenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateIdentitySource struct {
}

func (*awsAwsjson10_serializeOpCreateIdentitySource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateIdentitySource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIdentitySourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.CreateIdentitySource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateIdentitySourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreatePolicy struct {
}

func (*awsAwsjson10_serializeOpCreatePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreatePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.CreatePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreatePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreatePolicyStore struct {
}

func (*awsAwsjson10_serializeOpCreatePolicyStore) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreatePolicyStore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePolicyStoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.CreatePolicyStore")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreatePolicyStoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreatePolicyTemplate struct {
}

func (*awsAwsjson10_serializeOpCreatePolicyTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreatePolicyTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePolicyTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.CreatePolicyTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreatePolicyTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteIdentitySource struct {
}

func (*awsAwsjson10_serializeOpDeleteIdentitySource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteIdentitySource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentitySourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.DeleteIdentitySource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteIdentitySourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeletePolicy struct {
}

func (*awsAwsjson10_serializeOpDeletePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeletePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.DeletePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeletePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeletePolicyStore struct {
}

func (*awsAwsjson10_serializeOpDeletePolicyStore) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeletePolicyStore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyStoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.DeletePolicyStore")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeletePolicyStoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeletePolicyTemplate struct {
}

func (*awsAwsjson10_serializeOpDeletePolicyTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeletePolicyTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.DeletePolicyTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeletePolicyTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetIdentitySource struct {
}

func (*awsAwsjson10_serializeOpGetIdentitySource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetIdentitySource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentitySourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.GetIdentitySource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetIdentitySourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetPolicy struct {
}

func (*awsAwsjson10_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.GetPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetPolicyStore struct {
}

func (*awsAwsjson10_serializeOpGetPolicyStore) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetPolicyStore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyStoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.GetPolicyStore")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetPolicyStoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetPolicyTemplate struct {
}

func (*awsAwsjson10_serializeOpGetPolicyTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetPolicyTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.GetPolicyTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetPolicyTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetSchema struct {
}

func (*awsAwsjson10_serializeOpGetSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.GetSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpIsAuthorized struct {
}

func (*awsAwsjson10_serializeOpIsAuthorized) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpIsAuthorized) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IsAuthorizedInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.IsAuthorized")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentIsAuthorizedInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpIsAuthorizedWithToken struct {
}

func (*awsAwsjson10_serializeOpIsAuthorizedWithToken) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpIsAuthorizedWithToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IsAuthorizedWithTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.IsAuthorizedWithToken")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentIsAuthorizedWithTokenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListIdentitySources struct {
}

func (*awsAwsjson10_serializeOpListIdentitySources) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListIdentitySources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentitySourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.ListIdentitySources")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListIdentitySourcesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListPolicies struct {
}

func (*awsAwsjson10_serializeOpListPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.ListPolicies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListPoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListPolicyStores struct {
}

func (*awsAwsjson10_serializeOpListPolicyStores) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListPolicyStores) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPolicyStoresInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.ListPolicyStores")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListPolicyStoresInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListPolicyTemplates struct {
}

func (*awsAwsjson10_serializeOpListPolicyTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListPolicyTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPolicyTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.ListPolicyTemplates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListPolicyTemplatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpPutSchema struct {
}

func (*awsAwsjson10_serializeOpPutSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpPutSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.PutSchema")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentPutSchemaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateIdentitySource struct {
}

func (*awsAwsjson10_serializeOpUpdateIdentitySource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateIdentitySource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIdentitySourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.UpdateIdentitySource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateIdentitySourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdatePolicy struct {
}

func (*awsAwsjson10_serializeOpUpdatePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdatePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.UpdatePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdatePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdatePolicyStore struct {
}

func (*awsAwsjson10_serializeOpUpdatePolicyStore) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdatePolicyStore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePolicyStoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.UpdatePolicyStore")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdatePolicyStoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdatePolicyTemplate struct {
}

func (*awsAwsjson10_serializeOpUpdatePolicyTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdatePolicyTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePolicyTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("VerifiedPermissions.UpdatePolicyTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdatePolicyTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentActionIdentifier(v *types.ActionIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionId != nil {
		ok := object.Key("actionId")
		ok.String(*v.ActionId)
	}

	if v.ActionType != nil {
		ok := object.Key("actionType")
		ok.String(*v.ActionType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentAttributeValue(v types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AttributeValueMemberBoolean:
		av := object.Key("boolean")
		av.Boolean(uv.Value)

	case *types.AttributeValueMemberDecimal:
		av := object.Key("decimal")
		av.String(uv.Value)

	case *types.AttributeValueMemberEntityIdentifier:
		av := object.Key("entityIdentifier")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(&uv.Value, av); err != nil {
			return err
		}

	case *types.AttributeValueMemberIpaddr:
		av := object.Key("ipaddr")
		av.String(uv.Value)

	case *types.AttributeValueMemberLong:
		av := object.Key("long")
		av.Long(uv.Value)

	case *types.AttributeValueMemberRecord:
		av := object.Key("record")
		if err := awsAwsjson10_serializeDocumentRecordAttribute(uv.Value, av); err != nil {
			return err
		}

	case *types.AttributeValueMemberSet:
		av := object.Key("set")
		if err := awsAwsjson10_serializeDocumentSetAttribute(uv.Value, av); err != nil {
			return err
		}

	case *types.AttributeValueMemberString:
		av := object.Key("string")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentAudiences(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentBatchGetPolicyInputItem(v *types.BatchGetPolicyInputItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyId != nil {
		ok := object.Key("policyId")
		ok.String(*v.PolicyId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeDocumentBatchGetPolicyInputList(v []types.BatchGetPolicyInputItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentBatchGetPolicyInputItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentBatchIsAuthorizedInputItem(v *types.BatchIsAuthorizedInputItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsAwsjson10_serializeDocumentActionIdentifier(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("context")
		if err := awsAwsjson10_serializeDocumentContextDefinition(v.Context, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Principal, ok); err != nil {
			return err
		}
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentBatchIsAuthorizedInputList(v []types.BatchIsAuthorizedInputItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentBatchIsAuthorizedInputItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentBatchIsAuthorizedWithTokenInputItem(v *types.BatchIsAuthorizedWithTokenInputItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsAwsjson10_serializeDocumentActionIdentifier(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("context")
		if err := awsAwsjson10_serializeDocumentContextDefinition(v.Context, ok); err != nil {
			return err
		}
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentBatchIsAuthorizedWithTokenInputList(v []types.BatchIsAuthorizedWithTokenInputItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentBatchIsAuthorizedWithTokenInputItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentClientIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentCognitoGroupConfiguration(v *types.CognitoGroupConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupEntityType != nil {
		ok := object.Key("groupEntityType")
		ok.String(*v.GroupEntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCognitoUserPoolConfiguration(v *types.CognitoUserPoolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientIds != nil {
		ok := object.Key("clientIds")
		if err := awsAwsjson10_serializeDocumentClientIds(v.ClientIds, ok); err != nil {
			return err
		}
	}

	if v.GroupConfiguration != nil {
		ok := object.Key("groupConfiguration")
		if err := awsAwsjson10_serializeDocumentCognitoGroupConfiguration(v.GroupConfiguration, ok); err != nil {
			return err
		}
	}

	if v.UserPoolArn != nil {
		ok := object.Key("userPoolArn")
		ok.String(*v.UserPoolArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentConfiguration(v types.Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ConfigurationMemberCognitoUserPoolConfiguration:
		av := object.Key("cognitoUserPoolConfiguration")
		if err := awsAwsjson10_serializeDocumentCognitoUserPoolConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.ConfigurationMemberOpenIdConnectConfiguration:
		av := object.Key("openIdConnectConfiguration")
		if err := awsAwsjson10_serializeDocumentOpenIdConnectConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentContextDefinition(v types.ContextDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ContextDefinitionMemberCedarJson:
		av := object.Key("cedarJson")
		av.String(uv.Value)

	case *types.ContextDefinitionMemberContextMap:
		av := object.Key("contextMap")
		if err := awsAwsjson10_serializeDocumentContextMap(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentContextMap(v map[string]types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentAttributeValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentEntitiesDefinition(v types.EntitiesDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EntitiesDefinitionMemberCedarJson:
		av := object.Key("cedarJson")
		av.String(uv.Value)

	case *types.EntitiesDefinitionMemberEntityList:
		av := object.Key("entityList")
		if err := awsAwsjson10_serializeDocumentEntityList(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentEntityAttributes(v map[string]types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentAttributeValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentEntityIdentifier(v *types.EntityIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("entityId")
		ok.String(*v.EntityId)
	}

	if v.EntityType != nil {
		ok := object.Key("entityType")
		ok.String(*v.EntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentEntityItem(v *types.EntityItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson10_serializeDocumentEntityAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Identifier != nil {
		ok := object.Key("identifier")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Identifier, ok); err != nil {
			return err
		}
	}

	if v.Parents != nil {
		ok := object.Key("parents")
		if err := awsAwsjson10_serializeDocumentParentList(v.Parents, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentEntityList(v []types.EntityItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentEntityItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentEntityReference(v types.EntityReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EntityReferenceMemberIdentifier:
		av := object.Key("identifier")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityReferenceMemberUnspecified:
		av := object.Key("unspecified")
		av.Boolean(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentIdentitySourceFilter(v *types.IdentitySourceFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrincipalEntityType != nil {
		ok := object.Key("principalEntityType")
		ok.String(*v.PrincipalEntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentIdentitySourceFilters(v []types.IdentitySourceFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentIdentitySourceFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentOpenIdConnectAccessTokenConfiguration(v *types.OpenIdConnectAccessTokenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audiences != nil {
		ok := object.Key("audiences")
		if err := awsAwsjson10_serializeDocumentAudiences(v.Audiences, ok); err != nil {
			return err
		}
	}

	if v.PrincipalIdClaim != nil {
		ok := object.Key("principalIdClaim")
		ok.String(*v.PrincipalIdClaim)
	}

	return nil
}

func awsAwsjson10_serializeDocumentOpenIdConnectConfiguration(v *types.OpenIdConnectConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityIdPrefix != nil {
		ok := object.Key("entityIdPrefix")
		ok.String(*v.EntityIdPrefix)
	}

	if v.GroupConfiguration != nil {
		ok := object.Key("groupConfiguration")
		if err := awsAwsjson10_serializeDocumentOpenIdConnectGroupConfiguration(v.GroupConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Issuer != nil {
		ok := object.Key("issuer")
		ok.String(*v.Issuer)
	}

	if v.TokenSelection != nil {
		ok := object.Key("tokenSelection")
		if err := awsAwsjson10_serializeDocumentOpenIdConnectTokenSelection(v.TokenSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentOpenIdConnectGroupConfiguration(v *types.OpenIdConnectGroupConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupClaim != nil {
		ok := object.Key("groupClaim")
		ok.String(*v.GroupClaim)
	}

	if v.GroupEntityType != nil {
		ok := object.Key("groupEntityType")
		ok.String(*v.GroupEntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentOpenIdConnectIdentityTokenConfiguration(v *types.OpenIdConnectIdentityTokenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientIds != nil {
		ok := object.Key("clientIds")
		if err := awsAwsjson10_serializeDocumentClientIds(v.ClientIds, ok); err != nil {
			return err
		}
	}

	if v.PrincipalIdClaim != nil {
		ok := object.Key("principalIdClaim")
		ok.String(*v.PrincipalIdClaim)
	}

	return nil
}

func awsAwsjson10_serializeDocumentOpenIdConnectTokenSelection(v types.OpenIdConnectTokenSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.OpenIdConnectTokenSelectionMemberAccessTokenOnly:
		av := object.Key("accessTokenOnly")
		if err := awsAwsjson10_serializeDocumentOpenIdConnectAccessTokenConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.OpenIdConnectTokenSelectionMemberIdentityTokenOnly:
		av := object.Key("identityTokenOnly")
		if err := awsAwsjson10_serializeDocumentOpenIdConnectIdentityTokenConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentParentList(v []types.EntityIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentPolicyDefinition(v types.PolicyDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PolicyDefinitionMemberStatic:
		av := object.Key("static")
		if err := awsAwsjson10_serializeDocumentStaticPolicyDefinition(&uv.Value, av); err != nil {
			return err
		}

	case *types.PolicyDefinitionMemberTemplateLinked:
		av := object.Key("templateLinked")
		if err := awsAwsjson10_serializeDocumentTemplateLinkedPolicyDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentPolicyFilter(v *types.PolicyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyTemplateId != nil {
		ok := object.Key("policyTemplateId")
		ok.String(*v.PolicyTemplateId)
	}

	if len(v.PolicyType) > 0 {
		ok := object.Key("policyType")
		ok.String(string(v.PolicyType))
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsAwsjson10_serializeDocumentEntityReference(v.Principal, ok); err != nil {
			return err
		}
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityReference(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRecordAttribute(v map[string]types.AttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentAttributeValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentSchemaDefinition(v types.SchemaDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SchemaDefinitionMemberCedarJson:
		av := object.Key("cedarJson")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentSetAttribute(v []types.AttributeValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentAttributeValue(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStaticPolicyDefinition(v *types.StaticPolicyDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Statement != nil {
		ok := object.Key("statement")
		ok.String(*v.Statement)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTemplateLinkedPolicyDefinition(v *types.TemplateLinkedPolicyDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyTemplateId != nil {
		ok := object.Key("policyTemplateId")
		ok.String(*v.PolicyTemplateId)
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Principal, ok); err != nil {
			return err
		}
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateCognitoGroupConfiguration(v *types.UpdateCognitoGroupConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupEntityType != nil {
		ok := object.Key("groupEntityType")
		ok.String(*v.GroupEntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateCognitoUserPoolConfiguration(v *types.UpdateCognitoUserPoolConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientIds != nil {
		ok := object.Key("clientIds")
		if err := awsAwsjson10_serializeDocumentClientIds(v.ClientIds, ok); err != nil {
			return err
		}
	}

	if v.GroupConfiguration != nil {
		ok := object.Key("groupConfiguration")
		if err := awsAwsjson10_serializeDocumentUpdateCognitoGroupConfiguration(v.GroupConfiguration, ok); err != nil {
			return err
		}
	}

	if v.UserPoolArn != nil {
		ok := object.Key("userPoolArn")
		ok.String(*v.UserPoolArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateConfiguration(v types.UpdateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.UpdateConfigurationMemberCognitoUserPoolConfiguration:
		av := object.Key("cognitoUserPoolConfiguration")
		if err := awsAwsjson10_serializeDocumentUpdateCognitoUserPoolConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.UpdateConfigurationMemberOpenIdConnectConfiguration:
		av := object.Key("openIdConnectConfiguration")
		if err := awsAwsjson10_serializeDocumentUpdateOpenIdConnectConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentUpdateOpenIdConnectAccessTokenConfiguration(v *types.UpdateOpenIdConnectAccessTokenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audiences != nil {
		ok := object.Key("audiences")
		if err := awsAwsjson10_serializeDocumentAudiences(v.Audiences, ok); err != nil {
			return err
		}
	}

	if v.PrincipalIdClaim != nil {
		ok := object.Key("principalIdClaim")
		ok.String(*v.PrincipalIdClaim)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateOpenIdConnectConfiguration(v *types.UpdateOpenIdConnectConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityIdPrefix != nil {
		ok := object.Key("entityIdPrefix")
		ok.String(*v.EntityIdPrefix)
	}

	if v.GroupConfiguration != nil {
		ok := object.Key("groupConfiguration")
		if err := awsAwsjson10_serializeDocumentUpdateOpenIdConnectGroupConfiguration(v.GroupConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Issuer != nil {
		ok := object.Key("issuer")
		ok.String(*v.Issuer)
	}

	if v.TokenSelection != nil {
		ok := object.Key("tokenSelection")
		if err := awsAwsjson10_serializeDocumentUpdateOpenIdConnectTokenSelection(v.TokenSelection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateOpenIdConnectGroupConfiguration(v *types.UpdateOpenIdConnectGroupConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupClaim != nil {
		ok := object.Key("groupClaim")
		ok.String(*v.GroupClaim)
	}

	if v.GroupEntityType != nil {
		ok := object.Key("groupEntityType")
		ok.String(*v.GroupEntityType)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateOpenIdConnectIdentityTokenConfiguration(v *types.UpdateOpenIdConnectIdentityTokenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientIds != nil {
		ok := object.Key("clientIds")
		if err := awsAwsjson10_serializeDocumentClientIds(v.ClientIds, ok); err != nil {
			return err
		}
	}

	if v.PrincipalIdClaim != nil {
		ok := object.Key("principalIdClaim")
		ok.String(*v.PrincipalIdClaim)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateOpenIdConnectTokenSelection(v types.UpdateOpenIdConnectTokenSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.UpdateOpenIdConnectTokenSelectionMemberAccessTokenOnly:
		av := object.Key("accessTokenOnly")
		if err := awsAwsjson10_serializeDocumentUpdateOpenIdConnectAccessTokenConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.UpdateOpenIdConnectTokenSelectionMemberIdentityTokenOnly:
		av := object.Key("identityTokenOnly")
		if err := awsAwsjson10_serializeDocumentUpdateOpenIdConnectIdentityTokenConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentUpdatePolicyDefinition(v types.UpdatePolicyDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.UpdatePolicyDefinitionMemberStatic:
		av := object.Key("static")
		if err := awsAwsjson10_serializeDocumentUpdateStaticPolicyDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentUpdateStaticPolicyDefinition(v *types.UpdateStaticPolicyDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Statement != nil {
		ok := object.Key("statement")
		ok.String(*v.Statement)
	}

	return nil
}

func awsAwsjson10_serializeDocumentValidationSettings(v *types.ValidationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentBatchGetPolicyInput(v *BatchGetPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Requests != nil {
		ok := object.Key("requests")
		if err := awsAwsjson10_serializeDocumentBatchGetPolicyInputList(v.Requests, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentBatchIsAuthorizedInput(v *BatchIsAuthorizedInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entities != nil {
		ok := object.Key("entities")
		if err := awsAwsjson10_serializeDocumentEntitiesDefinition(v.Entities, ok); err != nil {
			return err
		}
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Requests != nil {
		ok := object.Key("requests")
		if err := awsAwsjson10_serializeDocumentBatchIsAuthorizedInputList(v.Requests, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentBatchIsAuthorizedWithTokenInput(v *BatchIsAuthorizedWithTokenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.Entities != nil {
		ok := object.Key("entities")
		if err := awsAwsjson10_serializeDocumentEntitiesDefinition(v.Entities, ok); err != nil {
			return err
		}
	}

	if v.IdentityToken != nil {
		ok := object.Key("identityToken")
		ok.String(*v.IdentityToken)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Requests != nil {
		ok := object.Key("requests")
		if err := awsAwsjson10_serializeDocumentBatchIsAuthorizedWithTokenInputList(v.Requests, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateIdentitySourceInput(v *CreateIdentitySourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson10_serializeDocumentConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.PrincipalEntityType != nil {
		ok := object.Key("principalEntityType")
		ok.String(*v.PrincipalEntityType)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreatePolicyInput(v *CreatePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Definition != nil {
		ok := object.Key("definition")
		if err := awsAwsjson10_serializeDocumentPolicyDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreatePolicyStoreInput(v *CreatePolicyStoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if len(v.DeletionProtection) > 0 {
		ok := object.Key("deletionProtection")
		ok.String(string(v.DeletionProtection))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ValidationSettings != nil {
		ok := object.Key("validationSettings")
		if err := awsAwsjson10_serializeDocumentValidationSettings(v.ValidationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreatePolicyTemplateInput(v *CreatePolicyTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Statement != nil {
		ok := object.Key("statement")
		ok.String(*v.Statement)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteIdentitySourceInput(v *DeleteIdentitySourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentitySourceId != nil {
		ok := object.Key("identitySourceId")
		ok.String(*v.IdentitySourceId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeletePolicyInput(v *DeletePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyId != nil {
		ok := object.Key("policyId")
		ok.String(*v.PolicyId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeletePolicyStoreInput(v *DeletePolicyStoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeletePolicyTemplateInput(v *DeletePolicyTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.PolicyTemplateId != nil {
		ok := object.Key("policyTemplateId")
		ok.String(*v.PolicyTemplateId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetIdentitySourceInput(v *GetIdentitySourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentitySourceId != nil {
		ok := object.Key("identitySourceId")
		ok.String(*v.IdentitySourceId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetPolicyInput(v *GetPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyId != nil {
		ok := object.Key("policyId")
		ok.String(*v.PolicyId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetPolicyStoreInput(v *GetPolicyStoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Tags {
		ok := object.Key("tags")
		ok.Boolean(v.Tags)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetPolicyTemplateInput(v *GetPolicyTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.PolicyTemplateId != nil {
		ok := object.Key("policyTemplateId")
		ok.String(*v.PolicyTemplateId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetSchemaInput(v *GetSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentIsAuthorizedInput(v *IsAuthorizedInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsAwsjson10_serializeDocumentActionIdentifier(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("context")
		if err := awsAwsjson10_serializeDocumentContextDefinition(v.Context, ok); err != nil {
			return err
		}
	}

	if v.Entities != nil {
		ok := object.Key("entities")
		if err := awsAwsjson10_serializeDocumentEntitiesDefinition(v.Entities, ok); err != nil {
			return err
		}
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Principal, ok); err != nil {
			return err
		}
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentIsAuthorizedWithTokenInput(v *IsAuthorizedWithTokenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("accessToken")
		ok.String(*v.AccessToken)
	}

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsAwsjson10_serializeDocumentActionIdentifier(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Context != nil {
		ok := object.Key("context")
		if err := awsAwsjson10_serializeDocumentContextDefinition(v.Context, ok); err != nil {
			return err
		}
	}

	if v.Entities != nil {
		ok := object.Key("entities")
		if err := awsAwsjson10_serializeDocumentEntitiesDefinition(v.Entities, ok); err != nil {
			return err
		}
	}

	if v.IdentityToken != nil {
		ok := object.Key("identityToken")
		ok.String(*v.IdentityToken)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.Resource != nil {
		ok := object.Key("resource")
		if err := awsAwsjson10_serializeDocumentEntityIdentifier(v.Resource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListIdentitySourcesInput(v *ListIdentitySourcesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsAwsjson10_serializeDocumentIdentitySourceFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListPoliciesInput(v *ListPoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsAwsjson10_serializeDocumentPolicyFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListPolicyStoresInput(v *ListPolicyStoresInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListPolicyTemplatesInput(v *ListPolicyTemplatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentPutSchemaInput(v *PutSchemaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		if err := awsAwsjson10_serializeDocumentSchemaDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateIdentitySourceInput(v *UpdateIdentitySourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentitySourceId != nil {
		ok := object.Key("identitySourceId")
		ok.String(*v.IdentitySourceId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.PrincipalEntityType != nil {
		ok := object.Key("principalEntityType")
		ok.String(*v.PrincipalEntityType)
	}

	if v.UpdateConfiguration != nil {
		ok := object.Key("updateConfiguration")
		if err := awsAwsjson10_serializeDocumentUpdateConfiguration(v.UpdateConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdatePolicyInput(v *UpdatePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		if err := awsAwsjson10_serializeDocumentUpdatePolicyDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.PolicyId != nil {
		ok := object.Key("policyId")
		ok.String(*v.PolicyId)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdatePolicyStoreInput(v *UpdatePolicyStoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeletionProtection) > 0 {
		ok := object.Key("deletionProtection")
		ok.String(string(v.DeletionProtection))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.ValidationSettings != nil {
		ok := object.Key("validationSettings")
		if err := awsAwsjson10_serializeDocumentValidationSettings(v.ValidationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdatePolicyTemplateInput(v *UpdatePolicyTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.PolicyStoreId != nil {
		ok := object.Key("policyStoreId")
		ok.String(*v.PolicyStoreId)
	}

	if v.PolicyTemplateId != nil {
		ok := object.Key("policyTemplateId")
		ok.String(*v.PolicyTemplateId)
	}

	if v.Statement != nil {
		ok := object.Key("statement")
		ok.String(*v.Statement)
	}

	return nil
}
