// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package marketplacemeteringiface provides an interface to enable mocking the AWSMarketplace Metering service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package marketplacemeteringiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/marketplacemetering"
)

// MarketplaceMeteringAPI provides an interface to enable mocking the
// marketplacemetering.MarketplaceMetering service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWSMarketplace Metering.
//	func myFunc(svc marketplacemeteringiface.MarketplaceMeteringAPI) bool {
//	    // Make svc.BatchMeterUsage request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := marketplacemetering.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockMarketplaceMeteringClient struct {
//	    marketplacemeteringiface.MarketplaceMeteringAPI
//	}
//	func (m *mockMarketplaceMeteringClient) BatchMeterUsage(input *marketplacemetering.BatchMeterUsageInput) (*marketplacemetering.BatchMeterUsageOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockMarketplaceMeteringClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MarketplaceMeteringAPI interface {
	BatchMeterUsage(*marketplacemetering.BatchMeterUsageInput) (*marketplacemetering.BatchMeterUsageOutput, error)
	BatchMeterUsageWithContext(aws.Context, *marketplacemetering.BatchMeterUsageInput, ...request.Option) (*marketplacemetering.BatchMeterUsageOutput, error)
	BatchMeterUsageRequest(*marketplacemetering.BatchMeterUsageInput) (*request.Request, *marketplacemetering.BatchMeterUsageOutput)

	MeterUsage(*marketplacemetering.MeterUsageInput) (*marketplacemetering.MeterUsageOutput, error)
	MeterUsageWithContext(aws.Context, *marketplacemetering.MeterUsageInput, ...request.Option) (*marketplacemetering.MeterUsageOutput, error)
	MeterUsageRequest(*marketplacemetering.MeterUsageInput) (*request.Request, *marketplacemetering.MeterUsageOutput)

	RegisterUsage(*marketplacemetering.RegisterUsageInput) (*marketplacemetering.RegisterUsageOutput, error)
	RegisterUsageWithContext(aws.Context, *marketplacemetering.RegisterUsageInput, ...request.Option) (*marketplacemetering.RegisterUsageOutput, error)
	RegisterUsageRequest(*marketplacemetering.RegisterUsageInput) (*request.Request, *marketplacemetering.RegisterUsageOutput)

	ResolveCustomer(*marketplacemetering.ResolveCustomerInput) (*marketplacemetering.ResolveCustomerOutput, error)
	ResolveCustomerWithContext(aws.Context, *marketplacemetering.ResolveCustomerInput, ...request.Option) (*marketplacemetering.ResolveCustomerOutput, error)
	ResolveCustomerRequest(*marketplacemetering.ResolveCustomerInput) (*request.Request, *marketplacemetering.ResolveCustomerOutput)
}

var _ MarketplaceMeteringAPI = (*marketplacemetering.MarketplaceMetering)(nil)
