//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package azcontainerregistry

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/streaming"
	"net/http"
	"net/url"
	"strings"
)

// authenticationClient contains the methods for the Authentication group.
// Don't use this type directly, use newAuthenticationClient() instead.
type authenticationClient struct {
	endpoint string
	pl       runtime.Pipeline
}

// ExchangeAADAccessTokenForACRRefreshToken - Exchange AAD tokens for an ACR refresh Token
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-07-01
//   - grantType - Can take a value of accesstokenrefreshtoken, or accesstoken, or refresh_token
//   - service - Indicates the name of your Azure container registry.
//   - options - authenticationClientExchangeAADAccessTokenForACRRefreshTokenOptions contains the optional parameters for the
//     authenticationClient.ExchangeAADAccessTokenForACRRefreshToken method.
func (client *authenticationClient) ExchangeAADAccessTokenForACRRefreshToken(ctx context.Context, grantType postContentSchemaGrantType, service string, options *authenticationClientExchangeAADAccessTokenForACRRefreshTokenOptions) (authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse, error) {
	req, err := client.exchangeAADAccessTokenForACRRefreshTokenCreateRequest(ctx, grantType, service, options)
	if err != nil {
		return authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse{}, runtime.NewResponseError(resp)
	}
	return client.exchangeAADAccessTokenForACRRefreshTokenHandleResponse(resp)
}

// exchangeAADAccessTokenForACRRefreshTokenCreateRequest creates the ExchangeAADAccessTokenForACRRefreshToken request.
func (client *authenticationClient) exchangeAADAccessTokenForACRRefreshTokenCreateRequest(ctx context.Context, grantType postContentSchemaGrantType, service string, options *authenticationClientExchangeAADAccessTokenForACRRefreshTokenOptions) (*policy.Request, error) {
	urlPath := "/oauth2/exchange"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	formData := url.Values{}
	formData.Set("grant_type", string(grantType))
	formData.Set("service", service)
	if options != nil && options.Tenant != nil {
		formData.Set("tenant", *options.Tenant)
	}
	if options != nil && options.RefreshToken != nil {
		formData.Set("refresh_token", *options.RefreshToken)
	}
	if options != nil && options.AccessToken != nil {
		formData.Set("access_token", *options.AccessToken)
	}
	body := streaming.NopCloser(strings.NewReader(formData.Encode()))
	return req, req.SetBody(body, "application/x-www-form-urlencoded")
}

// exchangeAADAccessTokenForACRRefreshTokenHandleResponse handles the ExchangeAADAccessTokenForACRRefreshToken response.
func (client *authenticationClient) exchangeAADAccessTokenForACRRefreshTokenHandleResponse(resp *http.Response) (authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse, error) {
	result := authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.acrRefreshToken); err != nil {
		return authenticationClientExchangeAADAccessTokenForACRRefreshTokenResponse{}, err
	}
	return result, nil
}

// ExchangeACRRefreshTokenForACRAccessToken - Exchange ACR Refresh token for an ACR Access Token
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-07-01
//   - service - Indicates the name of your Azure container registry.
//   - scope - Which is expected to be a valid scope, and can be specified more than once for multiple scope requests. You obtained
//     this from the Www-Authenticate response header from the challenge.
//   - refreshToken - Must be a valid ACR refresh token
//   - options - authenticationClientExchangeACRRefreshTokenForACRAccessTokenOptions contains the optional parameters for the
//     authenticationClient.ExchangeACRRefreshTokenForACRAccessToken method.
func (client *authenticationClient) ExchangeACRRefreshTokenForACRAccessToken(ctx context.Context, service string, scope string, refreshToken string, options *authenticationClientExchangeACRRefreshTokenForACRAccessTokenOptions) (authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse, error) {
	req, err := client.exchangeACRRefreshTokenForACRAccessTokenCreateRequest(ctx, service, scope, refreshToken, options)
	if err != nil {
		return authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse{}, runtime.NewResponseError(resp)
	}
	return client.exchangeACRRefreshTokenForACRAccessTokenHandleResponse(resp)
}

// exchangeACRRefreshTokenForACRAccessTokenCreateRequest creates the ExchangeACRRefreshTokenForACRAccessToken request.
func (client *authenticationClient) exchangeACRRefreshTokenForACRAccessTokenCreateRequest(ctx context.Context, service string, scope string, refreshToken string, options *authenticationClientExchangeACRRefreshTokenForACRAccessTokenOptions) (*policy.Request, error) {
	urlPath := "/oauth2/token"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	formData := url.Values{}
	formData.Set("service", service)
	formData.Set("scope", scope)
	formData.Set("refresh_token", refreshToken)
	if options != nil && options.GrantType != nil {
		formData.Set("grant_type", string(*options.GrantType))
	}
	body := streaming.NopCloser(strings.NewReader(formData.Encode()))
	return req, req.SetBody(body, "application/x-www-form-urlencoded")
}

// exchangeACRRefreshTokenForACRAccessTokenHandleResponse handles the ExchangeACRRefreshTokenForACRAccessToken response.
func (client *authenticationClient) exchangeACRRefreshTokenForACRAccessTokenHandleResponse(resp *http.Response) (authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse, error) {
	result := authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.acrAccessToken); err != nil {
		return authenticationClientExchangeACRRefreshTokenForACRAccessTokenResponse{}, err
	}
	return result, nil
}
