//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Azure Subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAFDCustomDomainsClient creates a new instance of AFDCustomDomainsClient.
func (c *ClientFactory) NewAFDCustomDomainsClient() *AFDCustomDomainsClient {
	subClient, _ := NewAFDCustomDomainsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAFDEndpointsClient creates a new instance of AFDEndpointsClient.
func (c *ClientFactory) NewAFDEndpointsClient() *AFDEndpointsClient {
	subClient, _ := NewAFDEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAFDOriginGroupsClient creates a new instance of AFDOriginGroupsClient.
func (c *ClientFactory) NewAFDOriginGroupsClient() *AFDOriginGroupsClient {
	subClient, _ := NewAFDOriginGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAFDOriginsClient creates a new instance of AFDOriginsClient.
func (c *ClientFactory) NewAFDOriginsClient() *AFDOriginsClient {
	subClient, _ := NewAFDOriginsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAFDProfilesClient creates a new instance of AFDProfilesClient.
func (c *ClientFactory) NewAFDProfilesClient() *AFDProfilesClient {
	subClient, _ := NewAFDProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCustomDomainsClient creates a new instance of CustomDomainsClient.
func (c *ClientFactory) NewCustomDomainsClient() *CustomDomainsClient {
	subClient, _ := NewCustomDomainsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEdgeNodesClient creates a new instance of EdgeNodesClient.
func (c *ClientFactory) NewEdgeNodesClient() *EdgeNodesClient {
	subClient, _ := NewEdgeNodesClient(c.credential, c.options)
	return subClient
}

// NewEndpointsClient creates a new instance of EndpointsClient.
func (c *ClientFactory) NewEndpointsClient() *EndpointsClient {
	subClient, _ := NewEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLogAnalyticsClient creates a new instance of LogAnalyticsClient.
func (c *ClientFactory) NewLogAnalyticsClient() *LogAnalyticsClient {
	subClient, _ := NewLogAnalyticsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedRuleSetsClient creates a new instance of ManagedRuleSetsClient.
func (c *ClientFactory) NewManagedRuleSetsClient() *ManagedRuleSetsClient {
	subClient, _ := NewManagedRuleSetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagementClient creates a new instance of ManagementClient.
func (c *ClientFactory) NewManagementClient() *ManagementClient {
	subClient, _ := NewManagementClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOriginGroupsClient creates a new instance of OriginGroupsClient.
func (c *ClientFactory) NewOriginGroupsClient() *OriginGroupsClient {
	subClient, _ := NewOriginGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOriginsClient creates a new instance of OriginsClient.
func (c *ClientFactory) NewOriginsClient() *OriginsClient {
	subClient, _ := NewOriginsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPoliciesClient creates a new instance of PoliciesClient.
func (c *ClientFactory) NewPoliciesClient() *PoliciesClient {
	subClient, _ := NewPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewProfilesClient creates a new instance of ProfilesClient.
func (c *ClientFactory) NewProfilesClient() *ProfilesClient {
	subClient, _ := NewProfilesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewResourceUsageClient creates a new instance of ResourceUsageClient.
func (c *ClientFactory) NewResourceUsageClient() *ResourceUsageClient {
	subClient, _ := NewResourceUsageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRoutesClient creates a new instance of RoutesClient.
func (c *ClientFactory) NewRoutesClient() *RoutesClient {
	subClient, _ := NewRoutesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRuleSetsClient creates a new instance of RuleSetsClient.
func (c *ClientFactory) NewRuleSetsClient() *RuleSetsClient {
	subClient, _ := NewRuleSetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRulesClient creates a new instance of RulesClient.
func (c *ClientFactory) NewRulesClient() *RulesClient {
	subClient, _ := NewRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecretsClient creates a new instance of SecretsClient.
func (c *ClientFactory) NewSecretsClient() *SecretsClient {
	subClient, _ := NewSecretsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecurityPoliciesClient creates a new instance of SecurityPoliciesClient.
func (c *ClientFactory) NewSecurityPoliciesClient() *SecurityPoliciesClient {
	subClient, _ := NewSecurityPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
