//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// CassandraDataCentersServer is a fake server for instances of the armcosmos.CassandraDataCentersClient type.
type CassandraDataCentersServer struct {
	// BeginCreateUpdate is the fake for method CassandraDataCentersClient.BeginCreateUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateUpdate func(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, body armcosmos.DataCenterResource, options *armcosmos.CassandraDataCentersClientBeginCreateUpdateOptions) (resp azfake.PollerResponder[armcosmos.CassandraDataCentersClientCreateUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CassandraDataCentersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, options *armcosmos.CassandraDataCentersClientBeginDeleteOptions) (resp azfake.PollerResponder[armcosmos.CassandraDataCentersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CassandraDataCentersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, options *armcosmos.CassandraDataCentersClientGetOptions) (resp azfake.Responder[armcosmos.CassandraDataCentersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CassandraDataCentersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, clusterName string, options *armcosmos.CassandraDataCentersClientListOptions) (resp azfake.PagerResponder[armcosmos.CassandraDataCentersClientListResponse])

	// BeginUpdate is the fake for method CassandraDataCentersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, body armcosmos.DataCenterResource, options *armcosmos.CassandraDataCentersClientBeginUpdateOptions) (resp azfake.PollerResponder[armcosmos.CassandraDataCentersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewCassandraDataCentersServerTransport creates a new instance of CassandraDataCentersServerTransport with the provided implementation.
// The returned CassandraDataCentersServerTransport instance is connected to an instance of armcosmos.CassandraDataCentersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCassandraDataCentersServerTransport(srv *CassandraDataCentersServer) *CassandraDataCentersServerTransport {
	return &CassandraDataCentersServerTransport{
		srv:               srv,
		beginCreateUpdate: newTracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientCreateUpdateResponse]](),
		beginDelete:       newTracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientDeleteResponse]](),
		newListPager:      newTracker[azfake.PagerResponder[armcosmos.CassandraDataCentersClientListResponse]](),
		beginUpdate:       newTracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientUpdateResponse]](),
	}
}

// CassandraDataCentersServerTransport connects instances of armcosmos.CassandraDataCentersClient to instances of CassandraDataCentersServer.
// Don't use this type directly, use NewCassandraDataCentersServerTransport instead.
type CassandraDataCentersServerTransport struct {
	srv               *CassandraDataCentersServer
	beginCreateUpdate *tracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientCreateUpdateResponse]]
	beginDelete       *tracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientDeleteResponse]]
	newListPager      *tracker[azfake.PagerResponder[armcosmos.CassandraDataCentersClientListResponse]]
	beginUpdate       *tracker[azfake.PollerResponder[armcosmos.CassandraDataCentersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for CassandraDataCentersServerTransport.
func (c *CassandraDataCentersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CassandraDataCentersClient.BeginCreateUpdate":
		resp, err = c.dispatchBeginCreateUpdate(req)
	case "CassandraDataCentersClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CassandraDataCentersClient.Get":
		resp, err = c.dispatchGet(req)
	case "CassandraDataCentersClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CassandraDataCentersClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CassandraDataCentersServerTransport) dispatchBeginCreateUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdate not implemented")}
	}
	beginCreateUpdate := c.beginCreateUpdate.get(req)
	if beginCreateUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/cassandraClusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataCenters/(?P<dataCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.DataCenterResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		dataCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCenterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateUpdate(req.Context(), resourceGroupNameParam, clusterNameParam, dataCenterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdate = &respr
		c.beginCreateUpdate.add(req, beginCreateUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdate) {
		c.beginCreateUpdate.remove(req)
	}

	return resp, nil
}

func (c *CassandraDataCentersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/cassandraClusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataCenters/(?P<dataCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		dataCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCenterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, clusterNameParam, dataCenterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CassandraDataCentersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/cassandraClusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataCenters/(?P<dataCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	dataCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCenterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, clusterNameParam, dataCenterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataCenterResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraDataCentersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/cassandraClusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataCenters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, clusterNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CassandraDataCentersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/cassandraClusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataCenters/(?P<dataCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.DataCenterResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		dataCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataCenterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, clusterNameParam, dataCenterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}
